--[[	reskinning BigWigs timers

------------------]]

local path = "Interface\\AddOns\\SyncUI\\Media\\Fonts\\Vibro.ttf"

local function applyStyle(bar)
	bar:SetSize(148,14)
	bar:SetTexture("Interface\\AddOns\\SyncUI\\Media\\Textures\\Elements\\Statusbar\\Statusbar_Fill2")
	
	-- Backdrop
	local backdrop = bar.candyBarBackdrop
	if backdrop then backdrop:Hide() end
	
	-- Icon
	local icon, iconBD = bar.candyBarIconFrame, bar.candyBarIconFrameBackdrop
	local tex = icon.icon
	bar:SetIcon(nil)
	icon:SetTexture(tex)
	icon:SetSize(22,22)
	icon:ClearAllPoints()
	icon:SetPoint("RIGHT",bar,"LEFT", -7, 0)
	icon:Show()
	iconBD:Hide()
	bar:Set("bigwigs:restoreicon", tex)
	
	-- Text
	bar.candyBarLabel:SetFont(path,10,"NONE")
	bar.candyBarLabel:SetJustifyH("LEFT")
	bar.candyBarLabel:SetSize(120,10)
	bar.candyBarLabel:ClearAllPoints()
	bar.candyBarLabel:SetPoint("LEFT",bar,"LEFT",3,0)
	
	bar.candyBarDuration:SetFont(path,10,"NONE")
	bar.candyBarDuration:SetJustifyH("RIGHT")
	bar.candyBarDuration:ClearAllPoints()
	bar.candyBarDuration:SetPoint("RIGHT", bar, "RIGHT", -2, 0)
	
	-- Border
	local parent = bar.candyBarBar
	local border, background = parent.border, parent.background
	if not border then
		border = parent:CreateTexture(nil,"OVERLAY")
		border:SetTexture("Interface\\AddOns\\SyncUI\\Media\\Textures\\UI-Mods\\BigWigs_Border")
		border:SetTexCoord(0,0.74609375,0,1)
		border:SetSize(191,32)
		border:SetPoint("RIGHT",9,0)
		parent.border = border
		
		background = parent:CreateTexture(nil,"BACKGROUND")
		background:SetAllPoints(true)
		background:SetTexture("Interface\\AddOns\\SyncUI\\Media\\Textures\\Elements\\Statusbar\\Statusbar_Background")
		parent.background = background
	else
		border:Show()
		background:Show()
	end
	
	-- Fix Emphasizes
	BigWigsAnchor:SetSize(148,20)
	BigWigsAnchor:SetScript("OnSizeChanged",function(self) self:SetSize(148,20) end)
	BigWigsEmphasizeAnchor:SetSize(math.ceil(148*1.3),20)
	BigWigsEmphasizeAnchor:SetScript("OnSizeChanged",function(self) self:SetSize(math.ceil(148*1.3),20) end)
	local children = {};
	for _, child in ipairs{BigWigsAnchor:GetChildren()} do tinsert(children,child) end;
	for _, child in ipairs{BigWigsEmphasizeAnchor:GetChildren()} do tinsert(children,child) end;
	for _, child in ipairs(children) do child:Hide() end;
end

local function removeStyle(bar)
	local parent = bar.candyBarBar
	local border, background = parent.border, parent.background
	if border then border:Hide()  background:Hide() end
end


function SyncUI_BigWigs_OnInit(self)
	if not BigWigs then return end
	local bars = BigWigs:GetPlugin("Bars", true)
	if not bars then return end
	self:UnregisterEvent("ADDON_LOADED")
	self:UnregisterEvent("PLAYER_LOGIN")
	bars:RegisterBarStyle("identifier", {
		apiVersion = 1,
		version = 1,
		GetSpacing = function(bar) return 12 end,
		ApplyStyle = applyStyle,
		BarStopped = removeStyle,
		GetStyleName = function() return "SyncUI" end,
	})
end

function SyncUI_BigWigs_OnRegister(self,event,msg)
	if event == "ADDON_LOADED" then
		if not reason then reason = select(6, GetAddOnInfo("BigWigs_Plugins")) end
		if (reason == "MISSING" and msg == "BigWigs") or msg == "BigWigs_Plugins" then
			SyncUI_BigWigs_OnInit(self)
		end
	elseif event == "PLAYER_LOGIN" then
		SyncUI_BigWigs_OnInit(self)
	end
end