--[[	handler functions for the minimap & reskinning

------------------]]

local _G = _G
local tinsert = table.insert
minimapButtons = {}
minimapButtonsShown = {}
local exeptionList = {
	[1] = "MiniMapWorldMapButton",
	[2] = "MiniMapRecordingButton",
	[3] = "MiniMapVoiceChatFrame",
	[4] = "MinimapZoomIn",
	[5] = "MinimapZoomOut",
	[6] = "TimeManagerClockButton",
	[7] = "GameTimeFrame",
}

-- Minimap
function SyncUI_Minimap_OnLoad(self)
	SyncUI_Minimap_OnStyling(self)
	
	-- Zoom Function
	Minimap:EnableMouseWheel(true)
	Minimap:SetScript("OnMouseWheel", function(_, zoom)
		if zoom > 0 then
			Minimap_ZoomIn()
		else
			Minimap_ZoomOut()
		end
	end)
	
	do	-- Garrison Minimap Alert
		local button = GarrisonLandingPageMinimapButton
		local alert, text = button.AlertBG, button.AlertText

		button:Show()
		
		alert:SetSize(200,50)
		alert:SetTexture("Interface\\AddOns\\SyncUI\\Media\\Textures\\UI-Mods\\AlertBG")
		alert:ClearAllPoints()
		alert:SetPoint("TOP",SyncUI_UIParent,0,-50)
		
		text:ClearAllPoints()
		text:SetPoint("CENTER",alert)
		text:SetFontObject(SyncUI_GameFontOutline_Medium)
		text:SetJustifyH("CENTER")
	end
		
	do	-- Garrison Mission Alert
		local frame = GarrisonMissionAlertFrame
		frame:ClearAllPoints()
		frame:SetPoint("TOP",SyncUI_UIParent,0,-50)
		frame.SetPoint = function() end
	end

	do	-- Help Ticket Button
		local frame = HelpOpenWebTicketButton
		frame:SetParent(self)
		frame:SetScale(0.8)
		frame:ClearAllPoints()
		frame:SetPoint("BOTTOMLEFT",-7,-4)
	end
	
	do	-- Ticket Status Frame
		local frame = TicketStatusFrame
		local button = TicketStatusFrameButton
		local text = TicketStatusTitleText
		button:SetBackdrop(SyncUI_Backdrop)
		text:SetFontObject(SyncUI_GameFontOutline_Medium)
		
		frame:ClearAllPoints()
		frame:SetPoint("TOP",SyncUI_Minimap,"BOTTOM",-15,-5)
	end
end

function SyncUI_Minimap_OnStyling(self)
	-- Hide Stuff
	local frames = {
		"MiniMapVoiceChatFrame",
		"MiniMapWorldMapButton",
		"MinimapZoneTextButton",
		"MiniMapMailFrame",
		"MinimapNorthTag",
		"MinimapZoomOut",
		"MinimapZoomIn",
		"MinimapBackdrop",
		"GameTimeFrame",
		"MinimapBorderTop",
	}
	for _, frame in pairs(frames) do
		_G[frame]:Hide()
		_G[frame].Show = function() end
	end

	local frame = _G[self:GetName()]
	local scale = 0.8
	-- Minimap
    MinimapCluster:EnableMouse(false)
	Minimap:SetParent(frame)
	Minimap:SetScale(scale)
	Minimap:SetSize(113/scale,113/scale)
	Minimap:ClearAllPoints()
	Minimap:SetPoint("TOP",frame,0,-11/scale)
	Minimap:SetMaskTexture("Interface\\AddOns\\SyncUI\\Media\\Textures\\UI-Mods\\Minimap\\Minimap_Mask")
	Minimap:SetHitRectInsets(0,0,0,0)
	Minimap:SetArchBlobRingScalar(0);
	Minimap:SetQuestBlobRingScalar(0);
	
	UIParent:HookScript("OnShow",function()
		Minimap:Show()
	end)
	UIParent:HookScript("OnHide",function()
		Minimap:Hide()
	end)
end


-- Minimap Button Frame
local function GetExeption(name)
	for _, button in ipairs(exeptionList) do
		if button == name then
			return true
		end
	end
	return false
end

local function GetMinimapButtons()
	local children = {Minimap:GetChildren()}
	for _, child in ipairs(children) do
		if child:HasScript("OnClick") then
			local name = child:GetName()
			if not GetExeption(name) then
				tinsert(minimapButtons,name)
			end
		end

		if not child:HasScript("OnClick") then
			for _, subChild in ipairs({child:GetChildren()}) do
				if subChild:HasScript("OnClick") then
					local name = subChild:GetName()
					if not GetExeption(name) then
						tinsert(minimapButtons,name)
					end
				end
			end
		end
	end
end

local function SetMinimapButtonHooks()
	for index, button in pairs(minimapButtons) do
		local frame = _G[button]
		frame:SetScript("OnShow", function() SyncUI_MinimapButtonFrame.forceUpdate = true end)
		frame:SetScript("OnHide", function() SyncUI_MinimapButtonFrame.forceUpdate = true end)
	end
end

function SyncUI_MinimapButton_OnInit()
	for i = 1, 5 do
		local frame = _G["SyncUI_MinimapButtonFrameButton"..i]
		frame:SetAlpha(0)
	end

	minimapButtonsShown = {}
	for index, button in ipairs(minimapButtons) do
		local frame = _G[button]
		if frame:IsShown() then tinsert(minimapButtonsShown,button) end
	end
	
	for index, button in ipairs(minimapButtonsShown) do
		local parent = _G["SyncUI_MinimapButtonFrameButton"..index]
		local frame = _G[button]

		if parent then
			parent:SetAlpha(1)
			
			frame:SetParent(parent)
			frame:SetSize(19,19)
			frame:ClearAllPoints()
			frame:SetPoint("CENTER",parent,0,0)
			frame:SetHitRectInsets(0,0,0,0)
			frame:RegisterForDrag()

			local icon = frame.icon or _G[frame:GetName().."Icon"]
			if icon then
				icon:SetSize(15,15)
				icon:ClearAllPoints()
				icon:SetPoint("CENTER")
			end
			
			frame:SetHighlightTexture("Interface\\AddOns\\SyncUI\\Media\\Textures\\UI-Mods\\Minimap\\Minimap_Button_Highlight")
			frame:GetHighlightTexture():SetTexCoord(0,0.65625,0,0.65625)
					
			for _, region in pairs({frame:GetRegions()}) do
				if region:GetObjectType() == "Texture" then
					local drawLayer = region:GetDrawLayer();
					if drawLayer == "BACKGROUND" or drawLayer == "OVERLAY" then
						region:Hide()
					end
				end
			end
		end
	end
end

function SyncUI_MinimapButtonFrame_OnLoad()
	GetMinimapButtons()
	SetMinimapButtonHooks()
	SyncUI_MinimapButton_OnInit()
	SetMinimapButtonHooks()
end

function SyncUI_MinimapButtonFrame_OnUpdate(self)
	if self.forceUpdate then
		SyncUI_MinimapButton_OnInit()
		self.forceUpdate = false
	end
end

function SyncUI_Minimap_SetDungeonDifficulty(self)
	local _, type, id = GetInstanceInfo()
	if type == "scenario" or type == "party" or type == "raid" then
	
		if id == 1 then		-- 5-player
			self.difficulty:SetText("")
		end
		if id == 2 then		-- 5-player HC
			self.difficulty:SetText("HC")
		end
		if id == 3 then		-- 10-player
			self.difficulty:SetText("10")
		end
		if id == 4 then		-- 25-player
			self.difficulty:SetText("25")
		end
		if id == 5 then		-- 10-player HC
			self.difficulty:SetText("10 HC")
		end
		if id == 6 then		-- 25-player HC
			self.difficulty:SetText("25 HC")
		end
		if id == 7 then		-- LFR
			self.difficulty:SetText("LFR")
		end
		if id == 8 then		-- Challenge Mode
			self.difficulty:SetText("CM")
		end
		if id == 9 then		-- 40x Raid
			self.difficulty:SetText("40")
		end
		if id == 11 then	-- Heroic Scenario
			self.difficulty:SetText("SZ HC")
		end
		if id == 12 then	-- Scenario
			self.difficulty:SetText("SZ")
		end
		if id == 14 then	-- Normal
			self.difficulty:SetText("Normal")
		end
		if id == 15 then	-- Heroic
			self.difficulty:SetText("Heroic")
		end
		if id == 16 then	-- Mythic
			self.difficulty:SetText("Mythic")
		end
		if id == 17 then	-- LFR (2)
			self.difficulty:SetText("LFR")
		end
	else
		self.difficulty:SetText("")
	end
end

