--[[	reskinning for raid info frame

------------------]]

local dummy = function() end

local function hideStuff()
	local tex = {"BG","Top","Bottom","Middle"}
	for i = 1, #tex do
		_G["RaidInfoScrollFrameScrollBar"..tex[i]]:Hide()
	end
	
	RaidInfoExtendButton.Left:Hide()
	RaidInfoExtendButton.Middle:Hide()
	RaidInfoExtendButton.Right:Hide()
end

local function changeFont()
	RaidInfoFrameHeaderText:SetFontObject(SyncUI_GameFontOutline_Medium)
	RaidInfoInstanceLabel.text:SetFontObject(SyncUI_GameFontOutline_Medium)
	RaidInfoIDLabel.text:SetFontObject(SyncUI_GameFontOutline_Medium)
	
	-- ScrollFrame Buttons
	for i = 1, 6 do
		local frame = _G["RaidInfoScrollFrameButton"..i]
		
		frame:SetSize(290,30)
		
		local suffix = {"Name","Difficulty","Reset","Extended"}
		for i = 1, #suffix do
			local font = _G[frame:GetName()..suffix[i]]
			font:SetFontObject(SyncUI_GameFontOutline_Medium)
			font:SetJustifyV("CENTER")
		end
	end
	
	RaidInfoCancelButton:SetNormalFontObject(SyncUI_GameFontOutline_Medium)
	RaidInfoCancelButton:SetHighlightFontObject(SyncUI_GameFontOutline_Medium)
	RaidInfoExtendButton:SetNormalFontObject(SyncUI_GameFontOutline_Medium)
	RaidInfoExtendButton:SetHighlightFontObject(SyncUI_GameFontOutline_Medium)
	RaidInfoExtendButton:SetDisabledFontObject(SyncUI_GameFontOutline_Medium)
end

function SyncUI_RaidInfoFrame_OnLoad(self)
	hideStuff()
	changeFont()
	
	RaidInfoScrollFrame:SetParent(self)
	RaidInfoScrollFrame:SetSize(290,150)
	RaidInfoScrollFrame.SetSize = dummy
	RaidInfoScrollFrame:ClearAllPoints()
	RaidInfoScrollFrame:SetPoint("TOPLEFT",self,32,-46)
	RaidInfoScrollFrameScrollBar:ClearAllPoints()
	RaidInfoScrollFrameScrollBar:SetPoint("TOPLEFT",RaidInfoScrollFrame,"TOPRIGHT",1,-17)
	RaidInfoScrollFrameScrollBar:SetPoint("BOTTOMLEFT",RaidInfoScrollFrame,"BOTTOMRIGHT",1,15)
	RaidInfoExtendButton:SetParent(self)
	RaidInfoExtendButton:ClearAllPoints()
	RaidInfoExtendButton:SetPoint("BOTTOM",self,0,8)
	
	self:SetScale(SyncUI_UIScale)
	tinsert(UISpecialFrames,self:GetName())
end