
local _G = _G

local function UpdateBar(self,unitID)
	if self.ManaBar then
		local mana, maxMana = UnitMana(unitID), UnitManaMax(unitID)
		self.ManaBar:SetMinMaxValues(0, maxMana)
		SmoothBar(self.ManaBar,mana)
		
		if UnitMana(unitID) > 0 then
			local color = SYNCUI_POWER_COLORS[select(2, UnitPowerType(unitID))]

			if color then
				self.ManaBar:SetStatusBarColor(color.r,color.g,color.b)
			else
				self.ManaBar:SetStatusBarColor(0.5,0.5,0.5)
			end
		end
	end
	
	if self.HealthBar then
		local health, maxHealth = UnitHealth(unitID), UnitHealthMax(unitID)
		
		self.HealthBar:SetMinMaxValues(0, maxHealth)
		SmoothBar(self.HealthBar,health)

		if UnitIsPlayer(unitID) then
			local class = select(2, UnitClass(unitID))
			local color = SYNCUI_CLASS_COLORS[class]
			
			if color then
				self.HealthBar:SetStatusBarColor(color.r,color.g,color.b,0)
			end
		else
			self.HealthBar:SetStatusBarColor(0,0.8,0,0)
		end
	end

	if self.AbsorbBar then
		local health, maxHealth = UnitHealth(unitID), UnitHealthMax(unitID)
		local absorb = UnitGetTotalAbsorbs(unitID) or 0
		local barWidth, barHeight = self.HealthBar:GetSize()
			
		if health + absorb > maxHealth then
			self.AbsorbBar:SetSize((barWidth-(health*barWidth/maxHealth))+0.1,barHeight)
		else
			self.AbsorbBar:SetSize((absorb * barWidth / maxHealth),barHeight)
		end
		if absorb == 0 then
			self.AbsorbBar:SetAlpha(0)
		else
			self.AbsorbBar:SetPoint("TOPLEFT", self.HealthBar:GetStatusBarTexture(), "TOPRIGHT")
			self.AbsorbBar:SetAlpha(1)
		end
	end
end

local function UpdateBarText(self,unitID)
	if self.Mana then
		local mana = UnitMana(unitID)
		
		if UnitIsDeadOrGhost(unitID) then
			self.Mana:SetText()
		else
			if mana > 10000 then
				self.Mana:SetText(string.format("%.0f",(mana)/1000).."k")
			elseif mana > 0 then
				self.Mana:SetText(mana)
			else
				self.Mana:SetText()
			end
		end
	end
	
	if self.Health then
		local health, maxHealth = UnitHealth(unitID), UnitHealthMax(unitID)
		
		if not UnitIsConnected(unitID) or UnitIsDeadOrGhost(unitID) then
			self.Health:SetText("")
		else
			if health >= 10000000 then
				self.Health:SetText(string.format("%.0f",(health)/1000000).."m".." | "..string.format("%.0f",math.ceil((health)*100/maxHealth)).."%")
			elseif health >= 10000 then
				self.Health:SetText(string.format("%.0f",(health)/1000).."k".." | "..string.format("%.0f",math.ceil((health)*100/maxHealth)).."%")
			elseif health > 0 then
				self.Health:SetText(health.." | "..string.format("%.0f",math.ceil((health)*100/maxHealth)).."%")
			end
		end
	end
end

local function UpdateName(self,unitID)
	if self.Name then
		local name, server = UnitName(unitID)
		self.Name:SetText(name)
	end
end

local function UpdateLevel(self,unitID)
	if self.Level then
		if UnitLevel(unitID) >= 0 then
			self.Level:SetText(UnitLevel(unitID))
		else
			self.Level:SetText("??")
		end
	end
end

local function UpdateStatusIcon(self,unitID)
	if self.Quest then
		if UnitIsQuestBoss(unitID) then
			self.Quest:Show()
		else
			self.Quest:Hide()
		end
	end

	if self.Tapped then
		if not UnitIsDeadOrGhost(unitID) then
			if UnitAffectingCombat(unitID) and UnitIsTapped(unitID) and not UnitIsTappedByPlayer(unitID) then
				self.Tapped:Show()
			else
				self.Tapped:Hide()
			end
		else
			self.Tapped:Hide()
		end
	end

	if self.Role then
		if UnitGroupRolesAssigned(unitID) == "TANK" then
			self.Role:SetTexture("Interface\\AddOns\\SyncUI\\Media\\Textures\\UnitFrames\\RaidFrame_RoleIcon_Tank")
		elseif UnitGroupRolesAssigned(unitID) == "HEALER" then
			self.Role:SetTexture("Interface\\AddOns\\SyncUI\\Media\\Textures\\UnitFrames\\RaidFrame_RoleIcon_Healer")
		else
			self.Role:SetTexture()
		end
	end

	if self.StatusIcon then
		if not UnitIsConnected(unitID) then
			self.StatusIcon:SetTexture("Interface\\CHARACTERFRAME\\Disconnect-Icon")
			self.StatusIcon:SetTexCoord(0.2,0.8,0.2,0.8)
			self.StatusIcon:Show()
		elseif UnitHasIncomingResurrection(unitID) then
			self.StatusIcon:SetTexture("Interface\\RaidFrame\\Raid-Icon-Rez")
			self.StatusIcon:SetTexCoord(0,1,0,1)
			self.StatusIcon:Show()		
		elseif UnitIsDeadOrGhost(unitID) then
			self.StatusIcon:SetTexture("Interface\\WorldStateFrame\\SkullBones")
			self.StatusIcon:SetTexCoord(0,0.5,0,0.5)
			self.StatusIcon:Show()
		else
			self.StatusIcon:Hide()
		end
	end
	
	if unitID == "target" or unitID == "focus" then
		if not UnitIsConnected(unitID) then
			self.Disconnect:Show()
			self.Boss:Hide()
			self.Death:Hide()
			self.Level:SetText("")
		else
			self.Disconnect:Hide()
			
			if UnitIsDeadOrGhost(unitID) then
				self.Death:Show()
				self.Boss:Hide()
				self.Level:SetText("")
			else
				self.Death:Hide()
				
				if UnitLevel(unitID) >= 0 then
					self.Boss:Hide()
					self.Level:SetText(UnitLevel(unitID))
				else
					self.Boss:Show()
					self.Level:SetText("")
				end
			end
		end
	end
	
end

local function UpdateGroupHeader(self,unitID)
	if self.GroupFrame then
		if GetNumGroupMembers() > 5 then
			self.GroupFrame:Show()

			for index = 1, 40 do
				local name, _,group = GetRaidRosterInfo(index)
				if name == UnitName("player") then
					self.Group:SetText("Group "..group)
				end
			end
		else
			self.GroupFrame:Hide()
		end
	end
end

local function UpdateAuraPosition(self)
	local buff = _G[self:GetName().."Buff1"]
	
	if self.CastingBar:GetAlpha() > 0 then
		buff:SetPoint("TOPLEFT",self,"BOTTOMLEFT",5.5,-23)
	else
		buff:SetPoint("TOPLEFT",self,"BOTTOMLEFT",5.5,3)
	end
end

local function UpdateSelection(self,unitID)
	if self.Selection then
		if UnitGUID(unitID) == UnitGUID("target") then
			self.Selection:Show()
		else
			self.Selection:Hide()
		end
	end
end


-- Clique Support
function SyncUI_RegisterUnitClickCasting(unitFrame)
	if not ClickCastFrames then ClickCastFrames = {} end

	ClickCastFrames[unitFrame] = true;
end


-- Specific Unit Frame Functions
function SyncUI_PlayerFrame_OnLoad(self)
	self:SetScale(0.9)
	self:RegisterForDrag("")
	self.unitID = "player"
	self.Group = self.GroupFrame.Group
	self.Health = self.ArtFrame.Health
	self.Mana = self.ArtFrame.Mana
	self.Level = self.ArtFrame.Level
	
	RegisterStateDriver(self, "visibility", "[petbattle] hide; show")

	SyncUI_UnitFrame_OnRegister(self)
	SyncUI_DisableFrame("PlayerFrame")
	SyncUI_DisableFrame("BuffFrame")
	SyncUI_DisableFrame("TemporaryEnchantFrame")
end

function SyncUI_PetFrame_OnLoad(self)
	self:SetScale(0.8)
	self.unitID = "pet"
	self.Name = self.ArtFrame.Name
	self.Health = self.ArtFrame.Health
	
	RegisterStateDriver(self, "visibility", "[petbattle][overridebar][vehicleui][possessbar,@vehicle,exists] hide; [@pet,exists] show; hide")
	
	SyncUI_UnitFrame_OnRegister(self)
end

function SyncUI_TargetFrame_OnLoad(self)
	self:SetScale(0.9)
	self.unitID = "target"
	self.Name = self.NameFrame.Name
	self.Health = self.ArtFrame.Health
	self.Mana = self.ArtFrame.Mana
	self.Level = self.ArtFrame.Level
	self.Boss = self.ArtFrame.Boss
	self.Death = self.ArtFrame.Death
	self.Quest = self.ArtFrame.Quest
	self.Disconnect = self.ArtFrame.Disconnect
	self.Tapped = self.ArtFrame.Tapped
	
	RegisterStateDriver(self, "visibility", "[petbattle] hide; [@target,exists] show; hide")
	
	SyncUI_UnitFrame_OnRegister(self)
	SyncUI_DisableFrame("TargetFrame")	
end

function SyncUI_ToTFrame_OnLoad(self)
	self.unitID = "targettarget"
	self.Name = self.ArtFrame.Name
	self.Health = self.ArtFrame.Health
	
	SyncUI_UnitFrame_OnRegister(self,true)
end

function SyncUI_FocusFrame_OnLoad(self)
	self:SetScale(0.9)
	self.unitID = "focus"
	self.Name = self.NameFrame.Name
	self.Health = self.ArtFrame.Health
	self.Mana = self.ArtFrame.Mana
	self.Level = self.ArtFrame.Level
	self.Boss = self.ArtFrame.Boss
	self.Death = self.ArtFrame.Death
	self.Quest = self.ArtFrame.Quest
	self.Disconnect = self.ArtFrame.Disconnect
	self.Tapped = self.ArtFrame.Tapped	
	
	SyncUI_UnitFrame_OnRegister(self,true)
	SyncUI_DisableFrame("FocusFrame")
end

function SyncUI_ToFFrame_OnLoad(self)
	self.unitID = "focustarget"
	self.Name = self.ArtFrame.Name
	self.Health = self.ArtFrame.Health
	
	SyncUI_UnitFrame_OnRegister(self,true)
end

function SyncUI_PartyFrame_OnLoad(self)
	if IsAddOnLoaded("Grid2") then
		local frame = self:GetParent()
		if frame:IsShown() then
			frame:Hide()
		end

		return
	end
	
	self.unitID = "party"..self:GetID()
	self.Name = self.ArtFrame.Name
	self.Health = self.ArtFrame.Health
	self.Role = self.ArtFrame.Role
	self.StatusIcon = self.ArtFrame.StatusIcon
	
	SyncUI_UnitFrame_OnRegister(self,true)
	SyncUI_DisableFrame("PartyMemberFrame"..self:GetID())
end

function SyncUI_RaidFrame_OnLoad(self)
	if IsAddOnLoaded("Grid2") then
		local frame = self:GetParent()
		if frame:IsShown() then
			frame:Hide()
		end
		
		return
	end
	
	self.unitID = "raid"..self:GetID()
	self.Name = self.ArtFrame.Name
	self.Role = self.ArtFrame.Role
	self.Selection = self.ArtFrame.Selection
	self.StatusIcon = self.ArtFrame.StatusIcon
	
	SyncUI_UnitFrame_OnRegister(self,true)
end

function SyncUI_BossFrame_OnLoad(self)
	self.unitID = "boss"..self:GetID()
	self.Name = self.ArtFrame.Name
	self.Health = self.ArtFrame.Health
	
	SyncUI_UnitFrame_OnRegister(self,true)
	SyncUI_DisableFrame("Boss"..self:GetID().."TargetFrame")
end

function SyncUI_HealFrame_OnLoad(self)
	self.unitID = "player"
	self.Name = self.ArtFrame.Name
	self.Role = self.ArtFrame.Role
	self.Selection = self.ArtFrame.Selection
	self.StatusIcon = self.ArtFrame.StatusIcon
	
	SyncUI_UnitFrame_OnRegister(self,true)
end


-- Generic UnitFrame Functions
function SyncUI_UnitFrame_OnRegister(self,force)
	local unitID = self.unitID
	
	self:SetAttribute("unit", unitID)
	self:SetAttribute("type1", "target")
	self:SetAttribute("*type2", "togglemenu")
	self:RegisterForClicks("AnyUp")
	self:RegisterForDrag("LeftButton")
	
	if force then RegisterUnitWatch(self) end
	
	SyncUI_RegisterUnitClickCasting(self)
	SyncUI_RegisterUnitAura(self,unitID)
end

function SyncUI_UnitFrame_OnUpdate(self)
	local unitID = self.unitID
	
	if UnitExists(unitID) then
		UpdateBar(self,unitID)
		UpdateBarText(self,unitID)
		
		UpdateName(self,unitID)
		UpdateLevel(self,unitID)
		UpdateStatusIcon(self,unitID)
		UpdateSelection(self,unitID)
		UpdateGroupHeader(self,unitID)
		
		if unitID == "target" or unitID == "focus" then
			UpdateAuraPosition(self)
		end
	end
end

function SyncUI_UnitFrame_OnEnter(self)
	local r, g, b = GameTooltip_UnitColor(self.unitID)
	
	GameTooltip_SetDefaultAnchor(GameTooltip, UIParent)
	GameTooltip:SetUnit(self.unitID)
	GameTooltipTextLeft1:SetTextColor(r, g, b)
	GameTooltip:Show()
	
	-- StatusBarColor
	if UnitIsPlayer(self.unitID) then
		local color = SYNCUI_CLASS_COLORS[select(2, UnitClass(self.unitID))]
		local r,g,b = color.r, color.g, color.b
		
		GameTooltipStatusBar:SetStatusBarColor(r,g,b)
	end
end

function SyncUI_UnitFrame_OnLeave(self)
	GameTooltip:FadeOut()
end


-- Drop Down Menu
--[[	UnitPopupButtons - config
	[text]
	[dist] - ??
	[icon]
	[tCoordLeft]
	[tCoordRight]
	[tCoordTop]
	[tCoordBottom]
	[tSizeX]
	[tSizeY]
	[tFitDropDownSizeX]
	[iconOnly]
	[notCheckable]
	[value]
	[owner]
	[func]
	[color] - {r,g,b}
	[checked]
	[hasArrow]
	[isNotRadio]
	[isTitle]
	[tooltipText]
	[disabled]
	[nested] - SubMenu
--]]

UnitPopupButtons["MOVE_FRAME"] = { text = "Move Frame", dist = 0, color = { r = 0.0, g = 1.0, b = 0.6 } }
UnitPopupButtons["LOCK_FRAME"] = { text = "Lock Frame", dist = 0, color = { r = 0.0, g = 1.0, b = 0.6 } }
UnitPopupButtons["RESET_POS"] = { text = "Reset Position", dist = 0, color = { r = 0.0, g = 1.0, b = 0.6 } }

local DefaultPositions = {
	["SyncUI_PlayerFrame"] = {"BOTTOM","SyncUI_MainMenuBar","TOP",-200,100},
	["SyncUI_TargetFrame"] = {"BOTTOM","SyncUI_MainMenuBar","TOP",200,100},
	["SyncUI_FocusFrame"] = {"BOTTOM","SyncUI_PlayerFrame","TOPLEFT",-25,125},
	
	["SyncUI_PetFrame"] = {"TOPLEFT","SyncUI_PlayerFrame","BOTTOMLEFT",-5,-35},	
	["SyncUI_ToTFrame"] = {"TOPLEFT","SyncUI_TargetFrame","BOTTOMRIGHT",-5,5},
	["SyncUI_ToFFrame"] = {"BOTTOMRIGHT","SyncUI_FocusFrame","TOPLEFT",5,-5},
}

local function GetUnitFrame(unitID)
	if unitID == "player" then
		return _G["SyncUI_PlayerFrame"]
	elseif unitID == "target" then
		return _G["SyncUI_TargetFrame"]
	elseif unitID == "focus" then
		return _G["SyncUI_FocusFrame"]
	elseif unitID == "pet" then
		return _G["SyncUI_PetFrame"]	
	elseif unitID == "targettarget" then
		return _G["SyncUI_ToTFrame"]
	elseif unitID == "focustarget" then
		return _G["SyncUI_ToFFrame"]
	end
end

local function DropDownButton_OnClick(type,frame)

	if type == "MOVE_FRAME" then
		frame.isMovable = true
	end
	
	if type == "LOCK_FRAME" then
		frame.isMovable = false
	end
	
	if type == "RESET_POS" then
		if InCombatLockdown() then return end
		
		local name = frame:GetName()
		local point, relativeTo, relativePoint, xPos, yPos = unpack(DefaultPositions[name])
		
		frame.isMovable = false
		frame:ClearAllPoints()
		frame:SetPoint(point, relativeTo, relativePoint, xPos, yPos)
	end
end

local function AddDropDownButton(type, frame)

	if type == "RESET_POS" and InCombatLockdown() then
		UnitPopupButtons["RESET_POS"].color = { r = 0.5, g = 0.5, b = 0.5 }
	else
		UnitPopupButtons["RESET_POS"].color = { r = 0.0, g = 1.0, b = 0.6 }
	end
	
	UnitPopup_AddDropDownButton({}, UnitPopupButtons[type], type, UIDROPDOWNMENU_MENU_LEVEL)
end

hooksecurefunc("UnitPopup_ShowMenu", function(dropdownMenu, which, unitID, name, userData)
	if UIDROPDOWNMENU_MENU_LEVEL > 1 then return end

	local frame = GetUnitFrame(unitID)
	
	if frame then
		AddDropDownButton("SUBSECTION_SEPARATOR")
		
		if frame.isMovable then
			AddDropDownButton("LOCK_FRAME")
		else
			AddDropDownButton("MOVE_FRAME")
		end
		
		AddDropDownButton("RESET_POS")
	end
end)

hooksecurefunc("UnitPopup_OnClick", function(self)
	local type = self.value
    local unitID = UIDROPDOWNMENU_INIT_MENU.unit
	local frame = GetUnitFrame(unitID)
	
	if frame then
		if type == "MOVE_FRAME" or type == "RESET_POS" or type == "LOCK_FRAME" then
			DropDownButton_OnClick(type,frame)
		end
	end
end)
