--[[	reskinning chat bubbles

------------------]]

local numChildren = -1
local font = SyncUI_GameFontOutline_Small

function SkinBubble(frame)
	for i = 1, frame:GetNumRegions() do
		local region = select(i, frame:GetRegions())
		if region:GetObjectType() == "Texture" then
			region:SetTexture(nil)
		elseif region:GetObjectType() == "FontString" then
			frame.text = region
		end
	end

	do	-- create new Backdrop
		local adj = 7
		local edgeSize = 12
		local bgFile = "Interface\\AddOns\\SyncUI\\Media\\Textures\\UI-Mods\\Tooltip\\Tooltip_Background"
		local edgeFile = "Interface\\AddOns\\SyncUI\\Media\\Textures\\UI-Mods\\Tooltip\\Tooltip_Edge"
		local arrowFile = "Interface\\AddOns\\SyncUI\\Media\\Textures\\UI-Mods\\Tooltip\\Tooltip_Arrow"
		
		local backdrop = frame:CreateTexture(nil,"BACKGROUND")
		backdrop:SetPoint("TOPLEFT",10,-10)
		backdrop:SetPoint("BOTTOMRIGHT",-10,10)
		backdrop:SetTexture(bgFile)

		local topleft = frame:CreateTexture(nil,"BACKGROUND")
		topleft:SetDrawLayer("BACKGROUND", 1)
		topleft:SetSize(edgeSize,edgeSize)
		topleft:SetPoint("TOPLEFT",0+adj,0-adj)
		topleft:SetTexture(edgeFile)
		topleft:SetTexCoord(0.5,0.625,0,1)
		
		local topright = frame:CreateTexture(nil,"BACKGROUND")
		topright:SetDrawLayer("BACKGROUND", 1)
		topright:SetSize(edgeSize,edgeSize)
		topright:SetPoint("TOPRIGHT",0-adj,0-adj)
		topright:SetTexture(edgeFile)
		topright:SetTexCoord(0.625,0.75,0,1)
		
		local top = frame:CreateTexture(nil,"BACKGROUND")
		top:SetDrawLayer("BACKGROUND", 1)
		top:SetPoint("TOPLEFT",topleft,"TOPRIGHT")
		top:SetPoint("BOTTOMRIGHT",topright,"BOTTOMLEFT")
		top:SetTexture(edgeFile)
		top:SetTexCoord(0.6,0.65,0,1)
		
		local bottomleft = frame:CreateTexture(nil,"BACKGROUND")
		bottomleft:SetDrawLayer("BACKGROUND", 1)
		bottomleft:SetSize(edgeSize,edgeSize)
		bottomleft:SetPoint("BOTTOMLEFT",0+adj,0+adj)
		bottomleft:SetTexture(edgeFile)
		bottomleft:SetTexCoord(0.75,0.875,0,1)
		
		local bottomright = frame:CreateTexture(nil,"BACKGROUND")
		bottomright:SetDrawLayer("BACKGROUND", 1)
		bottomright:SetSize(edgeSize,edgeSize)
		bottomright:SetPoint("BOTTOMRIGHT",0-adj,0+adj)
		bottomright:SetTexture(edgeFile)
		bottomright:SetTexCoord(0.875,1,0,1)
		
		local bottom = frame:CreateTexture(nil,"BACKGROUND")
		bottom:SetDrawLayer("BACKGROUND", 1)
		bottom:SetPoint("TOPLEFT",bottomleft,"TOPRIGHT")
		bottom:SetPoint("BOTTOMRIGHT",bottomright,"BOTTOMLEFT")
		bottom:SetTexture(edgeFile)
		bottom:SetTexCoord(0.85,0.9,0,1)
		
		local left = frame:CreateTexture(nil,"BACKGROUND")
		left:SetDrawLayer("BACKGROUND", 1)
		left:SetPoint("TOPLEFT",topleft,"BOTTOMLEFT")
		left:SetPoint("BOTTOMRIGHT",bottomleft,"TOPRIGHT")
		left:SetTexture(edgeFile)
		left:SetTexCoord(0,0.125,0,1)
		
		local right = frame:CreateTexture(nil,"BACKGROUND")
		right:SetDrawLayer("BACKGROUND", 1)
		right:SetPoint("TOPLEFT",topright,"BOTTOMLEFT")
		right:SetPoint("BOTTOMRIGHT",bottomright,"TOPRIGHT")
		right:SetTexture(edgeFile)
		right:SetTexCoord(0.125,0.25,0,1)
		
		local arrow = frame:CreateTexture(nil,"BACKGROUND")
		arrow:SetDrawLayer("BACKGROUND", 2)
		arrow:SetSize(edgeSize*2,edgeSize)
		arrow:SetPoint("TOP",bottom,"BOTTOM",0,4)
		arrow:SetTexture(arrowFile)
	end

	frame.text:SetFontObject(font)
	frame:SetClampedToScreen(false)
	frame.isStyled = true
end

function IsChatBubble(frame)
	for i = 1, frame:GetNumRegions() do
		local region = select(i, frame:GetRegions())
		if (region.GetTexture and region:GetTexture() and type(region:GetTexture() == "string") and
		strlower(region:GetTexture()) == [[interface\tooltips\chatbubble-background]]) then
			return true
		end
	end
	return false
end

function SyncUI_ChatBubble_OnLoad(self)
	self.lastupdate = -2
	
	self:SetScript('OnUpdate', function(self, elapsed)
		self.lastupdate = self.lastupdate + elapsed
		if self.lastupdate < 0.1 then return end
		self.lastupdate = 0
		
		local count = WorldFrame:GetNumChildren()
		if count ~= numChildren then
			numChildren = count
			for index = 1, select('#', WorldFrame:GetChildren()) do
				local frame = select(index, WorldFrame:GetChildren())

				if IsChatBubble(frame) and not frame.isStyled then SkinBubble(frame) end
			end
		end	
	end)
end