--[[	handler functions for the ready check window

------------------]]

SyncUI_Data["ReadyCheckInfo"] = {}
SyncUI_Data["ReadyCheckStatus"] = {}
local MAX_RCW_LINES = 6
local ReadyCheckInfo, ReadyCheckStatus = SyncUI_Data["ReadyCheckInfo"], SyncUI_Data["ReadyCheckStatus"]
local ReadyCheckFinished, ReadyCheckFading, ReadyCheckTimer;
local _G, gsub, tinsert, tremove = _G, gsub, table.insert, table.remove


local function GetInfo(index)
	local name, status
	
	for k, v in pairs(ReadyCheckInfo) do
		if k == index then
			name = v
			break
		end
	end
	
	for k, v in pairs(ReadyCheckStatus) do
		if k == index then
			status = v
			break
		end
	end
	
	return name, status
end

local function GetInfoIndex(name)
	for k, v in pairs(ReadyCheckInfo) do
		if v == name then
			return k
		end
	end
end

local function GetTexture(status)
	local path, left, right, top, bottom
	
	if status == "offline" then
		path = "Interface\\CHARACTERFRAME\\Disconnect-Icon"
		left, right, top, bottom = 0.2,0.8,0.2,0.8
	else
		if status == "ready" then
			path = READY_CHECK_READY_TEXTURE
		elseif status == "notready" then
			path = READY_CHECK_NOT_READY_TEXTURE
		elseif status == "waiting" then
			path = READY_CHECK_WAITING_TEXTURE
		end
		
		left, right, top, bottom = 0,1,0,1
	end
	
	return path, left, right, top, bottom
end

local function IsInTable(name)
	for k, v in pairs(ReadyCheckInfo) do
		if v == name then
			return true
		end
	end	
	
	return false
end


local function ReadyCheck_OnReset()
	ReadyCheckFinished = nil
	ReadyCheckFading = nil
	ReadyCheckInfo = {}
	ReadyCheckStatus = {}
end

local function ReadyCheck_OnInit(...)
	ReadyCheck_OnReset()
	
	ReadyCheckTimer = select(2, ...)
	
	local user, duration = ...
	user = user:gsub("%-.+", "")
	
	for i = 1, GetNumGroupMembers() do
		local unitID
		
		if IsInRaid() then
			unitID = "raid"..i
		elseif i == GetNumGroupMembers() then
			unitID = "player"
		else
			unitID = "party"..i
		end
		
		local name = select(1, UnitName(unitID))
		
		if not IsInTable(name) and name ~= user then
			tinsert(ReadyCheckInfo,name)
			
			if UnitIsConnected(name) then
				tinsert(ReadyCheckStatus,"waiting")
			else
				tinsert(ReadyCheckStatus,"offline")
			end
		end
	end
end

local function ReadyCheck_OnUpdate(...)
	local unitID, status = ...
	local name = select(1, UnitName(unitID))
	local index = GetInfoIndex(name)
	
	if index then
		if status then
			ReadyCheckStatus[index] = "ready"
			tremove(ReadyCheckStatus,index)
			tremove(ReadyCheckInfo,index)
		elseif ReadyCheckStatus[index] == "offline" then
			return		
		else
			ReadyCheckStatus[index] = "notready"			
		end
	end
end

local function ReadyCheck_OnFinished()
	if #ReadyCheckStatus > 0 then
		for k, v in pairs(ReadyCheckStatus) do
			if v == "waiting" then
				ReadyCheckStatus[k] = "notready"
			end
		end
	end

	ReadyCheckTimer = nil
	ReadyCheckFinished = true
	ReadyCheckFading = 7
end


function SyncUI_ReadyCheckWindow_OnLoad(self)
	ReadyCheck_OnReset()
	self:RegisterEvent("READY_CHECK")
	self:RegisterEvent("READY_CHECK_CONFIRM")
	self:RegisterEvent("READY_CHECK_FINISHED")
	self:RegisterForDrag('LeftButton')
	self:SetScale(SyncUI_UIScale)
end

function SyncUI_ReadyCheckWindow_OnEvent(self,event,...)
	if event == "READY_CHECK" then
		self:Show()
		ReadyCheck_OnInit(...)
	end
	if event == "READY_CHECK_CONFIRM" then
		ReadyCheck_OnUpdate(...)
	end
	if event == "READY_CHECK_FINISHED" then
		ReadyCheck_OnFinished()
	end
	
	SyncUI_ReadyCheckWindow_UpdateScrollFrame()
end

function SyncUI_ReadyCheckWindow_OnUpdate(self,elapsed)
	if ReadyCheckFinished then
		if ReadyCheckFading and ReadyCheckFading > 0 then
			ReadyCheckFading = ReadyCheckFading - elapsed
		else
			ReadyCheck_OnReset()
			self:Hide()
		end
	end
	
	if ReadyCheckTimer and ReadyCheckTimer > 0 then
		ReadyCheckTimer = ReadyCheckTimer - elapsed
		
		self.Timer:SetText(math.ceil(ReadyCheckTimer).."s")
	elseif not ReadyCheckTimer and ReadyCheckFinished then
		self.Timer:SetText("Fin")
	else
		self.Timer:SetText("")
	end
end

function SyncUI_ReadyCheckWindow_UpdateScrollFrame()
	FauxScrollFrame_Update(SyncUI_ReadyCheckWindowScrollFrame, #ReadyCheckInfo, MAX_RCW_LINES, 19)
	
	local offset = FauxScrollFrame_GetOffset(SyncUI_ReadyCheckWindowScrollFrame)
	
	for i = 1, MAX_RCW_LINES do
		local frame = _G["SyncUI_ReadyCheckWindowLine"..i]
		local index = offset + i
		if index <= #ReadyCheckInfo then
			local name, status = GetInfo(index)
			local texture, left, right, top, bottom = GetTexture(status)
			frame.name:SetText(name)
			frame.icon:SetTexture(texture)
			frame.icon:SetTexCoord(left, right, top, bottom)
			frame:Show()
		else
			frame:Hide()
		end
	end
end
