--[[	Core / API functions and Globals

------------------]]

-- Globals
if not SyncUI_Data then SyncUI_Data = {} end
if not SyncUI_CharData then SyncUI_CharData = {} end

SyncUI_UIScale = 768 / 1080

SYNCUI_CLASS_COLORS = {
    ["HUNTER"] 		= { r = 0.5, g = 0.7, b = 0.2 },
    ["WARLOCK"] 	= { r = 0.6, g = 0.0, b = 1.0 },
    ["PRIEST"] 		= { r = 1.0, g = 1.0, b = 1.0 },
    ["PALADIN"] 	= { r = 1.0, g = 0.2, b = 0.8 },
    ["MAGE"] 		= { r = 0.0, g = 0.8, b = 1.0 },
    ["ROGUE"]		= { r = 1.0, g = 1.0, b = 0.0 },
    ["DRUID"] 		= { r = 1.0, g = 0.3, b = 0.0 },
    ["SHAMAN"] 		= { r = 0.0, g = 0.4, b = 1.0 },
    ["WARRIOR"] 	= { r = 0.8, g = 0.6, b = 0.4 },
    ["DEATHKNIGHT"] = { r = 0.9, g = 0.0, b = 0.2 },
    ["MONK"] 		= { r = 0.0, g = 1.0, b = 0.6 },
}

SYNCUI_POWER_COLORS = {
	["MANA"] 		= { r = 0.0, g = 0.4, b = 8.0},
	["RAGE"] 		= { r = 1.0, g = 0.2, b = 0.2},
	["FOCUS"] 		= { r = 0.8, g = 0.4, b = 0.0},
	["ENERGY"] 		= { r = 0.8, g = 0.8, b = 0.0},
	["RUNIC_POWER"] = { r = 0.0, g = 0.8, b = 1.0},
}

BINDING_HEADER_SYNCUI = "SyncUI"


function SyncUI_UIParent_OnLoad(self)
	UIParent:HookScript("OnShow", function() self:SetAlpha(1) end)
	UIParent:HookScript("OnHide", function() self:SetAlpha(0) end)

	--MovieFrame:SetScript("OnEvent", function() GameMovieFinished() end)
	--hooksecurefunc(CinematicFrame,"Show", function() CinematicFrame.closeDialog:Hide() CinematicFrame_CancelCinematic() end)
end

function SyncUI_DisableFrame(ref)
	local frame
	
	if type(ref) == "string" then
		frame = _G[ref]
	else
		frame = ref
	end
	
	if frame then
		frame:SetParent(SyncUI_DisableBlizzard)
		frame:UnregisterAllEvents()
	end
end


function SyncUI_Flashing_OnInit(self,fadeInTime,fadeOutTime,flashDuration)
    self.fadeInTime = fadeInTime
    self.fadeOutTime = fadeOutTime
    self.flashDuration = flashDuration
    self.flashTimer = 0
end

function SyncUI_Flashing_OnUpdate(self,elapsed)
	self.flashTimer = self.flashTimer + elapsed

	if self.flashTimer > self.flashDuration and self.flashDuration ~= -1 then
		-- do nothing
	else
		local flashTime = self.flashTimer
		local alpha

		flashTime = flashTime%(self.fadeInTime + self.fadeOutTime)
		if flashTime < self.fadeInTime then
			alpha = flashTime/self.fadeInTime
		elseif flashTime < self.fadeInTime then
			alpha = 1
		elseif flashTime < self.fadeInTime + self.fadeOutTime then
			alpha = 1 - ((flashTime - self.fadeInTime) / self.fadeOutTime)
		else
			alpha = 0
		end

		self:SetAlpha(alpha)
	end
end


function SyncUI_FadeIn(frame,duration,secure)
	if not secure then frame:Show() end
	if not frame.FadeFrame then frame.FadeFrame = CreateFrame("Frame",nil,frame) end
	
	frame:SetAlpha(0)
	frame.FadeFrame:SetScript("OnUpdate", nil)
	frame.FadeFrame:SetScript("OnUpdate", function(self,elapsed)
		local alpha = frame:GetAlpha()
		if alpha < 1 then
			alpha = alpha + (elapsed / duration)
			frame:SetAlpha(alpha)
		else
			self:SetScript("OnUpdate", nil)
		end
	end)
end

function SyncUI_FadeOut(frame,duration,secure)
	if not frame.FadeFrame then frame.FadeFrame = CreateFrame("Frame",nil,frame) end
	
	frame:SetAlpha(1)
	frame.FadeFrame:SetScript("OnUpdate", nil)
	frame.FadeFrame:SetScript("OnUpdate", function(self,elapsed)
		local alpha = frame:GetAlpha()
		if alpha > 0 then
			alpha = alpha - (elapsed / duration)
			frame:SetAlpha(alpha)
		else
			self:SetScript("OnUpdate", nil)
			
			if secure and InCombatLockdown() then
				self:RegisterEvent("PLAYER_REGEN_ENABLED")
				self:SetScript("OnEvent", function(self)
					frame:Hide()
					self:UnregisterEvent("PLAYER_REGEN_ENABLED")
				end)
			else
				frame:Hide()
			end
		end
	end)
end


function SyncUI_SlideIn(self)
	self.SlideIn:Play()
end

function SyncUI_SlideOut(self)
	self.SlideOut:Play()
end


function SyncUI_Cooldown_OnRegister(self)
	local numRegions = self:GetNumRegions()

	for i = 1, numRegions do
		local region = select(i, self:GetRegions())

		if region.GetText then
			if self:GetHeight() > 37 then
				region:SetFontObject(SyncUI_GameFontNormal_Huge)
			else
				region:SetFontObject(SyncUI_GameFontNormal_Large)
			end
			
			region:SetPoint("CENTER",1,0)
		end 
	end

	self:SetBlingTexture("")
end
