--[[	handler functions for unit castbars

------------------]]

local ticks = {}
local tickList = {
	[GetSpellInfo(689) or ""] = 6,		-- Drain Life
	[GetSpellInfo(15407) or ""] = 3,	-- Mind Flay
	[GetSpellInfo(129197) or ""] = 3,	-- Mind Flay: Insanity
	[GetSpellInfo(115175) or ""] = 8,	-- Soothing Mist
}

local function GetUnitID(self)
	if strfind(self:GetName(),"Player") then
		return "player"
	elseif strfind(self:GetName(),"Target") then
		return "target"
	elseif strfind(self:GetName(),"Focus") then
		return "focus"
	elseif strfind(self:GetName(),"Party") then
		return "party"..self:GetID()		
	elseif strfind(self:GetName(),"Raid") then
		return "raid"..self:GetID()
	elseif strfind(self:GetName(),"Boss") then
		return "boss"..self:GetID()
	end
end

local function HideTicks(frame)
	for i = 1, #ticks do
		ticks[i]:Hide()
	end
end

local function SetCastTicks(frame,numTicks)
	if numTicks and numTicks <= 0 then return end
	
	local width = frame:GetWidth()
	local dimension = width / numTicks

	for i = 1, numTicks-1 do
		if not ticks[i] then
			ticks[i] = frame:CreateTexture(nil, 'OVERLAY')
			ticks[i]:SetTexture(0,0,0,0.5)
			ticks[i]:SetSize(2*SyncUI_UIScale,frame:GetHeight())
		end
		ticks[i]:ClearAllPoints()
		ticks[i]:SetPoint("RIGHT",frame,"LEFT",dimension*i,0)
		ticks[i]:Show()
	end
end

function SyncUI_CastingBar_OnLoad(self)
	self.Spell = self.ArtFrame.Spell
	self.Spark = self.ArtFrame.Spark
	
	self.Spark:ClearAllPoints()
	self.Spark:SetPoint("RIGHT",self.StatusBar:GetStatusBarTexture(),6,0)
	
	local unitID = self:GetParent().unitID or GetUnitID(self:GetParent())
	self:RegisterEvent("PLAYER_TARGET_CHANGED")
	self:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
	self:RegisterUnitEvent("UNIT_SPELLCAST_START",unitID)
	self:RegisterUnitEvent("UNIT_SPELLCAST_STOP",unitID)
	self:RegisterUnitEvent("UNIT_SPELLCAST_CHANNEL_START",unitID)
	self:RegisterUnitEvent("UNIT_SPELLCAST_CHANNEL_STOP",unitID)
	self:RegisterUnitEvent("UNIT_SPELLCAST_INTERRUPTED",unitID)
	self:SetAlpha(0)
end

function SyncUI_CastingBar_OnEvent(self, event, ...)
	local unitID = self:GetParent().unitID

	if not unitID then return end
		
	if event == "PLAYER_TARGET_CHANGED" then
		if not UnitCastingInfo(unitID) or not UnitChannelInfo(unitID) then
			self:SetAlpha(0)
		end
	end
	
	if event == "COMBAT_LOG_EVENT_UNFILTERED" then
		if select(2, ...) == "SPELL_INTERRUPT" then
			if select(4, ...) == UnitGUID(unitID) then
				self.StatusBar:SetMinMaxValues(0, 1)
				self.StatusBar:SetValue(1)
				self.StatusBar:SetStatusBarColor(1,0,0)
				self.Spell:SetText("LOCKOUT!!!")
				self.interrupted = true
			end
		end
		
		if select(2, ...) == "UNIT_DIED" then
			if select(4, ...) == UnitGUID(unitID) then
				self.fadeOut = 1
			end
		end
	end

	if event == "UNIT_SPELLCAST_INTERRUPTED" then
		self.StatusBar:SetMinMaxValues(0, 1)
		self.StatusBar:SetValue(1)
		self.StatusBar:SetStatusBarColor(1,0,0)
		self.Spell:SetText("Interrupted")
		self.interrupted = true
		HideTicks(self.StatusBar)
	end

	if event == "UNIT_SPELLCAST_START" then
		self.Spark:Show()
		self.StatusBar:SetAlpha(1)
		self.StatusBar:SetReverseFill(false)
		self.interrupted = nil
		self.fadeOut = nil
		HideTicks(self.bar)
	end
	
	if event == "UNIT_SPELLCAST_CHANNEL_START" then
		local unitID, spell = ...
		self.Spark:Show()
		self.StatusBar:SetAlpha(1)
		self.interrupted = nil
		self.fadeOut = nil
		
		if unitID == "player" then
			local numBaseTicks = tickList[spell]
			if numBaseTicks and numBaseTicks > 0 then
				SetCastTicks(self.StatusBar,numBaseTicks)
			end
		end
	end

	if event == "UNIT_SPELLCAST_STOP" or event == "UNIT_SPELLCAST_CHANNEL_STOP" then
		self.StatusBar:SetMinMaxValues(0, 1)
		self.StatusBar:SetValue(1)
		self.Spark:Hide()
		
		HideTicks(self.StatusBar)
		
		if self.interrupted == nil then
			self.StatusBar:SetStatusBarColor(0,1,0)
		else
			self.StatusBar:SetStatusBarColor(1,0,0)
		end
		
		self.fadeOut = 1
	end
end

function SyncUI_CastingBar_OnUpdate(self)
	local unitID = self:GetParent().unitID
	local fadeOutStep = 0.005
	
	if not unitID then return end
	
	-- FadeOut
	if self.fadeOut then
		local alpha = self:GetAlpha() - fadeOutStep
		if alpha > 0 then
			self:SetAlpha(alpha)
		else
			self.fadeOut = nil
			self:SetAlpha(0)
		end
	end

	-- Casting Info
	if UnitCastingInfo(unitID) then
		local spell, _, _, tex, startTime, endTime, _, _, interrupt = UnitCastingInfo(unitID)
		if spell then
			local value = (GetTime() - (startTime / 1000))
			local maxValue = ((endTime - startTime) / 1000)
		
			self:SetAlpha(1)
			self.StatusBar:SetMinMaxValues(0, maxValue)
			self.StatusBar:SetValue(value)
			self.Icon:SetTexture(tex)
			self.Spell:SetText(spell)
			
			-- Interrupt Color
			if interrupt then
				self.StatusBar:SetStatusBarColor(1,0,0)
			else
				self.StatusBar:SetStatusBarColor(1,0.7,0)
			end
		end
	end

	-- Channel Info
	if UnitChannelInfo(unitID) then
		local spell, _, _, tex, startTime, endTime, _, _, interrupt = UnitChannelInfo(unitID)
		if spell then
			local value = ((endTime / 1000) - GetTime())
			local maxValue = ((endTime - startTime) / 1000)
			
			self:SetAlpha(1)
			self.StatusBar:SetMinMaxValues(0, maxValue)
			self.StatusBar:SetValue(value)
			self.Icon:SetTexture(tex)
			self.Spell:SetText(spell)
			
			-- Interrupt Color
			if interrupt then
				self.StatusBar:SetStatusBarColor(1,0,0)
			else
				self.StatusBar:SetStatusBarColor(0,1,0)
			end
		end
	end
end
