
local rowMax = 10

local function SortContainer(a,b)
	if a == nil or b == nil then return false end
	
	if a.type ~= b.type then
		if a.type and b.type then
			return a.type > b.type
		elseif a.type == nil or b.type == nil then
			return a.type and true or false
		else
			return false
		end
	elseif a.rarity ~= b.rarity then
		return a.rarity > b.rarity
	elseif a.name ~= b.name then
		return a.name < b.name
	elseif a.stack ~= b.stack then
		return a.stack < b.stack
	else
		return false
	end
end

local function SortInventoryFreeSlot(self)
	if not self.freeSlot then return end
	
	for k, v in pairs(self.buttons) do
		if v == self.freeSlot then
			tremove(self.buttons,k)
		end
	end
	
	tinsert(self.buttons,self.freeSlot)
end

local function AddButtonToContainer(container,button)
	button.container = container
	
	for k, v in pairs(container.buttons) do
		if v == button then
			return
		end
	end
	
	table.insert(container.buttons,button)
end

local function RemoveButtonFromContainer(container,button)
	for i, ref in pairs(container.buttons) do
		if button == ref then
			table.remove(container.buttons,i)
		end
	end
end

local function UpdateSlot(bagID,slot)
	local button = _G["SyncUI_BankFrame_ReagentBank_Slot"..slot]
	local container = _G["SyncUI_BankFrame_ReagentBank"]
	local itemLink = GetContainerItemLink(bagID,slot)
	
	if button then
		if itemLink then
			AddButtonToContainer(container,button)
		else
			RemoveButtonFromContainer(container,button)
		end
		
		SyncUI_ItemSlot_ForceUpdate(button,bagID,slot)
	end
	
	SyncUI_ReagentBank_ForceUpdate(container)
end

local function UpdateBag(bagID)
	local numSlots = GetContainerNumSlots(bagID)
	
	for slot = 1, numSlots do
		UpdateSlot(bagID,slot)
	end
end

local function UpdateInventoryFreeSlot(self)
	local numFreeSlots = 98 - (#self.buttons - 1)
	self.freeSlot.text:SetText(numFreeSlots)
end


if IsAddOnLoaded("Bagnon") or IsAddOnLoaded("ArkInventory") or IsAddOnLoaded("cargBags_Nivaya") then return end


-- Reagent Bank Functions
function SyncUI_ReagentBank_OnLoad(self)
	self:RegisterEvent("REAGENTBANK_PURCHASED")
	self:RegisterEvent("REAGENTBANK_UPDATE")
	self:RegisterEvent("PLAYERREAGENTBANKSLOTS_CHANGED")
	self:SetID(REAGENTBANK_CONTAINER)
	self.buttons = {}
	
	for i = 1, 98 do
		local button = _G["SyncUI_BankFrame_ReagentBank_Slot"..i]
		
		SyncUI_ItemSlot_SetStyle(button)
		
		table.insert(self.buttons,button)
	end
end

function SyncUI_ReagentBank_OnShow(self)
	UpdateBag(self:GetID())
	
	if not IsReagentBankUnlocked() then self.unlock:Show() end
end

function SyncUI_ReagentBank_OnEvent(self,event,...)
	if event == "REAGENTBANK_PURCHASED" then
		self.unlock:Hide()
	end
	
	if event == "REAGENTBANK_UPDATE" then
		UpdateBag(self:GetID())
	end
	
	if event == "PLAYERREAGENTBANKSLOTS_CHANGED" then
		UpdateSlot(self:GetID(),...)
	end
end

function SyncUI_ReagentBank_ForceUpdate(self)
	local edgeSpace, buttonSize = 20,37
	local leftEdge, rightEdge, topEdge, bottomEdge = 31, 31, 28, 50
	local minHeight, maxHeight = 263, 448
	table.sort(self.buttons,SortContainer)
	SortInventoryFreeSlot(self)
	
	for i, button in pairs(self.buttons) do
		local pos = i % rowMax
		if pos == 0 then pos = rowMax end
		local row = math.ceil(i / rowMax)
			
		button:ClearAllPoints()
		button:SetPoint("TOPLEFT",self,leftEdge+(buttonSize*(pos-1)),-topEdge-(buttonSize*(row-1)))
	end
	
	local numSlots = #self.buttons
	local width = buttonSize*rowMax + leftEdge + rightEdge
	local height = math.ceil(numSlots / rowMax) * buttonSize

	height = height + topEdge + bottomEdge
	
	if height > maxHeight then
		height = maxHeight
	elseif height < minHeight then
		height = minHeight
	end
	
	self:SetSize(width,height)
	self:SetAlpha(1)
	
	UpdateInventoryFreeSlot(self)
end
