--[[	reskinning DBM timers

------------------]]

local _G = _G
local dummy = function() end
local path = "Interface\\AddOns\\SyncUI\\Media\\Fonts\\Vibro.ttf"

local function applyStyle(parent)
	local frame = parent.frame 
	local bar = _G[frame:GetName().."Bar"]
	bar.texture, bar.spark = _G[frame:GetName().."BarTexture"], _G[frame:GetName().."BarSpark"]
	bar.icon1, bar.icon2 = _G[frame:GetName().."BarIcon1"], _G[frame:GetName().."BarIcon2"]
	bar.name, bar.duration = _G[frame:GetName().."BarName"], _G[frame:GetName().."BarTimer"]
	
	-- Size Bar
	frame:SetHeight(26)
	frame.SetHeight = dummy
	
	bar:SetSize(148,14)
	bar.SetHeight = dummy
	bar.SetWidth = dummy
	
	bar:SetScript("OnSizeChanged",function(self) self:SetSize(148,14) end)	-- hotfix ?¿
	bar.texture:SetTexture("Interface\\AddOns\\SyncUI\\Media\\Textures\\Elements\\Statusbar\\Statusbar_Fill2")
	bar.texture.SetTexture = dummy
	
	-- Icons
	bar.icon1:SetSize(22,22)
	bar.icon1.SetHeight = dummy
	bar.icon1.SetWidth = dummy
	bar.icon1:ClearAllPoints()
	bar.icon1:SetDrawLayer("BACKGROUND")
	bar.icon1:SetPoint("RIGHT",bar,"LEFT", -7, 0)
	bar.icon1:SetTexCoord(0.05,0.95,0.05,0.95)
	bar.icon1:Show()
	bar.icon2:SetAlpha(0)
	
	-- Fonts
	bar.name:SetFont(path,10,"NONE")
	bar.name:SetJustifyH("LEFT")
	bar.name:SetSize(120,10)
	bar.name:ClearAllPoints()
	bar.name:SetPoint("LEFT",bar,"LEFT",3,0)
	
	bar.duration:SetFont(path,10,"NONE")
	bar.duration:SetJustifyH("RIGHT")
	bar.duration:ClearAllPoints()
	bar.duration:SetPoint("RIGHT", bar, "RIGHT", -2, 0)
	
	-- Spark
	bar.spark:SetTexture("Interface\\AddOns\\SyncUI\\Media\\Textures\\Elements\\Statusbar\\Statusbar_Spark")
	bar.spark:SetSize(15,15)
	bar.spark:SetDrawLayer("OVERLAY",-1)
	bar.spark:ClearAllPoints()
	bar.spark:SetPoint("RIGHT",bar.texture,6,0)
	bar.spark.SetSize = dummy
	bar.spark.SetTexture = dummy
	
	-- Border
	bar.border = bar:CreateTexture(nil,"OVERLAY")
	bar.border:SetTexture("Interface\\AddOns\\SyncUI\\Media\\Textures\\UI-Mods\\BigWigs_Border")
	bar.border:SetTexCoord(0,0.74609375,0,1)
	bar.border:SetSize(191,32)
	bar.border:SetPoint("RIGHT",9,0)

	bar.background = bar:CreateTexture(nil,"BACKGROUND",-1)
	bar.background:SetAllPoints(true)
	bar.background:SetTexture("Interface\\AddOns\\SyncUI\\Media\\Textures\\Elements\\Statusbar\\Statusbar_Background")

	-- save font
	parent.owner.options.Font = path
	parent.owner.options.FontSize = 10
	
	-- Save
	parent.styled = true
end

function SyncUI_DBM_OnRegister(self)
	if DBM then
		hooksecurefunc(DBT, "CreateBar", function(self)
			for bar in self:GetBarIterator() do
				if not bar.styled then
					applyStyle(bar)
				end
			end
		end)
	end
end
