--[[	handler functions for the info bar (bottom bar)

------------------]]

local _G = _G
local MAX_TOKENS = 10
local lastUpdate, updateInterval = 0, 1.00
local bars = {"MultiBarBottomRight","MultiBarRight","MultiBarLeft"}
local MicroButtons = {
	["Character"] = {
		"Interface\\AddOns\\SyncUI\\Media\\Textures\\UI-Mods\\MainMenuBar\\InfoBar\\MicroButton_Character_Normal",
		"Interface\\AddOns\\SyncUI\\Media\\Textures\\UI-Mods\\MainMenuBar\\InfoBar\\MicroButton_Character_Pushed"
	},
	["Spellbook"] = {
		"Interface\\AddOns\\SyncUI\\Media\\Textures\\UI-Mods\\MainMenuBar\\InfoBar\\MicroButton_SpellBook_Normal",
		"Interface\\AddOns\\SyncUI\\Media\\Textures\\UI-Mods\\MainMenuBar\\InfoBar\\MicroButton_SpellBook_Pushed"
	},
	["Talent"] = {
		"Interface\\AddOns\\SyncUI\\Media\\Textures\\UI-Mods\\MainMenuBar\\InfoBar\\MicroButton_Talent_Normal",
		"Interface\\AddOns\\SyncUI\\Media\\Textures\\UI-Mods\\MainMenuBar\\InfoBar\\MicroButton_Talent_Pushed"
	},
	["Achievement"] = {
		"Interface\\AddOns\\SyncUI\\Media\\Textures\\UI-Mods\\MainMenuBar\\InfoBar\\MicroButton_Achievement_Normal",
		"Interface\\AddOns\\SyncUI\\Media\\Textures\\UI-Mods\\MainMenuBar\\InfoBar\\MicroButton_Achievement_Pushed"
	},
	["Guild"] = {
		"Interface\\AddOns\\SyncUI\\Media\\Textures\\UI-Mods\\MainMenuBar\\InfoBar\\MicroButton_Guild_Normal",
		"Interface\\AddOns\\SyncUI\\Media\\Textures\\UI-Mods\\MainMenuBar\\InfoBar\\MicroButton_Guild_Pushed"
	},
	["LFD"] = {
		"Interface\\AddOns\\SyncUI\\Media\\Textures\\UI-Mods\\MainMenuBar\\InfoBar\\MicroButton_PvE_Normal",
		"Interface\\AddOns\\SyncUI\\Media\\Textures\\UI-Mods\\MainMenuBar\\InfoBar\\MicroButton_PvE_Pushed"
	},
	["EJ"] = {
		"Interface\\AddOns\\SyncUI\\Media\\Textures\\UI-Mods\\MainMenuBar\\InfoBar\\MicroButton_Browser_Normal",
		"Interface\\AddOns\\SyncUI\\Media\\Textures\\UI-Mods\\MainMenuBar\\InfoBar\\MicroButton_Browser_Pushed"
	},
	["Collections"] = {
		"Interface\\AddOns\\SyncUI\\Media\\Textures\\UI-Mods\\MainMenuBar\\InfoBar\\MicroButton_Mount_Normal",
		"Interface\\AddOns\\SyncUI\\Media\\Textures\\UI-Mods\\MainMenuBar\\InfoBar\\MicroButton_Mount_Pushed"
	}
}
local slots = {
	[1] = "Head",
	[3] = "Shoulders",
	[5] = "Chest",
	[6] = "Waist",
	[7] = "Legs",
	[8] = "Feet",
	[9] = "Wrist",
	[10] = "Hands",
	[16] = "Mainhand",
	[17] = "Offhand",
}
local AddOnMemory = {}

local function UpdateExpBar(self)
	if not IsXPUserDisabled() and UnitLevel("player") < MAX_PLAYER_LEVEL then
		local xp, maxXP = UnitXP("player"), UnitXPMax("player")
		local value = xp*100/maxXP
		for i = 1, MAX_TOKENS do
			_G["ExpToken"..i]:SetValue(value)
			
			if GetXPExhaustion() then
				_G["ExpToken"..i]:SetStatusBarColor(0,0.5,1)
			else
				_G["ExpToken"..i]:SetStatusBarColor(0,1,0)
			end
		end
		_G[self:GetName().."Text"]:SetText(string.format("%.1f",value).."%")
		
		if not self:IsShown() then self:Show() end
	else
		if self:IsShown() then self:Hide() end
	end
end

local function UpdateRepBar(self)
	if GetWatchedFactionInfo() then
		local _, _, minRep, maxRep, curRep = GetWatchedFactionInfo()
		local tokenDistanceValue = (maxRep - minRep) / MAX_TOKENS
		for i = 1, MAX_TOKENS do
			local tokenMinValue = minRep+((i*tokenDistanceValue)-tokenDistanceValue)
			local tokenMaxValue = minRep+((i*tokenDistanceValue))
			_G["RepToken"..i]:SetMinMaxValues(tokenMinValue,tokenMaxValue)
			_G["RepToken"..i]:SetValue(curRep)
			
			if maxRep <= -3000 then
				_G["RepToken"..i]:SetStatusBarColor(0.8,0.2,0)
			elseif maxRep <= 0 then
				_G["RepToken"..i]:SetStatusBarColor(0.8,0.2,0)
			elseif maxRep <= 3000 then
				_G["RepToken"..i]:SetStatusBarColor(0.8,0.6,0)
			else
				_G["RepToken"..i]:SetStatusBarColor(0,0.7,0)
			end
			
			local value = (curRep-minRep)*100/(maxRep-minRep)
			_G[self:GetName().."Text"]:SetText(string.format("%.1f",value).."%")
		end

		if not self:IsShown() then self:Show() end
	else
		if self:IsShown() then self:Hide() end
	end
end

local function UpdateSocialButton()
	local _, numBNetOnline = BNGetNumFriends()
	local _, numWoWOnline = GetNumFriends()
	SyncUI_SocialMicroButtonCount:SetText(numBNetOnline + numWoWOnline)
end

local function UpdateConfigButton()
	local config;
	if not SyncUI_SideBar.config or SyncUI_SideBar.config == 0 then
		config = "x"
	else
		config = SyncUI_SideBar.config
	end
	SyncUI_SideBarConfigButtonCount:SetText(config)
end

local function UpdateLootButton()
	local specID, specName = GetLootSpecialization(), nil
	local color = RAID_CLASS_COLORS[select(2, UnitClass("player"))]
	if specID == 0 then
		local name = select(2, GetSpecializationInfo(GetSpecialization() or 0))
		if not name then
			specName = "No Spec"
		else
			specName = select(2, GetSpecializationInfo(GetSpecialization()))
		end
	else
		specName = select(2, GetSpecializationInfoByID(specID))
	end
	
	SyncUI_LootSpecButtonText:SetText("|cffFFFFFFLoot:|r "..specName)
	SyncUI_LootSpecButtonText:SetVertexColor(color.r, color.g, color.b)
end

local function UpdateLatency(self)
	local _,_,latencyHome,latencyWorld = GetNetStats();				
	local home = tonumber(string.format("%3.0f",latencyHome))
	local world = tonumber(string.format("%3.0f",latencyWorld))

	if home >= 100 then
		home = tostring("|cffFF0000"..home.."|r")
	else
		home = tostring("|cff00FF00"..home.."|r")
	end
	
	if world >= 100 then
		world = tostring("|cffFF0000"..world.."|r")
	else
		world = tostring("|cff00FF00"..world.."|r")
	end

	self:SetText(home.." | "..world.." ms")
end

local function UpdateMemory(self)
	UpdateAddOnMemoryUsage()
	local memory, suffix = 0
	
	for i = 1, GetNumAddOns() do
		if IsAddOnLoaded(i) then
			memory = memory + GetAddOnMemoryUsage(i)
		end
	end
	
	if memory < 1000 then
		memory = tostring("|cff00FF00"..string.format("%.0f",memory).."|r")
		suffix = " KB"
	else
		memory = tostring("|cff00FF00"..string.format("%.2f",memory/1000).."|r")
		suffix = " MB"
	end
	
	self:SetText(memory..suffix)
end

local function UpdateFPS(self)
	local framerate = math.floor(GetFramerate())

	if framerate >= 50 then
		framerate = tostring("|cff00FF00"..framerate.."|r")
	elseif framerate >= 25 then
		framerate = tostring("|cffFFFF00"..framerate.."|r")
	else
		framerate = tostring("|cffFF0000"..framerate.."|r")
	end
	
	self:SetText(framerate.." FPS")
end

local function UpdateDurability(self)
	local durability, maxDurability = 0, 0
	for slot, type in pairs(slots) do
		local dur, maxDur = GetInventoryItemDurability(slot)
		if dur then
			durability = durability + dur
			maxDurability = maxDurability + maxDur
		end
	end
	
	local perc = math.floor(durability * 100 / maxDurability)
	
	if perc >= 70 then
		perc = tostring("|cff00FF00"..perc.."%|r")
	elseif perc >= 30 then
		perc = tostring("|cffFFFF00"..perc.."%|r")
	else
		perc = tostring("|cffFF0000"..perc.."%|r")
	end
	
	self:SetText(perc.." Durability")
end

local function UpdateInfoButton(self)
	if not self.select then self.select = 1 end
	
	if self.select == 1 then UpdateLatency(self) end
	if self.select == 2 then UpdateMemory(self) end
	if self.select == 3 then UpdateFPS(self) end
	if self.select == 4 then UpdateDurability(self) end
end

local function RegisterSideBarDriver(index)
	if InCombatLockdown() then return end
	
	if index == 0 then
		for _, bar in pairs(bars) do
			local Bar = _G["SyncUI_"..bar]
			UnregisterStateDriver(Bar,"visibility")
		end
		SyncUI_SideBar:UnregisterEvent("PLAYER_REGEN_ENABLED")
		SyncUI_SideBar:UnregisterEvent("PLAYER_REGEN_DISABLED")
	else
		for row, bar in pairs(bars) do
			local Bar = _G["SyncUI_"..bar]
			if row == index then
				RegisterStateDriver(Bar, "visibility", "[combat] show")
				SyncUI_SideBar.switch = row
			else
				RegisterStateDriver(Bar, "visibility", "[combat] hide")
			end
		end
		SyncUI_SideBar:RegisterEvent("PLAYER_REGEN_ENABLED")
		SyncUI_SideBar:RegisterEvent("PLAYER_REGEN_DISABLED")
	end
end

local function GetMicroButtonIndex(prefix)
	if prefix == "Character" then 	return 1 end
	if prefix == "Spellbook" then 	return 2 end
	if prefix == "Talent" then 		return 3 end
	if prefix == "Achievement" then return 4 end
	if prefix == "Guild" then 		return 5 end
	if prefix == "LFD" then 		return 6 end
	if prefix == "EJ" then 			return 7 end
	if prefix == "Collections" then	return 8 end
end


function SyncUI_InfoBar_OnUpdate(self,elapsed)
	lastUpdate = lastUpdate + elapsed;
	
	-- Status Text
	if lastUpdate > updateInterval then
		UpdateSocialButton()
		UpdateConfigButton()
		UpdateRepBar(SyncUI_ReputationBar)
		UpdateExpBar(SyncUI_ExperienceBar)
		
		UpdateLootButton()
		UpdateInfoButton(SyncUI_InfoToolButton)

		lastUpdate = 0.00
	end
end

function SyncUI_SideBarConfigFrame_OnInit(self)
	for i = 1, 4 do
		local button = _G[self:GetName().."Button"..i]
		local text = _G[button:GetName().."Text"]
		
		button:SetScript("OnClick", function()
			PlaySound("igMainMenuOptionCheckBoxOn")
			RegisterSideBarDriver(button:GetID())
			SyncUI_SideBar.config = button:GetID()
			SyncUI_FadeOut(self,0.2)
		end)
		
		if i == 1 then
			text:SetText("Disable Switch")
		else
			text:SetText("Switch to bar "..button:GetID())
		end
	end
end

function SyncUI_RaidToolFrame_OnInit(self)
	for i = 1, 4 do
		local button = _G[self:GetName().."Button"..i]
		local text = _G[button:GetName().."Text"]
		
		if i == 1 then
			text:SetText("Raid Compilation")
			button:SetScript("OnClick", function()
				PlaySound("igMainMenuOptionCheckBoxOn");
				ToggleFriendsFrame(4)
				SyncUI_FadeOut(self,0.2)
			end)
		end
		if i == 2 then
			text:SetText("Raid Lockouts")
			button:SetScript("OnClick", function()
				PlaySound("igMainMenuOptionCheckBoxOn")
				if not SyncUI_GameMenu:IsShown() then
					if SyncUI_RaidInfoFrame:IsShown() then
						SyncUI_FadeOut(SyncUI_RaidInfoFrame,0.2)
					else
						SyncUI_FadeIn(SyncUI_RaidInfoFrame,0.2)
					end
				end
				SyncUI_FadeOut(self,0.2)
			end)
		end
		if i == 3 then
			text:SetText("World Marks")
			button:SetScript("OnClick", function()
				SyncUI_ToggleWorldMarkerFrame()
				PlaySound("igMainMenuOptionCheckBoxOn");
				SyncUI_FadeOut(self,0.2)
			end)
		end
		if i == 4 then
			text:SetText("Ready Check")
			button:SetScript("OnClick", function()
				PlaySound("igMainMenuOptionCheckBoxOn");
				DoReadyCheck()
				SyncUI_FadeOut(self,0.2)
			end)
		end
	end
	
	RaidInfoFrame:SetParent(self:GetParent())
	RaidInfoFrame:ClearAllPoints()
	RaidInfoFrame:SetPoint("CENTER",UIParent)
	tinsert(UISpecialFrames,"RaidInfoFrame");
	--FriendsFrameTab4:Hide()
end

function SyncUI_LootSpecFrame_OnInit(self)
	for i = 1, 4 do
		local button = _G[self:GetName().."Button"..i]
		local buttonID = button:GetID()
		local text = _G[button:GetName().."Text"]
		
		if i == 1 then
			text:SetText("Current Spec")
			button:SetScript("OnClick", function() PlaySound("igMainMenuOptionCheckBoxOn"); SetLootSpecialization(0); SyncUI_FadeOut(self,0.2) end)
		else
			local id, name = GetSpecializationInfo(buttonID)
			text:SetText(name)
			button:SetScript("OnClick", function() PlaySound("igMainMenuOptionCheckBoxOn"); SetLootSpecialization(id); SyncUI_FadeOut(self,0.2) end)
		end
	end
end

function SyncUI_InfoToolFrame_OnInit(self)
	for i = 1, 4 do
		local button = _G[self:GetName().."Button"..i]
		local text = _G[button:GetName().."Text"]
		
		button:SetScript("OnClick", function() PlaySound("igMainMenuOptionCheckBoxOn"); SyncUI_InfoToolButton.select = i; SyncUI_FadeOut(self,0.2) end)
		
		if i == 1 then
			text:SetText("Latency")
		end
		if i == 2 then
			text:SetText("Memory")
		end
		if i == 3 then
			text:SetText("FPS")
		end
		if i == 4 then
			text:SetText("Durability")
		end
	end
end

function SyncUI_MicroMenuBar_OnLoad(self)
	for prefix, info in pairs(MicroButtons) do
		local button = _G[prefix.."MicroButton"]
		local index = GetMicroButtonIndex(prefix)
		button:SetParent(self)
		button:SetSize(32,32)
		button:SetHitRectInsets(3,3,3,3)
		button:ClearAllPoints()
		button:SetPoint("LEFT",self,0+(26*(index-1)),0)
		
		local normal, pushed = info[1], info[2]
		button:SetNormalTexture(normal)
		button:SetPushedTexture(pushed)
		button:SetHighlightTexture("")
		button:SetDisabledTexture(normal)
	end
	
	SyncUI_DisableFrame("TalentMicroButton")
	SyncUI_DisableFrame("QuestLogMicroButton")
	SyncUI_DisableFrame("StoreMicroButton")
	SyncUI_DisableFrame("HelpMicroButton")
	SyncUI_DisableFrame("MainMenuMicroButton")
	SyncUI_DisableFrame("TalentMicroButtonAlert")
	SyncUI_DisableFrame("GuildMicroButtonTabard")
end

function SyncUI_ExperienceBar_OnEnter(self)
	local currXP, maxXP = UnitXP("player"), UnitXPMax("player")
	local _, name, multiply = GetRestState()
	local expState = format(EXHAUST_TOOLTIP1, name, multiply*100)

	GameTooltip:SetOwner(self, "ANCHOR_TOP",0,0)
	GameTooltip:AddDoubleLine("Exp","|cFFFFFFFF"..currXP.." / "..maxXP)
	GameTooltip:AddDoubleLine(" "," ")
	GameTooltip:AddLine(expState)
	GameTooltip:Show()
end

function SyncUI_ReputationBar_OnEnter(self)
	GameTooltip:SetOwner(self, "ANCHOR_TOP",0,0)
	if GetWatchedFactionInfo() then
		local faction, level, minRep,maxRep,value = GetWatchedFactionInfo()
		local repLvL = getglobal("FACTION_STANDING_LABEL"..level)
		local curRep, realMaxRep = value - minRep, maxRep - minRep
		
		GameTooltip:AddLine(faction)

		if value >= 0 then
			GameTooltip:AddDoubleLine("|cFF00FF00"..repLvL, "|cFFFFFFFF"..curRep.." / "..realMaxRep)
		else
			GameTooltip:AddDoubleLine("|cFFFF0000"..repLvL, "|cFFFFFFFF"..curRep.." / "..realMaxRep)
		end
	end
	GameTooltip:AddLine("Click ".."|cFFFFFFFF".."to open reputation list")
	GameTooltip:Show()
end

function SyncUI_InfoToolButton_OnEnter(self)
	if self.select == 2 then	--AddOn Memory
		GameTooltip_SetDefaultAnchor(GameTooltip, UIParent)
		GameTooltip:AddLine("AddOn Memory")
		GameTooltip:AddLine(" ")

		AddOnMemory = {}

		for i = 1, GetNumAddOns(), 1 do
			if IsAddOnLoaded(i) then
				local memory = GetAddOnMemoryUsage(i)
				local name = GetAddOnInfo(i)

				tinsert(AddOnMemory,{name,memory})
			end
		end

		table.sort(AddOnMemory, function(a,b) return a[2] > b[2] end)

		for i = 1, #AddOnMemory do
			local name, memory, suffix = AddOnMemory[i][1],AddOnMemory[i][2]
		
			if memory < 1000 then
				memory = tostring("|cff00FF00"..string.format("%.0f",memory).."|r")
				suffix = " KB"
			else
				memory = tostring("|cff00FF00"..string.format("%.2f",memory/1000).."|r")
				suffix = " MB"
			end

			GameTooltip:AddLine(memory..suffix.." - "..name,1,1,1)
		end

		GameTooltip:Show()
	end

	if self.select == 4 then	-- Inventory Durability
		GameTooltip_SetDefaultAnchor(GameTooltip, UIParent)
		GameTooltip:AddLine("Durability")
		GameTooltip:AddLine(" ")
		
		for slot, type in pairs(slots) do
			local dur, maxDur = GetInventoryItemDurability(slot)
			local perc;
			
			if dur then
				perc = math.floor(dur*100/maxDur)
			end
			
			if perc then
				if perc >= 70 then
					perc = tostring("|cff00FF00"..perc.."%|r")
				elseif perc >= 30 then
					perc = tostring("|cffFFFF00"..perc.."%|r")
				else
					perc = tostring("|cffFF0000"..perc.."%|r")
				end
				
				GameTooltip:AddLine(perc.." - "..type,1,1,1)
			end
		end
		
		GameTooltip:Show()
	end
end