--[[	reskinning the tooltip

------------------]]

local fontSmall = SyncUI_GameFontShadow_Small
local fontMedium = SyncUI_GameFontShadow_Medium
local fontLarge = SyncUI_GameFontShadow_Large

local dummy = function() end

local backdrop = {
	edgeFile = "Interface\\AddOns\\SyncUI\\Media\\Textures\\UI-Mods\\Tooltip\\Tooltip_Edge",
	edgeSize = 16
}

local tips = {
	GameTooltip,
	ItemRefTooltip,
	ShoppingTooltip1,
	ShoppingTooltip2,
	ShoppingTooltip3,
	WorldMapTooltip,
	GarrisonFollowerTooltip,
	GarrisonFollowerAbilityTooltip,
	GarrisonMissionMechanicFollowerCounterTooltip,
}

local function SetIcon(self,spellID,isItem)
	local icon;
	if isItem then
		icon = select(10, GetItemInfo(spellID))
	else
		icon = select(3, GetSpellInfo(spellID))
	end

	self.icon:Show()
	self.tex:SetTexture(icon)
end

local function OverwriteBackdrop(tooltip)
	tooltip:SetBackdrop(backdrop)
	tooltip.SetBackdrop = dummy
	tooltip:SetBackdropColor(0,0,0,0)
	tooltip.SetBackdropColor = dummy
	
		-- kill TooltipBorderedFrameTemplate
	if tooltip.BorderTop then
		tooltip.BorderTopLeft:Hide()
		tooltip.BorderTopRight:Hide()
		tooltip.BorderBottomLeft:Hide()
		tooltip.BorderBottomRight:Hide()
		tooltip.BorderTop:Hide()
		tooltip.BorderLeft:Hide()
		tooltip.BorderRight:Hide()
		tooltip.BorderBottom:Hide()
		tooltip.Background:Hide()
	end
	
	-- create backdrop background (counter worldframe tooltip bugs)
	if not tooltip.bgFile then
		tooltip.bgFile = tooltip:CreateTexture(nil,"BACKGROUND")
		tooltip.bgFile:SetTexture("Interface\\AddOns\\SyncUI\\Media\\Textures\\UI-Mods\\Tooltip\\Tooltip_Background")
		tooltip.bgFile:SetPoint("TOPLEFT",4,-4)
		tooltip.bgFile:SetPoint("BOTTOMRIGHT",-4,4)
	end
end

function SyncUI_Tooltip_OnLoad()
	for _, tooltip in pairs(tips) do
		OverwriteBackdrop(tooltip)
	end
	
	GameTooltip.icon = CreateFrame("Frame",nil,GameTooltip)
	GameTooltip.icon:SetSize(40,40)
	GameTooltip.icon:SetPoint("TOPRIGHT",GameTooltip,"TOPLEFT",4,0)
	GameTooltip.icon:SetBackdrop(backdrop)
	GameTooltip.icon:SetBackdropColor(1,1,1,0)
	GameTooltip.icon:Hide()
	
	GameTooltip.tex = GameTooltip.icon:CreateTexture(nil,"BACKGROUND")
	GameTooltip.tex:SetTexCoord(0.05,0.95,0.05,0.95)
	GameTooltip.tex:SetSize(31,31)
	GameTooltip.tex:SetPoint("CENTER")
	
	GameTooltipStatusBar:ClearAllPoints()
	GameTooltipStatusBar:SetPoint("TOPLEFT",15,12)
	GameTooltipStatusBar:SetPoint("TOPRIGHT",-15,12)
	GameTooltipStatusBar:SetHeight(10)
	GameTooltipStatusBar:SetStatusBarTexture("Interface\\AddOns\\SyncUI\\Media\\Textures\\Elements\\Statusbar\\Statusbar_Fill2")

	GameTooltipStatusBar.leftBorder = GameTooltipStatusBar:CreateTexture(nil,"OVERLAY")
	GameTooltipStatusBar.leftBorder:SetSize(20,40)
	GameTooltipStatusBar.leftBorder:SetPoint("LEFT",GameTooltipStatusBar,-5,-1)
	GameTooltipStatusBar.leftBorder:SetTexture("Interface\\AddOns\\SyncUI\\Media\\Textures\\UI-Mods\\Tooltip\\Tooltip_StatusBar_Edge")
	GameTooltipStatusBar.leftBorder:SetTexCoord(0,0.5,0,1)
	
	GameTooltipStatusBar.rightBorder = GameTooltipStatusBar:CreateTexture(nil,"OVERLAY")
	GameTooltipStatusBar.rightBorder:SetSize(20,40)
	GameTooltipStatusBar.rightBorder:SetPoint("RIGHT",GameTooltipStatusBar,6,-1)
	GameTooltipStatusBar.rightBorder:SetTexture("Interface\\AddOns\\SyncUI\\Media\\Textures\\UI-Mods\\Tooltip\\Tooltip_StatusBar_Edge")
	GameTooltipStatusBar.rightBorder:SetTexCoord(0.5,1,0,1)
	
	GameTooltipStatusBar.border = GameTooltipStatusBar:CreateTexture(nil,"OVERLAY")
	GameTooltipStatusBar.border:SetPoint("TOPLEFT",GameTooltipStatusBar.leftBorder,20,0)
	GameTooltipStatusBar.border:SetPoint("BOTTOMRIGHT",GameTooltipStatusBar.rightBorder,-20,0)
	GameTooltipStatusBar.border:SetTexture("Interface\\AddOns\\SyncUI\\Media\\Textures\\UI-Mods\\Tooltip\\Tooltip_StatusBar_Edge")
	GameTooltipStatusBar.border:SetTexCoord(0.4,0.6,0,1)
	
	GameTooltipStatusBar.bg = GameTooltipStatusBar:CreateTexture(nil,"BACKGROUND")
	GameTooltipStatusBar.bg:SetAllPoints(GameTooltipStatusBar)
	GameTooltipStatusBar.bg:SetTexture("Interface\\AddOns\\SyncUI\\Media\\Textures\\Elements\\Statusbar\\Statusbar_Background")

	GameTooltip.arrow = GameTooltip:CreateTexture(nil,"BACKGROUND")
	GameTooltip.arrow:SetDrawLayer("BACKGROUND", 2)
	GameTooltip.arrow:SetSize(48,24)
	GameTooltip.arrow:SetPoint("TOP",GameTooltip,"BOTTOM",0,6)
	GameTooltip.arrow:SetTexture("Interface\\AddOns\\SyncUI\\Media\\Textures\\UI-Mods\\Tooltip\\Tooltip_Arrow")
	GameTooltip.arrow:Hide()

	-- Change Font
	GameTooltipHeaderText:SetFontObject(fontMedium)
	GameTooltipText:SetFontObject(fontMedium)
	Tooltip_Small:SetFontObject(fontSmall)
	SmallTextTooltipText:SetFontObject(fontMedium)
end
	
-- Hooks
FriendsTooltip:HookScript("OnShow", function(self)
	local fonts = {"Header","OtherToons","NoteText","BroadcastText","LastOnline","ToonMany","Toon1Name","Toon1Info","Toon2Name","Toon2Info","Toon3Name","Toon3Info","Toon4Name","Toon4Info","Toon5Name","Toon5Info"}

	OverwriteBackdrop(self)
	
	for _, font in pairs(fonts) do
		_G[self:GetName()..font]:SetFontObject(fontMedium)
	end
end)
GameTooltip:HookScript("OnTooltipSetSpell", function(self)
	local spellID = select(3, self:GetSpell())
	if spellID then
		local owner = self:GetOwner()
		if not owner.isTalent then
			SetIcon(self,spellID)
		end
	end
end)
GameTooltip:HookScript("OnTooltipSetItem", function(self)
	local spellID = select(2, self:GetItem())
	if spellID then
		SetIcon(self,spellID,true)
	end
end)
GameTooltip:HookScript("OnTooltipSetUnit", function(self)
	local unit = GameTooltip:GetUnit()
	local unitID = "mouseover"
	
	if UnitName(unitID) == unit and UnitIsPlayer(unitID) then
		local color = SYNCUI_CLASS_COLORS[select(2, UnitClass(unitID))]
		local r,g,b = color.r, color.g, color.b
		
		GameTooltipStatusBar:SetStatusBarColor(r,g,b)
	end
end)
hooksecurefunc("GameTooltip_SetDefaultAnchor", function(tooltip, parent)
	if cursor and GetMouseFocus() == WorldFrame then
		tooltip:SetOwner(parent, "ANCHOR_CURSOR")
	else
		tooltip:SetOwner(parent, "ANCHOR_NONE")
		tooltip:SetPoint("BOTTOMRIGHT","UIParent","BOTTOMRIGHT",-10,110)
		tooltip.default = 1
	end
end)
hooksecurefunc("GameTooltip_OnHide", function(self)
	if self.icon then self.icon:Hide() end
	if self.arrow then self.arrow:Hide() end
end)
hooksecurefunc("SetTooltipMoney", function(self)
	if not self.shownMoneyFrames then return end
	
	local moneyFrame;
	for i = 1, self.shownMoneyFrames do
		moneyFrame = _G[self:GetName().."MoneyFrame"..i]
		if moneyFrame then
			local name = moneyFrame:GetName()
			local prefix, suffix, gBtn, sBtn, cBtn = _G[name.."PrefixText"], _G[name.."SuffixText"], _G[name.."GoldButtonText"], _G[name.."SilverButtonText"], _G[name.."CopperButtonText"]
			
			for _, frame in pairs({prefix,suffix,gBtn,sBtn,cBtn}) do
				frame:SetFontObject(fontMedium)
			end
		end
	end
end)
hooksecurefunc("ToggleDropDownMenu", function(level)
	if not level then level = 1 end
	local menu = _G["DropDownList"..level]
	local bgDrop = _G[menu:GetName().."MenuBackdrop"]

	OverwriteBackdrop(bgDrop)
	
	for index = 1, menu.numButtons do
		local button = _G[menu:GetName().."Button"..index]
		local arrow = _G[button:GetName().."ExpandArrow"]
		local icon = _G[button:GetName().."Icon"]
		local yPos = select(5, button:GetPoint())
		
		button:SetNormalFontObject(fontMedium)
		button:SetHighlightFontObject(fontMedium)
		button:SetDisabledFontObject(fontMedium)
		arrow:SetPoint("TOPRIGHT",menu,-9,yPos)
		icon:SetPoint("TOPRIGHT",menu,-11,yPos)
	end
end)

-- Garrison Hook
LoadAddOn("Blizzard_GarrisonUI")
hooksecurefunc("GarrisonMissionMechanicFollowerCounter_OnEnter", function(self)
	local tooltip = GarrisonMissionMechanicFollowerCounterTooltip
	
	OverwriteBackdrop(tooltip)
end)