--[[	handler functions for the cast history bar

------------------]]

local maxCastHistorySpells = 5
local fadeOutStep = 0.01
local fadeOutTimer = 4
local _G = _G

local function GetUnitID(self)
	local name = self:GetName()
	local ID = self:GetID()
	
	if strfind(name,"Player") then
		return "player"
	elseif strfind(name,"Target") then
		return "target"
	elseif strfind(name,"Focus") then
		return "focus"
	elseif strfind(name,"Party") then
		return "party"..ID		
	elseif strfind(name,"Raid") then
		return "raid"..ID
	elseif strfind(name,"Boss") then
		return "boss"..ID
	end
end

function SyncUI_CastHistoryBar_OnLoad(self)
	local unitID = GetUnitID(self:GetParent())
	
	self:RegisterUnitEvent("UNIT_SPELLCAST_START",unitID)
	self:RegisterUnitEvent("UNIT_SPELLCAST_STOP",unitID)
	self:RegisterUnitEvent("UNIT_SPELLCAST_CHANNEL_START",unitID)
	self:RegisterUnitEvent("UNIT_SPELLCAST_SUCCEEDED",unitID)
	self:RegisterUnitEvent("UNIT_SPELLCAST_CHANNEL_STOP",unitID)
	self:RegisterUnitEvent("UNIT_SPELLCAST_CHANNEL_UPDATE",unitID)
	
	SyncUI_Flashing_OnInit(_G[self:GetName().."Spell1"],0.35,0.35,-1)
end

function SyncUI_CastHistoryBar_OnEvent(self,event,...)
	
	if event == "UNIT_SPELLCAST_START" or event == "UNIT_SPELLCAST_CHANNEL_START" then
		local icon = select(3, GetSpellInfo(select(5, ...)))
		local i = maxCastHistorySpells		
		repeat
			local spell = _G[self:GetName().."Spell"..i]
			local prevSpell = _G[self:GetName().."Spell"..i-1]
			
			if prevSpell then
				spell.icon:SetTexture(prevSpell.icon:GetTexture())
				spell.iconOverlay:SetTexture(prevSpell.iconOverlay:GetTexture())
				spell.fadeTimer = prevSpell.fadeTimer
				spell:SetAlpha(prevSpell:GetAlpha())
				i = i - 1
			end
		until i == 1
		
		local spell = _G[self:GetName().."Spell1"]
		spell.icon:SetTexture(icon)
		spell.iconOverlay:SetTexture()
		spell.fadeTimer = fadeOutTimer / 2
		spell:SetAlpha(1)
		
		self.isCasting = true
	end

	if event == "UNIT_SPELLCAST_CHANNEL_START" or event == "UNIT_SPELLCAST_CHANNEL_UPDATE" then
		local startTime = select(5, UnitChannelInfo(select(1,...)))
		local endTime = select(6, UnitChannelInfo(select(1,...)))

		self.channelDuration = (endTime - startTime) / 1000
		self.isChanneling = true
	end
	
	if event == "UNIT_SPELLCAST_SUCCEEDED" then
		local unitID = select(1, ...)
		local spellName = select(2, ...)
		local spellID = select(5, ...)
		
		-- prevent triggering for spells not in your spellbook (i.e. clicking portals)
		if not IsUsableSpell(spellName) and not select(2, GetSpellBookItemInfo(spellName)) then return end
		
		if unitID == "player" then
			-- Fix double determine for spells that were interrupted
			-- shortly before succeeding and also succeeded!
			local fixSpell = _G[self:GetName().."Spell1"]
			if fixSpell.lineID and fixSpell.lineID == select(4, ...) then
				fixSpell.iconOverlay:SetTexture()
				fixSpell.lineID = nil
				return
			end
			
			-- spell without casttime (instant-spell)
			if not self.isCasting then
				local icon = select(3, GetSpellInfo(select(5, ...)))
				local i = maxCastHistorySpells		
				repeat
					local spell = _G[self:GetName().."Spell"..i]			
					local prevSpell = _G[self:GetName().."Spell"..i-1]			
					if prevSpell then
						spell.icon:SetTexture(prevSpell.icon:GetTexture())
						spell.iconOverlay:SetTexture(prevSpell.iconOverlay:GetTexture())
						spell.fadeTimer = prevSpell.fadeTimer
						spell:SetAlpha(prevSpell:GetAlpha())
						i = i - 1
					end
				until i == 1

				local spell = _G[self:GetName().."Spell1"]
				spell.icon:SetTexture(icon)
				spell.iconOverlay:SetTexture()		
				spell.fadeTimer = fadeOutTimer / 2
				spell:SetAlpha(1)
			end

			-- spell with casttime
			if self.isCasting then
				_G[self:GetName().."Spell1"]:SetAlpha(1)
			end

			self.isCasting = nil
		end
	end
	
	if event == "UNIT_SPELLCAST_STOP" then
		if self.isCasting then
			local spell = _G[self:GetName().."Spell1"]
			spell.iconOverlay:SetTexture("Interface\\RAIDFRAME\\ReadyCheck-NotReady")
			spell.lineID = select(4, ...)
			spell:SetAlpha(1)
			
			self.isCasting = nil
			self.isChanneling = nil
		end
	end

	if event == "UNIT_SPELLCAST_CHANNEL_STOP" then
		local spell = _G[self:GetName().."Spell1"]

		-- Total "Zero" would be a bad choice here, because "elapsed" is not accurate enough
		-- One half of the finished channels determines below "0" and the other half between "0.01" - "0.08"
		if self.channelDuration > 0.1 then	
			spell.iconOverlay:SetTexture("Interface\\RAIDFRAME\\ReadyCheck-NotReady")
			spell.lineID = select(4, ...)
			spell:SetAlpha(1)
			
			self.isCasting = nil
			self.isChanneling = nil
			self.channelDuration = nil
		else
			spell:SetAlpha(1)
			
			self.isChanneling = nil
			self.channelDuration = nil
		end
	end

end

function SyncUI_CastHistoryBar_OnUpdate(self,elapsed)

	-- flashing first spell while casting
	local spell = _G[self:GetName().."Spell1"]
	if self.isCasting or self.isChanneling then
		SyncUI_Flashing_OnUpdate(spell,elapsed)
	end

	-- fadeOut
	for i = 1, maxCastHistorySpells do
		if ( i == 1 and not self.isCasting and not self.isChanneling ) or ( i > 1 ) then
			local spell = _G[self:GetName().."Spell"..i]
			if spell.fadeTimer then
				spell.fadeTimer = spell.fadeTimer - elapsed
				
				if spell.fadeTimer <= 0 then
					local alpha = spell:GetAlpha() - fadeOutStep
					if alpha > 0 then
						spell:SetAlpha(alpha)
					else
						spell:SetAlpha(0)
						spell.fadeTimer = nil
					end
				end
			end
		end
	end

	-- Fix for event: "UNIT_SPELLCAST_CHANNEL_STOP" to determine
	-- if channeled spell was fully casted or interrupted
	if self.isChanneling and self.channelDuration then
		if self.channelDuration > 0 then
			self.channelDuration = self.channelDuration - elapsed
		elseif self.channelDuration <= 0 then
			self.channelDuration = 0
		end
	end
end


-- currently not in use
local function GetSpellBookInfo(spellID)
	local info;
	local i = 1
	while true do
		local spellName, spellSubName = GetSpellBookItemName(i, BOOKTYPE_SPELL)
		if spellName then
			if select(1, GetSpellInfo(spellID)) == spellName then
				info = true
			end
			
			i = i + 1
		end
	end
	
	print("true")
	return info
end

local function GetUnauthorizedSpell(self,event,...)
	local foundMountID;
	local spellName = select(2, ...)
	for index = 1, GetNumCompanions("MOUNT") do 
		local mountSpellID = select(3, GetCompanionInfo("MOUNT",index))
		if mountSpellID == select(5, ...) then
			foundMountID = true
			break
		end
	end
	
	if not foundMountID and not GetSpellBookItemInfo(spellName) then
		--print(spellName)
		return true
	end
end
