--[[	handler functions for the world marker window

------------------]]

local WorldMarkers = {
	[1] = {"square",0,0.5,1},
	[2] = {"Triangle",0,1,0},
	[3] = {"Diamond",1,0,1},
	[4] = {"Cross",1,0,0},
	[5] = {"Star",1,1,0},
	[6] = {"Circle",1,0.5,0},
	[7] = {"Moon",0.5,1,1},
	[8] = {"Skull",1,1,1},
	[0] = {"Clear",1,1,1},
}

local function GetWorldMarkerType(index)
	return WorldMarkers[index][1], WorldMarkers[index][2], WorldMarkers[index][3], WorldMarkers[index][4]
end

function SyncUI_ToggleWorldMarkerFrame()
	if InCombatLockdown() then return end
	local frame = SyncUI_WorldMarkerFrame
	if frame:IsShown() then
		frame:Hide()
	else
		frame:Show()
	end
end

function SyncUI_WorldMarkerButton_OnLoad(self)
	local index = self:GetID()
	local text,r,g,b,a = GetWorldMarkerType(index)
	self:RegisterForClicks("AnyUp")
	self:SetAttribute("type", "macro")
	
	if index == 0 then
		self.text:SetText("Clear All")
		self:SetAttribute("macrotext1", "/cwm 0")
	else
		self.text:SetText(text)
		self.text:SetVertexColor(r,g,b)
		self:SetAttribute("macrotext1", string.format("/wm %d",index))
	end
end

function SyncUI_RaidControlFrame_OnLoad(self)
	for i = 1, 4 do
		local button = _G[self:GetName().."Button"..i]
		local text = _G[button:GetName().."Text"]
		
		if i == 1 then
			text:SetText("Raid Compilation")
			button:SetScript("OnClick", function()
				PlaySound("igMainMenuOptionCheckBoxOn");
				ToggleFriendsFrame(4)
				SyncUI_FadeOut(self,0.2)
			end)
		end
		if i == 2 then
			text:SetText("Raid Lockouts")
			button:SetScript("OnClick", function()
				PlaySound("igMainMenuOptionCheckBoxOn")
				if not SyncUI_OptionsMenu:IsShown() then
					if SyncUI_RaidInfoFrame:IsShown() then
						SyncUI_FadeOut(SyncUI_RaidInfoFrame,0.2)
					else
						SyncUI_FadeIn(SyncUI_RaidInfoFrame,0.2)
					end
				end
				SyncUI_FadeOut(self,0.2)
			end)
		end
		if i == 3 then
			text:SetText("World Marks")
			button:SetScript("OnClick", function()
				SyncUI_ToggleWorldMarkerFrame()
				PlaySound("igMainMenuOptionCheckBoxOn");
				SyncUI_FadeOut(self,0.2)
			end)
		end
		if i == 4 then
			text:SetText("Ready Check")
			button:SetScript("OnClick", function()
				PlaySound("igMainMenuOptionCheckBoxOn");
				DoReadyCheck()
				SyncUI_FadeOut(self,0.2)
			end)
		end
	end
	
	RaidInfoFrame:SetParent(self:GetParent())
	RaidInfoFrame:ClearAllPoints()
	RaidInfoFrame:SetPoint("CENTER",UIParent)
	tinsert(UISpecialFrames,"RaidInfoFrame");
	--FriendsFrameTab4:Hide()
end

--[[ Shift World Clicking to Toggle 
WorldFrame:HookScript("OnMouseDown", function(self, button)
	if button == "RightButton" and IsShiftKeyDown() and not UnitExists("mouseover") then
		SyncUI_ToggleWorldMarkerFrame()
	end
end)
--]]
