--[[	handler functions for exhaust/drowning bars

------------------]]

local _G = _G

function SyncUI_EnvironmentBar_OnLoad(self)
	self.Title = self.ArtFrame.Title
	
	local frame = _G["MirrorTimer"..self:GetID()]
	
	frame:SetAlpha(0)
	frame:EnableMouse(false)
	frame:HookScript("OnShow", function() SyncUI_EnvironmentBar_OnShow(self) end)
	frame:HookScript("OnHide", function() self:Hide() end)
end

function SyncUI_EnvironmentBar_OnShow(self)
	local text = _G["MirrorTimer"..self:GetID().."Text"]:GetText()
	local timer = _G["MirrorTimer"..self:GetID()].timer
	local color = MirrorTimerColors[timer]
	
	self.StatusBar:SetStatusBarColor(color.r,color.g,color.b)
	self.Title:SetText(text)
	
	self:Show()
end

function SyncUI_EnvironmentBar_OnUpdate(self)
	local bar = _G["MirrorTimer"..self:GetID().."StatusBar"]
	
	self.StatusBar:SetMinMaxValues(bar:GetMinMaxValues())
	self.StatusBar:SetValue(bar:GetValue())
end
