
local tinsert, tremove = table.insert, table.remove

function SyncUI_OptionPanelFrame_HidePanels()
	local children = {SyncUI_OptionPanelFrame:GetChildren()}
	
	for _, child in pairs(children) do
		child:Hide()
	end
end

-- Aura Panel --
local function SortWeakAuras(a,b)
	local aName = GetSpellInfo(a)
	local bName = GetSpellInfo(b)
	
	if aName and bName then
		return aName < bName
	end
end

local function LoadDefaultWeakAuraList()
	SyncUI_CharData["WeakAuras"] = {}
	--[[	
	local index = 0

	for k in pairs(PlayerAura_SpellIDs) do
		index = index + 1
		SyncUI_CharData["WeakAuras"][index] = k
	end
	--]]
end

function SyncUI_OptionPanel_ReactiveAura_OnShow(self)
	if not SyncUI_CharData["WeakAuras"] then
		LoadDefaultWeakAuraList()
	end

	table.sort(SyncUI_CharData["WeakAuras"],SortWeakAuras)
	
	self.ScrollFrame.ScrollBar:SetValue(0)
	SyncUI_OptionPanel_ReactiveAura_UpdateScrollFrame(self.ScrollFrame)
end

function SyncUI_OptionPanel_ReactiveAura_AuraButton_OnClick(self,button)
	if button == "RightButton" and IsShiftKeyDown() then
		local spellID = SyncUI_CharData["WeakAuras"][self:GetID()]
		local scrollFrame = self:GetParent().ScrollFrame
		
		-- Remove Aura
		tremove(SyncUI_CharData["WeakAuras"], self:GetID())
		
		-- Update Scroll Frame
		scrollFrame.ScrollBar:SetValue(0)
		SyncUI_OptionPanel_ReactiveAura_UpdateScrollFrame(scrollFrame)
		
		-- Print out
		if spellID then
			local name, _, icon = GetSpellInfo(spellID)
			
			if name and icon then
				print("|T"..icon..":20:20:0:0:64:64:5:59:5:59|t",name.." - has been removed!")
			end
		end
	end
end

function SyncUI_OptionPanel_ReactiveAura_AuraButton_Update(self)
	if not SyncUI_CharData["WeakAuras"][self:GetID()] then self:Hide() return end

	local spellID = SyncUI_CharData["WeakAuras"][self:GetID()]
	local name = select(1, GetSpellInfo(spellID))
	local icon = select(3, GetSpellInfo(spellID))

	if name then
		self.Icon:SetTexture(icon)
		self.Name:SetText(name)
	end
	
	if not self:IsShown() then self:Show() end
end

function SyncUI_OptionPanel_ReactiveAura_UpdateScrollFrame(self)
	local offset = FauxScrollFrame_GetOffset(self)
	local maxButtons = 7
	local size = #SyncUI_CharData["WeakAuras"]
	
	FauxScrollFrame_Update(self, size, maxButtons, 20)
	
	for i = 1, maxButtons do
		local button = _G["SyncUI_OptionPanel_ReactiveAura_Button"..i]
		local idx = offset + i

		button:SetID(idx)
		
		SyncUI_OptionPanel_ReactiveAura_AuraButton_Update(button)
	end
end

function SyncUI_OptionPanel_ReactiveAura_ApplyAura(self)
	local editBox = self:GetParent().Enter
	local text = editBox:GetText()
	local spellID = gsub(text,"%a+","")
	
	if spellID then
		local name, _, icon = GetSpellInfo(spellID)
		
		for _, spell in pairs(SyncUI_CharData["WeakAuras"]) do
			if spell == spellID then
				editBox:SetText("")

				return print("|T"..icon..":20:20:0:0:64:64:5:59:5:59|t",name.." - is already in the database!")
			end
		end

		if name then
			local scrollFrame = self:GetParent():GetParent().ScrollFrame

			-- Add Aura
			tinsert(SyncUI_CharData["WeakAuras"],spellID)
			
			-- Sort Table
			table.sort(SyncUI_CharData["WeakAuras"],SortWeakAuras)
			
			-- Update Scroll Frame
			scrollFrame.ScrollBar:SetValue(0)
			SyncUI_OptionPanel_ReactiveAura_UpdateScrollFrame(scrollFrame)
			
			-- Clear EditBox
			editBox:SetText("")
			
			-- Print
			print("|T"..icon..":20:20:0:0:64:64:5:59:5:59|t",name.." - has been added!")
		else
			if spellID == "" then
				print("Enter a spellID to add an aura!")
			else
				print("|cFF00FF99"..spellID.."|cFFFFFFFF - is no valid spellID!")
			end
		end
	end
end