--[[	reskinning the quest tracker

------------------]]

local font = SyncUI_GameFontShadow_Medium

local function QuestHub_Initialize()
	-- Position
	local tracker = ObjectiveTrackerFrame
	tracker:ClearAllPoints()
	tracker:SetParent(SyncUI_QuestHub)
	tracker:SetPoint("TOPRIGHT",0,0)
	tracker:SetHeight(SyncUI_QuestHub:GetHeight())
	tracker.ClearAllPoints = function() end
	tracker.SetPoint = function() end
	tracker.HeaderMenu.MinimizeButton:SetPoint("TOPRIGHT",tracker,"TOPRIGHT",-1,-3)
	tracker.HeaderMenu.Title:SetFontObject(font)
	tracker.HeaderMenu.Title:SetShadowColor(0, 0, 0, true and 1 or 0)
	
	hooksecurefunc("ObjectiveTracker_Update", function()
		if tracker.MODULES and #tracker.MODULES > 0 then
			for i = 1, #tracker.MODULES do
				local module = tracker.MODULES[i]
				module.Header.Background:Hide()
				module.Header.Text:SetFontObject(font)

				for _, block in pairs(module.usedBlocks) do
					if block.HeaderText then
						block.HeaderText:SetFontObject(font)
					end
				
					for _, line in pairs(block.lines) do
						line.Text:SetFontObject(font)
						if line.Dash then
							line.Dash:SetText("-")
						end
					end
				end
			end
		end
	end)
end

local function QuestHub_OnVisibleChange()
	local tracker = ObjectiveTrackerFrame
	local instance, type = IsInInstance()
	local state, collapse;

	if instance then
		if type == "pvp" or type == "arena" or type == "party" or type == "raid" then
			state, collapse = true, true
		end
	end

	--if state then tracker:Hide() else tracker:Show() end
	if collapse then ObjectiveTracker_Collapse(tracker) else ObjectiveTracker_Expand(tracker) end
end

function SyncUI_QuestHub_OnEvent(self,event,...)
	QuestHub_Initialize()
	QuestHub_OnVisibleChange()
end

