
local function UpdateContent(self)
	local content = ScenarioObjectiveBlock

	for i, line in pairs({content:GetChildren()}) do
		local frame = _G[self:GetName().."Line"..i]
		local icon = line.Icon
		local text = line.Text
		
		frame.Icon:SetTexture(icon:GetTexture())
		frame.Icon:SetTexCoord(icon:GetTexCoord())
		frame.Icon:SetAtlas(icon:GetAtlas())
		frame.Text:SetText(text:GetText())
	end
end

local function ResetBar(self)
	self.TimeBar:SetMinMaxValues(0,100)
	self.TimeBar:SetValue(100)
	self.Timer:SetText("")
	self.Medal:SetTexture("")
end

function SyncUI_ChallengeMode_OnLoad(self)
	self:SetScale(SyncUI_UIScale)
	
	self:RegisterEvent("CHALLENGE_MODE_START")
	self:RegisterEvent("CHALLENGE_MODE_RESET")
	self:RegisterEvent("CHALLENGE_MODE_COMPLETED")
	self:RegisterEvent("PLAYER_ENTERING_WORLD")
	self:RegisterEvent("ZONE_CHANGED_NEW_AREA")
	self:RegisterForDrag("LeftButton")
	
	self.Medal = self.ArtFrame.Medal
	self.Timer = self.ArtFrame.Timer
end

function SyncUI_ChallengeMode_OnEvent(self,event,...)
	if event == "CHALLENGE_MODE_START" then
		self:SetScript("OnUpdate", SyncUI_ChallengeMode_OnUpdate)
	end
	
	if event == "CHALLENGE_MODE_RESET" or event == "CHALLENGE_MODE_COMPLETED" then
		self:SetScript("OnUpdate", nil)
		ResetBar(self)
	end
	
	if event == "PLAYER_ENTERING_WORLD" or event == "ZONE_CHANGED_NEW_AREA" then
		local name, type, difficulty = GetInstanceInfo()
		
		self.Title:SetText(name)
		
		if  difficulty == 8 then
			local bar = ScenarioChallengeModeBlock.StatusBar
			if bar and bar:GetValue() ~= 0 then
				self:SetScript("OnUpdate", SyncUI_ChallengeMode_OnUpdate)
			end
			
			self:Show()	
			UpdateContent(self)
			SyncUI_QuestHub:Hide()
		else
			self:Hide()
			SyncUI_QuestHub:Show()
		end

	end
end

function SyncUI_ChallengeMode_OnUpdate(self)
	local block = ScenarioChallengeModeBlock
	local bar = block.StatusBar
	local minValue, maxValue, value, medal
	
	if bar then
		minValue, maxValue = bar:GetMinMaxValues()
		value = bar:GetValue()
		medal = block.MedalIcon:GetTexture()
	end
	
	self.TimeBar:SetMinMaxValues(minValue,maxValue)
	self.TimeBar:SetValue(value)
	self.Timer:SetText(GetTimeStringFromSeconds(value))
	self.Medal:SetTexture(medal)

	UpdateContent(self)
end
