--[[	reskin chat & integrate skada to it

------------------]]

local _G = _G
local dummy = function() end
local font = SyncUI_GameFontShadow_Medium
local font2 = SyncUI_GameFontShadow_Small
local path = "Interface\\AddOns\\SyncUI\\Media\\Fonts\\Vibro.ttf"

local TexturesToDisable = {
	"TabLeft",
	"TabMiddle",
	"TabRight",
	"TabSelectedLeft",
	"TabSelectedMiddle",
	"TabSelectedRight",
	"TabHighlightLeft",
	"TabHighlightMiddle",
	"TabHighlightRight",
	"EditBoxLeft",
	"EditBoxMid",
	"EditBoxRight",
	"EditBoxFocusLeft",
	"EditBoxFocusMid",
	"EditBoxFocusRight",
}

local TexturesToHide = {
	"TopLeftTexture",
	"BottomLeftTexture",
	"TopRightTexture",
	"BottomRightTexture",
	"LeftTexture",
	"RightTexture",
	"BottomTexture",
	"TopTexture",
}

local function ChatFrame_OnDisable(chatFrame)
	BNToastFrame:SetClampedToScreen(true)
	BNToastFrame:SetClampRectInsets(-15,15,15,-15)	
	SyncUI_DisableFrame(FriendsMicroButton)
	SyncUI_DisableFrame(ChatFrameMenuButton)
	GeneralDockManager:SetParent(SyncUI_ChatFrame.chat)
	
	-- Hide Textures
	for _, texture in pairs(TexturesToDisable) do
		_G[chatFrame:GetName()..texture]:SetTexture(nil)
	end
	
	for _, texture in pairs(TexturesToHide) do
		_G[chatFrame:GetName()..texture]:Hide()
	end

end

local function ChatFrame_OnInit(chatFrame)
	if InCombatLockdown() then return end

	local tab = _G[chatFrame:GetName().."Tab"]
	tab:SetNormalFontObject(font)

	local btnFrame = _G[chatFrame:GetName().."ButtonFrame"]
	btnFrame.Show = dummy
	btnFrame:Hide()
	
	chatFrame.Background = _G[chatFrame:GetName().."Background"]

	if chatFrame.isDocked then
		chatFrame:SetParent(SyncUI_ChatFrame.chat)
		chatFrame.Background:Hide()
	else
		chatFrame:SetParent(SyncUI_UndockedChatFrame)
	end
	
	if chatFrame:GetID() == 1 then
		tab:RegisterForDrag()
		
		chatFrame:StartMoving()
		chatFrame:SetSize(412,149)
		chatFrame:ClearAllPoints()
		chatFrame:SetPoint("BOTTOMLEFT",SyncUI_ChatFrame,41,23)
		chatFrame:SetClampRectInsets(0, 0, 0, 0)
		chatFrame:SetMaxResize(412, 149)
		chatFrame:SetMinResize(412, 149)
		chatFrame:StopMovingOrSizing()

		chatFrame.editBox:SetFontObject(font)
		chatFrame.editBox:SetParent(SyncUI_ChatFrame.chat)
		chatFrame.editBox:ClearAllPoints()
		chatFrame.editBox:SetPoint("TOPLEFT",chatFrame,"BOTTOMLEFT",-35,-21)
		chatFrame.editBox:SetPoint("RIGHT",chatFrame,35,0)
		chatFrame.editBox:HookScript("OnShow",function() SyncUI_ChatFrame.editBox:Show() end)
		chatFrame.editBox:HookScript("OnHide",function() SyncUI_ChatFrame.editBox:Hide() end)
	end
	
	ChatFrame_OnDisable(chatFrame)
end


function SyncUI_ChatFrame_OnLoad(self)
	self:RegisterEvent("ADDON_LOADED")
	self:RegisterEvent("UI_SCALE_CHANGED")
	
	hooksecurefunc("FCF_OpenTemporaryWindow", function()
		for _, chatFrameName in pairs(CHAT_FRAMES) do
			local frame = _G[chatFrameName]
			if frame.isTemporary then
				ChatFrame_OnInit(frame)
			end
		end
	end)
	
	hooksecurefunc("FCF_SetLocked", function(self)
		if self.isDocked then
			self:SetParent(SyncUI_ChatFrame.chat)
			
			if self.Background then
				self.Background:Hide()
			end
		else
			self:SetParent(SyncUI_UndockedChatFrame)
			
			if self.Background then
				self.Background:Show()
			end
		end
	end)
end

function SyncUI_ChatFrame_OnEvent(self,event,...)
	if event == "ADDON_LOADED" then
		for i = 1, NUM_CHAT_WINDOWS do
			local chatWindow = _G["ChatFrame"..i]
			ChatFrame_OnInit(chatWindow)
		end
	end
	
	if event == "UI_SCALE_CHANGED" then
		ChatFrame1:SetSize(412,149)
		ChatFrame1:ClearAllPoints()
		ChatFrame1:SetPoint("BOTTOMLEFT",SyncUI_ChatFrame,41,23)
		ChatFrame1Tab:ClearAllPoints()
	end
end

function SyncUI_ChatFrame_Skada_OnLoad(self)
	if not Skada then return end

	self:GetParent().chatButton:Show()
	self:GetParent().skadaButton:Show()
		
	hooksecurefunc(Skada, "CreateWindow", function(_,name)
		local window = _G["SkadaBarWindow"..name]
		-- window = win.bargroup
		if window then	
			window:SetParent(self)
			window:SetScript("OnSizeChanged",function(self) self:SetSize(298,110) end)
			window:SetSize(298,110)
			window:ClearAllPoints()
			window:SetPoint("TOPLEFT",SyncUI_ChatFrame,27.5,-13.5)
			window.Hide = dummy
			window:Show()
			
			window.button:EnableMouse(false)
		end
	end)
	hooksecurefunc(Skada, "UpdateDisplay", function(self)
		for _, win in ipairs(self:GetWindows()) do
			local button = win.bargroup.button
			if not button.isStyled then
				button:SetWidth(280)
				button:SetHeight(20)
				button:ClearAllPoints()
				button:SetPoint("TOPLEFT",7,19)
				button:SetNormalFontObject(font2)

				button.SetWidth = dummy
				button.SetWidth = dummy
				button.ClearAllPoints = dummy
				button.SetPoint = dummy
				button.SetNormalFontObject = dummy
				
				button.isStyled = true
			end
			
			for _, bar in pairs(win.bargroup:GetBars()) do
				if not bar.isStyled then
					bar:SetHeight(18)
					bar.label:SetFont(path,8)
					bar.timerLabel:SetFont(path,8)
					
					bar.SetHeight = dummy
					bar.label.SetFont = dummy
					bar.timerLabel.SetFont = dummy
					
					bar.isStyled = true
				end
			end
		end	
	end)
end

