--[[	filter functions for the chat (anti-spam)

------------------]]

local raidIconList = {	
	-- enUS
	"{%a%a%d}",
	"{[Xx]}",
	"{[Ss][Tt][Aa][Rr]}",
	"{[Cc][Ii][Rr][Cc][Ll][Ee]}",
	"{[Dd][Ii][Aa][Mm][Oo][Nn][Dd]}",
	"{[Tt][Rr][Ii][Aa][Nn][Gg][Ll][Ee]}",
	"{[Mm][Oo][Oo][Nn]}",
	"{[Ss][Qq][Uu][Aa][Rr][Ee]}",
	"{[Cc][Rr][Oo][Ss][Ss]}",
	"{[Ss][Kk][Uu][Ll][Ll]}",
	
	-- deDE
	"{Stern}",
	"{Kreis}",
	"{Diamant}",
	"{Dreieck}",
	"{Mond}",
	"{Quadrat}",
	"{Kreuz}",
	"{Totenkopf}",
	
	"{[Ss][Tt][Ee][Rr][Nn]}",
	"{[Kk][Rr][Ee][Ii][Ss]}",
	"{[Dd][Ii][Aa][Mm][Aa][Nn][Tt]}",
	"{[Dd][Rr][Ee][Ii][Ee][Cc][Kk]}",
	"{[Mm][Oo][Nn][Dd]}",
	"{[Vv][Ii][Ee][Rr][Ee][Cc][Kk]}",
	"{[Kk][Rr][Ee][Uu][Zz]}",
	"{[Tt][Oo][Tt][Ee][Nn][Ss][Cc][Hh][]+[Dd][Ee][Ll]}",
	
	-- frFR
	"{[]+[Tt][Oo][Ii][Ll][Ee]}",
	"{[Cc][Ee][Rr][Cc][Ll][Ee]}",
	"{[Ll][Oo][Ss][Aa][Nn][Gg][Ee]}",
	"{[Tt][Rr][Ii][Aa][Nn][Gg][Ll][Ee]}",
	"{[Ll][Uu][Nn][Ee]}",
	"{[Cc][Aa][Rr][Rr][]+}",
	"{[Cc][Rr][Oo][Ii][Xx]}",
	"{[Cc][Rr][]+[Nn][Ee]}",
}

local tradeFilterList = {
	["PvP"] = {
		"2s",
		"2's",
		"2s",
		"2`s",
		"2er",
		"2v2",
		"2vs2",
		"2n2",
		"2o2",
		"2on2",
		"2 on 2",
			
		"3s",
		"3's",
		"3s",
		"3`s",
		"3er",
		"3v3",
		"3vs3",
		"3n3",
		"3o3",
		"3on3",
		"3 on 3",

		"5s",
		"5's",
		"5s",
		"5`s",
		"5er",
		"5v5",
		"5vs5",
		"5n5",
		"5o5",
		"5on5",
		"5 on 5",

		"pvp",
		"arena",
		"m8",
		"mate",
		"cap",
		"bg",
		"rbg",
		"r-bg",
		"r bg",
		"mmr",

		"rmp",
		"lsd",
		"kfc",
		"mls",
		"rls",
		"tsg",
		"wmd",
		"rmd",
		"kittycleave",
		"shadowplay",
	},
	["Trade"] = {
		"buy",
		"kauf",
		"vk",
		"verk",
		"verkauf",
		"sale",
		"wtb",
		"wts",
		"price",
		"preis",
		"trade",
		"tausch",
		"gold",
		"mats",
	},
	["Advertising and Spam"] = {
		"anal",
		"twitch",
		"skype",
		"gamecard",
		"www",
		"http",
		".com",
		".net",
		".org",
	},
	["Misc"] = {
		"monkey",
		"port",
	},
}

local systemFilterList = {
	-- ability
	"You have learned a new ability",
	"You have learned a new spell",
	"You have learned a new passive",
	"You have unlearned",

	-- raid / party
	"You leave the group",	
	"You are no longer rested",
	"You are no longer away",
	"You are no longer listed for",
	"You are now queued in",
	"You are now listed for",
	"You are now saved to this instance",

	"has left the instance group",
	"has left the raid group",	
	"has joined the instance group",	

	"has joined the raid group",
	"Your Instance lock is scheduled to expire in",
	"Someone has declined the invite",	
	
	-- loot
	"was disenchanted for loot by",
	"Looting set to",
	"Looting changed to",
	"Loot threshold set to",
	"Loot Specialization set to:",
	
	-- auctions
	"Auction created",
	"Your auction of %s has expired",
	"Your auction of %s sold",
	"Bid accepted",
	"You won an auction for",
	
	-- drunk
	"is looking sober from the",
	"seems a little tipsy from the",
	"is getting drunk off of",
	"is completely smashed from the",
	"seems to be sobering up",
	"looks tipsy",
	"looks drunk",
	"looks completely smashed",
	
	-- duel
	"has defeated",
	"has fled from",
	
	-- pvp flagged
	"You are now flagged for PvP combat",
	"You will be unflagged for PvP combat",
	
	-- login message
	"Willkommen zu",
	"Welcome to",
	
	-- difficulty
	"Dungeon Difficulty set to",
	"Raid Difficulty set to",
}

--	Trade Channel Message Filter
local gsub,tremove,prevLineID,chatLines,chatPlayers = gsub,tremove,0,{},{}
ChatFrame_AddMessageEventFilter("CHAT_MSG_CHANNEL", function(_,event,msg,player,_,_,_,_,_,_,_,_,lineID)
	if lineID == prevLineID then
		return true
	else
		prevLineID = lineID
		local lowMsg, mewMsg = msg:lower(), nil;
		
		-- Check for guild & self posts
		if not CanComplainChat(player) or UnitIsInMyGuild(player) then return end	

		-- filter from blacklist
		for filter in pairs(tradeFilterList) do
			for k, v in pairs(tradeFilterList[filter]) do
				if lowMsg:find(v) then
					return true
				end
			end
		end
		
		-- filter if spam
		for index in pairs(chatLines) do
			local playerModified = gsub(player,"-"..GetRealmName(),"")
			if chatLines[index] == lowMsg and ( (chatPlayers[index] == player) or (chatPlayers[index] == playerModified) ) then
				return true
			end
			if index == 20 then tremove(chatLines, 1) tremove(chatPlayers, 1) end
		end
	
		-- modify RaidIcons
		if msg:find("{", nil, true) then	
			local found = 0
			for i = 1, #raidIconList do
				msg, found = gsub(msg,  raidIconList[i], "")
				if found > 0 then newMsg = msg end
			end
			if newMsg then
				return false,newMsg,player,_,_,_,_,_,_,_,_,lineID
			end
		end

		chatLines[#chatLines+1] = lowMsg
		chatPlayers[#chatPlayers+1] = player
	end
end)

-- System Message Filter
ChatFrame_AddMessageEventFilter("CHAT_MSG_SYSTEM", function(_,event,msg)
	for i = 1, #systemFilterList do
		if strmatch(msg, systemFilterList[i]) then
			return true
		end
	end	
end)
