--[[	reskinning loot frame

------------------]]

--[[	Expand Loot Frame Button Number to 6
LOOTFRAME_NUMBUTTONS = 5

for i = 5, 6 do
	_G["LootButton"..i] = CreateFrame("Button","LootButton"..i,LootFrame,"LootButtonTemplate")
	_G["LootButton"..i]:SetID(i)
end
--]]


function SyncUI_LootFrame_OnLoad(self)
	self:RegisterEvent("LOOT_OPENED")
	self:RegisterEvent("LOOT_SLOT_CLEARED")
	self:RegisterEvent("LOOT_SLOT_CHANGED")
	self:RegisterEvent("LOOT_CLOSED")
	self:RegisterEvent("LOOT_READY")
	self:RegisterEvent("OPEN_MASTER_LOOT_LIST")
	self:RegisterEvent("UPDATE_MASTER_LOOT_LIST")
	self:RegisterForDrag('LeftButton')
	self:EnableMouseWheel(true)

	LootFrame:SetAlpha(0)
	LootFrame:EnableMouse(false)
	LootFrame:HookScript("OnHide", function() self:Hide() end)

	for i = 1, LOOTFRAME_NUMBUTTONS do
		local button = _G["LootButton"..i]
		button.name = _G["LootButton"..i.."NameFrame"]
		button.text = _G["LootButton"..i.."Text"]
		button.quest = _G["LootButton"..i.."IconQuestTexture"]
		
		button:SetParent(self)
		button:SetSize(23,23)
		button:ClearAllPoints()
		button:SetPoint("TOPLEFT",self,32,-29-(29*(i-1)))
		button:SetHitRectInsets(0,-95,-5,-5)
		button:SetNormalTexture("")
		
		button.name:Hide()
		button.icon:SetTexCoord(0.08,0.92,0.08,0.92)
		
		button.quest:SetSize(25,26)
		button.quest:ClearAllPoints()
		button.quest:SetPoint("CENTER",0,0)

		button.text:SetSize(85,27)
		button.text:ClearAllPoints()
		button.text:SetPoint("LEFT",button,"RIGHT",6,0)
		button.text:SetFontObject(SyncUI_GameFontOutline_Medium)
		
		button.Count:ClearAllPoints()
		button.Count:SetPoint("BOTTOMRIGHT",button,"BOTTOMRIGHT",0,1)		
		button.Count:SetFontObject(SyncUI_GameFontNormal_Medium)

		button.border = _G["LootButton"..i]:CreateTexture(nil,"ARTWORK")
		button.border:SetTexture("Interface\\AddOns\\SyncUI\\Media\\Textures\\Elements\\Auras\\AuraBorder")
		button.border:SetTexCoord(0,0.515625,0,0.515625)
		button.border:SetSize(33,33)
		button.border:SetPoint("CENTER")
	end
	
	LootFrameUpButton:SetParent(self)
	LootFrameUpButton:SetSize(23,23)
	LootFrameUpButton:ClearAllPoints()
	LootFrameUpButton:SetPoint("BOTTOMLEFT",30,25)
	LootFrameUpButton:SetHitRectInsets(2,2,2,2)
	LootFrameUpButton:SetNormalTexture("Interface\\AddOns\\SyncUI\\Media\\Textures\\Elements\\ScrollBar\\ScrollBarUpButton")
	LootFrameUpButton:SetPushedTexture("Interface\\AddOns\\SyncUI\\Media\\Textures\\Elements\\ScrollBar\\ScrollBarUpButton")
	LootFrameUpButton:SetHighlightTexture("")
	LootFrameUpButton:GetNormalTexture():SetTexCoord(0,0.71875,0,0.1796875)
	LootFrameUpButton:GetPushedTexture():SetTexCoord(0,0.71875,0.25,0.4296875)
	LootFrameUpButton:SetScript("OnMouseUp",function(self,button)
		local highlight = self:GetHighlightTexture()
		highlight:ClearAllPoints()
		highlight:SetPoint("CENTER")
	end)
	LootFrameUpButton:SetScript("OnMouseDown",function(self,button)
		local highlight = self:GetHighlightTexture()
		highlight:ClearAllPoints()
		highlight:SetPoint("CENTER",0,-2)
	end)
	
	LootFrameDownButton:SetParent(self)
	LootFrameDownButton:SetSize(23,23)
	LootFrameDownButton:ClearAllPoints()
	LootFrameDownButton:SetPoint("BOTTOMRIGHT",-30,25)
	LootFrameDownButton:SetHitRectInsets(2,2,2,2)
	LootFrameDownButton:SetNormalTexture("Interface\\AddOns\\SyncUI\\Media\\Textures\\Elements\\ScrollBar\\ScrollBarDownButton")
	LootFrameDownButton:SetPushedTexture("Interface\\AddOns\\SyncUI\\Media\\Textures\\Elements\\ScrollBar\\ScrollBarDownButton")
	LootFrameDownButton:SetHighlightTexture("")
	LootFrameDownButton:GetNormalTexture():SetTexCoord(0,0.71875,0,0.1796875)
	LootFrameDownButton:GetPushedTexture():SetTexCoord(0,0.71875,0.25,0.4296875)
	LootFrameDownButton:SetScript("OnMouseUp",function(self,button)
		local highlight = self:GetHighlightTexture()
		highlight:ClearAllPoints()
		highlight:SetPoint("CENTER")
	end)
	LootFrameDownButton:SetScript("OnMouseDown",function(self,button)
		local highlight = self:GetHighlightTexture()
		highlight:ClearAllPoints()
		highlight:SetPoint("CENTER",0,-2)
	end)

	
	-- MasterLooter Fix
	hooksecurefunc("LootButton_OnClick",function(self,button)
		local method, LMParty, LMRaid = GetLootMethod()
		local isLootMaster;
		
		-- return if there is no lootmaster selected
		if method ~= "master" then return end
		
		-- check if player is lootmaster
		if IsInRaid() then
			if UnitGUID("raid"..LMRaid) == UnitGUID("player") then
				isLootMaster = true
			end
		elseif IsInGroup() and LMParty == 0 then
			isLootMaster = true
		end

		-- if player is lootmaster show dropdown menu
		if isLootMaster then
			ToggleDropDownMenu(1, nil, GroupLootDropDown, LootFrame.selectedLootButton, 0, 0)
		end
	end)
end

function SyncUI_LootFrame_OnMouseWheel(self,delta)
	if delta > 0 then
		if LootFrameUpButton:IsShown() then
			LootFrame_PageUp()
		end
	else
		if LootFrameDownButton:IsShown() then
			LootFrame_PageDown()
		end
	end
end