--[[	handler functions for action bars

------------------]]

local _G = _G
local prefix = "InterfaceOptionsActionBarsPanel"
local buttons = {"BottomRight","Right","RightTwo","AlwaysShowActionBars"}
local bars = {"MultiBarBottomRight","MultiBarRight","MultiBarLeft"}


local function StyleActionButton(self)
	self:SetSize(40,40)
	self:SetNormalTexture("")
	self:GetNormalTexture():SetAlpha(0)
	self.icon:SetTexCoord(0.05,0.95,0.05,0.95)
	
	self.iconTex = self:CreateTexture(nil,"BORDER")
	self.iconTex:SetSize(44,44)
	self.iconTex:SetPoint("CENTER",0,0)
	self.iconTex:SetTexture("Interface\\AddOns\\SyncUI\\Media\\Textures\\UI-Mods\\MainMenuBar\\ActionBarButton_Border")
	self.iconTex:SetTexCoord(0,0.6875,0,0.6875)

	self.normalTex = self:CreateTexture(nil,"BACKGROUND")
	self.normalTex:SetDrawLayer("BACKGROUND", -1)
	self.normalTex:SetSize(44,44)
	self.normalTex:SetPoint("CENTER",0,0)
	self.normalTex:SetTexture("Interface\\AddOns\\SyncUI\\Media\\Textures\\UI-Mods\\MainMenuBar\\ActionBarButton_Shadow")
	self.normalTex:SetTexCoord(0,0.6875,0,0.6875)

	self.hotkey = _G[self:GetName().."HotKey"]
	self.hotkey:SetFontObject(SyncUI_GameFontNormal_Large)
	self.hotkey:ClearAllPoints()
	self.hotkey:SetPoint("TOPRIGHT",1,-3)
	self.hotkey:SetShadowColor(0,0,0)
	self.hotkey:SetShadowOffset(1,-1)
	
	self.count = _G[self:GetName().."Count"]
	self.count:SetFontObject(SyncUI_GameFontNormal_Large)
	self.count:ClearAllPoints()
	self.count:SetPoint("BOTTOMRIGHT",0,1)
	
	self.name = _G[self:GetName().."Name"]
	self.name:SetFontObject(SyncUI_GameFontNormal_Medium)
	self.name:SetSize(42,10)
	self.name:SetPoint("BOTTOM",0,1)
	self.name:SetShadowOffset(0,0)

	self.border = _G[self:GetName().."Border"]
	self.border:SetTexture("Interface\\AddOns\\SyncUI\\Media\\Textures\\UI-Mods\\MainMenuBar\\ActionBarButton_ItemBorder")
	self.border:SetTexCoord(0,0.6875,0,0.6875)
	self.border:SetSize(44,44)
	self.border:SetPoint("CENTER",0,0)
	
	self.pushed = self:GetPushedTexture()
	self.pushed:SetSize(39,39)
	self.pushed:ClearAllPoints()
	self.pushed:SetPoint("CENTER")

	local floatingBG = _G[self:GetName().."FloatingBG"]
	if floatingBG then floatingBG:SetTexture("") end
	
	if self.cooldown then
		SyncUI_Cooldown_OnRegister(self.cooldown)
		
		self.cooldown:ClearAllPoints()
		self.cooldown:SetPoint("TOPLEFT",1,-1)
		self.cooldown:SetPoint("BOTTOMRIGHT",-1,1)
	end
end

local function StyleActionButton_SideBar(self)
	self:SetSize(33,33)
	self:SetNormalTexture("")
	self:GetNormalTexture():SetAlpha(0)
	self.icon:SetTexCoord(0.05,0.95,0.05,0.95)
	
	self.iconTex = self:CreateTexture(nil,"BORDER")
	self.iconTex:SetSize(37,37)
	self.iconTex:SetPoint("CENTER",0,0)
	self.iconTex:SetTexture("Interface\\AddOns\\SyncUI\\Media\\Textures\\UI-Mods\\MainMenuBar\\ActionBarButton_BorderSmall")
	self.iconTex:SetTexCoord(0,0.578125,0,0.578125)
	
	self.normalTex = self:CreateTexture(nil,"BACKGROUND")
	self.normalTex:SetDrawLayer("BACKGROUND", -1)
	self.normalTex:SetSize(37,37)
	self.normalTex:SetPoint("CENTER",0,0)
	self.normalTex:SetTexture("Interface\\AddOns\\SyncUI\\Media\\Textures\\UI-Mods\\MainMenuBar\\ActionBarButton_ShadowSmall")
	self.normalTex:SetTexCoord(0,0.578125,0,0.578125)

	self.hotkey = _G[self:GetName().."HotKey"]
	self.hotkey:SetFontObject(SyncUI_GameFontNormal_Medium)
	self.hotkey:ClearAllPoints()
	self.hotkey:SetPoint("TOPRIGHT",2,0)
	self.hotkey:SetShadowColor(0,0,0)
	self.hotkey:SetShadowOffset(1,-1)
	
	self.count = _G[self:GetName().."Count"]
	self.count:SetFontObject(SyncUI_GameFontNormal_Medium)
	self.count:ClearAllPoints()
	self.count:SetPoint("BOTTOMRIGHT",1,0)
	
	self.name = _G[self:GetName().."Name"]
	self.name:SetFontObject(SyncUI_GameFontNormal_Medium)
	self.name:SetSize(32,10)
	self.name:SetPoint("BOTTOM")
	
	self.border = _G[self:GetName().."Border"]
	self.border:SetTexture("Interface\\AddOns\\SyncUI\\Media\\Textures\\UI-Mods\\MainMenuBar\\ActionBarButton_ItemBorderSmall")
	self.border:SetTexCoord(0,0.578125,0,0.578125)
	self.border:SetSize(37,37)
	self.border:SetPoint("CENTER",0,0)

	
	local floatingBG = _G[self:GetName().."FloatingBG"]
	if floatingBG then floatingBG:SetTexture("") end
	
	if self.cooldown then
		SyncUI_Cooldown_OnRegister(self.cooldown)
		
		self.cooldown:ClearAllPoints()
		self.cooldown:SetPoint("TOPLEFT",1,-1)
		self.cooldown:SetPoint("BOTTOMRIGHT",-1,1)
	end
end

local function StyleActionButton_Vehicle(self)
	if not self.HotKey then self.HotKey = _G[self:GetName().."HotKey"] end
	if not self.icon then self.icon = self.Icon end
	
	self:SetSize(53,53)
	self:SetNormalTexture("")
	self.HotKey:SetSize(53,10)
	self.HotKey:SetFontObject(SyncUI_GameFontNormal_Large)
	self.HotKey:ClearAllPoints()
	self.HotKey:SetPoint("TOP",self,"BOTTOM",0,-2)
	self.HotKey:SetJustifyH("CENTER")
	
	self.icon:SetTexCoord(0.05,0.95,0.05,0.95)
	
	if not self.iconTex then
		self.iconTex = self:CreateTexture(nil,"BORDER")
		self.iconTex:SetSize(57,57)
		self.iconTex:SetPoint("CENTER",0,0)
		self.iconTex:SetTexture("Interface\\AddOns\\SyncUI\\Media\\Textures\\UI-Mods\\MainMenuBar\\ActionBarButton_BorderLarge")
		self.iconTex:SetTexCoord(0,0.890625,0,0.890625)
	end
	
	if self.cooldown then
		self.cooldown:ClearAllPoints()
		self.cooldown:SetPoint("TOPLEFT",1,-1)
		self.cooldown:SetPoint("BOTTOMRIGHT",-1,1)
	end
end

local function GetStanceIcon(index)
	local name = select(2, GetShapeshiftFormInfo(index))
	local class = select(2, UnitClass("player"))
	local icon;
	
	-- fix
	if class == "SHAMAN" and index == 1 then
		icon = select(3, GetSpellInfo("Ghost Wolf"))
	elseif class == "ROGUE" and index == 3 then
		-- Shadow Dance
		local spell = select(2, GetShapeshiftFormInfo(2))
		icon = select(3, GetSpellInfo(spell))
	else
		icon = select(3, GetSpellInfo(name))
	end

	return icon
end

local function RegisterFlyoutButton(self)
	self:RegisterEvent("PLAYER_LOGIN")
	self:RegisterEvent("PLAYER_TALENT_UPDATE")
	self:RegisterEvent("ACTIVE_TALENT_GROUP_CHANGED")
	
	self:SetAttribute("Collapsed",false)
	self:SetAttribute("Update",[[
		if self:GetAttribute("Collapsed") then
			self:GetFrameRef("SyncUI_StanceBar"):Hide()
		else
			self:GetFrameRef("SyncUI_StanceBar"):Show()
		end
	]])
	self:SetAttribute("_onclick",[[
		self:SetAttribute("Collapsed", not self:GetAttribute("Collapsed"))
		self:RunAttribute("Update")
	]])
	self:SetAttribute("_onstate-stance",[[
		self:SetAttribute("Collapsed",true)
		self:GetFrameRef("SyncUI_StanceBar"):Hide()
	]])
	self:SetAttribute("_onstate-combat", "self:RunAttribute('Update')")
	self:SetFrameRef("SyncUI_StanceBar", _G["SyncUI_StanceBar"])
	RegisterStateDriver(self, "stance", "[stance:1] 1; [stance:2] 2; [stance:3] 3; [stance:4] 4; [stance:5] 5;")
end


-- Action Bars
function SyncUI_MainMenuBar_OnLoad(self)
	self:SetScale(SyncUI_UIScale)
	
	-- Kill Frames
	SyncUI_DisableFrame("MainMenuBar")
	SyncUI_DisableFrame("ActionBarDownButton")
	SyncUI_DisableFrame("ActionBarUpButton")	
	SyncUI_DisableFrame("MainMenuBarBackpackButton")
	SyncUI_DisableFrame("CharacterBag0Slot")
	SyncUI_DisableFrame("CharacterBag1Slot")
	SyncUI_DisableFrame("CharacterBag2Slot")
	SyncUI_DisableFrame("CharacterBag3Slot")
	SyncUI_DisableFrame("OverrideActionBarExpBar")
	SyncUI_DisableFrame("OverrideActionBarHealthBar")
	SyncUI_DisableFrame("OverrideActionBarPowerBar")
	SyncUI_DisableFrame("OverrideActionBarPitchFrame")
	SyncUI_DisableFrame("OverrideActionBarLeaveFrame")

	for _, frame in pairs(MICRO_BUTTONS) do SyncUI_DisableFrame(frame) end

	-- Kill Textures	
	MainMenuBarPageNumber:Hide()
	OverrideActionBarEndCapL:Hide()
	OverrideActionBarEndCapR:Hide()
	OverrideActionBarDivider2:Hide()
	OverrideActionBarBorder:Hide()
	OverrideActionBarBG:Hide()
	OverrideActionBarMicroBGL:Hide()
	OverrideActionBarMicroBGR:Hide()
	OverrideActionBarMicroBGMid:Hide()
	OverrideActionBarButtonBGL:Hide()
	OverrideActionBarButtonBGR:Hide()
	OverrideActionBarButtonBGMid:Hide()

	StanceBarLeft:SetTexture(nil)
	StanceBarMiddle:SetTexture(nil)
	StanceBarRight:SetTexture(nil)	
	PossessBackground1:SetTexture(nil)
	PossessBackground2:SetTexture(nil)	
	SlidingActionBarTexture0:SetTexture(nil)
	SlidingActionBarTexture1:SetTexture(nil)
	MainMenuBarTexture0:SetTexture(nil)
    MainMenuBarTexture1:SetTexture(nil)
    MainMenuBarTexture2:SetTexture(nil)
    MainMenuBarTexture3:SetTexture(nil)
    MainMenuBarLeftEndCap:SetTexture(nil)
    MainMenuBarRightEndCap:SetTexture(nil)

	ExtraActionBarFrame:SetParent(self)
	ExtraActionBarFrame:ClearAllPoints()
	ExtraActionBarFrame:SetPoint("BOTTOM",self,"TOP")
end

function SyncUI_ActionBar_OnLoad(self)
	MainMenuBarArtFrame:SetParent(self)
	MainMenuBarArtFrame:EnableMouse(false)
	for i = 1, 12 do
		local button = _G["ActionButton"..i]
		StyleActionButton(button)

		button:ClearAllPoints()
		button:SetPoint("BOTTOM",-253+(46*(i-1)),28)
	end
	
	-- check if bottomLeft was shown
	if not _G[prefix.."BottomLeft"]:GetChecked() then
		self.borderLeft:SetTexture("Interface\\AddOns\\SyncUI\\Media\\Textures\\UI-Mods\\MainMenuBar\\ActionBar_BorderSmallLeft")
		self.borderRight:SetTexture("Interface\\AddOns\\SyncUI\\Media\\Textures\\UI-Mods\\MainMenuBar\\ActionBar_BorderSmallRight")	
	end
	
	self:RegisterUnitEvent("UNIT_ENTERED_VEHICLE","player")
	self:RegisterUnitEvent("UNIT_EXITED_VEHICLE","player")
	
	RegisterStateDriver(self, "visibility", "[petbattle][overridebar][vehicleui][possessbar,@vehicle,exists] hide; show")
end

function SyncUI_MultiBar_OnLoad(self)
	MultiBarBottomLeft:SetParent(self)
	MultiBarBottomLeft:EnableMouse(false)
	MultiBarBottomLeft:HookScript("OnShow",function()
		SyncUI_ActionBar.borderLeft:SetTexture("Interface\\AddOns\\SyncUI\\Media\\Textures\\UI-Mods\\MainMenuBar\\ActionBar_BorderLeft")
		SyncUI_ActionBar.borderRight:SetTexture("Interface\\AddOns\\SyncUI\\Media\\Textures\\UI-Mods\\MainMenuBar\\ActionBar_BorderRight")
	end)
	MultiBarBottomLeft:HookScript("OnHide",function()
		SyncUI_ActionBar.borderLeft:SetTexture("Interface\\AddOns\\SyncUI\\Media\\Textures\\UI-Mods\\MainMenuBar\\ActionBar_BorderSmallLeft")
		SyncUI_ActionBar.borderRight:SetTexture("Interface\\AddOns\\SyncUI\\Media\\Textures\\UI-Mods\\MainMenuBar\\ActionBar_BorderSmallRight")
	end)
	
	for i = 1, 12 do
		local button = _G["MultiBarBottomLeftButton"..i]
		StyleActionButton(button)
		
		button:ClearAllPoints()
		button:SetPoint("LEFT",self,0+(46*(i-1)),0)
	end

	RegisterStateDriver(self, "visibility", "[petbattle][overridebar][vehicleui][possessbar,@vehicle,exists] hide; show")
end

function SyncUI_SideBar_OnLoad(self)
	self.row, self.old = 1, 1
	
	for _, bar in pairs(bars) do
		local Bar = _G[bar]
		local parent = _G["SyncUI_"..bar]
		Bar:SetParent(parent)
		Bar:EnableMouse(false)
		Bar:Show()
		
		for i = 1, 12 do
			local button = _G[bar.."Button"..i]
			button:ClearAllPoints()
			button:SetPoint("LEFT",self,12+(37*(i-1)),0)
			button:SetAttribute("flyoutDirection", "UP")
			StyleActionButton_SideBar(button)
		end
	end

	for _, button in pairs(buttons) do
		local btn = _G[prefix..button]
		btn:Hide()
	end

	_G[prefix.."LockActionBars"]:ClearAllPoints()
	_G[prefix.."LockActionBars"]:SetPoint("TOP",prefix.."BottomLeft","BOTTOM",0,-8)
	_G[prefix.."SecureAbilityToggle"]:ClearAllPoints()
	_G[prefix.."SecureAbilityToggle"]:SetPoint("TOP",prefix.."LockActionBars","BOTTOM",0,-55)

	SyncUI_SideBar_OnScroll(self,0)

	RegisterStateDriver(self, "visibility", "[petbattle][overridebar][vehicleui][possessbar,@vehicle,exists] hide; show")
end

function SyncUI_SideBar_OnEvent(self,event,...)
	if event=="PLAYER_REGEN_ENABLED" then
		self.row = self.old
		SyncUI_SideBar_OnScroll(self,0)
	end
	if event=="PLAYER_REGEN_DISABLED" then
		self.old = self.row
		self.row = self.switch
		SyncUI_SideBar_OnScroll(self,0)
	end
end

function SyncUI_SideBar_OnScroll(self,value)
	if InCombatLockdown() then return end

	self.row = self.row + value
	
	if self.row > #bars then self.row = #bars return elseif self.row < 1 then self.row = 1 return end
	if self.row >= #bars then SyncUI_SideBarScrollUp:Hide() else SyncUI_SideBarScrollUp:Show() end
	if self.row <= 1 then SyncUI_SideBarScrollDown:Hide() else SyncUI_SideBarScrollDown:Show() end

	for row, bar in pairs(bars) do
		local Bar = _G["SyncUI_"..bar]
		if row == self.row then
			Bar:Show()
		else
			Bar:Hide()
		end
	end
end

function SyncUI_VehicleBar_OnLoad(self)
	OverrideActionBar:SetParent(self)
	OverrideActionBar:ClearAllPoints()
	OverrideActionBar:SetPoint("BOTTOM",0,27)
	OverrideActionBar:EnableMouse(false)
	OverrideActionBar:SetScript("OnShow", nil)
	
	local leaveButtonPlaced = false
	OverrideActionBar.LeaveButton:Hide()
	
	for i = 1, 6 do
		local button = _G["OverrideActionBarButton"..i]
		StyleActionButton_Vehicle(button)

		if i == 1 then
			button:SetPoint("LEFT", self, 90, 8)
		else
			local previous = _G["OverrideActionBarButton"..i-1]
			button:SetPoint("LEFT", previous, "RIGHT", 8, 0)
		end

		--button:SetPoint("LEFT",self,90+(61*(i-1)),8)
	end
	
	VehicleSeatIndicator:SetParent(self)
	VehicleSeatIndicator:ClearAllPoints()
	VehicleSeatIndicator:SetPoint("BOTTOMLEFT",self,"TOPLEFT",-125,-20)
	VehicleSeatIndicator.SetPoint = function() end

	RegisterStateDriver(self, "visibility", "[petbattle] hide; [overridebar][vehicleui][possessbar,@vehicle,exists] show; hide")
	RegisterStateDriver(OverrideActionBar, "visibility", "[overridebar][vehicleui][possessbar,@vehicle,exists] show; hide")
end

function SyncUI_PetBar_OnLoad(self)
	PetActionBarFrame:SetParent(self)
	PetActionBarFrame:EnableMouse(false)

	for i = 1, NUM_PET_ACTION_SLOTS do
		local button = _G["PetActionButton"..i]
		StyleActionButton_SideBar(button)
		
		button:ClearAllPoints()
		button:SetPoint("TOP",self,5,-49.5-(37*(i-1)))
	end
	
	RegisterStateDriver(self, "visibility", "[petbattle][overridebar][vehicleui][possessbar,@vehicle,exists] hide; [@pet,exists] show; hide")
end

function SyncUI_PetBattleBar_OnLoad(self)
	self:RegisterEvent("PET_BATTLE_OPENING_START")
	self:RegisterEvent("PET_BATTLE_OPENING_DONE")
	self:RegisterEvent("PET_BATTLE_TURN_STARTED")
	self:RegisterEvent("PET_BATTLE_PET_CHANGED")
	RegisterStateDriver(self, "visibility", "[petbattle] show; hide")
	
	-- Hide Stuff
	local ref = PetBattleFrame.BottomFrame
	ref:SetParent(self)
	ref.Background:Hide()
	ref.RightEndCap:Hide()
	ref.LeftEndCap:Hide()
	ref.FlowFrame:Hide()
	ref.Delimiter:Hide()
	ref.TurnTimer:Hide()
	ref.MicroButtonFrame:Hide()
	
	ref.TurnTimer:ClearAllPoints()
	ref.TurnTimer:SetPoint("BOTTOM",self,"TOP",0,-20)

end

function SyncUI_PetBattleBar_OnEvent(self)
	local ref = PetBattleFrame.BottomFrame

	for index, value in pairs(ref.abilityButtons) do
		local button = ref.abilityButtons[index]
		button:SetFrameStrata("HIGH")
		button:ClearAllPoints()
		button:SetPoint("LEFT",self,90+(61*(index-1)),6.5)
		StyleActionButton_Vehicle(button)
	end

	ref.SwitchPetButton:SetFrameStrata("HIGH")
	ref.SwitchPetButton:ClearAllPoints()
	ref.SwitchPetButton:SetPoint("LEFT",self,90+(61*3),6.5)
	
	ref.CatchButton:SetFrameStrata("HIGH")
	ref.CatchButton:ClearAllPoints()
	ref.CatchButton:SetPoint("LEFT",self,90+(61*4),6.5)
	
	ref.ForfeitButton:SetFrameStrata("HIGH")
	ref.ForfeitButton:ClearAllPoints()
	ref.ForfeitButton:SetPoint("LEFT",self,90+(61*5),6.5)

	StyleActionButton_Vehicle(ref.SwitchPetButton)
	StyleActionButton_Vehicle(ref.CatchButton)
	StyleActionButton_Vehicle(ref.ForfeitButton)
	
	PetBattleFrameXPBar:Hide()
end

function SyncUI_StanceBar_OnLoad(self)
	RegisterFlyoutButton(SyncUI_StanceButton)
	
	for i = 1, 10 do
		local button = _G["StanceButton"..i]
		StyleActionButton_SideBar(button)
		
		button:SetParent(self)
		button:ClearAllPoints()
		button:SetPoint("BOTTOMLEFT",self,7,7+(37*(i-1)))
	end
end

function SyncUI_StanceBar_OnUpdateSize(self)
	local backdrop = self.backdrop
	local numBtn = 0
	
	for i = 1, 10 do
		local button = _G["StanceButton"..i]
		if button:IsShown() then
			numBtn = numBtn + 1
		end
	end
	
	backdrop:SetSize(47,(37*numBtn)+10)
end

function SyncUI_StanceButton_OnEvent(self,event,...)
	if InCombatLockdown() then return end
	
	if GetNumShapeshiftForms() > 0 then
		self:EnableMouse(true)
	else
		self:EnableMouse(false)
		SyncUI_StanceBar:Hide()
	end
end

function SyncUI_StanceButton_OnUpdate(self)
	local index = GetShapeshiftForm()
	if index and index ~= 0 then
		self.alert:Show()
		local icon = GetStanceIcon(index)
		if self.alert.icon:GetTexture() ~= icon then
			self.alert.icon:SetTexture(icon)
		end
	else
		self.alert:Hide()
	end
end


-- Alternate Power Bar
function SyncUI_AlternatePowerBar_OnLoad(self)
	local unit = "player"
	
	self:RegisterEvent("PLAYER_ENTERING_WORLD")
	self:RegisterUnitEvent("UNIT_POWER_BAR_SHOW",unit)
	self:RegisterUnitEvent("UNIT_POWER_BAR_HIDE",unit)
	
	self.StatusBar.power = 0
	self.StatusBar.maxPower = 0
	self.Title = self.ArtFrame.Title
	
	PlayerPowerBarAlt:UnregisterAllEvents()
end

function SyncUI_AlternatePowerBar_OnEvent(self,event,...)
	local unit = "player"
	
	if event == "PLAYER_ENTERING_WORLD" then
		if UnitAlternatePowerInfo(unit) then
			self:RegisterUnitEvent("UNIT_POWER",unit)
			self:RegisterUnitEvent("UNIT_MAXPOWER",unit)
			self.StatusBar.power = UnitPower(unit, ALTERNATE_POWER_INDEX)
			self.StatusBar.maxPower = UnitPowerMax(unit, ALTERNATE_POWER_INDEX)
			self:Show()
		end
	end
	if event == "UNIT_POWER" or event == "UNIT_MAXPOWER" then
		self.StatusBar.power = UnitPower(unit, ALTERNATE_POWER_INDEX)
		self.StatusBar.maxPower = UnitPowerMax(unit, ALTERNATE_POWER_INDEX)
		self:Show()
	end
	if event == "UNIT_POWER_BAR_SHOW" then
		self:RegisterUnitEvent("UNIT_POWER",unit)
		self:RegisterUnitEvent("UNIT_POWER",unit)
		self:Show()
	end
	if event == "UNIT_POWER_BAR_HIDE" then
		self:UnregisterEvent("UNIT_POWER")
		self:UnregisterEvent("UNIT_MAXPOWER")
		self.StatusBar.power = 0
		self.StatusBar.maxPower = 0
		self:Hide()
	end
	
end

function SyncUI_AlternatePowerBar_OnUpdate(self)
	local power, maxPower = self.StatusBar.power, self.StatusBar.maxPower
	local _, r, g, b, a = UnitAlternatePowerTextureInfo("player",2,0)

	self.StatusBar:SetStatusBarColor(r,g,b,a)
	self.StatusBar:SetMinMaxValues(0,maxPower)
	SmoothBar(self.StatusBar,power)

	if power == 0 then
		self.Title:SetText("")
	else
		self.Title:SetText(math.ceil(power*100/maxPower).."%")
	end
end
