
local version = GetAddOnMetadata("SyncUI", "Version")
local maxChangeLogLines = 5
local ChangeLogData = {
	" - UnitFrames: duration timers added for buffs and debuffs.",
	" - ScrollBar: reskinned for all frames related to SyncUI.",
	" - ReadyChecker: slightly changed the design & added a fading counter.",
	" - SyncOptions has been added and merged into the game menu.",
	" - SyncOptions: new tag for reactive player auras has been added.",
}

local function GetChangeLogInfo(i)
	for line, info in pairs(ChangeLogData) do
		if line == i then
			return info
		end
	end
end

function SyncUI_ToggleChangeLog()
	PlaySound("igMainMenuOptionCheckBoxOn")
	local frame = SyncUI_ChangeLog
	
	if frame:IsShown() then
		frame:Hide()
	else
		SyncUI_SlideIn(frame)
	end
end

function SyncUI_ChangeLog_OnLoad(self)
	self:SetScale(SyncUI_UIScale)
	self:RegisterEvent("PLAYER_ENTERING_WORLD")
	
	self.Version:SetText(version)
	self.Version:SetTextColor(1,0.25,0.25)

	self.ScrollFrame:Show()
	tinsert(UISpecialFrames,"SyncUI_ChangeLog")
end

function SyncUI_ChangeLog_OnCheckVersion(self)
	if not SyncUI_Data["Version"] or ( SyncUI_Data["Version"] and SyncUI_Data["Version"] ~= version) then
		SyncUI_SlideIn(self)
		SyncUI_Data["Version"] = version
	end
	
	self:UnregisterEvent("PLAYER_ENTERING_WORLD")
end

function SyncUI_ChangeLog_ScrollBar_ForceUpdate(self)
	local offset = FauxScrollFrame_GetOffset(self)
	local parent = self:GetParent()
	
	FauxScrollFrame_Update(self, #ChangeLogData, maxChangeLogLines, 30)
	
	for i = 1, maxChangeLogLines do
		local button = _G[parent:GetName().."Button"..i]
		local idx = offset + i
		
		if idx <= #ChangeLogData then
			button.Text:SetText(GetChangeLogInfo(idx))
			
			button:Show()
		else
			button:Hide()
		end
	end
end
