--[[	handler functions for work order automization

------------------]]

local Building = {
    [  8] = "War Mill 1",
    [  9] = "War Mill 2",
    [ 10] = "War Mill 3",
    [111] = "Trading Post 1",
    [144] = "Trading Post 2",
    [145] = "Trading Post 3",
}

function SyncUI_AutoWorkOrders_OnLoad(self)
	self:RegisterEvent("SHIPMENT_CRAFTER_OPENED")
end

function SyncUI_AutoWorkOrders_OnEvent(self,event,...)
	if event == "SHIPMENT_CRAFTER_OPENED" then
		self:RegisterEvent("SHIPMENT_CRAFTER_INFO")
	end
	
	if event == "SHIPMENT_CRAFTER_INFO" then
		local _, usedWorkOrders, maxWorkOrders, plotID = ...
		local id = C_Garrison.GetOwnedBuildingInfo(plotID)

		if not Building[id] and usedWorkOrders < maxWorkOrders then
			GarrisonCapacitiveDisplayFrame.CreateAllWorkOrdersButton:Click()
		end

		self:UnregisterEvent("SHIPMENT_CRAFTER_INFO")
	end
end
