--[[	handler functions for alternate resource bars (chibar, dk-runes, totems)

------------------]]

local _G = _G
	
function SyncUI_ResourceBar_OnEvent(self,event,...)
	-- Pre Hide
	SyncUI_RuneBar:Hide()
	SyncUI_EclipseBar:Hide()
	SyncUI_ArcaneChargeBar:Hide()
	SyncUI_ChiBar:Hide()
	SyncUI_StaggerBar:Hide()
	SyncUI_EmberBar:Hide()
	SyncUI_SoulShardBar:Hide()
	SyncUI_FuryBar:Hide()
	SyncUI_OrbBar:Hide()
	SyncUI_TotemBar:Hide()
	SyncUI_HolyBar:Hide()
	SyncUI_ComboBar:Hide()
	
	local class = select(2, UnitClass("player"))
	
	if event == "UPDATE_SHAPESHIFT_FORM" and class == "DRUID" then
		local form = GetShapeshiftForm()
		
		if form == 2 then
			SyncUI_ComboBar:Show()
		elseif form == 4 then
			SyncUI_EclipseBar:Show()
		end
	else
		if class == "DEATHKNIGHT" then
			SyncUI_RuneBar:Show()
		end
		if class == "DRUID" then
			if GetSpecialization() then
				local specID = select(1, GetSpecializationInfo(GetSpecialization()))
				if specID == 102 then
					SyncUI_EclipseBar:Show()
				end
				if specID == 103 then
					SyncUI_ComboBar:Show()
				else
					SyncUI_ComboBar:Hide()
				end
			end
		end
		if class == "MAGE" then
			if GetSpecialization() then
				local specID = select(1, GetSpecializationInfo(GetSpecialization()))
				if specID == 62 then
					SyncUI_ArcaneChargeBar:Show()
				end
			end
		end
		if class == "MONK" then
			SyncUI_ChiBar:Show()
			
			--Brew Master
			if GetSpecialization() then
				local specID = select(1, GetSpecializationInfo(GetSpecialization()))
				if specID == 268 then
					SyncUI_StaggerBar:Show()
				end
			end
		end
		if class == "PALADIN" then
			SyncUI_HolyBar:Show()		
		end
		if class == "PRIEST" then
			if GetSpecialization() then
				local specID = select(1, GetSpecializationInfo(GetSpecialization()))
				if specID == 258 then
					SyncUI_OrbBar:Show()			
				end
			end
		end
		if class == "ROGUE" then
			SyncUI_ComboBar:Show()
		end
		if class == "SHAMAN" then
			SyncUI_TotemBar:Show()		
		end
		if class == "WARLOCK" then
			if GetSpecialization() then
				local specID = select(1, GetSpecializationInfo(GetSpecialization()))
				if specID == 265 then
					SyncUI_SoulShardBar:Show()
				end
				if specID == 266 then
					SyncUI_FuryBar:Show()	
				end
				if specID == 267 then
					SyncUI_EmberBar:Show()
				end
			end
		end
	end
end

function SyncUI_RuneBar_OnUpdate(self)
	for rune = 1, 6 do
		local start, duration, runeReady = GetRuneCooldown(rune);
		local runeType = GetRuneType(rune);
		local i;

		-- Set Index
		if rune >= 1 and rune <= 2 then i = rune
		elseif rune == 3 then i = 5
		elseif rune == 4 then i = 6
		elseif rune == 5 then i = 3
		elseif rune == 6 then i = 4 end
  
		-- Set Cooldown
		_G[self:GetName().."Rune"..i.."Fill"]:SetMinMaxValues(0,duration)
		_G[self:GetName().."Rune"..i.."Fill"]:SetValue(GetTime()-start)
		
		-- Ready Checker
		if not runeReady then
			_G[self:GetName().."Rune"..i].wasReady = nil
		end
		
		-- Set Rune Color
		if runeType == 1 then
			_G[self:GetName().."Rune"..i.."Fill"]:SetStatusBarColor(1,0,0)
		elseif runeType == 2 then
			_G[self:GetName().."Rune"..i.."Fill"]:SetStatusBarColor(0,1,0)
		elseif runeType == 3 then
			_G[self:GetName().."Rune"..i.."Fill"]:SetStatusBarColor(0,0.7,1)
		elseif runeType == 4 then
			_G[self:GetName().."Rune"..i.."Fill"]:SetStatusBarColor(0.8,0.3,1)
		end
	end
end

function SyncUI_RuneBar_OnEvent(self,event,...)
	if event == "RUNE_POWER_UPDATE" then
		for rune = 1, 6 do
			local start, duration, runeReady = GetRuneCooldown(rune);
			local i;

			-- Set Index
			if rune >= 1 and rune <= 2 then i = rune
			elseif rune == 3 then i = 5
			elseif rune == 4 then i = 6
			elseif rune == 5 then i = 3
			elseif rune == 6 then i = 4 end

			if runeReady then
				if not _G[self:GetName().."Rune"..i].wasReady then
					_G[self:GetName().."Rune"..i].wasReady = true
					RuneButton_ShineFadeIn(_G[self:GetName().."Rune"..i.."Shine"])
				end
			end
		end
	end
end

function SyncUI_EclipseBar_OnEclipseChanged(self,type)
	if type == "lunar" and not self.lunar then
			self.bar:SetReverseFill(true)
			self.bar:SetStatusBarColor(0.3,0.6,1)
			self.flash.tex:SetVertexColor(0.3,0.6,1)
			self.lunar = true
			self.solar = false
	elseif type == "solar" and not self.solar then
			self.bar:SetReverseFill(false)
			self.bar:SetStatusBarColor(1,1,0.3)
			self.flash.tex:SetVertexColor(1,1,0.3)
			self.solar = true
			self.lunar = false
	end
end

function SyncUI_EclipseBar_OnUpdate(self)
	local value = UnitPower("player", SPELL_POWER_ECLIPSE)
	local newValue;
	
	if value <= 0 then
		newValue = value-(2*value)
		SyncUI_EclipseBar_OnEclipseChanged(self,"lunar")
	elseif value > 0 then
		newValue = value
		SyncUI_EclipseBar_OnEclipseChanged(self,"solar")
	end
	
	-- flashing
	if newValue >= 35 then if not self.flash:IsShown() then self.flash:Show() end
	else if self.flash:IsShown() then self.flash:Hide() end end
	
	self.bar:SetValue(newValue)
end

function SyncUI_ArcaneChargeBar_OnUpdate(self)
	local charge = select(4, UnitDebuff("player","Arcane Charge"))
	local spellID = select(11, UnitDebuff("player","Arcane Charge"))
	
	for i = 1, 4 do
		if charge and i <= charge then
			_G[self:GetName().."Charge"..i.."Fill"]:SetValue(1)
		else
			_G[self:GetName().."Charge"..i.."Fill"]:SetValue(0)
		end
	end
end

function SyncUI_ChiBar_OnUpdate(self)
	local chi, maxChi = UnitPower("player", SPELL_POWER_CHI), UnitPowerMax("player", SPELL_POWER_CHI)
	local texture = tostring("Interface\\AddOns\\SyncUI\\Media\\Textures\\UnitFrames\\ResourceBar_"..maxChi.."x")

	SyncUI_ChiBarBorder:SetTexture(texture)
	
	for i = 1, 6 do
		_G[self:GetName().."Chi"..i]:SetAlpha(0)
	end

	for i = 1, maxChi do
		_G[self:GetName().."Chi"..i]:SetAlpha(1)

		if maxChi == 4 then
			_G[self:GetName().."Chi"..i]:SetSize(38,15)
		elseif maxChi == 5 then
			_G[self:GetName().."Chi"..i]:SetSize(29,15)
		elseif maxChi == 6 then
			_G[self:GetName().."Chi"..i]:SetSize(23,15)
		end
		
		if i <= chi then
			_G[self:GetName().."Chi"..i.."Fill"]:SetValue(1)
		else
			_G[self:GetName().."Chi"..i.."Fill"]:SetValue(0)
		end
	end
end

function SyncUI_StaggerBar_OnUpdate()
	local stagger, maxStagger = UnitStagger("player"), UnitHealthMax("player")
	local perc = math.ceil(stagger*100/maxStagger)
	
	--Update value + maxValue
	SyncUI_StaggerBarFill:SetMinMaxValues(0, maxStagger)
	SmoothBar(SyncUI_StaggerBarFill,stagger)
	
	--Update Color
	if perc > 60 then
		SyncUI_StaggerBarFill:SetStatusBarColor(1,0,0)
	elseif perc > 30 then
		SyncUI_StaggerBarFill:SetStatusBarColor(1,1,0)
	else
		SyncUI_StaggerBarFill:SetStatusBarColor(0,1,0)
	end
end

function SyncUI_HolyBar_OnUpdate(self)
	local holyPower = UnitPower("player", SPELL_POWER_HOLY_POWER)
	
	for i = 1, 5 do
		if i <= holyPower then
			_G[self:GetName().."Holy"..i.."Fill"]:SetValue(1)
		else
			_G[self:GetName().."Holy"..i.."Fill"]:SetValue(0)
		end
	end
end

function SyncUI_OrbBar_OnUpdate(self)
	local shadowOrb, maxOrbs = UnitPower("player", SPELL_POWER_SHADOW_ORBS), UnitPowerMax("player", SPELL_POWER_SHADOW_ORBS)
	local texture = tostring("Interface\\AddOns\\SyncUI\\Media\\Textures\\UnitFrames\\ResourceBar_"..maxOrbs.."x")
	
	SyncUI_OrbBarBorder:SetTexture(texture)
	
	for i = 1, 5 do
		_G[self:GetName().."Orb"..i]:SetAlpha(0)
	end
	
	for i = 1, maxOrbs do
		_G[self:GetName().."Orb"..i]:SetAlpha(1)
		
		if maxOrbs == 3 then
			_G[self:GetName().."Orb"..i]:SetSize(53,15)
		elseif maxOrbs == 5 then
			_G[self:GetName().."Orb"..i]:SetSize(29,15)
		end
		
		if i <= shadowOrb then
			_G[self:GetName().."Orb"..i.."Fill"]:SetValue(1)
		else
			_G[self:GetName().."Orb"..i.."Fill"]:SetValue(0)
		end
	end
end

function SyncUI_TotemBar_OnUpdate(self)
	for i = 1, 4 do
		local haveTotem, name, start, duration, icon = GetTotemInfo(i)
		if haveTotem then
			_G[self:GetName().."Totem"..i.."Icon"]:SetTexture(icon)

			-- Set Cooldown
			_G[self:GetName().."Totem"..i.."Fill"]:SetMinMaxValues(0,duration)
			_G[self:GetName().."Totem"..i.."Fill"]:SetValue(GetTime()-start)
			
			-- Set Timer
			local timeLeft = math.ceil(start + duration - GetTime())
			if timeLeft < 60 and timeLeft > 0 then
				_G[self:GetName().."Totem"..i.."Timer"]:SetText(string.format("%.0f",timeLeft))
			else
				_G[self:GetName().."Totem"..i.."Timer"]:SetText("")
			end
			--
			_G[self:GetName().."Totem"..i.."Fill"]:SetStatusBarColor(0,0,0,0.75)
		else
			_G[self:GetName().."Totem"..i.."Icon"]:SetTexture()
			_G[self:GetName().."Totem"..i.."Fill"]:SetStatusBarColor(0,0,0,0)
			_G[self:GetName().."Totem"..i.."Timer"]:SetText("")
		end		
	end
end

function SyncUI_EmberBar_OnUpdate(self)
	local ember = UnitPower("player", SPELL_POWER_BURNING_EMBERS, true)
	
	_G[self:GetName().."Ember1Fill"]:SetMinMaxValues(0,10)
	_G[self:GetName().."Ember2Fill"]:SetMinMaxValues(10,20)
	_G[self:GetName().."Ember3Fill"]:SetMinMaxValues(20,30)
	_G[self:GetName().."Ember4Fill"]:SetMinMaxValues(30,40)

	for i = 1, 4 do
		_G[self:GetName().."Ember"..i.."Fill"]:SetValue(ember)
	end

	--StatusBarColor
	if IsPlayerSpell(101508) then
		for i = 1, 4 do
			_G[self:GetName().."Ember"..i.."Fill"]:SetStatusBarColor(0.7,1,0)
		end
	elseif not IsPlayerSpell(101508) then
		for i = 1, 4 do
			_G[self:GetName().."Ember"..i.."Fill"]:SetStatusBarColor(1,0.5,0)
		end
	end
end

function SyncUI_SoulShardBar_OnUpdate(self)
	local shard = UnitPower("player", SPELL_POWER_SOUL_SHARDS)
	
	for i = 1, 4 do
		if i <= shard then
			_G[self:GetName().."Shard"..i.."Fill"]:SetValue(1)
		else
			_G[self:GetName().."Shard"..i.."Fill"]:SetValue(0)
		end
	end
end

function SyncUI_FuryBar_OnUpdate(self)
	local fury = UnitPower("player", SPELL_POWER_DEMONIC_FURY)
	
	--Update Value
	self.text:SetText(fury)
	SmoothBar(self.bar,fury)

	-- Show Glow
	if fury >= 900 then
		self.flash:Show()
		self.bar:SetStatusBarColor(0.5,1,0)
	else
		self.flash:Hide()
		self.bar:SetStatusBarColor(0.5,0.3,0.8)
	end
end

function SyncUI_ComboBar_OnEvent(self)
	local comboPoints = GetComboPoints("player", "target")

	for i = 1, 5 do
		local combo = _G[self:GetName().."Combo"..i.."Fill"]
		if i <= comboPoints then
			combo:SetValue(1)
		else
			combo:SetValue(0)
		end
	end
	
	SyncUI_ComboBarCombo1Fill:SetStatusBarColor(1,1,0)
	SyncUI_ComboBarCombo2Fill:SetStatusBarColor(1,0.75,0)
	SyncUI_ComboBarCombo3Fill:SetStatusBarColor(1,0.50,0)
	SyncUI_ComboBarCombo4Fill:SetStatusBarColor(1,0.25,0)
	SyncUI_ComboBarCombo5Fill:SetStatusBarColor(1,0,0)	
end
