local PocketPlot = CreateFrame("Frame", nil, Minimap)
local LSM = LibStub("LibSharedMedia-3.0")
local widgetLists = AceGUIWidgetLSMlists
local fonts = widgetLists.font
local _, class = UnitClass("player")
local classColor, movershown, clockFrame, clockTime, db, options
local Minimap = Minimap
local MinimapZoneTextButton = MinimapZoneTextButton
local GameTimeFrame = GameTimeFrame
local MiniMapTracking = MiniMapTracking
local QueueStatusMinimapButton = QueueStatusMinimapButton
local MiniMapMailFrame = MiniMapMailFrame
local MiniMapVoiceChatFrame = MiniMapVoiceChatFrame
local MiniMapMeetingStoneFrame = MiniMapMeetingStoneFrame
local TimeManagerClockFrame = TimeManagerClockFrame
PP_oldMinimap, PP_oldDurabilityFrame, PP_oldVehicleSeatIndicator = nil
local _G = _G
local mover, moverText
local wasIndoors
local coordframe = CreateFrame("Frame", nil, Minimap)
		coordframe:SetHeight(28)	--height of clock button
		coordframe:SetWidth(100)
		coordframe:EnableMouse(true)
local coords = coordframe:CreateFontString(nil, "OVERLAY")
		coords:SetParent(coordframe)
		--coords:SetFont("Interface\\AddOns\\PocketPlot\\media\\negotiate_free.ttf", 12)	--temporary
local frames = {	"None",
					"Minimap",
					"DurabilityFrame",
					"VehicleSeatIndicator",
					"MiniMapInstanceDifficulty",
					"GuildInstanceDifficulty",
					"MiniMapChallengeMode",
					"GarrisonLandingPageMinimapButton",
					"WorldStateAlwaysUpFrame",
				}
local stratae = {"BACKGROUND", "LOW", "MEDIUM", "HIGH", "DIALOG"}
local allshapes = {	"3-Corner BL",
					"3-Corner BR",
					"3-Corner TL",
					"3-Corner TR",
					"Circle",
					"Compass",
					--[["Faded Circle",	--<-- Test these more
					"Faded Edges",
					"Faded Square",]]
					"Fancy Frame",
					"Flower",
					"Half Round B",
					"Half Round L",
					"Half Round R",
					"Half Round T",
					"Rectangle",
					"Rounded",
					"Scalloped",
					"Slanted 1",
					"Slanted 2",
					"Square",
					"Teardrop BL",
					"Teardrop BR",
					"Teardrop TL",
					"Teardrop TR",
					"Torn",
					"Zigzag Round",
					"Zigzag Square"
				}
--need these 2 tables for minimap button paths
local squareMasks = {
		["3-Corner BL"] = true,
		["3-Corner BR"] = true,
		["3-Corner TL"] = true,
		["3-Corner TR"] = true,
		["Fancy Frame"] = true,
		["Half Round B"] = true,
		["Half Round L"] = true,
		["Half Round R"] = true,
		["Half Round T"] = true,
		["Rectangle"] = true,
		["Rounded"] = true,
		["Scalloped"] = true,
		["Slanted 1"] = true,
		["Slanted 2"] = true,
		["Square"] = true,
		["Torn"] = true,
		["Zigzag Square"] = true,
	}
local roundMasks = {
		["Circle"] = true,
		["Compass"] = true,
		["Flower"] = true,
		["Teardrop BL"] = true,
		["Teardrop BR"] = true,
		["Teardrop TL"] = true,
		["Teardrop TR"] = true,
		["Zigzag Round"] = true,
	}
local fontFlags = {"None", "Outline", "Monochrome Outline"}	--, "Monochrome"}
local blips = {	"default",
			"default light",
			"default sharp",
			"default soft",
			"PPblips",
			"PPblips light",
			"PPblips sharp",
			"PPblips soft",
			"PPblips comic",
		}

local defaults = {
	shape = "Square",
	blips = "PPblips",
	lsmfont = "Negotiate Free",
	fontFlag = "Outline",
	zoneText = true,
	zoneSize = 14,  --font size
	clockSize = 16,	--font size
	scale = 1,  --scale of the minimap
	mapPos = {x = -10, y = -10},  --offset of the minimap from the top right corner.  If you wish to change where the minimap is anchored, see the "Minimap Location and Size" section below  Note: this will move the quest tracker, etc, unless you use other addons to control those frames.
	bg = {r = 0, g = 0, b = 0},  --border colors (red, green, blue) -- values are a range from 0-1  (0,0,0 is black and 1,1,1 is white)
	mmAlpha = 1,
	combHide = false,
	alpha = 1,
	top = false,
	coords = true,
	clock = true,
	coordSize = 16,
	classbg = false,
	classfont = false,
	textOffset = 0,
	zoneTextOffset = 0,
	insets = 4,
	strata = "BACKGROUND",
	level = 2,
	hideTracking = false,
}


local function ClassColors()
	if db.classbg then
		PocketPlot:SetBackdropColor(classColor.r, classColor.g, classColor.b, db.alpha)
	else
		PocketPlot:SetBackdropColor(db.bg.r-.05,db.bg.g-.05,db.bg.b-.05,db.alpha)
	end
	if db.classfont then
		clockTime:SetTextColor(classColor.r, classColor.g, classColor.b)
		coords:SetTextColor(classColor.r, classColor.g, classColor.b)
	else
		clockTime:SetTextColor(1,1,1)
		coords:SetTextColor(1,1,1)
	end
end

local function CombatHide()
	if db.combHide then
		PocketPlot:RegisterEvent("PLAYER_REGEN_ENABLED")
		PocketPlot:RegisterEvent("PLAYER_REGEN_DISABLED")
		PocketPlot:SetScript("OnEvent", function(self,event)
					if event == "PLAYER_REGEN_DISABLED" then
						Minimap:Hide()
					else
						Minimap:Show()
					end
				end)
	else
		PocketPlot:UnregisterEvent("PLAYER_REGEN_ENABLED")
		PocketPlot:UnregisterEvent("PLAYER_REGEN_DISABLED")
	end
end

local function SetShape()
	Minimap:SetMaskTexture("Interface\\AddOns\\PocketPlot\\media\\"..db.shape)
	PocketPlot:SetBackdrop({ bgFile = "Interface\\AddOns\\PocketPlot\\media\\"..db.shape })
	if squareMasks[db.shape] then
		--so minimap buttons follow the square shape instead of round
		GetMinimapShape = function() return "SQUARE" end
	elseif roundMasks[db.shape] then
		GetMinimapShape = function() return "ROUND" end
	end
end

local function SetPosition(frame)
	if mover and mover:IsShown() then
		local r,_,a,x,y = mover:GetPoint()
		db[frame] = {["r"]=r, ["p"]="UIParent",["a"]=a,["x"]=x,["y"]=y}
	end
	_G[frame]:ClearAllPoints()
	_G[frame]:SetPoint(db[frame].r, _G[db[frame].p], db[frame].a, db[frame].x, db[frame].y)
	if not _G["PP_old"..frame] then
		_G["PP_old"..frame] = _G[frame].SetPoint
		_G[frame].SetPoint = function(self, a,b,c,d,e, ...)
				local a,b,c,d,e = db[frame].r, _G[db[frame].p], db[frame].a, db[frame].x, db[frame].y
				return _G["PP_old"..frame](self, a,b,c,d,e, ...)
			end
	end
end

local function MoveFrames(frame)
	if not mover then
		mover = CreateFrame("Frame", nil, UIParent)
		mover:SetBackdrop({bgFile ="Interface\\Buttons\\WHITE8x8",})
		mover:SetBackdropColor(.2,.2,.9,.6)
		mover:SetMovable(1)
		mover:SetFrameStrata("HIGH")
		mover:Hide()
		moverText = mover:CreateFontString(nil, "OVERLAY")
		moverText:SetFont("Fonts\\ARIALN.ttf", 15, "OUTLINE")
		moverText:SetParent(mover)
		moverText:SetPoint("CENTER")
		mover:SetScript("OnMouseDown", function() mover:StartMoving() end)
		mover:SetScript("OnMouseUp", function() mover:StopMovingOrSizing() SetPosition(movershown) end)
	end
	if frame == "None" then
		mover:SetScale(1)
		mover:Hide()
		mover:EnableMouse(false)
		return
	else
		mover:Show()
		moverText:SetText(frame)
		mover:EnableMouse(true)
		mover:SetScale(_G[frame]:GetScale())
		mover:ClearAllPoints()
		mover:SetAllPoints(frame)
	end
end

local function MapSetup()
	--restore moved frame positions--
	for i=1, #frames do
		if db[frames[i]] then
			SetPosition(frames[i])
		end
	end

--MINIMAP LOCATION AND SIZE
	Minimap:SetScale(db.scale)	--this says that the minimap is set to 90% scale
	Minimap:SetFrameStrata(db.strata)
	Minimap:SetFrameLevel(db.level)
	if db.mmAlpha < 1 and IsIndoors() then
		wasIndoors = true
	else
		--keep alpha of 1 while indoors - if mmAlpha is < 1, it will update when going outdoors
		Minimap:SetAlpha(db.mmAlpha)
	end
		
--ZONE TEXT
	MinimapZoneTextButton:SetParent("Minimap")
	MinimapZoneTextButton:ClearAllPoints()
	MinimapZoneTextButton:SetPoint("TOP", Minimap, "TOP", 0, -1 + db.zoneTextOffset)	--where the zone text is located
	MinimapZoneTextButton:SetFrameLevel(5)
	MinimapZoneText:ClearAllPoints()
	MinimapZoneText:SetPoint("CENTER")
	MinimapZoneText:SetFont(LSM:Fetch("font", db.lsmfont), db.zoneSize, db.fontFlag)	--font and font size for zone text
	if not db.zoneText then
		MinimapZoneTextButton:Hide()
	end

--MINIMAP ICONS/BLIPS
	if db.blips == "default" then
		Minimap:SetBlipTexture("Interface\\Minimap\\OBJECTICONSATLAS")
	else
		Minimap:SetBlipTexture("Interface\\AddOns\\PocketPlot\\media\\"..db.blips)
	end

--MAKE THE MINIMAP SQUARE WITH A THIN BORDER
	MinimapBorder:Hide()
	SetShape()
	PocketPlot:SetFrameLevel(1)
	PocketPlot:SetPoint("CENTER", Minimap, "CENTER")
	local dims = Minimap:GetWidth()
	PocketPlot:SetHeight(dims + db.insets)
	PocketPlot:SetWidth(dims + db.insets)

--MAKE THE MINIMAP ZOOM WITH MOUSEWHEEL
	MinimapZoomIn:Hide()
	MinimapZoomOut:Hide()
	Minimap:EnableMouseWheel(true)
	Minimap:SetScript("OnMouseWheel", function(_, zoom)
			if zoom > 0 then
				Minimap_ZoomIn()
			else
				Minimap_ZoomOut()
			end
		end)

--CLOCK FRAME
	if not IsAddOnLoaded("Blizzard_TimeManager") then
		LoadAddOn("Blizzard_TimeManager")
	end
	clockFrame, clockTime = TimeManagerClockButton:GetRegions()
	clockFrame:Hide()
	clockTime:SetFont(LSM:Fetch("font", db.lsmfont), db.clockSize, db.fontFlag)
	clockTime:SetAllPoints(TimeManagerClockButton)
	if not db.clock then	--toggle the clock, since CVar is removed in 4.0
		TimeManagerClockButton:Hide()
	end

--CALENDAR BUTTON/FRAME
	GameTimeFrame:SetAlpha(0)	--calendar button (old day/night indicator)  --Set alpha to 0 so that it's still hidden, but we'll see the ? flash for new invites
	GameTimeFrame:EnableMouse(false)	--so that we don't get the tooltip/click behavior still
	GameTimeCalendarInvitesTexture:SetParent("Minimap")	 --the ? texture
	--right click to open the calendar (but do it without pinging the map)
	local oldOnClick = Minimap:GetScript("OnMouseUp")
	Minimap:SetScript("OnMouseUp", function(self, click)
				if click == "RightButton" then
					if db.hideTracking and IsShiftKeyDown() then
						MiniMapTrackingButton:Click()
					else
						ToggleCalendar()
					end
				else
					oldOnClick(self)
				end
			end)
	
--TRACKING ICON/MENU
	--MiniMapTrackingButton:SetAlpha(0)
	MiniMapTrackingButtonBorder:SetAlpha(0)
	MiniMapTrackingBackground:Hide()
	MiniMapTracking:ClearAllPoints()
	MiniMapTracking:SetPoint("BOTTOMLEFT", Minimap, "BOTTOMLEFT", -4, -5)	--where the tracking icon/menu is located
	MiniMapTracking:SetScale(.9)
	MiniMapTrackingIcon:SetTexCoord(0.07,0.93,0.07,0.93)
	if db.hideTracking then
		MiniMapTracking:Hide()
	end

--BATTLEGROUND AND LFG QUEUE ICON
	QueueStatusMinimapButtonBorder:Hide()
	QueueStatusMinimapButton:ClearAllPoints()
	QueueStatusMinimapButton:SetPoint("BOTTOMLEFT", Minimap, "BOTTOMLEFT", 27, -4)	--where the queue icon is located
	--QueueStatusFrame:SetClampedToScreen(true)

--NEW MAIL ICON
	MiniMapMailBorder:Hide()
	MiniMapMailFrame:ClearAllPoints()
	MiniMapMailFrame:SetPoint("BOTTOMRIGHT", Minimap, "BOTTOMRIGHT", 4, -5)	--where the mail icon is located
	MiniMapMailIcon:SetTexture("Interface\\Minimap\\Tracking\\Mailbox.blp")

--VOICE CHAT ICON
	MiniMapVoiceChatFrameBorder:Hide()
	MiniMapVoiceChatFrameBackground:Hide()
	MiniMapVoiceChatFrame:ClearAllPoints()
	MiniMapVoiceChatFrame:SetPoint("BOTTOMRIGHT", Minimap, "BOTTOMRIGHT", -25, -5)
	
--MISC. THINGS TO HIDE
	MiniMapWorldMapButton:Hide()	--default keybinding for world map is M
	MinimapNorthTag:SetAlpha(0)	--Hide() wasn't working, but SetAlpha() is...
	MinimapBorderTop:Hide()
	
	CombatHide()	--Check to see if we should hide the minimap in combat

	--hide icons and zone text til mouseover
	--Minimap:SetScript("OnEnter", function() if db.mouseover then ShowOnMouseover() end end)
	--Minimap:SetScript("OnLeave", function() if db.mouseover then HideOnMouseOut() end end)
	
	MinimapCluster:EnableMouse(false)	--so you can still click the game world/turn in the upper right corner

--COORDINATES
	coords:SetFont(LSM:Fetch("font",db.lsmfont), db.coordSize, db.fontFlag)
	--thanks, Elviswind, for shadow code to match clock
	coords:SetShadowOffset(1,-1)
	coords:SetShadowColor(0,0,0,1)
	coords:SetAllPoints(coordframe)
	if not db.coords then
		coordframe:Hide()
	end
	coordframe:SetScript("OnEnter", function(self)
			GameTooltip:SetOwner(self, "ANCHOR_LEFT")
			GameTooltip:AddLine("Location Functions", 1,1,1)
			GameTooltip:AddLine("Click to display the world map.")
			GameTooltip:AddLine("Shift-click to input your coordinates into chat.")
			GameTooltip:Show()
		end)
	coordframe:SetScript("OnLeave", function() GameTooltip:Hide() end)
	coordframe:SetScript("OnMouseUp", function()
			if IsShiftKeyDown() then
				ChatFrame1EditBox:Insert("["..coords:GetText().."]")
			else
				ToggleFrame(WorldMapFrame)
			end
		end)
	local throttle = 0
	local coordx, coordy
	coordframe:SetScript("OnUpdate", function(self, elapsed)
			throttle = throttle + elapsed
			if throttle >= .3 then
				coordx,coordy = GetPlayerMapPosition("player")
				if coordx then
					coords:SetFormattedText("%.1f/%.1f", coordx*100, coordy*100)
				else
					coords:SetText("--/--")
				end
				throttle = 0
			end
		end)
	
--COLOR BORDER AND CLOCK/COORDS BY CLASS IF ENABLED
	ClassColors()
end

local function CoordPosition()
	local clockshown = db.clock
	local coordshown = db.coords
	TimeManagerClockButton:ClearAllPoints()
	coordframe:ClearAllPoints()
	if not db.top then
		if clockshown and not coordshown then
			TimeManagerClockButton:SetPoint("TOP", Minimap, "BOTTOM", 0, 0 + db.textOffset)
			clockTime:SetJustifyH("CENTER")
		end
		if coordshown and not clockshown then
			coords:SetJustifyH("CENTER")
			coordframe:SetPoint("TOP", Minimap, "BOTTOM", 0, 0 + db.textOffset)
		end
		if clockshown and coordshown then
			TimeManagerClockButton:SetPoint("TOPLEFT", Minimap, "BOTTOMLEFT", 2, 0 + db.textOffset)
			clockTime:SetJustifyH("LEFT")
			coords:SetJustifyH("RIGHT")
			coordframe:SetPoint("TOPRIGHT", Minimap, "BOTTOMRIGHT", 0, 0 + db.textOffset)
		end
	else
		if clockshown and not coordshown then
			TimeManagerClockButton:SetPoint("BOTTOM", Minimap, "TOP", 2, 0 + db.textOffset)
			clockTime:SetJustifyH("CENTER")
		end
		if coordshown and not clockshown then
			coords:SetJustifyH("CENTER")
			coordframe:SetPoint("BOTTOM", Minimap, "TOP", 0, 0 + db.textOffset)
		end
		if clockshown and coordshown then
			TimeManagerClockButton:SetPoint("BOTTOMLEFT", Minimap, "TOPLEFT", 0, 0 + db.textOffset)
			clockTime:SetJustifyH("LEFT")
			coords:SetJustifyH("RIGHT")
			coordframe:SetPoint("BOTTOMRIGHT", Minimap, "TOPRIGHT", 0, 0 + db.textOffset)
		end
	end
end

local function SetUpDB()
	if PocketPlotPCDB.charSpec then
		--set defaults if new charSpec DB
		for k,v in pairs(defaults) do
			if type(PocketPlotPCDB[k]) == "nil" then
				PocketPlotPCDB[k] = v
			end
		end
		db = PocketPlotPCDB
	else
		db = PocketPlotDB
	end
end


options = {
	name = "PocketPlot Options",
	type = "group",
	args = {
		header0 = {
			name = "General options",
			type = "header",
			order = 0,
		},
		shape = {
			name = "Minimap Shape",
			desc = "Set the shape of the minimap.",
			type = "select",
			values = allshapes,
			get = function()
						for k, v in pairs(allshapes) do
							if db.shape == v then
								return k
							end
						end
					end,
			set = function(_,key)
						db.shape = allshapes[key]
						SetShape()
						ClassColors()
					end,
			order = 1,
		},
		blips = {
			name = "Tracking Blips",
			desc = "Set the style of tracking blips (POI) on the minimap.",
			type = "select",
			values = blips,
			get = function()
						for k, v in pairs(blips) do
							if db.blips == v then
								return k
							end
						end
					end,
			set = function(_,key)
						db.blips = blips[key]
						if db.blips == "default" then
							Minimap:SetBlipTexture("Interface\\Minimap\\OBJECTICONS")
						else
							Minimap:SetBlipTexture("Interface\\AddOns\\PocketPlot\\media\\"..db.blips)
						end
					end,
			order = 2,
		},
		scale = {
			name = "Minimap Scale",
			desc = "Set the scale of the minimap.",
			type = "range",
			min = .25,
			max = 2,
			step = .05,
			get = function() return db.scale end,
			set = function(_,value)
						db.scale = value
						Minimap:SetScale(value)
					end,
			order = 3,
		},
		mmAlpha = {
			name = "Minimap Alpha",
			desc = "Set the transparency of the minimap when outdoors. Does not take effect when indoors.",
			type = "range",
			min = 0.05,
			max = 1,
			step = .05,
			get = function() return db.mmAlpha end,
			set = function(_,value)
						db.mmAlpha = value
						if not IsIndoors() then
							Minimap:SetAlpha(value)
						else
							wasIndoors = true
						end
						if db.mmAlpha < 1 then
							PocketPlot:RegisterEvent("ZONE_CHANGED_INDOORS")
							PocketPlot:RegisterEvent("ZONE_CHANGED")
						else
							PocketPlot:RegisterEvent("ZONE_CHANGED_INDOORS")
							PocketPlot:RegisterEvent("ZONE_CHANGED")
						end
					end,
			order = 4,
		},
		strata = {
			name = "Minimap Strata",
			desc = "Set the strata of the minimap and how it layers with other elements in your interface.",
			type = "select",
			values = stratae,
			get = function()
						for k, v in pairs(stratae) do
							if db.strata == v then
								return k
							end
						end
					end,
			set = function(_,key)
						db.strata = stratae[key]
						Minimap:SetFrameStrata(db.strata)
					end,
			order = 5,
		},
		level = {
			name = "Strata Level",
			desc = "Nudge the minimap up and down different levels on its frame strata.",
			type = "range",
			min = 1,
			max = 10,
			step = 1,
			get = function() return db.level end,
			set = function(_,value)
						db.level = value
						Minimap:SetFrameLevel(db.level)
					end,
			order = 6,
		},
		combHide = {
			name = "Hide in Combat",
			desc = "Hide the minimap when in combat.",
			type = "toggle",
			get = function() return db.combHide end,
			set = function()
						db.combHide = not db.combHide
						CombatHide()
					end,
			order = 7,
		},
		header1 = {
			name = "Border options",
			type = "header",
			order = 8,
		},
		border = {
			name = "Border Color",
			desc = "Select a color for the minimap's border.",
			type = "color",
			disabled = function() return db.classbg end,
--			hasAlpha = true,
			get = function() return db.bg.r, db.bg.g, db.bg.b end,
			set = function(_,r,g,b)
						db.bg.r,db.bg.g,db.bg.b = r,g,b
						ClassColors()
					end,
			order = 9,
		},
		classbg = {
			name = "Class colored border",
			desc = "Color the minimap border by your class.",
			type = "toggle",
			get = function() return db.classbg end,
			set = function()
						db.classbg = not db.classbg
						ClassColors()
					end,
			order = 10,
		},
		insets = {
			name = "Border size",
			desc = "Set the width of the border around the minimap.",
			type = "range",
			min = .5,
			max = 10,
			step = .5,
			get = function() return db.insets end,
			set = function(_,value)
						db.insets = value
						local dims = Minimap:GetWidth()
						PocketPlot:SetHeight(dims + value)
						PocketPlot:SetWidth(dims + value)
					end,
			order = 11,
		},
		alpha = {
			name = "Border Alpha",
			desc = "Set the alpha for the minimap border.",
			type = "range",
			min = 0,
			max = 1,
			step = .05,
			get = function() return db.alpha end,
			set = function(_,alpha)
						db.alpha = alpha
						ClassColors()
					end,
			order = 12,
		},
		header2 = {
			name = "Text options",
			type = "header",
			order = 13,
		},
		font = {
			name = "Font",
			desc = "Select a font to use.",
			type = "select",
			dialogControl = "LSM30_Font",
			values = fonts,
			get = function()
						return db.lsmfont
					end,
			set = function(_,font)
						db.lsmfont = font
						clockTime:SetFont(LSM:Fetch("font", db.lsmfont), db.clockSize, db.fontFlag)
						MinimapZoneText:SetFont(LSM:Fetch("font", db.lsmfont), db.zoneSize, db.fontFlag)
						coords:SetFont(LSM:Fetch("font",db.lsmfont), db.coordSize, db.fontFlag)
					end,
			order = 14,
		},
		fontFlag = {
			name = "Font Flag",
			desc = "Set how to alter the displayed font.",
			type = "select",
			values = fontFlags,
			get = function()
						for k, v in pairs(fontFlags) do
							if db.fontFlag == v then
								return k
							end
						end
					end,
			set = function(_,key)
						db.fontFlag = fontFlags[key]
						clockTime:SetFont(LSM:Fetch("font", db.lsmfont), db.clockSize, db.fontFlag)
						MinimapZoneText:SetFont(LSM:Fetch("font", db.lsmfont), db.zoneSize, db.fontFlag)
						coords:SetFont(LSM:Fetch("font",db.lsmfont), db.coordSize, db.fontFlag)
					end,
			order = 15,
		},
		zonesize = {
			name = "Zone Text Size",
			desc = "Change the font size of the Zone Text.",
			type = "range",
			min = 6,
			max = 24,
			step = 1,
			get = function() return db.zoneSize end,
			set = function(_,size) 
						db.zoneSize = size
						MinimapZoneText:SetFont(LSM:Fetch("font",db.lsmfont), db.zoneSize, db.fontFlag)
					end,
			order = 16,
		},
		clocksize = {
			name = "Clock Text Size",
			desc = "Change the font size of the clock.",
			type = "range",
			min = 6,
			max = 24,
			step = 1,
			get = function() return db.clockSize end,
			set = function(_,size) 
						db.clockSize = size
						clockTime:SetFont(LSM:Fetch("font",db.lsmfont), db.clockSize, db.fontFlag)
					end,
			order = 17,
		},
		coordsize = {
			name = "Coords Text Size",
			desc = "Change the font size of the coordinates.",
			type = "range",
			min = 6,
			max = 24,
			step = 1,
			get = function() return db.coordSize end,
			set = function(_,size) 
						db.coordSize = size
						coords:SetFont(LSM:Fetch("font",db.lsmfont), db.coordSize, db.fontFlag)
					end,
			order = 18,
		},
		classfont = {
			name = "Class colored text",
			desc = "Color the clock and coordinates by your class.",
			type = "toggle",
			get = function() return db.classfont end,
			set = function()
						db.classfont = not db.classfont
						ClassColors()
					end,
			order = 19,
		},
		coords = {
			name = "Display coords",
			desc = "Toggle showing the coordinates display.",
			type = "toggle",
			get = function() return db.coords end,
			set = function()
						db.coords = not db.coords
						if db.coords then
							coordframe:Show()
						else
							coordframe:Hide()
						end
						CoordPosition()
					end,
			order = 20,
		},
		clock = {
			name = "Display clock",
			desc = "Toggle showing the clock.",
			type = "toggle",
			get = function() return db.clock end,
			set = function()
						db.clock = not db.clock
						if db.clock then
							TimeManagerClockButton:Show()
						else
							TimeManagerClockButton:Hide()
						end
						CoordPosition()
					end,
			order = 21,
		},
		zoneText = {
			name = "Display zone text",
			desc = "Toggle showing the zone text.",
			type = "toggle",
			get = function() return db.zoneText end,
			set = function()
						db.zoneText = not db.zoneText
						if db.zoneText then
							MinimapZoneTextButton:Show()
						else
							MinimapZoneTextButton:Hide()
						end
					end,
			order = 22,
		},
		top = {
			name = "Clock/coords on top",
			desc = "Toggle showing the clock and coordinates above or below the map.",
			type = "toggle",
			get = function() return db.top end,
			set = function()
						db.top = not db.top
						CoordPosition()
					end,
			order = 23,
		},
		textOffset = {
			name = "Clock/Coord Offset",
			desc = "Vertical offset for the clock and coordinates.",
			type = "range",
			min = -50,
			max = 50,
			step = 1,
			get = function() return db.textOffset end,
			set = function(_,offset) 
						db.textOffset = offset
						CoordPosition()
					end,
			order = 23.5,
		},
		zoneTextOffset = {
			name = "Zone Text Offset",
			desc = "Vertical offset for the zone text.",
			type = "range",
			min = -50,
			max = 50,
			step = 1,
			get = function() return db.zoneTextOffset end,
			set = function(_,offset) 
						db.zoneTextOffset = offset
						MinimapZoneTextButton:ClearAllPoints()
						MinimapZoneTextButton:SetPoint("TOP", Minimap, "TOP", 0, -1 + db.zoneTextOffset)
					end,
			order = 23.75,
		},
		header3 = {
			name = "Frame Locations",
			type = "header",
			order = 24,
		},
		movers = {
			name = "Enable mover for...",
			desc = "Shows an anchor to move the selected frame.",
			type = "select",
			values = frames,
			get = function()
						if movershown then
							for k,v in pairs(frames) do
								if v == movershown then
									return k
								end
							end
						else
							return 1	--key for "None" in frames table
						end
					end,
			set = function(_,frame)
						movershown = frames[frame]
						MoveFrames(movershown)
					end,
			order = 25,
		},
		reset = {
			name = "Restore Positions",
			desc = "Clicking this will restore all frames to their default positions.\n\n|c00E30016WARNING:|r Your UI will be reloaded in the process!",
			type = "execute",
			confirm = true,
			func = function()
						for i=1, #frames do
							db[frames[i]] = nil
						end
						ReloadUI()
					end,
			order = 26,
		},
		hideTracking = {
			name = "Hide Tracking Button",
			desc = "Hides the minimap tracking button. Open the menu by using Shift-Right-Click on the minimap.",
			type = "toggle",
			get = function() return db.hideTracking end,
			set = function()
						db.hideTracking = not db.hideTracking
						if db.hideTracking then
							MiniMapTracking:Hide()
						else
							MiniMapTracking:Show()
						end
					end,
			order = 26.3,
		},
		div3 = {
			name = " ",
			type = "description",
			order = 26.4,
		},
		nudgehelp = {
			name = "Nudge the selected mover...",
			type = "description",
			order = 26.5,
		},
		nudgeL = {
			name = "Left",
			desc = "Nudge the frame 1px to the left.",
			type = "execute",
			width = "half",
			disabled = function() return movershown == "None" or movershown == nil end,
			func = function()
						if not db[movershown] then
							SetPosition(movershown)
						end
						local frame = _G[movershown]
						db[movershown].x = db[movershown].x - 1
						frame:ClearAllPoints()
						frame:SetPoint(db[movershown].r, db[movershown].p, db[movershown].a, db[movershown].x, db[movershown].y)
						mover:ClearAllPoints()
						mover:SetAllPoints(frame)
					end,
			order = 27,
		},
		nudgeR = {
			name = "Right",
			desc = "Nudge the frame 1px to the right.",
			type = "execute",
			width = "half",
			disabled = function() return movershown == "None" or movershown == nil end,
			func = function()
						if not db[movershown] then
							SetPosition(movershown)
						end
						local frame = _G[movershown]
						db[movershown].x = db[movershown].x + 1
						frame:ClearAllPoints()
						frame:SetPoint(db[movershown].r, db[movershown].p, db[movershown].a, db[movershown].x, db[movershown].y)
						mover:ClearAllPoints()
						mover:SetAllPoints(frame)
					end,
			order = 28,
		},
		nudgeU = {
			name = "Up",
			desc = "Nudge the frame 1px towards the top of the screen.",
			type = "execute",
			width = "half",
			disabled = function() return movershown == "None" or movershown == nil end,
			func = function()
						if not db[movershown] then
							SetPosition(movershown)
						end
						local frame = _G[movershown]
						db[movershown].y = db[movershown].y + 1
						frame:ClearAllPoints()
						frame:SetPoint(db[movershown].r, db[movershown].p, db[movershown].a, db[movershown].x, db[movershown].y)
						mover:ClearAllPoints()
						mover:SetAllPoints(frame)
					end,
			order = 29,
		},
		nudgeD = {
			name = "Down",
			desc = "Nudge the frame 1px towards the bottom of the screen.",
			type = "execute",
			width = "half",
			disabled = function() return movershown == "None" or movershown == nil end,
			func = function()
						if not db[movershown] then
							SetPosition(movershown)
						end
						local frame = _G[movershown]
						db[movershown].y = db[movershown].y - 1
						frame:ClearAllPoints()
						frame:SetPoint(db[movershown].r, db[movershown].p, db[movershown].a, db[movershown].x, db[movershown].y)
						mover:ClearAllPoints()
						mover:SetAllPoints(frame)
					end,
			order = 30,
		},
		div4 = {
			name = " ",
			type = "description",
			order = 31,
		},
		header4 = {
			name = "Profile",
			type = "header",
			order = 32,
		},
		charSpec = {
			name = "Character specific settings",
			desc = "Have this character use their own profile.  If checked, any changes made will not affect other characters.\n\n|c00E30016WARNING:|r Your UI will be reloaded in the process!",
			type = "toggle",
			width = "full",
			confirm = true,
			get = function() return PocketPlotPCDB.charSpec end,
			set = function()
						PocketPlotPCDB.charSpec = not PocketPlotPCDB.charSpec
						ReloadUI()
					end,
			order = 33,
		},
		copyProfile = {
			name = "Copy from Default",
			desc = "Copy all settings from the default, global profile to this character's profile.  This will not effect other characters' specific profiles.\n\n|c00E30016WARNING:|r Your UI will be reloaded in the process!",
			type = "execute",
			confirm = true,
			disabled = function() return not PocketPlotPCDB.charSpec end,
			func = function()
						PocketPlotPCDB = PocketPlotDB
						PocketPlotPCDB.charSpec = true
						ReloadUI()
					end,
			order = 34,
		},
		resetProfile = {
			name = "Profile Reset",
			desc = "Reset this profile back to the out-of-the-box settings.  If you reset the character specific profile, the global profile will be untouched, and vice versa.  This will not effect other character specific profiles.\n\n|c00E30016WARNING:|r Your UI will be reloaded in the process!",
			type = "execute",
			confirm = true,
			func = function()
						if PocketPlotPCDB.charSpec then
							PocketPlotPCDB = {charSpec = true}
						else
							PocketPlotDB = {}
						end
						ReloadUI()
					end,
			order = 35,
		},
	},
}


local function PlayerLogin()
	PocketPlotDB = PocketPlotDB or {}
	PocketPlotPCDB = PocketPlotPCDB or {}
		if PocketPlotPCDB.charSpec == nil then
			PocketPlotPCDB.charSpec = false
		end
	for k,v in pairs(defaults) do
	    if type(PocketPlotDB[k]) == "nil" then
	        PocketPlotDB[k] = v
	    end
	end
	SetUpDB()
	
	classColor = CUSTOM_CLASS_COLORS and CUSTOM_CLASS_COLORS[class] or RAID_CLASS_COLORS[class]
	
	if CUSTOM_CLASS_COLORS then
		CUSTOM_CLASS_COLORS:RegisterCallback(ClassColors)
	end

	LibStub("AceConfig-3.0"):RegisterOptionsTable("PocketPlot", options)
	PocketPlot.optionsFrame = LibStub("AceConfigDialog-3.0"):AddToBlizOptions("PocketPlot", "PocketPlot")
	SlashCmdList["POCKETPLOT"] = function()
		InterfaceOptionsFrame_OpenToCategory("PocketPlot")
		InterfaceOptionsFrame_OpenToCategory("PocketPlot")
	end
	SLASH_POCKETPLOT1 = "/pocketplot"
	SLASH_POCKETPLOT2 = "/pp"
	
	MapSetup()
	CoordPosition()
	
	if db.mmAlpha < 1 then
		PocketPlot:RegisterEvent("ZONE_CHANGED_INDOORS")
		PocketPlot:RegisterEvent("ZONE_CHANGED")
	end
		
	PlayerLogin = nil
end

--this is here instead of in the above function because Grid would throw some dumb error that shouldn't have been occuring, imo
LSM:Register("font", "Negotiate Free", "Interface\\AddOns\\PocketPlot\\media\\negotiate_free.ttf")


PocketPlot:RegisterEvent("PLAYER_LOGIN")
PocketPlot:SetScript("OnEvent", function(self,event)
	if event == "PLAYER_LOGIN" then
		PlayerLogin()
	elseif event == "ZONE_CHANGED_INDOORS" then
		Minimap:SetAlpha(1)
		Minimap:SetZoom(1)
		Minimap:SetZoom(0)
		wasIndoors = true
	else	--"ZONE_CHANGED"
		if wasIndoors then
			if not IsIndoors() then
				Minimap:SetAlpha(db.mmAlpha)
				wasIndoors = false
			end
		end
	end
end)
