local AceLocale = LibStub:GetLibrary("AceLocale-3.0")
local L = AceLocale:NewLocale("Raven", "zhTW")
if not L then return end

-- Main.lua
L["Raven"] = true
L["Raven left click"] = "點擊|cffffff00左鍵|r 以 打開/關閉配置菜單"
L["Raven right click"] = "點擊|cffffff00右鍵|r 以 鎖定/解鎖所有計時條組"
L["Raven shift left click"] = "|cffffff00Shift+左鍵|r 以 啟用/禁用 Raven"
L["Raven shift right click"] = "|cffffff00Shift+右鍵|r 以 顯示/隱藏系統默認BUFF"
L["Shared Potion Cooldown"] = "共享藥水冷卻"
L["Shared Elixir Cooldown"] = "共享藥劑冷卻"
L["Global Cooldown"] = "公共冷卻"
L["GCD"] = true -- abbreviation for Global Cooldown
L["Blood Rune"] = "鮮血符文"
L["Unholy Rune"] = "邪穢符文"
L["Frost Rune"] = "冰霜符文"
L["Death Rune"] = "死亡符文"
L["Failed to load "] = "加載失敗"
L["Not Tracking"] = "沒有監視"
L["Potions"] = "藥水"
L["Elixirs"] = "藥劑"
L["Fire Totem"] = "火圖騰"
L["Water Totem"] = "水圖騰"
L["Earth Totem"] = "大地圖騰"
L["Air Totem"] = "空氣圖騰"

-- Profile.lua
L["Frost School"] = "冰霜抗性"
L["Fire School"] ="火焰抗性"
L["Nature School"] = "自然抗性"
L["Shadow School"] = "暗影抗性"
L["Arcane School"] = "奧術抗性"
L["Holy School"] = "神聖抗性"
L["Physical School"] = "物理抗性"
L["Locked out of Frost school of magic."] = "鎖定冰霜抗性"
L["Locked out of Fire school of magic."] = "鎖定火焰抗性"
L["Locked out of Nature school of magic."] ="鎖定自然抗性"
L["Locked out of Shadow school of magic."] = "鎖定暗影抗性"
L["Locked out of Arcane school of magic."] ="鎖定奧術抗性"
L["Locked out of Holy school of magic."] = "鎖定神聖抗性"
L["Locked out of Physical school of magic."] = "鎖定物理抗性"

-- Bars.lua
L["Test Bar"] = "測試計時條組"
L["Custom Bar Group"] = true
L["Auto Bar Group"] = true
L["Anchor attached"] = '|cffffff00附著|r 到 "'
L["Anchor left click 1"] = "點擊|cffffff00左鍵|r 解除附著以移動錨點"
L["Anchor left click 2"] = "點擊|cffffff00左鍵|r 以移動錨點"
L["Anchor right click"] = "點擊|cffffff00右鍵|r 以鎖定並隱藏錨點"
L["Anchor shift left click"] = "|cffffff00Shift+左鍵|r 以顯示/隱藏測試條"
L["Anchor shift right click"] = "|cffffff00Shift+右鍵|r 以顯示/隱藏方向"
L["Anchor alt left click"] = "|cffffff00Alt+左鍵|r 以打開/關閉配置菜單"
L["Anchor alt right click"] = "|cffffff00Alt+右鍵|r 以配置循環"
L["Add filter"] = function(a, b, n) return string.format("Raven: \"%s\"已添加到 %s 過濾列表，計時條組： \"%s\"", a, b, n) end
L["Header click"] = "點擊|cffffff00右鍵|r 以隱藏該單位直到重新選擇目標或下一個buff/debuff由玩家應用"
L["<Applied by "] = "<應用 "

-- Conditions.lua
-- These strings are used in GetConditionText function to produce a detail condition description.
-- Many are also used in the options panel in the Conditions tab for defining tests.
L["Player Status"] = "玩家狀態"
L["Target Status"] = "目標狀態"
L["Focus Status"] = "焦點狀態"
L["All Buffs"] = "所有BUFF"
L["Any Buffs"] = "任意BUFF"
L["Buff Time Left"] = "BUFF剩余時間"
L["Buff Count"] = "BUFF層數"
L["Buff Type"] = "BUFF類型"
L["All Debuffs"] = "所有Debuff"
L["Any Debuffs"] = "任意Debuff"
L["Debuff Time Left"] = "DEBUFF剩余時間"
L["Debuff Count"] = "DEBUFF層數"
L["Debuff Type"] = "DEBUFF類型"
L["All Cooldowns"] = "所有冷卻"
L["Spell Ready"] = "法術就緒"
L["Spell Casting"] = "法術釋放中"
L["Item Ready"] = "物品就緒"
L["Condition Name"] = function(name) return string.format("|cFF7adbf2條件名稱:|r %s", name) end
L["(not found)"] = "(未找到)"
L["Disable String"] = " |cFFef2929[禁用]|r"
L["In Combat"] = "戰鬥中"
L["Out Of Combat"] ="戰鬥外"
L["Is Resting"] = "休息中"
L["Not Resting"] = "休息外"
L["Is Stealthed"] = "潛行"
L["Not Stealthed"] = "潛行外"
L["Is Fishing"] = "遊泳中"
L["Not Fishing"] = "遊泳外"
L["Is Mounted"] = "載具上"
L["Not Mounted"] = "載具外"
L["Is PvP"] = "PVP開啟"
L["Not PvP"] = "PVP關閉"
L["In Group"] = "在團隊中"
L["Not In Group"] = "不在團隊中"
L["In Party"] = "在隊伍中"
L["Not In Party"] = "不在隊伍中"
L["In Raid"] = "在Raid中"
L["Not In Raid"] = "不在Raid中"
L["In Instance"] = "在副本中"
L["Not In Instance"] = "不在副本中"
L["In Arena"] = "在競技場中"
L["Not In Arena"] = "不在競技場中"
L["In Battleground"] = "在戰場中"
L["Not In Battleground"] = "不在戰場中"
L["Primary Talents"] = "主天賦"
L["If checked, bar group is shown when the player is in primary talents."] = "當玩家使用主天賦樹時啟用該計時條組"
L["Secondary Talents"] = "副天賦"
L["If checked, bar group is shown when the player is in secondary talents."] = "當玩家使用副天賦樹時啟用該計時條組"
L["Has Pet"] = "有寵物"
L["No Pet"] = "無寵物"
L["Level String"] = function(x, level) return string.format("等級 %s %d", x, level) end
L["Health String"] = function(x, minHealth) return string.format("生命值 %s %d%%", x, minHealth) end
L["Power String"] = function(x, minPower) return string.format("能量值 %s %d", x, minPower) end
L["Holy Power String"] = function(x, minPower) return string.format("聖能 %s %d", x, minPower) end
L["Shards String"] = function(x, minShards) return string.format("靈魂碎片 %s %d", x, minShards) end
L["Eclipse String"] = function(x, power) return string.format("月蝕能量 %s %d", x, power) end
L["Solar Eclipse"] = true
L["Lunar Eclipse"] = true
L["Combo Pts String"] = function(x, minComboPoints) return string.format("連擊點: %s %d", x, minComboPoints) end
L["Stance String"] = function(stance) return string.format("姿態 = \"%s\"", stance) end
L["Talent String"] = function(talent) return string.format("天賦 = \"%s\"", talent) end
L["Blood"] = "鮮血"
L["Frost"] = "冰霜"
L["Unholy"] = "邪穢"
L["Rune"] = "符文"
L["Runes"] = "符文"
L["Mainhand String"] = function(level) return string.format("主手武器 >= %d", level) end
L["Offhand String"] = function(level) return string.format("副手武器 >= %d", level) end
L["Ranged String"] = function(level) return string.format("遠程武器 >= %d", level) end
L["Exists"] = "存在"
L["Not Exists"] = "不存在"
L["Is Player"] = "是玩家"
L["Not Player"] = "不是玩家"
L["Is Enemy"] = "敵對"
L["Not Enemy"] = "非敵對"
L["Is Friendly"] = "友善的"
L["Not Friendly"] = "非友善的"
L["Is Dead"] = "死亡"
L["Not Dead"] = "未死亡"
L["In Range"] = "範圍內"
L["Out Of Range"] = "範圍外"
L["Is "] = "是"
L["Not "] = "不是"
L["On"] = "在"
L["Not All Active"] = "不全激活"
L["All Active"] = "全部激活"
L["None Active"] = "不激活"
L["Any Active"] = "任意激活"
L["Cast By Player"] = "由玩家釋放"
L["Cast By Other"] = "由其他人釋放"
L["Cast By Anyone"] = "由任何人釋放"
L["Missing"] = "丟失"
L["Present"] = "目前"
L["Less Than"] = "小於"
L["Or More"] = "或更多"
L["Seconds"] = "秒"
L["Seconds Or More"] = "秒或更長"
L["Test Global Cooldown"] = "測試GCD"
L["Ignore Global Cooldown"] = "忽略GCD"
L["Ignore Spell Usable"] = "忽略法術可用"
L["Test Spell Usable"] = "測試法術可用"
L["Target In Range"] = "目標在範圍內"
L["Target Out Of Range"] = "目標在範圍外"
L["Cast By"] = "釋放者:"
L["Item Is Not Ready"] = "物品未就緒"
L["Item Is Ready"] = "物品就緒"
L["Dependencies String"] = " \n|cFF7adbf2依賴於:|r"
L["True Color String"] = "|cFF8ae234真|r"
L["False Color String"] = "|cFFef2929假|r"
L["Logic AND String"] = "\n|cFF7adbf2以與邏輯進行評估測試, "
L["Logic OR String"] = "\n|cFF7adbf2以或邏輯進行評估測試, "
L["Toggle String"] = "顯示結果|r"
L["No Toggle String"] = "不顯示結構|r"
L["Set Result True"] = "\n|cFF7adbf2結果設為真|r"
L["Set Result False"] = "\n|cFF7adbf2結果設定為假|r"
L["Normal"] = "普通"
L["Boss"] = true
L["Elite"] = "精英"
L["Rare"] = "稀有"
L["Rare Elite"] = "稀有精英"

-- Nest.lua
L["Right-to-left bars, label left, icon left"] ="從右到左,文字在左邊,圖標在左邊"
L["Left-to-right bars, label left, icon left"] ="從左到右,文字在左邊,圖標在左邊"
L["Right-to-left bars, label right, icon left"] = "從右到左,文字在右邊,圖標在左邊"
L["Left-to-right bars, label right, icon left"] = "從左到右,文字在右邊,圖標在左邊"
L["Right-to-left bars, label left, icon right"] = "從右到左,文字在左邊,圖標在右邊"
L["Left-to-right bars, label left, icon right"] = "從左到右,文字在左邊,圖標在右邊"
L["Right-to-left bars, label right, icon right"] = "從右到左,文字在右邊,圖標在右邊"
L["Left-to-right bars, label right, icon right"] = "從左到右,文字在左邊,圖標在右邊"
L["Icons in rows, with right-to-left mini-bars"] = true
L["Icons in rows, with left-to-right mini-bars"] = true
L["Icons in columns, right-to-left mini-bars"] = true
L["Icons in columns, left-to-right mini-bars"] = true
L["Icons on horizontal timeline, no mini-bars"] = true
L["Icons on vertical timeline, no mini-bars"] = true

-- L["Buff button right click"] = "|cffffff00Right-click|r to cancel this buff"

-- Shared cooldowns
L["Portals"] = "頭像"
L["Summon Infernal/Doomguard"] = "召喚地獄火/末日守衛"
L["Shouts"] = true
L["Pummel/Shield Bash"] = "拳擊/盾擊"
L["Crusader/Hammer"] = "十字軍/錘"
L["Fire Traps"] = "爆炸陷阱"
L["Frost Traps"] = "冰霜陷阱"
L["Earth/Fire Elementals"] = "大地/火焰元素"
L["Shocks"] = "沖擊"

-- All strings from here down are used for the options panel and are referenced in Options.lua.

L["Not valid string"] = function(n) return string.format("Raven: 警告 \"%s\" 不是一個有效的法術名稱", n) end
L["Circular string"] = function(a, b) return string.format("Raven: \"%s\" 不能附著在 \"%s\" 因為會創建一個循環依賴", a, b) end
L["Dup bar group string"] = function(n) return string.format("重復的名稱！ \n已經有一個命名為 %s 的計時條組. 希望覆蓋它嗎?", n) end
L["Dup condition string"] = function(n) return string.format("重復的名稱 \n已經有一個命名為 %s的條件 .希望覆蓋它嗎?", n) end
L["is a duplicate of an existing bar label"] = "現有標簽欄重復"
L["does not begin with a letter or contains restricted characters"] = "不能以字母開頭,或包含了非法字符"
L["Type and condition string"] = function(t, a) return string.format("|cFF7adbf2類型:|r %s\n|cFF7adbf2條件:|r %s", t, a) end
L["Associated spell string"] = function(s) return string.format("\n|cFF7adbf2關聯的法術:|r %s", s) end
L["Action type source string"] = function(a, t, s) return string.format("|cFF7adbf2動作:|r %s\n|cFF7adbf2類型:|r %s\n|cFF7adbf2來源:|r %s", a, t, s) end
L["Type source string"] = function(t, s) return string.format("|cFF7adbf2類型:|r %s\n|cFF7adbf2來源:|r %s", t, s) end
L["Action on cast by string"] = function(m, c) return string.format("\n|cFF7adbf2動作:|r %s\n|cFF7adbf2釋放者:|r %s", m, c) end

-- Blizzard Addons option table
L["Configure"] = "配置"
L["Open Raven's standalone options panel."] = "開啟Raven的獨立配置面板"

-- Setup tab
L["Setup"] = "安裝"
L["Enable Raven"] ="啟用Raven"
L["If checked, Raven is enabled, otherwise all features are disabled."] = "啟用Raven，除非所有模塊被禁用"
L["Hide Blizzard Buffs"] = "隱藏系統自帶BUFF"
L["If checked, Raven will hide the default user interface for buffs."] = "隱藏系統自帶的BUFF界面"
L["Hide Blizzard Runes"] = "隱藏系統自帶的符文條"
L["If checked, Raven will hide the default user interface for runes."] = "隱藏系統自帶服務條"
L["Mute Raven Sound"] = "Raven禁音"
L["If checked, Raven will not play sound effects."] = "Raven將不播放音效"
L["Minimap Icon"] = "小地圖圖標"
L["If checked, Raven will add an icon to the minimap."] ="顯示小地圖圖標"
L["Standard Bar Groups"] = "默認的計時條組"
L["Anchor description"] = "Raven 可以讓你顯示buff\debuff\冷卻的圖標和監視條 " ..
	'你可以在 "計時條組" 標簽下進行設置,以配置一個個性化的界面. ' ..
	"想要開始的話,很簡單,用列出默認的計時條組開始下手吧. " ..
	'選擇你喜歡的計時條組,然後按"以條創建"或"以圖標創建". ' ..
	'你可以像這樣配置多次以創造出一個圖標和條的組合.\n'
L["All buffs on you, sort by time left."] = "你身上的所有BUFF,以剩余時間排列"
L["Short Buffs"] = "排列BUFF"
L["Buffs on you lasting less than 2 minutes."] = "你身上的小於2分鐘的BUFF"
L["Long Buffs"] = "長時間BUFF"
L["Buffs on you lasting at least 2 minutes, sort and color by class."] ="你身上的長於兩分鐘的BUFF將按照職業著色"
L["Debuffs"] = true
L["Debuffs on you."] ="你身上的DEBUFF"
L["Cooldowns"] = "冷卻"
L["Cooldowns on your spells and trinkets lasting at least 2 seconds."] = "法術或飾品的大於2秒的冷卻時間"
L["Target"] = "目標"
L["Buffs and debuffs you cast on the target."] = "目標身上由你釋放的buff和debuff"
L["Focus"] = "焦點"
L["Buffs and debuffs you cast on the focus."] = "焦點身上由你釋放的buff和debuff"
L["Totems"] = "圖騰"
L["Totem tracker bars for Shaman players."] = "薩滿的圖騰監視"
L["Rune cooldown bars for Death Knight players."] = "DK的符文監視"
L["Notifications"] = "提示"
L["Common class-specific notifications."] = "默認的提示"
L["Buff Tracker"] = "Buff監視"
L["Buff tracker string"] = "你給目標釋放的Buff (例如, HoT 計時)."
L["Debuff Tracker"] = "Debuff監視"
L["Debuff tracker string"] = "你給目標釋放的Debuff (例如, DoT 計時)."
L["Timeline string"] = "法術和飾品冷卻的時間線設定."
L["Create As Bars"] ="以條創建"
L["Create bars string"] = "將選定的計時條組以監視條創建 "
L["Create As Icons"] = "以圖標創建"
L["Create icons string"] = "將選定的計時條組以監視圖標創建."
L["Configure string"] = "創建計時條組\n你確定創建一個計時條組,並覆蓋相同名字的計時條組?"
L["Reset selections."] = "重置"
L["Link"] = "鏈接"
L["Link settings string"] = "將選定的計時條組與配置文件中其他具有相同名稱的計時條組鏈接在一起。被鏈接的計時條組具有相同的位置、布局和外觀選項。"
L["Delete the selected bar groups."] = "刪除選定的計時條組"
L["Delete standard string"] = "刪除計時條組\n確定刪除選定的計時條組?"
L["Bar Group Anchors"] = "計時條組錨點"
L["Bar group anchor string"] = "計時條組錨點決定將在哪裏顯示監視條 " ..
	"錨點的提示將列出有幫助的快捷方式(例如:在錨點上改變監視條的增長方向\測試等). " ..
	"你可以點擊左鍵以拖動錨點。 " ..
	"當你對位置滿意時你可以點擊右鍵鎖定. " ..
	'鎖定的錨點將被隱藏--點擊 "解鎖全部錨點"按鈕以顯示他們.\n'
L["Lock All Anchors"] = "鎖定全部錨點"
L["Lock and hide the anchors for all bar groups."] = "鎖定並隱藏全部計時條組的錨點"
L["Unlock All Anchors"] = "解鎖全部錨點"
L["Unlock and show the anchors for all bar groups."] = "解鎖並顯示全部計時條組的錨點"

-- Defaults tab
L["Defaults"] = "默認"
L["Defaults string"] = "在計時條組裏的監視條擁有例如尺寸\字體和紋理的外觀選項 " ..
	"您可以在這個選項界面中調整這些選項的默認值. " ..
	"這些設置將被所有的配置文件所共同采用，以便您使用多個角色.\n"
L["Bar Configurations"] = "條 配置"
L["Icon Configurations"] = "圖標 配置"
L["Bar Width"] = "條寬度"
L["Set width of bars."] = "設定條的寬度"
L["Bar Height"] = "條高度"
L["Set height of bars."] = "設定條的高度"
L["Icon Size"] = "圖標尺寸"
L["Set width/height for icons."] = "設定圖標的寬度/高度"
L["Scale"] = "縮放"
L["Set scale factor for bars and icons."] = "設定條和圖標的縮放"
L["Horizontal Spacing"] = "水平間距"
L["Adjust horizontal spacing between bars."] = "設定條之間的水平間距"
L["Vertical Spacing"] = "垂直間距"
L["Adjust vertical spacing between bars."] = "設定條之間的垂直間距"
L["Icon Inset"] = "圖標水平偏移"
L["Set icon's horizontal inset from bar."] = "設定圖標在條上的水平偏移"
L["Icon Offset"] = "圖標垂直偏移"
L["Set vertical offset between icon and bar."] = "設定圖標在條上的垂直偏移"
L["Reset Format"] = "重設格式"
L["Reset format to default settings."] = "將格式重設為默認"
L["RESET FORMAT\nAre you sure you want to reset the format options?"] ="重設格式\n你確定將格式重設為默認??"
L["Fonts and Textures"] = "字體和材質"
L["Label Text"] = "標簽文本"
L["Font"] = "字體"
L["Select font."] = "選擇字體"
L["Font Size"] = "字號"
L["Set font size."] = "設定字號"
L["Opacity"] = "不透明度"
L["Set text opacity."] = "設置文字不透明度"
L["Color"] = "顏色"
L["Outline"] = "描邊"
L["Add black outline."] ="添加黑色描邊"
L["粗邊"] = ""
L["Add thick black outline."] ="添加黑色粗邊"
L["Mono"] = true
L["Render font without antialiasing."] = "不采用反鋸齒渲染字體"
L["Shadow"] ="陰影"
L["Show shadow with text."] ="顯示文字陰影"
L["Time Text"] = "時間文字"
L["Icon Text"] = "圖標文字"
L["Bars and Icons"] = "條和圖標"
L["Bar Foreground Texture"] = "條的前景材質"
L["Select foreground texture for bars."] ="選擇條的前景材質"
L["Foreground Opacity"] = "前景透明度"
L["Set foreground opacity for bars."] = "設置前景的透明度"
L["Bar Background Texture"] = "條的背景材質"
L["Select background texture for bars."] = "選擇條的背景材質"
L["Background Opacity"] = "背景透明度"
L["Set background opacity for bars."] = "設置條的背景透明度"
L["Panels and Borders"] = "面板和邊框"
L["Background Panel"] ="背景面板"
L["Enable display of a background panel behind bar group."] = "在計時條組的背後顯示背景面板"
L["Panel Texture"] = "面板材質"
L["Select texture to display in panel behind bar group."] = "選擇背景面板的材質"
L["Adjust padding between bar group and the background panel and border."] = "設置計時條組和背景面板、邊框之間的間距"
L["Set fill color for the panel."] = "選擇面板的填充顏色"
L["Background Border"] ="背景邊框"
L["Select border to display behind bar group (select None to disable border)."] = "選擇計時條組背景的邊框材質"
L["Adjust inset from the border to background panel's fill color."] = "設定邊框和背景面板的間距"
L["Set color for the border."] = "設置邊框顏色"
L["Bar Border"] = "條邊框"
L["Select border for bars in the bar group (select None to disable border)."] ="設定計時條組中的監視條的邊框"
L["Adjust size of the border's edge."] = "設定邊沿的尺寸"
L["Adjust offset to the border from the bar."] = "設定邊框和條的間距"
L["Set border's offset from the bar."] = "設定邊框與條的間距"
L["Edge Size"] = "邊沿尺寸"
L["Inset"] = "偏移"
L["Offset"] ="偏移"
L["Padding"] = "填充"
L["Border Color"] = "邊框顏色"
L["Panel Color"] = "面板顏色"
L["Foreground Saturation"] = "前景飽和度"
L["Set saturation for foreground colors."] = "設定前景的飽和度"
L["Foreground Brightness"] = "前景亮度"
L["Set brightness for foreground colors."] = "設定前景的亮度"
L["Background Saturation"] = "背景飽和度"
L["Set saturation for background colors."] = "設置背景的飽和度"
L["Background Brightness"] = "背景亮度"
L["Set brightness for background colors."] = "設置背景的保護度"
L["Opacity (Not Combat)"] = "戰鬥外透明度"
L["Set opacity for bars/icons when not in combat."] = "設定戰鬥外的透明度"
L["Opacity (In Combat)"] = "戰鬥中透明度"
L["Set opacity for bars/icons when in combat."] = "設定戰鬥中的透明度"
L["Icon Border Saturation"] = "圖標邊框飽和度"
L["Set saturation for icon border colors."] = "設置圖標邊框的飽和度"
L["Icon Border Brightness"] = "圖標邊框亮度"
L["Set brightness for icon border colors."] = "設置圖標邊框亮度"
L["Reset Fonts/Textures"] = "重設字體/材質"
L["Reset fonts and textures to default settings."] = "重設材質/字體到默認"
L["RESET FONTS/TEXTURES\nAre you sure you want to reset the font and texture options?"] ="重設字體/材質\n確定將字體和材質重設到默認?"
L["Standard Colors"] = "標準顏色"
L["Bar Colors:"] ="條顏色:"
L["Notify"] = "提示"
L["Buff"] = true
L["Debuff"] = true
L["Cooldown"] ="冷卻"
L["Buffs"] = true
L["Debuff Colors:"] = "Debuff顏色"
L["Curse"] = "詛咒"
L["Magic"] = "魔法"
L["Disease"] = "疾病"
L["Poison"] = "中毒"
L["Reset Bar Colors"] = "重設條顏色"
L["Reset bar colors back to default."] = "將條顏色重設為默認"
L["RESET BAR COLORS\nAre you sure you want to reset bar colors back to default?"] = "重設條顏色\n確定要把條顏色重設為默認值?"
L["Reset Debuff Colors"] = "重設Debuff顏色"
L["Reset debuff colors back to default."] = "將Debuff顏色重設為默認"
L["RESET DEBUFF COLORS\nAre you sure you want to reset debuff colors back to default?"] = "重設Debuff顏色\n確定要把Debuff顏色重設為默認值?"
L["OmniCC"] = true
L["Hide OmniCC"] = "隱藏OmniCC"
L["If checked, OmniCC counts are hidden on icons in all bar groups (requires /reloadui)."] = "在圖標上隱藏OmniCC計時"
L["Masque/Button Facade"] = ""
L["If checked, icons are skinned with Masque (formerly known as Button Facade)."] = "勾選，則圖標使用Masque皮膚"
L["Color Normal Texture"] = "默認材質顏色"
L["If checked, icon border color is applied to the normal texture."] = "勾選,則邊框將使用默認材質"
L["Color Border Texture"] = "邊框材質顏色"
L["If checked, icon border color is applied to the border texture."] = "勾選,則邊框將使用邊框材質"
L["Sound Channel"] = "音效通道"
L["Master"] ="主聲音"
L["If checked, sound is played in Master channel."] = "勾選,則聲音通過遊戲主聲音播放"
L["SFX"] = true
L["If checked, sound is played in SFX channel."] = "勾選,則聲音通過SFX通道播放"
L["Music"] = "音樂"
L["If checked, sound is played in Music channel."] = "勾選,則聲音通過音樂頻道播放"
L["Ambience"] = "環境"
L["If checked, sound is played in Ambience channel."] = "勾選,則聲音通過環境通道播放"

-- Spells tab
L["Spells"] ="法術"
L["Spells string"] = "法術標簽可定義與法術有關聯的顏色和標簽. " ..
	"這些設置將被所有的配置文件所共同采用，以便您使用多個角色. " ..
	"您也可以創建法術列表,並在本標簽指定他們的GCD和效果計時器.\n"
L["Colors and Labels"] = "顏色和標簽"
L["Spell Name"] = "法術名字"
L["Enter spell name (or numeric identifier) whose color you want to change."] = "輸入你要修改顏色的法術名稱"
L["Select a standard color or click to set a custom color."] = "選擇一個顏色"
L["Spell Label"] = "法術標簽"
L["Enter a label to be used by default with this spell."] = "輸入一個這個法術默認使用的標簽文字"
L["Spell Sound"] = "法術聲音"
L["Select sound to associate with the spell."] = "選擇一個與這個法術關聯的聲音"
L["Reset"] = "重設"
L["Reset color and label string"] = function(s) return string.format("重設 %s  的顏色,標簽和聲音", s) end
L["Reset color and label confirm"] = function(s) return string.format("重設法術\n你確定重設 %s 的顏色,標簽和聲音?", s) end
L["Reset Spell Colors"] = "重設法術顏色"
L["Reset spell colors back to defaults."] = "重設法術顏色到默認"
L["RESET SPELL COLORS\nAre you sure you want to reset all spell colors back to defaults?"] ="重設法術顏色\n確定將法術顏色重設到默認?"
L["Reset Spell Labels"] ="重設標簽"
L["Reset spell labels back to defaults."] ="重設標簽到默認"
L["RESET SPELL LABELS\nAre you sure you want to reset all spell labels back to defaults?"] ="重設標簽\n確定將標簽重設到默認?"
L["Reset Spell Sounds"] = "重設聲音"
L["Reset spell sounds back to defaults."] = "重設聲音到默認"
L["RESET SPELL SOUNDS\nAre you sure you want to reset all spell sounds back to defaults?"] ="重設法術聲音\n確定將法術聲音重設到默認?"
L["Internal Cooldowns Triggered By Buffs/Debuffs"] = "由buff/debuff引起的內部冷卻"
L["Internal Cooldowns"] = "內部冷卻"
L["Enable detecting internal cooldowns."] = "啟用內部冷卻"
L["Cooldown List"] = "冷卻列表"
L["New Cooldown"] = "新冷卻"
L["Enter a new internal cooldown triggered by a buff or debuff."] = "輸入一個引發內部冷卻的Buff/Debuff"
L["Enter Spell Name or ID"] = "輸入名稱或法術ID"
L["Enter buff or debuff spell name or numeric identifier for new internal cooldown."] = "輸入一個引發內部冷卻的Buff/Debuff的名稱或法術ID"
L["Cancel creating a new internal cooldown."] = "取消創建內部冷卻"
L["Delete Cooldown"] = "刪除"
L["Delete the selected internal cooldown."] = "刪除選擇的內部冷卻計時"
L["Delete cooldown string"] = "刪除冷卻\n你確定要刪除冷卻即使?"
L["Enter duration in seconds."] = "輸入持續時間(單位:秒)"
L["Enable detecting this internal cooldown."] = "輸入內部冷卻的時間"
L["If checked, test if buffs/debuffs were cast by the player."] = "測試:若這個buff/debuff由玩家釋放"
L["Cast On Player"] = "由玩家釋放"
L["If checked, test if buffs/debuffs are on the player and cast by anyone other than the player."] = true
L["Reset List"] = "重設列表"
L["Enter comma-separated list of buffs or debuffs (either spell names or numeric identifiers) that reset the internal cooldown."] = "輸入以逗號分隔的buff/debuff名稱或ID以重設內部CD列表"
L["Reset Cooldowns"] ="重設冷卻"
L["Reset all internal cooldowns back to defaults."] ="重設所有的內部CD"
L["RESET COOLDOWNS\nAre you sure you want to reset all internal cooldowns back to defaults?"] = "重設內部CD\n確定要重設全部的內部CD?"
L["Effect Timers Triggered By Spell Casts"] = "通過法術觸發效果計時器"
L["Enable detecting spell effects."] = "啟用檢測法術效果"
L["Spell Effect List"] = "法術效果列表"
L["New Spell Effect"] ="新法術效果"
L["Enter a new spell effect triggered by a successful spell cast."] = "輸入一個新的法術釋放成功所產生的法術效果"
L["Enter spell name or numeric identifier that, when cast, will trigger a new spell effect."] = "輸入當法術釋放成功時產生的法術效果的名稱或ID"
L["Cancel creating a new spell effect."] = "取消創建法術效果"
L["If checked, spell effect is a buff."] = "該效果是BUFF"
L["If checked, spell effect is a debuff."] = "該效果是DEBUFF"
L["If checked, spell effect is a cooldown."] = "該效果是冷卻時間"
L["Delete Spell Effect"] = "刪除法術效果"
L["Delete the selected spell effect."] = "刪除法術效果"
L["Delete effect string"] = "刪除法術效果\n確定刪除法術效果?"
L["Enable detecting this spell effect."] = "啟用檢測此法術效果"
L["Renew"] = "更新"
L["If checked, spell effect is renewed if spell is cast again while effect is active."] = "當該效果再一次釋放時該法術效果將被更新"
L["If checked, include name of caster in the label if spell effect is a buff or debuff."] = "若該效果是buff或debuff時,在標簽裏包含釋放者的名稱"
L["Enter spell name or numeric identifier for spell to be associated with this effect (default is to use spell that triggers the effect)."] = "輸入法術效果的名稱或法術ID"
L["Required Talent"] = "需要天賦"
L["Enter name or numeric identifier for talent required for effect to happen (leave blank if no talent required)."] = "輸入觸發該效果需要的天賦名稱或id"
L["Required Buff"] = "需要Buff"
L["Enter name or numeric identifier for buff required to be active on player for effect to happen (leave blank if no buff required)."] =  "輸入觸發該效果需要的buff名稱或id"
L["Required Condition"] = "需要條件"
L["Enter name of condition required to be true for effect to happen (leave blank if no condition required)."] = "輸入觸發該效果所需的前提條件"
L["If checked, spell must be cast by the player to trigger the spell effect."] = "該效果必須由玩家釋放的法術觸發"
L["If checked, spell must be cast by the player's pet to trigger the spell effect."] = "該效果必須由玩家的寵物釋放的法術觸發"
L["If checked, spell must be cast by the target to trigger the spell effect."] = "該效果必須由目標釋放的法術觸發"
L["If checked, spell must be cast by the focus to trigger the spell effect."] = "該效果必須由焦點釋放的法術觸發"
L["If checked, spell must be cast by anyone other than the player or pet to trigger the spell effect."] = "該效果必須由除玩家或寵物之外的其他目標觸發"
L["If checked, trigger the spell effect if the spell is cast by anyone, including player."] = "該效果可以由任何人觸發"
L["Spell Lists"] = "法術列表"
L["Spell List"] = "法術列表"
L["New Spell List"] = "新法術列表"
L["Create a new spell list."] = "創建新的法術列表"
L["Enter Spell List Name"] = "輸入新的法術列表名稱"
L["Enter name for a new spell list."] = "輸入新的法術列表名稱"
L["Cancel creating a new spell list."] = "取消創建新的法術列表"
L["Delete Spell List"] = "刪除法術列表"
L["Delete the selected spell list."] = "刪除選定的法術列表"
L["Delete spell list string"] = "刪除法術列表\n你確定要刪除法術列表?"
L["Enter Spell"] = "輸入法術"
L["Enter a spell name (or numeric identifier, optionally preceded by # for a specific spell id) to be added to the list."] = "輸入法術名稱或ID以添加到法術列表"
L["Delete the selected spell from the list."] = "從列表中刪除選定的法術"
L["Reset the spell list."] = "重置法術列表"
L['RESET\nAre you sure you want to reset the spell list?'] = '重置\n確定要重置法術列表?'

-- Bar Groups tab
L["Bar Groups"] = "計時條組"
L["Bar Group"] = "計時條組"
L["New Custom Group"] = "新建自定義計時條組"
L["Create a new bar group with manually added bars."] = "以手動添加的方式創建一個新的條組"
L["New Auto Group"] = "新建自動計時條組"
L["Create a new bar group with automatically displayed bars."] = "以自動添加的方式創建一個新的條組"
L["Enter Custom Group Name"] = "輸入自定義計時條組名稱"
L["Enter name of new custom bar group."] = "輸入新建的計時條組名稱"
L["Invalid name."] = "有效名稱"
L["Enter Auto Group Name"] = "輸入自動計時條組名稱"
L["Enter name of new auto bar group."] = "輸入自動計時條組的名稱"
L["Cancel"] = "取消"
L["Cancel creating a new bar group."] = "取消創建計時條組"
L["Delete Bar Group"] = "刪除計時條組"
L["Delete the selected bar group."] = "刪除選中的計時條組"
L["Delete bar group string"] = function(s) return string.format("刪除計時條組\n你確定要刪除計時條組 %s ?", s) end

-- Bar Groups > General tab
L["General"] = "一般"
L["Settings"] = "設定"
L["Enable Bar Group"] = "啟用計時條組"
L["Enable bar group string"] = "若選中,計時條組將被啟用,錨點和監視條將會顯示, " ..
	"除非該計時條組或錨點為不可見的."
L["Merge Bar Group"] = "合並計時條組"
L["Merge bar group string"] = "若選中，將合並其他計時條組中的監視條. " ..
	"監視條將繼承該計時條組的設定, " ..
	"但排列和布局仍使用其他條的設定."
L["Link Settings"] = "鏈接設定"
L["Link settings string"] = "若選中,該計時條組的配置" ..
	"將和其他配置文件中同名的計時條組同步."
L["Save Settings"] = "保存設定"
L["Click to save current settings to linked settings."] = "點擊以保存當前設定與鏈接設定"
L["Bar Group To Merge Into"] = "要合並的計時條組"
L["Select a bar group to merge into."] = "選擇一個要合並的計時條組"
L["Rename Bar Group"] = "重命名計時條組"
L["New Name"] = "新名字"
L["Enter new name for the bar group."] = "為計時條組輸入一個新名字"
L["Sort Order"] = "排序"
L["A to Z"] = "A到Z"
L["If checked, sort in ascending alphabetical order starting at bar closest to the anchor."] = true
L["Time Left"] ="時間剩余"
L["If checked, sort by time left in ascending order starting at bar closest to the anchor."] = true
L["Duration"] = "時間"
L["If checked, sort by overall duration in ascending order starting at bar closest to the anchor."] = true
L["Creation"] = "創建"
L["If checked, show bars in order created with oldest bar closest to the anchor."] = true
L["Class"] = "職業"
L["If checked, sort by associated class name, if any, in ascending alphabetical order starting at bar closest to the anchor."] = true
L["Custom"] = "默認"
L["If checked, allow manually setting the order of bars."] = true
L["Reverse Order"] = "反轉排序"
L['If checked, reverse the sort order (e.g., "A to Z" becomes "Z to A").'] = "反轉排序(比如A-Z變成Z-A)"
L["Show When"] = "顯示,當:"
L["If checked, bar group is shown when the player is in combat."] ="當在戰鬥中時顯示"
L["If checked, bar group is shown when the player is out of combat."] = "當在戰鬥外顯示"
L["Resting"] = "休息"
L["If checked, bar group is shown when the player is resting."] = true
L["Mounted"] ="坐騎上"
L["If checked, bar group is shown when the player is mounted."] = true
L["Vehicle"] = "載具上"
L["If checked, bar group is shown when the player is in a vehicle."] = true
L["Enemy"] = "敵人"
L["If checked, bar group is shown when the target is an enemy."] ="目標是敵人時顯示"
L["Friendly"] = "友善"
L["If checked, bar group is shown when the target is friendly."] = "目標是友善時顯示"
L["Focus=Target"] = true
L["If checked, bar group is shown when focus is same as target."] = "當目標與焦點相同時"
L["Solo"] = "獨自"
L["If checked, bar group is shown when the player is not in a party or raid."] ="不在隊伍或團隊時顯示"
L["If checked, bar group is shown when the player is in a party."] = "在隊伍中時顯示"
L["If checked, bar group is shown when the player is in a raid."] = "在團隊中時顯示"
L["If checked, bar group is shown when the player is in a 5-man or raid instance."] = "在5人副本或團隊副本中時顯示"
L["If checked, bar group is shown when the player is not in a 5-man or raid instance."] = "不在5人副本或團隊副本時顯示"
L["If checked, bar group is shown when the player is in an arena."] = "競技場中顯示"
L["If checked, bar group is shown when the player is in a battleground."] = "戰場中顯示"
L["Fishing"] = "釣魚"
L["If checked, bar group is shown when the player is ready to fish (i.e., trained with fishing pole equipped)."] = "把魚竿拿在手上時顯示"
L["Blizzard Buffs Enabled"] ="啟用系統自帶BUFF"
L["If checked, the bar group is shown if the default user interface for buffs is enabled."] = true
L["Blizzard Buffs Disabled"] = "禁用系統自帶BUFF"
L["If checked, the bar group is shown if the default user interface for buffs is disabled."] = true
L["Condition Is True"] = "條件為真"
L["If checked, bar group is shown only when the selected condition is true."] = true
L["Condition"] ="條件"
L["Player Class"] = "玩家職業"
L["Start Spell Sound"] = "法術開始音效"
L["Play associated spell sound, if any, when bar starts (spell sounds are set up on Spells tab)."] = "請選擇法術音效,如果選擇,則在條開始時同時播放該聲音"
L["Alternative Start Sound"] = "改變開始音效"
L["Select sound to play when bar starts and there is no associated spell sound (or start spell sounds are not enabled)."] = "選擇法術開始時需要播放的音效."
L["Replay"] = "重放"
L["Enable replay of start sound (after a specified amount of time) while bar is active."] = "啟用反復播放開始音效"
L["Replay Time"] = "重復次數"
L["Replay Start Sound"] = "重放開始聲音"
L["Set number of seconds between replays of start sound."] = "設置開始聲音的重放時間,單位秒"
L["Finish Spell Sound"] = "法術結束音效"
L["Play associated spell sound, if any, when bar finishes (spell sounds are set up on Spells tab)."] = "播放關聯的音效,當條走完的時候播放"
L["Alternative Finish Sound"] = "更改結束音效"
L["Select sound to play when bar finishes and there is no associated spell sound (or finish spell sounds are not enabled)."] = "選擇法術結束時需要播放的音效."
L["Expire Spell Sound"] = "法術將結束音效"
L["Play associated spell sound, if any, when bar is about to expire (spell sounds are set up on Spells tab)."] =  "選擇法術將要結束時需要播放的音效."
L["Alternative Expire Sound"] = "更改法術將結束音效"
L["Select sound to play when bar is about to expire and there is no associated spell sound (or expire spell sounds are not enabled)."] ="選擇法術將要結束時需要播放的音效."
L["Expire Time"] = "到期時間"
L["Set number of seconds before expiration that bar should change color and/or play expire sound."] ="設置還剩多少時間的時候條將變色/播放將要結束音效"
L["Minimum Duration"] = "最短時間"
L["Set minimum duration in minutes required to trigger expiration options."] ="設置將結束選項所適用的法術最短時間,單位秒"
L["Color When Expiring"] = "到期顏色"
L["Enable color changes for expiring bars (and, for icon configurations, make background visible if opacity is set to invisible to enable bar as highlight)."] =  "選擇法術將要結束時需要條的顏色."
L["Set bar color for when about to expire (set invisible opacity to disable color change)."] ="選擇法術將要結束時需要條的顏色."
L["Set label color for when bar is about to expire (set invisible opacity to disable color change)."] = "選擇法術將要結束時需要標簽的顏色."
L["Set time color for when bar is about to expire (set invisible opacity to disable color change)."] = "選擇法術將要結束時需要時間的顏色."
L["Combat Text"] = "戰鬥文字"
L["Enable warning in combat text for expiring bars."] = "在戰鬥文字中為將過期的法術提示"
L["Critical"] = "暴擊"
L["Enable combat text warning as critical."] = "提示以暴擊數字的形式提示"
L["Set color for combat text warning."] = "設置戰鬥文字的顏色"
L["expiring"] = "到期"
L["Miscellaneous Options"] = "其他選項"
L["Frame Strata"] = "框體層次"
L["Frame strata string"] = "選擇框體層次,以便讓計時條組處於其他UI元素之前或之後."
L["Lock"] ="鎖定"
L["Lock and hide the anchor for the bar group."] = "鎖定並隱藏計時條組的錨點"
L["Unlock"] = "解鎖"
L["Unlock and show the anchor for the bar group."] ="解鎖並顯示計時條組的錨點"
L["Non-Interactive"] = "非交互的"
L["If checked, the bar group is non-interactive and doesn't show tooltips or respond to clicks."] = "勾選,則該計時條組不響應鼠標事件"
L["Only Icons Interact"] = "只有圖標互動"
L["If checked, only icons show tooltips and respond to clicks, otherwise entire bar does."] = "勾選,則計時條組中只有圖標響應鼠標事件"
L["Tooltip Anchor"] = "提示錨點"
L["Tooltip anchor string"] = "設置提示的錨點(\"DEFAULT\" 設置為默認)."
L["Combat Tooltips"] = "戰鬥中顯示提示"
L["If checked, tooltips are shown during combat."] = "勾選,則提示會在戰鬥中顯示"
L["Caster"] = "釋放者"
L["If checked, tooltips include caster for buffs and debuffs when known."] = "勾選,則在釋放者可知時顯示釋放者"
L["Show Headers"] = "顯示標題"
L["When showing all buffs or debuffs cast by player, add headers for each affected target."] = "當顯示玩家釋放的所有BUFF/DEBUF,為每個受影響的目標添加標題"
L["Sort Target First"] = "首先排序目標"
L["When showing all buffs or debuffs cast by player, sort ones for target first."] = "當顯示玩家釋放的所有BUFF/DEBUFF,排序目標."
L["Non-Target Opacity"] = "無目標時的透明度"
L["When showing all buffs or debuffs cast by player, set opacity for ones not on target."] = "沒選擇目標時計時條組的透明度"
L["Targets"] = "目標"
L["When showing all buffs or debuffs cast by player without headers, show target names in labels."] ="當顯示玩家釋放的所有BUFF/DEBUF,在標簽上顯示目標名字"
L["When showing all buffs or debuffs cast by player without headers, show spell names in labels."] = "當顯示玩家釋放的所有BUFF/DEBUF,在標簽上顯示法術名字"

-- Bar Groups > Custom Bars tab
L["Custom Bars"] = "自定義條"
L["New"] = "新建"
L["Create a new bar."] = "以新的條創建"
L["Delete the selected bar."] = "刪除選定的條"
L['DELETE BAR\nAre you sure you want to delete the selected bar?'] = "刪除條\n確定刪除選定的條?"

-- Bar Groups > Buffs tab
L["Auto Buffs"] = "自動BUFF"
L['Enable automatically displaying bars for buffs that match these settings.'] = "啟用自動為符合這些設置的buff創建條"
L["All Cast By Player"] = "所有由玩家釋放的法術"
L['Include all buffs cast by player on others.'] = "所有目標的由玩家釋放的法術"
L["Action On"] = "動作於:"
L["If checked, only add bars for buffs if they are on the player."] = "勾選,則只為釋放在玩家身上的buff創建條"
L["If checked, only add bars for buffs if they are on the player's pet."] = "勾選,則只為釋放在寵物身上的buff創建條"
L["If checked, only add bars for buffs if they are on the target."] = "勾選,則只為釋放在玩目標上的buff創建條"
L["If checked, only add bars for buffs if they are on the focus."] = "勾選,則只為釋放在焦點身上的buff創建條"
L["Exclude On"] = "排除"
L["If checked, exclude buffs if they are on the player."] = "勾選,則排除釋放在玩家身上的buff"
L["If checked, exclude buffs if they are on the player's pet."] =  "勾選,則排除釋放在玩家寵物身上的buff"
L["If checked, exclude buffs if they are on the target."] =  "勾選,則排除釋放在目標身上的buff"
L["If checked, exclude buffs if they are on the focus."] = "勾選,則排除釋放在焦點身上的buff"
L["Mouseover"] = "鼠標滑過"
L["Pet's Target"] = "寵物目標"
L["Target's Target"] = "目標的目標"
L["Focus's Target"] = "焦點目標"
L["If checked, only add bars for buffs if they are on the mouseover unit."] = "勾選,則只為釋放在鼠標滑過的目標身上的buff創建條"
L["If checked, only add bars for buffs if they are on the pet's target."] = "勾選,則只為釋放在寵物的目標身上的buff創建條"
L["If checked, only add bars for buffs if they are on the target's target."] = "勾選,則只為釋放在目標的目標身上的buff創建條"
L["If checked, only add bars for buffs if they are on the focus's target."] = "勾選,則只為釋放在焦點的目標身上的buff創建條"
L["If checked, only add bars for buffs if cast by the player."] = "勾選,則只為玩家釋放的buff創建條"
L["If checked, only add bars for buffs if cast by the player's pet."] =  "勾選,則只為玩家寵物釋放的buff創建條"
L["If checked, only add bars for buffs if cast by the target."] =  "勾選,則只為目標釋放的buff創建條"
L["If checked, only add bars for buffs if cast by the focus."] =  "勾選,則只為焦點釋放的buff創建條"
L["If checked, only add bars for buffs if cast by anyone other than the player or pet."] =  "勾選,則只為除了玩家和玩家寵物外其他人釋放的buff創建條"
L["If checked, add bars for buffs if cast by anyone, including player."] =  "勾選,則為任何人釋放的buff創建條"
L["Other"] = "其他"
L["Anyone"] = "任何人"
L["Filter By Type"] = "以類型過濾"
L["Filter buff types string"] = "只為所選類型的buff創建條"
L["Tracking"] = "監視"
L["Include Tracking"] = "包括監視"
L["Show Only Tracking"] = "只顯示監視的法術"
L['Include the active tracking types as buffs.'] = "把監視的法術看作buff"
L['Include only the active tracking types.'] = "包括其他的激活的監視類型"
L["Stealable"] = "可偷取"
L['Include buffs that mages can spellsteal.'] = "包括法師可偷取的法術類型"
L['Include magic buffs (these can usually be removed with abilities like Purge).'] = "包括魔法法術"
L['Include other buffs not selected with filter types.'] = "包括所選的其他類型"
L["Filter List"] = "過濾列表"
L["Black List"] = "黑名單"
L["White List"] = "白名單"
L["Use Spell List"] = "適用法術列表"
L["If checked, filter list includes spells in specified spell list (these are set up on the Spells tab)."] = true
L["If checked, don't display any buffs that are in the filter list."] = true
L["If checked, only display buffs that are in the filter list."] = true
L["If checked, the filter list is shared with bar groups in other profiles with the same name."] = "勾選,則該列表將與配置文件中其他同名列表共享"
L["Enter Buff"] = "啟用Buff"
L["Enter a buff to be added to the filter list."] = "輸入一個要添加到過濾列表的法術名稱"
L["Delete the selected buff from the filter list."] = "從過濾列表中刪除選定的buff"
L["Reset the buff filter list."] = "重設過濾列表"
L['RESET\nAre you sure you want to reset the buff filter list?'] = "重設\n確定重設buff的過濾列表?"
L["Filter Bar Group"] = "過濾計時條組"
L["Select filter bar group."] = "選擇過濾的計時條組"
L["Filter buff bar group string"] = "勾選,則不在計時條組中顯示buff,如果選定了自定義計時條組,則不在自定義計時條組中顯示buff.如果自動選擇計時條組,不顯示在過濾列表裏的buff."

-- Bar Groups > Debuffs tab
L["Auto Debuffs"] = "自動debuff"
L['Enable automatically displaying bars for debuffs that match these settings.'] = "啟用自動為符合這些設置的buff創建條"
L['Include all debuffs cast by player on others.'] = "所有目標的由玩家釋放的法術"
L["Only Show Dispellable"] = "只顯示可驅散的"
L['If check, only show debuffs that can be dispelled by the player.'] = "若勾選,則只顯示可被玩家驅散的debuff"
L["If checked, exclude debuffs if they are on the player."] = "若勾選,則排除施放於玩家的debuff"
L["If checked, exclude debuffs if they are on the player's pet."] = "若勾選,則排除施放於玩家寵物身上的debuff"
L["If checked, exclude debuffs if they are on the target."] ="若勾選,則排除施放於目標的debuff"
L["If checked, exclude debuffs if they are on the focus."] ="若勾選,則排除施放於焦點的debuff"
L["If checked, only add bars for debuffs if they are on the player."] = "若勾選,則只為施放於玩家的debuff添加計時條"
L["If checked, only add bars for debuffs if they are on the player's pet."] ="若勾選,則只為施放於玩家寵物的debuff添加計時條"
L["If checked, only add bars for debuffs if they are on the target."] = "若勾選,則只為施放於目標的debuff添加計時條"
L["If checked, only add bars for debuffs if they are on the focus."] = "若勾選,則只為施放於焦點的debuff添加計時條"
L["If checked, only add bars for debuffs if they are on the mouseover unit."] = "若勾選,則只為施放於鼠標滑過的玩家的debuff添加計時條"
L["If checked, only add bars for debuffs if they are on the pet's target."] = "若勾選,則只為施放於玩家的寵物目標debuff添加計時條"
L["If checked, only add bars for debuffs if they are on the target's target."] = "若勾選,則只為施放於目標的目標的debuff添加計時條"
L["If checked, only add bars for debuffs if they are on the focus's target."] = "若勾選,則只為施放於焦點目標的debuff添加計時條"
L["If checked, only add bars for debuffs if cast by the player."] = "若勾選,則只為由玩家釋放的debuff添加計時條"
L["If checked, only add bars for debuffs if cast by the player's pet."] ="若勾選,則只為由玩家寵物釋放的debuff添加計時條"
L["If checked, only add bars for debuffs if cast by the target."] ="若勾選,則只為由目標釋放的debuff添加計時條"
L["If checked, only add bars for debuffs if cast by the focus."] ="若勾選,則只為由焦點釋放的debuff添加計時條"
L["If checked, only add bars for debuffs if cast by anyone other than the player or pet."] = "若勾選,則只為由除玩家和寵物之外任何人釋放的debuff添加計時條"
L["If checked, add bars for debuffs if cast by anyone, including player."] = "若勾選,則只為由任何人釋放的debuff添加計時條"
L["If checked, don't display any debuffs that are in the filter list."] = "若勾選,則不顯示在過濾列表中的法術"
L["If checked, only display debuffs that are in the filter list."] = "若勾選,則只顯示在過濾列表中的法術"
L["Dispellable"] = "可驅散"
L["Filter debuff types string"] = "只顯示選中類型的debuff."
L['Include other debuffs not selected with filter types.'] = "包括其他未選擇的過濾類型"
L['Include debuffs that the player can dispel.'] = "包括玩家可驅散的法術"
L['Include debuffs cast by boss.'] = "包括由boss釋放的debuff"
L['Include poison debuffs.'] = "包括中毒debuff"
L['Include curse debuffs.'] = "包括詛咒debuff"
L['Include magic debuffs.'] = "包括魔法debuff"
L['Include disease debuffs.'] = "包括疾病debuff"
L["If checked, the debuff filter list is shared with bar groups in other profiles with the same name."] = "勾選,則該列表將與配置文件中其他同名列表共享"
L["Enter Debuff"] = "輸入debuff名稱"
L["Enter a debuff to be added to the filter list."] = "輸入要添加到過濾列表的法術名稱"
L["Delete the selected debuff from the filter list."] = "從過濾列表中刪除選中的debuff"
L["Reset the debuff filter list."] = "重設debuff過濾列表"
L['RESET\nAre you sure you want to reset the debuff filter list?'] = "重設\n確定重設debuff過濾列表?"
L["Filter debuff bar group string"] = "勾選,則不在計時條組中顯示debuff,如果選定了自定義計時條組,則不在自定義計時條組中顯示debuff.如果自動選擇計時條組,不顯示在過濾列表裏的debuff."

-- Bar Groups > Cooldowns tab
L["Auto Cooldowns"] = "自動冷卻"
L['Enable automatically displaying bars for cooldowns that match these settings.'] = "啟用自動為符合這些設置的buff創建條"
L["Action By"] = "動作:"
L["If checked, only add bars for cooldowns associated with the player."] = "勾選,則只為玩家的冷卻創建計時條"
L["If checked, only add bars for cooldowns associated with the player's pet."] = "勾選,則只為玩家寵物的冷卻創建計時條"
L["If checked, add bars for cooldowns cast by either player or player's pet."] = "勾選,則同時為玩家和玩家寵物創建計時條"
L["Include"] = "包括"
L["If checked, include bars for spell cooldowns."] ="勾選,則為法術冷卻包括計時條"
L["Trinkets"] = "飾品"
L["If checked, include bars for cooldowns on equipped trinkets."] = "勾選.則計時條組包含已裝備物品的冷卻"
L["If checked, include bars for internal cooldowns triggered by a buff or debuff."] = "勾選,則計時條組包括debuff和buff引起的GCD"
L["Effect Timers"] = "生效計時器"
L["If checked, include bars for effect timers triggered by a spell cast."] ="勾選,則計時條組包括法術觸發的計時器"
L["Weapon Buffs"] = "武器buff"
L["If checked, include bars for weapon buffs."] = "勾選,則計時條組包括武器buff"
L["Potions/Elixirs"] = "藥水/藥劑"
L["If checked, include bars for shared potion/elixir cooldowns (an item subject to the shared cooldown must be in your bags in order for the cooldown to be detected)."] = "勾選,則計時條組包括藥水或藥劑的冷卻"
L["If checked, include bars for other cooldowns (for item cooldowns, an item subject to the cooldown must be in your bags in order for the cooldown to be detected)."] = "勾選,則為其他冷卻創建計時條"
L["Shared Cooldowns"] ="共享冷卻"
L["If checked, only show one cooldown for hunter Frost Traps."] = "勾選,則為獵人的冰霜陷阱只創建一個冷卻計時"
L["If checked, only show one cooldown for hunter Fire Traps."] = "勾選,則為獵人的爆炸陷阱只創建一個冷卻計時"
L["If checked, only show one cooldown for shaman Shocks."] = "勾選,則為薩滿的震擊只創建一個冷卻計時"
L["If checked, only show one cooldown for paladin Crusader Strike and Hammer of the Righteous."] = "勾選,則為聖騎士的十字軍打擊和正義之錘只創建一個冷卻計時"
L["Filter Cooldowns"] ="冷卻過濾"
L["If checked, don't display any cooldowns that are in the filter list."] = "勾選,則不顯示在過濾列表裏的冷卻"
L["If checked, only display cooldowns that are in the filter list."] = "勾選,則只顯示在過濾列表裏的冷卻"
L["If checked, the cooldown filter list is shared with bar groups in other profiles with the same name."] = "勾選,則該列表將與配置文件中其他同名列表共享"
L["Enter Cooldown"] = "輸入冷卻"
L["Enter a cooldown to be added to the filter list."] = "輸入一個冷卻名稱以加入過濾列表"
L["Delete the selected cooldown from the filter list."] = "刪除選擇的冷卻"
L["Reset the cooldown filter list."] = "重設冷卻過濾列表"
L['RESET\nAre you sure you want to reset the cooldown filter list?'] = "重設\n確定重設冷卻列表?"
L["Filter cooldown bar group string"] = "勾選,則不在計時條組中顯示冷卻,如果選定了自定義計時條組,則不在自定義計時條組中顯示冷卻.如果自動選擇計時條組,不顯示在過濾列表裏的冷卻."

-- Bar Groups > Layout tab
L["Layout"] = "布局"
L["Configuration"] ="配置"
L["Bars"] = "計時條"
L["If checked, use a bar-oriented configuration."] = "勾選,則使用計時條向導配置"
L["Icons"] = "圖標"
L["If checked, use an icon-oriented configuration."] =  "勾選,則使用圖標向導配置"
L["Options"] = "選項"
L["Select a configuration option for bars or icons."] = "為計時條或圖標選擇一個配置選項"
L["Direction"] = "方向"
L["If checked, grow up or to the right, otherwise grow down or to the left."] = "勾選,則向右增長,否則向左增長"
L["Copy Layout From"] = "復制布局格式"
L["Select bar group to copy all layout settings from."] = "復制所有的布局格式"
L["Timeline"] = "時間線"
L["Width"] = "寬度"
L["Set width of timeline."] ="設置時間線的寬度"
L["Height"] = "高度"
L["Set height of timeline."] = "設置時間線的高度"
L["Set maximum duration represented on the timeline in seconds."] = "設置時間線的最大持續時間,單位秒"
L["Exponent"] = "指數"
L["Set exponent factor for timeline to adjust time scale."] = "設置時間線縮放的調節指數"
L["Label List"] = "標簽列表"
L['Enter comma-separated list of times to show as labels on the timeline (times are in seconds unless you include "m", which is included in the label, or "M", which is hidden, for minutes).'] = '輸入用逗號分隔的時間線中顯示為標簽的時間列表'
L["Texture"] = "材質"
L["Select texture for timeline."] ="選擇時間線的材質"
L["Opacity"] = "透明度"
L["Set opacity for timeline."] = "設置時間線的透明度"
L["Timeline Color"] = "時間線顏色"
L["Set color for timeline background."] = "設置時間線的顏色"
L["Splash Effect"] = "閃亮效果"
L["If checked, show a splash effect when icons expire."] = "勾選,則在圖標將要到期時顯示閃亮效果"
L["Overlap Switch"] = "重疊開關"
L["If checked, when icons overlap, switch every two seconds which is shown on top (otherwise always show icon with shortest time remaining on top)."] = "勾選，則在時間線上重疊的圖標講輪流置於頂端."
L["Hide Empty"] ="隱藏恐怖"
L["If checked, hide the timeline background when there are no active icons."] = "勾選,則在沒有圖標時隱藏時間線"
L["If checked, format options are set to default values."] ="勾選,則格式選項重設到默認值"
L["Reset format for this bar group back to the current defaults."] = "重設該計時條組的配置到默認"
L["Format"] = "格式"
L["Icon"] = "圖標"
L["Show icon string"] = "顯示圖標文字"
L["Clock"] = "時鐘"
L["Show clock animation on icons for timer bars."] = "為圖標顯示動態時鐘"
L["Bar"] = "計時條"
L["Show colored bar and background."] = "顯示著色的計時條與悲劇"
L["Spark"] = "火花"
L["Show spark that moves across bars to indicate remaining time."] = "顯示移動到剩余時間的火花"
L["Label"] = "標簽"
L["Show label text on bars."] = "在計時條上顯示標簽"
L["Count"] = "層數"
L["Show stack count in parentheses after label (it is also displayed as overlay on icon)."] = "顯示圖標的堆疊層數"
L["Time"] ="計時器"
L["Show time left on bars that have a duration."] = "顯示剩余時間"
L["Tooltips"] = "鼠標提示"
L["Show tooltips when the cursor is over a bar's icon."] = "顯示鼠標提示"
L["Text Settings"] = "文字設定"
L["Label Text Inset"] = "標簽文字縮進"
L["Set horizontal inset for label from edge of bar."] = "設定文字的水平縮進"
L["Label Text Offset"] = "標簽文字偏移"
L["Set vertical offset for label text from center of bar."] = "設定文字的垂直偏移"
L["Wrap"] = "包裹"
L["If checked, wrap label text when it doesn't fit in the bar's width."] = "勾選,則當標簽文字不適合計時條寬度時包裹文字"
L["Top"] = true
L["If checked, set \"Top\" alignment for label text."] = true
L["Middle"] = true
L["If checked, set \"Middle\" alignment for label text."] = true
L["Bottom"] = true
L["If checked, set \"Bottom\" alignment for label text."] = true
L["Time Text Inset"] = "時間文字縮進"
L["Set horizontal inset for time text from edge of bar."] = "設定時間文字的水平縮進"
L["Time Text Offset"] = "偏移"
L["Set vertical offset for time text from center of bar."] = "設定時間文字的垂直偏移"
L["If checked, use normal alignment with small inset for time and label texts."] = "勾選,則使用默認對齊"
L["Left"] = true
L["If checked, set \"Left\" alignment for time text and normal alignment for label."] = "選定,則標簽文字左對齊"
L["Center"] = true
L["If checked, set \"Center\" alignment for time text and normal alignment for label."] ="選定,則標簽文字中對齊"
L["Right"] = true
L["If checked, set \"Right\" alignment for time text and normal alignment for label."] = "選定,則標簽文字右對齊"
L["Icon Text Inset"] ="圖標文字縮進"
L["Set horizontal inset for icon text from middle of icon."] = "設置圖標文字的水平縮進"
L["Icon Text Offset"] = "圖標文字偏移"
L["Set vertical offset for icon text from center of icon."] = "設置圖標文字的垂直偏移"
L["If checked, time text is shown on the icon instead of the bar."] = "勾選,時間文字顯示在圖標中間而不是計時條上"
L["Icon Configuration Options"] = "圖標配置選項"
L["Set how many bars/icons to display before wrapping to next row or column. If this is set to 0 then wrapping is disabled."] = "設置每行多少計時條/圖標"
L["Wrap Direction"] = "換行方向"
L["If checked, wrap up when arranged in rows or to the right when arranged in columns, otherwise wrap down or to the left."] ="勾選,則換行在左邊,否則換行到右邊"
L["Snap To Center"] = "捕捉中心"
L["If checked and the icon configuration bar group is locked, snap to center at the anchor position."] ="選擇,則捕捉到錨點坐標中心"
L["Display Position"] = "顯示位置"
L["Horizontal"] = "水平"
L["Set horizontal position as percentage of overall width (cannot move beyond edge of display)."] = "總寬度的水平位移百分比"
L["Vertical"] = "垂直"
L["Set vertical position as percentage of overall height (cannot move beyond edge of display)."] = "中高度的垂直位移百分比"
L["Bar/Icon Limit"] = "計時條/圖標限制"
L["Set the maximum number of bars/icons to display (the ones that sort closest to the anchor have priority). If this is set to 0 then the number is not limited."] = "設置計時條/圖標的最大數量"
L["Attachment"] = "附加"
L["Select a bar group to attach to (for independent position, attach to self)."] = "選擇一個需要附加的計時條組"
L["Offset X"] = "X偏移"
L["Set horizontal offset from the selected bar group."] ="設置X偏移"
L["Offset Y"] = "Y偏移"
L["Set vertical offset from the selected bar group."] = "設置Y偏移"
L["Last Bar"] = "最後的計時條"
L["If checked, position is relative to last bar/icon in the selected bar group."] = "勾選,位置依賴於計時條組的最後一個計時條或圖標"
L["Empty"] = "控"
L["If checked, offsets are not applied if the selected bar group is empty."] = "勾選,則位移在計時條組空時失效"
L["By Row"] = "行"
L["When wrap is enabled in the selected bar group, position is relative to last bar/icon in row closest to the anchor."] = "勾選,則位置依賴於計時條組/圖標的最後一行"
L["By Column"] = "列"
L["When wrap is enabled in the selected bar group, position is relative to last bar/icon in column closest to the anchor."] = "勾選,則位置依賴於計時條組/圖標的最後一列"
L["Parent Frame"] = "父框體"
L["Enter name of parent frame for this bar group (leave blank to use default)."] = "輸入該計時條組的父框體名稱"
L["Anchor Frame"] = "錨點框體"
L["Enter name of anchor frame to attach to (leave blank to enable bar group attachment)."] =  "輸入該計時條組的錨點框體名稱"
L["Anchor Point"] = "錨點"
L["Select point on anchor frame to attach to."] ="選擇要附著的錨點"
L["Reset attachment options."] = "重設錨點"
L["Frame Stack"] = "框體層級"
L["Toggle showing Blizzard's frame stack tooltips."] = "顯示系統自帶的框體層級提示"

-- Bar Groups > Appearance tab
L["Appearance"] ="外觀"
L["Use Defaults"] = "使用默認"
L["If checked, fonts and textures use the default values."] = "勾選,使用默認值"
L["Restore Defaults"] = "保存為默認"
L["Reset fonts and textures for this bar group back to the current defaults."] = "將當前設定保存為默認值"
L["Copy From"] = "復制格式"
L["Select bar group to copy font and texture settings from."] ="選擇一個計時條組以復制格式"
L["If checked, colors use the default values."] = "使用默認顏色著色"
L["Reset standard colors for this bar group back to the current defaults."] ="重設為默認顏色"
L["Select bar group to copy standard colors from."] = "選擇一個需要復制標準顏色的計時條組"
L["Bar Color Scheme"] = "計時條顏色"
L["Foreground:"] = "前景色"
L["Show bars in default colors for their type, including special debuff colors when applicable."] = "顯示計時條的顏色為它們的類型顏色"
L["Color the bars with a custom color."] = "以自定義顏色著色"
L["Class Colors"] = "職業顏色"
L["Show bars in class colors of associated spells when possible, otherwise use default bar colors."] ="可用時使用職業顏色著色,否則使用默認顏色"
L["Spell Colors"] = "法術顏色"
L["Show bars using spell colors when possible, otherwise use default bar colors."] = "可用時使用法術顏色著色,否則使用默認顏色"
L["Background:"] = "背景顏色"
L["Same as Foreground"] = "和前景色相同"
L["Color the background the same as the foreground."] ="著色與前景色相同"
L["Color the background with a custom color."] ="以自定義顏色著色"
L["Icon Border:"] = "圖標邊框"
L["Color the icon border the same as the bar foreground."] = "著色與前景色相同"
L["Color the icon border with a custom color."] ="以自定義顏色著色"
L["Color the icon border string"] = "只為debuff添加著色邊框."
L["None"] = "沒有"
L["Do not color the icon border."] ="不著色圖標邊框"

-- Bar Groups > Timer Options tab
L["Timer Options"] = "計時器選項"
L["Show With Uniform Duration"] ="以統一的格式顯示"
L["Show timer bars scaled with a uniform duration (text still shows actual time left)."] = "使用同一的計時條縮放"
L["Enter minutes in the uniform duration."] = "輸入統一格式的分鐘"
L["Enter seconds in the uniform duration."] = "輸入統一格式的秒鐘"
L["Show If Unlimited Duration"] = "無限時間時顯示"
L["Show bars for actions with unlimited duration (e.g., paladin auras)."] ="無限時間時顯示"
L["Only Show Unlimited"] = "只在無限時間時顯示"
L["Show bars for actions only if they have unlimited duration."] ="只在無限時間時顯示"
L["Full Bars"] = "完整計時條"
L["If checked, bars with unlimited duration show as full bars, otherwise they show as empty bars."] = "勾選,則持續時間無限的buff將以一個完整的計時條顯示"
L["Unlimited As Zero"] = "顯示為空"
L["If checked, bars with unlimited duration sort as zero duration, otherwise as very long duration."] = "勾選,則持續時間無限的buff將以一個空的計時條顯示"
L["Check Overall Duration"] = "檢查總持續時間"
L["Only include timer bars with a specified minimum (or maximum) duration."] = "只包括指定最小或最大值的計時條"
L["Enter minutes for overall duration check."] = "輸入總持續時間的分鐘"
L["Enter seconds for overall duration check."] = "輸入總持續時間的秒鐘"
L["Check Time Left"] = "檢查剩余時間"
L["Only show timer bars with a specified minimum (or maximum) time left."] = "只顯示指定了最大/最小剩余時間的計時條"
L["Enter minutes for time left check."] = "輸入剩余時間的分鐘"
L["Enter seconds for time left check."] = "輸入剩余時間的秒鐘"
L["Time Format"] = "時間格式"
L["Time format string"] = "選擇計時條和圖標的時間顯示格式,單獨設置為五個範圍: " ..
	"大於一小時,2分鐘到一小時,1分鐘到2分鐘,10秒到1分鐘,小於10秒 " ..
	"這些選項可以在下拉菜單中找到示例."
L["Spaces"] = "空格"
L["Include spaces between values in time format."] = "在時間格式中包括空格"
L["Uppercase"] = "大寫"
L["If checked, use uppercase H, M and S in time format, otherwise use lowercase."] = "為H,M,S使用大寫"
L["Special Effects"] = "特殊效果"
L["Pulse At Start"] = "以脈沖啟動"
L["Enable icon pulse when bar is started."] ="當計時條開始時以脈沖啟動"
L["Pulse When Expiring"] = "將要結束時脈沖"
L["Enable icon pulse when bar is expiring."] ="當計時條結束時以脈沖啟動"
L["Hide After Start"] = "開始後隱藏"
L["Enable hide after start for timer bars (does not hide bars with unlimited duration)."] = "開始後隱藏"
L["Fade After Start"] = "開始後漸隱"
L["Enable fade after start (i.e., switch to fade opacity after a delay)."] ="開始後漸隱"
L["Delay"] = "延遲"
L["Set number of seconds before bar will hide or fade."] = "開始後漸隱的延遲"
L["Flash When Expiring"] = "結束時閃爍"
L["Enable flashing of expiring bars."] = "結束時閃爍"
L["Flash Time"] = "閃爍時間"
L["Set number of seconds before expiration that bar should start flashing."] ="設置閃爍時間"

-- Conditions tab
L["Conditions"]="條件"
L["Condition"] = "條件"
L["New Condition"] = "新條件"
L["Create a new condition."] = "創建一個新條件"
L["Enter Condition Name"] = "輸入條件名稱"
L["Enter name of new condition."] = "輸入新條件名稱"
L["Cancel creating a new condition."] ="取消創建新條件"
L["Delete Condition"] = "刪除條件"
L["Delete the selected condition."] = "刪除選擇的條件"
L["Delete condition string"] = function(name) string.format('刪除條件\n確定刪除"%s" 條件?', name) end

-- Conditions > General tab
L["Enable Condition"] = "啟用條件"
L["If checked, the condition is enabled and its value is determined by evaluating the associated tests, otherwise the condition is disabled and its value is always false."] = true
L["Notification"] = "通知"
L["If checked, this condition is suitable for a notification and will show up as an option for new notify bars."] ="勾選,則在這種情況下是合適的通知,將顯示一個新的通知欄選項"
L["Detailed Tooltip"] = "詳細提示"
L["If checked, tooltip for notifications based on this condition will include a detailed description."] = "勾選,則提示將顯示詳細的描述"
L["Share Condition"] = "共享條件"
L["If checked, this condition's settings can be copied between characters."]  ="勾選,則條件可以在角色之間共同使用"
L["Copy Condition Settings From"] = "復制條件設置表格"
L["Select a shared condition to copy settings from, including tests, associated spells, and dependencies."] ="選擇一個條件以復制"
L["Reset and delete all current shared condition settings."] = "重設並刪除當前的共享條件設置"
L["Rename Condition"] = "重命名條件"
L["Enter new name for the condition."] = "輸入新的條件名稱"
L["Associated Spell"] = "關聯法術"
L["Enter spell name (or numeric identifier) whose color and icon can be used by notification bars based on this condition."] = "輸入這個條件將使用的關聯法術"

-- Conditions > Tests tab
L["Tests"] = "測試"
L["Summary"] = "摘要"

-- Conditions > Tests > Player Status
L["Enable Test"] = "啟用測試"
L["Enable"] = "啟用"
L["If checked, enable this test."] = "勾選,啟用測試"
L["Combat"] = "戰鬥"
L["If checked, test combat status."] = "勾選,測試戰鬥狀態"
L["If checked, must be in combat."] = "勾選,必須在戰鬥中"
L["If checked, must be out of combat."] = "勾選,必須在戰鬥外"
L["Resting"] = "休息"
L["If checked, test if the player is resting."] = "勾選,測試玩家休息"
L["If checked, player must be resting (e.g., in an inn)."] ="勾選,玩家必須在休息狀態"
L["If checked, player must not be resting."] = "勾選,玩家必須不在休息狀態"
L["Mounted"] = "坐騎"
L["If checked, test if the player is mounted."] = "測試:玩家在坐騎上"
L["If checked, player must be mounted."] = "玩家必須在坐騎上"
L["If checked, player must not be mounted."] ="玩家必須不在坐騎上"
L["Stealthed"] = "潛行"
L["If checked, test if the player is stealthed."] = "測試:玩家潛行"
L["If checked, player must be stealthed."] = "玩家必須是潛行狀態"
L["If checked, player must not be stealthed."] = "玩家必須不是潛行狀態"
L["Fishing"] = "釣魚"
L["If checked, test if the player is fishing."] = "測試:玩家在釣魚"
L["If checked, player must be ready to fish (i.e., trained with fishing pole equipped)."] = "玩家必須在釣魚"
L["If checked, player must not be ready to fish."] = "玩家必須不在釣魚"
L["PvP"] = true
L["If checked, test if the player has PvP enabled."] = "測試:玩家處於PVP狀態"
L["If checked, player must have PvP enabled."] = "玩家啟用PVP"
L["If checked, player must not have PvP enabled."] = "玩家禁用PVP"
L["If checked, test if player is in a party."] = "測試:玩家在隊伍裏"
L["If checked, player must be in a party."] = "玩家必須在隊伍裏"
L["If checked, player must not be in a party."] = "玩家必須不在隊伍裏"
L["If checked, test if player is in raid group."] = "測試:玩家在團隊裏"
L["If checked, player must be in a raid group."] = "玩家必須在隊伍裏"
L["If checked, player must not be in a raid group."] = "玩家必須不在隊伍裏"
L["If checked, test if player is in either a party or raid with other players."] ="測試:玩家在隊伍裏或團隊裏"
L["If checked, player must be in either a party or raid with other players."] = "玩家必須在隊伍裏或團隊裏"
L["If checked, player must not be in either a party or raid with other players."] = "玩家必須不在隊伍裏或隊伍裏"
L["If checked, test if player is in a 5-man or raid instance."] = "測試:玩家在五人副本或團隊副本裏"
L["If checked, player must be in a 5-man or raid instance."] = "玩家必須在五人副本或團隊副本裏"
L["If checked, player must not be in a 5-man or raid instance."] = "玩家必須不在五人副本或團隊副本裏"
L["If checked, test if player is in an arena."] = "測試:玩家在競技場裏"
L["If checked, player must be in an arena."] = "玩家必須在競技場裏"
L["If checked, player must not be in an arena."] = "玩家必須不在競技場"
L["If checked, test if player is in a battleground."] = "測試:玩家在戰場裏"
L["If checked, player must be in a battleground."] = "玩家必須在戰場裏"
L["If checked, player must not be in a battleground."] = "玩家必須不在戰場裏"
L["If checked, test if the player has a pet."] = "測試:玩家有寵物"
L["If checked, player must have a pet."] = "玩家必須有寵物"
L["If checked, player must not have a pet"] = "玩家必須沒有寵物"
L["Player"] = "玩家"
L["Pet"] = "寵物"
L["Level"] = "等級"
L["If checked, test the player's level."] = "測試:玩家等級"
L["If checked, player must be at least at this level, otherwise must be lower."] = "勾選,則玩家必須高於這個等級,否則必須低於"
L["If checked, test the player's health."] ="測試:玩家生命"
L["If checked, player's health must be at least this percentage, otherwise must be less."] = "勾選,則玩家生命必須高於這個百分比,否則必須低於"
L["If checked, test the player's power (i.e., mana, rage, energy, focus, runic power)."] = "測試:玩家法力值"
L["If checked, player's power must be at least this percentage, otherwise must be less."] = "勾選,則玩家法力值必須高於這個百分比,否則必須低於"
L["If checked, test the player's holy power."] = "測試:玩家的聖能"
L["If checked, player's holy power must be at least this many charges, otherwise must be less."] = "勾選,則玩家聖能必須高於這個數字,否則必須低於"
L["If checked, test the player's number of soul shards."] = "測試:玩家的靈魂碎片"
L["If checked, player's holy power must be at least this many charges, otherwise must be less."] ="勾選,則玩家靈魂碎片必須高於這個數字,否則必須低於"
L["If checked, test the player's eclipse power. You can set power level (-100 to -1 for lunar power, 1 to 100 for solar power) and the comparison to use (either less or greater than the power level)."] = "測試：玩家月蝕能量.你可以設置基本能量進行測試"
L["If checked, player's eclipse power must be at least this level, otherwise must be less."] ="勾選,則玩家的月蝕能量必須高於這個數字,否則必須低於"
L["If checked, test the player's eclipse status. You can test current eclipse direction (toward sun or moon) and whether lunar or solar eclipse is active."] = "測試:玩家的月蝕狀態"
L["If checked, player must be in Solar Eclipse."] = "勾選,則玩家必須在日蝕"
L["If checked, player must be in Lunar Eclipse."] = "勾選,則玩家必須在日蝕"
L["If checked, eclipse direction must be going toward the sun."] = "勾選,則玩家的月蝕能量必須正在向日蝕方向移動"
L["If checked, eclipse direction must be going toward the moon."] ="勾選,則玩家的日蝕能量必須正在向月蝕方向移動"
L["Available"] = "可用"
L["If checked, test the player's rune status."] ="測試:玩家符文"
L["Any"] = "任意"
L["If checked, at least one rune of any type must be available."] ="勾選,則最少一個該類型的符文必須可用"
L["If checked, must have at least one blood rune available (or enough death runes)."] = "勾選,則至少一個鮮血符文可用(或足夠的死亡符文)"
L["If checked, must have at least one frost rune available (or enough death runes)."] ="勾選,則至少一個冰霜符文可用(或足夠的死亡符文)"
L["If checked, must have at least one unholy rune available (or enough death runes)."] = "勾選,則至少一個邪穢符文可用(或足夠的死亡符文)"
L["Recharging"] ="補充中"
L["Not Recharging"] = ",沒有補充"
L[">= 1"] = true
L["If checked, test blood runes."] = "測試血符文"
L["If checked, at least one blood rune must be recharging, otherwise none."] = true
L["If checked, test frost runes."] ="測試冰霜符文"
L["If checked, at least one frost rune must be recharging, otherwise none."] = true
L["If checked, test unholy runes."] = "測試邪穢符文"
L["If checked, at least one unholy rune must be recharging, otherwise none."] = true
L["If checked, test how many combo points the player has on the target."] ="測試:連擊點數"
L["If checked, player must have at least this many combo points, otherwise must be fewer."] = "勾選,玩家的連擊點數必須至少有這個值,否則必須低於"
L["If checked, test the player's totem status."] = "測試:圖騰狀態"
L["If checked, must have an active totem of this type (or specific totem if Totem Name is defined)."] = "勾選,則玩家必須激活一個如下類型的圖騰."
L["If checked, must not have an active totem of this type (or specific totem if Totem Name is defined)."] = "勾選,則玩家必須未激活一個如下類型的圖騰."
L["Totem Name"] ="圖騰名稱"
L["Enter name of specific totem to check is active."] = "輸入要監視激活的圖騰名稱"
L["Health"] = "生命"
L["Power"] = "法力"
L["Minimum"] = "最小"
L["Holy Power"] = "聖能"
L["Soul Shards"] = "靈魂碎片"
L["Eclipse Power"] = "月蝕能量"
L["Eclipse State"] = "月蝕狀態"
L["Eclipse"] = "蝕"
L["Solar"] = "日"
L["Lunar"] = "月"
L[">> Sun"] = ">>日"
L[">> Moon"] = ">>月"
L["Combo Points"] = "連擊點"
L["If checked, test if the player has a mainhand weapon equipped with at least the specified item level."] = "勾選,測試玩家的主手武器物品等級必須高於設定值"
L["If checked, test if the player has an offhand weapon equipped with at least the specified item level."] ="勾選,測試玩家的副手武器物品等級必須高於設定值"
L["If checked, test if the player has an ranged weapon equipped with at least the specified item level."] = "勾選,測試玩家的遠程武器物品等級必須高於設定值"
L["If checked, test if the player is in a stance."] = "勾選,測試玩家姿態"
L['Enter the stance to check for (enter "none" to check for no stance).'] = "輸入要測試的姿態"
L["If checked, test if points have been spent in one of the player's talents."] ="勾選,測試若選擇的天賦已經啟用"
L["Weapons"] = "武器"
L["Mainhand"] = "主手"
L["Offhand"] = "副手"
L["Ranged"] = "遠程"
L["Stance"] = "姿態"
L["Talent"] = "天賦"

-- Conditions > Tests > Pet Status
L["Pet Status"] = "寵物狀態"
L["If checked, test if pet currently exists."] = "如果勾選, 檢測寵物當前狀態."
L["If checked, pet must exist."] = "如果勾選, 則寵物必須存在."
L["If checked, pet must not exist."] = "如果勾選, 則寵物必須不存在."
L["If checked, test pet's target."] = "如果勾選, 檢測寵物目標."
L["No Target"] = "無目標"
L["If checked, must not have a target."] = "如果勾選, 必須沒有目標."
L["Player's Target"] = "玩家目標"
L["If checked, must be same as player's target."] = "如果勾選, 必須與玩家目標相同."
L["Any Target"] = "任何目標"
L["If checked, must have a target."] = "如果勾選, 必須擁有一個目標."
L["If checked, test the pet's health."] = "如果勾選, 檢測寵物生命值."
L["If checked, pet's health must be at least this percentage, otherwise must be less."] = "如果勾選, 寵物生命值必須等於或高於此百分比, 不勾選則必須低於此百分比."
L["If checked, test the pet's power (i.e., mana, rage, energy, focus)."] = "如果勾選, 檢測寵物能量值 (魔法值, 怒氣值, 能量值, 集中值)."
L["If checked, pet's power must be at least this percentage, otherwise must be less."] = "如果勾選, 寵物能量值必須等於或高於此百分比, 不勾選則必須低於此百分比."

-- Conditions > Tests > Target Status
L["If checked, test if target currently exists."] = "如果勾選, 檢測目標當前狀態."
L["If checked, target must exist."] = "如果勾選, 則目標必須存在."
L["If checked, target must not exist."] = "如果勾選, 則目標必須不存在."
L["Player"] = "玩家"
L["If checked, test if the target is a player."] = "如果勾選, 檢測目標是否為玩家目標."
L["If checked, target must be a player."] = "如果勾選, 則目標必須是玩家."
L["If checked, target must not be a player."] = "如果勾選, 則目標必須不是玩家."
L["Enemy"] = "敵方"
L["If checked, test if the target is an enemy."] = "如果勾選, 檢測目標是否為敵對目標."
L["If checked, target must be an enemy."] = "如果勾選, 則目標必須是敵對目標."
L["If checked, target must not be an enemy."] = "如果勾選, 則目標必須不是敵對目標."
L["Friendly"] = "友方"
L["If checked, test if the target is friendly."] = "如果勾選, 檢測目標是否為友方目標."
L["If checked, target must be friendly."] = "如果勾選, 則目標必須是友方目標."
L["If checked, target must not be friendly."] = "如果勾選, 則目標必須不是友方目標."
L["Dead"] = "死亡"
L["If checked, test if the target is dead."] = "如果勾選, 檢測目標是否死亡."
L["If checked, target must be dead."] = "如果勾選, 則目標必須死亡."
L["If checked, target must not be dead."] = "如果勾選, 則目標必須存活."
L["Classification"] = "分類"
L["If checked, test the target's classification (you can select multiple classifications)."] = "如果勾選, 檢測目標分類 (您可以選擇多個分類)."
L["If checked, test for normal classification."] = "如果勾選, 檢測正常分類."
L["If checked, test for boss classification."] = "如果勾選, 檢測首領分類."
L["If checked, test for elite classification."] = "如果勾選, 檢測精英分類."
L["If checked, test for rare classification."] = "如果勾選, 檢測稀有分類."
L["If checked, test for rare elite classification."] = "如果勾選, 檢測稀有精英分類."
L["Range"] = "距離"
L["If checked, test if the target is in range."] = "如果勾選, 檢測目標距離."
L["If checked, target must be in range."] = "如果勾選, 則目標必須在射程內."
L["If checked, target must not be in range."] = "如果勾選, 則目標必須在射程外."
L["Spellsteal"] = "法術偷取"
L["Not Spellsteal"] = "不能法術偷取"
L["If checked, test for a buff that can be transferred to the player with Spellsteal."] = "如果勾選, 檢測是否有可以偷取的Buff."
L["If checked, there must be a spellstealable buff."] = "如果勾選, 則必須存在可以偷取的BUFF."
L["If checked, there must not be a spellstealable buff."] = "如果勾選, 則必須沒有可以偷取的BUFF."
L["If checked, test the target's health."] = "如果勾選, 檢測目標生命值."
L["If checked, target's health must be at least this percentage, otherwise must be less."] = "如果勾選, 目標生命值必須等於或高於此百分比, 不勾選則必須低於此百分比."
L["If checked, test the target's power (i.e., mana, rage, energy, focus, runic power)."] = "如果勾選, 檢測目標能量值 (魔法, 怒氣, 能量值, 集中值, 符文能量)."
L["If checked, target's power must be at least this percentage, otherwise must be less."] = "如果勾選, 目標能量值必須等於或高於此百分比, 不勾選則必須低於此百分比."

-- Conditions > Tests > Focus Status
L["If checked, test if focus currently exists."] = "如果勾選, 檢測焦點當前狀態."
L["If checked, focus must exist."] = "如果勾選, 則焦點必須存在."
L["If checked, focus must not exist."] = "如果勾選, 則焦點必須不存在."
L["If checked, test if the focus is a player."] = "如果勾選, 檢測焦點是否為玩家."
L["If checked, focus must be a player."] = "如果勾選, 則焦點必須是玩家."
L["If checked, focus must not be a player."] = "如果勾選, 則焦點必須不是玩家."
L["If checked, test if the focus is an enemy."] = "如果勾選, 檢測焦點是否為敵對目標."
L["If checked, focus must be an enemy."] = "如果勾選, 則焦點必須是敵對目標."
L["If checked, focus must not be an enemy."] = "如果勾選, 則焦點必須不是敵對目標."
L["If checked, test if the focus is friendly."] = "如果勾選, 檢測焦點是否為友方目標."
L["If checked, focus must be friendly."] = "如果勾選, 則焦點必須是友方目標."
L["If checked, focus must not be friendly."] = "如果勾選, 則焦點必須不是友方目標."
L["If checked, test if the focus is dead."] = "如果勾選, 檢測焦點是否死亡."
L["If checked, focus must be dead."] = "如果勾選, 則焦點必須死亡."
L["If checked, focus must not be dead."] = "如果勾選, 則焦點必須存活."
L["If checked, test the focus's classification (you can select multiple classifications)."] = "如果勾選, 檢測焦點的分類 (您可以選擇多個分類)."
L["If checked, test if the focus is in range."] = "如果勾選, 檢測焦點距離."
L["If checked, focus must be in range."] = "如果勾選, 則焦點必須在射程內."
L["If checked, focus must not be in range."] = "如果勾選, 則焦點必須在射程外."
L["If checked, test the focus's health."] = "如果勾選, 檢測焦點生命值."
L["If checked, focus's health must be at least this percentage, otherwise must be less."] = "如果勾選, 焦點生命值必須等於或高於此百分比, 不勾選則必須低於此百分比."
L["If checked, test the focus's power (i.e., mana, rage, energy, focus, runic power)."] = "如果勾選, 檢測焦點能量值 (魔法, 怒氣, 能量值, 集中值, 符文能量)."
L["If checked, focus's power must be at least this percentage, otherwise must be less."] = "如果勾選, 目標焦點值必須等於或高於此百分比, 不勾選則必須低於此百分比."

-- Conditions > Tests > All Buffs
L["Buff List Entry"] = "Buff列表項"
L["Test Buffs"] = "檢測Buff"
L["Who Has Buff"] = "誰擁有Buff"
L["Who Cast Buff"] = "誰施放的Buff"
L["Enter comma-separated list of buffs."] = "輸入Buff列表(多個Buff可以使用逗號分隔)."
L["If checked, test if all the buffs are active."] = "如果勾選, 檢測是否所有Buff都處於激活狀態."
L["If checked, test if any of the buffs are not active."] = "如果勾選, 檢測哪些Buff不處於激活狀態."
L["If checked, test if player buffs."] = "如果勾選, 檢測玩家Buff."
L["If checked, test if target buffs."] = "如果勾選, 檢測目標Buff."
L["If checked, test if focus buffs."] = "如果勾選, 檢測焦點Buff."
L["If checked, test if the buffs were cast by the player."] = "如果勾選, 檢測玩家施放的Buff."
L["If checked, test if the buffs were cast by anyone other than the player."] = "如果勾選, 檢測其他人施放的Buff."
L["If checked, buffs may be cast by anyone, including the player."] = "如果勾選, 檢測所有人施放的Buff."
L["On Player"] = "存在於玩家身上"
L["On Target"] = "存在於目標身上"
L["On Focus"] = "存在於焦點身上"
L["Cast By Target"] = "目標施放的"
L["Cast By Focus"] = "焦點施放的"

-- Conditions > Tests > Any Buffs
L["If checked, test if any of the buffs are active."] = "如果勾選, 檢測激活的Buff."
L["If checked, test if none of the buffs are active."] = "如果勾選, 檢測未激活的Buff."

-- Conditions > Tests > Buff Time Left
L["Buff Entry"] = "Buff 項"
L["Enter the buff to be tested."] = "輸入Buff進行測試."
L["Minutes"] = "分"
L["Seconds"] = "秒"
L["If checked, test if buff is on player."] = "如果勾選, 檢測Buff是否存在於玩家身上."
L["If checked, test if buff is on pet."] = "如果勾選, 檢測Buff是否存在於寵物身上."
L["If checked, test if buff is on target."] = "如果勾選, 檢測Buff是否存在於目標身上."
L["If checked, test if buff is on focus."] = "如果勾選, 檢測Buff是否存在於焦點身上."
L["If checked, test if the buff was cast by the player."] = "如果勾選, 檢測玩家施放的Buff."
L["If checked, test if the buff was cast by anyone other than the player."] = "如果勾選, 檢測其他人施放的Buff."
L["If checked, buff may be cast by anyone, including the player."] = "如果勾選, 檢測所有人施放的Buff."

-- Conditions > Tests > Buff Count
L["Enter buff to test for stack count (if buff doesn't stack then its count is 0)."] = "輸入Buff測試堆疊層數 (如果Buff無法堆疊則層數為0)."
L["Stack Count"] = "堆疊層數"
L["Enter value to compare with the buff stack count."] = "輸入Buff堆疊層數比較值."
L["Comparison"] = "比較"

-- Conditions > Tests > Buff Type
L["Player Has Buff"] = "玩家的Buff"
L["If checked, player must have a mainhand buff."] = "如果勾選, 玩家必須擁有主手武器Buff."
L["If checked, player must have an offhand buff."] = "如果勾選, 玩家必須擁有副手武器Buff."
L["If checked, player must have a ranged buff."] = "如果勾選, 玩家必須擁有遠程武器Buff."
L["If checked, true if player has a buff of the specified type."] = "如果勾選, 如果玩家擁有一個指定類型的Buff，則結果為正確."
L["If checked, true if player does not have a buff of the specified type."] = "如果勾選, 如果玩家未擁有一個指定類型的Buff，則結果為正確."
L["Result"] = "結果"

-- Conditions > Tests > All Debuffs
L["Debuff List Entry"] = "Debuff 列表項"
L["Test Debuffs"] = "測試Debuff"
L["Who Has Debuff"] = "誰擁有Debuff"
L["Who Cast Debuff"] = "誰施放的Debuff"
L["Enter comma-separated list of debuffs."] = "輸入Debuff列表(多個Debuff可以使用逗號分隔)."
L["If checked, test if all the debuffs are active."] = "如果勾選, 檢測是否所有Debuff都處於激活狀態."
L["If checked, test if any of the debuffs are not active."] = "如果勾選, 檢測哪些Debuff不處於激活狀態."
L["If checked, test if debuff is on player."] = "如果勾選, 檢測玩家Debuff."
L["If checked, test if debuff is on pet."] = "如果勾選, 檢測寵物Debuff."
L["If checked, test if debuff is on target."] = "如果勾選, 檢測目標Debuff."
L["If checked, test if debuff is on focus."] = "如果勾選, 檢測焦點Debuff."
L["If checked, test if the debuffs were cast by the player."] = "如果勾選, 檢測玩家施放的Debuff."
L["If checked, test if the debuffs were cast by anyone other than the player."] = "如果勾選, 檢測其他人施放的Debuff."
L["If checked, debuffs may be cast by anyone, including the player."] = "如果勾選, 檢測所有人施放的Debuff."

-- Conditions > Tests > Any Debuffs
L["If checked, test if any of the debuffs are active."] = "如果勾選, 檢測激活的Debuff."
L["If checked, test if none of the debuffs are active."] = "如果勾選, 檢測未激活的Debuff."

-- Conditions > Tests > Debuff Time Left
L["Enter the debuff to be tested."] = "輸入Deuff進行測試."
L["Debuff Entry"] = "Debuff 項"
L["If checked, test if the debuff was cast by the player."] = "如果勾選, 檢測玩家施放的Debuff."
L["If checked, test if the debuff was cast by anyone other than the player."] = "如果勾選, 檢測其他人施放的Debuff."
L["If checked, debuff may be cast by anyone, including the player."] = "如果勾選, 檢測所有人施放的Debuff."

-- Conditions > Tests > Debuff Count
L["Enter debuff to test for stack count (if debuff doesn't stack then its count is 0)."] = "輸入Debuff測試堆疊層數 (如果Debuff無法堆疊則層數為0)."
L["Enter value to compare with the debuff stack count."] = "輸入Debuff堆疊層數比較值."

-- Conditions > Tests > Debuff Type
L["Player Has Debuff"] = "玩家的Deuff"
L["If checked, player must have a poison debuff."] = "如果勾選 玩機必須擁有毒藥Debuff."
L["If checked, player must have a disease debuff."] = "如果勾選 玩機必須擁有疾病Debuff."
L["If checked, player must have a curse debuff."] = "如果勾選 玩機必須擁有詛咒Debuff."
L["If checked, player must have a magic debuff."] = "如果勾選 玩機必須擁有魔法Debuff."
L["If checked, true if player has a debuff of the specified type."] = "如果勾選, 如果玩家擁有一個指定類型的Debuff，則結果為正確."
L["If checked, true if player does not have a debuff of the specified type."] = "如果勾選, 如果玩家未擁有一個指定類型的Debuff，則結果為正確."

-- Conditions > Tests > All Cooldowns
L["Spell List Entry"] = "技能列表項"
L["If checked, test if spells are usable (i.e., enough mana, reagents, etc.)."] = "如果勾選, 檢測可用的技能 (例如, 擁有足夠的魔法, 藥劑, 等等.)."
L["Enter comma-separated list of spells."] = "輸入技能列表(多個技能可以使用逗號分隔)."
L["Enter seconds for cooldown time left check."] = "輸入冷卻時間進行檢測,單位為秒."

-- Conditions > Tests > Spell Ready
L["Spell Entry"] = "技能項"
L["Spell"] = "技能"
L["Enter spell to test if ready to be cast."] = "輸入技能檢測它是否可以被釋放."
L["If checked, test if spell is on global cooldown, otherwise ignore global cooldown."] = "如果勾選, 則檢測技能是否處於公共冷卻, 如果不勾選則忽略公共冷卻."
L["Is Usable"] = "可用"
L["If checked, test if spell is usable (i.e., enough mana, reagents, etc.)."] = "如果勾選, 檢測法術是否可用 (例如, 擁有足夠的魔法, 藥劑, 等等.)."
L["If checked, also test if the target is in range of the spell."] = "如果勾選, 則同時檢測目標是否處於技能射程內."
L["If checked, target must be in range."] = "如果勾選, 則目標必須處於射程內."
L["If checked, target must be out of range."] = "如果勾選, 則目標必須處於射程外."

-- Conditions > Tests > Spell Casting
L["Enter spell to test if being cast or channeled."] = "輸入技能測試它是讀條法術或是通道法術."
L["Who Is Casting"] = "誰施放"
L["If checked, test player casting."] = "如果勾選, 檢測玩家施放."
L["If checked, test target casting."] = "如果勾選, 檢測目標施放."
L["If checked, test focus casting."] = "如果勾選, 檢測焦點施放."

-- Conditions > Tests > Item Ready
L["Item Entry"] = "物品記錄"
L["Item"] = "物品"
L["Enter name or itemID of item to test. Item must be in the player's bags. Use generic cooldown names for Potions and Elixirs."] = "輸入物品名稱或ID進行測試. 物品必須在您的背包中. 使用藥劑以及合劑的通用冷卻名."
L["Ready"] = "就緒"
L["If checked, test if the item is ready to use."] = "如果勾選, 檢測物品是否已經可以使用."
L["If checked, item must be ready."] = "如果勾選, 物品必須可以使用."
L["If checked, item must not be ready."] = "如果勾選, 物品必須不可使用."
L["If checked, test item count."] = "如果勾選, 檢測物品數量."
L["Enter value to compare with item count."] = "輸入物品數量參考值."
L["Charges"] = "費用"
L["If checked, test the number of charges on the item(s)."] = "如果勾選, 測試物品所需費用."
L["Enter value to compare with the number of charges."] = "輸入物品所需費用的參考值."

-- Conditions > Tests > Result
L["Dependencies"] = "依賴關系"
L["Dependencies string"] = "相關在其他條件使特定的結果必須評估此條件的結果是正確的. " ..
	"一個 \"And\" 邏輯關系分組 (全部 \"And\" 依賴關系必須評估他們的指定結果) " ..
	"或者 \"Or\" (至少有一個 \"Or\" 依賴關系必須評估他們的指定結果). " ..
	"檢測依賴關系前記錄所有其他評估測試條件.\n"
L["True"] = "正確"
L["Condition is true only if the selected condition evaluates to true."] = "只有選擇的條件被檢測為正確時，條件才被判定為正確."
L["False"] = "錯誤"
L["Condition is true only if the selected condition evaluates to false."] = "只有選擇的條件被檢測為錯誤時，條件才被判定為錯誤."
L["And/Or"] = true
L["And"] = true
L["Or"] = true
L["Toggle between logical \"And\" and \"Or\" for this dependecy."] = "在 \"And\" 以及 \"Or\" 依賴關系之間切換顯示."
L["Delete"] = "刪除"
L["Delete this condition from the dependencies list."] = "從依賴關系列表中刪除此條件."
L["Test Evaluation"] = "評估測試"
L["If checked, evaluate all enabled tests with logical \"And\" (i.e., all tests must be true), othewise use logical \"Or\" (i.e., only one test must be true)."] = "如果勾選, 評估所有啟用的 \"And\" 測試 (i.e., 所有測試結果必須為正確), 否則使用 \"Or\" (i.e., 只需要一個測試結果為正確)."
L["Toggle Result"] = "顯示結果"
L["If checked, the result for this condition, after evaluating all tests and checking dependencies, is toggled."] = "如果勾選, 此條件的結果, 將在所有的依賴關系檢測完畢之後顯示."
L["Set Result"] = "設置結果"
L["If checked, the result for this condition is set to true or false (this feature is provided to help debug conditions)."] = "如果勾選, 此條件的結果設置為正確或錯誤 (此功能用於調試插件)."
L["If checked, result is set to true."] = "如果勾選, 此條件的結果設置為正確."
L["If checked, result is set to false."] = "如果勾選, 此條件的結果設置為錯誤."

-- In-Combat Buffs tab
L["In-Combat Bar"] = "In-Combat條"
L["Enable In-Combat Bar"] = "啟用In-Combat條"
L["In-combat string"] = "Raven 包含一個可選項 \"in-combat bar\" 使你可以在戰鬥中取消Buff. 您可以設置計時條的外觀以及設置您需要取消的Buff列表. 當您選定的Buff在戰鬥中激活, Buff圖標將在In-Combat條上顯示你可以右鍵點擊取消Buff. |cffedd400請註意:|r 您可能需要重載以應用設置.\n"
L["Enable in-combat buffs string"] = "啟用顯示BUFF圖標的欄位，您可以在戰鬥中右鍵單擊用來取消BUFF."
L["Lock Bar Layout"] = "鎖定In-Combat條"
L["Lock in-combat string"] = "設置完畢後隱藏計時條."
L["Link Bar Layout"] = "連接In-Combat條"
L["Link in-combat settings string"] = "共享所有的In-Combat條設置(但不包括Buff列表)."
L["Out Of Combat"] = "脫離戰鬥"
L["If checked, also display buffs on the bar when out of combat."] = "如果勾選, 脫離戰鬥之後將依然顯示Buff."
L["Enter in-combat buff string"] = "輸入Buff名稱將它添加到 In-Combat Buff 列表."
L["Buff List"] = "Buff列表"
L["Delete the selected buff from the in-combat list."] = "從 In-Combat Buff 列表列表中刪除選擇的Buff."
L["Reset the in-combat buff list."] = "重置 In-Combat Buff 列表."
L["Set size for the buff icons."] = "設置Buff圖標大小."
L["Horizontal Bar"] = "橫向"
L["Configure as a horizontal bar of buff icons."] = "設置Buff圖標橫向顯示."
L["Vertical Bar"] = "縱向"
L["Configure as a vertical bar of buff icons."] = "設置Buff圖標縱向顯示."
L["Spacing"] = "間距"
L["Set spacing between the buff icons."] = "設置Buff圖標間距."
L["Set scale factor for the bar."] = "設置In-Combat條比例."
L["Set opacity for the bar."] = "設置In-Combat條透明度."
L["Mainhand Weapon"] = "主手武器"
L["Offhand Weapon"] = "副手武器"
L["Ranged Weapon"] = "遠程武器"
L["Enter name of anchor frame to attach to (leave blank to enable manual positioning)."] = "輸入錨點依附框體 (如果為空白則需要手動定位)."

-- Highlights tab
L["Highlights"] = "高亮"
L["Highlights string"] = "如果您使用 Bartender4, Dominos or Macaroon 則您可以使用按鈕高亮" ..
	"如果 buffs 以及 debuffs 是您施放的 (它們將要消失時將會閃爍顯示). " ..
	"高亮可以出現在特定的時間並且優先級為目標-焦點-玩家. " ..
	"您還可以在按鈕上顯示物品以及法術的冷卻計時 (如果OmniCC為加載狀態，則禁用該功能).\n"
L["Enable Highlights"] = "啟用高亮"
L["If checked, enable Raven's support for button highlights and cooldown counts."] = "如果勾選, 啟用 Raven的按鈕高亮以及冷卻計時功能."
L["Use ButtonFacade"] = "使用ButtonFacade"
L["Enable setting highlights through ButtonFacade if it is loaded. This is not ideal for every BF skin which is why it can be disabled. Try both enabled and disabled settings and see which works best."] = "如果ButtonFacade被啟用則通過它啟用高亮設置. 並不是每個BF皮膚都能支持,這也是為什麽它被禁用. "
L["Highlight Buffs"] = "Buff高亮"
L["Enable player buff highlights on buttons."] = "在按鈕上啟用玩家Buff高亮."
L["Buff Color"] = "Buff顏色"
L["Set player buff highlight color."] = "設置玩家Buff高亮顏色."
L["Highlight Debuffs"] = "Debuff高亮"
L["Enable player debuff highlights on buttons."] = "在按鈕上啟用玩家Debuff高亮."
L["Debuff Color"] = "Debuff顏色"
L["Set player debuff highlight color."] = "設置玩家Debuff高亮顏色."
L["Enable target buff highlights on buttons."] = "在按鈕上啟用目標Buff高亮."
L["Set target buff highlight color."] = "設置目標Buff高亮顏色."
L["Enable target debuff highlights on buttons."] = "在按鈕上啟用目標Debuff高亮."
L["Set target debuff highlight color."] = "設置目標Debuff高亮顏色."
L["Enable focus buff highlights on buttons."] = "在按鈕上啟用焦點Buff高亮."
L["Set focus buff highlight color."] = "設置焦點Buff高亮顏色."
L["Enable focus debuff highlights on buttons."] = "在按鈕上啟用焦點Debuff高亮."
L["Set focus debuff highlight color."] = "設置焦點Debuff高亮顏色."
L["Flashing"] = "閃爍"
L["Enable highlight flashing for expiring buffs and debuffs."] = "啟用Buff/Debuff將要結束時閃爍顯示."
L["Set number of seconds to flash before buffs and debuffs expire."] = "設置Buff/Debuff結束時間數值，單位為秒."
L["Cooldown Time"] = "冷卻時間"
L["Show cooldown time remaining on buttons."] = "在按鈕上顯示剩余冷卻時間."
L["Set font size for cooldown time text overlay."] = "設置冷卻時間字體大小."
L["Font"] = "字體"
L["Select font for cooldown time text overlay."] = "選擇冷卻時間文本字體."
L["Cooldown format string"] = "選擇冷卻時間格式. 這裏可以選擇五種範圍: " ..
	"大於一小時, 2分鐘到1小時, 1分鐘到2分鐘, 10秒到1分鐘, 少於10秒. " ..
	"您可以在下拉菜單中選擇."
L["Alignment"] = "校準"
L["Vertical:"] = "縱向:"
L["Horizontal:"] = "橫向:"
L["If checked, vertically align cooldown text to top."] = "如果勾選, 在頂部縱向排列冷卻文本."
L["If checked, vertically align cooldown text in middle."] = "如果勾選, 在中部縱向排列冷卻文本."
L["If checked, vertically align cooldown text to bottom."] = "如果勾選, 在底部縱向排列冷卻文本."
L["If checked, horizontally align cooldown text to left."] = "如果勾選, 在左側橫向直排列冷卻文本."
L["If checked, horizontally align cooldown text in center."] = "如果勾選, 在中心橫向直排列冷卻文本."
L["If checked, horizontally align cooldown text to right."] = "如果勾選, 在右側橫向直排列冷卻文本."

-- Inserted Bar Information tab
L["Bar Information"] = "計時條信息"
L["Custom Sort Order"] = "自定義排序"
L["Move Up"] = "置頂"
L["Move the bar up, overriding sort order."] = "移動到計時條頂部."
L["Move Down"] = "下沈"
L["Move the bar down, overriding sort order."] = "移動到計時條底部."
L["If checked, enable showing the bar."] = "如果勾選, 則顯示計時條."
L["Enter label text for the bar."] = "啟用計時條標簽文本."
L["Label Link"] = "標簽關聯"
L["If checked, label is linked to the associated spell and changing it here will change it for all bars linked to the same spell."] = "如果勾選, 設置標簽所關聯的法術以及同類法術."
L["Show When Ready"] = "準備就緒後顯示"
L["If checked, show ready bar when action is not on cooldown."] = "如果勾選, 則計時條激活時表示技能不再冷卻狀態."
L["Show Not Active"] = "為激活時顯示"
L["If checked, show ready bar when action is not active."] = "如果勾選, 則計時條激活時表示技能未激活."
L["Usable"] = "可用"
L["If checked, show ready bar only if spell is usable (i.e., enough mana, reagents, etc.)."] = "如果勾選, 則只有技能為可用時才會激活計時條 (例如擁有足夠的魔法, 藥劑, 等等.)."
L["Show Time"] = "顯示時間"
L["Set number of seconds to show the ready bar (0 for unlimited time)."] = "設置顯示計時條的時間數值.數值單位為秒 (0為最大時間)."
L["Color and Icon"] = "顏色以及圖標"
L["Use Spell Color"] = "使用法術顏色"
L["If checked, use color from associated spell."] = "如果勾選, 則使用技能相關的顏色."
L["Use Spell Icon"] = "使用技能圖標"
L["If checked, use icon from associated spell."] = "如果勾選, 則使用技能圖標."
L["Color Link"] = "顏色關聯"
L["If checked, the color is linked to the associated spell and changing it here will change it for all bars linked to the same spell."] = "如果勾選, 設置顏色所關聯的法術以及同類法術."
L["Hide"] = "隱藏"
L["If checked, bar is conditionally hidden."] = "如果勾選, 計時條將有條件的隱藏."
L["If checked, bar is hidden if the condition is true."] = "如果勾選, 如果符合條件則計時條將隱藏."
L["If checked, bar is hidden if the condition is false."] = "如果勾選, 如果不符合條件則計時條將隱藏."
L["Hide Condition"] = "隱藏條件"
L["Flash"] = "閃爍"
L["If checked, bar will conditionally flash."] = "如果勾選, 計時條將有條件的閃爍."
L["If checked, bar will flash if the condition is true."] = "如果勾選, 如果符合條件則計時條將閃爍."
L["If checked, bar will flash if the condition is false."] = "如果勾選, 如果不符合條件則計時條將閃爍."
L["Flash Condition"] = "閃爍條件"
L["Fade"] = "淡化"
L["If checked, bar will conditionally change from normal opacity to fade opacity."] = "如果勾選, 計時條將有條件的從正常透明度變為淡化透明度."
L["If checked, bar will fade if the condition is true."] = "如果勾選, 如果符合條件則計時條將淡化."
L["If checked, bar will fade if the condition is false."] = "如果勾選, 如果不符合條件則計時條將淡化."
L["Fade Condition"] = "淡化條件"
L["Normal Opacity"] = "正常透明度"
L["Set normal opacity for this bar."] = "設置此計時條正常透明度."
L["Fade Opacity"] = "淡化透明度"
L["Set fade opacity for this bar."] = "設置此計時條淡化透明度."
L["Set opacity for faded bars."] = "設置淡化的計時條透明度."
L["Ready Opacity"] = "已就緒透明度"
L["Set opacity for ready bar."] = "設置已就緒的計時條透明度."
L["Type"] = "類型"
L["If checked, this is a notify bar."] = "如果勾選, 將此計時條類型設置為通告."
L["If checked, this is a buff bar."] = "如果勾選, 將此計時條類型設置為Buff."
L["If checked, this is a debuff bar."] = "如果勾選, 將此計時條類型設置為Debuff."
L["If checked, this is a cooldown bar."] = "如果勾選, 將此計時條類型設置為冷卻."
L["Source"] = "來源"
L["Race"] = "種族"
L["If checked, select actions associated with a class."] = "如果勾選, 將該技能關聯給一個職業."
L["If checked, select actions associated with a pet."] = "如果勾選, 將該技能關聯給寵物."
L["If checked, select actions associated with a race."] = "如果勾選, 將該技能關聯給一個種族."
L["If checked, enter spell name for an associated action."] = "如果勾選, 輸入相關的法術名稱."
L["Druid"] = "德魯伊"
L["If checked, select druid actions."] = "如果勾選, 則選擇為德魯伊技能."
L["Hunter"] = "獵人"
L["If checked, select hunter actions."] = "如果勾選, 則選擇為獵人技能."
L["Mage"] = "法師"
L["If checked, select mage actions."] = "如果勾選, 則選擇為法師技能."
L["Paladin"] = "聖騎士"
L["If checked, select paladin actions."] = "如果勾選, 則選擇為聖騎士技能."
L["Priest"] = "牧師"
L["If checked, select priest actions."] = "如果勾選, 則選擇為牧師技能."
L["Rogue"] = "潛行者"
L["If checked, select rogue actions."] = "如果勾選, 則選擇為潛行者技能."
L["Shaman"] = "薩滿祭司"
L["If checked, select shaman actions."] = "如果勾選, 則選擇為薩滿祭司技能."
L["Warlock"] = "術士"
L["If checked, select warlock actions."] = "如果勾選, 則選擇為術士技能."
L["Warrior"] = "戰士"
L["If checked, select warrior actions."] = "如果勾選, 則選擇為戰士技能."
L["Death Knight"] = "死亡騎士"
L["If checked, select death knight actions."] = "如果勾選, 則選擇為死亡騎士技能."
L["Conditions To Monitor"] = "條件檢測"
L["Select all the conditions."] = "選擇全部條件."
L["Deselect all the conditions."] = "反選全部條件."
L["Other Spell"] = "其他技能"
L["Enter spell name (or numeric identifier) to associate with a bar."] = "輸入技能名稱將它關聯到計時條."
L["Actions To Monitor"] = "技能檢測"
L["All On"] = "所有"
L["Select all the actions."] = "選擇所有技能."
L["All Off"] = "關閉"
L["Deselect all the actions."] = "反選所有技能."
L["If checked, must be on the player."] = "如果勾選, 則必須為玩家."
L["If checked, must be on the player's pet."] = "如果勾選, 則必須為玩家寵物."
L["If checked, must be on the target."] = "如果勾選, 則必須為目標."
L["If checked, must be on the focus."] = "如果勾選, 則必須為焦點."
L["If checked, must be on the mouseover unit."] = "如果勾選, 則必須為指向單位."
L["If checked, must be on the pet's target."] = "如果勾選, 則必須為寵物目標."
L["If checked, must be on the target's target."] = "如果勾選, 則必須為目標的目標."
L["If checked, must be on the focus's target."] = "如果勾選, 則必須為焦點目標."
L["If checked, only track if cast by the player."] = "如果勾選, 則只監視玩家施放的."
L["If checked, only track if cast by the player's pet."] = "如果勾選, 則只監視玩家寵物施放的."
L["If checked, only track if cast by anyone other than the player."] = "如果勾選, 則只監視除玩家之外單位施放的."
L["If checked, track if cast by anyone, including player and pet."] = "如果勾選, 則監視所有單位施放的."
L["OK"] = "同意"
L["Confirm creating new bars for the selected actions/conditions."] = "確定為選擇的技能/條件創建一個新計時條."
L["Cancel creating new bars."] = "取消創建新計時條."

L["Enrage"] = "激怒"
L["Include enrage debuffs."] = "包含激怒debuff"
L["Required Class"] = "所需職業"
L["Enter class required for internal cooldown (leave blank if all classes can trigger internal cooldown)."] = "輸入觸發內置CD的職業(留空則所有的職業都可以觸發)"

------- New Entries September 6, 2011
L["If checked, hide count overlay text on icon."] = "如果勾選，則隱藏覆蓋圖標層數文字"
L["If checked, set \"Left\" alignment for icon text."] ="如果勾選，設置文本\"左對齊\"" 
L["If checked, set \"Center\" alignment for icon text."] = "如果勾選，設置文本\"居中對齊\"" 
L["If checked, set \"Right\" alignment for icon text."] = "如果勾選，設置文本\"右對齊\"" 
------- New Entries October 1, 2011 
L["Castable"] = "可施放的" 
L['Include buffs that the player can cast.'] = "包括玩家施放的Buff" 
L['Include debuffs that the player can cast.'] = "包括玩家施放的Debuff" 
L["NPC"] = true 
L['Include buffs cast by an NPC (note: only valid while caster is selected, such as when checking target of target).'] ="包括NPC施放的Buff（注：只有當施法者被選中時有效，比如監視目標的目標）" 
L['Include debuffs cast by an NPC (note: only valid while caster is selected, such as when checking target of target).'] ="包括NPC施放的DeBuff（注：只有當施法者被選中時有效，比如監視目標的目標）" 
L['Include buffs cast by a vehicle (note: only valid while caster is selected, such as when checking target of target).'] = "包括載具施放的Buff（注：只有當施法者被選中時有效，比如監視目標的目標）" 
L['Include debuffs cast by a vehicle (note: only valid while caster is selected, such as when checking target of target).'] = "包括載具施放的DeBUFF（注：只有當施法者被選中時有效，比如監視目標的目標）" 
