---@type SeasonOfDiscovery
local SeasonOfDiscovery = QuestieLoader:ImportModule("SeasonOfDiscovery")
---@type QuestieDB
local QuestieDB = QuestieLoader:ImportModule("QuestieDB")
---@type ZoneDB
local ZoneDB = QuestieLoader:ImportModule("ZoneDB")

--- Load the base quests for Season of Discovery
--- These are generated, do NOT EDIT the data entries here.
--- If you want to edit an item, do so in sodItemFixes.lua
function SeasonOfDiscovery:LoadBaseItems()
    local itemKeys = QuestieDB.itemKeys
    local itemClasses = QuestieDB.itemClasses

    return {
        [202251] = {
            [itemKeys.name] = "Bag of Pet Treats",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [202254] = {
            [itemKeys.name] = "Bracers of Redirection",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [202256] = {
            [itemKeys.name] = "Privateer's Ornate Pistol",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [202316] = {
            [itemKeys.name] = "Runecarving Test - Crippling Poison",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [202641] = {
            [itemKeys.name] = "Mud-covered notebook",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [203723] = {
            [itemKeys.name] = "Cutty's Note",
            [itemKeys.npcDrops] = {103},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [203726] = {
            [itemKeys.name] = "Cutty's Rune",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [203745] = {
            [itemKeys.name] = "Spell Notes: Ice Lance",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [203746] = {
            [itemKeys.name] = "Spell Notes: Living Flame",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [203747] = {
            [itemKeys.name] = "Spell Notes: Fingers of Frost",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [203748] = {
            [itemKeys.name] = "Spell Notes: Burnout",
            [itemKeys.npcDrops] = {208275,208752,202060},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [203749] = {
            [itemKeys.name] = "Spell Notes: Enlightenment",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [203750] = {
            [itemKeys.name] = "Elwynn Treasure Map",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [203751] = {
            [itemKeys.name] = "Spell Notes: CALE ENCI",
            [itemKeys.npcDrops] = {1507,38},
            [itemKeys.objectDrops] = {404695,405633},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [203752] = {
            [itemKeys.name] = "Spell Notes: MILEGIN VALF",
            [itemKeys.npcDrops] = {3199,3195,1536,1537,3196,3198,3197,1124,1397,476,1535},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [203753] = {
            [itemKeys.name] = "Spell Notes: RING SEFF OSTROF",
            [itemKeys.npcDrops] = {1119,1130,1137,3204,1132,1271,1961,1388,208196,208638,448,3205},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [203754] = {
            [itemKeys.name] = "Archmage Antonidas: The Unabridged Autobiography",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {386691},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [203755] = {
            [itemKeys.name] = "Archmage Theocritus's Research Journal",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {386759},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [203756] = {
            [itemKeys.name] = "Azora Apprentice Notes: Page 1",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [203784] = {
            [itemKeys.name] = "Top-Right Map Piece",
            [itemKeys.npcDrops] = {257,475,40,40,257,80,476,475,6},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [203785] = {
            [itemKeys.name] = "Top-Left Map Piece",
            [itemKeys.npcDrops] = {474,6866,116,103,116,38,94,474},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [203786] = {
            [itemKeys.name] = "Bottom-Right Map Piece",
            [itemKeys.npcDrops] = {46,285,735,46,732},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [203787] = {
            [itemKeys.name] = "Bottom-Left Map Piece",
            [itemKeys.npcDrops] = {478,97,478},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [203960] = {
            [itemKeys.name] = "Azora Apprentice Notes: Page 2",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [203961] = {
            [itemKeys.name] = "Azora Apprentice Notes: Page 3",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [203962] = {
            [itemKeys.name] = "Azora Apprentice Notes: Page 4",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [203990] = {
            [itemKeys.name] = "Rune of Mutilation",
            [itemKeys.npcDrops] = {2038},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [203991] = {
            [itemKeys.name] = "Rune of Quick Draw",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {386675},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [203992] = {
            [itemKeys.name] = "Rune of Trickery",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [203993] = {
            [itemKeys.name] = "Rune of Slaughter",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {404941,407734,387466},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [203994] = {
            [itemKeys.name] = "Rune of Deadly Brew",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [204174] = {
            [itemKeys.name] = "Rune of Precision",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {405201,407352,405946,404830,386777},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [204270] = {
            [itemKeys.name] = "Fathom Core",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [204441] = {
            [itemKeys.name] = "Rune of Blood Frenzy",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {392029},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [204476] = {
            [itemKeys.name] = "Severed Kobold Head",
            [itemKeys.npcDrops] = {327,40,475},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [204477] = {
            [itemKeys.name] = "Severed Murloc Head",
            [itemKeys.npcDrops] = {46,1543,1545,1544,735,285},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [204478] = {
            [itemKeys.name] = "Severed Gnoll Head",
            [itemKeys.npcDrops] = {448,1941,2951,1674,1675,2950,2949,97,478},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [204688] = {
            [itemKeys.name] = "Monster Hunter's First Rune Fragment",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [204689] = {
            [itemKeys.name] = "Monster Hunter's Second Rune Fragment",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [204690] = {
            [itemKeys.name] = "Monster Hunter's Third Rune Fragment",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [204703] = {
            [itemKeys.name] = "Rune of Devastate",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [204716] = {
            [itemKeys.name] = "Rune of Frenzied Assault",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [204795] = {
            [itemKeys.name] = "Rune of Shadowstrike",
            [itemKeys.npcDrops] = {1506},
            [itemKeys.objectDrops] = {405628,406006,404911,387477},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [204804] = {
            [itemKeys.name] = "Hydraxian Bangles",
            [itemKeys.npcDrops] = {202699},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [204806] = {
            [itemKeys.name] = "Rune of Victory Rush",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {406736,403102,404911,397987},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [204807] = {
            [itemKeys.name] = "Fathomblade",
            [itemKeys.npcDrops] = {202699},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [204809] = {
            [itemKeys.name] = "Rune of Furious Thunder",
            [itemKeys.npcDrops] = {100,1137,5785,5823,6113,207515,448,1388,3204,5807,1271,208638,3058,3131,5786,208196,3281,327},
            [itemKeys.objectDrops] = {407734},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [204864] = {
            [itemKeys.name] = "Azora Apprentice Notes",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [204905] = {
            [itemKeys.name] = "Ominous Tome",
            [itemKeys.npcDrops] = {881,476,474},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [204906] = {
            [itemKeys.name] = "Gnoll Blood",
            [itemKeys.npcDrops] = {97,1674,1675,1941,478},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [204907] = {
            [itemKeys.name] = "Wolf Jawbone",
            [itemKeys.npcDrops] = {1133,1138,1922,69,704,118,1131,525,299,705},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [204910] = {
            [itemKeys.name] = "Monster - Trident, Naga (Gold)",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [204912] = {
            [itemKeys.name] = "Rune of Grace",
            [itemKeys.npcDrops] = {204070},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [205019] = {
            [itemKeys.name] = "Tainted Soul Shard",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [205020] = {
            [itemKeys.name] = "Pure Soul Shard",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [205022] = {
            [itemKeys.name] = "Rune of Soul Siphon",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [205181] = {
            [itemKeys.name] = "Unidentified Artifact",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {208223,205364},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [205182] = {
            [itemKeys.name] = "Powerless Artifact",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [205183] = {
            [itemKeys.name] = "Fel-Powered Artifact",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [205184] = {
            [itemKeys.name] = "Acolyte's Note",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {205364},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [205215] = {
            [itemKeys.name] = "Rune of Tactics",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [205218] = {
            [itemKeys.name] = "Libram of Discovery",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [205228] = {
            [itemKeys.name] = "Rune of Chaos Bolt",
            [itemKeys.npcDrops] = {208275,208752,202060},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [205230] = {
            [itemKeys.name] = "Rune of Haunting",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {404695,387477,406736,405633},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [205364] = {
            [itemKeys.name] = "Acolyte's Knapsack",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [205420] = {
            [itemKeys.name] = "Libram of Judgement",
            [itemKeys.npcDrops] = {706,38},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [205683] = {
            [itemKeys.name] = "Rune of Rebuke",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [205685] = {
            [itemKeys.name] = "Rune of Aegis",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [205863] = {
            [itemKeys.name] = "Corrupted Libram",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [205864] = {
            [itemKeys.name] = "Charred Note",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [205897] = {
            [itemKeys.name] = "Rune of Martyrdom",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [205905] = {
            [itemKeys.name] = "Memory of a Devout Champion",
            [itemKeys.npcDrops] = {212809,210537},
            [itemKeys.objectDrops] = {208766,414663},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [205932] = {
            [itemKeys.name] = "Prophecy of a King's Demise",
            [itemKeys.npcDrops] = {209742},
            [itemKeys.objectDrops] = {411674,414646},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [205940] = {
            [itemKeys.name] = "Memory of a Dark Purpose",
            [itemKeys.npcDrops] = {3129,3128,1211,208196,327},
            [itemKeys.objectDrops] = {407734},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [205942] = {
            [itemKeys.name] = "Chimaeric Epiphany",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [205943] = {
            [itemKeys.name] = "Prophecy of a Desecrated Citadel",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [205944] = {
            [itemKeys.name] = "Reciprocal Epiphany",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [205945] = {
            [itemKeys.name] = "Memory of an Imprisoned Savior",
            [itemKeys.npcDrops] = {471,1119,3204,5822,8503,60,476,5808,13157,1935,6124,1934,2038,3205,40},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [205946] = {
            [itemKeys.name] = "Memory of a Leader's Betrayal",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [205947] = {
            [itemKeys.name] = "Prophecy of a Desecrated Citadel",
            [itemKeys.npcDrops] = {3118,1536,2004,2005,3113,1124,2003,2002,3207,3206,1397,474,1535},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [205948] = {
            [itemKeys.name] = "Anodyne Epiphany",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [205949] = {
            [itemKeys.name] = "Manifold Epiphany",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [205950] = {
            [itemKeys.name] = "Tenebrous Epiphany",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = {213077,214070,214096,214098,214099,214101},
            [itemKeys.startQuest] = nil,
        },
        [205951] = {
            [itemKeys.name] = "Memory of a Troubled Acolyte",
            [itemKeys.npcDrops] = {80},
            [itemKeys.objectDrops] = {405633},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [205952] = {
            [itemKeys.name] = "Memory of a Shattered World",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [205953] = {
            [itemKeys.name] = "Prophecy of a Broken Vow",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [205961] = {
            [itemKeys.name] = "Mulgore Bird Meat",
            [itemKeys.npcDrops] = {2957,2970,2969,2956},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [205979] = {
            [itemKeys.name] = "Rune of Flanking",
            [itemKeys.npcDrops] = {205382,208812,208124,209928},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [205995] = {
            [itemKeys.name] = "Prairie Dog Musk",
            [itemKeys.npcDrops] = {2951,2949,2950},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [206032] = {
            [itemKeys.name] = "Rune of Carve",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [206155] = {
            [itemKeys.name] = "Rune of Marksmanship",
            [itemKeys.npcDrops] = {205700,209812,208180},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [206157] = {
            [itemKeys.name] = "Seaforium Mining Charge",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [206159] = {
            [itemKeys.name] = "Venture Co Disguise",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [206168] = {
            [itemKeys.name] = "Rune of the Chimera",
            [itemKeys.npcDrops] = {1994,3124},
            [itemKeys.objectDrops] = {405628},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [206169] = {
            [itemKeys.name] = "Rune of Explosive Shot",
            [itemKeys.npcDrops] = {3056,1132,1137,3068,5807,1271,1961,3058,208638,1388,7318,3281},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [206170] = {
            [itemKeys.name] = "Windfury Cone",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [206175] = {
            [itemKeys.name] = "Pine Salve",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [206176] = {
            [itemKeys.name] = "Mortar and Pestle",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [206177] = {
            [itemKeys.name] = "Pine Nut Butter",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [206264] = {
            [itemKeys.name] = "Rune of Inspiration",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [206344] = {
            [itemKeys.name] = "Knife Set",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [206345] = {
            [itemKeys.name] = "Fish Chunks",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [206376] = {
            [itemKeys.name] = "Bulwark Icon",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [206381] = {
            [itemKeys.name] = "Dyadic Icon",
            [itemKeys.npcDrops] = {2953,3124},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [206382] = {
            [itemKeys.name] = "Tempest Icon",
            [itemKeys.npcDrops] = {1972},
            [itemKeys.objectDrops] = {152618,152608,3642},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [206383] = {
            [itemKeys.name] = "Lithic Icon",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [206384] = {
            [itemKeys.name] = "Astral Icon",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [206385] = {
            [itemKeys.name] = "Clastic Icon",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [206386] = {
            [itemKeys.name] = "Galvanic Icon",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [206387] = {
            [itemKeys.name] = "Kajaric Icon",
            [itemKeys.npcDrops] = {2373},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [206388] = {
            [itemKeys.name] = "Sulfurous Icon",
            [itemKeys.npcDrops] = {208275},
            [itemKeys.objectDrops] = {404352},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [206389] = {
            [itemKeys.name] = "Brimstone Icon",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [206390] = {
            [itemKeys.name] = "Ichthyan Icon",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [206391] = {
            [itemKeys.name] = "Syzygic Icon",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [206466] = {
            [itemKeys.name] = "Prairie Crown",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [206469] = {
            [itemKeys.name] = "Prairie Flower",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [206954] = {
            [itemKeys.name] = "Idol of Ursine Rage",
            [itemKeys.npcDrops] = {2964,2965,2971,3232,3566,2979,2960,7318},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [206963] = {
            [itemKeys.name] = "Rune of Natural Potential",
            [itemKeys.npcDrops] = {206245},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [206966] = {
            [itemKeys.name] = "Lakeweed Bulb",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [206970] = {
            [itemKeys.name] = "Rune of Life",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [206975] = {
            [itemKeys.name] = "Artifact Storage Key",
            [itemKeys.npcDrops] = {2990,2989},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [206985] = {
            [itemKeys.name] = "Echo of the Alpha",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [206989] = {
            [itemKeys.name] = "Rune of the Sun",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {404433},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [206992] = {
            [itemKeys.name] = "Rune of Skull Bash",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = {213077,214070,214096,214098,214099,214101},
            [itemKeys.startQuest] = nil,
        },
        [206994] = {
            [itemKeys.name] = "Severed Quilboar Head",
            [itemKeys.npcDrops] = {3113,3114,3111,3232,3112},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [206995] = {
            [itemKeys.name] = "Severed Harpy Head",
            [itemKeys.npcDrops] = {2965,3118,3117,2962,3115,2963,3116},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [207062] = {
            [itemKeys.name] = "Severed Centaur Head",
            [itemKeys.npcDrops] = {3120,3119},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [207098] = {
            [itemKeys.name] = "Note from Ba'so",
            [itemKeys.npcDrops] = {3195,3196,3199,3198,3197},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [207106] = {
            [itemKeys.name] = "Bottom-Left Map Piece",
            [itemKeys.npcDrops] = {3206,3207,3206,3207},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [207107] = {
            [itemKeys.name] = "Bottom-Right Map Piece",
            [itemKeys.npcDrops] = {3112,3113,3114,3111,3114,3111,3112,3113},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [207108] = {
            [itemKeys.name] = "Top-Left Map Piece",
            [itemKeys.npcDrops] = {3199,3195,3196,3198,3197,3195,3196,3199,3198,3197},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [207109] = {
            [itemKeys.name] = "Top-Right Map Piece",
            [itemKeys.npcDrops] = {3128,3129,3129,3128},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [207110] = {
            [itemKeys.name] = "Durotar Treasure Map",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [207590] = {
            [itemKeys.name] = "Durotar Pig Meat",
            [itemKeys.npcDrops] = {3225,3100,3099},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [207631] = {
            [itemKeys.name] = "Adder Pheromone",
            [itemKeys.npcDrops] = {5824,5826,3113,3114,3112,3111},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [207731] = {
            [itemKeys.name] = "Ominous Tome",
            [itemKeys.npcDrops] = {3118,3198,3113,3207,3206},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [207732] = {
            [itemKeys.name] = "Makrura Leg",
            [itemKeys.npcDrops] = {3104,3103},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [207733] = {
            [itemKeys.name] = "Kul Tiran Skull",
            [itemKeys.npcDrops] = {3129,3128},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [207972] = {
            [itemKeys.name] = "The Lessons of Ta'zo",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [207973] = {
            [itemKeys.name] = "Hound Jawbone",
            [itemKeys.npcDrops] = {1549,1547,1548},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [207974] = {
            [itemKeys.name] = "Ominous Tome",
            [itemKeys.npcDrops] = {1522},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [207975] = {
            [itemKeys.name] = "Severed Bat Head",
            [itemKeys.npcDrops] = {1554,1553},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208005] = {
            [itemKeys.name] = "Agamand Relic Coffer Key",
            [itemKeys.npcDrops] = {1523,1527,1528,1529,1657,1916,1917,1520,1525,1675,1522,1526,1674,1941,1530,1534,1674,1941,1526,1675,1529,1502,1522,1520,1525,1501},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208007] = {
            [itemKeys.name] = "Shipwreck Cache Key",
            [itemKeys.npcDrops] = {1543,1545,1543,1544},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208034] = {
            [itemKeys.name] = "Tirisfal Treasure Map",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208035] = {
            [itemKeys.name] = "Top-Right Map Piece",
            [itemKeys.npcDrops] = {1539,1540,1538,1536,1537,1535,1535,1537,1536,1538},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208036] = {
            [itemKeys.name] = "Top-Left Map Piece",
            [itemKeys.npcDrops] = {1935,1934,1934,1935},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208037] = {
            [itemKeys.name] = "Bottom-Right Map Piece",
            [itemKeys.npcDrops] = {1544,1545,1543,1545,1544,1543},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208038] = {
            [itemKeys.name] = "Bottom-Left Map Piece",
            [itemKeys.npcDrops] = {1674,1941,1675,1674,1675,1941},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208085] = {
            [itemKeys.name] = "Scarlet Lieutenant Signet Ring",
            [itemKeys.npcDrops] = {1662},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208086] = {
            [itemKeys.name] = "Forged Scarlet Memorandum",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208139] = {
            [itemKeys.name] = "Ominous Tome",
            [itemKeys.npcDrops] = {1124,1397},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208140] = {
            [itemKeys.name] = "Wendigo Blood",
            [itemKeys.npcDrops] = {1134,1135},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208158] = {
            [itemKeys.name] = "Pristine Trogg Heart",
            [itemKeys.npcDrops] = {1116,1117,1115},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208159] = {
            [itemKeys.name] = "Severed Troll Head",
            [itemKeys.npcDrops] = {1120,1122,1397,1124,1121,1123},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208160] = {
            [itemKeys.name] = "Severed Wendigo Paw",
            [itemKeys.npcDrops] = {1134,1135},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208180] = {
            [itemKeys.name] = "Rabbit Musk",
            [itemKeys.npcDrops] = {1118,1116,1117,1115},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208183] = {
            [itemKeys.name] = "Apothecary Notes",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208185] = {
            [itemKeys.name] = "The Apothecary's Metaphysical Primer",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {405879},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208192] = {
            [itemKeys.name] = "Dun Morogh Pig Meat",
            [itemKeys.npcDrops] = {208638,1689,1126,1127,1125},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208205] = {
            [itemKeys.name] = "Blackrat's Note",
            [itemKeys.npcDrops] = {6123},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208213] = {
            [itemKeys.name] = "Top-Right Map Piece",
            [itemKeys.npcDrops] = {1121,1123,1397,946,1124,1122,706,1122,1124,1121,946,1123,706},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208215] = {
            [itemKeys.name] = "Top-Left Map Piece",
            [itemKeys.npcDrops] = {724,1115,1116,1116,1115,1718,724},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208218] = {
            [itemKeys.name] = "Bottom-Right Map Piece",
            [itemKeys.npcDrops] = {1211,1211},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208219] = {
            [itemKeys.name] = "Bottom-Left Map Piece",
            [itemKeys.npcDrops] = {6123,6123},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208220] = {
            [itemKeys.name] = "Dun Morogh Treasure Map",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208223] = {
            [itemKeys.name] = "Acolyte's Knapsack",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208224] = {
            [itemKeys.name] = "Acolyte's Note",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {208223},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208414] = {
            [itemKeys.name] = "Lunar Idol",
            [itemKeys.npcDrops] = {1989},
            [itemKeys.objectDrops] = {403102},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208601] = {
            [itemKeys.name] = "Top-Right Map Piece",
            [itemKeys.npcDrops] = {2025,2030,2027,2029,2022},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208602] = {
            [itemKeys.name] = "Top-Left Map Piece",
            [itemKeys.npcDrops] = {2013,2012,2011,2152,2009,2010,2012,2011},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208603] = {
            [itemKeys.name] = "Bottom-Right Map Piece",
            [itemKeys.npcDrops] = {2017,2018,2020,2015,2019,2021,2019,2018},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208604] = {
            [itemKeys.name] = "Bottom-Left Map Piece",
            [itemKeys.npcDrops] = {2003,2004,2002,2005},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208605] = {
            [itemKeys.name] = "Teldrassil Treasure Map",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208607] = {
            [itemKeys.name] = "Deer Musk",
            [itemKeys.npcDrops] = {2014,2013,2012,2152,2009,2011,2010},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208608] = {
            [itemKeys.name] = "Teldrassil Bird Meat",
            [itemKeys.npcDrops] = {1997,1996,1995},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208609] = {
            [itemKeys.name] = "Glade Flower",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208610] = {
            [itemKeys.name] = "Severed Owl Head",
            [itemKeys.npcDrops] = {1997,1996,1995},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208611] = {
            [itemKeys.name] = "Severed Tiger Head",
            [itemKeys.npcDrops] = {2033,2043,2042},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208612] = {
            [itemKeys.name] = "Severed Spider Head",
            [itemKeys.npcDrops] = {1999,1998},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208682] = {
            [itemKeys.name] = "Abandoned Snapjaw Egg",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208687] = {
            [itemKeys.name] = "Rune of Lacerate",
            [itemKeys.npcDrops] = {210483},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208689] = {
            [itemKeys.name] = "Ferocious Idol",
            [itemKeys.npcDrops] = {6788},
            [itemKeys.objectDrops] = {152618,152608,3642},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208701] = {
            [itemKeys.name] = "Rune of Beast Mastery",
            [itemKeys.npcDrops] = {211736,210533,209524},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208739] = {
            [itemKeys.name] = "Horde Warbanner",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208741] = {
            [itemKeys.name] = "Rune of Endless Rage",
            [itemKeys.npcDrops] = {506,519,520,1424,211146,210451,209607,391},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208743] = {
            [itemKeys.name] = "Soul of Greed",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208744] = {
            [itemKeys.name] = "Rune of Shadowbolts",
            [itemKeys.npcDrops] = {10373,212753,3662,209958},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208749] = {
            [itemKeys.name] = "Gnarlpine Stash Key",
            [itemKeys.npcDrops] = {2012,2011,2012,2011},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208750] = {
            [itemKeys.name] = "Rune of Channeling",
            [itemKeys.npcDrops] = {2336,210501,212763},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208753] = {
            [itemKeys.name] = "Spell Notes: Regeneration",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208754] = {
            [itemKeys.name] = "Spell Notes: TENGI RONEERA",
            [itemKeys.npcDrops] = {450,1867},
            [itemKeys.objectDrops] = {152608,3642,407983},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208758] = {
            [itemKeys.name] = "Earthen Rune",
            [itemKeys.npcDrops] = {211875,209742},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208760] = {
            [itemKeys.name] = "Glade Crown",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208764] = {
            [itemKeys.name] = "Rune of the Banshee",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208765] = {
            [itemKeys.name] = "Helping Hand",
            [itemKeys.npcDrops] = {3266,3265,3267,3268},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208766] = {
            [itemKeys.name] = "Helping Hand",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208767] = {
            [itemKeys.name] = "Rune of Mending",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208768] = {
            [itemKeys.name] = "Buccaneer's Matchbox",
            [itemKeys.npcDrops] = {3384,3383,3381,3383,3381,3382},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208771] = {
            [itemKeys.name] = "Rune of Blade Dance",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {414532},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208772] = {
            [itemKeys.name] = "Rune of Saber Slash",
            [itemKeys.npcDrops] = {210549},
            [itemKeys.objectDrops] = {409131},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208773] = {
            [itemKeys.name] = "Fishing Harpoon",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = {3497},
            [itemKeys.startQuest] = nil,
        },
        [208777] = {
            [itemKeys.name] = "Rune of the Sniper",
            [itemKeys.npcDrops] = {210549,210107,210482,209797},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208778] = {
            [itemKeys.name] = "Rune of Quick Strike",
            [itemKeys.npcDrops] = {210482,210487,209797},
            [itemKeys.objectDrops] = {208848},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208799] = {
            [itemKeys.name] = "Spell Notes: Living Bomb",
            [itemKeys.npcDrops] = {210501},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208800] = {
            [itemKeys.name] = "Baxtan: On Destructive Magics",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {407566},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208823] = {
            [itemKeys.name] = "Offering Coin",
            [itemKeys.npcDrops] = {1177,1174,1175},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208828] = {
            [itemKeys.name] = "Memory of a Broken Vow",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208833] = {
            [itemKeys.name] = "Malevolent Pie",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = {3291},
            [itemKeys.startQuest] = nil,
        },
        [208838] = {
            [itemKeys.name] = "Dark Iron Lockbox",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208843] = {
            [itemKeys.name] = "Battle Totem",
            [itemKeys.npcDrops] = {1181,1178,1179,1183,1180},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208847] = {
            [itemKeys.name] = "Skull-Shaped Geode",
            [itemKeys.npcDrops] = {1164,1161,1162},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208848] = {
            [itemKeys.name] = "Cracked Skull-Shaped Geode",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208849] = {
            [itemKeys.name] = "Libram of Blessings",
            [itemKeys.npcDrops] = {210537},
            [itemKeys.objectDrops] = {407844},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208851] = {
            [itemKeys.name] = "Libram of Justice",
            [itemKeys.npcDrops] = {572,846,7050},
            [itemKeys.objectDrops] = {407850},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208853] = {
            [itemKeys.name] = "Spell Notes: Brain Freeze",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208854] = {
            [itemKeys.name] = "Chewed Spell Notes",
            [itemKeys.npcDrops] = {1166},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [208855] = {
            [itemKeys.name] = "Rainbow Fin Albacore Chum",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = {1684},
            [itemKeys.startQuest] = nil,
        },
        [208860] = {
            [itemKeys.name] = "Rumi of Gnomeregan: The Collected Works",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {408014},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209027] = {
            [itemKeys.name] = "Crab Treats",
            [itemKeys.npcDrops] = {2170,2169,2171,2168,2324,2167},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209028] = {
            [itemKeys.name] = "Spell Notes: BIVOLG NIMB",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209029] = {
            [itemKeys.name] = "Message from Emily",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {209031},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209030] = {
            [itemKeys.name] = "Equipment Stash Key",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {209031},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209031] = {
            [itemKeys.name] = "Discreet Envelope",
            [itemKeys.npcDrops] = {481,95,504,121,590},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209041] = {
            [itemKeys.name] = "Magic Pumpkin Seeds",
            [itemKeys.npcDrops] = {589,590,95,504},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209042] = {
            [itemKeys.name] = "Fishy Bonemeal",
            [itemKeys.npcDrops] = {830,831},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209043] = {
            [itemKeys.name] = "Fertile Soil Sample",
            [itemKeys.npcDrops] = {1236},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209045] = {
            [itemKeys.name] = "Soul of the Sea",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209047] = {
            [itemKeys.name] = "Gnarled Harpoon",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {408802},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209056] = {
            [itemKeys.name] = "Spare Reaper Parts",
            [itemKeys.npcDrops] = {115,36,480,114},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209057] = {
            [itemKeys.name] = "Prototype Engine",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209058] = {
            [itemKeys.name] = "Elemental Core",
            [itemKeys.npcDrops] = {832},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209059] = {
            [itemKeys.name] = "Goretusk Haunch",
            [itemKeys.npcDrops] = {157,454},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209418] = {
            [itemKeys.name] = "Adamantine Tortoise Armor",
            [itemKeys.npcDrops] = {201722},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209420] = {
            [itemKeys.name] = "Gillsbane",
            [itemKeys.npcDrops] = {121,589,590,504,95},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209421] = {
            [itemKeys.name] = "Cord of Aquanis",
            [itemKeys.npcDrops] = {202699},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209422] = {
            [itemKeys.name] = "High Tide Choker",
            [itemKeys.npcDrops] = {202699},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209423] = {
            [itemKeys.name] = "Flowing Scarf",
            [itemKeys.npcDrops] = {202699},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209424] = {
            [itemKeys.name] = "Shell Plate Barrier",
            [itemKeys.npcDrops] = {201722},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209432] = {
            [itemKeys.name] = "Ghamoo-ra's Cinch",
            [itemKeys.npcDrops] = {201722},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209436] = {
            [itemKeys.name] = "Chipped Bite of Serra'kis",
            [itemKeys.npcDrops] = {201722},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209523] = {
            [itemKeys.name] = "Shimmering Thresher Cape",
            [itemKeys.npcDrops] = {201722},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209524] = {
            [itemKeys.name] = "Bindings of Serra'kis",
            [itemKeys.npcDrops] = {201722},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209525] = {
            [itemKeys.name] = "Honed Darkwater Talwar",
            [itemKeys.npcDrops] = {204068},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209526] = {
            [itemKeys.name] = "TEST Darkwater Talwar",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209527] = {
            [itemKeys.name] = "Naga Battle Gauntlets",
            [itemKeys.npcDrops] = {204068},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209534] = {
            [itemKeys.name] = "Azshari Arbalest",
            [itemKeys.npcDrops] = {213334},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209559] = {
            [itemKeys.name] = "Twilight Sage's Walking Stick",
            [itemKeys.npcDrops] = {204921},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209560] = {
            [itemKeys.name] = "Hammer of Righteous Judgement",
            [itemKeys.npcDrops] = {207356},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209561] = {
            [itemKeys.name] = "Rod of the Ancient Sleepwalker",
            [itemKeys.npcDrops] = {209678},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209562] = {
            [itemKeys.name] = "Deadly Strike of the Hydra",
            [itemKeys.npcDrops] = {213334},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209563] = {
            [itemKeys.name] = "Naga Heartrender",
            [itemKeys.npcDrops] = {204068},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209564] = {
            [itemKeys.name] = "Guardian's Trident",
            [itemKeys.npcDrops] = {204068},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209565] = {
            [itemKeys.name] = "Band of Deep Places",
            [itemKeys.npcDrops] = {204068},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209566] = {
            [itemKeys.name] = "Leggings of the Faithful",
            [itemKeys.npcDrops] = {204068},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209567] = {
            [itemKeys.name] = "Coral Reef Axe",
            [itemKeys.npcDrops] = {204921},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209568] = {
            [itemKeys.name] = "Algae Gauntlets",
            [itemKeys.npcDrops] = {204921},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209569] = {
            [itemKeys.name] = "Murloc Hide Kneeboots",
            [itemKeys.npcDrops] = {204921},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209570] = {
            [itemKeys.name] = "Tome of Cavern Lore",
            [itemKeys.npcDrops] = {204921},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209571] = {
            [itemKeys.name] = "Deadlight",
            [itemKeys.npcDrops] = {204921},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209572] = {
            [itemKeys.name] = "Black Boiled Leathers",
            [itemKeys.npcDrops] = {204921},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209573] = {
            [itemKeys.name] = "Wrathful Spire",
            [itemKeys.npcDrops] = {204921},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209574] = {
            [itemKeys.name] = "Discarded Tenets of the Silver Hand",
            [itemKeys.npcDrops] = {207356},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209575] = {
            [itemKeys.name] = "Carved Driftwood Icon",
            [itemKeys.npcDrops] = {207356},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209576] = {
            [itemKeys.name] = "Mind-Expanding Mushroom",
            [itemKeys.npcDrops] = {207356},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209577] = {
            [itemKeys.name] = "Fist of the Wild",
            [itemKeys.npcDrops] = {207356},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209578] = {
            [itemKeys.name] = "Glowing Leather Bands",
            [itemKeys.npcDrops] = {207356},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209579] = {
            [itemKeys.name] = "Crashing Thunder",
            [itemKeys.npcDrops] = {207356},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209580] = {
            [itemKeys.name] = "Gusting Wind",
            [itemKeys.npcDrops] = {213334},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209581] = {
            [itemKeys.name] = "Silver Hand Sabatons",
            [itemKeys.npcDrops] = {207356},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209590] = {
            [itemKeys.name] = "Cracked Water Globe",
            [itemKeys.npcDrops] = {202699},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209608] = {
            [itemKeys.name] = "Captain's Skeleton Key",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209667] = {
            [itemKeys.name] = "Gaze Dreamer Leggings",
            [itemKeys.npcDrops] = {209678},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209668] = {
            [itemKeys.name] = "Signet of the Twilight Lord",
            [itemKeys.npcDrops] = {209678},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209669] = {
            [itemKeys.name] = "Twilight Invoker's Shoes",
            [itemKeys.npcDrops] = {209678,213334,207356,204921},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209670] = {
            [itemKeys.name] = "Skinwalkers",
            [itemKeys.npcDrops] = {204921},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209671] = {
            [itemKeys.name] = "Twilight Invoker's Robes",
            [itemKeys.npcDrops] = {209678,213334,207356,204921},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209672] = {
            [itemKeys.name] = "Black Fingerless Gloves",
            [itemKeys.npcDrops] = {209678},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209673] = {
            [itemKeys.name] = "Glowing Fetish Amulet",
            [itemKeys.npcDrops] = {209678},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209674] = {
            [itemKeys.name] = "Phoenix Ignition",
            [itemKeys.npcDrops] = {209678},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209675] = {
            [itemKeys.name] = "Clamweave Tunic",
            [itemKeys.npcDrops] = {201722},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209676] = {
            [itemKeys.name] = "Shoulderguards of Crushing Depths",
            [itemKeys.npcDrops] = {202699},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209677] = {
            [itemKeys.name] = "Loop of Swift Currents",
            [itemKeys.npcDrops] = {202699},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209678] = {
            [itemKeys.name] = "Mantle of the Thresher Slayer",
            [itemKeys.npcDrops] = {201722},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209679] = {
            [itemKeys.name] = "Azshari Novice's Shoulderpads",
            [itemKeys.npcDrops] = {204068},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209680] = {
            [itemKeys.name] = "Waterproof Scarf",
            [itemKeys.npcDrops] = {204068},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209681] = {
            [itemKeys.name] = "Black Murloc Egg",
            [itemKeys.npcDrops] = {204921},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209682] = {
            [itemKeys.name] = "Sturdy Hood",
            [itemKeys.npcDrops] = {207356},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209683] = {
            [itemKeys.name] = "Twilight Invoker's Shawl",
            [itemKeys.npcDrops] = {213334,209678,207356,204921},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209684] = {
            [itemKeys.name] = "Soul Leech Pants",
            [itemKeys.npcDrops] = {213334},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209685] = {
            [itemKeys.name] = "Ancient Moss Cinch",
            [itemKeys.npcDrops] = {213334},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209686] = {
            [itemKeys.name] = "Jagged Bone Necklace",
            [itemKeys.npcDrops] = {209678},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209687] = {
            [itemKeys.name] = "Hydra Hide Cuirass",
            [itemKeys.npcDrops] = {213334},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209688] = {
            [itemKeys.name] = "Bael Modan Blunderbuss",
            [itemKeys.npcDrops] = {213334},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209689] = {
            [itemKeys.name] = "Crabshell Waders",
            [itemKeys.npcDrops] = {213334},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209690] = {
            [itemKeys.name] = "Shadowscale Coif",
            [itemKeys.npcDrops] = {213334},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209691] = {
            [itemKeys.name] = "Vampiric Boot Knife",
            [itemKeys.npcDrops] = {213334},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209692] = {
            [itemKeys.name] = "Sentinel Pauldrons",
            [itemKeys.npcDrops] = {213334},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209693] = {
            [itemKeys.name] = "Perfect Blackfathom Pearl",
            [itemKeys.npcDrops] = {213334},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 78916,
        },
        [209694] = {
            [itemKeys.name] = "Blackfathom Ritual Dagger",
            [itemKeys.npcDrops] = {209678},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209748] = {
            [itemKeys.name] = "Althalaxx Orb",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209778] = {
            [itemKeys.name] = "Summoner's Salt",
            [itemKeys.npcDrops] = {334,4464,4462,436,4065,615,435,4463},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209779] = {
            [itemKeys.name] = "Mote of Mannoroth",
            [itemKeys.npcDrops] = {6071,6115,6073,11697},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209800] = {
            [itemKeys.name] = "Orb Fragments",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209816] = {
            [itemKeys.name] = "Fetish of Mischief",
            [itemKeys.npcDrops] = {209678},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209817] = {
            [itemKeys.name] = "Voidwalker Brooch",
            [itemKeys.npcDrops] = {209678},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209818] = {
            [itemKeys.name] = "Sun-Touched Crescent",
            [itemKeys.npcDrops] = {207356},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209819] = {
            [itemKeys.name] = "Wyvern Taming Wand",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209820] = {
            [itemKeys.name] = "Black Shroud Choker",
            [itemKeys.npcDrops] = {204921},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209821] = {
            [itemKeys.name] = "Ring of Shadowsight",
            [itemKeys.npcDrops] = {204921},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209822] = {
            [itemKeys.name] = "Strength of Purpose",
            [itemKeys.npcDrops] = {204068},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209823] = {
            [itemKeys.name] = "Signet of Beasts",
            [itemKeys.npcDrops] = {204068},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209824] = {
            [itemKeys.name] = "Shimmering Shoulderpads",
            [itemKeys.npcDrops] = {201722},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209825] = {
            [itemKeys.name] = "Droplet Choker",
            [itemKeys.npcDrops] = {202699},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209828] = {
            [itemKeys.name] = "Sub-Zero Pauldrons",
            [itemKeys.npcDrops] = {202699},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209830] = {
            [itemKeys.name] = "Ironhide Arbalest",
            [itemKeys.npcDrops] = {201722},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209836] = {
            [itemKeys.name] = "Althalaxx Orb",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {409289},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209838] = {
            [itemKeys.name] = "Hypnotic Crystal",
            [itemKeys.npcDrops] = {3654},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209840] = {
            [itemKeys.name] = "Gnarled Wand of Wild Magic",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209841] = {
            [itemKeys.name] = "Wild Magic Essence",
            [itemKeys.npcDrops] = {3922,3748,3750,3924},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209843] = {
            [itemKeys.name] = "Nar'thalas Almanac, Vol. 74",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {409496},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209844] = {
            [itemKeys.name] = "The Dalaran Digest, Vol. 23",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {409501},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209845] = {
            [itemKeys.name] = "Bewitchments and Glamours",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {409562},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209846] = {
            [itemKeys.name] = "Secrets of the Dreamers",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209847] = {
            [itemKeys.name] = "Arcanic Systems Manual",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {409700},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209848] = {
            [itemKeys.name] = "Goaz Scrolls",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {409717},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209849] = {
            [itemKeys.name] = "Crimes Against Anatomy",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {409735},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209850] = {
            [itemKeys.name] = "Runes of the Sorcerer-Kings",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {409731},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209851] = {
            [itemKeys.name] = "Fury of the Land",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {409711},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209852] = {
            [itemKeys.name] = "Rune of Kill Command",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209872] = {
            [itemKeys.name] = "Dragonslayer's Helm",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {409758},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209873] = {
            [itemKeys.name] = "Dragonslayer's Shield",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {409754},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [209874] = {
            [itemKeys.name] = "Dragonslayer's Lance",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = {3180},
            [itemKeys.startQuest] = nil,
        },
        [210015] = {
            [itemKeys.name] = "Rune of Raging Blow",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210026] = {
            [itemKeys.name] = "Symbol of the Third Owl",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210043] = {
            [itemKeys.name] = "Symbol of the Second Owl",
            [itemKeys.npcDrops] = {211200},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210044] = {
            [itemKeys.name] = "Symbol of the First Owl",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210045] = {
            [itemKeys.name] = "Shadeleaf",
            [itemKeys.npcDrops] = {3784,3782},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210053] = {
            [itemKeys.name] = "Dire Wolf Paw",
            [itemKeys.npcDrops] = {213,565},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210055] = {
            [itemKeys.name] = "Hillsbrad Human Bones",
            [itemKeys.npcDrops] = {2268,2267,2266,2360},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210056] = {
            [itemKeys.name] = "Tincture of Waking Death",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210080] = {
            [itemKeys.name] = "Voodoo Offering",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210137] = {
            [itemKeys.name] = "Rune of Wild Growth",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210138] = {
            [itemKeys.name] = "Dark Iron Ordinance",
            [itemKeys.npcDrops] = {1054,1053,1052,1051},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210146] = {
            [itemKeys.name] = "Shredder Turbocharger",
            [itemKeys.npcDrops] = {11684,642,4074,4073,214129},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210147] = {
            [itemKeys.name] = "Shredder Autosalvage Unit",
            [itemKeys.npcDrops] = {3988},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210177] = {
            [itemKeys.name] = "Ataeric: On Arcane Curiosities",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {410299},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210178] = {
            [itemKeys.name] = "Schematic: Shredder Autosalvage Unit",
            [itemKeys.npcDrops] = {643},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210179] = {
            [itemKeys.name] = "Spell Notes: ILMEGAI SARRBES",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210183] = {
            [itemKeys.name] = "Horn of Xelthos",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {410528},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210186] = {
            [itemKeys.name] = "Breaching Charge",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210187] = {
            [itemKeys.name] = "Venture Co. Work Order",
            [itemKeys.npcDrops] = {3988,3992,4070,3993},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210188] = {
            [itemKeys.name] = "Shredded Work Order",
            [itemKeys.npcDrops] = {4070,3988},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210195] = {
            [itemKeys.name] = "Unbalanced Idol",
            [itemKeys.npcDrops] = {1770,1769},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210209] = {
            [itemKeys.name] = "Twin Key",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210210] = {
            [itemKeys.name] = "Grizzwerks Defense Industries Founder's Certificate",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210212] = {
            [itemKeys.name] = "Brother's Half-Key",
            [itemKeys.npcDrops] = {211764},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210213] = {
            [itemKeys.name] = "Sister's Half-Key",
            [itemKeys.npcDrops] = {211765},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210229] = {
            [itemKeys.name] = "Rune of Mutilation",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210250] = {
            [itemKeys.name] = "Engraved Gold Ring",
            [itemKeys.npcDrops] = {910,215,909},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210251] = {
            [itemKeys.name] = "Engraved Silver Ring",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210252] = {
            [itemKeys.name] = "Rune of Shiving",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210253] = {
            [itemKeys.name] = "Rot Totem",
            [itemKeys.npcDrops] = {1773},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210322] = {
            [itemKeys.name] = "Rune of Venom",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {410847},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210323] = {
            [itemKeys.name] = "Safe Combination",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {210330},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210329] = {
            [itemKeys.name] = "Hillsbrad Treasure Map",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {210330},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210330] = {
            [itemKeys.name] = "Hot Tip",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = {3536},
            [itemKeys.startQuest] = nil,
        },
        [210410] = {
            [itemKeys.name] = "Freshwater Snapper Bait",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = {3537},
            [itemKeys.startQuest] = nil,
        },
        [210499] = {
            [itemKeys.name] = "Marshroom",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210500] = {
            [itemKeys.name] = "Rune of the Stars",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210534] = {
            [itemKeys.name] = "Idol of the Wild",
            [itemKeys.npcDrops] = {11913,11912,11910,11911},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210568] = {
            [itemKeys.name] = "Decrepit Phylactery",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {411348},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210569] = {
            [itemKeys.name] = "Rune of Flagellation",
            [itemKeys.npcDrops] = {212261},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210573] = {
            [itemKeys.name] = "Rune of Consuming Rage",
            [itemKeys.npcDrops] = {211965},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210589] = {
            [itemKeys.name] = "Echo of the Ancestors",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210596] = {
            [itemKeys.name] = "Rune of Cobra Strikes",
            [itemKeys.npcDrops] = {211951},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210653] = {
            [itemKeys.name] = "Rune of Main Gauche",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = {211653},
            [itemKeys.startQuest] = nil,
        },
        [210654] = {
            [itemKeys.name] = "Spell Notes: Rewind Time",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = {211653},
            [itemKeys.startQuest] = nil,
        },
        [210655] = {
            [itemKeys.name] = "Spell Notes: TERWEM DINI",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210665] = {
            [itemKeys.name] = "Mote of Torrential Rage",
            [itemKeys.npcDrops] = {3917},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210667] = {
            [itemKeys.name] = "Mote of Infernal Rage",
            [itemKeys.npcDrops] = {4036,4037,4038},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210668] = {
            [itemKeys.name] = "Mote of Seismic Rage",
            [itemKeys.npcDrops] = {4035,4034},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210696] = {
            [itemKeys.name] = "Rot Bane",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210708] = {
            [itemKeys.name] = "Elixir of Coalesced Regret",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210709] = {
            [itemKeys.name] = "Recipe: Elixir of Coalesced Regret",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = {3134,3537},
            [itemKeys.startQuest] = nil,
        },
        [210712] = {
            [itemKeys.name] = "Elixir of Insight",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210713] = {
            [itemKeys.name] = "Tortured Soul",
            [itemKeys.npcDrops] = {1973,1974},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210724] = {
            [itemKeys.name] = "Hirzek's Staff",
            [itemKeys.npcDrops] = {212694},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210741] = {
            [itemKeys.name] = "Automatic Crowd Pummeler",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210746] = {
            [itemKeys.name] = "Rune of Earth Shield",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210763] = {
            [itemKeys.name] = "Bough of Altek",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {411715},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210765] = {
            [itemKeys.name] = "Orb of Des",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {411710},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210771] = {
            [itemKeys.name] = "Waylaid Supplies: Copper Bars",
            [itemKeys.npcDrops] = {60,6123,1993,2039,6846,1426,1772,3058,1782,6093,2025,2989,4008,2957,390,2167,2019,3103,2177,1236,2976,3205,2979,2030,3104,1779,3114,2950,3120,2011,2990,1997,2178,2977,881,3126,1662,3243,2029,2234,1531,2152,1124,3035,2021,1655,473,11913,1656,3265,1532,1765,1190,2185,97,2321,590,3206,327,1866,2017,1177,2018,3274,515,1797,1161,1135,1175,2069,3267,1117,2033,3207,2008,3112,501,833,524,1999,3197,1773,3382,3271,3110,1186,3415,1529,7235,2959,4316,2013,1116,1953,2004,2965,1675,2005,1162,2212,1195,1674,116,121,3246,126,1555,3438,1123,3266,735,1781,712,95,2963,3268,3397,123,2322,1172,732,2978,3113,480,1201,589,6789,2020,1196,3119,3379,1202,3122,1778,2951,1538,3284,1163,2189,43,285,3272,1769,1115,2015,2203,500,3276,3425,2964,2231,1522,114,40,834,2176,2010,1166,2163,3254,1548,3115,3127,1867,3129,3117,3121,46,504,2202,1536,199,3566,474,2962,1188,1934,2027,3255,3232,478,11910,1211,476,1164,3285,1121,1397,3116,3242,1197,2070,2009,1174,4263,2190,1126,117,3381,1543},
            [itemKeys.objectDrops] = {404352,106319,106318},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210772] = {
            [itemKeys.name] = "Supply Shipment: Copper Bars",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210773] = {
            [itemKeys.name] = "Mantle of the Second War",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210779] = {
            [itemKeys.name] = "Plans: Mantle of the Second War",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = {213077,214070,214096,214098,214099,214101},
            [itemKeys.startQuest] = nil,
        },
        [210781] = {
            [itemKeys.name] = "Phoenix Bindings",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210794] = {
            [itemKeys.name] = "Shifting Silver Breastplate",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210795] = {
            [itemKeys.name] = "Extraplanar Spidersilk Boots",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210811] = {
            [itemKeys.name] = "Rune of Primordial Fury",
            [itemKeys.npcDrops] = {212837},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210817] = {
            [itemKeys.name] = "Rune of Survival",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = {211653},
            [itemKeys.startQuest] = nil,
        },
        [210818] = {
            [itemKeys.name] = "Rune of Lone Wolf",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = {211653},
            [itemKeys.startQuest] = nil,
        },
        [210820] = {
            [itemKeys.name] = "Rune of Sacrifice",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = {211653},
            [itemKeys.startQuest] = nil,
        },
        [210822] = {
            [itemKeys.name] = "Harmonious Epiphany",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = {211653},
            [itemKeys.startQuest] = nil,
        },
        [210823] = {
            [itemKeys.name] = "Rune of Dual Wield Specialization",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = {211653},
            [itemKeys.startQuest] = nil,
        },
        [210824] = {
            [itemKeys.name] = "Rune of the Pact",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = {211653},
            [itemKeys.startQuest] = nil,
        },
        [210825] = {
            [itemKeys.name] = "Rune of the Warbringer",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = {211653},
            [itemKeys.startQuest] = nil,
        },
        [210953] = {
            [itemKeys.name] = "Eye of Bhossca",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210955] = {
            [itemKeys.name] = "Scarlet Initiate's Uniform",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210963] = {
            [itemKeys.name] = "Scryer's Key",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210966] = {
            [itemKeys.name] = "Blood of the Legion",
            [itemKeys.npcDrops] = {6071,11697,6073,6115},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210967] = {
            [itemKeys.name] = "Confidential Message",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210968] = {
            [itemKeys.name] = "Reliquary Key",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210979] = {
            [itemKeys.name] = "Rune of Blade Rush",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [210980] = {
            [itemKeys.name] = "Rune of Metamorphosis",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211205] = {
            [itemKeys.name] = "Rune of Aspect of the Lion",
            [itemKeys.npcDrops] = {211965},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211247] = {
            [itemKeys.name] = "Pattern: Phoenix Bindings",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = {213077,214070,214096,214099,214101},
            [itemKeys.startQuest] = nil,
        },
        [211263] = {
            [itemKeys.name] = "Judgement Chestguard",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211315] = {
            [itemKeys.name] = "Waylaid Supplies: Light Leather",
            [itemKeys.npcDrops] = {2065,2062,10356,14431,6846,1426,3231,1997,12138,1773,1770,1124,3051,2176,7234,1528,2149,502,2979,1869,2008,2964,2951,2027,43,1768,1539,2018,3274,2038,3122,330,2167,881,119,3111,6123,1174,46,2178,2324,501,3241,1782,515,2020,1164,1176,1522,1236,2021,1654,2950,3120,3196,1163,1769,3206,2030,524,1781,2990,2234,1535,3246,1540,3114,1196,3267,3107,3381,2965,3195,1545,1689,1536,1117,2029,97,2177,1135,3265,3121,1767,2976,3232,3271,1529,476,7235,3205,3119,504,2970,1161,2025,1197,2012,95,3035,1867,2190,732,2321,285,117,3117,2989,1123,589,2202,2963,3207,199,1772,2069,1162,2009,2322,478,1122,1544,590,11910,3380,2011,2231,2163,1941,3379,3103,3425,474,3129,3255,3112,3242,1190,1211,1184,2185,3284,2015,116,513,1779,1109,36,2164,3269,3197,3272,1138,3123,114,1553,822,1172,1674,3266,735,456,1526,11911,2033,1201,3282,1188,3130,833,1934,1797,1555,2978,40,3382,2956,2960,423,1131,1766,3415,3285,2959,1191,3116,4316,830,3104,2070,1115,834,2010,454,1175,1675,2212,500,1195,1866},
            [itemKeys.objectDrops] = {404352,106319,106318},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211316] = {
            [itemKeys.name] = "Waylaid Supplies: Peacebloom",
            [itemKeys.npcDrops] = {208638,2061,6846,2972,3056,2951,6866,2030,1997,6093,3204,456,1177,1781,1772,7318,1660,97,2971,2034,2015,7319,2950,3206,1924,3199,2167,881,2321,2177,390,2176,1531,1166,1122,3113,3271,1770,1779,7235,1124,2189,2979,1202,1236,1753,1655,473,1996,1797,1999,3131,2178,123,3118,95,513,2978,1117,3269,1121,3198,2234,2185,2201,1161,3203,46,1540,1545,1689,11911,1163,10158,2190,1115,1538,2962,1135,1188,3381,1767,2976,1773,1131,1520,1529,1164,1537,2070,1953,478,3129,11913,2965,1175,1765,1190,1174,1186,1778,1523,500,2043,3438,735,712,2202,3255,1536,2963,3268,36,590,3197,2957,114,116,1693,2010,2322,1535,3272,2152,1782,524,1544,1201,11910,2020,3114,3415,1211,1526,2011,2164,3285,117,3122,3266,3265,3121,126,822,1172,3284,1173,2000,43,1426,327,2017,40,2018,2324,10160,3274,3242,2990,1138,504,1548,1162,3117,824,480,3100,454,1941,2029,3207,3397,199,3566,11912,474,1195,501,3130,3234,1934,1555,2027,732,3382,1196,476,1397,4316,830,1197,1127,3120,118,157,2212,3244,1866,3425,1780},
            [itemKeys.objectDrops] = {404352,106319,106318},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211317] = {
            [itemKeys.name] = "Waylaid Supplies: Silverleaf",
            [itemKeys.npcDrops] = {209742,1132,8503,1773,1193,6093,1770,1660,1769,6866,1664,456,2979,7234,1869,2201,3120,1122,285,2029,1768,2015,2152,2025,1779,1175,2008,2177,2977,550,2070,6123,1772,3122,501,3234,515,2020,3271,3380,117,3104,3204,2167,2950,3196,1174,2178,3126,2959,97,2321,2212,123,1426,1657,1866,2965,2030,1177,1781,1520,1201,95,3284,1674,1782,1530,3203,3268,1540,3107,2033,3397,11912,2964,2971,3206,3112,2962,1135,1797,10159,1529,2203,3119,1172,1537,1117,1116,480,1953,1115,1163,11913,2004,2190,1162,3192,2960,500,2164,735,2202,40,3115,3267,390,1914,2009,2322,1195,1535,1161,2978,1131,2019,1164,3379,2179,3566,3110,2021,1766,2951,590,1538,1532,1996,1675,46,2069,2185,2000,3118,116,513,2231,2324,3273,1912,2990,118,1138,1548,3381,3123,3129,822,124,3117,121,3255,3121,2043,504,2189,478,712,481,1536,11911,114,3207,199,157,1778,1188,3130,524,2027,3232,3244,423,3425,1196,3415,3127,1922,7235,1121,3116,830,1197,834,2010,824,1765,1190,4263,3131,1173,1126,1211,2989,10158,2963,3197,2234,1544},
            [itemKeys.objectDrops] = {404352,106319,106318},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211318] = {
            [itemKeys.name] = "Waylaid Supplies: Minor Healing Potions",
            [itemKeys.npcDrops] = {208638,5786,471,1870,6846,1981,6866,1426,1236,3196,7234,1769,2167,1177,880,1660,2951,2976,1773,1983,2012,1539,1997,3123,1772,1782,2232,1770,1124,2979,1655,473,1656,3282,2000,2212,3248,1520,2963,1117,1201,1527,1530,456,712,2202,3397,2177,2971,3206,3112,1538,501,1135,524,3232,1529,476,1164,4316,2025,3104,4263,2321,3198,550,2989,1115,1779,2185,1781,36,2957,2010,2152,3130,1544,2978,2020,3415,2011,1397,3103,2008,1175,1996,1999,1184,3126,2189,285,2015,327,2030,3255,513,2964,2017,199,10158,1166,3274,2163,478,3269,2990,1126,3121,3099,40,2069,2965,2033,3207,157,474,2962,3035,3381,454,833,732,589,590,3382,2956,2960,11910,2164,1693,830,3267,2070,834,2950,3276,4127,1675,1174,2178,3118,116,1554,95,1163,3277,1914,1162,1161,3284,3246,3113,2205,3114,3107,1211,1526,114,3566,3425,1202,1534,1778,3129,3273,824,3242,1532,1190,126,46,423,1186,1522,2009,515,3197,118,1548,2190,1523,1172,124,3117,121,2043,1123,3266,504,735,1536,1537,11911,11912,123,1195,3461,1196,3285,1121},
            [itemKeys.objectDrops] = {404352,106319,106318},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211319] = {
            [itemKeys.name] = "Waylaid Supplies: Copper Shortswords",
            [itemKeys.npcDrops] = {2173,6846,2014,1065,1380,3204,881,14428,1545,1782,880,1769,1768,1530,2012,2018,3243,2033,1135,2324,1549,501,1544,2011,1124,2979,1655,2951,3196,7234,2178,2989,116,1527,3203,1175,121,2167,1540,456,2029,2179,831,3265,833,1934,1767,2976,2978,1773,3126,4316,3103,2013,3267,2004,2950,515,2005,2190,2177,285,2212,330,1123,1779,2185,1781,1772,3206,1195,2152,1122,732,3113,2020,1520,2965,2959,3116,3117,2070,2021,3112,1538,1996,1675,1174,2069,3111,589,2000,43,1693,1529,1426,2203,2964,2017,2176,3115,1162,3129,1535,117,3246,480,735,712,481,1117,114,3207,3397,11912,3122,1778,3232,2956,2960,11910,1131,3272,3415,1211,476,7235,3119,1172,1161,3104,1115,95,2009,3120,478,1173,504,1543,2235,3273,3242,2963,36,3269,3197,3100,1163,2234,3127,3284,40,590,3382,3107,2008,199,3566,1202,1194,3198,3121,1532,454,126,1555,1999,46,2189,1186,3268,2970,2231,834,1166,2164,1867,1126,1523,822,1674,2043,1780,3099,3110,3266,2202,1537,11911,3282,97,157,3035,3130,3381,524,1196,2163,3285,1191},
            [itemKeys.objectDrops] = {404352,106319,106318},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211320] = {
            [itemKeys.name] = "Waylaid Supplies: Runed Copper Pants",
            [itemKeys.npcDrops] = {2968,2060,1133,1193,1865,3056,3231,12138,3225,3204,473,1177,1782,2212,2989,2976,2978,6866,2025,3383,2950,2008,3199,1868,2033,6123,2324,1934,2965,1236,1655,3196,1426,3248,2017,1781,1554,2963,1778,515,2990,2152,1135,2167,3267,2029,123,501,833,126,1767,1773,2956,476,2203,2979,1953,2176,2010,2005,285,1126,2960,3198,1172,330,1555,9523,712,2202,3197,1772,11912,1522,1162,2009,2322,1161,1122,1544,589,590,6789,11910,3107,2164,1397,1191,504,1176,3566,157,1202,3122,2021,2951,3265,1675,3284,2000,43,1769,1115,327,3118,3035,2030,513,40,2018,3269,2190,1674,116,121,3266,456,481,1689,2177,3206,2962,1188,3130,3381,3232,3425,1131,1520,10159,3268,7235,1164,1121,3116,4316,1197,2070,95,1127,1765,1174,2069,2189,2321,1211,1866,3117,2964,1543,36,114,1548,1535,1530,480,2205,3114,1526,2011,1941,1693,199,1534,3129,3112,3273,3275,1190,1999,1184,3111,1186,1529,2970,3255,834,1166,1867,1523,822,1780,478,3242,3207,1163,3397,97,1195,3382,1553,1196,3285,2959,3119,3103,1175,824,118,4263},
            [itemKeys.objectDrops] = {404352,106319,106318},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211321] = {
            [itemKeys.name] = "Waylaid Supplies: Lesser Magic Wands",
            [itemKeys.npcDrops] = {202060,14268,2972,6927,1868,3384,1770,2149,1869,3203,3232,6866,1782,2030,2012,2017,2990,2957,2029,1122,6789,1124,473,11913,2960,97,43,2015,1177,1543,2018,2963,116,2205,2178,456,3195,2008,2001,3198,833,1773,3271,7235,2979,3129,1765,1173,2177,2212,3415,124,2167,126,735,1554,3269,3115,1772,390,2234,123,478,2978,590,3380,1520,3114,2011,3116,1176,1534,3266,1194,2951,40,3265,1175,1532,3381,1675,454,3126,423,3272,1529,1779,2324,2010,1166,2959,1138,2321,1162,3121,2043,3110,3273,1689,3242,11911,1117,2033,157,95,3122,1778,2962,1934,524,2027,2956,1548,1131,3103,1161,2070,171,3120,1135,1190,3131,2189,504,500,1201,1195,3117,1780,2989,2231,1781,36,3197,114,3254,3127,1914,822,2152,3284,1530,1544,118,3113,3382,3107,2164,2179,3566,1109,3112,1555,1999,46,1184,3111,589,1186,2203,3268,2970,2176,10160,515,4127,1693,2190,3123,117,3244,121,3246,3425,1123,2202,3276,1537,3207,1163,3397,199,3282,3206,1188,3035,3130,732,1553,11910,1196,1211,1164,3285,1397,3100,1191,1197,1174,4263},
            [itemKeys.objectDrops] = {404352,106319,106318},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211322] = {
            [itemKeys.name] = "Waylaid Supplies: Minor Wizard Oil",
            [itemKeys.npcDrops] = {3226,1380,1997,2039,1124,119,2001,3058,1236,3196,1426,1177,7318,456,43,1768,3205,330,550,1662,1868,6123,1772,2962,1531,1782,833,3271,3114,2019,1770,3268,3379,3204,1753,2950,285,2978,2018,3274,3269,1115,2234,480,1174,1540,3198,1767,3232,2185,3126,2956,3117,478,10159,1529,4316,2025,2012,1953,2004,2005,2177,3192,3122,1674,2167,735,1536,2957,3207,97,3115,390,116,2010,2152,1161,1544,3113,6789,2960,2020,3380,3107,1941,2204,3119,2008,1534,2951,1538,1162,1135,3265,1175,3275,1117,126,1211,3111,1769,2015,3118,3267,513,2964,2324,1554,1912,2190,2321,114,1523,3129,1535,3110,1190,712,1526,1201,1163,3397,3035,524,2027,1548,1766,3127,476,7235,2979,3103,1197,2070,1522,3120,1765,2069,2178,2212,1866,2164,3425,1779,589,1781,3284,1530,118,3099,40,590,3382,1196,2011,2163,2965,2959,504,157,1532,454,46,2189,423,2203,834,2176,1166,515,1138,3277,3123,1172,124,121,2043,1780,3273,3276,1537,123,1195,1188,3130,3381,3244,11910,1131,3116,1693,95,171,1675,1173,3272,500,2231,3197},
            [itemKeys.objectDrops] = {404352,106319,106318},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211323] = {
            [itemKeys.name] = "Waylaid Supplies: Rough Copper Bombs",
            [itemKeys.npcDrops] = {208124,2066,5826,6846,1426,6927,1177,2963,3383,1997,3199,3192,1662,1772,390,2978,1770,1654,3196,7234,1528,43,2203,1657,2989,2017,2190,3203,1544,3114,3267,1689,3282,3566,2177,1161,2971,3111,3266,830,1537,1953,2176,2324,2005,474,550,126,1543,2202,11911,1117,2957,2234,1522,1914,2069,2322,1122,1115,3380,2321,2011,2965,3122,3198,3112,2951,1195,1162,1996,1675,2178,1173,3246,285,2015,95,2030,513,1779,2010,3274,515,3269,1126,1535,1674,2043,2167,46,1526,481,97,11912,157,2231,2962,3234,1934,524,1555,2027,3232,2960,116,11910,3271,3425,1196,114,3268,7235,1397,3119,4316,3103,1197,3104,2070,2009,171,3129,11913,1166,3120,1135,4127,1765,1174,3272,500,1866,3117,2164,3110,3273,3197,3115,478,1172,2152,1782,1530,480,40,3382,2205,3107,3415,1211,1176,2008,1538,3242,3275,3121,3381,454,1797,1184,2185,589,1186,3244,2970,10160,1523,117,1123,735,1127,3276,1536,3207,1163,3397,3206,3035,1553,1131,1164,3285,2959,3100,1191,1175,118,1190,2189,3118,2964,10158,1912,36,1766,3284,3255,442,1941},
            [itemKeys.objectDrops] = {404352,106319,106318},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211324] = {
            [itemKeys.name] = "Waylaid Supplies: Rough Boomsticks",
            [itemKeys.npcDrops] = {208638,2064,6866,7318,1770,1116,1426,1657,2149,1177,1869,1660,1658,2030,1539,330,2989,119,1868,3397,1772,2232,1124,473,2951,1656,3111,7234,43,2978,3116,1174,2178,285,1779,2962,3269,2027,3232,3126,1520,10159,2163,7235,3205,2979,2970,1953,1163,2176,2324,2004,1765,3566,2005,1867,3122,1523,1674,1866,3381,1797,3438,1123,1543,589,9523,2963,11911,2957,97,11912,2234,1162,2322,3284,1782,1544,3380,2011,1941,2179,95,1236,1534,2021,3129,3112,40,1135,1175,1532,1117,1186,1115,2015,500,327,2017,590,3382,2009,2010,1196,2990,3197,504,2190,2321,3246,2167,480,1780,1190,2069,478,2202,1536,3242,2029,3207,157,2177,474,3198,3234,1934,126,2960,476,3285,830,2070,171,1166,2950,3120,3121,118,4263,114,117,3117,1553,3273,3254,3115,3244,3127,3035,1161,1530,732,3113,1127,3415,1211,2164,3276,1693,1176,3425,1202,1195,1538,3265,1999,1184,2185,1529,3268,1522,1138,1766,822,124,3110,3266,735,2235,712,1537,199,1109,3206,3130,454,524,3255,1131,2959,3119,3103,1197,1675,1173,3272,1201,2964,2231},
            [itemKeys.objectDrops] = {404352,106319,106318},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211325] = {
            [itemKeys.name] = "Waylaid Supplies: Handstitched Leather Belts",
            [itemKeys.npcDrops] = {6866,1664,7318,6846,6927,3199,1236,3225,1426,1971,880,1539,2004,3192,119,1868,2033,1531,2019,3204,1655,473,285,1769,327,513,1543,2176,2324,3122,2201,2152,2178,1540,712,2011,1545,11911,1779,3112,501,3265,2976,3111,1186,7235,3205,830,3103,2012,1953,1765,2069,732,2212,3118,1123,2185,9523,3268,1117,2962,1161,524,95,1544,2978,3382,3114,2190,2965,1164,3285,3119,1176,3272,3117,2951,1996,1797,1184,2015,116,2231,2960,2018,1554,1166,10160,3197,1195,3115,1766,2321,1162,1535,3284,1674,3121,2167,456,2164,2029,1163,2177,3198,504,454,1934,126,1555,3232,590,2956,11910,3271,1196,1211,1397,1197,3104,2070,3099,1115,834,1127,2950,1175,118,1675,46,3131,1109,3255,1126,117,2989,2964,2235,1537,2963,1548,2234,822,3035,2008,3425,1202,474,1194,3273,3275,1532,3381,1190,1553,1922,3244,3267,114,2010,515,1138,3127,1523,1172,3246,2043,3266,3276,199,97,589,1520,3415,2163,1121,3100,3129,824,3385,1174,1173,500,1201,1120,3242,36,3269,3254,40,1941,1693,478,1522,2009,4127,3110,2959,1135},
            [itemKeys.objectDrops] = {404352,106319,106318},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211326] = {
            [itemKeys.name] = "Waylaid Supplies: Embossed Leather Vests",
            [itemKeys.npcDrops] = {202060,472,60,2061,1865,7318,3056,6123,1773,1236,1972,2027,880,1545,3227,2971,2951,2976,6866,1658,2030,1539,2324,1997,3199,1662,3243,2177,390,1782,11910,3114,2190,1779,7235,3204,1753,1656,1996,1999,1528,2000,327,1941,3274,1674,3203,1175,1544,2167,3113,1123,2178,1540,456,2202,3195,500,2034,1127,1184,3271,476,3205,2979,2013,2176,3381,1166,2950,3120,1765,478,474,1195,1866,121,550,126,3438,735,3129,97,2234,2069,1162,3035,1122,3246,3382,2019,3107,3285,3103,2008,116,1197,1135,1532,1797,1211,1172,46,1163,3126,43,285,1186,1769,2015,1529,1426,3268,2017,2960,3197,504,2321,95,3123,1523,3425,1190,3266,2965,2164,1689,1117,2033,2029,3207,3397,199,3122,3198,3234,2978,3232,2956,1766,1520,1196,10159,2959,1397,3119,3116,4316,830,3242,2009,11913,1174,2189,3255,2212,3110,1693,2964,1553,1554,1537,2963,36,3269,114,1914,2152,1161,454,1530,480,2011,1176,2179,3566,157,1538,3121,3111,2185,1922,2203,118,4127,1138,1867,117,3284,3117,442,3099,1115,712,3272,3282,123,3206,524,732},
            [itemKeys.objectDrops] = {404352,106319,106318},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211327] = {
            [itemKeys.name] = "Waylaid Supplies: Brown Linen Pants",
            [itemKeys.npcDrops] = {208638,3141,2968,2066,6866,5786,2972,1426,1177,1769,1549,3058,1655,3232,7318,1971,3195,2030,2990,2977,2957,2322,1124,2979,121,3204,1656,1135,1532,11911,1765,3397,97,2000,43,1657,2324,3274,2963,1797,2152,1527,2167,3107,1545,1117,1534,2971,2976,2978,1773,2956,3205,1953,2176,11913,2004,2950,3566,2005,2960,500,116,550,3438,589,3206,2009,2962,1535,1161,1782,1122,3113,2020,3114,2321,1941,2204,1397,2008,2070,1236,2021,1766,2951,40,1538,1174,2185,3284,2189,478,2015,2970,1779,2018,2010,1211,515,36,3269,1867,3123,3129,1172,3117,3110,1123,1526,2202,3282,2177,95,3198,501,3035,3234,3381,1934,524,126,1555,3197,3244,590,3415,476,1162,3268,7235,2164,3285,3119,3116,4316,822,1115,834,1127,1166,1175,3276,4127,1675,46,2069,3131,2190,285,1126,1201,1195,3118,1866,2964,3266,1781,114,3254,1163,3115,2234,1530,1544,3246,480,3382,2163,2965,1176,2179,199,3425,157,3112,3273,3265,3242,1184,3126,1186,3272,1922,1529,504,3267,10160,1548,454,3127,124,2043,2235,712,1536,1537,123,1188,3130},
            [itemKeys.objectDrops] = {404352,106319,106318},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211328] = {
            [itemKeys.name] = "Waylaid Supplies: Brown Linen Robes",
            [itemKeys.npcDrops] = {202060,2014,1664,1380,6866,3051,880,2951,1426,735,2324,3114,2011,2005,330,2989,1779,2963,3241,2232,1656,1528,43,513,11910,3274,1123,481,2009,2001,3265,2034,833,126,2976,2978,3232,10159,2979,3267,2025,3104,2070,2004,3120,1765,3192,2959,3266,1536,40,1135,97,2234,1914,2322,1782,1530,1544,2020,1520,2965,1164,3116,2177,2021,3112,1195,1538,1996,3381,1675,1174,1172,46,3111,1163,3126,478,285,1769,2015,2970,2030,2017,590,36,3269,3254,1766,2321,2043,480,1526,3273,1186,2164,1689,1117,3282,11912,123,2231,1778,3206,504,501,524,1797,1553,3271,1131,3415,1922,1162,3268,7235,3285,4316,1693,1522,1115,1166,2950,1175,1190,2190,157,3118,3110,1543,95,1537,3197,3244,3127,1535,2152,3284,732,3246,3382,1196,3107,3276,474,3122,1534,3121,2185,2203,114,834,2176,10160,1211,118,4127,1138,3277,1867,3123,1523,1674,116,121,2167,3425,1780,3099,712,2202,3272,3242,3397,2962,3035,3255,589,2960,1121,1397,3119,1197,171,3129,4263,2069,2178,2189,1173,500,2964,1554,3566,1194,3198,3100,2010,117},
            [itemKeys.objectDrops] = {404352,106319,106318},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211329] = {
            [itemKeys.name] = "Waylaid Supplies: Herb Baked Eggs",
            [itemKeys.npcDrops] = {202060,2968,1119,1133,6927,6123,3058,3248,1177,1527,3203,1660,3227,1773,1769,1426,1658,7319,2152,2977,881,3438,1781,2324,1531,2232,2020,1770,7235,1124,3103,2008,473,1654,712,2951,1135,3126,2000,43,480,1657,2176,2177,3122,1163,3035,2043,2167,3107,2202,1536,97,3112,1912,3269,833,2978,3232,3271,4316,2013,2025,1197,3383,1522,2004,1778,2960,1674,3117,1123,735,2963,3268,3282,1772,390,2234,3206,2010,1166,1782,732,118,2956,6789,1131,2019,2190,1526,2011,1164,1941,2204,3116,3379,2179,2021,1195,1538,1996,1174,126,114,3111,2185,589,3246,285,1186,1201,513,2964,2017,3382,2018,157,3274,2990,3254,3115,2321,1162,95,1172,1115,2069,478,456,11911,1117,2033,2029,3566,11912,123,3130,3197,2027,40,1196,10159,476,2163,2164,830,1161,3284,3104,171,11913,3120,1175,3121,1765,4263,3131,2189,1109,1173,3255,2212,590,3118,1866,3425,2989,1693,2231,1779,3273,1537,36,504,3244,1914,1535,1544,2205,3114,1211,3276,116,1534,3129,3198,3265,824,3275,1532,1797,1999,46,1184,1553,423,3272,1529,2203},
            [itemKeys.objectDrops] = {404352,106319,106318},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211330] = {
            [itemKeys.name] = "Waylaid Supplies: Spiced Wolf Meat",
            [itemKeys.npcDrops] = {209928,6846,1664,2178,2005,390,1779,1527,880,2324,97,2971,1773,6866,1768,2979,2030,2990,2977,9523,3243,6123,2322,2027,2020,476,1176,3204,2167,1236,1655,473,2950,1656,3196,1996,2000,2962,1866,2989,524,3248,1164,117,1544,3113,1174,3107,1689,1536,2010,1166,3122,831,2190,2034,2978,3115,3268,1201,1172,2012,1116,1953,478,1115,2009,1175,3197,4263,1173,2177,1162,3192,40,1195,3381,550,3438,2964,735,2185,1781,2963,36,3269,3282,1135,11912,3206,3425,1535,1782,95,1122,504,589,3380,1526,1941,1121,3379,3266,2021,3112,1532,1190,126,1161,2189,1553,43,285,1769,1529,1127,2018,3273,10160,2163,515,2959,114,3129,3284,3117,2043,480,46,2965,1537,11911,1117,2033,2029,3207,501,1188,3035,3234,1797,3232,1548,116,11910,1131,1766,3277,3272,3127,2164,1397,3242,3267,3104,1522,3121,118,1765,2321,2212,1126,1211,1693,1543,1554,3254,2152,732,3382,2960,3114,2011,2008,2179,3566,157,1538,3275,1555,2069,3111,423,1186,2203,2970,3255,2176,454,1867,822,1674,121,3246,1780,3110,1123,712,1163,1109},
            [itemKeys.objectDrops] = {404352,106318,106319},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211331] = {
            [itemKeys.name] = "Waylaid Supplies: Brilliant Smallfish",
            [itemKeys.npcDrops] = {2067,1936,1133,1665,6846,1981,6866,1664,1545,3058,1773,1124,1236,2324,1426,2990,7318,2950,2978,2019,1660,2971,2234,2177,3383,2018,524,3438,97,3206,1531,1782,1530,2008,1654,2951,1135,11911,1765,3111,1657,1177,2009,2963,1540,1689,1536,2010,3198,1538,2962,501,3265,833,46,1520,3205,2013,1953,95,834,2004,3120,1175,2069,2189,3566,2005,3242,1523,117,1674,550,1779,1781,3268,2957,3207,3397,1211,1772,3121,3035,1544,2956,2020,1127,3380,3107,2190,2011,2164,3379,478,3117,2070,1202,3122,1534,3266,3129,40,1162,3275,1996,1675,1190,1555,2185,3284,2000,43,2015,1201,2030,732,513,2964,2231,1522,2017,114,3382,1109,3274,3127,822,1535,124,121,3425,3099,1115,1526,2965,3272,481,2029,118,123,1194,3234,1797,3197,2027,3255,3232,589,116,11910,10159,2959,3119,3116,2979,830,3103,1161,3267,1197,11913,4263,1173,2321,285,504,2212,590,1195,3118,1780,3381,2989,2235,1554,1537,1117,36,3254,3115,1914,1172,3246,3113,2205,3415,3276,1176,157,3112,1532,454,1999,2203,3100,3244,2970,1166,515,4127},
            [itemKeys.objectDrops] = {404352,106319,106318},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211332] = {
            [itemKeys.name] = "Waylaid Supplies: Heavy Linen Bandages",
            [itemKeys.npcDrops] = {2067,2061,6133,2974,5786,99,3051,1865,1770,6846,1981,3199,881,1773,2232,1426,1657,2201,2976,6866,2979,2012,2977,126,119,1662,6123,2957,2970,2178,6789,476,2204,1124,1236,1753,2950,1135,3196,1769,2015,2030,513,2017,1177,1781,2324,3274,1163,2070,1523,2043,456,2010,2008,123,1532,1912,3126,3271,3415,7235,3119,4316,2013,2009,3121,1765,1548,2005,1173,2190,2321,474,3198,2163,550,2989,2964,1779,423,2202,11911,36,3397,3282,1772,2069,2322,3035,1782,1530,1122,1544,2978,480,2020,3380,3114,2011,2965,3285,3116,3379,3103,117,1202,171,2021,2951,3273,1538,1675,1190,1999,3111,43,1922,500,95,1522,3382,2960,2176,2018,10160,515,3254,1867,3123,1126,3129,3117,2167,3425,590,504,735,1211,712,1526,1941,481,1689,1536,1117,2029,3207,97,3122,3206,501,833,524,3232,2185,1766,1162,3268,1121,2959,3284,3242,3246,3120,3276,118,46,2189,157,40,1195,3118,1866,116,1780,1554,10158,3197,3277,1914,1535,2152,1161,454,3113,3099,1115,2205,1196,3107,2164,1176,3566,2177,1534,3112,3275,1797,1186},
            [itemKeys.objectDrops] = {404352,106319,106318},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211365] = {
            [itemKeys.name] = "Supply Shipment",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211367] = {
            [itemKeys.name] = "Supply Shipment",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211368] = {
            [itemKeys.name] = "Supply Shipment",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211382] = {
            [itemKeys.name] = "Small Courier Satchel",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = {213077,214070,214096,214098,214099,214101},
            [itemKeys.startQuest] = nil,
        },
        [211384] = {
            [itemKeys.name] = "Sturdy Courier Bag",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = {213077,214070,214096,214098,214099,214101},
            [itemKeys.startQuest] = nil,
        },
        [211385] = {
            [itemKeys.name] = "Rune of Serpent Spread",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = {213077,214070,214096,214098,214099,214101},
            [itemKeys.startQuest] = nil,
        },
        [211386] = {
            [itemKeys.name] = "Spell Notes: Arcane Surge",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = {213077,214070,214096,214098,214099,214101},
            [itemKeys.startQuest] = nil,
        },
        [211387] = {
            [itemKeys.name] = "Rune of Beckoning Light",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = {213077,214070,214096,214098,214099,214101},
            [itemKeys.startQuest] = nil,
        },
        [211390] = {
            [itemKeys.name] = "Rune of Teasing",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = {213077,214070,214096,214098,214099,214101},
            [itemKeys.startQuest] = nil,
        },
        [211391] = {
            [itemKeys.name] = "Rune of Healing Rain",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = {213077,214070,214096,214098,214099,214101},
            [itemKeys.startQuest] = nil,
        },
        [211392] = {
            [itemKeys.name] = "Rune of Everlasting Affliction",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = {213077,214070,214096,214098,214099,214101},
            [itemKeys.startQuest] = nil,
        },
        [211393] = {
            [itemKeys.name] = "Rune of Single-Minded Fury",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = {213077,214070,214096,214098,214099,214101},
            [itemKeys.startQuest] = nil,
        },
        [211419] = {
            [itemKeys.name] = "Handful of Shifting Scales",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211420] = {
            [itemKeys.name] = "Shifting Scale Talisman",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211421] = {
            [itemKeys.name] = "The Box",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211422] = {
            [itemKeys.name] = "Shard of the Void",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211423] = {
            [itemKeys.name] = "Void-Touched Leather Gloves",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211443] = {
            [itemKeys.name] = "Blade of Rage",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211444] = {
            [itemKeys.name] = "Summoner's Cloak",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211445] = {
            [itemKeys.name] = "Barbaric Recurve",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211447] = {
            [itemKeys.name] = "Arms Shipment",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211448] = {
            [itemKeys.name] = "Signed Procurement Contract",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211449] = {
            [itemKeys.name] = "Avenger's Void Pearl",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211450] = {
            [itemKeys.name] = "Invoker's Void Pearl",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211451] = {
            [itemKeys.name] = "Acolyte's Void Pearl",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211452] = {
            [itemKeys.name] = "Perfect Blackfathom Pearl",
            [itemKeys.npcDrops] = {213334},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 78917,
        },
        [211454] = {
            [itemKeys.name] = "Strange Water Globe",
            [itemKeys.npcDrops] = {202699},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 78920,
        },
        [211455] = {
            [itemKeys.name] = "Slick Fingerless Gloves",
            [itemKeys.npcDrops] = {209678},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211456] = {
            [itemKeys.name] = "Dagger of Willing Sacrifice",
            [itemKeys.npcDrops] = {213334},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211457] = {
            [itemKeys.name] = "Twilight Defender's Girdle",
            [itemKeys.npcDrops] = {209678},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211458] = {
            [itemKeys.name] = "Tome of Shadow Warding",
            [itemKeys.npcDrops] = {209678},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211460] = {
            [itemKeys.name] = "Ancient Arctic Buckler",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211461] = {
            [itemKeys.name] = "Inscribed Gravestone Scepter",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211462] = {
            [itemKeys.name] = "Ever-Sustaining Ring",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211463] = {
            [itemKeys.name] = "Chittering Beetle Clasps",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211464] = {
            [itemKeys.name] = "Worn Prelacy Cape",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211465] = {
            [itemKeys.name] = "Nimbus Boots of Insight",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211466] = {
            [itemKeys.name] = "Tender's Heartwood Girdle",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211467] = {
            [itemKeys.name] = "Band of the Iron Fist",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211468] = {
            [itemKeys.name] = "Frayed Chestnut Mantle",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211471] = {
            [itemKeys.name] = "Cliffspring Key",
            [itemKeys.npcDrops] = {2179,2180},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211472] = {
            [itemKeys.name] = "Libram of Banishment",
            [itemKeys.npcDrops] = {910,215,909},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211476] = {
            [itemKeys.name] = "Rune of Fires Wake",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = {414713},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211477] = {
            [itemKeys.name] = "Rune of Incinerate",
            [itemKeys.npcDrops] = {214519},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211482] = {
            [itemKeys.name] = "Shatterspear Offering",
            [itemKeys.npcDrops] = {2183,2182,2181},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211487] = {
            [itemKeys.name] = "Demolition Explosives",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = {3537},
            [itemKeys.startQuest] = nil,
        },
        [211488] = {
            [itemKeys.name] = "Rune of the Avenger",
            [itemKeys.npcDrops] = {214456},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211490] = {
            [itemKeys.name] = "Prophecy of a Thousand Lights",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211491] = {
            [itemKeys.name] = "Bottomless Murloc Skin Bag",
            [itemKeys.npcDrops] = {204921},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211492] = {
            [itemKeys.name] = "Kelris's Satchel",
            [itemKeys.npcDrops] = {209678},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211498] = {
            [itemKeys.name] = "Trainee's Sentinel Nightsaber",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = {14753},
            [itemKeys.startQuest] = nil,
        },
        [211499] = {
            [itemKeys.name] = "Trainee's Outrider Wolf",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = {14754},
            [itemKeys.startQuest] = nil,
        },
        [211500] = {
            [itemKeys.name] = "Resilient Cloth Headband",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = {14753,14754},
            [itemKeys.startQuest] = nil,
        },
        [211501] = {
            [itemKeys.name] = "Chestguard of Might",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211502] = {
            [itemKeys.name] = "Void-Touched Leather Gauntlets",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211504] = {
            [itemKeys.name] = "Twilight Avenger's Chain",
            [itemKeys.npcDrops] = {209678,213334,204921,207356},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211505] = {
            [itemKeys.name] = "Twilight Avenger's Helm",
            [itemKeys.npcDrops] = {213334,209678,204921,207356},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211506] = {
            [itemKeys.name] = "Twilight Avenger's Boots",
            [itemKeys.npcDrops] = {213334,209678,204921,207356},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211507] = {
            [itemKeys.name] = "Twilight Elementalist's Cowl",
            [itemKeys.npcDrops] = {213334,209678,207356,204921},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211508] = {
            [itemKeys.name] = "Twilight Elementalist's Footpads",
            [itemKeys.npcDrops] = {213334,209678,207356,204921},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211509] = {
            [itemKeys.name] = "Twilight Elementalist's Robe",
            [itemKeys.npcDrops] = {213334,209678,204921,207356},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211510] = {
            [itemKeys.name] = "Twilight Slayer's Cowl",
            [itemKeys.npcDrops] = {213334,209678,204921,207356},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211511] = {
            [itemKeys.name] = "Twilight Slayer's Footpads",
            [itemKeys.npcDrops] = {209678,213334,207356,204921},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211512] = {
            [itemKeys.name] = "Twilight Slayer's Tunic",
            [itemKeys.npcDrops] = {213334,209678,207356,204921},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211514] = {
            [itemKeys.name] = "Spell Notes: Mass Regeneration",
            [itemKeys.npcDrops] = {212261},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211528] = {
            [itemKeys.name] = "Dark Insight",
            [itemKeys.npcDrops] = {910,909,215},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211530] = {
            [itemKeys.name] = "Prophecy of a City Enthralled",
            [itemKeys.npcDrops] = {436},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211531] = {
            [itemKeys.name] = "Prophecy of Seven Visitors",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211534] = {
            [itemKeys.name] = "Primal Insight",
            [itemKeys.npcDrops] = {3750,3922,3924},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211691] = {
            [itemKeys.name] = "Spell Notes: Arcane Blast",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211777] = {
            [itemKeys.name] = "Naga Manuscript",
            [itemKeys.npcDrops] = {3715,3717},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211779] = {
            [itemKeys.name] = "Comprehension Charm",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = {958,983,1257,1275,1307,1308,1351,1463,1673,2805,3323,3335,3351,3490,3542,3562,3700,3970,4083,4220,4562,4575,4878,5110,5151,8361,13476},
            [itemKeys.startQuest] = nil,
        },
        [211780] = {
            [itemKeys.name] = "Scroll: KWYJIBO",
            [itemKeys.npcDrops] = {46,126,390,474,501,515,524,712,833,1123,1163,1166,1177,1186,1188,1527,1538,1540,1543,1544,1554,1662,1689,1767,1778,1780,1781,1912,1914,1981,2029,2033,2152,2177,2179,2185,2189,2202,2203,2204,2212,2234,2235,2322,2963,2964,2979,2990,3100,3104,3107,3111,3113,3119,3127,3198,3244,3274,3285,3380,3415,3461,3566,4127,4263,4316,5787,6866,10158,11911,210537,36,423,442,476,480,735,1109,1117,1121,1126,1173,1176,1184,1194,1397,1529,1530,1555,1674,1769,1779,1782,1797,1866,1867,1934,1941,2008,2013,2070,2176,2178,2321,2956,2959,3103,3115,3116,3117,3118,3120,3121,3122,3192,3206,3267,3272,3276,3277,3284,3425,7318,10159,123,285,500,513,822,1164,1174,1190,1201,1202,1426,1523,1532,1545,1675,1765,1766,1922,2010,2069,2167,2978,3035,3112,3246,3266,3269,3271,3382,3385,116,157,199,732,1162,1172,1175,1197,1526,1537,1548,2009,2164,2231,3197,3242,3255,3273,3381,95,97,118,834,1115,1553,3129,590,1535,114,589,1161,1195,1196,1520,1522,1693,454,1127,1135,40,1211,478,504},
            [itemKeys.objectDrops] = {404352,106319,106318},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211784] = {
            [itemKeys.name] = "Scroll: WUBBA WUBBA",
            [itemKeys.npcDrops] = {48,127,171,202,212,422,424,426,445,449,452,505,544,824,920,930,948,949,1008,1012,1020,1027,1028,1032,1110,1157,1167,1189,1194,1393,1908,1942,1943,1955,1956,1973,2054,2089,2157,2170,2205,2208,2233,2266,2267,2323,2336,2339,2349,2351,2354,2356,2384,2427,3239,3247,3251,3252,3257,3260,3375,3376,3377,3385,3424,3456,3458,3711,3712,3732,3733,3734,3740,3748,3765,3767,3770,3780,3781,3810,3817,3921,3925,3988,3989,4005,4006,4012,4013,4020,4024,4040,4093,4463,4627,8886,9524,10323,11913,12856,217,428,430,446,545,578,1021,1025,1165,1197,1915,2165,2180,2235,2237,3240,3282,3283,3286,3730,4007,4127,11912,11917,124,213,485,517,580,1007,1164,3261,3278,3717,3924,423,547,548,1024,1939,3256,3461,4067,441,598,3263,4416},
            [itemKeys.objectDrops] = {111095,3715,2850,2849},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211785] = {
            [itemKeys.name] = "Scroll: CWAL",
            [itemKeys.npcDrops] = {209742,2063,6093,513,1654,2149,6866,1426,2977,456,1536,1163,97,1549,1782,1770,1779,3204,1236,1656,327,1177,1867,2201,1535,1674,1530,1174,1534,2971,1188,2978,1773,10159,476,480,1953,2324,2950,1173,3192,1126,1211,1866,2167,1797,3438,9523,1772,2152,95,1122,3113,1520,2204,1397,3379,117,1197,1778,2951,1135,1532,1117,2178,43,1769,3118,2964,515,2990,3115,3121,1190,1123,735,712,1186,11911,3207,3397,1109,474,123,501,1934,2027,2956,3271,1162,7235,1164,3119,4316,1172,2979,504,3267,3104,1765,46,2069,114,285,2212,500,1195,3117,116,2989,1543,3273,3242,1912,36,1914,1544,40,2205,1127,3415,2008,3122,1538,3265,126,1555,1999,1184,3111,3126,478,1922,1529,3268,3100,3244,1201,2231,590,834,2176,1166,3197,1766,454,2190,1523,1161,3284,3425,3110,1115,3266,1537,3282,11912,3206,2962,589,3382,11910,1131,1121,2959,1175,118,1675,2189,3272,1120,10158,1548,3277,3127,822,1526,3566,157,2177,1194,3198,3381,1553,423,3461,1522,2321,1780,3035,732,3255,2960,1196,2164,1693,3129,824,3246,3099},
            [itemKeys.objectDrops] = {404352,106319,106318},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211786] = {
            [itemKeys.name] = "Scroll: CHAP BALK WELLES",
            [itemKeys.npcDrops] = {583,2061,1865,6866,1972,1772,7318,880,1545,285,1768,1997,2977,2038,119,833,1124,1674,1538,3265,3196,1769,1426,1866,1177,3274,2963,1164,515,1544,3195,2008,1120,3206,1555,2976,2027,3205,1535,2013,2025,3104,1116,2004,2950,1941,1135,1174,2178,1778,330,550,2989,735,1779,9523,97,2322,2962,1782,732,3113,1115,6789,2020,1127,3380,3107,3379,2021,1117,1190,1797,1172,423,1529,3268,327,3118,2030,1196,36,2990,3277,1867,117,121,2167,480,1780,40,46,1123,2189,456,2965,3242,1537,1693,2033,1163,3566,2177,123,501,454,524,126,2978,116,3271,1131,7235,3116,2979,2010,1175,3276,3121,2190,1186,500,1195,1211,1543,95,504,1914,478,1161,1530,3246,442,1526,2164,1176,157,1202,474,3122,1534,3198,3275,1999,1184,3111,3244,1201,3267,1522,114,590,2009,834,2176,2324,118,1138,3127,1162,3123,1126,1523,2043,712,2202,1536,11911,3397,1188,3035,3382,2956,11910,3461,3415,1121,1397,3119,3129,824,1675,2069,3272,3425,2964,1554,3273,3269,3197,1548,3115,1766,3255,3381,2185,589,1553,3100,1166},
            [itemKeys.objectDrops] = {404352,106319,106318},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211787] = {
            [itemKeys.name] = "Scroll: LOWER PING WHOMEVER",
            [itemKeys.npcDrops] = {208196,3228,1380,2039,1770,1664,3058,880,833,6866,1426,3205,1779,1197,1868,1772,2232,3114,1202,1753,2021,1654,2951,1656,2178,1769,2030,2017,1177,1781,2018,1520,1166,36,1867,1123,735,3195,2029,3207,2971,1934,1767,2976,1773,476,2979,2012,11913,1175,1675,95,1523,330,1536,2957,3397,97,2152,1122,732,2205,1121,1236,1534,1172,1163,1173,2000,43,116,2964,1522,40,1554,3274,1138,1162,1535,1674,480,46,456,1186,1537,2177,474,3381,126,2027,11910,3271,3425,1766,3272,114,7235,4316,3103,3104,454,2950,1765,1109,2190,285,2212,590,1126,1195,3118,1780,3110,1543,1553,10158,3269,2234,3035,1544,118,3113,1196,3415,1526,2965,1941,504,2008,3122,3273,3265,3121,1532,1190,1999,3111,2185,589,2189,423,3268,1201,834,2010,10160,1211,2164,1548,3127,822,1161,3284,121,3246,2167,1115,3266,1127,712,11911,1117,3282,123,3206,2962,3244,3100,3119,3116,1693,2070,3129,1135,478,2231,3242,1912,3197,3115,3255,3276,157,1778,1194,3198,1555,3461,1922,3267,2009,4127,2321,117,3117,3382,2960,2163,2959,2069},
            [itemKeys.objectDrops] = {404352,106319,106318},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211789] = {
            [itemKeys.name] = "Artemis Cowl",
            [itemKeys.npcDrops] = {204068},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211799] = {
            [itemKeys.name] = "Sack of Stolen Goods",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211800] = {
            [itemKeys.name] = "Scroll of Reintegration",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211809] = {
            [itemKeys.name] = "Comprehension Primer",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211813] = {
            [itemKeys.name] = "Silverwing Sentinel Charm",
            [itemKeys.npcDrops] = {212707,212804,212803,212703,212706,212699},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 79098,
        },
        [211814] = {
            [itemKeys.name] = "Warsong Outrider Mark",
            [itemKeys.npcDrops] = {212730,212802,212801,212729,212728,212727},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = 79090,
        },
        [211815] = {
            [itemKeys.name] = "Silverwing Battle Hymn",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211816] = {
            [itemKeys.name] = "Warsong Battle Drum",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211818] = {
            [itemKeys.name] = "Strange Water Globe",
            [itemKeys.npcDrops] = {202699},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211819] = {
            [itemKeys.name] = "Waylaid Supplies: Bronze Bars",
            [itemKeys.npcDrops] = {48,98,202,426,432,433,442,445,446,452,545,923,1007,1020,1025,1027,1032,1083,1165,1167,1189,1197,1216,1727,1924,1943,1953,1954,1955,1974,2168,2169,2170,2187,2206,2208,2236,2237,2244,2323,2349,3238,3240,3275,3279,3385,3386,3416,3426,3459,3463,3466,3711,3712,3721,3725,3730,3739,3742,3749,3750,3758,3782,3783,3797,3809,3820,3823,3893,3917,3926,3944,3987,3992,3993,4005,4006,4011,4012,4013,4021,4022,4025,4042,4044,4053,4073,4094,4128,9523,10323,10758,11912,12856,430,437,449,517,531,615,628,824,930,1008,1011,1012,1021,1028,1194,1417,1942,2156,2165,2183,2233,2260,2336,2339,2354,2427,3239,3245,3250,3260,3277,3457,3717,3728,3743,3748,3780,3922,3943,3991,3999,4019,4096,9524,122,124,203,217,428,440,485,505,539,565,568,578,832,1010,1111,1164,1939,1973,2157,2338,2384,3263,3280,3286,3713,3924,4007,424,435,1400,2180,3278,3283,3458,4040,4463,4627,214129,422,2351,3258,3261,3988,3989,5053,213,548,2261,441,547,3256,1024,8886,4416,598},
            [itemKeys.objectDrops] = {111095,2850,2849},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211820] = {
            [itemKeys.name] = "Waylaid Supplies: Silver Bars",
            [itemKeys.npcDrops] = {209797,211965,214129,2159,2160,2120,4073,2332,1973,4015,4074,3745,2338,8886,3434,2169,4264,3396,2171,1956,2339,3472,2183,3733,4416,2449,1943,579,3944,2427,1954,518,6180,3667,3435,2208,3248,3445,2180,3774,3730,3459,4070,435,2054,2181,423,9524,2170,3749,449,3746,4053,4627,598,3816,3992,4014,124,3725,3456,3394,2182,9523,445,5053,3923,3812,3282,2168,615,424,2207,127,98,4463,909,1024,2157,441,2102,1028,1032,12896,3283,4006,4096,452,1942,3386,3279,3457,3999,2244,2235,3466,4005,3278,3928,122,2071,1727,4037,458,832,923,1027,3240,3426,1400,3820,11913,3819,3286,628,3249,1167,2323,154,547,3245,2233,4094,1940,2103,2156,431,1914,1189,213,568,203,3712,3239,4020,3809,3252,3989,4036,2336,3256,4128,422,578,3713,2165,3743,1020,3251,3260,3988,217,121,442,12856,2266,48,3922,446,2268,1083,1192,2267,3263,1007,485,1197,432,171,1111,2360,1165,2349,3921,580,1939,3458,4093,430,2351,3924,440,531,3376,4012,428,1194,539,4007,4127,4067,2350,1021,1010,3,2356,548,3717,824,948},
            [itemKeys.objectDrops] = {3715,111095,2850,2849},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211821] = {
            [itemKeys.name] = "Waylaid Supplies: Medium Leather",
            [itemKeys.npcDrops] = {98,203,435,437,442,453,458,531,539,568,578,628,889,930,1021,1040,1167,1189,1194,1222,1393,1400,1417,1888,1923,1939,1955,1956,2071,2102,2103,2156,2157,2168,2169,2206,2207,2233,2260,2267,2268,2360,2384,2387,3236,3257,3277,3279,3374,3375,3386,3452,3455,3459,3463,3466,3467,3471,3712,3725,3727,3737,3739,3743,3750,3781,3814,3816,3820,3823,3824,3921,3991,3992,3993,4004,4005,4008,4020,4022,4031,4036,4054,4067,4070,4093,4127,5053,5683,9524,10373,11913,12940,217,345,422,449,505,517,545,547,579,824,1010,1027,1083,1111,1197,1940,1942,1943,2054,2179,2266,2336,3239,3240,3252,3458,3461,3711,3730,3740,3745,3749,3772,3917,3924,3928,3988,4094,4463,11917,122,202,213,423,440,548,580,1165,1727,2181,2338,2354,3245,3261,3715,3717,3999,4026,4627,10323,48,428,430,441,1025,1032,1164,2244,2261,3260,3282,3809,3925,4007,565,1020,2165,2180,2237,2351,3385,446,485,1024,2235,3258,3283,3989,8886,3286,3256,3263,3278,2339,4416,598},
            [itemKeys.objectDrops] = {111095,3715,2850,2849},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211822] = {
            [itemKeys.name] = "Waylaid Supplies: Bruiseweed",
            [itemKeys.npcDrops] = {48,98,124,171,203,213,215,217,433,434,435,442,445,458,539,548,628,923,1025,1040,1043,1167,1169,1189,1194,1197,1216,1417,1913,1914,1943,1956,1973,2120,2156,2160,2170,2179,2182,2183,2206,2266,2322,2350,2449,3239,3240,3252,3257,3260,3374,3377,3393,3426,3456,3457,3458,3466,3467,3474,3475,3712,3717,3728,3730,3733,3739,3743,3749,3758,3781,3814,3816,3820,3824,3926,3944,3988,4002,4021,4094,4127,4129,11915,14272,212837,214129,3,202,423,424,426,440,449,531,568,580,930,1020,1021,1022,1111,1164,1185,2102,2168,2233,2235,2267,2360,2384,3245,3263,3277,3385,3713,3740,3817,3819,3823,3921,3924,3925,3928,3993,3999,4012,4013,4018,4067,4070,4096,12856,127,432,1008,1027,1032,1727,2180,2261,2336,2351,2354,2356,3280,3282,3283,3286,3461,3750,3772,3991,4005,4006,4014,4020,9524,485,547,565,1007,1010,1083,1165,2268,3278,4007,4627,422,441,1939,2237,2244,2338,2339,3809,122,446,2165,3989,3258,3261,428,5053,8886,1024,3256,4416,598},
            [itemKeys.objectDrops] = {3715,111095,2850,2849},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211823] = {
            [itemKeys.name] = "Waylaid Supplies: Swiftthistle",
            [itemKeys.npcDrops] = {127,171,423,426,429,432,440,446,505,517,545,569,819,824,831,889,1007,1010,1012,1025,1026,1027,1032,1043,1192,1216,1222,1224,1393,1400,1888,1939,1942,1954,2053,2102,2156,2160,2169,2179,2182,2237,2244,2260,2266,2322,2323,2336,2350,2356,2360,2403,3248,3277,3280,3377,3424,3436,3452,3456,3475,3713,3721,3725,3728,3730,3732,3737,3742,3745,3746,3809,3812,3814,3988,3998,4002,4003,4009,4013,4020,4025,4037,4040,4093,6180,6788,11913,11915,11917,11921,12856,98,202,422,435,442,452,539,580,615,923,1024,1028,1165,1167,1189,2157,2168,2183,2208,2265,2339,2351,3252,3275,3282,3374,3461,3467,3727,3816,3823,3917,3924,4005,4006,4022,4127,11912,122,213,430,437,485,531,1083,1197,1955,2235,3258,3260,3278,3458,3819,3925,3987,4012,4627,214129,48,424,548,832,1111,1164,2071,2354,3240,3245,3261,3385,3989,3991,3999,9524,449,2165,2180,2261,2384,3256,3263,3750,4007,547,3283,3711,3286,428,8886,565,2338,3239,441,5053,4416,598},
            [itemKeys.objectDrops] = {111095,2850,2849},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211824] = {
            [itemKeys.name] = "Waylaid Supplies: Lesser Mana Potions",
            [itemKeys.npcDrops] = {3,121,171,202,215,217,422,431,432,433,440,531,539,548,580,831,1008,1009,1012,1016,1020,1027,1030,1111,1165,1194,1197,1727,1940,1956,1973,2157,2158,2170,2179,2180,2182,2183,2233,2236,2237,2266,2267,2351,2356,2360,2384,2427,3238,3260,3263,3277,3456,3459,3461,3471,3472,3503,3711,3712,3715,3725,3733,3749,3750,3781,3809,3921,3926,3944,4005,4012,4018,4020,4023,4024,4036,4040,4053,4074,4093,10323,11915,12856,428,449,485,565,615,1167,1189,1216,1393,1400,1417,1913,1939,2156,2205,2207,2235,2260,2265,2349,3245,3280,3282,3374,3458,3473,3713,3717,3814,3816,3817,3823,3924,3925,4013,4067,4096,4463,5053,9523,214129,430,442,547,1164,2336,2338,2339,3240,3989,4627,122,435,1021,3258,3278,3283,3286,213,1024,3261,3999,441,2261,3256,8886,598,4416},
            [itemKeys.objectDrops] = {111095,3715,2850,2849},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211825] = {
            [itemKeys.name] = "Waylaid Supplies: Rough Bronze Boots",
            [itemKeys.npcDrops] = {98,124,127,345,430,441,452,505,544,569,578,580,711,923,1025,1026,1029,1083,1164,1169,1205,1224,1417,1914,1924,1943,1956,1974,2071,2102,2157,2165,2181,2182,2183,2236,2237,2260,2261,2265,2267,2323,2338,2339,2451,3245,3247,3251,3261,3374,3377,3456,3458,3467,3667,3717,3725,3742,3746,3749,3774,3783,3809,3823,3917,3922,3944,3988,3998,4002,4003,4006,4012,4014,4020,4023,4026,4096,4127,4128,4129,6020,6180,9523,202,424,440,442,458,485,517,547,548,824,1007,1012,1032,1165,1167,1194,1939,2168,2206,2233,2351,2354,2356,2384,3258,3260,3385,3445,3712,3745,3750,4007,4013,4094,5053,48,217,422,428,433,446,449,531,565,1185,2266,3239,3275,3283,3457,3461,3780,3991,4005,4627,9524,203,568,930,1010,1020,1024,1028,2336,2360,3240,3278,3989,8886,2180,3286,435,3256,4416,598},
            [itemKeys.objectDrops] = {3715,111095,2850,2849},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211826] = {
            [itemKeys.name] = "Waylaid Supplies: Silver Skeleton Keys",
            [itemKeys.npcDrops] = {3,48,115,121,124,202,422,428,431,433,434,442,445,453,568,578,832,909,1007,1010,1021,1022,1032,1164,1167,1169,1185,1222,1727,1913,1942,1943,1954,1955,1956,1974,2089,2156,2182,2206,2208,2244,2265,2267,2356,3238,3239,3240,3252,3261,3275,3282,3374,3375,3385,3394,3424,3426,3452,3459,3463,3467,3728,3733,3739,3742,3772,3774,3780,3781,3816,3820,3824,3900,3921,3924,3928,3988,4005,4006,4007,4022,4025,4053,4067,4093,4096,4463,11921,217,424,426,435,440,548,565,615,1008,1012,1027,1028,1192,1216,1417,2170,2336,2338,2350,2360,3250,3251,3277,3283,3456,3809,3814,3917,3944,3989,4094,12856,213,430,446,1165,2103,2180,2181,2266,2339,3260,3278,3286,3458,3461,3713,3743,4040,4074,4127,4627,11912,517,547,1025,1111,2235,2384,3258,3263,3376,441,485,1083,2165,2261,3245,3256,1024,5053,8886,4416,598},
            [itemKeys.objectDrops] = {111095,2850,2849},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211827] = {
            [itemKeys.name] = "Waylaid Supplies: Runed Silver Rods",
            [itemKeys.npcDrops] = {98,232,429,431,433,434,440,449,458,505,531,548,568,578,711,824,889,923,948,1021,1022,1027,1028,1111,1167,1194,1888,1889,1914,1915,1939,1940,1953,2071,2156,2157,2159,2187,2207,2208,2233,2235,2237,2266,2267,2268,2322,2350,2384,3240,3263,3275,3376,3385,3394,3396,3458,3461,3713,3721,3725,3732,3739,3750,3762,3772,3814,3816,3944,3988,3991,3992,4003,4004,4006,4022,4024,4025,4036,4040,4044,4051,4096,4112,4463,4627,9524,11917,48,422,430,435,441,446,485,615,909,1020,1165,1197,1727,2180,2244,2261,2323,2351,3239,3245,3279,3282,3743,3774,3809,4012,4094,9523,214129,213,423,432,565,930,1007,1164,1974,2181,2182,2336,2339,3249,3260,3286,3928,11912,202,424,428,547,2260,2338,3280,3989,4007,1025,3258,3283,122,1024,1083,4005,5053,8886,3256,4416,3278,598},
            [itemKeys.objectDrops] = {111095,2850,2849},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211828] = {
            [itemKeys.name] = "Waylaid Supplies: Minor Mana Oil",
            [itemKeys.npcDrops] = {121,127,171,426,434,437,442,505,568,615,819,1008,1010,1011,1020,1025,1040,1111,1164,1205,1216,1393,1417,1908,1940,1973,2089,2158,2179,2182,2183,2233,2235,2237,2244,2260,2261,2268,2332,3241,3245,3252,3256,3257,3277,3280,3374,3375,3385,3393,3394,3416,3426,3461,3712,3717,3728,3739,3746,3748,3749,3817,3819,3921,3944,3991,4002,4005,4013,4020,4022,4025,4040,4051,4067,4070,4128,4129,4463,6180,8886,9336,10323,11912,11917,122,213,422,424,429,431,449,531,1028,1083,1192,1400,1939,2157,2165,2170,2180,2266,2267,2336,2339,2349,2360,2384,3239,3260,3282,3286,3459,3467,3711,3743,3988,3999,4007,4093,4127,11913,11918,12856,428,430,435,548,565,1021,1194,2168,3240,3823,3989,4003,4627,1165,2338,3713,547,3261,3263,3278,3283,485,1007,5053,1024,441,3258,4416,598},
            [itemKeys.objectDrops] = {3715,111095,2850,2849},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211829] = {
            [itemKeys.name] = "Waylaid Supplies: Small Bronze Bombs",
            [itemKeys.npcDrops] = {121,124,127,215,426,429,430,431,442,449,452,453,531,539,548,565,568,569,580,930,948,1007,1010,1032,1111,1167,1192,1194,1197,1417,1939,1942,1973,1974,2053,2071,2169,2170,2180,2181,2182,2183,2233,2235,2237,2323,2351,2360,2384,3249,3252,3277,3283,3452,3456,3459,3461,3466,3715,3725,3728,3730,3739,3750,3772,3780,3781,3812,3816,3900,3988,3991,4004,4020,4022,4032,4036,4044,4053,4067,4093,4627,6020,12896,48,202,422,435,824,1727,1940,2157,2168,2261,2339,2350,3260,3261,3263,3374,3385,3458,3467,3727,3809,3819,3823,3926,3928,3989,4005,4006,4094,9524,11912,424,441,445,578,1008,1021,1027,1083,2336,2338,3239,3245,3256,3386,3713,4007,4012,8886,122,428,458,547,615,1020,3240,3258,3286,3717,3999,5053,214129,3278,1024,598,4416},
            [itemKeys.objectDrops] = {3715,111095,2850,2849},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211830] = {
            [itemKeys.name] = "Waylaid Supplies: Ornate Spyglasses",
            [itemKeys.npcDrops] = {98,202,423,440,442,539,565,569,580,615,628,824,1009,1012,1024,1028,1042,1111,1924,1955,2157,2169,2170,2171,2180,2182,2205,2235,2236,2260,2266,2267,2323,2338,2354,2360,2428,3238,3263,3282,3385,3456,3457,3461,3466,3474,3475,3711,3715,3725,3740,3749,3809,3814,3816,3817,3917,3922,3924,3943,3944,4003,4005,4013,4018,4093,4127,4627,7017,9524,12896,214129,121,122,124,127,217,426,428,434,435,437,446,449,505,517,531,1027,1189,1192,1197,1417,1923,1940,1956,2071,2165,2181,2261,2384,3239,3240,3280,3745,3823,3879,3988,3991,3999,4012,4094,4463,441,1032,1083,1165,1914,2179,2237,3245,3260,3261,6606,430,2244,3286,3458,3989,4007,485,547,1167,2339,3256,3283,5053,8886,3258,3278,2336,4416,598},
            [itemKeys.objectDrops] = {111095,3715,2850,2849},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211831] = {
            [itemKeys.name] = "Waylaid Supplies: Dark Leather Cloaks",
            [itemKeys.npcDrops] = {3,115,124,217,428,431,434,435,437,440,442,565,578,615,628,1011,1021,1031,1032,1033,1069,1167,1189,1197,1400,1939,1942,1943,1955,1956,2071,2102,2157,2168,2183,2205,2233,2236,2237,2265,2323,2339,2349,2354,2360,2384,3241,3245,3247,3252,3261,3277,3377,3424,3458,3459,3461,3717,3728,3734,3739,3740,3742,3745,3746,3762,3772,3816,3823,3917,3922,3924,3988,3989,3999,4008,4025,4040,4057,4067,4096,4129,4463,4627,10323,11915,14271,48,127,423,424,426,539,832,1020,1027,1194,1727,2156,2180,2235,2244,2261,2351,3260,3263,3280,3283,3286,3743,3750,3780,3921,4012,4128,9524,11921,202,432,433,485,548,580,1024,1164,1914,2260,2267,3238,3258,3820,4005,5053,122,422,1025,1083,1417,2169,2336,2338,3239,3712,4007,430,441,446,547,3256,3278,8886,598,4416},
            [itemKeys.objectDrops] = {3715,111095,2850,2849},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211832] = {
            [itemKeys.name] = "Waylaid Supplies: Hillman's Shoulders",
            [itemKeys.npcDrops] = {48,202,203,422,423,426,433,435,437,442,446,449,450,452,458,505,517,547,548,565,568,569,615,930,1009,1011,1020,1021,1022,1027,1030,1032,1040,1164,1192,1393,1939,1956,1974,2053,2089,2157,2159,2168,2179,2187,2205,2233,2266,2351,3241,3247,3279,3280,3385,3396,3456,3461,3474,3475,3712,3739,3749,3809,3816,3823,3824,3921,3928,3988,3992,4004,4005,4006,4007,4023,4026,4036,4040,4044,4067,4093,4129,6606,9524,11714,121,127,213,424,430,432,485,580,1007,1026,1167,1417,1727,1940,1958,2180,2182,2206,2208,2235,2237,2336,2339,2354,2384,3239,3240,3457,3467,3713,3715,3730,3743,3745,3750,3989,3991,4094,578,1083,1197,2261,3245,3256,3258,3263,3282,3374,3717,3917,3999,8886,12856,531,2165,2338,3261,3278,3727,5053,122,428,2350,3283,3924,1024,441,4416,598},
            [itemKeys.objectDrops] = {3715,111095,2850,2849},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211833] = {
            [itemKeys.name] = "Waylaid Supplies: Gray Woolen Shirts",
            [itemKeys.npcDrops] = {48,127,422,423,432,433,437,445,453,517,615,819,824,1008,1020,1021,1022,1027,1083,1192,1216,1222,1727,1908,1914,1954,1955,1956,1974,2054,2102,2168,2171,2179,2182,2207,2236,2260,2266,2267,2322,2338,2354,2449,3245,3250,3279,3374,3394,3457,3458,3466,3667,3712,3721,3725,3728,3750,3774,3780,3783,3812,3814,3817,3823,3893,3917,3924,3986,3988,3991,3999,4005,4009,4016,4020,4025,4026,4044,4054,4057,4093,4129,9524,11858,11912,124,213,217,434,435,442,446,452,930,1032,1111,1189,1194,1400,1940,1942,2071,2170,2181,2233,2261,2384,3239,3256,3258,3261,3280,3377,3385,3461,3727,3819,3992,4007,4094,4096,5053,202,428,539,548,1165,2156,2237,3238,3277,4627,11917,424,426,547,565,1024,2165,2244,2336,3260,3286,3713,3717,3809,3989,214129,122,485,8886,441,2339,3283,3263,3278,4416,598},
            [itemKeys.objectDrops] = {3715,111095,2850,2849},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211834] = {
            [itemKeys.name] = "Waylaid Supplies: Pearl-clasped Cloaks",
            [itemKeys.npcDrops] = {48,125,213,428,429,430,437,440,446,531,565,615,832,909,923,1020,1022,1169,1185,1259,1393,1417,1888,1939,1940,1942,1954,1955,2103,2156,2157,2158,2165,2179,2181,2182,2266,2322,2323,2350,3238,3249,3261,3277,3376,3394,3396,3416,3426,3434,3455,3456,3457,3458,3461,3712,3717,3737,3743,3746,3812,3817,3823,3824,3893,3922,3924,3925,3926,3928,3991,4002,4003,4004,4006,4007,4013,4020,4044,4053,4094,4096,4127,4128,4463,4627,6180,6606,9524,10373,11921,12856,12897,214129,122,127,154,171,424,432,441,449,824,948,1032,1111,1167,1197,1727,2102,2170,2180,2244,2360,2384,3279,3386,3711,3727,3733,3750,3988,3989,4005,5053,11912,11915,202,930,1164,1400,2235,2267,2354,3245,3256,3263,3283,3286,3374,3809,3816,485,548,580,2336,3258,3278,3748,3780,3999,8886,547,1024,1194,2351,3260,3713,2339,2338,4416,598},
            [itemKeys.objectDrops] = {3715,111095,2850,2849},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211835] = {
            [itemKeys.name] = "Waylaid Supplies: Smoked Sagefish",
            [itemKeys.npcDrops] = {121,124,217,429,432,433,434,437,446,449,458,548,615,889,948,1016,1020,1028,1033,1164,1165,1192,1194,1205,1400,1940,1956,1957,2071,2102,2103,2170,2171,2183,2205,2206,2208,2236,2266,2268,2351,2384,3238,3239,3241,3245,3247,3249,3252,3280,3376,3385,3386,3393,3396,3457,3466,3467,3471,3712,3717,3727,3728,3732,3737,3743,3745,3749,3772,3782,3812,3816,3820,3917,3924,3925,3991,3993,4014,4018,4037,4040,4051,4093,4096,4129,4627,9523,11858,11915,214129,98,171,213,424,428,430,505,517,531,547,568,569,1007,1025,1026,1032,1167,1189,1197,1417,1909,2207,2267,2323,2338,2354,3240,3260,3283,3461,3713,3725,3748,3819,3823,3928,4006,4007,4025,4127,9524,12678,48,202,422,426,435,440,485,539,578,1010,2235,2237,2261,2339,3275,3286,3809,4094,441,1027,2156,2244,3261,3922,3999,4005,122,1024,1083,3258,3277,3282,5053,8886,2336,3256,3263,3989,2165,3278,598,4416},
            [itemKeys.objectDrops] = {3715,111095,2850,2849},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211836] = {
            [itemKeys.name] = "Waylaid Supplies: Smoked Bear Meat",
            [itemKeys.npcDrops] = {3,48,202,213,217,423,424,440,446,517,580,824,832,889,923,1010,1011,1030,1033,1043,1083,1164,1167,1192,1197,1417,1914,1943,1954,2103,2165,2181,2182,2205,2260,2267,2336,2338,2350,3240,3250,3251,3277,3279,3282,3283,3286,3374,3375,3395,3426,3454,3455,3457,3467,3471,3667,3711,3712,3725,3728,3734,3737,3740,3746,3750,3781,3819,3922,3926,3928,3944,3988,3993,4012,4018,4025,4028,4044,4073,4093,4627,6020,6180,9456,12896,210451,98,127,171,203,426,442,452,458,531,539,568,615,930,1007,1027,1032,1165,1940,1953,2071,2102,2168,2206,2233,2244,2261,2351,2354,2360,3238,3245,3263,3280,3385,3461,3743,3816,3924,3991,3999,4005,4094,11912,11917,214129,430,435,548,1111,2237,3239,3252,3717,3732,3823,3925,4096,4129,122,428,485,1008,1020,1024,1025,1727,2156,2384,3278,3989,4007,5053,12856,547,565,2235,3809,3917,2339,3260,8886,9524,3261,3256,3258,441,4416,598},
            [itemKeys.objectDrops] = {3715,111095,2850,2849},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211837] = {
            [itemKeys.name] = "Waylaid Supplies: Goblin Deviled Clams",
            [itemKeys.npcDrops] = {48,98,127,154,217,218,345,429,430,437,445,453,485,568,569,579,819,824,930,1007,1008,1015,1025,1028,1032,1069,1165,1189,1216,1258,1417,1888,1940,1953,2054,2103,2156,2158,2165,2169,2179,2182,2237,2268,2349,2356,2384,2428,3238,3240,3241,3249,3261,3275,3280,3282,3374,3375,3396,3416,3445,3454,3475,3711,3712,3725,3733,3743,3746,3750,3809,3819,3824,3921,3923,3924,3999,4006,4011,4018,4021,4025,4057,4070,4129,4264,6606,7015,9456,11912,11915,213,428,433,435,452,539,580,1027,1111,1167,1192,1400,1942,1956,2071,2168,2181,2235,2244,2260,2336,2351,2354,2360,3256,3260,3385,3386,3394,3426,3457,3459,3717,3737,3917,4013,4627,11917,214129,434,565,615,1083,2180,2338,2339,3239,3461,3991,4007,4012,4094,4096,9524,422,440,442,517,578,1727,1939,2261,3263,3277,3278,4005,4127,202,426,446,547,3258,3283,122,423,441,1024,5053,8886,4416,598},
            [itemKeys.objectDrops] = {111095,2850,2849},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211838] = {
            [itemKeys.name] = "Waylaid Supplies: Heavy Wool Bandages",
            [itemKeys.npcDrops] = {3,48,98,121,154,202,422,423,424,428,431,440,445,453,505,531,548,1007,1010,1032,1164,1197,1393,1400,1889,1942,1974,2089,2103,2157,2165,2168,2170,2171,2182,2205,2207,2233,2261,2264,2267,2349,2350,2354,3248,3251,3257,3263,3275,3279,3280,3282,3377,3386,3416,3424,3458,3459,3466,3467,3667,3728,3730,3737,3750,3758,3762,3783,3816,3820,3823,3925,3988,3991,4006,4007,4013,4020,4023,4040,4054,4070,4094,4127,4627,212837,214129,124,127,171,217,426,432,449,458,565,819,1020,1022,1027,1165,1913,1954,2102,2169,2180,2181,2208,2235,2265,2323,2339,2360,3250,3261,3278,3376,3456,3475,3774,3819,3917,3924,4012,4463,9524,11912,122,430,446,517,578,580,1167,1939,1940,2156,2336,3245,3461,3713,3717,3999,4005,6180,8886,11917,1417,2244,2266,3256,3283,3809,3989,5053,213,2384,4018,441,485,1024,3258,3260,3277,547,824,3385,598,4416},
            [itemKeys.objectDrops] = {3715,111095,2850,2849},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211839] = {
            [itemKeys.name] = "Supply Shipment",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211840] = {
            [itemKeys.name] = "Supply Shipment",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211841] = {
            [itemKeys.name] = "Supply Shipment",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211842] = {
            [itemKeys.name] = "Rakkamar's Tattered Thinking Cap",
            [itemKeys.npcDrops] = {204068},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211843] = {
            [itemKeys.name] = "Mask of Scorn",
            [itemKeys.npcDrops] = {204068},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211845] = {
            [itemKeys.name] = "Blackfathom Sharpening Stone",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211846] = {
            [itemKeys.name] = "Plans: Blackfathom Sharpening Stone",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211848] = {
            [itemKeys.name] = "Blackfathom Mana Oil",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211849] = {
            [itemKeys.name] = "Formula: Blackfathom Mana Oil",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211852] = {
            [itemKeys.name] = "Handwraps of Befouled Water",
            [itemKeys.npcDrops] = {202699},
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211853] = {
            [itemKeys.name] = "Scroll: VOCE WELL",
            [itemKeys.npcDrops] = {115,122,202,205,345,423,435,452,505,531,539,565,568,579,580,615,628,785,832,1010,1018,1020,1022,1111,1157,1164,1185,1197,1216,1400,1417,1418,1727,1914,1956,1958,2054,2089,2102,2159,2168,2180,2207,2235,2338,2349,2351,2360,3240,3245,3247,3252,3258,3261,3277,3283,3286,3374,3395,3426,3712,3713,3728,3730,3743,3762,3763,3772,3780,3781,3784,3809,3820,3823,3917,3921,3923,3925,3944,3991,4003,4013,4020,4036,4093,4095,4627,9524,11912,12856,98,432,437,446,485,517,1007,1025,1032,1083,1110,1165,1167,1194,1270,1942,2103,2206,2260,2261,2265,2266,2269,2339,3239,3263,3375,3459,3717,3733,3928,4012,8886,428,430,548,1008,1940,1943,3256,3260,3461,3989,4005,422,424,441,547,1024,1027,4007,3278,4416,598},
            [itemKeys.objectDrops] = {3715,2850,2849},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211854] = {
            [itemKeys.name] = "Scroll: OMIT KESA",
            [itemKeys.npcDrops] = {3,98,115,213,426,433,434,441,442,446,449,505,547,565,579,604,824,832,891,892,920,930,948,1008,1020,1032,1069,1083,1111,1158,1165,1169,1185,1197,1216,1270,1393,1417,1418,1666,1727,1908,1909,1942,1954,1955,1956,1973,2168,2206,2233,2260,2267,2339,2387,3249,3280,3282,3283,3286,3374,3395,3458,3459,3461,3727,3730,3740,3743,3780,3784,3893,3924,3988,3989,3991,4014,4020,4025,4051,4099,4109,5053,12897,202,217,422,435,531,539,548,615,819,1007,1010,1025,1167,1194,1939,1953,1974,2071,2102,2165,2384,3260,3456,3824,4007,4093,122,127,440,578,2244,2336,3240,3245,3261,3263,3713,3809,4627,428,1024,1940,2181,2266,2338,3256,8886,3278,4416,598},
            [itemKeys.objectDrops] = {111095,3715,2850,2849},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211855] = {
            [itemKeys.name] = "Scroll: STHENIC LUNATE",
            [itemKeys.npcDrops] = {48,121,122,124,210,424,426,432,449,452,458,505,531,539,548,568,892,948,949,1007,1011,1012,1025,1028,1030,1111,1165,1169,1189,1216,1942,1943,1953,1956,1973,1974,2165,2180,2207,2233,2236,2244,2267,2322,2339,2348,2350,2375,2384,2404,2503,3247,3250,3260,3277,3280,3374,3377,3394,3445,3459,3467,3475,3711,3715,3737,3810,3817,3819,3823,3825,3922,3999,4020,4023,4026,4031,4051,4054,4094,4096,4463,6020,6073,127,202,213,423,430,435,485,517,547,578,1024,1027,1167,1939,2237,2260,2261,2269,2338,2354,2360,3240,3245,3261,3283,3286,3395,3416,3717,3988,4040,4627,6606,9524,440,441,1083,1417,1418,1940,2323,3239,3256,3263,3278,3385,3461,5053,428,1008,2266,3989,3258,8886,598,4416},
            [itemKeys.objectDrops] = {3715,111095,2850,2849},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211856] = {
            [itemKeys.name] = "Resilient Mail Coif",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = {14753,14754},
            [itemKeys.startQuest] = nil,
        },
        [211857] = {
            [itemKeys.name] = "Resilient Leather Mask",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = {14753,14754},
            [itemKeys.startQuest] = nil,
        },
        [211933] = {
            [itemKeys.name] = "Waylaid Supplies: Rough Stone",
            [itemKeys.npcDrops] = {207515,202116,1130,1193,7318,1993,1865,2149,14429,6093,2167,7234,1782,3232,9523,390,2950,1122,2212,1545,1660,3269,6866,476,1426,1983,1535,2176,2962,2005,3199,1674,881,735,1662,2963,6123,1772,2234,2178,2185,2232,2020,2019,1770,1779,46,2959,4316,2979,2177,1654,3265,3196,1996,1675,1528,43,3268,1127,2017,1177,2324,2069,2990,2070,2321,3114,456,3207,2001,97,3246,501,2034,3035,833,126,2976,1529,3266,7235,3205,3119,3103,1161,3242,2025,2012,1116,1953,1163,11913,2004,1166,589,1941,1175,3197,118,3131,2190,1186,3272,2960,3415,1866,2989,1115,712,1536,1912,3254,3397,1135,3115,3267,1190,3206,3130,524,1201,590,3382,6789,3116,478,1197,1548,3198,3112,2951,1538,1162,3275,3121,3381,1211,822,3111,3284,2189,2000,285,1769,1922,327,95,732,513,2964,1522,2009,2018,157,3274,1693,1766,3277,3123,1126,124,2043,1780,40,1123,1689,1537,11911,1117,114,3282,3566,11912,474,3122,3234,454,1797,1555,2027,2978,1553,116,3271,3285,1121,3273,1172,830,3104,3129,3120,1765,1174,504,3117,3110,1120,1543},
            [itemKeys.objectDrops] = {404352,106319,106318},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211934] = {
            [itemKeys.name] = "Waylaid Supplies: Healing Potions",
            [itemKeys.npcDrops] = {202060,2067,1193,2972,2039,1658,1664,6093,1753,43,880,1768,1426,2017,2977,3265,330,119,3438,1662,6123,2152,6789,2232,1770,2321,1655,7234,285,3206,2989,2978,1177,2963,3285,2190,1523,6466,1527,3203,735,123,1773,3232,11913,2177,3192,2043,2167,2964,3207,1772,390,2009,2189,1186,1161,1782,1122,732,589,2960,11910,3114,2008,1236,2951,1162,1135,1532,1996,1675,126,3111,1769,2015,500,2970,1779,114,2324,1554,1166,2990,121,1780,456,2202,1689,1536,1537,11911,1693,2033,2029,3397,97,11912,95,3198,2962,1188,3035,3234,1934,1797,3197,2185,1548,1553,116,1131,1196,3268,1121,2959,4316,2979,3284,3267,2070,1522,2950,1174,478,1173,1126,3117,2164,1543,10158,1912,36,504,2234,1914,1535,1544,118,3113,2205,3107,2011,2965,1176,3566,157,1202,1534,1778,3129,3112,1195,824,3275,3121,3381,1190,1999,1201,2010,515,1138,1766,454,3127,117,124,1674,3425,1123,1127,712,3273,3272,1117,1163,3282,524,3255,40,2956,1520,1211,2163,3119,3116,1197,171,1175,46,2069,2178,3244,3118,2231,3242,3115,822,3246},
            [itemKeys.objectDrops] = {404352,106319,106318},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211935] = {
            [itemKeys.name] = "Waylaid Supplies: Elixir of Firepower",
            [itemKeys.npcDrops] = {3,154,171,202,434,437,440,442,449,458,517,578,580,615,628,930,1007,1009,1010,1011,1012,1026,1040,1069,1164,1167,1197,1259,1417,1727,1908,1920,1923,1940,1942,1958,1974,2156,2165,2169,2180,2182,2207,2208,2233,2244,2261,2266,2268,2323,2339,2350,2356,2360,2384,3238,3245,3251,3260,3263,3275,3286,3374,3377,3386,3396,3711,3715,3728,3733,3739,3745,3750,3780,3817,3823,3924,3928,3991,3993,4003,4005,4007,4014,4020,4036,4037,4040,4094,4127,11912,12896,210107,203,213,426,446,531,539,568,1020,1027,1032,1189,1194,1943,2181,2235,2236,3239,3277,3278,3280,3283,3456,3457,3459,3461,3466,3717,3725,3819,3999,4006,4012,4018,4070,4093,12856,122,217,422,430,547,565,1021,1024,1025,1165,2157,2338,2354,3252,3385,4024,9524,435,441,485,1083,2336,3258,3713,3988,3989,428,3261,3256,3809,2237,4416,5053,8886,598},
            [itemKeys.objectDrops] = {3715,111095,2850,2849},
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211940] = {
            [itemKeys.name] = "Ecks'av's Tribal Guardian",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211941] = {
            [itemKeys.name] = "Windwalker's Yari",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211944] = {
            [itemKeys.name] = "Tojara's Will",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211953] = {
            [itemKeys.name] = "Scroll of Arcane Recovery I",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211954] = {
            [itemKeys.name] = "Scroll of Arcane Accuracy I",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211955] = {
            [itemKeys.name] = "Scroll of Arcane Protection - Fire I",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211956] = {
            [itemKeys.name] = "Scroll of Arcane Protection - Frost I",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [211957] = {
            [itemKeys.name] = "Scroll of Arcane Power I",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [212160] = {
            [itemKeys.name] = "Chronoboon Displacer",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = {958,983,1257,1275,1307,1308,1351,1463,1673,2805,3323,3335,3351,3490,3542,3562,3700,3970,4083,4220,4562,4575,4878,5110,5151,8361,13476},
            [itemKeys.startQuest] = nil,
        },
        [212580] = {
            [itemKeys.name] = "Lorekeeper's Staff",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = {14753},
            [itemKeys.startQuest] = nil,
        },
        [212581] = {
            [itemKeys.name] = "Outrunner's Bow",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = {14753},
            [itemKeys.startQuest] = nil,
        },
        [212582] = {
            [itemKeys.name] = "Protector's Sword",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = {14753},
            [itemKeys.startQuest] = nil,
        },
        [212583] = {
            [itemKeys.name] = "Sentinel's Blade",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = {14753},
            [itemKeys.startQuest] = nil,
        },
        [212584] = {
            [itemKeys.name] = "Advisor's Gnarled Staff",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = {14754},
            [itemKeys.startQuest] = nil,
        },
        [212585] = {
            [itemKeys.name] = "Outrider's Bow",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = {14754},
            [itemKeys.startQuest] = nil,
        },
        [212586] = {
            [itemKeys.name] = "Legionnaire's Sword",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = {14754},
            [itemKeys.startQuest] = nil,
        },
        [212587] = {
            [itemKeys.name] = "Scout's Blade",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = {14754},
            [itemKeys.startQuest] = nil,
        },
        [212588] = {
            [itemKeys.name] = "Provisioner's Gloves",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = {213077,214070,214096,214098,214099,214101},
            [itemKeys.startQuest] = nil,
        },
        [212589] = {
            [itemKeys.name] = "Courier Treads",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = {213077,214070,214096,214098,214099,214101},
            [itemKeys.startQuest] = nil,
        },
        [212590] = {
            [itemKeys.name] = "Hoist Strap",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = {213077,214070,214096,214098,214099,214101},
            [itemKeys.startQuest] = nil,
        },
        [213087] = {
            [itemKeys.name] = "Sergeant's Cloak",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = {12805},
            [itemKeys.startQuest] = nil,
        },
        [213088] = {
            [itemKeys.name] = "Sergeant's Cloak",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = {12799},
            [itemKeys.startQuest] = nil,
        },
        [213121] = {
            [itemKeys.name] = "Preserved Holly",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
        [213443] = {
            [itemKeys.name] = "Ticking Present",
            [itemKeys.npcDrops] = nil,
            [itemKeys.objectDrops] = nil,
            [itemKeys.vendors] = nil,
            [itemKeys.startQuest] = nil,
        },
    }
end
