---@type l10n
local l10n = QuestieLoader:ImportModule("l10n")

local questsByZoneLocales = {
    ["Quests by Zone"] = {
        ["ptBR"] = "Missões por zona",
        ["ruRU"] = "Задания по игровым зонам",
        ["deDE"] = "Quests pro Zone",
        ["koKR"] = "지역 별 퀘스트",
        ["esMX"] = "Misiones por zona",
        ["enUS"] = true,
        ["zhCN"] = "按地区查寻",
        ["zhTW"] = "依區域查看",
        ["esES"] = "Misiones por zona",
        ["frFR"] = "Quêtes par zone",
    },
    ["Select Your Continent and Zone"] = {
        ["ptBR"] = "Selecione seu continente e sua zona",
        ["ruRU"] = "Выберите континент и игровую зону",
        ["deDE"] = "Wähle deinen Kontinent und deine Zone",
        ["koKR"] = "대륙과 지역을 선택해주세요",
        ["esMX"] = "Selecciona tu continente y zona",
        ["enUS"] = true,
        ["zhCN"] = "选择大陆与区域",
        ["zhTW"] = "選擇大陸和區域",
        ["esES"] = "Selecciona tu continente y zona",
        ["frFR"] = "Sélectionnez votre continent et votre zone",
    },
    ["Select Your Continent"] = {
        ["ptBR"] = "Selecione seu continente",
        ["ruRU"] = "Выберите континент",
        ["deDE"] = "Wähle deinen Kontinent",
        ["koKR"] = "대륙 선택",
        ["esMX"] = "Selecciona tu continente",
        ["enUS"] = true,
        ["zhCN"] = "选择大陆",
        ["zhTW"] = "選擇大陸",
        ["esES"] = "Selecciona tu continente",
        ["frFR"] = "Sélectionnez votre continent",
    },
    ["Select Your Zone"] = {
        ["ptBR"] = "Selecione a sua zona",
        ["ruRU"] = "Выберите игровую зону",
        ["deDE"] = "Wähle deine Zone",
        ["koKR"] = "지역 선택",
        ["esMX"] = "Selecciona tu zona",
        ["enUS"] = true,
        ["zhCN"] = "选择区域",
        ["zhTW"] = "選擇區域",
        ["esES"] = "Selecciona tu zona",
        ["frFR"] = "Sélectionnez votre zone",
    },
    ["Select Your Profession"] = {
        ["ptBR"] = "Selecione sua profissão",
        ["ruRU"] = "Выберите профессию",
        ["deDE"] = "Wähle deinen Beruf",
        ["koKR"] = "전문 기술 선택",
        ["esMX"] = "Selecciona tu profesión",
        ["enUS"] = true,
        ["zhCN"] = "选择你的职业",
        ["zhTW"] = "選擇職業",
        ["esES"] = "Selecciona tu profesión",
        ["frFR"] = "Sélectionnez votre profession",
    },
    ["This quest is an automatic completion quest and does not contain an objective."] = {
        ["ptBR"] = "Essa missão é uma missão de conclusão automática e não contém um objetivo.",
        ["ruRU"] = "Это задание выполняется автоматически и не содержит цели",
        ["deDE"] = "Diese Quest schließt sich automatisch ab und beinhaltet keinerlei Ziele.",
        ["koKR"] = "이 퀘스트는 자동으로 완료되는 퀘스트라 표시할 퀘스트 목표가 없습니다.",
        ["esMX"] = "Esta misión se completa automáticamente y no contiene objetivos.",
        ["enUS"] = true,
        ["zhCN"] = "这个任务自动完成，所以没有目标。",
        ["zhTW"] = "這是個會自動完成的任務，而且沒有包含任務目標。",
        ["esES"] = "Esta misión se completa automaticamente y no contiene objetivos.",
        ["frFR"] = "Cette quête est une quête d'achèvement automatique et ne contient pas d'objectif.",
    },
    ["Zone Quests"] = {
        ["ptBR"] = "Missões de zona",
        ["ruRU"] = "Задания выбранной игровой зоны",
        ["deDE"] = "Zonen-Quests",
        ["koKR"] = "지역 퀘스트",
        ["esMX"] = "Misiones de zona",
        ["enUS"] = true,
        ["zhCN"] = "区域任务",
        ["zhTW"] = "區域任務",
        ["esES"] = "Misiones de zona",
        ["frFR"] = "Quêtes de zone",
    },
    ["Available Quests"] = {
        ["ptBR"] = "Missões disponíveis",
        ["ruRU"] = "Доступные задания",
        ["deDE"] = "Verfügbare Quests",
        ["koKR"] = "수행 가능한 퀘스트",
        ["esMX"] = "Misiones disponibles",
        ["enUS"] = true,
        ["zhCN"] = "可接受",
        ["zhTW"] = "可接的任務",
        ["esES"] = "Misiones disponibles",
        ["frFR"] = "Quêtes disponibles",
    },
    ["Completed Quests"] = {
        ["ptBR"] = "Missões concluídas",
        ["ruRU"] = "Выполненные задания",
        ["deDE"] = "Abgeschlossene Quests",
        ["koKR"] = "완료한 퀘스트",
        ["esMX"] = "Misiones completadas",
        ["enUS"] = true,
        ["zhCN"] = "已完成",
        ["zhTW"] = "完成的任務",
        ["esES"] = "Misiones completadas",
        ["frFR"] = "Quêtes terminées",
    },
    ["Completed"] = {
        ["ptBR"] = "Concluída",
        ["ruRU"] = "выполнено",
        ["deDE"] = "Abgeschlossen",
        ["koKR"] = "완료",
        ["esMX"] = "Completada",
        ["enUS"] = true,
        ["zhCN"] = "完成",
        ["zhTW"] = "已完成",
        ["esES"] = "Completada",
        ["frFR"] = "Terminée",
    },
    ["Repeatable Quests"] = {
        ["ptBR"] = "Missões repetíveis",
        ["ruRU"] = "Повторяемые задания",
        ["deDE"] = "Wiederholbare Quests",
        ["koKR"] = "반복 퀘스트",
        ["esMX"] = "Misiones repetibles",
        ["enUS"] = true,
        ["zhCN"] = "可重复的任务",
        ["zhTW"] = "可重覆的任務",
        ["esES"] = "Misiones repetibles",
        ["frFR"] = "Quêtes répétables",
    },
    ["Missing Pre Quest"] = {
        ["ptBR"] = "Faltando missão de pré-requisito",
        ["ruRU"] = "Необходимо предзадание",
        ["deDE"] = "Prequest fehlt",
        ["koKR"] = "선행 퀘스트 미수행",
        ["esMX"] = "Falta misión requisita",
        ["enUS"] = true,
        ["zhCN"] = "需要前置任务",
        ["zhTW"] = "需要前置任務",
        ["esES"] = "Falta misión requisita",
        ["frFR"] = "Pré-quête manquante",
    },
    ["Unobtainable Quests"] = {
        ["ptBR"] = "Missões impossíveis de se obter",
        ["ruRU"] = "Недоступные задания",
        ["deDE"] = "Nicht abschließbare Quests",
        ["koKR"] = "수행이 불가능한 퀘스트",
        ["esMX"] = "Misiones inobtenibles",
        ["enUS"] = true,
        ["zhCN"] = "未完成的任务",
        ["zhTW"] = "無法取得的任務",
        ["esES"] = "Misiones inobtenibles",
        ["frFR"] = "Quêtes impossibles à obtenir",
    },
    ["Pre Quests"] = {
        ["ptBR"] = "Missões de pré-requisito",
        ["ruRU"] = "Предзадание:",
        ["deDE"] = "Pre-Quests",
        ["koKR"] = "선행 퀘스트",
        ["esMX"] = "Misiones requisitas",
        ["enUS"] = true,
        ["zhCN"] = "前置任务",
        ["zhTW"] = "前置任務",
        ["esES"] = "Misiones requisitas",
        ["frFR"] = "Pré-Quêtes",
    },
}

for k, v in pairs(questsByZoneLocales) do
    l10n.translations[k] = v
end
