---@type l10n
local l10n = QuestieLoader:ImportModule("l10n")


local raidLocales = {
    ["Molten Core"] = {
        ["ptBR"] = "Núcleo Derretido",
        ["ruRU"] = "Огненные Недра",
        ["deDE"] = "Geschmolzener Kern",
        ["koKR"] = "화산 심장부",
        ["esMX"] = "Núcleo de Magma",
        ["enUS"] = true,
        ["frFR"] = "Cœur du Magma",
        ["esES"] = "Núcleo de Magma",
        ["zhTW"] = "熔火之心",
        ["zhCN"] = "熔火之心",
    },
    ["Blackwing Lair"] = {
        ["ptBR"] = "Covil Asa Negra",
        ["ruRU"] = "Логово Крыла Тьмы",
        ["deDE"] = "Pechschwingenhort",
        ["koKR"] = "검은날개 둥지",
        ["esMX"] = "Guarida de Alanegra",
        ["enUS"] = true,
        ["frFR"] = "Repaire de l'Aile noire",
        ["esES"] = "Guarida Alanegra",
        ["zhTW"] = "黑翼之巢",
        ["zhCN"] = "黑翼之巢",
    },
    ["Onyxia's Lair"] = {
        ["ptBR"] = "Covil da Onyxia",
        ["ruRU"] = "Логово Ониксии",
        ["deDE"] = "Onyxias Hort",
        ["koKR"] = "오닉시아의 둥지",
        ["esMX"] = "Guarida de Onyxia",
        ["enUS"] = true,
        ["frFR"] = "Repaire d'Onyxia",
        ["esES"] = "Guarida de Onyxia",
        ["zhTW"] = "奧妮克希亞的巢穴",
        ["zhCN"] = "奥妮克希亚的巢穴",
    },
    ["Zul'Gurub"] = {
        ["ptBR"] = "Zul'Gurub",
        ["ruRU"] = "Зул'Гуруб",
        ["deDE"] = "Zul'Gurub",
        ["koKR"] = "줄구룹",
        ["esMX"] = "Zul'Gurub",
        ["enUS"] = true,
        ["frFR"] = "Zul'Gurub",
        ["esES"] = "Zul'Gurub",
        ["zhTW"] = "祖爾格拉布",
        ["zhCN"] = "祖尔格拉布",
    },
    ["Ruins of Ahn'Qiraj"] = {
        ["ptBR"] = "Ruínas de Ahn'Qiraj",
        ["ruRU"] = "Руины Ан'Киража",
        ["deDE"] = "Ruinen von Ahn'Qiraj",
        ["koKR"] = "안퀴라즈 폐허",
        ["esMX"] = "Ruinas de Ahn'Qiraj",
        ["enUS"] = true,
        ["frFR"] = "Ruines d'Ahn'Qiraj",
        ["esES"] = "Ruinas de Ahn'Qiraj",
        ["zhTW"] = "安其拉廢墟",
        ["zhCN"] = "安其拉废墟",
    },
    ["Ahn'Qiraj"] = {
        ["ptBR"] = "Ahn'Qiraj",
        ["ruRU"] = "Ан'Кираж",
        ["deDE"] = "Ahn'Qiraj",
        ["koKR"] = "안퀴라즈",
        ["esMX"] = "Ahn'Qiraj",
        ["enUS"] = true,
        ["frFR"] = "Ahn'Qiraj",
        ["esES"] = "Ahn'Qiraj",
        ["zhTW"] = "安其拉",
        ["zhCN"] = "安其拉",
    },
    ["Naxxramas"] = {
        ["ptBR"] = "Naxxramas",
        ["ruRU"] = "Наксрамас",
        ["deDE"] = "Naxxramas",
        ["koKR"] = "낙스라마스",
        ["esMX"] = "Naxxramas",
        ["enUS"] = true,
        ["frFR"] = "Naxxramas",
        ["esES"] = "Naxxramas",
        ["zhTW"] = "納克薩瑪斯",
        ["zhCN"] = "纳克萨玛斯",
    },
    ["Karazhan"] = {
        ["ptBR"] = "Karazhan",
        ["ruRU"] = "Каражан",
        ["deDE"] = "Karazhan",
        ["koKR"] = "카라잔",
        ["esMX"] = "Karazhan",
        ["enUS"] = true,
        ["frFR"] = "Karazhan",
        ["esES"] = "Karazhan",
        ["zhTW"] = "卡拉贊",
        ["zhCN"] = "卡拉赞",
    },
    ["Gruul's Lair"] = {
        ["ptBR"] = "Covil de Gruul",
        ["ruRU"] = "Логово Груула",
        ["deDE"] = "Gruuls Unterschlupf",
        ["koKR"] = "그룰의 둥지",
        ["esMX"] = "Guarida de Gruul",
        ["enUS"] = true,
        ["frFR"] = "Repaire de Gruul",
        ["esES"] = "Guarida de Gruul",
        ["zhTW"] = "戈魯爾之巢",
        ["zhCN"] = "格鲁尔的巢穴",
    },
    ["Magtheridon's Lair"] = {
        ["ptBR"] = "Covil de Magtheridon",
        ["ruRU"] = "Логово Магтеридона",
        ["deDE"] = "Magtheridons Kammer",
        ["koKR"] = "마그테리돈의 둥지",
        ["esMX"] = "Guarida de Magtheridon",
        ["enUS"] = true,
        ["frFR"] = "Le repaire de Magtheridon",
        ["esES"] = "Guarida de Magtheridon",
        ["zhTW"] = "瑪瑟里頓的巢穴",
        ["zhCN"] = "玛瑟里顿的巢穴",
    },
    ["Serpentshrine Cavern"] = {
        ["ptBR"] = "Caverna do Serpentário",
        ["ruRU"] = "Змеиное святилище",
        ["deDE"] = "Höhle des Schlangenschreins",
        ["koKR"] = "불뱀 제단",
        ["esMX"] = "Caverna Santuario Serpiente",
        ["enUS"] = true,
        ["frFR"] = "Caverne du sanctuaire du Serpent",
        ["esES"] = "Caverna Santuario Serpiente",
        ["zhTW"] = "毒蛇神殿洞穴",
        ["zhCN"] = "毒蛇神殿",
    },
    ["Tempest Keep"] = {
        ["ptBR"] = "Bastilha da Tormenta",
        ["ruRU"] = "Крепость Бурь",
        ["deDE"] = "Festung der Stürme",
        ["koKR"] = "폭풍우 요새",
        ["esMX"] = "El Castillo de la Tempestad",
        ["enUS"] = true,
        ["frFR"] = "Donjon de la Tempête",
        ["esES"] = "El Castillo de la Tempestad",
        ["zhTW"] = "風暴要塞",
        ["zhCN"] = "风暴要塞",
    },
    ["Hyjal Summit"] = {
        ["ptBR"] = "Pico Hyjal",
        ["ruRU"] = "Вершина Хиджала",
        ["deDE"] = "Hyjalgipfel",
        ["koKR"] = "하이잘 정상",
        ["esMX"] = "La Cima Hyjal",
        ["enUS"] = true,
        ["frFR"] = "Sommet d'Hyjal",
        ["esES"] = "La Cima Hyjal",
        ["zhTW"] = "海加爾山",
        ["zhCN"] = "海加尔峰",
    },
    ["Black Temple"] = {
        ["ptBR"] = "Templo Negro",
        ["ruRU"] = "Черный храм",
        ["deDE"] = "Der Schwarze Tempel",
        ["koKR"] = "검은 사원",
        ["esMX"] = "El Templo Oscuro",
        ["enUS"] = true,
        ["frFR"] = "Le Temple noir",
        ["esES"] = "El Templo Oscuro",
        ["zhTW"] = "黑暗神廟",
        ["zhCN"] = "黑暗神殿",
    },
    ["Zul'Aman"] = {
        ["ptBR"] = "Zul'Aman",
        ["ruRU"] = "Зул'Аман",
        ["deDE"] = "Zul'Aman",
        ["koKR"] = "줄아만",
        ["esMX"] = "Zul'Aman",
        ["enUS"] = true,
        ["frFR"] = "Zul'Aman",
        ["esES"] = "Zul'Aman",
        ["zhTW"] = "祖阿曼",
        ["zhCN"] = "祖阿曼",
    },
    ["Sunwell Plateau"] = {
        ["ptBR"] = "Platô da Nascente do Sol",
        ["ruRU"] = "Плато Солнечного Колодца",
        ["deDE"] = "Sonnenbrunnenplateau",
        ["koKR"] = "태양샘 고원",
        ["esMX"] = "Meseta de La Fuente del Sol",
        ["enUS"] = true,
        ["frFR"] = "Plateau du Puits de soleil",
        ["esES"] = "Meseta de La Fuente del Sol",
        ["zhTW"] = "太陽之井高地",
        ["zhCN"] = "太阳之井高地",
    },
    ["Ulduar"] = {
        ["ptBR"] = true,
        ["ruRU"] = "Ульдуар",
        ["deDE"] = true,
        ["koKR"] = "울두아르",
        ["esMX"] = true,
        ["enUS"] = true,
        ["frFR"] = true,
        ["esES"] = true,
        ["zhTW"] = "奧杜亞",
        ["zhCN"] = "奥杜尔",
    },
    ["Wyrmrest Temple"] = { -- Not really a dungeon but used for the Meeting Stone
        ["ptBR"] = "Templo do Repouso das Serpes",
        ["ruRU"] = "Храм Драконьего Покоя",
        ["deDE"] = "Wyrmruhtempel",
        ["koKR"] = "고룡쉼터 사원",
        ["esMX"] = "Templo del Reposo del Dragón",
        ["enUS"] = true,
        ["frFR"] = "Temple du Repos du ver",
        ["esES"] = "Templo del Reposo del Dragón",
        ["zhTW"] = "龍眠神殿",
        ["zhCN"] = "龙眠神殿",
    },
    ["Vault of Archavon"] = {
        ["ptBR"] = "Abóbada de Arcavon",
        ["ruRU"] = "Склеп Аркавона",
        ["deDE"] = "Archavons Kammer",
        ["koKR"] = "아카본 석실",
        ["esMX"] = "La Cámara de Archavon",
        ["enUS"] = true,
        ["frFR"] = "Caveau d'Archavon",
        ["esES"] = "La Cámara de Archavon",
        ["zhTW"] = "亞夏梵穹殿",
        ["zhCN"] = "阿尔卡冯的宝库",
    },
    ["Argent Tournament"] = { -- Not really a dungeon but used for the Meeting Stone
        ["ptBR"] = "Campos do Torneio Argênteo",
        ["ruRU"] = "Ристалище Серебряного турнира",
        ["deDE"] = "Argentumturnierplatz",
        ["koKR"] = "은빛십자군 마상시합 광장",
        ["esMX"] = "Campos del Torneo Argenta",
        ["enUS"] = true,
        ["frFR"] = "Enceinte du tournoi d'Argent",
        ["esES"] = "Campos del Torneo Argenta",
        ["zhTW"] = "銀白聯賽場地",
        ["zhCN"] = "银色比武场",
    },
    ["Icecrown Citadel"] = {
        ["ptBR"] = "Cidadela da Coroa de Gelo",
        ["ruRU"] = "Цитадель Ледяной Короны",
        ["deDE"] = "Eiskronenzitadelle",
        ["koKR"] = "얼음왕관 성채",
        ["esMX"] = "Ciudadela de la Corona de Hielo",
        ["enUS"] = true,
        ["frFR"] = "Citadelle de la Couronne de glace",
        ["esES"] = "Ciudadela de la Corona de Hielo",
        ["zhTW"] = "冰冠城塞",
        ["zhCN"] = "冰冠堡垒",
    },
}

for k, v in pairs(raidLocales) do
    l10n.translations[k] = v
end
