---@type SeasonOfDiscovery
local SeasonOfDiscovery = QuestieLoader:ImportModule("SeasonOfDiscovery")
---@type QuestieDB
local QuestieDB = QuestieLoader:ImportModule("QuestieDB")
---@type ZoneDB
local ZoneDB = QuestieLoader:ImportModule("ZoneDB")

--- Load the base NPCs for Season of Discovery
--- These are generated, do NOT EDIT the data entries here.
--- If you want to edit an NPC, do so in sodNPCFixes.lua
function SeasonOfDiscovery:LoadBaseNPCs()
    local npcKeys = QuestieDB.npcKeys
    local zoneIDs = ZoneDB.zoneIDs
    local sortKeys = QuestieDB.sortKeys

    return {
        [162539] = {
            [npcKeys.name] = "World Talent Master",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [169106] = {
            [npcKeys.name] = "Shea Dorrisist",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [173338] = {
            [npcKeys.name] = "Invisible Bunny",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [176552] = {
            [npcKeys.name] = "Orgrimmar",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [176553] = {
            [npcKeys.name] = "Stormwind",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [176663] = {
            [npcKeys.name] = "Call for Help Trigger",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [176721] = {
            [npcKeys.name] = "Dummy",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [177063] = {
            [npcKeys.name] = "Spellcaster Dummy",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [183709] = {
            [npcKeys.name] = "Season 01 Controller - Era",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [183713] = {
            [npcKeys.name] = "Season 02 Controller - Fresh Start",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [184314] = {
            [npcKeys.name] = "Beta Vendor and Raid Teleporter",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [184383] = {
            [npcKeys.name] = "Sulfuron Harbinger",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [185273] = {
            [npcKeys.name] = "Firemaw Trigger",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [185320] = {
            [npcKeys.name] = "Unstable Chromatic Drake",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 2677,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [185331] = {
            [npcKeys.name] = "Avelina Lilly Projection",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [185332] = {
            [npcKeys.name] = "Isaac Pearson Projection",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [185336] = {
            [npcKeys.name] = "Jezelle's Incubus",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 1497,
            [npcKeys.spawns] = {
                [1497] = {{77.4, 13.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [185342] = {
            [npcKeys.name] = "Ruby Breath Trigger",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [185371] = {
            [npcKeys.name] = "Emerald Breath Trigger",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [185378] = {
            [npcKeys.name] = "Azure Breath Trigger",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [185379] = {
            [npcKeys.name] = "Obsidian Breath Trigger",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [185380] = {
            [npcKeys.name] = "Bronze Breath Trigger",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [185536] = {
            [npcKeys.name] = "Suppression Device Trigger",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [185585] = {
            [npcKeys.name] = "Flame Patch",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [185590] = {
            [npcKeys.name] = "Dream Fog",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [185605] = {
            [npcKeys.name] = "Chromatic Drakonid Spawner",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [185631] = {
            [npcKeys.name] = "Corrupted Weapon",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [185650] = {
            [npcKeys.name] = "Dream Breath Trigger",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [185658] = {
            [npcKeys.name] = "Corrupted Weapon",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [185746] = {
            [npcKeys.name] = "Bouncing Bolt",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [185760] = {
            [npcKeys.name] = "Nightmare Brambles",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [185859] = {
            [npcKeys.name] = "Wing Buffet Trigger",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [185868] = {
            [npcKeys.name] = "[DNT] Electricity Visual Trigger",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [186130] = {
            [npcKeys.name] = "[DNT] Ebonroc and Flamegor Controller",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [186348] = {
            [npcKeys.name] = "The Prophet Skeram",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [186506] = {
            [npcKeys.name] = "[DNT] Frost Tomb",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [187162] = {
            [npcKeys.name] = "Eye of C'Thun",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [187237] = {
            [npcKeys.name] = "Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [187274] = {
            [npcKeys.name] = "Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [187309] = {
            [npcKeys.name] = "Eye of C'Thun",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [187327] = {
            [npcKeys.name] = "Claw Tentacle",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [187345] = {
            [npcKeys.name] = "Eye Tentacle",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [187346] = {
            [npcKeys.name] = "Giant Claw Tentacle",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [187383] = {
            [npcKeys.name] = "AQ40 Bonus Difficulty Trigger",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [187564] = {
            [npcKeys.name] = "AQ40 Bonus Difficulty Indicator",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [187664] = {
            [npcKeys.name] = "Fungal Spore Cluster",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [187724] = {
            [npcKeys.name] = "Mad Scientist",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [187725] = {
            [npcKeys.name] = "Deathknight Captain",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [187728] = {
            [npcKeys.name] = "Necropolis Acolyte",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [187729] = {
            [npcKeys.name] = "Patchwork Golem",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [187798] = {
            [npcKeys.name] = "Corrupted Weapon",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [187801] = {
            [npcKeys.name] = "Corrupted Weapon",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [187832] = {
            [npcKeys.name] = "Skeletal Hitching Post",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [187978] = {
            [npcKeys.name] = "Thaddius Mechanic Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [187993] = {
            [npcKeys.name] = "Plagued Ghoul",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [188018] = {
            [npcKeys.name] = "Dread Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [188109] = {
            [npcKeys.name] = "Tentacle Portal",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [188110] = {
            [npcKeys.name] = "Tentacle Portal",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [188111] = {
            [npcKeys.name] = "Tentacle Portal",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [188119] = {
            [npcKeys.name] = "Claw Tentacle",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [188131] = {
            [npcKeys.name] = "Giant Claw Tentacle",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [188134] = {
            [npcKeys.name] = "Eye Tentacle",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [188147] = {
            [npcKeys.name] = "Tentacle Portal",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [188148] = {
            [npcKeys.name] = "Tentacle Portal",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [188170] = {
            [npcKeys.name] = "Giant Tentacle Portal",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [188178] = {
            [npcKeys.name] = "Tentacle Portal",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [188182] = {
            [npcKeys.name] = "Tentacle Portal",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [188183] = {
            [npcKeys.name] = "Giant Tentacle Portal",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [189047] = {
            [npcKeys.name] = "[DNT] Quick Sand",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [200571] = {
            [npcKeys.name] = "Artificer Terothordius",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [201722] = {
            [npcKeys.name] = "Ghamoo-ra",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [201854] = {
            [npcKeys.name] = "Cutty",
            [npcKeys.minLevel] = 8,
            [npcKeys.maxLevel] = 8,
            [npcKeys.zoneID] = 12,
            [npcKeys.spawns] = {
                [12] = {{49.8, 52},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [201933] = {
            [npcKeys.name] = "Spellfrost Orb",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [202060] = {
            [npcKeys.name] = "Frozen Murloc",
            [npcKeys.minLevel] = 9,
            [npcKeys.maxLevel] = 9,
            [npcKeys.zoneID] = 12,
            [npcKeys.spawns] = {
                [12] = {{76.8, 51.4},{77, 51.8},},
                [85] = {{66.2, 40},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [202079] = {
            [npcKeys.name] = "Shadowfiend",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [202093] = {
            [npcKeys.name] = "Polymorphed Apprentice",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 12,
            [npcKeys.spawns] = {
                [12] = {{28.2, 83},{28.4, 82.4},{28.6, 82.2},{28.6, 82.8},{29.4, 83.6},{29.6, 83.4},{29.6, 84},{29.6, 84.6},{30.8, 90.2},{31, 90.6},{31.2, 68.4},{31.2, 69},{31.2, 87},{31.6, 90},{34.4, 83.2},{34.8, 82.2},{35, 82.8},{37.2, 77.6},{37.4, 77.2},{37.6, 77.6},{38, 77},{38.2, 76.4},{38.6, 76},{40.4, 89.4},{40.4, 90},{40.6, 87.6},{40.8, 89.4},{40.8, 89.8},{44.2, 56.4},{44.4, 57},{44.4, 57.6},{44.6, 56.8},{44.6, 57.6},{44.8, 56.2},{45.8, 87},{46, 86.4},{46.2, 70.8},{46.4, 69.4},{46.4, 70.2},{46.6, 70.4},{46.8, 70.6},{48.4, 52.4},{48.4, 54.2},{48.4, 54.8},{48.4, 81.4},{48.6, 51.4},{48.6, 53.6},{48.6, 55},{48.8, 51.8},{48.8, 53.4},{49, 81.2},{49.2, 81.6},{49.4, 73.4},{49.4, 73.6},{49.8, 73.4},{50, 73.6},{51.4, 84},{56.2, 80.4},{56.2, 80.6},{56.6, 80.4},{56.6, 81},{58.4, 59.8},{58.8, 58.8},{58.8, 60},{61.4, 76.8},{61.6, 77},{62, 77.6},{62.4, 63.2},{62.4, 63.6},{62.8, 63.8},{63, 62.4},{63.2, 63},{63.6, 62.8},{65.4, 42.4},{65.6, 42.4},{65.8, 41.2},{67, 82.6},{67.2, 81.2},{67.2, 81.8},{68.8, 74.6},{69.4, 76.2},{70, 75.4},{70, 75.6},{70.2, 64.2},{70.4, 63.4},{70.6, 63.2},{70.6, 63.6},{73.8, 40.2},{74, 41},{77.4, 39.4},{77.4, 40},{77.6, 39.4},{77.6, 39.6},{79.2, 79.8},{79.4, 64},{79.4, 65.6},{79.4, 78.4},{79.4, 78.8},{79.6, 64.2},{79.6, 79},{79.8, 64.6},{80.4, 49.8},{80.4, 50.6},{80.6, 50.4},{80.8, 49.4},{80.8, 50.6},{82.4, 71},{82.4, 86.8},{82.6, 86.2},{82.8, 70.6},{83.2, 70.2},{83.4, 86.8},{83.6, 82.8},{83.8, 84.6},{84, 84},{85.2, 66},{85.8, 65.4},{85.8, 66},{85.8, 67.2},{86.6, 65.6},{86.8, 82.2},{86.8, 82.6},{87.6, 82.2},{90.2, 77.2},{90.4, 77.6},{90.6, 77.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [202116] = {
            [npcKeys.name] = "Cut-throat Mugger",
            [npcKeys.minLevel] = 10,
            [npcKeys.maxLevel] = 10,
            [npcKeys.zoneID] = 1519,
            [npcKeys.spawns] = {
                [1519] = {{57.4, 28.8},{61.4, 29.2},{61.8, 29.2},{63.2, 29.6},},
                [1537] = {{51.4, 10.6},{51.4, 11.8},{51.8, 12.4},{51.8, 12.8},{52.6, 9.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [202387] = {
            [npcKeys.name] = "Eye of the Void",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [202390] = {
            [npcKeys.name] = "Homunculus",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [202391] = {
            [npcKeys.name] = "Homunculus",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [202392] = {
            [npcKeys.name] = "Homunculus",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [202699] = {
            [npcKeys.name] = "Baron Aquanis",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [202838] = {
            [npcKeys.name] = "Fathom Elemental",
            [npcKeys.minLevel] = 26,
            [npcKeys.maxLevel] = 26,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [202839] = {
            [npcKeys.name] = "Riptide Elemental",
            [npcKeys.minLevel] = 26,
            [npcKeys.maxLevel] = 26,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [202840] = {
            [npcKeys.name] = "Torrent Elemental",
            [npcKeys.minLevel] = 26,
            [npcKeys.maxLevel] = 26,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [203079] = {
            [npcKeys.name] = "Wandering Swordsman",
            [npcKeys.minLevel] = 7,
            [npcKeys.maxLevel] = 7,
            [npcKeys.zoneID] = 1,
            [npcKeys.spawns] = {
                [1] = {{51.8, 48.8},{53.4, 47.4},{53.4, 47.8},{53.6, 47.6},{53.8, 47.2},},
                [12] = {{22.2, 73.2},{22.2, 73.6},{22.4, 72.4},{22.6, 73.2},{24.2, 71},{24.4, 69.4},{24.6, 75.2},{25, 69.4},{25.2, 70},{25.2, 70.6},{25.6, 69.6},{25.6, 74.2},{26.2, 72.2},{29.8, 74.8},{29.8, 76.4},{30.2, 73.2},{30.2, 73.6},{30.6, 74.2},{35.6, 79.2},{36.2, 80.2},{36.2, 80.6},{36.2, 82.4},{37.6, 78.6},{38.4, 75.4},{38.4, 75.6},{38.4, 76.8},{38.6, 75.2},{38.6, 75.6},{38.8, 74.4},{39.8, 75.2},{40.6, 74.4},{40.8, 74.6},{41.6, 76.6},},
                [14] = {{36, 47.4},{36, 48},{37, 46.8},{41, 49.4},{41.2, 49.6},{55, 39.4},{55.8, 38.4},{56, 38.6},{56.4, 27},{56.6, 26.6},{56.8, 21.4},{56.8, 21.6},},
                [141] = {{39.6, 37.6},{39.8, 37.4},{39.8, 69.4},{39.8, 69.6},{43.8, 77},{54.8, 66},{62.6, 71.8},},
                [215] = {{37.8, 55},{40.4, 53.2},{40.6, 53},{40.6, 53.8},{45.4, 36.4},{45.4, 37},{45.6, 36.4},{51.8, 39.2},{60.2, 67.4},{60.2, 67.6},},
            },
            [npcKeys.friendlyToFaction] = "AH",
        },
        [203138] = {
            [npcKeys.name] = "Anvilrage Overseer",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [203139] = {
            [npcKeys.name] = "Son of Arugal",
            [npcKeys.minLevel] = 24,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 130,
            [npcKeys.spawns] = {
                [130] = {{35.4, 19.2},{36, 18.2},{36.2, 19.8},{36.4, 15.2},{36.4, 20.6},{36.6, 15.6},{37, 16.8},{37.4, 15.4},{37.6, 15.8},{37.8, 25.8},{38, 14.2},{38, 28},{38.2, 16.8},{38.4, 14.8},{38.6, 27.2},{39, 17.2},{39.2, 15.2},{39.2, 16.4},{39.2, 26},{39.8, 15.4},{39.8, 18},{40, 16.4},{40, 28.2},{40.2, 30.8},{40.4, 16.6},{40.4, 29.2},{41, 19.4},{41, 19.6},{41.2, 29.4},{41.4, 29.6},{41.6, 18.2},{41.6, 21.6},{41.8, 20},{42.2, 20.8},{42.4, 30.2},{42.6, 21.4},{43, 22},{43, 29.6},{43.6, 19},{43.6, 21.4},{43.6, 21.8},{43.6, 28},{44.2, 29.2},{44.2, 78.4},{44.4, 18.2},{44.4, 19.8},{45, 29},{45, 29.8},{45.2, 17},{45.4, 19},{45.4, 28.2},{45.4, 34.2},{45.6, 29.2},{45.6, 83.4},{45.8, 21.4},{46, 79},{46.4, 26.2},{46.4, 27.6},{46.4, 32.2},{46.4, 33.6},{46.4, 84.2},{46.8, 33.4},{47, 20.6},{47, 83.6},{47.2, 32.2},{47.2, 83.4},{47.4, 34.2},{47.4, 34.8},{47.6, 31.8},{47.6, 33.6},{47.8, 31.4},{47.8, 32.8},{48, 34.8},{48.2, 26},{48.2, 38.4},{48.4, 20.8},{48.6, 31.6},{48.6, 34.8},{48.8, 31},{49, 26.2},{49.2, 20.8},{49.2, 25.4},{49.4, 36.4},{49.8, 76.4},{49.8, 79.2},{49.8, 83.2},{50.6, 34.8},{51, 78.4},{51.6, 76.4},{51.6, 77.8},{52.2, 77.4},{52.6, 76.2},{53.2, 76.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [203147] = {
            [npcKeys.name] = "Whirlpool",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [203218] = {
            [npcKeys.name] = "Giant Whirlpool",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [203226] = {
            [npcKeys.name] = "Viktoria Woods",
            [npcKeys.minLevel] = 30,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 1519,
            [npcKeys.spawns] = {
                [1519] = {{69.4, 50},{69.4, 50.6},{69.6, 50.6},{69.8, 50},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [203279] = {
            [npcKeys.name] = "Riptide Essence",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [203475] = {
            [npcKeys.name] = "Liv Bradford",
            [npcKeys.minLevel] = 30,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 1519,
            [npcKeys.spawns] = {
                [1519] = {{22.4, 63.4},{22.4, 64.4},{22.4, 64.6},{22.6, 64.2},{22.6, 64.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [203478] = {
            [npcKeys.name] = "Stuart",
            [npcKeys.minLevel] = 10,
            [npcKeys.maxLevel] = 10,
            [npcKeys.zoneID] = 1519,
            [npcKeys.spawns] = {
                [1519] = {{21.2, 61},{21.4, 58.6},{21.4, 60.2},{21.4, 61.8},{21.4, 62.6},{21.4, 63.6},{21.6, 62.6},{21.8, 57.6},{21.8, 62.4},{22, 53.8},{22, 58.6},{22, 65.2},{22.2, 63.6},{22.6, 54.2},{23, 56.4},{23.2, 53.2},{29.4, 51},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [203694] = {
            [npcKeys.name] = "Riding Lobster (Dead)",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [204068] = {
            [npcKeys.name] = "Lady Sarevess",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [204070] = {
            [npcKeys.name] = "Soboz",
            [npcKeys.minLevel] = 8,
            [npcKeys.maxLevel] = 8,
            [npcKeys.zoneID] = 1,
            [npcKeys.spawns] = {
                [1] = {{41.2, 36.2},{42, 36.6},{42.2, 35.4},{42.2, 35.6},{42.8, 35.8},},
                [14] = {{67.4, 87.8},{67.4, 89.2},{67.6, 87.8},{67.8, 88.6},},
                [1497] = {{22.2, 42.6},{22.8, 42.8},{23, 38.4},{23.2, 41.2},{23.2, 42.2},{23.6, 37.4},{23.6, 38.4},{23.6, 39.4},{24, 39.6},{24, 41.4},{24, 41.6},},
                [1519] = {{24.8, 77.8},{25, 77.4},{25.6, 78},{25.8, 76.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [204091] = {
            [npcKeys.name] = "Blackfathom Elite",
            [npcKeys.minLevel] = 26,
            [npcKeys.maxLevel] = 26,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [204253] = {
            [npcKeys.name] = "Blackfathom Elite Spawner",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [204256] = {
            [npcKeys.name] = "Damien Kane",
            [npcKeys.minLevel] = 10,
            [npcKeys.maxLevel] = 10,
            [npcKeys.zoneID] = 12,
            [npcKeys.spawns] = {
                [12] = {{44, 66.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [204346] = {
            [npcKeys.name] = "Treant",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [204503] = {
            [npcKeys.name] = "Dead Acolyte",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 12,
            [npcKeys.spawns] = {
                [12] = {{56.4, 57.4},{56.4, 57.8},{56.6, 57.4},{56.6, 57.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [204545] = {
            [npcKeys.name] = "Tim's Stalker 01",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [204645] = {
            [npcKeys.name] = "Blackfathom Elite",
            [npcKeys.minLevel] = 26,
            [npcKeys.maxLevel] = 26,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [204675] = {
            [npcKeys.name] = "Rune Scrying Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [204758] = {
            [npcKeys.name] = "Exploded Corpse",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [204827] = {
            [npcKeys.name] = "Adventurer's Remains",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 1,
            [npcKeys.spawns] = {
                [1] = {{43, 49.4},{43, 49.6},},
                [12] = {{52.2, 84.4},{52.2, 84.6},},
                [14] = {{48, 79.4},{48, 79.6},},
                [141] = {{33.6, 35.6},},
                [215] = {{60.4, 33.4},{60.4, 33.6},},
            },
            [npcKeys.friendlyToFaction] = "AH",
        },
        [204921] = {
            [npcKeys.name] = "Gelihast",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [204937] = {
            [npcKeys.name] = "Adventurer's Spirit",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 1,
            [npcKeys.spawns] = {
                [1] = {{43, 49.6},},
                [12] = {{52.2, 84.4},{52.2, 84.6},},
                [14] = {{48, 79.4},{48, 79.6},},
                [141] = {{33.4, 35.6},{33.6, 35.6},},
                [215] = {{60.2, 33.4},{60.4, 33.6},},
            },
            [npcKeys.friendlyToFaction] = "AH",
        },
        [204940] = {
            [npcKeys.name] = "Puddle",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [204960] = {
            [npcKeys.name] = "Chomp",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [204961] = {
            [npcKeys.name] = "Snarly",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [204962] = {
            [npcKeys.name] = "Tidelurker Mrrglrlr",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [204989] = {
            [npcKeys.name] = "Wounded Adventurer",
            [npcKeys.minLevel] = 5,
            [npcKeys.maxLevel] = 5,
            [npcKeys.zoneID] = 12,
            [npcKeys.spawns] = {
                [12] = {{61.8, 47},{61.8, 47.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [205153] = {
            [npcKeys.name] = "Ada Gelhardt",
            [npcKeys.minLevel] = 10,
            [npcKeys.maxLevel] = 10,
            [npcKeys.zoneID] = 10,
            [npcKeys.spawns] = {
                [10] = {{4.2, 28.6},{4.4, 28.2},{4.6, 27.4},{4.6, 28.2},{4.6, 28.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [205278] = {
            [npcKeys.name] = "Brother Romulus",
            [npcKeys.minLevel] = 30,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 1519,
            [npcKeys.spawns] = {
                [1519] = {{38.2, 28.2},{38.4, 29},{38.6, 27.4},{38.6, 28.4},{38.6, 28.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [205382] = {
            [npcKeys.name] = "Mokwa",
            [npcKeys.minLevel] = 7,
            [npcKeys.maxLevel] = 7,
            [npcKeys.zoneID] = 215,
            [npcKeys.spawns] = {
                [215] = {{35, 57.6},{35.4, 57.2},{35.6, 56.8},{35.6, 57.6},{36.6, 56.6},{37.8, 55.6},{37.8, 56.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [205383] = {
            [npcKeys.name] = "Hunter's Vision",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [205422] = {
            [npcKeys.name] = "Hunter's Vision",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [205423] = {
            [npcKeys.name] = "Hunter's Vision",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [205635] = {
            [npcKeys.name] = "Takoda Sunmane",
            [npcKeys.minLevel] = 8,
            [npcKeys.maxLevel] = 8,
            [npcKeys.zoneID] = 215,
            [npcKeys.spawns] = {
                [215] = {{46.2, 60.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [205692] = {
            [npcKeys.name] = "Rustling Bush",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 215,
            [npcKeys.spawns] = {
                [215] = {{58.8, 54.2},{59, 54.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [205700] = {
            [npcKeys.name] = "Venture Co. Poacher",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 215,
            [npcKeys.spawns] = {
                [215] = {{58.2, 54},{58.6, 54.8},{58.8, 54.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [205724] = {
            [npcKeys.name] = "Blackfathom Tendril",
            [npcKeys.minLevel] = 27,
            [npcKeys.maxLevel] = 27,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [205729] = {
            [npcKeys.name] = "Boarton Shadetotem",
            [npcKeys.minLevel] = 4,
            [npcKeys.maxLevel] = 4,
            [npcKeys.zoneID] = 1638,
            [npcKeys.spawns] = {
                [1638] = {{39.4, 64.4},{39.4, 65.2},{39.4, 66.4},{39.4, 66.6},{39.6, 64.4},{39.6, 65.4},{39.6, 65.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [205733] = {
            [npcKeys.name] = "Blackfathom Pearl",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [205765] = {
            [npcKeys.name] = "Murloc Egg",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [205767] = {
            [npcKeys.name] = "Void Murloc",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [205805] = {
            [npcKeys.name] = "Water Elemental",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [206152] = {
            [npcKeys.name] = "SoD Test Dummy 25",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [206153] = {
            [npcKeys.name] = "SoD Test Dummy 26",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [206154] = {
            [npcKeys.name] = "SoD Test Dummy 27",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [206155] = {
            [npcKeys.name] = "SoD Test Dummy 28",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [206217] = {
            [npcKeys.name] = "Bubble Beam Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [206245] = {
            [npcKeys.name] = "Unleashed Nature Spirit",
            [npcKeys.minLevel] = 7,
            [npcKeys.maxLevel] = 7,
            [npcKeys.zoneID] = 141,
            [npcKeys.spawns] = {
                [141] = {{66.4, 57.6},{67, 58},{67, 58.6},},
                [215] = {{37.2, 49.8},{37.4, 49.4},{37.8, 49.4},{37.8, 49.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [206248] = {
            [npcKeys.name] = "Wooden Effigy",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 141,
            [npcKeys.spawns] = {
                [141] = {{66.8, 58},},
                [215] = {{37.4, 49.4},{37.4, 49.6},{37.6, 49.6},{37.8, 49.4},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [207010] = {
            [npcKeys.name] = "Telemachus",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [207356] = {
            [npcKeys.name] = "Lorgus Jett",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [207358] = {
            [npcKeys.name] = "Blackfathom Tide Priestess",
            [npcKeys.minLevel] = 27,
            [npcKeys.maxLevel] = 27,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [207359] = {
            [npcKeys.name] = "Blackfathom Tide Priestess",
            [npcKeys.minLevel] = 27,
            [npcKeys.maxLevel] = 27,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [207367] = {
            [npcKeys.name] = "Blackfathom Tide Priestess",
            [npcKeys.minLevel] = 27,
            [npcKeys.maxLevel] = 27,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [207397] = {
            [npcKeys.name] = "Corrupted Windfury Totem",
            [npcKeys.minLevel] = 27,
            [npcKeys.maxLevel] = 27,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [207457] = {
            [npcKeys.name] = "Corrupted Lightning Shield Totem",
            [npcKeys.minLevel] = 27,
            [npcKeys.maxLevel] = 27,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [207515] = {
            [npcKeys.name] = "Lurkmane",
            [npcKeys.minLevel] = 7,
            [npcKeys.maxLevel] = 7,
            [npcKeys.zoneID] = 215,
            [npcKeys.spawns] = {
                [215] = {{30.6, 61.2},{30.8, 61.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [207520] = {
            [npcKeys.name] = "Invisible Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [207527] = {
            [npcKeys.name] = "Corrupted Molten Fury",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [207576] = {
            [npcKeys.name] = "Corrupted Molten Fury Totem",
            [npcKeys.minLevel] = 27,
            [npcKeys.maxLevel] = 27,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [207577] = {
            [npcKeys.name] = "Lunar Stone",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 141,
            [npcKeys.spawns] = {
                [141] = {{52.8, 79.8},},
                [215] = {{35, 69.4},{35.2, 69.6},{35.4, 68.2},{35.4, 70.6},{35.6, 70.4},{35.6, 70.6},{35.8, 68},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [207588] = {
            [npcKeys.name] = "Mulgore Lunar Stone Invisible Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [207637] = {
            [npcKeys.name] = "Vateya Timberhoof",
            [npcKeys.minLevel] = 30,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 215,
            [npcKeys.spawns] = {
                [215] = {{46.4, 61.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [207743] = {
            [npcKeys.name] = "Netali Proudwind",
            [npcKeys.minLevel] = 30,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 1638,
            [npcKeys.spawns] = {
                [1638] = {{28.2, 19},{28.4, 18.2},{28.6, 18.2},{28.6, 18.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [207754] = {
            [npcKeys.name] = "Mooart",
            [npcKeys.minLevel] = 10,
            [npcKeys.maxLevel] = 10,
            [npcKeys.zoneID] = 1638,
            [npcKeys.spawns] = {
                [1638] = {{26.4, 18.4},{26.4, 18.8},{26.4, 20},{26.6, 19.8},{27, 18},{27, 18.8},{28, 21.4},{28.2, 22.4},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [207957] = {
            [npcKeys.name] = "Vahi Bonesplitter",
            [npcKeys.minLevel] = 30,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 14,
            [npcKeys.spawns] = {
                [14] = {{53, 43.4},{53, 43.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [208023] = {
            [npcKeys.name] = "Gru'ark",
            [npcKeys.minLevel] = 10,
            [npcKeys.maxLevel] = 10,
            [npcKeys.zoneID] = 1637,
            [npcKeys.spawns] = {
                [1637] = {{49.6, 65},{55.8, 57},{57, 44.6},{57.6, 55.4},{57.6, 57},{58, 48.4},{58, 48.8},{58.2, 50.2},{58.2, 51.2},{58.4, 52},{58.4, 52.6},{58.4, 56.2},{58.6, 51.4},{58.6, 51.8},{58.6, 53.8},{58.8, 53.4},{61.4, 44.4},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [208036] = {
            [npcKeys.name] = "Ba'so",
            [npcKeys.minLevel] = 8,
            [npcKeys.maxLevel] = 8,
            [npcKeys.zoneID] = 14,
            [npcKeys.spawns] = {
                [14] = {{51.8, 58.6},{52, 58.4},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [208071] = {
            [npcKeys.name] = "Back-alley Mugger",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 1637,
            [npcKeys.spawns] = {
                [1637] = {{55.8, 44.6},{56.2, 42.8},{56.4, 43.6},{58.8, 50.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [208124] = {
            [npcKeys.name] = "Raluk",
            [npcKeys.minLevel] = 7,
            [npcKeys.maxLevel] = 7,
            [npcKeys.zoneID] = 14,
            [npcKeys.spawns] = {
                [14] = {{67.6, 73},{67.8, 68.8},{68.4, 71.4},{68.4, 71.6},{68.6, 71.4},{68.6, 71.6},{71, 72},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [208127] = {
            [npcKeys.name] = "Hunter's Vision",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [208128] = {
            [npcKeys.name] = "Hunter's Vision",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [208158] = {
            [npcKeys.name] = "Hunter's Vision",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [208179] = {
            [npcKeys.name] = "Rustling Bush",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 14,
            [npcKeys.spawns] = {
                [14] = {{40.4, 52},{40.6, 52},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [208180] = {
            [npcKeys.name] = "Razormane Poacher",
            [npcKeys.minLevel] = 7,
            [npcKeys.maxLevel] = 8,
            [npcKeys.zoneID] = 1,
            [npcKeys.spawns] = {
                [1] = {{28.8, 49.4},{28.8, 49.8},{29.6, 50.6},},
                [14] = {{40.2, 51.4},{40.4, 52},{40.6, 51.4},{40.6, 52},{40.6, 52.6},{41.8, 51},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [208184] = {
            [npcKeys.name] = "Razzil",
            [npcKeys.minLevel] = 8,
            [npcKeys.maxLevel] = 8,
            [npcKeys.zoneID] = 14,
            [npcKeys.spawns] = {
                [14] = {{52.2, 44},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [208196] = {
            [npcKeys.name] = "Gillgar",
            [npcKeys.minLevel] = 7,
            [npcKeys.maxLevel] = 7,
            [npcKeys.zoneID] = 85,
            [npcKeys.spawns] = {
                [85] = {{25.4, 47.4},{25.4, 48.4},{25.4, 48.8},{25.6, 48.2},{25.6, 48.6},{26.2, 47},{26.4, 46.4},{26.6, 46.8},{27.2, 46.4},{27.6, 46.4},{29, 46.6},{29.8, 46},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [208226] = {
            [npcKeys.name] = "Darmak Bloodhowl",
            [npcKeys.minLevel] = 10,
            [npcKeys.maxLevel] = 10,
            [npcKeys.zoneID] = 14,
            [npcKeys.spawns] = {
                [14] = {{54.4, 41.4},{54.6, 41.4},{54.6, 41.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [208275] = {
            [npcKeys.name] = "Frozen Makrura",
            [npcKeys.minLevel] = 9,
            [npcKeys.maxLevel] = 9,
            [npcKeys.zoneID] = 14,
            [npcKeys.spawns] = {
                [14] = {{58.6, 45.4},{58.6, 45.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [208307] = {
            [npcKeys.name] = "Serpent Loa",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 14,
            [npcKeys.spawns] = {
                [14] = {{55.4, 72.4},{55.4, 72.6},{55.6, 72.4},{55.6, 72.6},},
                [17] = {{51.4, 29.4},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [208309] = {
            [npcKeys.name] = "Loa Altar",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 14,
            [npcKeys.spawns] = {
                [14] = {{55.4, 72.4},{55.4, 72.6},},
                [17] = {{51.4, 29.4},{51.6, 29.4},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [208518] = {
            [npcKeys.name] = "Gaeriyan",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 440,
            [npcKeys.spawns] = {
                [440] = {{54, 23.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [208546] = {
            [npcKeys.name] = "Brazier of Embersight",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [208565] = {
            [npcKeys.name] = "Altar of the Light",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 1,
            [npcKeys.spawns] = {
                [1] = {{28.8, 66.4},{28.8, 66.6},},
                [38] = {{37.4, 46.2},{37.6, 46.2},},
                [40] = {{52.6, 52.4},{52.8, 52.8},},
                [1537] = {{31.2, 19},{31.2, 21.4},{31.4, 20.4},{31.4, 21.6},{32, 18.2},{32, 20.4},{32, 20.6},{32.2, 21.8},{32.6, 21.4},{32.6, 21.6},{32.8, 19},{32.8, 20},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [208619] = {
            [npcKeys.name] = "Dorac Graves",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 1497,
            [npcKeys.spawns] = {
                [1497] = {{47.2, 70.4},{47.4, 70.8},{47.8, 70.2},{47.8, 71.6},{48, 69.4},{48, 70.6},{48.6, 71.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [208638] = {
            [npcKeys.name] = "Fyodi",
            [npcKeys.minLevel] = 7,
            [npcKeys.maxLevel] = 7,
            [npcKeys.zoneID] = 1,
            [npcKeys.spawns] = {
                [1] = {{28.4, 42.8},{28.4, 43.6},{28.6, 43.8},{28.8, 38.4},{28.8, 44.8},{29.4, 39},{29.4, 42.6},{29.6, 38.4},{29.6, 42.2},{29.6, 42.8},{30, 39},{30.2, 43.6},{30.4, 36.6},{30.4, 40.4},{30.4, 41.2},{30.6, 39.4},{30.8, 39.6},{31.6, 40},{32.2, 36},{32.2, 37.6},{32.6, 36.8},{33.2, 35.2},{33.2, 35.6},{33.4, 37.6},{33.6, 35},{33.6, 36},{33.8, 34},{33.8, 37.2},{35, 37.4},{35.2, 32.8},{35.2, 34.2},{35.2, 35},{35.4, 36.4},{35.8, 33.8},{35.8, 36.4},{35.8, 37},{36.6, 36.6},{37.6, 35.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [208652] = {
            [npcKeys.name] = "Junni Steelpass",
            [npcKeys.minLevel] = 30,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 1,
            [npcKeys.spawns] = {
                [1] = {{46.4, 53.2},{46.4, 53.6},{46.6, 53.2},{46.6, 53.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [208682] = {
            [npcKeys.name] = "Denton Bleakway",
            [npcKeys.minLevel] = 10,
            [npcKeys.maxLevel] = 10,
            [npcKeys.zoneID] = 1497,
            [npcKeys.spawns] = {
                [1497] = {{83.4, 25.4},{83.4, 26},{83.4, 26.6},{83.4, 27.6},{83.6, 26.2},{83.8, 27.4},{84, 25.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [208711] = {
            [npcKeys.name] = "Toby",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 1,
            [npcKeys.spawns] = {
                [1] = {{63.4, 50.2},{63.6, 50.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [208712] = {
            [npcKeys.name] = "Odd Melon",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 85,
            [npcKeys.spawns] = {
                [85] = {{30, 47.2},{33.4, 49.4},{33.4, 49.6},{33.6, 49.4},{33.6, 49.8},{34.8, 51.2},{35.4, 49.2},{35.6, 49},{36.4, 50.8},{36.8, 51},{40.2, 42.2},{44, 38.6},{44.2, 38.4},{44.6, 28.4},{44.8, 28.6},{45.4, 33.4},{47, 50.4},{47.2, 28.8},{47.2, 50.8},{49.4, 46.2},{49.4, 46.8},{49.6, 59.2},{49.8, 46.4},{49.8, 46.6},{49.8, 50.4},{50, 59.6},{50.2, 50.8},{50.4, 31},{50.4, 61.8},{50.6, 31},{51.4, 57.2},{51.6, 57.2},{51.6, 57.6},{52.2, 30.2},{52.6, 30},{52.8, 57.8},{53.6, 58.2},{53.8, 28},{53.8, 58.6},{53.8, 59.8},{54, 56.4},{54, 56.8},{57.2, 40.4},{57.4, 40.6},{58.2, 35.6},{58.4, 35.4},{58.6, 35.2},{58.8, 58.2},{59.8, 33.2},{60, 37},{65.6, 63},{71.4, 34},{71.8, 50.8},{72, 50.2},{74.8, 61.6},{75.2, 61.2},{75.8, 59.6},{76, 59.2},{76.4, 51.2},{76.4, 61.4},{76.4, 61.6},{76.6, 61.4},{76.6, 61.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [208752] = {
            [npcKeys.name] = "Frozen Trogg",
            [npcKeys.minLevel] = 9,
            [npcKeys.maxLevel] = 9,
            [npcKeys.zoneID] = 1,
            [npcKeys.spawns] = {
                [1] = {{69.2, 58.2},{69.2, 58.6},{69.6, 58.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [208758] = {
            [npcKeys.name] = "Junior Apothecary",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [208802] = {
            [npcKeys.name] = "Wounded Adventurer",
            [npcKeys.minLevel] = 5,
            [npcKeys.maxLevel] = 5,
            [npcKeys.zoneID] = 1,
            [npcKeys.spawns] = {
                [1] = {{25.4, 43},{25.4, 43.6},{25.6, 43.4},{25.6, 43.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [208809] = {
            [npcKeys.name] = "Hunter's Vision",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [208810] = {
            [npcKeys.name] = "Hunter's Vision",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [208811] = {
            [npcKeys.name] = "Hunter's Vision",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [208812] = {
            [npcKeys.name] = "Jorul",
            [npcKeys.minLevel] = 8,
            [npcKeys.maxLevel] = 8,
            [npcKeys.zoneID] = 1,
            [npcKeys.spawns] = {
                [1] = {{35.8, 42.6},{36.6, 40.4},{37, 41},{37.2, 42.4},{37.4, 43},{37.6, 41.4},{37.8, 42.4},{38.4, 43.4},{38.4, 43.6},{38.6, 43.4},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [208841] = {
            [npcKeys.name] = "Reverent Blacksmith",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [208842] = {
            [npcKeys.name] = "The Gardener",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [208843] = {
            [npcKeys.name] = "Abominable Snowman",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [208844] = {
            [npcKeys.name] = "Crimson Emissary",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [208845] = {
            [npcKeys.name] = "Par'kourc",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [208846] = {
            [npcKeys.name] = "Sun Admirer",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [208847] = {
            [npcKeys.name] = "Bloodrend Bandagethief",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [208875] = {
            [npcKeys.name] = "Back-alley Mugger",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 1637,
            [npcKeys.spawns] = {
                [1637] = {{55.8, 44.6},{56.2, 42.8},{58.4, 49.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [208876] = {
            [npcKeys.name] = "Cut-throat Mugger",
            [npcKeys.minLevel] = 10,
            [npcKeys.maxLevel] = 10,
            [npcKeys.zoneID] = 1519,
            [npcKeys.spawns] = {
                [1519] = {{59, 27.8},{61.4, 29.6},{61.8, 29},{62.4, 29.6},{62.8, 29.6},{63.2, 29.2},},
                [1537] = {{50.6, 10.2},{50.6, 11.4},{51, 12.2},{51.8, 12.4},{52, 12.6},{52.8, 10.4},{56.8, 12.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [208886] = {
            [npcKeys.name] = "Blackrat",
            [npcKeys.minLevel] = 8,
            [npcKeys.maxLevel] = 8,
            [npcKeys.zoneID] = 1,
            [npcKeys.spawns] = {
                [1] = {{57.2, 45.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [208919] = {
            [npcKeys.name] = "Blueheart",
            [npcKeys.minLevel] = 10,
            [npcKeys.maxLevel] = 10,
            [npcKeys.zoneID] = 85,
            [npcKeys.spawns] = {
                [85] = {{59.8, 51.8},{61.2, 53.6},{61.4, 53},{61.6, 51.4},{61.6, 52.8},{61.8, 51.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [208920] = {
            [npcKeys.name] = "Penny Hawkins",
            [npcKeys.minLevel] = 30,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 85,
            [npcKeys.spawns] = {
                [85] = {{61.8, 52},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [208927] = {
            [npcKeys.name] = "Dead Acolyte",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 85,
            [npcKeys.spawns] = {
                [85] = {{76.4, 44.8},{76.6, 44.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [208974] = {
            [npcKeys.name] = "Dark Iron Poacher",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [208975] = {
            [npcKeys.name] = "Rustling Bush",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 1,
            [npcKeys.spawns] = {
                [1] = {{28.8, 49.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [209002] = {
            [npcKeys.name] = "Gaklik Voidtwist",
            [npcKeys.minLevel] = 10,
            [npcKeys.maxLevel] = 10,
            [npcKeys.zoneID] = 1,
            [npcKeys.spawns] = {
                [1] = {{47.2, 53.4},{47.2, 53.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [209004] = {
            [npcKeys.name] = "Bruart",
            [npcKeys.minLevel] = 10,
            [npcKeys.maxLevel] = 10,
            [npcKeys.zoneID] = 1537,
            [npcKeys.spawns] = {
                [1537] = {{60.8, 70.4},{63.6, 73},{65.2, 74.2},{65.4, 77},{66.4, 69.6},{66.6, 73.4},{66.8, 75.2},{67.2, 77.8},{67.6, 74.8},{68, 67.4},{68.8, 71.8},{70.2, 72.8},{70.8, 72.4},{70.8, 75},{71.2, 73.2},{71.2, 75.8},{72, 75.2},{72, 75.6},{72.2, 73.8},{72.4, 76.6},{72.6, 76},{72.8, 75.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [209209] = {
            [npcKeys.name] = "Blackfathom Elite",
            [npcKeys.minLevel] = 26,
            [npcKeys.maxLevel] = 26,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [209213] = {
            [npcKeys.name] = "Murloc Spawner",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [209214] = {
            [npcKeys.name] = "Blackfathom Murloc",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [209511] = {
            [npcKeys.name] = "Oasis Snapjaw Hatchling",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 17,
            [npcKeys.spawns] = {
                [17] = {{48.2, 40.2},{55.8, 42.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [209524] = {
            [npcKeys.name] = "Patrolling Cheetah",
            [npcKeys.minLevel] = 18,
            [npcKeys.maxLevel] = 18,
            [npcKeys.zoneID] = 17,
            [npcKeys.spawns] = {
                [17] = {{43.2, 56.6},{43.4, 56.4},{43.6, 56.6},{44, 56.2},{44.4, 55.2},{44.6, 55.6},{44.8, 55.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [209548] = {
            [npcKeys.name] = "Mannequin",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [209607] = {
            [npcKeys.name] = "Lieutenant Stonebrew",
            [npcKeys.minLevel] = 17,
            [npcKeys.maxLevel] = 17,
            [npcKeys.zoneID] = 17,
            [npcKeys.spawns] = {
                [17] = {{61.4, 54.8},{62.4, 56.2},{62.6, 56.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [209608] = {
            [npcKeys.name] = "Delwynna",
            [npcKeys.minLevel] = 35,
            [npcKeys.maxLevel] = 35,
            [npcKeys.zoneID] = 1657,
            [npcKeys.spawns] = {
                [1657] = {{63.2, 22.6},{63.4, 20.6},{63.4, 21.8},{64, 21.2},{64, 22},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [209678] = {
            [npcKeys.name] = "Twilight Lord Kelris",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [209742] = {
            [npcKeys.name] = "Desert Mirage",
            [npcKeys.minLevel] = 15,
            [npcKeys.maxLevel] = 15,
            [npcKeys.zoneID] = 17,
            [npcKeys.spawns] = {
                [17] = {{54.4, 36},{54.8, 35.8},{55, 35.4},{55.8, 34},{57.4, 35.8},{57.4, 38.4},{57.4, 38.6},{57.6, 35.8},{57.6, 38.4},{57.8, 38.8},{58.8, 37.4},{58.8, 37.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [209758] = {
            [npcKeys.name] = "Invading Nightmare",
            [npcKeys.minLevel] = 26,
            [npcKeys.maxLevel] = 26,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [209773] = {
            [npcKeys.name] = "Dream Copy",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [209797] = {
            [npcKeys.name] = "Bruuz",
            [npcKeys.minLevel] = 20,
            [npcKeys.maxLevel] = 20,
            [npcKeys.zoneID] = 17,
            [npcKeys.spawns] = {
                [17] = {{63.2, 38.6},{63.6, 38.4},{64.4, 39},{64.4, 39.6},{65.2, 39.4},{65.2, 39.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [209806] = {
            [npcKeys.name] = "Waterfall Test",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [209811] = {
            [npcKeys.name] = "Rustling Bush",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 141,
            [npcKeys.spawns] = {
                [141] = {{46.4, 46.2},{46.6, 46.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [209812] = {
            [npcKeys.name] = "Fallenroot Poacher",
            [npcKeys.minLevel] = 9,
            [npcKeys.maxLevel] = 9,
            [npcKeys.zoneID] = 141,
            [npcKeys.spawns] = {
                [141] = {{46.2, 45.4},{46.2, 48.2},{46.2, 49},{46.4, 46.2},{46.4, 46.8},{46.6, 45.4},{46.6, 46.2},{46.6, 46.6},{47.4, 50.2},{47.6, 44.4},{47.6, 50.2},{48, 51},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [209815] = {
            [npcKeys.name] = "Phantasmal Priestess",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [209830] = {
            [npcKeys.name] = "Phantasmal Statue",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [209872] = {
            [npcKeys.name] = "Syllart",
            [npcKeys.minLevel] = 10,
            [npcKeys.maxLevel] = 10,
            [npcKeys.zoneID] = 141,
            [npcKeys.spawns] = {
                [141] = {{56.2, 59.4},{56.2, 59.6},{56.4, 58.4},{56.6, 57.8},{56.8, 58.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [209889] = {
            [npcKeys.name] = "Barebones",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 1519,
            [npcKeys.spawns] = {
                [1519] = {{56, 60.8},{56, 61.6},{56.6, 61.2},},
                [1637] = {{51.8, 75.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [209908] = {
            [npcKeys.name] = "Heretic Idol",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 38,
            [npcKeys.spawns] = {
                [38] = {{71.8, 27},{71.8, 27.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [209928] = {
            [npcKeys.name] = "Mowgh",
            [npcKeys.minLevel] = 8,
            [npcKeys.maxLevel] = 8,
            [npcKeys.zoneID] = 141,
            [npcKeys.spawns] = {
                [141] = {{46.8, 33.6},{47.4, 32.4},{47.4, 32.8},{47.6, 32.6},{48.2, 31.4},{48.2, 31.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [209939] = {
            [npcKeys.name] = "Hunter's Vision",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [209940] = {
            [npcKeys.name] = "Hunter's Vision",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [209941] = {
            [npcKeys.name] = "Hunter's Vision",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [209948] = {
            [npcKeys.name] = "Relaeron",
            [npcKeys.minLevel] = 30,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 1657,
            [npcKeys.spawns] = {
                [1657] = {{38.6, 7.6},{39.2, 9},{39.4, 9.8},{39.8, 9.4},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [209949] = {
            [npcKeys.name] = "Sickly Deer",
            [npcKeys.minLevel] = 5,
            [npcKeys.maxLevel] = 5,
            [npcKeys.zoneID] = 1657,
            [npcKeys.spawns] = {
                [1657] = {{39.2, 8.4},{39.2, 9},{39.6, 9.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [209954] = {
            [npcKeys.name] = "Demonic Remains",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 38,
            [npcKeys.spawns] = {
                [38] = {{72.4, 68.4},{72.4, 68.6},{72.6, 68.4},{72.6, 68.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [209958] = {
            [npcKeys.name] = "Graix",
            [npcKeys.minLevel] = 18,
            [npcKeys.maxLevel] = 18,
            [npcKeys.zoneID] = 38,
            [npcKeys.spawns] = {
                [38] = {{71.2, 68.2},{72.4, 68.4},{72.4, 68.8},{72.6, 68.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [210006] = {
            [npcKeys.name] = "Battle Totem",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [210107] = {
            [npcKeys.name] = "Kackle",
            [npcKeys.minLevel] = 15,
            [npcKeys.maxLevel] = 16,
            [npcKeys.zoneID] = 38,
            [npcKeys.spawns] = {
                [38] = {{52.8, 56.8},{53.2, 55.4},{53.4, 55.8},{53.8, 54.4},{54, 56},{54.2, 56.8},{54.4, 55.2},{54.6, 52.2},{54.8, 54.2},{54.8, 54.6},{55, 55.8},{55.4, 53},{55.6, 52.2},{55.6, 55},{55.8, 53.2},{55.8, 54.4},{57.2, 64.4},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [210451] = {
            [npcKeys.name] = "Lady Sedorax",
            [npcKeys.minLevel] = 18,
            [npcKeys.maxLevel] = 18,
            [npcKeys.zoneID] = 148,
            [npcKeys.spawns] = {
                [148] = {{54.8, 31.6},{55, 32.6},{55, 35.4},{55.2, 33.8},{55.4, 36.2},{55.4, 36.6},{55.6, 35.2},{55.6, 36.4},{55.6, 36.6},{55.8, 34.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [210482] = {
            [npcKeys.name] = "Paxnozz",
            [npcKeys.minLevel] = 20,
            [npcKeys.maxLevel] = 20,
            [npcKeys.zoneID] = 148,
            [npcKeys.spawns] = {
                [148] = {{46.4, 14.4},{46.6, 13.8},{46.8, 17.2},{47.4, 14.8},{47.4, 16.2},{47.6, 13.6},{48, 13.4},{48, 18},{48.2, 15.6},{48.4, 14.6},{48.4, 16.6},{48.6, 16.6},{48.8, 15.6},{49, 11.8},{49, 14.8},{49.2, 12.8},{49.4, 14.2},{49.6, 12},{49.8, 14.4},{50, 14.6},{50.2, 12.6},{50.4, 11.4},{51, 13.6},{51.8, 15.6},{52.4, 17.4},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [210483] = {
            [npcKeys.name] = "Aggressive Squashling",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 40,
            [npcKeys.spawns] = {
                [40] = {{36.6, 48.8},{43.2, 34.2},{43.6, 33.8},{43.8, 38},{44.2, 32.4},{50.4, 19.8},{50.6, 18.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [210487] = {
            [npcKeys.name] = "Horror of the Deep",
            [npcKeys.minLevel] = 20,
            [npcKeys.maxLevel] = 20,
            [npcKeys.zoneID] = 40,
            [npcKeys.spawns] = {
                [40] = {{26, 69.6},{26.2, 68},{26.2, 69.2},{26.8, 66.2},{26.8, 68},{26.8, 69.8},{27, 68.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [210501] = {
            [npcKeys.name] = "Harvest Reaper Prototype",
            [npcKeys.minLevel] = 18,
            [npcKeys.maxLevel] = 18,
            [npcKeys.zoneID] = 40,
            [npcKeys.spawns] = {
                [40] = {{35.4, 52.2},{35.6, 52.2},{44.4, 39.2},{45, 40.8},{45.2, 39.6},{45.4, 38.8},{45.6, 39},{49.6, 36.6},{50, 19},{50.2, 17.4},{50.2, 18.4},{50.6, 18.8},{51.4, 33.4},{51.8, 34},{52.2, 32.4},{52.4, 32.6},{52.8, 33},{61.2, 57.4},{61.4, 58.2},{61.4, 58.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [210528] = {
            [npcKeys.name] = "Terrified Soul",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [210533] = {
            [npcKeys.name] = "Silverspur",
            [npcKeys.minLevel] = 14,
            [npcKeys.maxLevel] = 14,
            [npcKeys.zoneID] = 40,
            [npcKeys.spawns] = {
                [40] = {{33.6, 40.8},{34.8, 38.6},{35, 38.4},{35, 39.6},{35.6, 38.4},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [210537] = {
            [npcKeys.name] = "Undying Laborer",
            [npcKeys.minLevel] = 14,
            [npcKeys.maxLevel] = 15,
            [npcKeys.zoneID] = 40,
            [npcKeys.spawns] = {
                [40] = {{28.8, 49.2},{29, 50.2},{29.4, 46.4},{29.6, 50.6},{29.8, 46},{29.8, 46.6},{30, 49.6},{30.4, 45.4},{30.6, 46},{30.8, 43},{31, 45.2},{31.4, 44.2},{31.6, 44},{31.8, 45},{32, 43.4},{32.2, 42.4},{32.6, 43.2},{34.8, 41.6},{35.2, 40.8},{37.8, 45.4},{43.4, 26.8},{43.8, 25.2},{44.4, 27},{44.4, 29.4},{44.6, 20.2},{44.6, 24.2},{44.6, 24.8},{44.8, 27.4},{45, 22.8},{45, 26},{45.2, 18.6},{45.2, 31.2},{45.4, 18.2},{45.4, 21.2},{45.4, 21.6},{45.4, 28},{45.6, 20.4},{45.6, 21.2},{45.6, 21.8},{45.8, 27.4},{45.8, 36.4},{46, 18.4},{46, 18.6},{46, 26.4},{46.2, 28.2},{46.6, 27.4},{46.8, 29.6},{47.6, 33.6},{50.6, 29.2},{53.4, 27.6},{54.4, 29.6},{55.2, 31.4},{55.8, 47.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [210549] = {
            [npcKeys.name] = "Defias Scout",
            [npcKeys.minLevel] = 14,
            [npcKeys.maxLevel] = 15,
            [npcKeys.zoneID] = 40,
            [npcKeys.spawns] = {
                [40] = {{50.2, 48.2},{50.2, 48.6},{50.4, 47.4},{50.6, 47.6},{51, 47},{51.4, 55.4},{51.4, 55.6},{51.6, 55.2},{51.6, 55.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [210697] = {
            [npcKeys.name] = "Captain Namier",
            [npcKeys.minLevel] = 20,
            [npcKeys.maxLevel] = 20,
            [npcKeys.zoneID] = 130,
            [npcKeys.spawns] = {
                [130] = {{36.6, 26.6},{37.4, 27.8},{37.8, 29.6},{38, 28},{38, 28.6},{38.6, 28.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [210750] = {
            [npcKeys.name] = "M'grrgl",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [210802] = {
            [npcKeys.name] = "Webbed Victim",
            [npcKeys.minLevel] = 16,
            [npcKeys.maxLevel] = 16,
            [npcKeys.zoneID] = 130,
            [npcKeys.spawns] = {
                [130] = {{34.8, 7.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [210845] = {
            [npcKeys.name] = "Jixo Madrocket",
            [npcKeys.minLevel] = 20,
            [npcKeys.maxLevel] = 20,
            [npcKeys.zoneID] = 406,
            [npcKeys.spawns] = {
                [406] = {{59.2, 62.4},{59.2, 62.6},{60.6, 62.2},},
            },
            [npcKeys.friendlyToFaction] = "AH",
        },
        [210887] = {
            [npcKeys.name] = "Unsuspecting Pridewing",
            [npcKeys.minLevel] = 19,
            [npcKeys.maxLevel] = 20,
            [npcKeys.zoneID] = 406,
            [npcKeys.spawns] = {
                [406] = {{60.4, 62},{60.6, 62.4},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [210901] = {
            [npcKeys.name] = "Stonetalon Wyvern stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [210995] = {
            [npcKeys.name] = "Alonso",
            [npcKeys.minLevel] = 20,
            [npcKeys.maxLevel] = 20,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{42, 69},{42.4, 70},{43.4, 70.4},{43.4, 70.6},{43.6, 70.2},{43.6, 70.6},},
            },
            [npcKeys.friendlyToFaction] = "AH",
        },
        [211022] = {
            [npcKeys.name] = "Owen Thadd",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 1497,
            [npcKeys.spawns] = {
                [1497] = {{73.4, 33},{73.6, 33},{73.8, 32.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [211033] = {
            [npcKeys.name] = "Garion Wendell",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = 1519,
            [npcKeys.spawns] = {
                [1519] = {{37.8, 80.2},{37.8, 81},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [211042] = {
            [npcKeys.name] = "Green Dragon Whelp",
            [npcKeys.minLevel] = 20,
            [npcKeys.maxLevel] = 20,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{42, 69.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [211043] = {
            [npcKeys.name] = "Alonso",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [211146] = {
            [npcKeys.name] = "Lost Adventurer",
            [npcKeys.minLevel] = 16,
            [npcKeys.maxLevel] = 16,
            [npcKeys.zoneID] = 130,
            [npcKeys.spawns] = {
                [130] = {{34.2, 9.4},{34.4, 8.4},{35, 7.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [211183] = {
            [npcKeys.name] = "John Lakeman",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [211188] = {
            [npcKeys.name] = "Maethra Slagheart",
            [npcKeys.minLevel] = 50,
            [npcKeys.maxLevel] = 50,
            [npcKeys.zoneID] = 1657,
            [npcKeys.spawns] = {
                [1657] = {{37.8, 88.8},{38, 88},{38, 89.6},{38.6, 88.8},{38.6, 89.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [211200] = {
            [npcKeys.name] = "Agon",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 10,
            [npcKeys.spawns] = {
                [10] = {{59.8, 31.6},{60.6, 25.8},{60.8, 29.2},{61.2, 30.8},{61.4, 30},{61.6, 28.8},{61.6, 29.6},{61.8, 27.6},{63.4, 25},{63.4, 29},{63.6, 31.4},{64, 34},{64.4, 33.2},{64.4, 35.6},{64.8, 24},{64.8, 25},{64.8, 34.4},{64.8, 35.6},{65, 32.4},{65.2, 34.8},{65.4, 26},{65.6, 26.4},{65.6, 34.8},{66, 23.6},{66.6, 29},{66.6, 30.6},{66.8, 28.4},{66.8, 29.8},{67.6, 30.2},{67.6, 31.2},{68, 31.6},{69.4, 32.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [211225] = {
            [npcKeys.name] = "Baj'ura",
            [npcKeys.minLevel] = 20,
            [npcKeys.maxLevel] = 20,
            [npcKeys.zoneID] = 1497,
            [npcKeys.spawns] = {
                [1497] = {{46, 20},{46.4, 19.4},{46.4, 20.6},{47.2, 19.4},{47.2, 19.6},{47.8, 19.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [211229] = {
            [npcKeys.name] = "Dietrich Praice",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 1637,
            [npcKeys.spawns] = {
                [1637] = {{35.4, 88},{35.6, 87.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [211269] = {
            [npcKeys.name] = "Summoned Wisp",
            [npcKeys.minLevel] = 20,
            [npcKeys.maxLevel] = 20,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{86.6, 43.6},{86.8, 43.4},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [211274] = {
            [npcKeys.name] = "Ashenvale Wisp Target",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [211279] = {
            [npcKeys.name] = "Corrupt Spirit Beast",
            [npcKeys.minLevel] = 23,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{86.4, 44},{86.8, 43.4},{86.8, 43.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [211298] = {
            [npcKeys.name] = "Syrnoya",
            [npcKeys.minLevel] = 40,
            [npcKeys.maxLevel] = 40,
            [npcKeys.zoneID] = 148,
            [npcKeys.spawns] = {
                [148] = {{37.6, 43.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [211330] = {
            [npcKeys.name] = "Suspicious Target",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 130,
            [npcKeys.spawns] = {
                [130] = {{65.8, 11.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [211338] = {
            [npcKeys.name] = "Vile Fin Hunter",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 130,
            [npcKeys.spawns] = {
                [130] = {{65.8, 11.2},{65.8, 11.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [211653] = {
            [npcKeys.name] = "Grizzby",
            [npcKeys.minLevel] = 30,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 17,
            [npcKeys.spawns] = {
                [17] = {{61.8, 39.4},},
            },
            [npcKeys.friendlyToFaction] = "AH",
        },
        [211736] = {
            [npcKeys.name] = "Grizzled Protector",
            [npcKeys.minLevel] = 16,
            [npcKeys.maxLevel] = 16,
            [npcKeys.zoneID] = 130,
            [npcKeys.spawns] = {
                [130] = {{36.6, 16},{36.6, 17.2},{37.8, 15.6},{39.4, 15.2},{41.6, 19.6},{44, 51.6},{44.2, 16.6},{48.2, 20.8},{48.6, 21.6},{49.8, 22.4},{50.4, 16.2},{50.4, 38.2},{50.6, 36.6},{50.8, 35.4},{51, 15.8},{51.6, 38.8},{52, 51.2},{52.6, 47.4},{53.2, 20.2},{53.4, 59},{53.8, 45.8},{54.6, 40.4},{55, 41.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [211764] = {
            [npcKeys.name] = "Gefell",
            [npcKeys.minLevel] = 21,
            [npcKeys.maxLevel] = 22,
            [npcKeys.zoneID] = 209,
            [npcKeys.spawns] = {
                [209] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [211765] = {
            [npcKeys.name] = "Gemela",
            [npcKeys.minLevel] = 21,
            [npcKeys.maxLevel] = 22,
            [npcKeys.zoneID] = 209,
            [npcKeys.spawns] = {
                [209] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [211839] = {
            [npcKeys.name] = "Test Boss",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [211875] = {
            [npcKeys.name] = "Decayed Elemental",
            [npcKeys.minLevel] = 15,
            [npcKeys.maxLevel] = 15,
            [npcKeys.zoneID] = 130,
            [npcKeys.spawns] = {
                [130] = {{44.4, 21.8},{44.4, 42},{44.8, 22},{45.2, 21},{45.4, 20.2},{45.6, 22.6},{45.8, 21.2},{46, 19.8},{46, 22.2},{47, 19.2},{47.2, 20.4},{55.4, 15.6},},
                [1637] = {{37, 76.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [211941] = {
            [npcKeys.name] = "Dream Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [211951] = {
            [npcKeys.name] = "Koartul",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 267,
            [npcKeys.spawns] = {
                [267] = {{52.4, 39},{57.2, 22.8},{59, 23.4},{59, 34.6},{59.2, 38.6},{59.4, 32.8},{59.4, 40.2},{60.2, 33},{60.2, 33.6},{60.8, 25},{60.8, 25.6},{60.8, 35.2},{61, 33.2},{61.4, 33.6},{62, 33},{62.2, 31.4},{62.2, 34.6},{62.4, 34.4},{62.6, 34},{64, 33.8},{64.6, 32.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [211952] = {
            [npcKeys.name] = "Omni Diffusion Armor",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [211953] = {
            [npcKeys.name] = "Bulky Protective Ironweave",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [211954] = {
            [npcKeys.name] = "Electrostatic Discharge Shielding",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [211955] = {
            [npcKeys.name] = "Auxiliary Anti-Tamper Mechanism",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [211956] = {
            [npcKeys.name] = "Scarimous the Wandering",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [211965] = {
            [npcKeys.name] = "Carrodin",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 11,
            [npcKeys.spawns] = {
                [11] = {{46.4, 65},{46.6, 65.6},{46.8, 63.4},{47.2, 64.4},{47.2, 64.8},{47.6, 63.2},{47.6, 64},{47.6, 64.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [211967] = {
            [npcKeys.name] = "Leech Stalker Corpse",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [212159] = {
            [npcKeys.name] = "Old Serra'kis",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = "AH",
        },
        [212186] = {
            [npcKeys.name] = "Grugimdern",
            [npcKeys.minLevel] = 20,
            [npcKeys.maxLevel] = 20,
            [npcKeys.zoneID] = 11,
            [npcKeys.spawns] = {
                [11] = {{36.8, 15.2},},
            },
            [npcKeys.friendlyToFaction] = "AH",
        },
        [212209] = {
            [npcKeys.name] = "Vodyanoi",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 11,
            [npcKeys.spawns] = {
                [11] = {{31.2, 18.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [212252] = {
            [npcKeys.name] = "Harvest Golem V000-A",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [212261] = {
            [npcKeys.name] = "Awakened Lich",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 10,
            [npcKeys.spawns] = {
                [10] = {{16, 37.4},{17.4, 37.4},{17.4, 37.6},{17.6, 37.4},{17.8, 38},{18, 38.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [212330] = {
            [npcKeys.name] = "Explrgl",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [212333] = {
            [npcKeys.name] = "Blackfathom Tendril",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [212334] = {
            [npcKeys.name] = "Dead Twilight Cultist",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{17.2, 26.4},{17.2, 26.6},},
            },
            [npcKeys.friendlyToFaction] = "AH",
        },
        [212443] = {
            [npcKeys.name] = "Nightmare Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [212458] = {
            [npcKeys.name] = "Phantasmal Crustacean",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 26,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [212461] = {
            [npcKeys.name] = "Phantasmal Servant",
            [npcKeys.minLevel] = 26,
            [npcKeys.maxLevel] = 26,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [212462] = {
            [npcKeys.name] = "Phantasmal Softshell",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [212463] = {
            [npcKeys.name] = "Phantasmal Snapjaw",
            [npcKeys.minLevel] = 26,
            [npcKeys.maxLevel] = 27,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [212468] = {
            [npcKeys.name] = "Invading Nightmare",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [212598] = {
            [npcKeys.name] = "Recke Grinnes",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 130,
            [npcKeys.spawns] = {
                [130] = {{66.2, 31},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [212667] = {
            [npcKeys.name] = "Fettered Elemental",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [212674] = {
            [npcKeys.name] = "Death's Head Shaman",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [212678] = {
            [npcKeys.name] = "Earth Elemental",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [212692] = {
            [npcKeys.name] = "Bound Elemental",
            [npcKeys.minLevel] = 21,
            [npcKeys.maxLevel] = 21,
            [npcKeys.zoneID] = 17,
            [npcKeys.spawns] = {
                [17] = {{42.2, 80.8},{43, 78.6},{43.2, 78.4},{43.6, 78.4},{43.6, 78.6},{44, 91.2},{44.2, 80.2},{44.8, 76.8},{45, 79.6},{45.2, 63.8},{45.2, 74.2},{45.8, 80.4},{46, 69},{47.6, 81.6},{47.8, 83.8},},
                [400] = {{31.6, 23.4},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [212694] = {
            [npcKeys.name] = "Hirzek",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 17,
            [npcKeys.spawns] = {
                [17] = {{43, 78.4},{43.2, 78.6},{43.6, 78.4},{43.6, 78.8},{44.2, 91},{46, 74.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [212699] = {
            [npcKeys.name] = "Silverwing Archer",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{25.8, 27.2},{26.4, 28},{27.4, 27.4},{27.4, 27.6},{28, 26.4},{28.2, 27.4},{28.2, 29.6},{28.4, 28.2},{28.4, 28.8},{28.6, 28.4},{28.6, 28.8},{28.6, 29.6},{28.8, 26.4},{29.2, 27.4},{50.4, 54.4},{50.4, 55.4},{50.4, 55.8},{51.2, 55.8},{51.2, 56.6},{51.4, 54.4},{51.4, 54.8},{51.6, 54.4},{51.6, 54.6},{51.6, 55.6},{51.6, 57},{52.6, 54.2},{53, 54.6},{58.2, 72.2},{59.2, 72.6},{59.4, 68.6},{59.4, 72},{59.4, 74},{59.6, 68.6},{59.8, 70.2},{59.8, 71.6},{60, 71.4},{60, 72.6},{60.6, 71},{60.8, 71.6},{71.2, 72.8},{72, 69.2},{72.2, 70.6},{72.4, 72.4},{72.4, 73.4},{72.4, 73.6},{72.8, 72.4},{73, 73.2},{73.2, 74.6},{73.4, 73.6},{73.6, 72.8},{73.8, 73.8},{74, 74.8},},
            },
            [npcKeys.friendlyToFaction] = "A",
        },
        [212703] = {
            [npcKeys.name] = "Silverwing Dryad",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{27.2, 27.6},{28.2, 28.6},{28.4, 27.4},{28.4, 28.2},{28.6, 26.4},{28.6, 28.2},{28.8, 27},{28.8, 29},{29, 29.8},{29.6, 29},{51, 56.6},{51.2, 55.4},{51.2, 55.6},{51.4, 54.4},{51.6, 54.4},{51.6, 55.6},{51.8, 55},{51.8, 56.6},{52.6, 58},{52.8, 54.4},{53.2, 54.8},{58.4, 72.2},{59.2, 72.8},{59.4, 68.6},{59.4, 72.4},{59.8, 72.4},{60, 71},{60, 72.6},{60.2, 70.2},{60.6, 71},{61.2, 72.2},{69.8, 70.6},{72.2, 72.4},{72.4, 72.8},{72.8, 72.4},{73, 73.2},{73.2, 73.6},{74, 73.4},{74, 74},},
            },
            [npcKeys.friendlyToFaction] = "A",
        },
        [212706] = {
            [npcKeys.name] = "Silverwing Druid",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{27, 27.8},{27.4, 26.8},{28, 26.4},{28.2, 27.4},{28.4, 28.4},{28.4, 28.6},{28.6, 26.2},{28.6, 28.2},{28.6, 28.8},{28.8, 27},{30.2, 25.8},{50.4, 55.8},{50.8, 57.6},{51.2, 56.2},{51.2, 56.8},{51.4, 54.4},{51.4, 54.6},{51.6, 54.2},{51.6, 54.8},{51.6, 55.6},{53, 54.8},{59, 72.8},{59.2, 72},{59.2, 73.6},{59.6, 68.6},{59.8, 71.8},{60, 70.4},{60, 70.8},{60, 72.6},{60.6, 71.2},{60.8, 70},{61, 71.6},{71.2, 68.2},{72.4, 66.6},{72.4, 71.4},{72.4, 72},{72.4, 73},{72.6, 70.6},{72.8, 72.4},{72.8, 72.8},{73.2, 73.6},{74, 73.4},{74, 74.2},{74.6, 74},},
            },
            [npcKeys.friendlyToFaction] = "A",
        },
        [212707] = {
            [npcKeys.name] = "Larodar",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{46, 56},{50.4, 51.2},{50.4, 54.4},{50.4, 54.8},{51.2, 55.6},{51.2, 56.8},{51.4, 54.4},{51.4, 54.6},{51.4, 57.8},{51.6, 53.2},{51.6, 54.2},{51.6, 54.8},{51.6, 55.6},{51.6, 56.6},{52.4, 58.2},{52.6, 54.6},{52.8, 58.4},{53, 54.4},{53.4, 58.8},{53.8, 59},{54.2, 54.6},{55.2, 55.4},{55.2, 59.8},{56.2, 54.8},{56.2, 55.6},},
            },
            [npcKeys.friendlyToFaction] = "A",
        },
        [212727] = {
            [npcKeys.name] = "Warsong Grunt",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{20, 37.6},{20.2, 35.6},{20.4, 36.8},{21.2, 38},{21.4, 36.4},{21.4, 37},{21.4, 38.8},{21.6, 36.4},{21.6, 37},{21.6, 40.2},{22, 35.4},{22, 37.8},{22.2, 38.8},{22.6, 35.6},{22.8, 34.8},{23.2, 38.2},{37.4, 67.6},{38.2, 67.8},{38.4, 67.2},{38.4, 68.6},{38.6, 66.8},{38.6, 68.6},{39, 66.4},{39, 67.6},{39.4, 65.2},{39.6, 66.4},{39.6, 66.6},{39.8, 65},{39.8, 67.6},{39.8, 69.6},{40, 69.4},{41.2, 65.8},{41.2, 67},{52, 54.4},{52.4, 54.6},{53, 54.6},{53.2, 54.4},{54, 53.4},{54, 54.6},{54.2, 54.4},{54.8, 55},{55, 54.2},{55.4, 55.6},{55.6, 55.4},{56, 55.6},{57, 56},{67.6, 62.2},{68.4, 63.4},{69.4, 62.4},{69.4, 63},{69.4, 63.6},{69.6, 63},{69.8, 63.6},{70.2, 62.2},{70.6, 63.2},},
            },
            [npcKeys.friendlyToFaction] = "H",
        },
        [212728] = {
            [npcKeys.name] = "Warsong Raider",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{20, 37.4},{20.4, 35.6},{21, 38.6},{21.2, 36.4},{21.4, 36.6},{21.4, 37.8},{21.6, 36.4},{21.6, 38.6},{21.8, 37.4},{22, 35.4},{22, 37.8},{22.6, 38},{22.8, 35.2},{37, 68},{38.4, 67.2},{38.4, 67.8},{38.8, 69},{39, 66.4},{39, 66.8},{39, 67.8},{39.4, 65.2},{39.6, 64.8},{39.6, 66.4},{39.6, 66.6},{40, 67.8},{40.6, 66.2},{41.6, 65.4},{51.4, 54.4},{51.4, 54.6},{51.8, 54.6},{52, 53.8},{52.6, 54.4},{53, 54.6},{53.6, 54.6},{53.8, 54.4},{54.2, 53.2},{54.4, 55.6},{54.6, 54},{55.2, 53.2},{55.4, 55.2},{55.4, 55.6},{55.6, 55.2},{55.8, 55.6},{67.8, 62.4},{68.4, 63.6},{68.6, 63.6},{69.4, 63},{69.6, 63},{69.8, 63.6},{70.4, 62.4},{70.6, 62.4},{70.6, 62.8},{71.2, 63.8},},
            },
            [npcKeys.friendlyToFaction] = "H",
        },
        [212729] = {
            [npcKeys.name] = "Warsong Shaman",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{20.2, 36.8},{20.4, 36.2},{20.4, 37.6},{21.2, 36.4},{21.2, 36.6},{21.4, 38},{21.6, 36.4},{21.6, 38.6},{21.8, 37.4},{21.8, 37.6},{38.2, 67.8},{38.4, 67.2},{38.8, 66.4},{39, 67.4},{39, 68},{39, 68.8},{39.6, 66.2},{39.6, 67.2},{39.6, 67.6},{39.8, 65.4},{51.8, 54.4},{52.2, 54.6},{53, 54.4},{53, 54.6},{53.6, 54.2},{53.6, 54.6},{54.4, 53.4},{54.6, 53.8},{54.6, 55.6},{54.8, 55.2},{55.6, 55},{68.4, 62.6},{69.2, 63.6},{69.4, 62.8},{69.6, 62.8},{69.6, 63.6},{70, 62},{70.6, 63.6},{70.8, 62.4},{70.8, 63.2},},
            },
            [npcKeys.friendlyToFaction] = "H",
        },
        [212730] = {
            [npcKeys.name] = "Tojara",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{50.2, 54.2},{50.4, 54.6},{51, 53.2},{51, 55.6},{51.4, 54.2},{51.4, 55},{51.6, 53.8},{51.6, 54.6},{52.2, 53.2},{53, 54.4},{53.4, 54.6},{53.8, 54.4},{53.8, 54.6},{54.2, 52.2},{54.2, 53.2},{54.6, 53.4},{54.8, 54.4},{54.8, 54.8},{55, 55.6},{55.8, 55.4},{55.8, 55.8},{57.4, 55.8},},
            },
            [npcKeys.friendlyToFaction] = "H",
        },
        [212753] = {
            [npcKeys.name] = "Tortured Soul",
            [npcKeys.minLevel] = 20,
            [npcKeys.maxLevel] = 20,
            [npcKeys.zoneID] = 17,
            [npcKeys.spawns] = {
                [17] = {{45, 58.6},},
                [44] = {{76.4, 84.2},},
                [130] = {{44.2, 40.2},{44.4, 42},{44.8, 42.4},{45, 40.6},{46, 39.6},{46.4, 83.8},{49, 38.2},{53.8, 71.6},{56.8, 70.6},{57.6, 71.4},{58, 71.8},{59.4, 70.4},{59.4, 70.8},{59.8, 75.4},{60.4, 72.4},{60.4, 73.6},{65.8, 80},},
                [1497] = {{66.8, 43.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [212763] = {
            [npcKeys.name] = "Sadistic Fiend",
            [npcKeys.minLevel] = 19,
            [npcKeys.maxLevel] = 19,
            [npcKeys.zoneID] = 130,
            [npcKeys.spawns] = {
                [130] = {{58.2, 45.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [212801] = {
            [npcKeys.name] = "Jubei",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{20.4, 36.4},{20.4, 37},{21.2, 38.6},{21.4, 36.4},{21.4, 37.2},{21.4, 38.2},{21.6, 37.4},{21.6, 37.6},{21.8, 36.4},{22, 38.6},{22.6, 38.4},},
            },
            [npcKeys.friendlyToFaction] = "H",
        },
        [212802] = {
            [npcKeys.name] = "Moogul the Sly",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{68.4, 63.2},{68.4, 63.8},{68.6, 65},{69, 63.6},{69.4, 63},{69.6, 63},{69.6, 63.6},{70, 62.4},{70.8, 62.8},{71.4, 63.6},},
            },
            [npcKeys.friendlyToFaction] = "H",
        },
        [212803] = {
            [npcKeys.name] = "Ceredwyn",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{72.4, 72.2},{72.4, 73},{72.6, 72.4},{73, 73.2},{73.2, 73.6},{73.4, 74.6},{74, 73.4},{74, 74},{74, 74.6},{74.6, 73.4},{74.6, 74},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [212804] = {
            [npcKeys.name] = "Centrius",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{27.2, 26.4},{27.4, 26.8},{27.4, 27.8},{28, 26.4},{28.2, 27.4},{28.4, 28.4},{28.4, 28.8},{28.4, 29.6},{28.6, 28.4},{28.6, 28.8},{28.6, 29.8},{28.8, 26.2},{29, 27.4},},
            },
            [npcKeys.friendlyToFaction] = "A",
        },
        [212809] = {
            [npcKeys.name] = "Wailing Spirit",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 130,
            [npcKeys.spawns] = {
                [130] = {{57.2, 70.4},{57.4, 71},{57.6, 71},{58, 71.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [212837] = {
            [npcKeys.name] = "Primordial Anomaly",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 406,
            [npcKeys.spawns] = {
                [406] = {{27, 64},{27.6, 63},{27.8, 64.4},{28.4, 64.8},{28.4, 65.6},{28.4, 72.2},{28.6, 62},{28.6, 66},{28.6, 71.2},{28.8, 65.2},{29, 73},{29, 73.8},{29.2, 71.8},{29.6, 63.6},{29.6, 72},{32.6, 67.6},{33, 68.8},{33, 70},{33.2, 66.6},{33.6, 69.2},{33.8, 70},{35, 72.2},{36.4, 72.6},{36.6, 73},{37, 72.2},{37.4, 71.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [212969] = {
            [npcKeys.name] = "Kazragore",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{37.4, 66.6},{38.2, 68},{38.4, 66.8},{38.4, 68.6},{38.8, 66.4},{39, 67.4},{39, 68.6},{39.2, 67.8},{39.6, 66.6},{39.6, 67.6},{39.8, 65.4},{39.8, 66.2},{39.8, 69.4},{39.8, 69.6},{40.6, 66.4},},
            },
            [npcKeys.friendlyToFaction] = "H",
        },
        [212970] = {
            [npcKeys.name] = "Felore Moonray",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{59.2, 70.4},{59.2, 71},{59.4, 72},{59.4, 72.6},{59.4, 73.8},{59.4, 75.2},{59.6, 73.8},{60, 70.2},{60, 71.4},{60, 72},{60, 72.6},{60, 75.2},{60.6, 70.6},},
            },
            [npcKeys.friendlyToFaction] = "A",
        },
        [213077] = {
            [npcKeys.name] = "Elaine Compton",
            [npcKeys.minLevel] = 30,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 1519,
            [npcKeys.spawns] = {
                [1519] = {{54.4, 60.2},{54.4, 60.8},{54.6, 61.2},{54.8, 62},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [213334] = {
            [npcKeys.name] = "Aku'mai",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [213444] = {
            [npcKeys.name] = "Mysterious Traveler",
            [npcKeys.minLevel] = 30,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{79, 80.2},},
            },
            [npcKeys.friendlyToFaction] = "AH",
        },
        [213445] = {
            [npcKeys.name] = "Raszel Ander",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 17,
            [npcKeys.spawns] = {
                [17] = {{49.2, 57.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [213451] = {
            [npcKeys.name] = "Cleansing Elemental",
            [npcKeys.minLevel] = 27,
            [npcKeys.maxLevel] = 27,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [213452] = {
            [npcKeys.name] = "Corrosion Elemental",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [213540] = {
            [npcKeys.name] = "Mysterious Traveler",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 17,
            [npcKeys.spawns] = {
                [17] = {{49.2, 57.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [213595] = {
            [npcKeys.name] = "Void Elemental",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [213659] = {
            [npcKeys.name] = "Dark Ritual Portal",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [213708] = {
            [npcKeys.name] = "Legion Hound",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{79, 80.4},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [213709] = {
            [npcKeys.name] = "Mannoroc Lasher",
            [npcKeys.minLevel] = 24,
            [npcKeys.maxLevel] = 24,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{79, 80.4},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [213710] = {
            [npcKeys.name] = "Felguard",
            [npcKeys.minLevel] = 24,
            [npcKeys.maxLevel] = 24,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{79, 80.4},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [213711] = {
            [npcKeys.name] = "Searing Infernal",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{79, 80.4},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [213994] = {
            [npcKeys.name] = "Corrosive Droplet",
            [npcKeys.minLevel] = 26,
            [npcKeys.maxLevel] = 26,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [214000] = {
            [npcKeys.name] = "Corrosive Pool Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [214070] = {
            [npcKeys.name] = "Jornah",
            [npcKeys.minLevel] = 30,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 1637,
            [npcKeys.spawns] = {
                [1637] = {{51.4, 63.8},{51.6, 63.8},{51.6, 64.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [214096] = {
            [npcKeys.name] = "Dokimi",
            [npcKeys.minLevel] = 30,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 1638,
            [npcKeys.spawns] = {
                [1638] = {{39.4, 53.4},{39.4, 53.6},{39.6, 53.4},{39.6, 53.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [214098] = {
            [npcKeys.name] = "Gishah",
            [npcKeys.minLevel] = 30,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 1497,
            [npcKeys.spawns] = {
                [1497] = {{63.8, 37.2},{64, 39.2},{64.4, 38.4},{64.8, 38.2},{65.4, 38.8},{65.6, 38.4},{65.6, 38.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [214099] = {
            [npcKeys.name] = "Tamelyn Aldridge",
            [npcKeys.minLevel] = 30,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 1537,
            [npcKeys.spawns] = {
                [1537] = {{24, 65.8},{24.4, 67.4},{24.4, 67.6},{24.6, 67.4},{24.6, 67.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [214101] = {
            [npcKeys.name] = "Marcy Baker",
            [npcKeys.minLevel] = 30,
            [npcKeys.maxLevel] = 30,
            [npcKeys.zoneID] = 1657,
            [npcKeys.spawns] = {
                [1657] = {{59.2, 56.6},{59.4, 56},{59.8, 56.4},{59.8, 56.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [214129] = {
            [npcKeys.name] = "Venture Co. Light Shredder",
            [npcKeys.minLevel] = 20,
            [npcKeys.maxLevel] = 21,
            [npcKeys.zoneID] = 406,
            [npcKeys.spawns] = {
                [406] = {{59, 53.8},{59.2, 54.6},{59.4, 51},{59.8, 51.4},{59.8, 51.6},{60, 53.4},{60, 54.4},{60, 55},{60.2, 50.4},{60.2, 55.6},{60.6, 51},{60.6, 55.2},{61.4, 52.4},{61.4, 52.8},{62, 53},{62, 53.8},{62.2, 52.2},{62.4, 55.2},{62.6, 52},{62.6, 52.8},{65.8, 46.4},{65.8, 57.8},{66.4, 46.6},{66.4, 47.6},{66.6, 47.4},{66.6, 47.6},{66.6, 54.8},{67.2, 58},{67.4, 57.4},{67.6, 57.4},{67.6, 57.8},{68.2, 47.6},{68.4, 47.4},{68.4, 48.6},{68.6, 47.8},{68.6, 54.4},{68.6, 57.8},{68.8, 48.6},{68.8, 57.4},{69, 47.2},{69.2, 49.8},{69.4, 55.2},{69.8, 47.6},{70, 55.8},{70.2, 49.6},{70.2, 54.2},{70.2, 55.2},{70.4, 40.8},{70.4, 41.8},{70.4, 42.8},{70.4, 48.6},{70.6, 41.4},{70.6, 42.6},{70.6, 55},{70.8, 42},{70.8, 48.2},{70.8, 49.2},{70.8, 49.6},{70.8, 55.8},{71, 50.8},{71.8, 52},{72.2, 50.2},{72.4, 53},{72.4, 53.6},{72.6, 53},{72.8, 52.4},{72.8, 53.6},{73, 44.8},{73, 51.4},{73.2, 55.6},{74.8, 52.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [214133] = {
            [npcKeys.name] = "Breath Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [214190] = {
            [npcKeys.name] = "Blackfathom Pearl",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [214208] = {
            [npcKeys.name] = "N'ora Anyheart",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 17,
            [npcKeys.spawns] = {
                [17] = {{62, 39.4},},
            },
            [npcKeys.friendlyToFaction] = "AH",
        },
        [214212] = {
            [npcKeys.name] = "Shadowy Figure",
            [npcKeys.minLevel] = 63,
            [npcKeys.maxLevel] = 63,
            [npcKeys.zoneID] = 36,
            [npcKeys.spawns] = {
                [36] = {{88.4, 73.4},{88.4, 73.6},{88.6, 73.4},{88.6, 73.6},},
            },
            [npcKeys.friendlyToFaction] = "AH",
        },
        [214254] = {
            [npcKeys.name] = "Pool of Shadow Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [214440] = {
            [npcKeys.name] = "Demolition Explosives",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [214456] = {
            [npcKeys.name] = "Dro'zem the Blasphemous",
            [npcKeys.minLevel] = 23,
            [npcKeys.maxLevel] = 23,
            [npcKeys.zoneID] = 44,
            [npcKeys.spawns] = {
                [44] = {{32.6, 6.8},{33.4, 7.8},{34.4, 6.8},{34.4, 7.6},{34.8, 7.6},{35, 7.2},{35.2, 8.8},{35.6, 8.2},{35.8, 6.8},{36.6, 7.6},{38.6, 13.8},{39.6, 14.4},{57.4, 41.4},{61.4, 45.2},{61.8, 41.8},{62, 44.2},{62, 44.8},{62.4, 43.4},{62.6, 42},{62.6, 44.2},{62.8, 43.4},{63.6, 42.8},{64, 42},{64.2, 45},{64.2, 45.8},{64.6, 46.6},{65, 48.4},{65.2, 42.6},{71.6, 79.2},{71.8, 80.8},{72.6, 81},{73.6, 79.6},{74.4, 81.6},{74.6, 73.6},{74.6, 76.8},{74.6, 78.6},{75.2, 73.2},{75.2, 79.8},{75.2, 82},{75.2, 82.8},{75.2, 83.6},{75.4, 77.8},{75.4, 80.6},{75.6, 79.2},{75.8, 79.6},{75.8, 82},{75.8, 83.6},{76, 77.4},{76.2, 72},{76.2, 83.4},{77, 73.8},{77.2, 79.8},{77.4, 69.4},{77.4, 71.4},{77.4, 71.6},{77.4, 75},{77.6, 70.6},{77.6, 74},{77.8, 67},{77.8, 70.2},{78, 72.4},{78.2, 63.6},{78.2, 68.2},{78.2, 69.4},{78.4, 72.8},{78.6, 68},{78.6, 69.2},{78.6, 69.6},{78.6, 70.6},{78.6, 72.2},{79.8, 70.6},{80, 70},{80.2, 67.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [214458] = {
            [npcKeys.name] = "Baron Aquanis",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [214468] = {
            [npcKeys.name] = "Ghamoo-ra",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [214469] = {
            [npcKeys.name] = "Lady Sarevess",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [214519] = {
            [npcKeys.name] = "Incinerator Gar'im",
            [npcKeys.minLevel] = 23,
            [npcKeys.maxLevel] = 23,
            [npcKeys.zoneID] = 44,
            [npcKeys.spawns] = {
                [44] = {{74, 82.2},{74.6, 83.4},{75.2, 84.4},{76.4, 83.4},{76.4, 84},{76.6, 83},{76.6, 84.4},{76.8, 82.2},{77.2, 76.4},{77.4, 85.4},{77.4, 85.8},{77.6, 85.8},{77.6, 86.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [214523] = {
            [npcKeys.name] = "Blackfathom Elite",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [214524] = {
            [npcKeys.name] = "Gelihast",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [214525] = {
            [npcKeys.name] = "Lorgus Jett",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [214526] = {
            [npcKeys.name] = "Twilight Lord Kelris",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [214527] = {
            [npcKeys.name] = "Aku'mai",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [214528] = {
            [npcKeys.name] = "Boss Dummy",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [214529] = {
            [npcKeys.name] = "Brave Stonetorch",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 267,
            [npcKeys.spawns] = {
                [267] = {{66, 19.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [214530] = {
            [npcKeys.name] = "Ardelle Dralta",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 267,
            [npcKeys.spawns] = {
                [267] = {{51, 58.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [214603] = {
            [npcKeys.name] = "Blackfathom Tide Priestess",
            [npcKeys.minLevel] = 26,
            [npcKeys.maxLevel] = 26,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [214612] = {
            [npcKeys.name] = "Aku'mai Fisher",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [214658] = {
            [npcKeys.name] = "Ashenvale Arcane Shard Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [214695] = {
            [npcKeys.name] = "Peon",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [214830] = {
            [npcKeys.name] = "Wisp",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [214837] = {
            [npcKeys.name] = "Cheddar",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [214876] = {
            [npcKeys.name] = "Davius Voidstar",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 148,
            [npcKeys.spawns] = {
                [148] = {{36.8, 43.4},{36.8, 43.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [214914] = {
            [npcKeys.name] = "Blackfathom Pearl",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [214954] = {
            [npcKeys.name] = "Rix Xizzix",
            [npcKeys.minLevel] = 45,
            [npcKeys.maxLevel] = 45,
            [npcKeys.zoneID] = 33,
            [npcKeys.spawns] = {
                [33] = {{28.4, 75.6},},
            },
            [npcKeys.friendlyToFaction] = "AH",
        },
        [215062] = {
            [npcKeys.name] = "Supplicant",
            [npcKeys.minLevel] = 5,
            [npcKeys.maxLevel] = 5,
            [npcKeys.zoneID] = 1519,
            [npcKeys.spawns] = {
                [1519] = {{39.2, 29.6},{39.4, 28.4},{39.4, 29},{39.6, 28.4},{39.6, 29.2},{40, 29.6},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [215068] = {
            [npcKeys.name] = "[DNT] Kill Credit - Priest - Meditation Sharing Tutorial",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [215072] = {
            [npcKeys.name] = "Loa Altar",
            [npcKeys.minLevel] = 1,
            [npcKeys.maxLevel] = 1,
            [npcKeys.zoneID] = 36,
            [npcKeys.spawns] = {
                [36] = {{79.8, 66.8},{80, 67.8},},
                [331] = {{11.8, 35.4},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [215081] = {
            [npcKeys.name] = "Bat Loa",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 36,
            [npcKeys.spawns] = {
                [36] = {{79.8, 67},},
                [331] = {{11.8, 35.4},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [215095] = {
            [npcKeys.name] = "Supplicant",
            [npcKeys.minLevel] = 5,
            [npcKeys.maxLevel] = 5,
            [npcKeys.zoneID] = 1657,
            [npcKeys.spawns] = {
                [1657] = {{39.4, 86.8},{39.8, 86},{40, 88.6},{40.2, 87.4},{40.4, 87.8},{40.6, 88.4},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [215096] = {
            [npcKeys.name] = "Supplicant",
            [npcKeys.minLevel] = 5,
            [npcKeys.maxLevel] = 5,
            [npcKeys.zoneID] = 1637,
            [npcKeys.spawns] = {
                [1637] = {{35.4, 86.4},{35.4, 87.6},{35.6, 87.2},{35.8, 86.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [215097] = {
            [npcKeys.name] = "Supplicant",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [215098] = {
            [npcKeys.name] = "Supplicant",
            [npcKeys.minLevel] = 5,
            [npcKeys.maxLevel] = 5,
            [npcKeys.zoneID] = 1497,
            [npcKeys.spawns] = {
                [1497] = {{48.2, 14.6},{49.4, 14.4},{49.4, 15},{49.4, 15.6},{49.6, 14.8},{49.6, 16},{50.2, 14.4},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [215108] = {
            [npcKeys.name] = "Aku'mai Snapjaw",
            [npcKeys.minLevel] = 27,
            [npcKeys.maxLevel] = 27,
            [npcKeys.zoneID] = 719,
            [npcKeys.spawns] = {
                [719] = {{-1, -1},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [215367] = {
            [npcKeys.name] = "Dawnwatcher Selgorm",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 1657,
            [npcKeys.spawns] = {
                [1657] = {{55.6, 23.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [215369] = {
            [npcKeys.name] = "Bashana Runetotem",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 1638,
            [npcKeys.spawns] = {
                [1638] = {{70, 33.6},{70.8, 32.4},{70.8, 33.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [216126] = {
            [npcKeys.name] = "Invisible Stalker",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [216620] = {
            [npcKeys.name] = "Unkillable Test Dummy",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [216659] = {
            [npcKeys.name] = "Fallenroot Satyr",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{13.4, 9.2},{13.4, 10},{13.4, 12.2},{13.4, 13.2},{13.6, 11.8},{13.6, 13.4},{13.8, 10},{13.8, 11.2},{14.4, 9.4},{14.6, 9.8},{15, 10.6},{15.6, 11.2},{16.2, 11.6},{16.6, 11},{16.6, 11.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [216660] = {
            [npcKeys.name] = "Fallenroot Rogue",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{13.2, 13},{14.4, 9.4},{14.4, 9.6},{14.6, 10},{15.2, 10.8},{15.6, 11.2},{16.2, 11.6},{16.6, 11},{16.6, 11.8},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [216661] = {
            [npcKeys.name] = "Blackfathom Tide Priestess",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{12.4, 10},{12.6, 10},{13.2, 9.4},{13.2, 12.8},{13.4, 12.2},{13.6, 11.8},{13.6, 13.2},{13.8, 10.2},{13.8, 11.2},{14, 13.8},{14.4, 9.4},{14.6, 8.4},{14.6, 8.6},{14.8, 10.2},{15, 10.6},{16, 11.4},{16.4, 11.6},{16.6, 11.6},{16.8, 11.2},{17.6, 11},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [216662] = {
            [npcKeys.name] = "Blackfathom Oracle",
            [npcKeys.minLevel] = 25,
            [npcKeys.maxLevel] = 25,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{12.4, 9.8},{12.8, 10},{13.2, 12.6},{13.4, 9.4},{13.4, 12},{13.6, 9.6},{13.6, 12},{13.6, 13.4},{13.8, 10.6},{14, 13.8},{14.2, 9.2},{14.6, 8.8},{14.6, 9.8},{15, 10.6},{15.8, 11.4},{16.4, 11.6},{16.6, 10.4},{16.6, 11},{16.6, 11.6},{17.6, 11},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [216664] = {
            [npcKeys.name] = "Sprok",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [216665] = {
            [npcKeys.name] = "Gnomeregan Evacuee",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 1,
            [npcKeys.spawns] = {
                [1] = {{24.4, 40.2},},
            },
            [npcKeys.friendlyToFaction] = nil,
        },
        [216666] = {
            [npcKeys.name] = "Techbot",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [216667] = {
            [npcKeys.name] = "Addled Leper",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [216668] = {
            [npcKeys.name] = "Irradiated Invader",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [216669] = {
            [npcKeys.name] = "Caverndeep Pillager",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [216670] = {
            [npcKeys.name] = "Caverndeep Looter",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [216671] = {
            [npcKeys.name] = "Caverndeep Invader",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [216672] = {
            [npcKeys.name] = "Namdo Bizzfizzle",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [216902] = {
            [npcKeys.name] = "Wulmort Jinglepocket",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [216915] = {
            [npcKeys.name] = "Strange Snowman",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [216924] = {
            [npcKeys.name] = "Kaymard Copperpinch",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [216931] = {
            [npcKeys.name] = "The Abominable Greench",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [216937] = {
            [npcKeys.name] = "Jubei",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [217049] = {
            [npcKeys.name] = "Mirror Image",
            [npcKeys.minLevel] = 99,
            [npcKeys.maxLevel] = 99,
            [npcKeys.zoneID] = 331,
            [npcKeys.spawns] = {
                [331] = {{20, 36.2},{20.2, 37.2},{21.2, 36.4},{21.2, 37},{21.2, 38.6},{21.4, 37.6},{21.6, 36.4},{21.6, 37.4},{21.8, 37.8},{21.8, 38.6},{25.2, 37.4},{25.4, 39.4},{26.8, 44},{50, 56.2},{50.2, 49.6},{51.4, 52.4},{51.4, 54.4},{51.4, 55},{52.4, 54.2},{52.4, 54.6},{53.2, 54.4},{53.2, 54.6},{53.8, 54},{53.8, 54.6},{54.2, 53.4},{54.4, 52.4},{54.6, 53.6},{54.6, 55},{54.6, 55.6},{55.6, 55},{55.6, 55.6},{56.4, 57.6},{64.8, 65.2},{65, 59.8},{67.4, 62.4},{68.4, 63.8},{68.6, 64.6},{68.8, 63.6},{69, 62},{69.2, 63},{69.6, 62.8},{69.8, 64.2},{70, 62},},
            },
            [npcKeys.friendlyToFaction] = "H",
        },
        [217706] = {
            [npcKeys.name] = "Kazragore",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
        [217707] = {
            [npcKeys.name] = "Felore Moonray",
            [npcKeys.minLevel] = 0,
            [npcKeys.maxLevel] = 0,
            [npcKeys.zoneID] = 0,
            [npcKeys.spawns] = nil,
            [npcKeys.friendlyToFaction] = nil,
        },
    }
end
