---@type SeasonOfDiscovery
local SeasonOfDiscovery = QuestieLoader:ImportModule("SeasonOfDiscovery")
---@type QuestieDB
local QuestieDB = QuestieLoader:ImportModule("QuestieDB")
---@type ZoneDB
local ZoneDB = QuestieLoader:ImportModule("ZoneDB")
---@type QuestieProfessions
local QuestieProfessions = QuestieLoader:ImportModule("QuestieProfessions")

function SeasonOfDiscovery:LoadQuests()
    local questKeys = QuestieDB.questKeys
    local zoneIDs = ZoneDB.zoneIDs
    local raceIDs = QuestieDB.raceKeys
    local classIDs = QuestieDB.classKeys
    local sortKeys = QuestieDB.sortKeys
    local questFlags = QuestieDB.questFlags
    local specialFlags = QuestieDB.specialFlags
    local profKeys = QuestieProfessions.professionKeys
    local specKeys = QuestieProfessions.specializationKeys

    -- TODO: reputation once data is more reliably confirmed
    -- TODO: ZoneIDs, sort keys

    return {
        [77568] = {
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{410121, nil, 206168}}},
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
            [questKeys.requiredSpell] = -410121,
        },
        [77571] = {
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{410061, nil, 208414}}},
            [questKeys.zoneOrSort] = sortKeys.DRUID,
            [questKeys.requiredSpell] = -410061,
        },
        [77574] = {
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{402862, nil, 205951}}},
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
            [questKeys.requiredSpell] = -402862,
        },
        [77585] = {
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{410094, nil, 206381}}},
            [questKeys.requiredRaces] = raceIDs.ORC,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
            [questKeys.requiredSpell] = -410094,
        },
        [77586] = {
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{403919, nil, 205230}}},
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
            [questKeys.requiredSpell] = -403919,
        },
        [77587] = {
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{410094, nil, 206381}}},
            [questKeys.requiredRaces] = raceIDs.TROLL,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
            [questKeys.requiredSpell] = -410094,
        },
        [77617] = {
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{410002, nil, 205420}}},
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
            [questKeys.requiredSpell] = -410002,
        },
        [77619] = {
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{402862, nil, 205951}}},
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
            [questKeys.requiredSpell] = -402862,
        },
        [77621] = {
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{403919, nil, 205230}}},
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
            [questKeys.requiredSpell] = -403919,
        },
        [77642] = {
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{402862, nil, 205951}}},
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
            [questKeys.requiredSpell] = -402862,
        },
        [77648] = {
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{410061, nil, 208414}}},
            [questKeys.zoneOrSort] = sortKeys.DRUID,
            [questKeys.requiredSpell] = -410061,
        },
        [77649] = {
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{410121, nil, 206168}}},
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
            [questKeys.requiredSpell] = -410121,
        },
        [77652] = {
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{410094, nil, 206381}}},
            [questKeys.requiredRaces] = raceIDs.TAUREN,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
            [questKeys.requiredSpell] = -410094,
        },
        [77661] = {
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{402862, nil, 205951}}},
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
            [questKeys.requiredSpell] = -402862,
        },
        [77666] = {
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{403919, nil, 205230}}},
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
            [questKeys.requiredSpell] = -403919,
        },
        [77670] = {
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{402862, nil, 205951}}},
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
            [questKeys.requiredSpell] = -402862,
        },
        [77672] = {
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{403919, nil, 205230}}},
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
            [questKeys.requiredSpell] = -403919,
        },
        [78089] = {
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [78090] = {
            [questKeys.preQuestSingle] = {78089},
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [78091] = {
            [questKeys.preQuestSingle] = {78090},
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [78092] = {
            [questKeys.preQuestSingle] = {78091},
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [78093] = {
            [questKeys.preQuestSingle] = {78092},
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [78124] = {
            [questKeys.questLevel] = -1,
            [questKeys.requiredSpell] = -425170,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [78127] = {
            [questKeys.questLevel] = 20,
            [questKeys.requiredSpell] = -425170,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [78142] = {
            [questKeys.questLevel] = -1,
            [questKeys.requiredSpell] = -425170,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [78143] = {
            [questKeys.questLevel] = -1,
            [questKeys.requiredSpell] = -425170,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [78145] = {
            [questKeys.questLevel] = -1,
            [questKeys.requiredSpell] = -425170,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [78146] = {
            [questKeys.questLevel] = -1,
            [questKeys.requiredSpell] = -425170,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [78147] = {
            [questKeys.questLevel] = -1,
            [questKeys.requiredSpell] = -425170,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [78148] = {
            [questKeys.name] = "Runes of the Sorcerer-Kings",
            [questKeys.questLevel] = -1,
            [questKeys.requiredSpell] = -425170,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [78149] = {
            [questKeys.questLevel] = -1,
            [questKeys.requiredSpell] = -425170,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [78265] = {
            [questKeys.objectivesText] = {"Bring 24 Fish Oil to Grizzby."},
        },
        [78266] = {
            [questKeys.objectivesText] = {"Bring 20 Dark Iron Ordinance to Grizzby."},
        },
        [78267] = {
            [questKeys.objectivesText] = {"Bring 16 Shredder Turbocharger to Grizzby."},
        },
        [78277] = {
            [questKeys.objectivesText] = {"Complete the quest chain starting with Resting in Pieces to receive the Living Bomb rune."},
            [questKeys.requiredSpell] = -415936,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [78611] = {
            [questKeys.startedBy] = {{213077,214070,214096,214098,214099,214101,}},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [78612] = {
            [questKeys.startedBy] = {{213077,214070,214096,214098,214099,214101,}},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [78680] = {
            [questKeys.name] = "Rumors Abound",
            [questKeys.startedBy] = {{6247}},
            [questKeys.finishedBy] = {{6247}},
            [questKeys.requiredLevel] = 20,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
            [questKeys.objectives] = {nil,nil,{{210765},{210763}}},
            [questKeys.objectivesText] = {"Not much is known about the location of these shattered weapon fragments, save that they are both in the possession of once great mages held up in towers of importance. One is said to be located here to the north on Kalimdor, while the other is nestled near the heart of the Eastern Kingdoms.\n\nSee if the rumors are true... Search for the two missing halves of this weapon and bring them to me."},
            [questKeys.questFlags] = 1,
            [questKeys.preQuestSingle] = {1740},
        },
        [78681] = {
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
            [questKeys.questFlags] = 1,
            [questKeys.preQuestSingle] = {78680},
        },
        [78684] = {
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
            [questKeys.questFlags] = 1,
            [questKeys.preQuestSingle] = {78681},
        },
        [78702] = {
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
            [questKeys.preQuestSingle] = {78684},
        },
        [78872] = {
            [questKeys.startedBy] = {{213077,214070,214096,214098,214099,214101,}},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [78916] = { -- The Heart of the Void
            [questKeys.startedBy] = {nil, nil, {209693}},
            [questKeys.finishedBy] = {{4783}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.sourceItemId] = 209693,
            [questKeys.zoneOrSort] = zoneIDs.BLACKFATHOM_DEEPS,
        },
        [78917] = { -- The Heart of the Void
            [questKeys.startedBy] = {nil, nil, {211452}},
            [questKeys.finishedBy] = {{9087}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.sourceItemId] = 211452,
            [questKeys.zoneOrSort] = zoneIDs.BLACKFATHOM_DEEPS,
        },
        [78920] = { -- Baron Aquanis
            [questKeys.startedBy] = {nil, nil, {211454}},
            [questKeys.finishedBy] = {{12736}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.zoneOrSort] = zoneIDs.ASHENVALE,
            [questKeys.questFlags] = 62,
        },
        [78921] = { -- Blackfathom Villainy
            [questKeys.startedBy] = {{4787}},
            [questKeys.finishedBy] = {{4783}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectives] = {nil,nil,{{5881}}},
            [questKeys.zoneOrSort] = zoneIDs.BLACKFATHOM_DEEPS,
            [questKeys.questFlags] = 62,
        },
        [78922] = { -- Blackfathom Villainy
            [questKeys.startedBy] = {{4787}},
            [questKeys.finishedBy] = {{9087}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectives] = {nil,nil,{{5881}}},
            [questKeys.zoneOrSort] = zoneIDs.BLACKFATHOM_DEEPS,
            [questKeys.questFlags] = 62,
        },
        [78923] = { -- Knowledge in the Deeps
            [questKeys.startedBy] = {{2786}},
            [questKeys.finishedBy] = {{2786}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectives] = {nil,nil,{{5359}}},
            [questKeys.zoneOrSort] = zoneIDs.BLACKFATHOM_DEEPS,
            [questKeys.questFlags] = 62,
        },
        [78925] = { -- Twilight Falls
            [questKeys.startedBy] = {{4784}},
            [questKeys.finishedBy] = {{4784}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectives] = {nil,nil,{{5879}}},
            [questKeys.zoneOrSort] = zoneIDs.BLACKFATHOM_DEEPS,
            [questKeys.questFlags] = 62,
        },
        [78926] = { -- Researching the Corruption
            [questKeys.startedBy] = {{8997}},
            [questKeys.finishedBy] = {{8997}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectives] = {nil,nil,{{5952}}},
            [questKeys.zoneOrSort] = zoneIDs.BLACKFATHOM_DEEPS,
            [questKeys.questFlags] = 62,
        },
        [78927] = { -- Allegiance to the Old Gods
            [questKeys.startedBy] = {{12736}},
            [questKeys.finishedBy] = {{12736}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectives] = {{{207356}},nil,nil},
            [questKeys.zoneOrSort] = zoneIDs.BLACKFATHOM_DEEPS,
            [questKeys.questFlags] = 62,
        },
        [79090] = {
            [questKeys.startedBy] = {{212727,212728,212729,212730,212801,212802}},
            [questKeys.finishedBy] = {{212970,217707}},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.WEEKLY,
            [questKeys.zoneOrSort] = zoneIDs.ASHENVALE,
        },
        [79091] = {
            [questKeys.startedBy] = {{211033},{386691}},
            [questKeys.questLevel] = -1,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'Archmage Antonidas: The Unabridged Autobiography'and bring it to Garion Wendell in Stormwind. After ten book turnins you will receive the Icy Veins rune."},
            [questKeys.requiredSpell] = -425170,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [79092] = {
            [questKeys.startedBy] = {{211033},{386759}},
            [questKeys.questLevel] = -1,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'Azora Apprentice Notes: Page 1'and bring it to Garion Wendell in Stormwind. After ten book turnins you will receive the Icy Veins rune."},
            [questKeys.requiredSpell] = -425170,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [79093] = {
            [questKeys.startedBy] = {{211033},{408014}},
            [questKeys.questLevel] = -1,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'Rumi of Gnomeregan: The Collected Works'and bring it to Garion Wendell in Stormwind. After ten book turnins you will receive the Icy Veins rune."},
            [questKeys.requiredSpell] = -425170,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [79094] = {
            [questKeys.startedBy] = {{211022},{450001}},
            [questKeys.questLevel] = -1,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'The Lessons of Ta'zo'and bring it to Owen Thadd in Undercity. After ten book turnins you will receive the Icy Veins rune."},
            [questKeys.requiredSpell] = -425170,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [79095] = {
            [questKeys.startedBy] = {{211022},{405879}},
            [questKeys.questLevel] = -1,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'The Apothecary's Metaphysical Primer'and bring it to Owen Thadd in Undercity. After ten book turnins you will receive the Icy Veins rune."},
            [questKeys.requiredSpell] = -425170,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [79096] = {
            [questKeys.startedBy] = {{211022},{409700}},
            [questKeys.questLevel] = -1,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'Arcanic Systems Manual'and bring it to Owen Thadd in Undercity. After ten book turnins you will receive the Icy Veins rune."},
            [questKeys.requiredSpell] = -425170,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [79097] = {
            [questKeys.questLevel] = -1,
            [questKeys.requiredSpell] = -425170,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [79098] = {
            [questKeys.startedBy] = {{212699,212703,212706,212707,212803,212804}},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.WEEKLY,
            [questKeys.zoneOrSort] = zoneIDs.ASHENVALE,
        },
        [79099] = { -- Baron Aquanis
            [questKeys.startedBy] = {{214876}},
            [questKeys.finishedBy] = {{214876}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectives] = {nil,nil,{{211818}}},
            [questKeys.zoneOrSort] = zoneIDs.AUBERDINE,
            [questKeys.questFlags] = 62,
        },
        [79100] = {
            [questKeys.startedBy] = {{213077,214070,214096,214098,214099,214101,}},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [79101] = {
            [questKeys.startedBy] = {{213077,214070,214096,214098,214099,214101,}},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [79102] = {
            [questKeys.startedBy] = {{213077,214070,214096,214098,214099,214101,}},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [79103] = {
            [questKeys.startedBy] = {{213077,214070,214096,214098,214099,214101,}},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [79482] = {
            [questKeys.startedBy] = {{216902}},
            [questKeys.finishedBy] = {{216915}},
            [questKeys.questFlags] = questFlags.RAID,
            [questKeys.zoneOrSort] = sortKeys.SEASONAL,
        },
        [79483] = {
            [questKeys.startedBy] = {{216924}},
            [questKeys.finishedBy] = {{216915}},
            [questKeys.questFlags] = questFlags.RAID,
            [questKeys.zoneOrSort] = sortKeys.SEASONAL,
        },
        [79484] = {
            [questKeys.startedBy] = {{216915}},
            [questKeys.finishedBy] = {{216902}},
            [questKeys.objectives] = {nil,nil,{{17662}}},
            [questKeys.preQuestSingle] = {79482},
            [questKeys.questFlags] = questFlags.RAID,
            [questKeys.zoneOrSort] = sortKeys.SEASONAL,
        },
        [79485] = {
            [questKeys.startedBy] = {{216915}},
            [questKeys.finishedBy] = {{216924}},
            [questKeys.objectives] = {nil,nil,{{17662}}},
            [questKeys.preQuestSingle] = {79483},
            [questKeys.questFlags] = questFlags.RAID,
            [questKeys.zoneOrSort] = sortKeys.SEASONAL,
        },
        [79486] = {
            [questKeys.questFlags] = questFlags.RAID,
            [questKeys.zoneOrSort] = sortKeys.SEASONAL,
        },
        [79487] = {
            [questKeys.questFlags] = questFlags.RAID,
            [questKeys.zoneOrSort] = sortKeys.SEASONAL,
        },
        [79492] = {
            [questKeys.startedBy] = {{216902}},
            [questKeys.finishedBy] = {{216902}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectives] = {{{15664,"Find Metzen the Reindeer and rescue him"}},nil,{{21211}}},
            [questKeys.questFlags] = questFlags.RAID,
            [questKeys.zoneOrSort] = sortKeys.SEASONAL,
        },
        [79495] = {
            [questKeys.startedBy] = {{216924}},
            [questKeys.finishedBy] = {{216924}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectives] = {{{15664,"Find Metzen the Reindeer and rescue him"}},nil,{{21211}}},
            [questKeys.questFlags] = questFlags.RAID,
            [questKeys.zoneOrSort] = sortKeys.SEASONAL,
        },
        [79588] = {
            [questKeys.zoneOrSort] = sortKeys.DARKMOON_FAIRE,
        },
        [79589] = {
            [questKeys.zoneOrSort] = sortKeys.DARKMOON_FAIRE,
        },
        [79590] = {
            [questKeys.startedBy] = {{14832}},
            [questKeys.finishedBy] = {{14832}},
            [questKeys.zoneOrSort] = sortKeys.DARKMOON_FAIRE,
        },
        [79591] = {
            [questKeys.zoneOrSort] = sortKeys.DARKMOON_FAIRE,
        },
        [79592] = {
            [questKeys.zoneOrSort] = sortKeys.DARKMOON_FAIRE,
        },
        [79593] = {
            [questKeys.zoneOrSort] = sortKeys.DARKMOON_FAIRE,
        },
        [79594] = {
            [questKeys.zoneOrSort] = sortKeys.DARKMOON_FAIRE,
        },
        [79595] = {
            [questKeys.zoneOrSort] = sortKeys.DARKMOON_FAIRE,
        },

        --- Fake rune quests
        [90000] = {
            [questKeys.name] = "Arcane Blast",
            [questKeys.startedBy] = {nil,{450000}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Cast Arcane Explosion in the correct order next to the Arcane Shard. South to North."},
            [questKeys.requiredSpell] = -401757,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90001] = {
            [questKeys.name] = "Burnout",
            [questKeys.startedBy] = {{208752}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 9,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Gather some Mage and Warlock friends and attack the Frozen Trogg with fire spells."},
            [questKeys.requiredSpell] = -401759,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90002] = {
            [questKeys.name] = "Burnout",
            [questKeys.startedBy] = {{202060}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 9,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Gather some Mage and Warlock friends and attack the Frozen Murloc with fire spells."},
            [questKeys.requiredSpell] = -401759,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90003] = {
            [questKeys.name] = "Burnout",
            [questKeys.startedBy] = {{208275}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 9,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Gather some Mage and Warlock friends and attack the Frozen Makrura with fire spells."},
            [questKeys.requiredSpell] = -401759,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90004] = {
            [questKeys.name] = "Fingers of Frost",
            [questKeys.startedBy] = {{448,1132,1388,1271}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 11,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Defeat him."},
            [questKeys.requiredSpell] = -401765,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90005] = {
            [questKeys.name] = "Fingers of Frost",
            [questKeys.startedBy] = {{3205,208196}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 11,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Defeat him."},
            [questKeys.requiredSpell] = -401765,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90006] = {
            [questKeys.name] = "Regeneration",
            [questKeys.startedBy] = {nil,{407983}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 14,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Search the hut for a Pile of Stolen Books."},
            [questKeys.requiredSpell] = -401767,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90007] = {
            [questKeys.name] = "Regeneration",
            [questKeys.startedBy] = {nil,{152608,3642}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 14,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Loot the Kolkar's Booty chest."},
            [questKeys.requiredSpell] = -401767,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90008] = {
            [questKeys.name] = "Regeneration",
            [questKeys.startedBy] = {{589}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 14,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Defeat Defias Pillager."},
            [questKeys.requiredSpell] = -401767,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90009] = {
            [questKeys.name] = "Regeneration",
            [questKeys.startedBy] = {{1867}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 14,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Defeat Dalaran Apprentice."},
            [questKeys.requiredSpell] = -401767,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90010] = {
            [questKeys.name] = "Enlightenment",
            [questKeys.startedBy] = {{202093}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 5,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Polymorph 6 irregular critters like Gazelle, Maggot and Larva to loot Azora Apprentice Notes."},
            [questKeys.requiredSpell] = -415942,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90011] = {
            [questKeys.name] = "Enlightenment",
            [questKeys.startedBy] = {{208712}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 5,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Polymorph 6 Odd Melon to loot Apothecary Notes."},
            [questKeys.requiredSpell] = -415942,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90012] = {
            [questKeys.name] = "Arcane Surge",
            [questKeys.startedBy] = {{213077,214099,214101,}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Reach Friendly with the Azeroth Commerce Authority, then buy the Arcane Surge rune from the Quartermaster."},
            [questKeys.requiredSpell] = -425171,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90013] = {
            [questKeys.name] = "Arcane Surge",
            [questKeys.startedBy] = {{214070,214096,214098}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Reach Friendly with Durotar Supply and Logistics, then buy the Arcane Surge rune from the Quartermaster."},
            [questKeys.requiredSpell] = -425171,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90014] = {
            [questKeys.name] = "Mass Regeneration",
            [questKeys.startedBy] = {{212261},{411348}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Loot the Decrepit Phylactery from the Dusty Coffer in the eastern crypt. Then use it on the Slumbering Bones in the western crypt to summon the Awakened Lich."},
            [questKeys.requiredSpell] = -415939,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90015] = {
            [questKeys.name] = "Living Flame",
            [questKeys.startedBy] = {{476}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 6,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Defeat Kobold Geomancer."},
            [questKeys.requiredSpell] = -401768,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90016] = {
            [questKeys.name] = "Living Flame",
            [questKeys.startedBy] = {{1124,1397}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 9,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Defeat Frostmane Shadowcaster and Frostmane Seer."},
            [questKeys.requiredSpell] = -401768,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90017] = {
            [questKeys.name] = "Living Flame",
            [questKeys.startedBy] = {{3197}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 9,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Defeat Burning Blade Fanatic."},
            [questKeys.requiredSpell] = -401768,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90018] = {
            [questKeys.name] = "Living Flame",
            [questKeys.startedBy] = {{1535}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 6,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Defeat Scarlet Warrior."},
            [questKeys.requiredSpell] = -401768,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90019] = {
            [questKeys.name] = "Rewind Time",
            [questKeys.startedBy] = {{211653}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 20,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Buy the Rewind Time rune from Grizzby."},
            [questKeys.preQuestGroup] = {78265,78266,78267},
            [questKeys.requiredSpell] = -401761,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90020] = {
            [questKeys.name] = "Living Bomb",
            [questKeys.startedBy] = {{1166}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 13,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Defeat Stonesplinter Seer."},
            [questKeys.requiredSpell] = -415936,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90021] = {
            [questKeys.name] = "Living Bomb",
            [questKeys.startedBy] = {nil,{407505}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 20,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Use Blink to reach each green dot."},
            [questKeys.requiredSpell] = -415936,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90022] = {
            [questKeys.name] = "Divine Storm",
            [questKeys.startedBy] = {nil,{409289}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Loot Althalaxx Orb on top of the tower then go to Maestra’s Post in Ashenvale and speak with Delgren the Purifier."},
            [questKeys.exclusiveTo] = {78089},
            [questKeys.requiredSpell] = -410014,
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [90023] = {
            [questKeys.name] = "Wild Strikes",
            [questKeys.startedBy] = {{11910,11913,11912,11911}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 15,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Defeat Grimtotem Tauren."},
            [questKeys.requiredSpell] = -410021,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90024] = {
            [questKeys.name] = "Survival of the Fittest",
            [questKeys.startedBy] = {{211653}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 20,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Buy the Survival of the Fittest rune from Grizzby."},
            [questKeys.preQuestGroup] = {78265,78266,78267},
            [questKeys.requiredSpell] = -416042,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90025] = {
            [questKeys.name] = "Serendipity",
            [questKeys.startedBy] = {{211653}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 20,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Buy the Serendipity rune from Grizzby."},
            [questKeys.preQuestGroup] = {78265,78266,78267},
            [questKeys.requiredSpell] = -415995,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90026] = {
            [questKeys.name] = "Divine Sacrifice",
            [questKeys.startedBy] = {{211653}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 20,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Buy the Divine Sacrifice rune from Grizzby."},
            [questKeys.preQuestGroup] = {78265,78266,78267},
            [questKeys.requiredSpell] = -410010,
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [90027] = {
            [questKeys.name] = "Lone Wolf",
            [questKeys.startedBy] = {{211653}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 20,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Buy the Lone Wolf rune from Grizzby."},
            [questKeys.preQuestGroup] = {78265,78266,78267},
            [questKeys.requiredSpell] = -410122,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90028] = {
            [questKeys.name] = "Warbringer",
            [questKeys.startedBy] = {{211653}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 20,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Buy the Warbringer rune from Grizzby."},
            [questKeys.preQuestGroup] = {78265,78266,78267},
            [questKeys.requiredSpell] = -425445,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90029] = {
            [questKeys.name] = "Demonic Pact",
            [questKeys.startedBy] = {{211653}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 20,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Buy the Demonic Pact rune from Grizzby."},
            [questKeys.preQuestGroup] = {78265,78266,78267},
            [questKeys.requiredSpell] = -425476,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90030] = {
            [questKeys.name] = "Main Gauche",
            [questKeys.startedBy] = {{211653}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 20,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Buy the Main Gauche rune from Grizzby."},
            [questKeys.preQuestGroup] = {78265,78266,78267},
            [questKeys.requiredSpell] = -424990,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90031] = {
            [questKeys.name] = "Dual Wield Specialization",
            [questKeys.startedBy] = {{211653}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 20,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Buy the Dual Wield Specialization rune from Grizzby."},
            [questKeys.preQuestGroup] = {78265,78266,78267},
            [questKeys.requiredSpell] = -410096,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [90032] = {
            [questKeys.name] = "Lake of Fire",
            [questKeys.startedBy] = {{3537}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Buy Demolition Explosives from Zixil for 5 gold."},
            [questKeys.requiredSpell] = -403937,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90033] = {
            [questKeys.name] = "Lake of Fire",
            [questKeys.startedBy] = {nil,{414658}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Use the Demolition Explosives bought from Zixil on the rubble and loot the chest that spawns."},
            [questKeys.requiredSpell] = -403937,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90034] = {
            [questKeys.name] = "Master Channeler",
            [questKeys.startedBy] = {{3291}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Buy Malevolent Pie from Greishan Ironstove. Eat it and he will give you the rune."},
            [questKeys.requiredSpell] = -403932,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90035] = {
            [questKeys.name] = "Master Channeler",
            [questKeys.startedBy] = {{2336}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Kill Dark Strand Fanatic"},
            [questKeys.requiredSpell] = -403932,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90036] = {
            [questKeys.name] = "Master Channeler",
            [questKeys.startedBy] = {{114,480,832}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Kill Harvest Watcher or Rusty Harvest Golem for Spare Reaper Parts. Kill Dust Devil for Elemental Core. Combine for Elemental Core. Use on Harvest Reaper Prototype and kill it for the rune"},
            [questKeys.requiredSpell] = -403932,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90037] = {
            [questKeys.name] = "Master Channeler",
            [questKeys.startedBy] = {{212763}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Cast Curse of Recklessness on Sadistic Fiend and kill it"},
            [questKeys.requiredSpell] = -403932,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90038] = {
            [questKeys.name] = "Master Channeler",
            [questKeys.startedBy] = {nil,{407347}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Cast Health Funnel while standing on the Altar of Thorns until you are at 0 health"},
            [questKeys.requiredSpell] = -403932,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90039] = {
            [questKeys.name] = "Chaos Bolt",
            [questKeys.startedBy] = {{208752}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 9,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Gather some Mage and Warlock friends and attack the Frozen Trogg with fire spells."},
            [questKeys.requiredSpell] = -403925,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90040] = {
            [questKeys.name] = "Beacon of Light",
            [questKeys.startedBy] = {{213077,214099,214101,}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Reach Friendly with the Azeroth Commerce Authority, then buy the Beacon of Light rune from the Quartermaster."},
            [questKeys.requiredSpell] = -409999,
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [90041] = {
            [questKeys.name] = "Healing Rain",
            [questKeys.startedBy] = {{214070,214096,214098}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Reach Friendly with Durotar Supply and Logistics, then buy the Healing Rain rune from the Quartermaster."},
            [questKeys.requiredSpell] = -416057,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [90042] = {
            [questKeys.name] = "Everlasting Affliction",
            [questKeys.startedBy] = {{213077,214099,214101,}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Reach Friendly with the Azeroth Commerce Authority, then buy the Everlasting Affliction rune from the Quartermaster."},
            [questKeys.requiredSpell] = -416008,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90043] = {
            [questKeys.name] = "Everlasting Affliction",
            [questKeys.startedBy] = {{214070,214096,214098}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Reach Friendly with Durotar Supply and Logistics, then buy the Everlasting Affliction rune from the Quartermaster."},
            [questKeys.requiredSpell] = -416008,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90044] = {
            [questKeys.name] = "Serpent Spread",
            [questKeys.startedBy] = {{213077,214099,214101,}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Reach Friendly with the Azeroth Commerce Authority, then buy the Serpent Spread rune from the Quartermaster."},
            [questKeys.requiredSpell] = -425760,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90045] = {
            [questKeys.name] = "Serpent Spread",
            [questKeys.startedBy] = {{214070,214096,214098}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Reach Friendly with Durotar Supply and Logistics, then buy the Serpent Spread rune from the Quartermaster."},
            [questKeys.requiredSpell] = -425760,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90046] = {
            [questKeys.name] = "Single-Minded Fury",
            [questKeys.startedBy] = {{213077,214099,214101,}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Reach Friendly with the Azeroth Commerce Authority, then buy the Single-Minded Fury rune from the Quartermaster."},
            [questKeys.requiredSpell] = -416003,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90047] = {
            [questKeys.name] = "Single-Minded Fury",
            [questKeys.startedBy] = {{214070,214096,214098}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Reach Friendly with Durotar Supply and Logistics, then buy the Single-Minded Fury rune from the Quartermaster."},
            [questKeys.requiredSpell] = -416003,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90048] = {
            [questKeys.name] = "Skull Bash",
            [questKeys.startedBy] = {{213077,214099,214101,}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Reach Friendly with the Azeroth Commerce Authority, then buy the Skull Bash rune from the Quartermaster."},
            [questKeys.requiredSpell] = -416046,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90049] = {
            [questKeys.name] = "Skull Bash",
            [questKeys.startedBy] = {{214070,214096,214098}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Reach Friendly with Durotar Supply and Logistics, then buy the Skull Bash rune from the Quartermaster."},
            [questKeys.requiredSpell] = -416046,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90050] = {
            [questKeys.name] = "Just a Flesh Wound",
            [questKeys.startedBy] = {{213077,214099,214101,}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Reach Friendly with the Azeroth Commerce Authority, then buy the Just a Flesh Wound rune from the Quartermaster."},
            [questKeys.requiredSpell] = -400082,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90051] = {
            [questKeys.name] = "Just a Flesh Wound",
            [questKeys.startedBy] = {{214070,214096,214098}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Reach Friendly with Durotar Supply and Logistics, then buy the Just a Flesh Wound rune from the Quartermaster."},
            [questKeys.requiredSpell] = -400082,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90052] = {
            [questKeys.name] = "Mind Sear",
            [questKeys.startedBy] = {{213077,214099,214101,}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Reach Friendly with the Azeroth Commerce Authority, then buy the Mind Sear rune from the Quartermaster."},
            [questKeys.requiredSpell] = -415996,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90053] = {
            [questKeys.name] = "Mind Sear",
            [questKeys.startedBy] = {{214070,214096,214098}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Reach Friendly with Durotar Supply and Logistics, then buy the Mind Sear rune from the Quartermaster."},
            [questKeys.requiredSpell] = -415996,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90054] = {
            [questKeys.name] = "Living Seed",
            [questKeys.startedBy] = {{206248}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 7,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Loot 3 Glade Flower spread across the zone. Combine them to the Glade Crown, use it on the Wooden Effigy and defeat the Unleashed Nature Spirit Elite mob."},
            [questKeys.requiredSpell] = -416050,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90055] = {
            [questKeys.name] = "Living Seed",
            [questKeys.startedBy] = {{206248}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 7,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Loot 3 Prairie Flower spread across the zone. Combine them to the Prairie Crown, use it on the Wooden Effigy and defeat the Unleashed Nature Spirit Elite mob."},
            [questKeys.requiredSpell] = -416050,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90056] = {
            [questKeys.name] = "Starsurge",
            [questKeys.startedBy] = {{212186}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Accept the offer from Grugimdern to receive a Mushroom. Then eat the Mushroom at the pond and speak with Vodyanoi."},
            [questKeys.requiredSpell] = -424718,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90057] = {
            [questKeys.name] = "Sunfire",
            [questKeys.startedBy] = {nil,{404433}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 4,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Cast Moonfire on all three Lunar Stones to spawn the Lunar Chest."},
            [questKeys.requiredSpell] = -416044,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90058] = {
            [questKeys.name] = "Lifebloom",
            [questKeys.startedBy] = {{204827}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 4,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Summon the Adventurer's Spirit with the help of a friend and defeat it."},
            [questKeys.requiredSpell] = -410033,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90059] = {
            [questKeys.name] = "Prayer of Mending",
            [questKeys.startedBy] = {{204827}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 4,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Summon the Adventurer's Spirit with the help of a friend and defeat it."},
            [questKeys.requiredSpell] = -402848,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90060] = {
            [questKeys.name] = "Ancestral Guidance",
            [questKeys.startedBy] = {{204827}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 4,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Summon the Adventurer's Spirit with the help of a friend and defeat it."},
            [questKeys.requiredSpell] = -410099,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [90061] = {
            [questKeys.name] = "Chaos Bolt",
            [questKeys.startedBy] = {{202060}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 9,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Gather some Mage and Warlock friends and attack the Frozen Murloc with fire spells."},
            [questKeys.requiredSpell] = -403925,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90062] = {
            [questKeys.name] = "Chaos Bolt",
            [questKeys.startedBy] = {{208275}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 9,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Gather some Mage and Warlock friends and attack the Frozen Makrura with fire spells."},
            [questKeys.requiredSpell] = -403925,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90063] = {
            [questKeys.name] = "Chaos Bolt",
            [questKeys.startedBy] = {{202060}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 9,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Gather some Mage and Warlock friends and attack the Frozen Murloc with fire spells."},
            [questKeys.requiredSpell] = -403925,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90064] = {
            [questKeys.name] = "Shadow Bolt Volley",
            [questKeys.startedBy] = {{209954,209958}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 18,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Kill Demonic Remains with a shadow spell. It spawns Graix, who drops the Rune."},
            [questKeys.requiredSpell] = -403936,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90065] = {
            [questKeys.name] = "Shadow Bolt Volley",
            [questKeys.startedBy] = {{391}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 18,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Use Drain Soul on Old Murk-Eye to receive Soul of the Sea."},
            [questKeys.requiredSpell] = -403936,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90066] = {
            [questKeys.name] = "Shadow Bolt Volley",
            [questKeys.startedBy] = {nil,{450002}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 18,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Use Soul of the Sea on the Medusa Statue."},
            [questKeys.requiredSpell] = -403936,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90067] = {
            [questKeys.name] = "Shadow Bolt Volley",
            [questKeys.startedBy] = {{3445}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 18,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Use Drain Soul on Supervisor Lugwizzle to receive Soul of Greed."},
            [questKeys.requiredSpell] = -403936,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90068] = {
            [questKeys.name] = "Shadow Bolt Volley",
            [questKeys.startedBy] = {nil,{407312}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 18,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Use the Soul of Greed on the Hungry Idol."},
            [questKeys.requiredSpell] = -403936,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90069] = {
            [questKeys.name] = "Shadow Bolt Volley",
            [questKeys.startedBy] = {{1974,1973}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 18,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Kill Ravenclaw Drudger and Ravenclaw Guardian until they drop Tortured Soul. Once gathered, Life Tap to receive a buff, and then use the item. This will spawn a Ghost mob to kill."},
            [questKeys.requiredSpell] = -403936,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90070] = {
            [questKeys.name] = "Incinerate",
            [questKeys.startedBy] = {{214519}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 23,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Kill Incinerator Gar'im"},
            [questKeys.requiredSpell] = -416015,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90071] = {
            [questKeys.name] = "Demonic Tactics",
            [questKeys.startedBy] = {{204503,906,6122}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 8,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Loot the Dead Acolyte near Jasperlode Mine. Take the artifact to the Warlock Trainer in Goldshire. Use the Powerless Artifact near the Dead Acolyte. Finally go to Gakin the Darkbinder in Stormwind"},
            [questKeys.requiredSpell] = -416009,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90072] = {
            [questKeys.name] = "Demonic Tactics",
            [questKeys.startedBy] = {{208927,2127,5675}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 8,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Loot the Dead Acolyte near Scarlet Monestary. Take the artifact to the Warlock Trainer in Brill. Use the Powerless Artifact near the Dead Acolyte. Finally go to Carendin Halgar in Undercity"},
            [questKeys.requiredSpell] = -416009,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90073] = {
            [questKeys.name] = "Soul Siphon",
            [questKeys.startedBy] = {{6124,209002}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Drain a critter with Drain Soul to obtain Pure Soul Shard. Drain Captain Beld to obtain Tainted Soul Shard. Trade both Shards to Gaklik Voidtwist in Kharanos"},
            [questKeys.requiredSpell] = -403920,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90074] = {
            [questKeys.name] = "Soul Siphon",
            [questKeys.startedBy] = {{448,204256}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Drain a critter with Drain Soul to obtain Pure Soul Shard. Drain Hogger to obtain Tainted Soul Shard. Trade both Shards to Damien Kane, found in the basement of the Goldshire Inn."},
            [questKeys.requiredSpell] = -403920,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90075] = {
            [questKeys.name] = "Soul Siphon",
            [questKeys.startedBy] = {{3204,208226}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Drain a critter with Drain Soul to obtain Pure Soul Shard. Drain Gazz'uz to obtain Tainted Soul Shard. Trade both Shards to Darmak Bloodhowl in Razor Hill."},
            [questKeys.requiredSpell] = -403920,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90076] = {
            [questKeys.name] = "Soul Siphon",
            [questKeys.startedBy] = {{1753,208682}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Drain a critter with Drain Soul to obtain Pure Soul Shard. Drain Maggot Eye to obtain Tainted Soul Shard. Trade both Shards to Denton Bleakway in Undercity."},
            [questKeys.requiredSpell] = -403920,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90077] = {
            [questKeys.name] = "Demonic Grace",
                                    --Frostmane Shadowcaster,Wendigos ,Wolfs                 ,Soboz
            [questKeys.startedBy] = {{1124,1397             ,1134,1135,705,704,1131,1133,1138,204070}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 8,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Obtain Ominous Tome from Frostmane Shadowcaster in Troll cave west of Brewnall Village Loot Wendigo Blood from Wendigo mobs Loot Wolf Jawbone from Wolf mobs. Use the reagents on Shimmer Ridge and kill Soboz"},
            [questKeys.requiredSpell] = -425477,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90078] = {
            [questKeys.name] = "Demonic Grace",
                                    --Book       ,Gnolls,Wolfs              ,Soboz
            [questKeys.startedBy] = {{881,476,474,97,478,299,525,69,1922,118,204070}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 8,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Obtain Ominous Tome from Kobolds in Jasperlode Mine. Loot Gnoll Blood from any Gnoll. Loot Wolf Jawbone from any Prowler or Wolf. Use the reagents on the summoning circle at The Slaughtered Lamb Inn in the Mage Quarter in Stormwind and kill Soboz."},
            [questKeys.requiredSpell] = -425477,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90079] = {
            [questKeys.name] = "Demonic Grace",
                                    --Book                              ,Makrura  ,Kul Tiran,Soboz
            [questKeys.startedBy] = {{1522,3206,3207,3113,3198,3118,1675,3103,3104,3128,3129,204070}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 8,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Obtain Ominous Tome from Voodoo Troll in Echo Isles. Loot Makrura Leg from Makrura mobs. Loot Kul Tiran Skull from Kul Tiran mobs in Tiragarde Keep. Use the reagents on the summoning circle near Zalazane and kill Soboz"},
            [questKeys.requiredSpell] = -425477,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90080] = {
            [questKeys.name] = "Demonic Grace",
                                    --Book,Gnolls        ,Darkhounds    ,Soboz
            [questKeys.startedBy] = {{3206,1675,1941,1674,1547,1548,1549,204070}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 8,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Obtain Ominous Tome from Darkeye Bonecaster. Loot Gnoll Blood from any Gnoll in Garren's Haunt. Loot Wolf Jawbone from any Darkhound in Tirisfal Glades. Use the reagents on the summoning circle in the Sewers location in Undercity - up where the flight path usually flies you over. Kill Soboz."},
            [questKeys.requiredSpell] = -425477,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90081] = {
            [questKeys.name] = "Aspect of the Lion",
            [questKeys.startedBy] = {{211965}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Defeat him."},
            [questKeys.requiredSpell] = -410115,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90082] = {
            [questKeys.name] = "Master Marksman",
            [questKeys.startedBy] = {{205692,208179,208975,209811}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 7,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Use Hunter's Mark on the Bush and defeat the Poacher."},
            [questKeys.requiredSpell] = -410113,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90083] = {
            [questKeys.name] = "Cobra Strikes",
            [questKeys.startedBy] = {{205692,208179,208975,209811}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Use Hunter's Mark on the Bush and defeat the Poacher."},
            [questKeys.requiredSpell] = -425759,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
    }
end

function SeasonOfDiscovery:LoadFactionQuestFixes()
    local questKeys = QuestieDB.questKeys
    local raceIDs = QuestieDB.raceKeys

    local questFixesHorde = {
        [78124] = {
            [questKeys.startedBy] = {{211022},{409496}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'Nar'thalas Almanac, Vol. 74' and bring it to Owen Thadd in Undercity. After ten books you will receive the Icy Veins rune."},
        },
        [78127] = {
            [questKeys.startedBy] = {{211022},{409501}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'The Dalaran Digest, Vol. 23' and bring it to Owen Thadd in Undercity. After ten books you will receive the Icy Veins rune."},
        },
        [78142] = {
            [questKeys.startedBy] = {{211022},{409562}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'Bewitchments and Glamours' and bring it to Owen Thadd in Undercity. After ten books you will receive the Icy Veins rune."},
        },
        [78143] = {
            [questKeys.startedBy] = {{211022},{409692}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'Secrets of the Dreamers' and bring it to Owen Thadd in Undercity. After ten books you will receive the Icy Veins rune."},
        },
        [78145] = {
            [questKeys.startedBy] = {{211022},{409717}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'Goaz Scrolls' and bring it to Owen Thadd in Undercity. After ten books you will receive the Icy Veins rune."},
        },
        [78146] = {
            [questKeys.startedBy] = {{211022},{409496}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'Nar'thalas Almanac, Vol. 74' and bring it to Owen Thadd in Undercity. After ten books you will receive the Icy Veins rune."},
        },
        [78147] = {
            [questKeys.startedBy] = {{211022},{409735}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'Crimes Against Anatomy' and bring it to Owen Thadd in Undercity. After ten books you will receive the Icy Veins rune."},
        },
        [78148] = {
            [questKeys.startedBy] = {{211022},{409731}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'Runes of the Sorcerer-Kings' and bring it to Owen Thadd in Undercity. After ten books you will receive the Icy Veins rune."},
        },
        [78149] = {
            [questKeys.startedBy] = {{211022},{409711}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'Fury of the Land' and bring it to Owen Thadd in Undercity. After ten books you will receive the Icy Veins rune."},
        },
        [78611] = {
            [questKeys.startedBy] = {{214070,214096,214098}},
            [questKeys.finishedBy] = {{214070,214096,214098}},
        },
        [78612] = {
            [questKeys.startedBy] = {{214070,214096,214098}},
            [questKeys.finishedBy] = {{214070,214096,214098}},
        },
        [78872] = {
            [questKeys.startedBy] = {{214070,214096,214098}},
            [questKeys.finishedBy] = {{214070,214096,214098}},
        },
        [79097] = {
            [questKeys.startedBy] = {{211022},{407566}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'Baxtan: On Destructive Magics' and bring it to Owen Thadd in Undercity. After ten books you will receive the Icy Veins rune."},
        },
        [79100] = {
            [questKeys.startedBy] = {{214070,214096,214098}},
            [questKeys.finishedBy] = {{214070,214096,214098}},
        },
        [79101] = {
            [questKeys.startedBy] = {{214070,214096,214098}},
            [questKeys.finishedBy] = {{214070,214096,214098}},
        },
        [79102] = {
            [questKeys.startedBy] = {{214070,214096,214098}},
            [questKeys.finishedBy] = {{214070,214096,214098}},
        },
        [79103] = {
            [questKeys.startedBy] = {{214070,214096,214098}},
            [questKeys.finishedBy] = {{214070,214096,214098}},
        },
    }

    local questFixesAlliance = {
        [78124] = {
            [questKeys.startedBy] = {{211033},{409496}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'Nar'thalas Almanac, Vol. 74' and bring it to Garion Wendell in Stormwind. After ten book turnins you will receive the Icy Veins rune."},
        },
        [78127] = {
            [questKeys.startedBy] = {{211033},{409501}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'The Dalaran Digest, Vol. 23' and bring it to Garion Wendell in Stormwind. After ten book turnins you will receive the Icy Veins rune."},
        },
        [78142] = {
            [questKeys.startedBy] = {{211033},{409562}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'Bewitchments and Glamours' and bring it to Garion Wendell in Stormwind. After ten book turnins you will receive the Icy Veins rune."},
        },
        [78143] = {
            [questKeys.startedBy] = {{211033},{409692}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'Secrets of the Dreamers' and bring it to Garion Wendell in Stormwind. After ten book turnins you will receive the Icy Veins rune."},
        },
        [78145] = {
            [questKeys.startedBy] = {{211033},{409717}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'Goaz Scrolls' and bring it to Garion Wendell in Stormwind. After ten book turnins you will receive the Icy Veins rune."},
        },
        [78146] = {
            [questKeys.startedBy] = {{211033},{409496}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'Nar'thalas Almanac, Vol. 74' and bring it to Garion Wendell in Stormwind. After ten book turnins you will receive the Icy Veins rune."},
        },
        [78147] = {
            [questKeys.startedBy] = {{211033},{409735}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'Crimes Against Anatomy' and bring it to Garion Wendell in Stormwind. After ten book turnins you will receive the Icy Veins rune."},
        },
        [78148] = {
            [questKeys.startedBy] = {{211033},{409731}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'Runes of the Sorcerer-Kings' and bring it to Garion Wendell in Stormwind. After ten book turnins you will receive the Icy Veins rune."},
        },
        [78149] = {
            [questKeys.startedBy] = {{211033},{409711}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'Fury of the Land' and bring it to Garion Wendell in Stormwind. After ten book turnins you will receive the Icy Veins rune."},
        },
        [78611] = {
            [questKeys.startedBy] = {{213077,214099,214101}},
            [questKeys.finishedBy] = {{213077,214099,214101}},
        },
        [78612] = {
            [questKeys.startedBy] = {{213077,214099,214101}},
            [questKeys.finishedBy] = {{213077,214099,214101}},
        },
        [78872] = {
            [questKeys.startedBy] = {{213077,214099,214101}},
            [questKeys.finishedBy] = {{213077,214099,214101}},
        },
        [79097] = {
            [questKeys.startedBy] = {{211033},{407566}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'Baxtan: On Destructive Magics' and bring it to Garion Wendell in Stormwind. After ten book turnins you will receive the Icy Veins rune."},
        },
        [79100] = {
            [questKeys.startedBy] = {{213077,214099,214101}},
            [questKeys.finishedBy] = {{213077,214099,214101}},
        },
        [79101] = {
            [questKeys.startedBy] = {{213077,214099,214101}},
            [questKeys.finishedBy] = {{213077,214099,214101}},
        },
        [79102] = {
            [questKeys.startedBy] = {{213077,214099,214101}},
            [questKeys.finishedBy] = {{213077,214099,214101}},
        },
        [79103] = {
            [questKeys.startedBy] = {{213077,214099,214101}},
            [questKeys.finishedBy] = {{213077,214099,214101}},
        },
    }

    if UnitFactionGroup("Player") == "Horde" then
        return questFixesHorde
    else
        return questFixesAlliance
    end
end
