---@type l10n
local l10n = QuestieLoader:ImportModule("l10n")

local tooltipsUILocales = {
    ["You are on this quest"] = {
        ["ptBR"] = "Você tem essa missão",
        ["ruRU"] = "У вас есть это задание",
        ["deDE"] = "Diese Quest ist für dich aktiv",
        ["koKR"] = "현재 진행중인 퀘스트",
        ["esMX"] = "Tienes esta misión",
        ["enUS"] = true,
        ["zhCN"] = "你正在进行这项任务",
        ["zhTW"] = "你正在進行這項任務",
        ["esES"] = "Tienes esta misión",
        ["frFR"] = "Vous effectuez cette quête",
    },
    ["You have not done this quest"] = {
        ["ptBR"] = "Você não fez esta missão",
        ["ruRU"] = "Вы не выполнили это задание",
        ["deDE"] = "Du hast diese Quest noch nicht abgeschlossen",
        ["koKR"] = "아직 완료하지 않은 퀘스트",
        ["esMX"] = "No has completado esta misión",
        ["enUS"] = true,
        ["zhCN"] = "你并未完成这项任务",
        ["zhTW"] = "你並未完成這項任務",
        ["esES"] = "No has completado esta misión",
        ["frFR"] = "Vous n'avez pas terminé cette quête",
    },
    ["Nearby"] = {
        ["ptBR"] = "Nas proximidades",
        ["ruRU"] = "Недалеко",
        ["deDE"] = "In der Nähe",
        ["koKR"] = "근처",
        ["esMX"] = "Cerca de",
        ["enUS"] = true,
        ["zhCN"] = "附近",
        ["zhTW"] = "附近",
        ["esES"] = "Cerca de",
        ["frFR"] = "Proche",
    },
    ["Requirements"] = {
        ["ptBR"] = "Requisitos",
        ["ruRU"] = "Требуется:",
        ["deDE"] = "Voraussetzungen",
        ["koKR"] = "요구사항",
        ["esMX"] = "Requisitos",
        ["enUS"] = true,
        ["zhCN"] = "需求",
        ["zhTW"] = "需求",
        ["esES"] = "Requisitos",
        ["frFR"] = "Requises",
    },
    ["You are ineligible for this quest"] = {
        ["ptBR"] = "Você não é elegível para esta missão",
        ["ruRU"] = "Это задание вам недоступно",
        ["deDE"] = "Du kannst diese Quest nicht annehmen",
        ["koKR"] = "이 퀘스트를 받을 자격이 없습니다",
        ["esMX"] = "No eres elegible para esta misión",
        ["enUS"] = true,
        ["zhCN"] = "你无法进行这项任务",
        ["zhTW"] = "你無法進行這項任務",
        ["esES"] = "No eres elegible para esta misión",
        ["frFR"] = "Vous n'êtes pas éligible pour cette quête",
    },
    ["This quest is repeatable"] = {
        ["ptBR"] = "Essa missão é repetível",
        ["ruRU"] = "Это повторяемое задание",
        ["deDE"] = "Diese Quest ist wiederholbar",
        ["koKR"] = "반복 가능한 퀘스트",
        ["esMX"] = "Esta misión es repetible",
        ["enUS"] = true,
        ["zhCN"] = "这个任务可以重复完成",
        ["zhTW"] = "這任務可被重複進行",
        ["esES"] = "Esta misión es repetible.",
        ["frFR"] = "Cette quête est répétable",
    },
    ["Your progress"] = {
        ["ptBR"] = "Seu progresso",
        ["ruRU"] = "Ваш прогресс",
        ["deDE"] = "Dein Fortschritt",
        ["koKR"] = "현재 진행상태",
        ["esMX"] = "Progreso",
        ["enUS"] = true,
        ["zhCN"] = "你的进度",
        ["zhTW"] = "你的進度",
        ["esES"] = "Progreso",
        ["frFR"] = "Progression",
    },
    ["You have completed this quest"] = {
        ["ptBR"] = "Você concluiu esta missão",
        ["ruRU"] = "Вы выполнили это задание",
        ["deDE"] = "Du hast diese Quest bereits abgeschlossen",
        ["koKR"] = "완료된 퀘스트",
        ["esMX"] = "Ya has completado esta misión",
        ["enUS"] = true,
        ["zhCN"] = "你已完成这项任务",
        ["zhTW"] = "你已完成這項任務",
        ["esES"] = "Ya has completado esta misión",
        ["frFR"] = "Vous avez terminé cette quête",
    },
    ["Started by"] = {
        ["ptBR"] = "Começado por",
        ["ruRU"] = "Начинает",
        ["deDE"] = "Gestarted von",
        ["koKR"] = "시작",
        ["esMX"] = "Iniciado por",
        ["enUS"] = true,
        ["zhCN"] = "任务开始于",
        ["zhTW"] = "任務開始於",
        ["esES"] = "Iniciado por",
        ["frFR"] = "Début",
    },
    ["Ended by"] = {
        ["ptBR"] = "Terminado por",
        ["ruRU"] = "Завершает",
        ["deDE"] = "Beendet von",
        ["koKR"] = "끝",
        ["esMX"] = "Terminada por",
        ["enUS"] = true,
        ["zhCN"] = "任务结束于",
        ["zhTW"] = "任務結束於",
        ["esES"] = "Terminada por",
        ["frFR"] = "Fin",
    },
    ["Completed on:"] = {
        ["ptBR"] = "Concluído em:",
        ["ruRU"] = "Выполнено:",
        ["deDE"] = "Abgeschlossen am",
        ["koKR"] = "완료",
        ["esMX"] = "Completada el:",
        ["enUS"] = true,
        ["zhCN"] = "完成于:",
        ["zhTW"] = "已完成:",
        ["esES"] = "Completada el:",
        ["frFR"] = "Complété le:",
    }
}

for k, v in pairs(tooltipsUILocales) do
    l10n.translations[k] = v
end
