---@type l10n
local l10n = QuestieLoader:ImportModule("l10n")

local kalimdorLocales = {
    ["Moonglade"] = {
        ["ptBR"] = "Clareira da Lua",
        ["ruRU"] = "Лунная поляна",
        ["deDE"] = "Mondlichtung",
        ["koKR"] = "달의 숲",
        ["esMX"] = "Claro de la Luna",
        ["enUS"] = true,
        ["frFR"] = "Reflet-de-Lune",
        ["esES"] = "Claro de la Luna",
        ["zhTW"] = "月光林地",
        ["zhCN"] = "月光林地",
    },
    ["Thousand Needles"] = {
        ["ptBR"] = "Mil Agulhas",
        ["ruRU"] = "Тысяча Игл",
        ["deDE"] = "Tausend Nadeln",
        ["koKR"] = "버섯구름 봉우리",
        ["esMX"] = "Las Mil Agujas",
        ["enUS"] = true,
        ["frFR"] = "Mille pointes",
        ["esES"] = "Las Mil Agujas",
        ["zhTW"] = "千針石林",
        ["zhCN"] = "千针石林",
    },
    ["Timbermaw Hold"] = {
        ["ptBR"] = "Domínio dos Presamatos",
        ["ruRU"] = "Древобрюхи",
        ["deDE"] = "Holzschlundfeste",
        ["koKR"] = false,
        ["esMX"] = "Bastión de los Fauces de Madera",
        ["enUS"] = true,
        ["frFR"] = "Les Grumegueules",
        ["esES"] = "Bastión de los Fauces de Madera",
        ["zhTW"] = false,
        ["zhCN"] = "木喉要塞",
    },
    ["Winterspring"] = {
        ["ptBR"] = "Hibérnia",
        ["ruRU"] = "Зимние Ключи",
        ["deDE"] = "Winterquell",
        ["koKR"] = "여명의 설원",
        ["esMX"] = "Cuna del Invierno",
        ["enUS"] = true,
        ["frFR"] = "Berceau-de-l'Hiver",
        ["esES"] = "Cuna del Invierno",
        ["zhTW"] = "冬泉谷",
        ["zhCN"] = "冬泉谷",
    },
    ["Ashenvale"] = {
        ["ptBR"] = "Vale Gris",
        ["ruRU"] = "Ясеневый лес",
        ["deDE"] = "Eschental",
        ["koKR"] = "잿빛 골짜기",
        ["esMX"] = "Vallefresno",
        ["enUS"] = true,
        ["frFR"] = "Orneval",
        ["esES"] = "Vallefresno",
        ["zhTW"] = "梣谷",
        ["zhCN"] = "灰谷",
    },
    ["Teldrassil"] = {
        ["ptBR"] = "Teldrassil",
        ["ruRU"] = "Тельдрассил",
        ["deDE"] = "Teldrassil",
        ["koKR"] = "텔드랏실",
        ["esMX"] = "Teldrassil",
        ["enUS"] = true,
        ["frFR"] = "Teldrassil",
        ["esES"] = "Teldrassil",
        ["zhTW"] = "泰達希爾",
        ["zhCN"] = "泰达希尔",
    },
    ["Un'Goro Crater"] = {
        ["ptBR"] = "Cratera Un'Goro",
        ["ruRU"] = "Кратер Ун'Горо",
        ["deDE"] = "Krater von Un'Goro",
        ["koKR"] = "운고로 분화구",
        ["esMX"] = "Cráter de Un'Goro",
        ["enUS"] = true,
        ["frFR"] = "Cratère d'Un'Goro",
        ["esES"] = "Cráter de Un'Goro",
        ["zhTW"] = "安戈洛環形山",
        ["zhCN"] = "安戈洛环形山",
    },
    ["Mulgore"] = {
        ["ptBR"] = "Mulgore",
        ["ruRU"] = "Мулгор",
        ["deDE"] = "Mulgore",
        ["koKR"] = "멀고어",
        ["esMX"] = "Mulgore",
        ["enUS"] = true,
        ["frFR"] = "Mulgore",
        ["esES"] = "Mulgore",
        ["zhTW"] = "莫高雷",
        ["zhCN"] = "莫高雷",
    },
    ["Dustwallow Marsh"] = {
        ["ptBR"] = "Pântano Vadeoso",
        ["ruRU"] = "Пылевые топи",
        ["deDE"] = "Düstermarschen",
        ["koKR"] = "먼지진흙 슾지대",
        ["esMX"] = "Marjal Revolcafango",
        ["enUS"] = true,
        ["frFR"] = "Marécage d'Âprefange",
        ["esES"] = "Marjal Revolcafango",
        ["zhTW"] = "塵泥沼澤",
        ["zhCN"] = "尘泥沼泽",
    },
    ["Felwood"] = {
        ["ptBR"] = "Selva Maleva",
        ["ruRU"] = "Оскверненный лес",
        ["deDE"] = "Teufelswald",
        ["koKR"] = "악령의 숲",
        ["esMX"] = "Frondavil",
        ["enUS"] = true,
        ["frFR"] = "Gangrebois",
        ["esES"] = "Frondavil",
        ["zhTW"] = "費伍德森林",
        ["zhCN"] = "费伍德森林",
    },
    ["Darkshore"] = {
        ["ptBR"] = "Costa Negra",
        ["ruRU"] = "Темные берега",
        ["deDE"] = "Dunkelküste",
        ["koKR"] = "어둠의 해안",
        ["esMX"] = "Costa Oscura",
        ["enUS"] = true,
        ["frFR"] = "Sombrivage",
        ["esES"] = "Costa Oscura",
        ["zhTW"] = "黑海岸",
        ["zhCN"] = "黑海岸",
    },
    ["Orgrimmar"] = {
        ["ptBR"] = "Orgrimmar",
        ["ruRU"] = "Оргриммар",
        ["deDE"] = "Orgrimmar",
        ["koKR"] = "오그리마",
        ["esMX"] = "Orgrimmar",
        ["enUS"] = true,
        ["frFR"] = "Orgrimmar",
        ["esES"] = "Orgrimmar",
        ["zhTW"] = "奧格瑪",
        ["zhCN"] = "奥格瑞玛",
    },
    ["Desolace"] = {
        ["ptBR"] = "Desolação",
        ["ruRU"] = "Пустоши",
        ["deDE"] = "Desolace",
        ["koKR"] = "잊혀진 땅",
        ["esMX"] = "Desolace",
        ["enUS"] = true,
        ["frFR"] = "Désolace",
        ["esES"] = "Desolace",
        ["zhTW"] = "淒涼之地",
        ["zhCN"] = "凄凉之地",
    },
    ["Tanaris"] = {
        ["ptBR"] = "Tanaris",
        ["ruRU"] = "Танарис",
        ["deDE"] = "Tanaris",
        ["koKR"] = "타나리스",
        ["esMX"] = "Tanaris",
        ["enUS"] = true,
        ["frFR"] = "Tanaris",
        ["esES"] = "Tanaris",
        ["zhTW"] = "塔納利斯",
        ["zhCN"] = "塔纳利斯",
    },
    ["Azshara"] = {
        ["ptBR"] = "Azshara",
        ["ruRU"] = "Азшара",
        ["deDE"] = "Azshara",
        ["koKR"] = "아즈샤라",
        ["esMX"] = "Azshara",
        ["enUS"] = true,
        ["frFR"] = "Azshara",
        ["esES"] = "Azshara",
        ["zhTW"] = "艾薩拉",
        ["zhCN"] = "艾萨拉",
    },
    ["Feralas"] = {
        ["ptBR"] = "Feralas",
        ["ruRU"] = "Фералас",
        ["deDE"] = "Feralas",
        ["koKR"] = "페랄라스",
        ["esMX"] = "Feralas",
        ["enUS"] = true,
        ["frFR"] = "Féralas",
        ["esES"] = "Feralas",
        ["zhTW"] = "菲拉斯",
        ["zhCN"] = "菲拉斯",
    },
    ["The Barrens"] = {
        ["ptBR"] = "Sertões",
        ["ruRU"] = "Степи",
        ["deDE"] = "Das Brachland",
        ["koKR"] = "불모의 땅",
        ["esMX"] = "Los Baldíos",
        ["enUS"] = true,
        ["frFR"] = "Les Tarides",
        ["esES"] = "Los Baldíos",
        ["zhTW"] = "貧瘠之地",
        ["zhCN"] = "贫瘠之地",
    },
    ["Durotar"] = {
        ["ptBR"] = "Durotar",
        ["ruRU"] = "Дуротар",
        ["deDE"] = "Durotar",
        ["koKR"] = "듀로타",
        ["esMX"] = "Durotar",
        ["enUS"] = true,
        ["frFR"] = "Durotar",
        ["esES"] = "Durotar",
        ["zhTW"] = "杜洛塔",
        ["zhCN"] = "杜隆塔尔",
    },
    ["Thunder Bluff"] = {
        ["ptBR"] = "Penhasco do Trovão",
        ["ruRU"] = "Громовой Утес",
        ["deDE"] = "Donnerfels",
        ["koKR"] = "썬더 블러프",
        ["esMX"] = "Cima del Trueno",
        ["enUS"] = true,
        ["frFR"] = "Thunder Bluff",
        ["esES"] = "Cima del Trueno",
        ["zhTW"] = "雷霆崖",
        ["zhCN"] = "雷霆崖",
    },
    ["Silithus"] = {
        ["ptBR"] = "Silithus",
        ["ruRU"] = "Силитус",
        ["deDE"] = "Silithus",
        ["koKR"] = "실리더스",
        ["esMX"] = "Silithus",
        ["enUS"] = true,
        ["frFR"] = "Silithus",
        ["esES"] = "Silithus",
        ["zhTW"] = "希利蘇斯",
        ["zhCN"] = "希利苏斯",
    },
    ["Stonetalon Mountains"] = {
        ["ptBR"] = "Cordilheira das Torres de Pedra",
        ["ruRU"] = "Когтистые горы",
        ["deDE"] = "Steinkrallengebirge",
        ["koKR"] = "돌발톱 산맥",
        ["esMX"] = "Sierra Espolón",
        ["enUS"] = true,
        ["frFR"] = "Les Serres-Rocheuses",
        ["esES"] = "Sierra Espolón",
        ["zhTW"] = "石爪山脈",
        ["zhCN"] = "石爪山脉",
    },
    ["Darnassus"] = {
        ["ptBR"] = "Darnassus",
        ["ruRU"] = "Дарнасс",
        ["deDE"] = "Darnassus",
        ["koKR"] = "다르나서스",
        ["esMX"] = "Darnassus",
        ["enUS"] = true,
        ["frFR"] = "Darnassus",
        ["esES"] = "Darnassus",
        ["zhTW"] = "達納蘇斯",
        ["zhCN"] = "达纳苏斯",
    },
    ["Auberdine"] = { -- town in Darkshore, used as zoneOrSort in SoD quest for some reason
        ["ptBR"] = true, -- since this string is transcribed, not translated, latin languages are identical
        ["ruRU"] = "Аубердина",
        ["deDE"] = true,
        ["koKR"] = "아우버다인",
        ["esMX"] = true,
        ["enUS"] = true,
        ["frFR"] = true,
        ["esES"] = true,
        ["zhTW"] = "奥伯丁",
        ["zhCN"] = "奥伯丁",
    },
}

for k, v in pairs(kalimdorLocales) do
    l10n.translations[k] = v
end
