---@type l10n
local l10n = QuestieLoader:ImportModule("l10n")

local northrendLocales = {
    ["Zul'Drak"] = {
        ["ptBR"] = "Zul'Drak",
        ["ruRU"] = "Зул'Драк",
        ["deDE"] = "Zul'Drak",
        ["koKR"] = "줄드락",
        ["esMX"] = "Zul'Drak",
        ["enUS"] = true,
        ["frFR"] = "Zul'Drak",
        ["esES"] = "Zul'Drak",
        ["zhTW"] = "祖爾德拉克",
        ["zhCN"] = "祖达克",
    },
    ["Grizzly Hills"] = {
        ["ptBR"] = "Serra Gris",
        ["ruRU"] = "Седые холмы",
        ["deDE"] = "Grizzlyhügel",
        ["koKR"] = "회색 구릉지",
        ["esMX"] = "Colinas Pardas",
        ["enUS"] = true,
        ["frFR"] = "Les Grisonnes",
        ["esES"] = "Colinas Pardas",
        ["zhTW"] = "灰白之丘",
        ["zhCN"] = "灰熊丘陵",
    },
    ["Grizzlemaw"] = {
        ["ptBR"] = "Bocaina Velha",
        ["ruRU"] = "Седая Пасть",
        ["deDE"] = "Grauschlund",
        ["koKR"] = "회색구렁 요새",
        ["esMX"] = "Fauceparda",
        ["enUS"] = true,
        ["frFR"] = "Grisegueule",
        ["esES"] = "Fauceparda",
        ["zhTW"] = "灰喉鎮",
        ["zhCN"] = "灰喉堡",
    },
    ["Howling Fjord"] = {
        ["ptBR"] = "Fiorde Uivante",
        ["ruRU"] = "Ревущий фьорд",
        ["deDE"] = "Der heulende Fjord",
        ["koKR"] = "울부짖는 협만",
        ["esMX"] = "Fiordo Aquilonal",
        ["enUS"] = true,
        ["frFR"] = "Fjord Hurlant",
        ["esES"] = "Fiordo Aquilonal",
        ["zhTW"] = "凜風峽灣",
        ["zhCN"] = "嚎风峡湾",
    },
    ["Crystalsong Forest"] = {
        ["ptBR"] = "Floresta do Canto Cristalino",
        ["ruRU"] = "Лес Хрустальной Песни",
        ["deDE"] = "Kristallsangwald",
        ["koKR"] = "수정노래 숲",
        ["esMX"] = "Bosque Canto de Cristal",
        ["enUS"] = true,
        ["frFR"] = "Forêt du Chant de cristal",
        ["esES"] = "Bosque Canto de Cristal",
        ["zhTW"] = "水晶之歌森林",
        ["zhCN"] = "晶歌森林",
    },
    ["The Frozen Sea"] = {
        ["ptBR"] = "Mar Congelado",
        ["ruRU"] = "Ледяное море",
        ["deDE"] = "Die gefrorene See",
        ["koKR"] = "얼어붙은 바다",
        ["esMX"] = "El Mar Gélido",
        ["enUS"] = true,
        ["frFR"] = "La mer Gelée",
        ["esES"] = "El Mar Gélido",
        ["zhTW"] = "冰凍之海",
        ["zhCN"] = "冰冻之海",
    },
    ["Daggercap Bay"] = {
        ["ptBR"] = "Baía das Adagas",
        ["ruRU"] = "Бухта Кинжалов",
        ["deDE"] = "Dolchbucht",
        ["koKR"] = "비수집 만",
        ["esMX"] = "Bahía Cubredaga",
        ["enUS"] = true,
        ["frFR"] = "Baie de Coiffedague",
        ["esES"] = "Bahía Cubredaga",
        ["zhTW"] = "匕鞘海灣",
        ["zhCN"] = "匕鞘湾",
    },
    ["Valgarde"] = {
        ["ptBR"] = "Valgarde",
        ["ruRU"] = "Валгард",
        ["deDE"] = "Valgarde",
        ["koKR"] = "발가드",
        ["esMX"] = "Valgarde",
        ["enUS"] = true,
        ["frFR"] = "Valgarde",
        ["esES"] = "Valgarde",
        ["zhTW"] = "瓦爾加德",
        ["zhCN"] = "瓦加德",
    },
    ["Wyrmskull Village"] = {
        ["ptBR"] = "Aldeia Caveira de Dragão",
        ["ruRU"] = "Деревня Драконьего Черепа",
        ["deDE"] = "Wyrmskol",
        ["koKR"] = "고룡해골 마을",
        ["esMX"] = "Poblado Calavermis",
        ["enUS"] = true,
        ["frFR"] = "Crâne-du-ver",
        ["esES"] = "Poblado Calavermis",
        ["zhTW"] = "龍顱村",
        ["zhCN"] = "龙颅村",
    },
    ["Nifflevar"] = {
        ["ptBR"] = "Niffelvar",
        ["ruRU"] = "Ниффлвар",
        ["deDE"] = "Niffelvar",
        ["koKR"] = "니플바르",
        ["esMX"] = "Nafsavar",
        ["enUS"] = true,
        ["frFR"] = "Nifflevar",
        ["esES"] = "Nafsavar",
        ["zhTW"] = "尼弗瓦",
        ["zhCN"] = "尼弗莱瓦",
    },
    ["Falls of Ymiron"] = {
        ["ptBR"] = "Salto de Ymiron",
        ["ruRU"] = "Водопады Имирона",
        ["deDE"] = "Ymironfälle",
        ["koKR"] = "이미론의 폭포",
        ["esMX"] = "Cataratas de Ymiron",
        ["enUS"] = true,
        ["frFR"] = "Chutes d'Ymiron",
        ["esES"] = "Cataratas de Ymiron",
        ["zhTW"] = "依米倫瀑布",
        ["zhCN"] = "伊米隆瀑布",
    },
    ["Echo Reach"] = {
        ["ptBR"] = "Rincão do Eco",
        ["ruRU"] = "Край Эха",
        ["deDE"] = "Echoweiten",
        ["koKR"] = "메아리치는 바다",
        ["esMX"] = "Risco del Eco",
        ["enUS"] = true,
        ["frFR"] = "Les confins de l'écho",
        ["esES"] = "Risco del Eco",
        ["zhTW"] = "回音之境",
        ["zhCN"] = "回音海滩",
    },
    ["The Isle of Spears"] = {
        ["ptBR"] = "Ilha das Lanças",
        ["ruRU"] = "Остров Копий",
        ["deDE"] = "Die Insel der Speere",
        ["koKR"] = "작살잡이 섬",
        ["esMX"] = "La Isla de las Lanzas",
        ["enUS"] = true,
        ["frFR"] = "L'île des Lances",
        ["esES"] = "La Isla de las Lanzas",
        ["zhTW"] = "群矛之島",
        ["zhCN"] = "长矛岛",
    },
    ["Kamagua"] = {
        ["ptBR"] = "Kamagua",
        ["ruRU"] = "Камагуа",
        ["deDE"] = "Kamagua",
        ["koKR"] = "카마구아",
        ["esMX"] = "Komawa",
        ["enUS"] = true,
        ["frFR"] = "Kamagua",
        ["esES"] = "Komawa",
        ["zhTW"] = "卡瑪廓",
        ["zhCN"] = "卡玛古",
    },
    ["Garvan's Reef"] = {
        ["ptBR"] = "Recife Garvan",
        ["ruRU"] = "Риф Гарвана",
        ["deDE"] = "Garvans Riff",
        ["koKR"] = "가반의 산호초",
        ["esMX"] = "Arrecife de Garvan",
        ["enUS"] = true,
        ["frFR"] = "Récif de Garvan",
        ["esES"] = "Arrecife de Garvan",
        ["zhTW"] = "加爾文暗礁",
        ["zhCN"] = "加维暗礁",
    },
    ["Scalawag Point"] = {
        ["ptBR"] = "Angra dos Malandros",
        ["ruRU"] = "Лагерь Скалаваг",
        ["deDE"] = "Halunkeneck",
        ["koKR"] = "해적 야영지",
        ["esMX"] = "Cabo Pillastre",
        ["enUS"] = true,
        ["frFR"] = "Cap du Forban",
        ["esES"] = "Cabo Pillastre",
        ["zhTW"] = "無賴角",
        ["zhCN"] = "无赖港",
    },
    ["New Agamand"] = {
        ["ptBR"] = "Nova Agamand",
        ["ruRU"] = "Новый Агамонд",
        ["deDE"] = "Neu-Agamand",
        ["koKR"] = "신 아가만드",
        ["esMX"] = "Nuevo Agamand",
        ["enUS"] = true,
        ["frFR"] = "Nouvelle-Agamand",
        ["esES"] = "Nuevo Agamand",
        ["zhTW"] = "新阿加曼德",
        ["zhCN"] = "新阿加曼德",
    },
    ["The Ancient Lift"] = {
        ["ptBR"] = "Elevador Ancestral",
        ["ruRU"] = "Древний подъемник",
        ["deDE"] = "Der Uralte Aufzug",
        ["koKR"] = "고대 승강장",
        ["esMX"] = "El Antiguo Elevador",
        ["enUS"] = true,
        ["frFR"] = "L'antique élévateur",
        ["esES"] = "El Antiguo Elevador",
        ["zhTW"] = "遠古升降梯",
        ["zhCN"] = "上古升降梯",
    },
    ["Westguard Turret"] = {
        ["ptBR"] = "Torreta da Guarda Oeste",
        ["ruRU"] = "Башня Западной Стражи",
        ["deDE"] = "Turm der Westwacht",
        ["koKR"] = "서부경비대 포탑",
        ["esMX"] = "Torreta de la Guardia Oeste",
        ["enUS"] = true,
        ["frFR"] = "Tourelle de la Garde de l'ouest",
        ["esES"] = "Torreta de la Guardia Oeste",
        ["zhTW"] = "鎮西砲塔",
        ["zhCN"] = "西部卫戍要塞塔楼",
    },
    ["Halgrind"] = {
        ["ptBR"] = "Halgrind",
        ["ruRU"] = "Халгринд",
        ["deDE"] = "Halgrind",
        ["koKR"] = "할그린드",
        ["esMX"] = "Haltorboll",
        ["enUS"] = true,
        ["frFR"] = "Halegrince",
        ["esES"] = "Haltorboll",
        ["zhTW"] = "霍葛萊",
        ["zhCN"] = "哈尔格林德",
    },
    ["The Laughing Stand"] = {
        ["ptBR"] = "Ponta Gargalhante",
        ["ruRU"] = "Веселая стоянка",
        ["deDE"] = "Der Lachende Stützpunkt",
        ["koKR"] = "웃음소리 해안",
        ["esMX"] = "La Playa Rompeolas",
        ["enUS"] = true,
        ["frFR"] = "La grève Rieuse",
        ["esES"] = "La Playa Rompeolas",
        ["zhTW"] = "可笑的看臺",
        ["zhCN"] = "欢笑之台",
    },
    ["Baelgun's Excavation Site"] = {
        ["ptBR"] = "Sítio de Escavação de Baelgun",
        ["ruRU"] = "Раскопки Бейлгуна",
        ["deDE"] = "Baelguns Ausgrabungsstätte",
        ["koKR"] = "바엘군의 발굴현장",
        ["esMX"] = "Excavación de Baelgun",
        ["enUS"] = true,
        ["frFR"] = "Excavations de Baelgun",
        ["esES"] = "Excavación de Baelgun",
        ["zhTW"] = "巴爾古恩挖掘場",
        ["zhCN"] = "巴尔古挖掘场",
    },
    ["Explorers' League Outpost"] = {
        ["ptBR"] = "Posto Avançado da Liga dos Exploradores",
        ["ruRU"] = "Лагерь Лиги Исследователей",
        ["deDE"] = "Außenposten der Forscherliga",
        ["koKR"] = "탐험가 연맹 전초기지",
        ["esMX"] = "Avanzada de la Liga de Expedicionarios",
        ["enUS"] = true,
        ["frFR"] = "Avant-poste de la Ligue des explorateurs",
        ["esES"] = "Avanzada de la Liga de Expedicionarios",
        ["zhTW"] = "探險者協會前哨",
        ["zhCN"] = "探险者协会哨站",
    },
    ["Westguard Keep"] = {
        ["ptBR"] = "Bastilha da Guarda Oeste",
        ["ruRU"] = "Крепость Западной Стражи",
        ["deDE"] = "Westwacht",
        ["koKR"] = "서부경비대 성채",
        ["esMX"] = "Fortaleza de la Guardia Oeste",
        ["enUS"] = true,
        ["frFR"] = "Donjon de la Garde de l'ouest",
        ["esES"] = "Fortaleza de la Guardia Oeste",
        ["zhTW"] = "鎮西要塞",
        ["zhCN"] = "西部卫戍要塞",
    },
    ["Steel Gate"] = {
        ["ptBR"] = "Portão de Aço",
        ["ruRU"] = "Стальные ворота",
        ["deDE"] = "Das Stählerne Tor",
        ["koKR"] = "강철 관문",
        ["esMX"] = "Las Puertas de Acero",
        ["enUS"] = true,
        ["frFR"] = "Porte d'acier",
        ["esES"] = "Las Puertas de Acero",
        ["zhTW"] = "鋼鐵之門",
        ["zhCN"] = "钢铁之门",
    },
    ["Vengeance Landing"] = {
        ["ptBR"] = "Porto Vendeta",
        ["ruRU"] = "Лагерь Возмездия",
        ["deDE"] = "Hafen der Vergeltung",
        ["koKR"] = "복수의 상륙지",
        ["esMX"] = "Campo Venganza",
        ["enUS"] = true,
        ["frFR"] = "Accostage de la Vengeance",
        ["esES"] = "Campo Venganza",
        ["zhTW"] = "復仇臺地",
        ["zhCN"] = "复仇港",
    },
    ["Baleheim"] = {
        ["ptBR"] = "Baleheim",
        ["ruRU"] = "Гибльхейм",
        ["deDE"] = "Quälheim",
        ["koKR"] = "베일하임",
        ["esMX"] = "Baleheim",
        ["enUS"] = true,
        ["frFR"] = "Torvheim",
        ["esES"] = "Baleheim",
        ["zhTW"] = "貝爾海姆",
        ["zhCN"] = "拜尔海姆",
    },
    ["Skorn"] = {
        ["ptBR"] = "Skorn",
        ["ruRU"] = "Скорн",
        ["deDE"] = "Skorn",
        ["koKR"] = "스코른",
        ["esMX"] = "Skorn",
        ["enUS"] = true,
        ["frFR"] = "Mörg",
        ["esES"] = "Skorn",
        ["zhTW"] = "斯考恩",
        ["zhCN"] = "斯克恩",
    },
    ["Fort Wildervar"] = {
        ["ptBR"] = "Forte Vildervar",
        ["ruRU"] = "Крепость Вилдервар",
        ["deDE"] = "Fort Wildervar",
        ["koKR"] = "빌더바르 요새",
        ["esMX"] = "Fuerte Vildervar",
        ["enUS"] = true,
        ["frFR"] = "Fort Hardivar",
        ["esES"] = "Fuerte Vildervar",
        ["zhTW"] = "威德瓦堡壘",
        ["zhCN"] = "维德瓦堡垒",
    },
    ["Vileprey Village"] = {
        ["ptBR"] = "Aldeia Presabjeta",
        ["ruRU"] = "Деревня Жестокой Травли",
        ["deDE"] = "Vil'prajidorf",
        ["koKR"] = "썩은수렵 마을",
        ["esMX"] = "Poblado Presavil",
        ["enUS"] = true,
        ["frFR"] = "Vileproie",
        ["esES"] = "Poblado Presavil",
        ["zhTW"] = "鄙掠村",
        ["zhCN"] = "邪猎村",
    },
    ["Ivald's Ruin"] = {
        ["ptBR"] = "Ruína de Ivald",
        ["ruRU"] = "Руины Ивальда",
        ["deDE"] = "Ivalds Ruine",
        ["koKR"] = "이발드의 폐허",
        ["esMX"] = "Ruinas de Ivald",
        ["enUS"] = true,
        ["frFR"] = "Ruines d'Ivald",
        ["esES"] = "Ruinas de Ivald",
        ["zhTW"] = "伊瓦德遺跡",
        ["zhCN"] = "伊瓦尔德废墟",
    },
    ["Gjalerbron"] = {
        ["ptBR"] = "Gjalerbron",
        ["ruRU"] = "Гьялерброн",
        ["deDE"] = "Gjalerbron",
        ["koKR"] = "샬레르브론",
        ["esMX"] = "Gjalerbron",
        ["enUS"] = true,
        ["frFR"] = "Gjalerbron",
        ["esES"] = "Gjalerbron",
        ["zhTW"] = "夏勒布隆",
        ["zhCN"] = "亚勒伯龙",
    },
    ["Tomb of the Lost Kings"] = {
        ["ptBR"] = "Tumba dos Reis Perdidos",
        ["ruRU"] = "Могила Побежденных Королей",
        ["deDE"] = "Gruft der verlorenen Könige",
        ["koKR"] = "왕의 무덤",
        ["esMX"] = "Tumba de los Reyes Perdidos",
        ["enUS"] = true,
        ["frFR"] = "Tombeau des Rois perdus",
        ["esES"] = "Tumba de los Reyes Perdidos",
        ["zhTW"] = "逝王陵墓",
        ["zhCN"] = "失落王者之墓",
    },
    ["Camp Winterhoof"] = {
        ["ptBR"] = "Aldeia Casco Invernal",
        ["ruRU"] = "Лагерь Заиндевевшего Копыта",
        ["deDE"] = "Lager der Winterhufe",
        ["koKR"] = "겨울발굽 야영지",
        ["esMX"] = "Campamento Pezuña Invernal",
        ["enUS"] = true,
        ["frFR"] = "Camp Sabot-d'hiver",
        ["esES"] = "Campamento Pezuña Invernal",
        ["zhTW"] = "冬蹄營地",
        ["zhCN"] = "冬蹄营地",
    },
    ["Development Land"] = {
        ["ptBR"] = "Área em Desenvolvimento",
        ["ruRU"] = "Зона разработчика",
        ["deDE"] = "Entwicklungsland",
        ["koKR"] = "진화의 대지",
        ["esMX"] = "Tierra de Desarrollo",
        ["enUS"] = true,
        ["frFR"] = "Terrain en développement",
        ["esES"] = "Tierra de Desarrollo",
        ["zhTW"] = "開發之地",
        ["zhCN"] = "Development Land",
    },
    ["Mightstone Quarry"] = {
        ["ptBR"] = "Pedreira do Megalito",
        ["ruRU"] = "Карьер Камня Силы",
        ["deDE"] = "Großfelsbruch",
        ["koKR"] = "퇴마석 채석장",
        ["esMX"] = "Cantera de Piedra de Poderío",
        ["enUS"] = true,
        ["frFR"] = "Carrière de pierres de pouvoir",
        ["esES"] = "Cantera de Piedra de Poderío",
        ["zhTW"] = "力石礦場",
        ["zhCN"] = "巨石采掘场",
    },
    ["Bloodspore Plains"] = {
        ["ptBR"] = "Planícies Sanguesporo",
        ["ruRU"] = "Равнины Кровавых Спор",
        ["deDE"] = "Blutsporenprärie",
        ["koKR"] = "핏빛포자 평원",
        ["esMX"] = "Llanuras Sanguiespora",
        ["enUS"] = true,
        ["frFR"] = "Plaines de Spore-sang",
        ["esES"] = "Llanuras Sanguiespora",
        ["zhTW"] = "血孢平原",
        ["zhCN"] = "血孢平原",
    },
    ["Gammoth"] = {
        ["ptBR"] = "Gamute",
        ["ruRU"] = "Гаммот",
        ["deDE"] = "Gammut",
        ["koKR"] = "감모스",
        ["esMX"] = "Gammoth",
        ["enUS"] = true,
        ["frFR"] = "Gammoth",
        ["esES"] = "Gammoth",
        ["zhTW"] = "甘默斯",
        ["zhCN"] = "迦莫斯",
    },
    ["Amber Ledge"] = {
        ["ptBR"] = "Promontório Âmbar",
        ["ruRU"] = "Янтарная гряда",
        ["deDE"] = "Bernsteinflöz",
        ["koKR"] = "호박석 절벽",
        ["esMX"] = "El Saliente Ámbar",
        ["enUS"] = true,
        ["frFR"] = "Escarpement d'Ambre",
        ["esES"] = "El Saliente Ámbar",
        ["zhTW"] = "琥珀岩臺",
        ["zhCN"] = "琥珀崖",
    },
    ["Coldarra"] = {
        ["ptBR"] = "Gelarra",
        ["ruRU"] = "Хладарра",
        ["deDE"] = "Kaltarra",
        ["koKR"] = "콜다라",
        ["esMX"] = "Gelidar",
        ["enUS"] = true,
        ["frFR"] = "Frimarra",
        ["esES"] = "Gelidar",
        ["zhTW"] = "凜懼島",
        ["zhCN"] = "考达拉",
    },
    ["The Westrift"] = {
        ["ptBR"] = "Fenda Ocidental",
        ["ruRU"] = "Западная расселина",
        ["deDE"] = "Die Westklamm",
        ["koKR"] = "서부 균열",
        ["esMX"] = "La Falla Oeste",
        ["enUS"] = true,
        ["frFR"] = "La Faille-Ouest",
        ["esES"] = "La Falla Oeste",
        ["zhTW"] = "西裂峽",
        ["zhCN"] = "西部裂谷",
    },
    ["The Transitus Stair"] = {
        ["ptBR"] = "Escada Transitus",
        ["ruRU"] = "Промежуточная лестница",
        ["deDE"] = "Die Transitustreppe",
        ["koKR"] = "변위의 계단",
        ["esMX"] = "La Escalera de Tránsito",
        ["enUS"] = true,
        ["frFR"] = "L'escalier Transitus",
        ["esES"] = "La Escalera de Tránsito",
        ["zhTW"] = "隘境梯臺",
        ["zhCN"] = "永生之阶",
    },
    ["Coast of Echoes"] = {
        ["ptBR"] = "Costa do Eco",
        ["ruRU"] = "Берег Эха",
        ["deDE"] = "Echoküste",
        ["koKR"] = "메아리 해안",
        ["esMX"] = "Costa de los Ecos",
        ["enUS"] = true,
        ["frFR"] = "Côte des Échos",
        ["esES"] = "Costa de los Ecos",
        ["zhTW"] = "回聲海岸",
        ["zhCN"] = "回音海岸",
    },
    ["Riplash Strand"] = {
        ["ptBR"] = "Areal Quebramar",
        ["ruRU"] = "Берег Терзающего Бича",
        ["deDE"] = "Strand der Peitschennarbe",
        ["koKR"] = "채찍파도 해안",
        ["esMX"] = "Litoral Tralladón",
        ["enUS"] = true,
        ["frFR"] = "Grève des Courcinglants",
        ["esES"] = "Litoral Tralladón",
        ["zhTW"] = "裂鞭水岸",
        ["zhCN"] = "裂鞭海岸",
    },
    ["Riplash Ruins"] = {
        ["ptBR"] = "Ruínas Quebramar",
        ["ruRU"] = "Руины Терзающего Бича",
        ["deDE"] = "Ruinen der Peitschennarbe",
        ["koKR"] = "채찍파도 폐허",
        ["esMX"] = "Ruinas Tralladón",
        ["enUS"] = true,
        ["frFR"] = "Ruines des Courcinglants",
        ["esES"] = "Ruinas Tralladón",
        ["zhTW"] = "裂鞭遺跡",
        ["zhCN"] = "裂鞭废墟",
    },
    ["Coast of Idols"] = {
        ["ptBR"] = "Costa dos Ídolos",
        ["ruRU"] = "Берег истуканов",
        ["deDE"] = "Küste der Götzen",
        ["koKR"] = "우상 해안",
        ["esMX"] = "Costa de los Ídolos",
        ["enUS"] = true,
        ["frFR"] = "Côte des Idoles",
        ["esES"] = "Costa de los Ídolos",
        ["zhTW"] = "巨像海岸",
        ["zhCN"] = "巨像海岸",
    },
    ["Pal'ea"] = {
        ["ptBR"] = "Pal'ea",
        ["ruRU"] = "Пал'иа",
        ["deDE"] = "Pal'ea",
        ["koKR"] = "팔에아",
        ["esMX"] = "Pal'ea",
        ["enUS"] = true,
        ["frFR"] = "Pal'ea",
        ["esES"] = "Pal'ea",
        ["zhTW"] = "帕雷亞",
        ["zhCN"] = "帕尔依",
    },
    ["Valiance Keep"] = {
        ["ptBR"] = "Bastilha Valentia",
        ["ruRU"] = "Крепость Отваги",
        ["deDE"] = "Valianzfeste",
        ["koKR"] = "용맹의 성채",
        ["esMX"] = "Fortaleza Denuedo",
        ["enUS"] = true,
        ["frFR"] = "Donjon de la Bravoure",
        ["esES"] = "Fortaleza Denuedo",
        ["zhTW"] = "驍勇要塞",
        ["zhCN"] = "无畏要塞",
    },
    ["Winterfin Village"] = {
        ["ptBR"] = "Aldeia Falésia Invernal",
        ["ruRU"] = "Деревня Зимних Плавников",
        ["deDE"] = "Dorf der Winterflossen",
        ["koKR"] = "겨울지느러미 마을",
        ["esMX"] = "Poblado Aleta Invernal",
        ["enUS"] = true,
        ["frFR"] = "Aileron-d'hiver",
        ["esES"] = "Poblado Aleta Invernal",
        ["zhTW"] = "冬鰭村",
        ["zhCN"] = "冬鳞村",
    },
    ["Taunka'le Village"] = {
        ["ptBR"] = "Aldeia Taunka'le",
        ["ruRU"] = "Деревня Таунка'ле",
        ["deDE"] = "Taunka'le",
        ["koKR"] = "타운카르 마을",
        ["esMX"] = "Poblado Taunka'le",
        ["enUS"] = true,
        ["frFR"] = "Taunka'le",
        ["esES"] = "Poblado Taunka'le",
        ["zhTW"] = "坦卡雷村",
        ["zhCN"] = "牦牛村",
    },
    ["Magnamoth Caverns"] = {
        ["ptBR"] = "Caverna Magnatraça",
        ["ruRU"] = "Пещеры Магнамух",
        ["deDE"] = "Magnamuthöhlen",
        ["koKR"] = "마그나모스 동글",
        ["esMX"] = "Cavernas Magnamoth",
        ["enUS"] = true,
        ["frFR"] = "Cavernes de Magnamoth",
        ["esES"] = "Cavernas Magnamoth",
        ["zhTW"] = "瑪格納默斯洞窟",
        ["zhCN"] = "猛犸人洞穴",
    },
    ["Coldrock Quarry"] = {
        ["ptBR"] = "Pedreira da Rocha Fria",
        ["ruRU"] = "Карьер Ледяного Булыжника",
        ["deDE"] = "Froststeinbruch",
        ["koKR"] = "얼음바위 채석장",
        ["esMX"] = "Cantera Frioescollo",
        ["enUS"] = true,
        ["frFR"] = "Carrière de Rochefroide",
        ["esES"] = "Cantera Frioescollo",
        ["zhTW"] = "冷岩礦場",
        ["zhCN"] = "冷石采掘场",
    },
    ["Njord's Breath Bay"] = {
        ["ptBR"] = "Baía do Bafo de Njord",
        ["ruRU"] = "Бухта Дыхания Ньорда",
        ["deDE"] = "Bucht des Njordatems",
        ["koKR"] = "요르드의 숨결 만",
        ["esMX"] = "Bahía Aliento de Njord",
        ["enUS"] = true,
        ["frFR"] = "Baie du Souffle de Njord",
        ["esES"] = "Bahía Aliento de Njord",
        ["zhTW"] = "尼約德之息海灣",
        ["zhCN"] = "尼约德海湾",
    },
    ["Kaskala"] = {
        ["ptBR"] = "Kaskala",
        ["ruRU"] = "Каскала",
        ["deDE"] = "Kaskala",
        ["koKR"] = "카스칼라",
        ["esMX"] = "Kashala",
        ["enUS"] = true,
        ["frFR"] = "Kaskala",
        ["esES"] = "Kashala",
        ["zhTW"] = "卡斯卡拉",
        ["zhCN"] = "卡斯卡拉",
    },
    ["Transborea"] = {
        ["ptBR"] = "Transbórea",
        ["ruRU"] = "Трансборея",
        ["deDE"] = "Transborea",
        ["koKR"] = "북풍길",
        ["esMX"] = "Transborea",
        ["enUS"] = true,
        ["frFR"] = "Transborée",
        ["esES"] = "Transborea",
        ["zhTW"] = "越風之地",
        ["zhCN"] = "横贯冰原",
    },
    ["Ember Clutch"] = {
        ["ptBR"] = "Ninho Incandescente",
        ["ruRU"] = "Пылающее Гнездовье",
        ["deDE"] = "Glutstätte",
        ["koKR"] = "잿불의 손아귀",
        ["esMX"] = "Encierro Ámbar",
        ["enUS"] = true,
        ["frFR"] = "Étreinte de braise",
        ["esES"] = "Encierro Ámbar",
        ["zhTW"] = "餘燼窩巢",
        ["zhCN"] = "灰烬龙巢",
    },
    ["Derelict Strand"] = {
        ["ptBR"] = "Praia do Naufrágio",
        ["ruRU"] = "Обнажившееся дно",
        ["deDE"] = "Verlassener Strand",
        ["koKR"] = "적막한 해안",
        ["esMX"] = "Playa Derelicta",
        ["enUS"] = true,
        ["frFR"] = "Grève des Épaves",
        ["esES"] = "Playa Derelicta",
        ["zhTW"] = "遺棄水岸",
        ["zhCN"] = "荒弃海岸",
    },
    ["The Frozen Glade"] = {
        ["ptBR"] = "A Clareira Congelada",
        ["ruRU"] = "Заиндевевшая поляна",
        ["deDE"] = "Gefrorene Lichtung",
        ["koKR"] = "얼어붙은 숲",
        ["esMX"] = "El Claro Helado",
        ["enUS"] = true,
        ["frFR"] = "La clairière Gelée",
        ["esES"] = "El Claro Helado",
        ["zhTW"] = "冰凍林地",
        ["zhCN"] = "冰雪林地",
    },
    ["The Vibrant Glade"] = {
        ["ptBR"] = "Clareira Vibrante",
        ["ruRU"] = "Светлая поляна",
        ["deDE"] = "Lebendige Lichtung",
        ["koKR"] = "활력의 숲",
        ["esMX"] = "El Claro Vibrante",
        ["enUS"] = true,
        ["frFR"] = "La clairière Vibrante",
        ["esES"] = "El Claro Vibrante",
        ["zhTW"] = "鮮亮林地",
        ["zhCN"] = "活力之林",
    },
    ["The Twisted Glade"] = {
        ["ptBR"] = "Clareira Deformada",
        ["ruRU"] = "Холмистая поляна",
        ["deDE"] = "Siechende Lichtung",
        ["koKR"] = "뒤틀린 숲",
        ["esMX"] = "El Claro Retorcido",
        ["enUS"] = true,
        ["frFR"] = "La clairière Tordue",
        ["esES"] = "El Claro Retorcido",
        ["zhTW"] = "扭曲林地",
        ["zhCN"] = "扭曲之林",
    },
    ["Rivenwood"] = {
        ["ptBR"] = "Bosque Fendido",
        ["ruRU"] = "Вырубки",
        ["deDE"] = "Bruchwald",
        ["koKR"] = "비틀린 숲",
        ["esMX"] = "El Bosque Hendido",
        ["enUS"] = true,
        ["frFR"] = "Clivebois",
        ["esES"] = "El Bosque Hendido",
        ["zhTW"] = "裂木森林",
        ["zhCN"] = "裂木森林",
    },
    ["Caldemere Lake"] = {
        ["ptBR"] = "Lago Caldemere",
        ["ruRU"] = "Озеро Холдомир",
        ["deDE"] = "Kaldemaarsee",
        ["koKR"] = "칼더미어 호수",
        ["esMX"] = "Lago Caldemere",
        ["enUS"] = true,
        ["frFR"] = "Lac Caldemere",
        ["esES"] = "Lago Caldemere",
        ["zhTW"] = "凱德米爾湖",
        ["zhCN"] = "凯德米尔湖",
    },
    ["Utgarde Catacombs"] = {
        ["ptBR"] = "Catacumbas de Utgarde",
        ["ruRU"] = "Катакомбы Утгард",
        ["deDE"] = "Katakomben von Utgarde",
        ["koKR"] = "우트가드 지하묘지",
        ["esMX"] = "Catacumbas de Utgarde",
        ["enUS"] = true,
        ["frFR"] = "Catacombes d'Utgarde",
        ["esES"] = "Catacumbas de Utgarde",
        ["zhTW"] = "俄特加德墓窖",
        ["zhCN"] = "乌特加德墓穴",
    },
    ["Shield Hill"] = {
        ["ptBR"] = "Monte Égide",
        ["ruRU"] = "Заградительный холм",
        ["deDE"] = "Schildhügel",
        ["koKR"] = "방패 언덕",
        ["esMX"] = "Colina Escudo",
        ["enUS"] = true,
        ["frFR"] = "Colline du Bouclier",
        ["esES"] = "Colina Escudo",
        ["zhTW"] = "盾丘",
        ["zhCN"] = "盾牌岭",
    },
    ["Lake Cauldros"] = {
        ["ptBR"] = "Lago Cauldros",
        ["ruRU"] = "Озеро Колдрос",
        ["deDE"] = "Kaldrossee",
        ["koKR"] = "카울드로스 호수",
        ["esMX"] = "Lago Caldros",
        ["enUS"] = true,
        ["frFR"] = "Lac Calderos",
        ["esES"] = "Lago Caldros",
        ["zhTW"] = "科德洛斯湖",
        ["zhCN"] = "考杜斯湖",
    },
    ["Cauldros Isle"] = {
        ["ptBR"] = "Ilha Cauldros",
        ["ruRU"] = "Остров Колдрос",
        ["deDE"] = "Kaldrosinsel",
        ["koKR"] = "카울드로스 섬",
        ["esMX"] = "Isla Caldros",
        ["enUS"] = true,
        ["frFR"] = "Île Calderos",
        ["esES"] = "Isla Caldros",
        ["zhTW"] = "科德洛斯島",
        ["zhCN"] = "考杜斯岛",
    },
    ["Bleeding Vale"] = {
        ["ptBR"] = "Vale Sangrento",
        ["ruRU"] = "Кровоточащая долина",
        ["deDE"] = "Blutklamm",
        ["koKR"] = "피투성이 계곡",
        ["esMX"] = "Vega Sangrante",
        ["enUS"] = true,
        ["frFR"] = "Val Sanglant",
        ["esES"] = "Vega Sangrante",
        ["zhTW"] = "浴血谷",
        ["zhCN"] = "鲜血谷",
    },
    ["Giants' Run"] = {
        ["ptBR"] = "Passo do Gigante",
        ["ruRU"] = "Тропа Великанов",
        ["deDE"] = "Plateau der Riesen",
        ["koKR"] = "거인의 터",
        ["esMX"] = "El Paso del Gigante",
        ["enUS"] = true,
        ["frFR"] = "La piste des Géants",
        ["esES"] = "El Paso del Gigante",
        ["zhTW"] = "巨人小徑",
        ["zhCN"] = "巨人平原",
    },
    ["Apothecary Camp"] = {
        ["ptBR"] = "Acampamento da Sociedade dos Boticários",
        ["ruRU"] = "Аптекарский поселок",
        ["deDE"] = "Apothekerlager",
        ["koKR"] = "연금술사 야영지",
        ["esMX"] = "Campamento de los Boticarios",
        ["enUS"] = true,
        ["frFR"] = "Camp des Apothicaires",
        ["esES"] = "Campamento de los Boticarios",
        ["zhTW"] = "藥劑師營地",
        ["zhCN"] = "药剂师营地",
    },
    ["Ember Spear Tower"] = {
        ["ptBR"] = "Torre da Lança Incandescente",
        ["ruRU"] = "Тлеющая башня",
        ["deDE"] = "Glutspeerturm",
        ["koKR"] = "잿불창 경비탑",
        ["esMX"] = "Torre Lanza Ámbar",
        ["enUS"] = true,
        ["frFR"] = "Tour de la Lance de braise",
        ["esES"] = "Torre Lanza Ámbar",
        ["zhTW"] = "餘燼矛塔",
        ["zhCN"] = "灰烬长矛塔楼",
    },
    ["Shattered Straits"] = {
        ["ptBR"] = "Estreito dos Estilhaços",
        ["ruRU"] = "Пролив Кораблекрушений",
        ["deDE"] = "Straße der Trümmer",
        ["koKR"] = "부서진 해협",
        ["esMX"] = "Estrecho Devastado",
        ["enUS"] = true,
        ["frFR"] = "Les détroits Fracassés",
        ["esES"] = "Estrecho Devastado",
        ["zhTW"] = "破碎海峽",
        ["zhCN"] = "碎裂海峡",
    },
    ["Gjalerhorn"] = {
        ["ptBR"] = "Gjalehorn",
        ["ruRU"] = "Гьялерхорн",
        ["deDE"] = "Gjalerhorn",
        ["koKR"] = "샬레르호른",
        ["esMX"] = "Gjalercorn",
        ["enUS"] = true,
        ["frFR"] = "Gjalercorne",
        ["esES"] = "Gjalercorn",
        ["zhTW"] = "夏勒宏恩",
        ["zhCN"] = "亚勒霍恩",
    },
    ["Frostblade Peak"] = {
        ["ptBR"] = "Pico de Cunhalva",
        ["ruRU"] = "Вершина Ледяного Клинка",
        ["deDE"] = "Frostklingengipfel",
        ["koKR"] = "서릿날 봉우리",
        ["esMX"] = "Pico Filoescarcha",
        ["enUS"] = true,
        ["frFR"] = "Pic de Givrelame",
        ["esES"] = "Pico Filoescarcha",
        ["zhTW"] = "霜刃峰",
        ["zhCN"] = "霜刃峰",
    },
    ["West Spear Tower"] = {
        ["ptBR"] = "Torre da Lança Oeste",
        ["ruRU"] = "Западная башня",
        ["deDE"] = "Westspeerturm",
        ["koKR"] = "서부창 경비탑",
        ["esMX"] = "Torre Lanza del Oeste",
        ["enUS"] = true,
        ["frFR"] = "Tour de la Lance de l'ouest",
        ["esES"] = "Torre Lanza del Oeste",
        ["zhTW"] = "西矛哨塔",
        ["zhCN"] = "西部长矛塔楼",
    },
    ["North Spear Tower"] = {
        ["ptBR"] = "Torre da Lança Norte",
        ["ruRU"] = "Северная башня",
        ["deDE"] = "Nordspeerturm",
        ["koKR"] = "북부창 경비탑",
        ["esMX"] = "Torre Lanza del Norte",
        ["enUS"] = true,
        ["frFR"] = "Tour de la Lance du nord",
        ["esES"] = "Torre Lanza del Norte",
        ["zhTW"] = "北矛哨塔",
        ["zhCN"] = "北部长矛塔楼",
    },
    ["Chillmere Coast"] = {
        ["ptBR"] = "Costa da Água Fria",
        ["ruRU"] = "Берег Стылой Межи",
        ["deDE"] = "Küste des Frostmaares",
        ["koKR"] = "서릿발 해안",
        ["esMX"] = "Costafría",
        ["enUS"] = true,
        ["frFR"] = "Côte de Frissonde",
        ["esES"] = "Costafría",
        ["zhTW"] = "寒凜海岸",
        ["zhCN"] = "切米尔海岸",
    },
    ["Whisper Gulch"] = {
        ["ptBR"] = "Desfiladeiro dos Sussurros",
        ["ruRU"] = "Шепчущая теснина",
        ["deDE"] = "Flüsterschlucht",
        ["koKR"] = "속삭임 협곡",
        ["esMX"] = "Garganta Susurro",
        ["enUS"] = true,
        ["frFR"] = "Goulet des Murmures",
        ["esES"] = "Garganta Susurro",
        ["zhTW"] = "低語峽谷",
        ["zhCN"] = "低语峡谷",
    },
    ["Sub zone"] = {
        ["ptBR"] = "Subárea",
        ["ruRU"] = "Sub zone",
        ["deDE"] = "Subzone",
        ["koKR"] = "세부 지역",
        ["esMX"] = "Subzona",
        ["enUS"] = true,
        ["frFR"] = "Sous-zone",
        ["esES"] = "Subzona",
        ["zhTW"] = "子區域",
        ["zhCN"] = "Sub zone",
    },
    ["Winter's Terrace"] = {
        ["ptBR"] = "Terraço do Inverno",
        ["ruRU"] = "Зимняя терраса",
        ["deDE"] = "Terrasse des Winters",
        ["koKR"] = "겨울 단상",
        ["esMX"] = "Bancal del Invierno",
        ["enUS"] = true,
        ["frFR"] = "Terrasse de l'Hiver",
        ["esES"] = "Bancal del Invierno",
        ["zhTW"] = "冬之殿堂",
        ["zhCN"] = "寒冬大厅",
    },
    ["The Waking Halls"] = {
        ["ptBR"] = "Salões do Despertar",
        ["ruRU"] = "Чертоги Пробуждения",
        ["deDE"] = "Die Hallen des Erwachens",
        ["koKR"] = "각성의 전당",
        ["esMX"] = "Las Salas del Despertar",
        ["enUS"] = true,
        ["frFR"] = "Les salles de l'Éveil",
        ["esES"] = "Las Salas del Despertar",
        ["zhTW"] = "喚醒之廳",
        ["zhCN"] = "苏醒之厅",
    },
    ["Sorlof's Strand"] = {
        ["ptBR"] = "Praia de Sorlof",
        ["ruRU"] = "Берег Сорлофа",
        ["deDE"] = "Sorlofs Strand",
        ["koKR"] = "소를로프의 해안",
        ["esMX"] = "Playa de Sorlof",
        ["enUS"] = true,
        ["frFR"] = "La grève de Sorlof",
        ["esES"] = "Playa de Sorlof",
        ["zhTW"] = "索洛夫水岸",
        ["zhCN"] = "索罗夫海岸",
    },
    ["Frostblade Pass"] = {
        ["ptBR"] = "Desfiladeiro de Cunhalva",
        ["ruRU"] = "Перевал Ледяного Клинка",
        ["deDE"] = "Frostklingenpass",
        ["koKR"] = "서릿날 고개",
        ["esMX"] = "Paso Filoescarcha",
        ["enUS"] = true,
        ["frFR"] = "Passe de Givrelame",
        ["esES"] = "Paso Filoescarcha",
        ["zhTW"] = "霜刃隘口",
        ["zhCN"] = "霜刃小径",
    },
    ["Claytön's WoWEdit Land"] = {
        ["ptBR"] = "Terra do WoWEdit do Claytön",
        ["ruRU"] = "Clayton's WoWEdit Land",
        ["deDE"] = "Claytön's WoWEdit Land",
        ["koKR"] = "클레이튼의 섬",
        ["esMX"] = "Claytön's WoWEdit Land",
        ["enUS"] = true,
        ["frFR"] = "Claytön's WoWEdit Land",
        ["esES"] = "Claytön's WoWEdit Land",
        ["zhTW"] = "克雷頓的WoW編輯地",
        ["zhCN"] = "Clayton's WoWEdit Land",
    },
    ["Winterfin Caverns"] = {
        ["ptBR"] = "Caverna Falésia Invernal",
        ["ruRU"] = "Пещеры Зимних Плавников",
        ["deDE"] = "Höhlen der Winterflossen",
        ["koKR"] = "겨울지느러미 동굴",
        ["esMX"] = "Cavernas Aleta Invernal",
        ["enUS"] = true,
        ["frFR"] = "Cavernes des Ailerons-d'hiver",
        ["esES"] = "Cavernas Aleta Invernal",
        ["zhTW"] = "冬鰭洞窟",
        ["zhCN"] = "冬鳞洞穴",
    },
    ["Glimmer Bay"] = {
        ["ptBR"] = "Baía Tremeluzente",
        ["ruRU"] = "Мерцающая бухта",
        ["deDE"] = "Glimmerbucht",
        ["koKR"] = "깜박임 만",
        ["esMX"] = "Bahía Titileo",
        ["enUS"] = true,
        ["frFR"] = "Baie Scintillante",
        ["esES"] = "Bahía Titileo",
        ["zhTW"] = "微光海灣",
        ["zhCN"] = "幽光海湾",
    },
    ["Winterfin Retreat"] = {
        ["ptBR"] = "Retiro da Falésia Invernal",
        ["ruRU"] = "Приют Зимних Плавников",
        ["deDE"] = "Zuflucht der Winterflossen",
        ["koKR"] = "겨울지느러미 은신처",
        ["esMX"] = "Refugio Aleta Invernal",
        ["enUS"] = true,
        ["frFR"] = "Retraite des Ailerons-d'hiver",
        ["esES"] = "Refugio Aleta Invernal",
        ["zhTW"] = "冬鰭避居地",
        ["zhCN"] = "冬鳞避难所",
    },
    ["The Culling of Stratholme"] = {
        ["ptBR"] = "Expurgo de Stratholme",
        ["ruRU"] = "Очищение Стратхольма",
        ["deDE"] = "Das Ausmerzen von Stratholme",
        ["koKR"] = "옛 스트라솔름",
        ["esMX"] = "La Matanza de Stratholme",
        ["enUS"] = true,
        ["frFR"] = "L'Épuration de Stratholme",
        ["esES"] = "La Matanza de Stratholme",
        ["zhTW"] = "斯坦索姆的抉擇",
        ["zhCN"] = "净化斯坦索姆",
    },
    ["Sands of Nasam"] = {
        ["ptBR"] = "Areias de Nasam",
        ["ruRU"] = "Пески Назама",
        ["deDE"] = "Sande von Nasam",
        ["koKR"] = "나삼의 갯벌",
        ["esMX"] = "Arenas de Nasam",
        ["enUS"] = true,
        ["frFR"] = "Sables de Nasam",
        ["esES"] = "Arenas de Nasam",
        ["zhTW"] = "納森沙地",
        ["zhCN"] = "纳萨姆沙地",
    },
    ["Krom's Landing"] = {
        ["ptBR"] = "Porto de Krom",
        ["ruRU"] = "Лагерь Крома",
        ["deDE"] = "Kroms Landeplatz",
        ["koKR"] = "크롬의 정박지",
        ["esMX"] = "Puerto de Krom",
        ["enUS"] = true,
        ["frFR"] = "Point d'ancrage de Krom",
        ["esES"] = "Puerto de Krom",
        ["zhTW"] = "克羅姆臺地",
        ["zhCN"] = "克罗姆的码头",
    },
    ["Nasam's Talon"] = {
        ["ptBR"] = "Garra de Nasam",
        ["ruRU"] = "Коготь Назама",
        ["deDE"] = "Nasams Klaue",
        ["koKR"] = "나삼의 발톱",
        ["esMX"] = "Garfa de Nasam",
        ["enUS"] = true,
        ["frFR"] = "La serre de Nasam",
        ["esES"] = "Garfa de Nasam",
        ["zhTW"] = "納森之爪",
        ["zhCN"] = "纳萨姆之爪",
    },
    ["Echo Cove"] = {
        ["ptBR"] = "Angra do Eco",
        ["ruRU"] = "Бухта Эха",
        ["deDE"] = "Echobucht",
        ["koKR"] = "메아리 동굴",
        ["esMX"] = "Cala del Eco",
        ["enUS"] = true,
        ["frFR"] = "Crique de l'Écho",
        ["esES"] = "Cala del Eco",
        ["zhTW"] = "回音灣",
        ["zhCN"] = "回音湾",
    },
    ["Beryl Point"] = {
        ["ptBR"] = "Penhasco de Berília",
        ["ruRU"] = "Берилловый лагерь",
        ["deDE"] = "Beryllspitze",
        ["koKR"] = "녹주석 거점",
        ["esMX"] = "Alto de Berilo",
        ["enUS"] = true,
        ["frFR"] = "Halte de Béryl",
        ["esES"] = "Alto de Berilo",
        ["zhTW"] = "碧晶哨點",
        ["zhCN"] = "蓝玉营地",
    },
    ["Garrosh's Landing"] = {
        ["ptBR"] = "Ancoradouro de Garrosh",
        ["ruRU"] = "Лагерь Гарроша",
        ["deDE"] = "Garroshs Landeplatz",
        ["koKR"] = "가로쉬의 상륙지",
        ["esMX"] = "Desembarco de Garrosh",
        ["enUS"] = true,
        ["frFR"] = "Point d'accostage de Garrosh",
        ["esES"] = "Desembarco de Garrosh",
        ["zhTW"] = "卡爾洛斯臺地",
        ["zhCN"] = "加尔鲁什码头",
    },
    ["Warsong Jetty"] = {
        ["ptBR"] = "Quebra-mar Brado Guerreiro",
        ["ruRU"] = "Пристань Песни Войны",
        ["deDE"] = "Landebrücke des Kriegshymnenklans",
        ["koKR"] = "전쟁노래부족 부두",
        ["esMX"] = "Malecón Grito de Guerra",
        ["enUS"] = true,
        ["frFR"] = "Jetée chanteguerre",
        ["esES"] = "Malecón Grito de Guerra",
        ["zhTW"] = "戰歌碼頭",
        ["zhCN"] = "战歌防波堤",
    },
    ["Fizzcrank Airstrip"] = {
        ["ptBR"] = "Pista de Pouso do Biela",
        ["ruRU"] = "Взлетная полоса Выкрутеня",
        ["deDE"] = "Landebahn Kurbelzisch",
        ["koKR"] = "피즈크랭크 비행장",
        ["esMX"] = "Pista de Aterrizaje de Palanqueta",
        ["enUS"] = true,
        ["frFR"] = "Piste d'atterrissage de Spumelevier",
        ["esES"] = "Pista de Aterrizaje de Palanqueta",
        ["zhTW"] = "嘶軸簡易機場",
        ["zhCN"] = "菲兹兰克机场",
    },
    ["Lake Kum'uya"] = {
        ["ptBR"] = "Lago Kum'uya",
        ["ruRU"] = "Озеро Кум'уа",
        ["deDE"] = "Kum'uyasee",
        ["koKR"] = "쿰우야 호수",
        ["esMX"] = "Lago Kum'uya",
        ["enUS"] = true,
        ["frFR"] = "Lac Kum'uya",
        ["esES"] = "Lago Kum'uya",
        ["zhTW"] = "庫姆亞湖",
        ["zhCN"] = "库姆亚湖",
    },
    ["Farshire Fields"] = {
        ["ptBR"] = "Campos de Algures",
        ["ruRU"] = "Поля Далечья",
        ["deDE"] = "Weiden von Fernhain",
        ["koKR"] = "파샤이어 농장",
        ["esMX"] = "Campos de Lindeallá",
        ["enUS"] = true,
        ["frFR"] = "Champs de Comté-lointaine",
        ["esES"] = "Campos de Lindeallá",
        ["zhTW"] = "遠郡原野",
        ["zhCN"] = "致远郡农场",
    },
    ["Farshire"] = {
        ["ptBR"] = "Algures",
        ["ruRU"] = "Далечье",
        ["deDE"] = "Fernhain",
        ["koKR"] = "파샤이어",
        ["esMX"] = "Lindeallá",
        ["enUS"] = true,
        ["frFR"] = "Comté-lointaine",
        ["esES"] = "Lindeallá",
        ["zhTW"] = "遠郡",
        ["zhCN"] = "致远郡",
    },
    ["Farshire Lighthouse"] = {
        ["ptBR"] = "Farol de Algures",
        ["ruRU"] = "Маяк Далечья",
        ["deDE"] = "Leuchtturm von Fernhain",
        ["koKR"] = "파샤이어 등대",
        ["esMX"] = "Faro de Lindeallá",
        ["enUS"] = true,
        ["frFR"] = "Phare de Comté-lointaine",
        ["esES"] = "Faro de Lindeallá",
        ["zhTW"] = "遠郡燈塔",
        ["zhCN"] = "致远郡灯塔",
    },
    ["Unu'pe"] = {
        ["ptBR"] = "Unu'pe",
        ["ruRU"] = "Уну'пе",
        ["deDE"] = "Unu'pe",
        ["koKR"] = "우누페",
        ["esMX"] = "Unu'pe",
        ["enUS"] = true,
        ["frFR"] = "Unu'pe",
        ["esES"] = "Unu'pe",
        ["zhTW"] = "昂紐沛",
        ["zhCN"] = "乌努比",
    },
    ["Death's Stand"] = {
        ["ptBR"] = "Campo da Morte",
        ["ruRU"] = "Стоянка Смерти",
        ["deDE"] = "Todeswehr",
        ["koKR"] = "죽음의 언덕",
        ["esMX"] = "Confín de la Muerte",
        ["enUS"] = true,
        ["frFR"] = "Le séjour de la Mort",
        ["esES"] = "Confín de la Muerte",
        ["zhTW"] = "死亡看臺",
        ["zhCN"] = "死亡营地",
    },
    ["The Abandoned Reach"] = {
        ["ptBR"] = "Os Confins Abandonados",
        ["ruRU"] = "Покинутый предел",
        ["deDE"] = "Die verlassenen Weiten",
        ["koKR"] = "버려진 해안",
        ["esMX"] = "El Tramo Abandonado",
        ["enUS"] = true,
        ["frFR"] = "Les confins Abandonnés",
        ["esES"] = "El Tramo Abandonado",
        ["zhTW"] = "被遺棄之境",
        ["zhCN"] = "遗弃海岸",
    },
    ["Scalding Pools"] = {
        ["ptBR"] = "Lagos Escaldantes",
        ["ruRU"] = "Жгучие пруды",
        ["deDE"] = "Siedende Teiche",
        ["koKR"] = "끓어오르는 웅덩이",
        ["esMX"] = "Pozas Escaldantes",
        ["enUS"] = true,
        ["frFR"] = "Bassins Brûlants",
        ["esES"] = "Pozas Escaldantes",
        ["zhTW"] = "沸水之池",
        ["zhCN"] = "滚烫熔池",
    },
    ["Transitus Shield"] = {
        ["ptBR"] = "Escudo de Transitus",
        ["ruRU"] = "Маскировочный щит",
        ["deDE"] = "Transitusschild",
        ["koKR"] = "변위의 보호막",
        ["esMX"] = "Escudo de Tránsito",
        ["enUS"] = true,
        ["frFR"] = "Bouclier Transitus",
        ["esES"] = "Escudo de Tránsito",
        ["zhTW"] = "隘境之盾",
        ["zhCN"] = "永生之盾",
    },
    ["Bor'gorok Outpost"] = {
        ["ptBR"] = "Posto Avançado Bor'gorok",
        ["ruRU"] = "Застава Бор'горока",
        ["deDE"] = "Außenposten Bor'gorok",
        ["koKR"] = "보르고로크 전초기지",
        ["esMX"] = "Avanzada Bor'gorok",
        ["enUS"] = true,
        ["frFR"] = "Avant-poste de Bor'gorok",
        ["esES"] = "Avanzada Bor'gorok",
        ["zhTW"] = "博格洛克前哨",
        ["zhCN"] = "博古洛克前哨站",
    },
    ["Magmoth"] = {
        ["ptBR"] = "Magmute",
        ["ruRU"] = "Магмот",
        ["deDE"] = "Magmut",
        ["koKR"] = "마그모스",
        ["esMX"] = "Magmoth",
        ["enUS"] = true,
        ["frFR"] = "Magmoth",
        ["esES"] = "Magmoth",
        ["zhTW"] = "瑪格默斯",
        ["zhCN"] = "犸格莫斯",
    },
    ["The Dens of Dying"] = {
        ["ptBR"] = "Tocas da Morte",
        ["ruRU"] = "Кельи Смерти",
        ["deDE"] = "Die Höhlen des Todes",
        ["koKR"] = "사자의 동굴",
        ["esMX"] = "Los Cubiles de los Moribundos",
        ["enUS"] = true,
        ["frFR"] = "Les tanières du Trépas",
        ["esES"] = "Los Cubiles de los Moribundos",
        ["zhTW"] = "垂死獸穴",
        ["zhCN"] = "亡者之穴",
    },
    ["Temple City of En'kilah"] = {
        ["ptBR"] = "Cidade-templo de En'kilah",
        ["ruRU"] = "Храмовый город Эн'кила",
        ["deDE"] = "Tempelstadt En'kilah",
        ["koKR"] = "엔킬라 사원",
        ["esMX"] = "Ciudad Templo de En'kilah",
        ["enUS"] = true,
        ["frFR"] = "Ville-temple d'En'kilah",
        ["esES"] = "Ciudad Templo de En'kilah",
        ["zhTW"] = "恩吉拉聖城",
        ["zhCN"] = "圣城恩其拉",
    },
    ["The Wailing Ziggurat"] = {
        ["ptBR"] = "Zigurate dos Lamentos",
        ["ruRU"] = "Стонущий зиккурат",
        ["deDE"] = "Die klagende Ziggurat",
        ["koKR"] = "통곡의 지구라트",
        ["esMX"] = "El Zigurat de los Lamentos",
        ["enUS"] = true,
        ["frFR"] = "La ziggourat Gémissante",
        ["esES"] = "El Zigurat de los Lamentos",
        ["zhTW"] = "悲嘯通靈塔",
        ["zhCN"] = "悲叹通灵塔",
    },
    ["Steeljaw's Caravan"] = {
        ["ptBR"] = "Caravana do Queixoduro",
        ["ruRU"] = "Караван Стальной Челюсти",
        ["deDE"] = "Stahlkiefers Karawane",
        ["koKR"] = "스틸조의 짐마차",
        ["esMX"] = "Caravana de Quijacero",
        ["enUS"] = true,
        ["frFR"] = "Caravane de Mâchoire-d'acier",
        ["esES"] = "Caravana de Quijacero",
        ["zhTW"] = "鋼顎商隊",
        ["zhCN"] = "钢腭的车队",
    },
    ["Naxxanar"] = {
        ["ptBR"] = "Naxxanar",
        ["ruRU"] = "Наксанар",
        ["deDE"] = "Naxxanar",
        ["koKR"] = "낙사나르",
        ["esMX"] = "Naxxanar",
        ["enUS"] = true,
        ["frFR"] = "Naxxanar",
        ["esES"] = "Naxxanar",
        ["zhTW"] = "納克薩爾",
        ["zhCN"] = "纳克萨纳尔",
    },
    ["Warsong Hold"] = {
        ["ptBR"] = "Fortaleza Brado Guerreiro",
        ["ruRU"] = "Крепость Песни Войны",
        ["deDE"] = "Kriegshymnenfeste",
        ["koKR"] = "전쟁노래부족 요새",
        ["esMX"] = "Bastión Grito de Guerra",
        ["enUS"] = true,
        ["frFR"] = "Bastion Chanteguerre",
        ["esES"] = "Bastión Grito de Guerra",
        ["zhTW"] = "戰歌堡",
        ["zhCN"] = "战歌要塞",
    },
    ["Plains of Nasam"] = {
        ["ptBR"] = "Planícies de Nasam",
        ["ruRU"] = "Равнины Назама",
        ["deDE"] = "Ebene von Nasam",
        ["koKR"] = "나삼의 평원",
        ["esMX"] = "Llanuras de Nasam",
        ["enUS"] = true,
        ["frFR"] = "Les plaines de Nasam",
        ["esES"] = "Llanuras de Nasam",
        ["zhTW"] = "納森平原",
        ["zhCN"] = "纳萨姆平原",
    },
    ["Ruins of Eldra'nath"] = {
        ["ptBR"] = "Ruínas de Eldra'nath",
        ["ruRU"] = "Руины Элдра'ната",
        ["deDE"] = "Ruinen von Eldra'nath",
        ["koKR"] = "엘드라나스 폐허",
        ["esMX"] = "Ruinas de Eldra'nath",
        ["enUS"] = true,
        ["frFR"] = "Ruines d'Eldra'nath",
        ["esES"] = "Ruinas de Eldra'nath",
        ["zhTW"] = "艾卓納斯遺跡",
        ["zhCN"] = "埃德拉纳斯废墟",
    },
    ["Charred Rise"] = {
        ["ptBR"] = "Alto Calcinado",
        ["ruRU"] = "Обугленная вершина",
        ["deDE"] = "Kohlschwarze Anhöhe",
        ["koKR"] = "잿더미 마루",
        ["esMX"] = "Alto Carbonizado",
        ["enUS"] = true,
        ["frFR"] = "Cime Calcinée",
        ["esES"] = "Alto Carbonizado",
        ["zhTW"] = "焦炭高崗",
        ["zhCN"] = "焦土高地",
    },
    ["Blistering Pool"] = {
        ["ptBR"] = "Poço Virulento",
        ["ruRU"] = "Кипящий пруд",
        ["deDE"] = "Kochender Teich",
        ["koKR"] = "부글거리는 웅덩이",
        ["esMX"] = "Poza Virulenta",
        ["enUS"] = true,
        ["frFR"] = "Bassin Caustique",
        ["esES"] = "Poza Virulenta",
        ["zhTW"] = "極熱之池",
        ["zhCN"] = "毒泡水池",
    },
    ["Frozen Reach"] = {
        ["ptBR"] = "Confins Glaciais",
        ["ruRU"] = "Студеный предел",
        ["deDE"] = "Die gefrorenen Weiten",
        ["koKR"] = "얼어붙은 해안",
        ["esMX"] = "Tramo Helado",
        ["enUS"] = true,
        ["frFR"] = "Les confins Gelés",
        ["esES"] = "Tramo Helado",
        ["zhTW"] = "冰凍之境",
        ["zhCN"] = "冰冻平原",
    },
    ["Torp's Farm"] = {
        ["ptBR"] = "Fazenda dos Torp",
        ["ruRU"] = "Ферма Торпа",
        ["deDE"] = "Torps Bauernhof",
        ["koKR"] = "토르프의 농장",
        ["esMX"] = "Granja de Torp",
        ["enUS"] = true,
        ["frFR"] = "Ferme de Torp",
        ["esES"] = "Granja de Torp",
        ["zhTW"] = "托普的農場",
        ["zhCN"] = "托普的农场",
    },
    ["Warsong Granary"] = {
        ["ptBR"] = "Celeiro Brado Guerreiro",
        ["ruRU"] = "Амбар Песни Войны",
        ["deDE"] = "Kornkammer des Kriegshymnenklans",
        ["koKR"] = "전쟁노래부족 곡물창고",
        ["esMX"] = "Granero Grito de Guerra",
        ["enUS"] = true,
        ["frFR"] = "Grenier chanteguerre",
        ["esES"] = "Granero Grito de Guerra",
        ["zhTW"] = "戰歌穀倉",
        ["zhCN"] = "战歌粮仓",
    },
    ["Warsong Slaughterhouse"] = {
        ["ptBR"] = "Matadouro Brado Guerreiro",
        ["ruRU"] = "Скотобойня Песни Войны",
        ["deDE"] = "Schlachthof des Kriegshymnenklans",
        ["koKR"] = "전쟁노래부족 도살장",
        ["esMX"] = "Matadero Grito de Guerra",
        ["enUS"] = true,
        ["frFR"] = "Abattoir chanteguerre",
        ["esES"] = "Matadero Grito de Guerra",
        ["zhTW"] = "戰歌屠宰場",
        ["zhCN"] = "战歌屠宰场",
    },
    ["Warsong Farms Outpost"] = {
        ["ptBR"] = "Acampamento das Fazendas Brado Guerreiro",
        ["ruRU"] = "Застава у ферм Песни войны",
        ["deDE"] = "Höfe des Kriegshymnenklans",
        ["koKR"] = "전쟁노래부족 농장 전진기지",
        ["esMX"] = "Avanzada de las Granjas Grito de Guerra",
        ["enUS"] = true,
        ["frFR"] = "Avant-poste des fermes chanteguerres",
        ["esES"] = "Avanzada de las Granjas Grito de Guerra",
        ["zhTW"] = "戰歌農場前哨",
        ["zhCN"] = "战歌农场哨站",
    },
    ["West Point Station"] = {
        ["ptBR"] = "Estação Oeste",
        ["ruRU"] = "Западная станция",
        ["deDE"] = "Weststation",
        ["koKR"] = "서부 거점",
        ["esMX"] = "Estación de la Punta Oeste",
        ["enUS"] = true,
        ["frFR"] = "Poste de la Halte de l'ouest",
        ["esES"] = "Estación de la Punta Oeste",
        ["zhTW"] = "西點抽水站",
        ["zhCN"] = "西部哨站",
    },
    ["Mid Point Station"] = {
        ["ptBR"] = "Estação Central",
        ["ruRU"] = "Центральная станция",
        ["deDE"] = "Zentralstation",
        ["koKR"] = "중부 거점",
        ["esMX"] = "Estación de la Punta Central",
        ["enUS"] = true,
        ["frFR"] = "Poste de la Halte du centre",
        ["esES"] = "Estación de la Punta Central",
        ["zhTW"] = "中點抽水站",
        ["zhCN"] = "中部哨站",
    },
    ["South Point Station"] = {
        ["ptBR"] = "Estação Sul",
        ["ruRU"] = "Южная станция",
        ["deDE"] = "Südstation",
        ["koKR"] = "남부 거점",
        ["esMX"] = "Estación de la Punta Sur",
        ["enUS"] = true,
        ["frFR"] = "Poste de la Halte du sud",
        ["esES"] = "Estación de la Punta Sur",
        ["zhTW"] = "南點抽水站",
        ["zhCN"] = "南部哨站",
    },
    ["D.E.H.T.A. Encampment"] = {
        ["ptBR"] = "Acampamento da DruiPA",
        ["ruRU"] = "Лагерь Д.Э.Г.О.Ж.",
        ["deDE"] = "Lager der D.E.H.T.A.",
        ["koKR"] = "동물보호협회 야영지",
        ["esMX"] = "Campamento D.E.H.T.A.",
        ["enUS"] = true,
        ["frFR"] = "Campement de la SdPA",
        ["esES"] = "Campamento D.E.H.T.A.",
        ["zhTW"] = "D.E.H.T.A.駐營",
        ["zhCN"] = "仁德会营地",
    },
    ["Kaw's Roost"] = {
        ["ptBR"] = "Mirante de Kaw",
        ["ruRU"] = "Гнездо Кау",
        ["deDE"] = "Kraas Ruhestätte",
        ["koKR"] = "카우의 보금자리",
        ["esMX"] = "Percha de Kaw",
        ["enUS"] = true,
        ["frFR"] = "Perchoir de Kaw",
        ["esES"] = "Percha de Kaw",
        ["zhTW"] = "卡烏的棲息地",
        ["zhCN"] = "卡奥的营地",
    },
    ["Moa'ki Harbor"] = {
        ["ptBR"] = "Porto Moa'ki",
        ["ruRU"] = "Гавань Моа'ки",
        ["deDE"] = "Hafen Moa'ki",
        ["koKR"] = "모아키 항구",
        ["esMX"] = "Puerto Moa'ki",
        ["enUS"] = true,
        ["frFR"] = "Port-Moa'ki",
        ["esES"] = "Puerto Moa'ki",
        ["zhTW"] = "默亞基港",
        ["zhCN"] = "莫亚基港口",
    },
    ["Indu'le Village"] = {
        ["ptBR"] = "Aldeia Indu'le",
        ["ruRU"] = "Деревня Инду'ле",
        ["deDE"] = "Indu'le",
        ["koKR"] = "인두르 마을",
        ["esMX"] = "Poblado Indu'le",
        ["enUS"] = true,
        ["frFR"] = "Indu'le",
        ["esES"] = "Poblado Indu'le",
        ["zhTW"] = "因度雷村",
        ["zhCN"] = "因度雷村",
    },
    ["Snowfall Glade"] = {
        ["ptBR"] = "Clareira Nevada",
        ["ruRU"] = "Поляна Снегопада",
        ["deDE"] = "Schneewehenlichtung",
        ["koKR"] = "눈사태 숲",
        ["esMX"] = "Claro Avalancha",
        ["enUS"] = true,
        ["frFR"] = "Clairière de Tombeneige",
        ["esES"] = "Claro Avalancha",
        ["zhTW"] = "落雪林地",
        ["zhCN"] = "飘雪林地",
    },
    ["The Half Shell"] = {
        ["ptBR"] = "A Carapaça",
        ["ruRU"] = "Половина Оболочки",
        ["deDE"] = "Die Halbmuschel",
        ["koKR"] = "반쪽 껍질",
        ["esMX"] = "La Media Concha",
        ["enUS"] = true,
        ["frFR"] = "La demi-coquille",
        ["esES"] = "La Media Concha",
        ["zhTW"] = "半殼號",
        ["zhCN"] = "半壳龟",
    },
    ["Surge Needle"] = {
        ["ptBR"] = "Agulha de Mana",
        ["ruRU"] = "Волноловы",
        ["deDE"] = "Sognadel",
        ["koKR"] = "폭풍 바늘",
        ["esMX"] = "Aguja de Flujo",
        ["enUS"] = true,
        ["frFR"] = "Capteur tellurique",
        ["esES"] = "Aguja de Flujo",
        ["zhTW"] = "極濤磁針",
        ["zhCN"] = "湍流之针",
    },
    ["Moonrest Gardens"] = {
        ["ptBR"] = "Jardins Lua Serena",
        ["ruRU"] = "Сады Лунного Покоя",
        ["deDE"] = "Mondruhgärten",
        ["koKR"] = "달쉼터 정원",
        ["esMX"] = "Jardines Reposo Lunar",
        ["enUS"] = true,
        ["frFR"] = "Jardins de Repos-de-Lune",
        ["esES"] = "Jardines Reposo Lunar",
        ["zhTW"] = "月眠花園",
        ["zhCN"] = "眠月花园",
    },
    ["Stars' Rest"] = {
        ["ptBR"] = "Recanto das Estrelas",
        ["ruRU"] = "Покой Звезд",
        ["deDE"] = "Sternenruh",
        ["koKR"] = "별의 쉼터",
        ["esMX"] = "Reposo Estelar",
        ["enUS"] = true,
        ["frFR"] = "Repos des étoiles",
        ["esES"] = "Reposo Estelar",
        ["zhTW"] = "繁星之眠",
        ["zhCN"] = "群星之墓",
    },
    ["Westfall Brigade Encampment"] = {
        ["ptBR"] = "Acampamento da Brigada de Cerro Oeste",
        ["ruRU"] = "Лагерь дружины Западного Края",
        ["deDE"] = "Lager der Westfallbrigade",
        ["koKR"] = "서부 몰락지대 여단 야영지",
        ["esMX"] = "Campamento de la Brigada de los Páramos de Poniente",
        ["enUS"] = true,
        ["frFR"] = "Campement de la brigade de la marche de l'Ouest",
        ["esES"] = "Campamento de la Brigada de los Páramos de Poniente",
        ["zhTW"] = "西荒兵團駐營",
        ["zhCN"] = "月溪旅营地",
    },
    ["Lothalor Woodlands"] = {
        ["ptBR"] = "Bosques de Lothalor",
        ["ruRU"] = "Лоталорское редколесье",
        ["deDE"] = "Waldländer von Lothalor",
        ["koKR"] = "로탈로르 숲",
        ["esMX"] = "Bosque Lothalor",
        ["enUS"] = true,
        ["frFR"] = "Forêt de Lothalor",
        ["esES"] = "Bosque Lothalor",
        ["zhTW"] = "洛薩羅林地",
        ["zhCN"] = "罗萨洛尔森林",
    },
    ["Icemist Falls"] = {
        ["ptBR"] = "Cachoeira Bruma Boreal",
        ["ruRU"] = "Водопады Ледяной Пыли",
        ["deDE"] = "Eisnebelfälle",
        ["koKR"] = "얼음안개 폭포",
        ["esMX"] = "Cataratas Bruma de Hielo",
        ["enUS"] = true,
        ["frFR"] = "Chutes de Brume-glace",
        ["esES"] = "Cataratas Bruma de Hielo",
        ["zhTW"] = "冰霧瀑布",
        ["zhCN"] = "冰雾瀑布",
    },
    ["The Pit of Narjun"] = {
        ["ptBR"] = "Fosso de Narjun",
        ["ruRU"] = "Провал Наржуна",
        ["deDE"] = "Die Grube von Narjun",
        ["koKR"] = "나르준의 구덩이",
        ["esMX"] = "El Foso de Narjun",
        ["enUS"] = true,
        ["frFR"] = "La fosse de Narjun",
        ["esES"] = "El Foso de Narjun",
        ["zhTW"] = "那金之淵",
        ["zhCN"] = "纳尔苏深渊",
    },
    ["Lake Indu'le"] = {
        ["ptBR"] = "Lago Indu'le",
        ["ruRU"] = "Озеро Инду'ле",
        ["deDE"] = "Wasser von Indu'le",
        ["koKR"] = "인두르 호수",
        ["esMX"] = "Lago Indu'le",
        ["enUS"] = true,
        ["frFR"] = "Lac Indu'le",
        ["esES"] = "Lago Indu'le",
        ["zhTW"] = "因度雷湖",
        ["zhCN"] = "因度雷湖",
    },
    ["Ruby Dragonshrine"] = {
        ["ptBR"] = "Santuário Dragônico Rubi",
        ["ruRU"] = "Рубиновое святилище драконов",
        ["deDE"] = "Rubindrachenschrein",
        ["koKR"] = "루비 용제단",
        ["esMX"] = "Santuario de Dragones Rubí",
        ["enUS"] = true,
        ["frFR"] = "Sanctuaire draconique rubis",
        ["esES"] = "Santuario de Dragones Rubí",
        ["zhTW"] = "晶紅龍殿",
        ["zhCN"] = "红玉巨龙圣地",
    },
    ["Fordragon Hold"] = {
        ["ptBR"] = "Forte Fordragon",
        ["ruRU"] = "Крепость Фордрагона",
        ["deDE"] = "Feste Fordragon",
        ["koKR"] = "폴드라곤 요새",
        ["esMX"] = "Bastión de Fordragón",
        ["enUS"] = true,
        ["frFR"] = "Bastion Fordragon",
        ["esES"] = "Bastión de Fordragón",
        ["zhTW"] = "弗塔根堡",
        ["zhCN"] = "弗塔根要塞",
    },
    ["Kor'kron Vanguard"] = {
        ["ptBR"] = "Vanguarda Kor'kron",
        ["ruRU"] = "Отряд кор'крона",
        ["deDE"] = "Vorposten der Kor'kron",
        ["koKR"] = "코르크론 선봉기지",
        ["esMX"] = "Vanguardia Kor'kron",
        ["enUS"] = true,
        ["frFR"] = "Avant-garde kor'kronne",
        ["esES"] = "Vanguardia Kor'kron",
        ["zhTW"] = "柯爾克隆先鋒駐地",
        ["zhCN"] = "库卡隆先锋营地",
    },
    ["The Court of Skulls"] = {
        ["ptBR"] = "Castelo das Caveiras",
        ["ruRU"] = "Двор Черепов",
        ["deDE"] = "Der Hof der Schädel",
        ["koKR"] = "해골 왕궁",
        ["esMX"] = "La Corte de las Calaveras",
        ["enUS"] = true,
        ["frFR"] = "La cour des Crânes",
        ["esES"] = "La Corte de las Calaveras",
        ["zhTW"] = "骸骨之廷",
        ["zhCN"] = "颅骨之庭",
    },
    ["Galakrond's Rest"] = {
        ["ptBR"] = "Repouso de Galakrond",
        ["ruRU"] = "Покой Галакронда",
        ["deDE"] = "Galakronds Ruhestätte",
        ["koKR"] = "갈라크론드의 안식처",
        ["esMX"] = "Reposo de Galakrond",
        ["enUS"] = true,
        ["frFR"] = "Le Repos de Galakrond",
        ["esES"] = "Reposo de Galakrond",
        ["zhTW"] = "葛拉克朗安息地",
        ["zhCN"] = "迦拉克隆之墓",
    },
    ["The Wicked Coil"] = {
        ["ptBR"] = "Espiral Perversa",
        ["ruRU"] = "Пагубный Серпантин",
        ["deDE"] = "Die Serpentine",
        ["koKR"] = "악의 똬리",
        ["esMX"] = "La Espiral Maldita",
        ["enUS"] = true,
        ["frFR"] = "La Spirale pernicieuse",
        ["esES"] = "La Espiral Maldita",
        ["zhTW"] = "敗德螺旋",
        ["zhCN"] = "邪恶之旋",
    },
    ["Bronze Dragonshrine"] = {
        ["ptBR"] = "Santuário Dragônico Bronze",
        ["ruRU"] = "Бронзовое святилище драконов",
        ["deDE"] = "Bronzedrachenschrein",
        ["koKR"] = "청동 용제단",
        ["esMX"] = "Santuario de Dragones Bronce",
        ["enUS"] = true,
        ["frFR"] = "Sanctuaire draconique bronze",
        ["esES"] = "Santuario de Dragones Bronce",
        ["zhTW"] = "青銅龍殿",
        ["zhCN"] = "青铜巨龙圣地",
    },
    ["The Mirror of Dawn"] = {
        ["ptBR"] = "Espelho da Aurora",
        ["ruRU"] = "Зеркало Рассвета",
        ["deDE"] = "Spiegel der Morgenröte",
        ["koKR"] = "새벽의 거울",
        ["esMX"] = "El Espejo del Alba",
        ["enUS"] = true,
        ["frFR"] = "Le Miroir de l'aube",
        ["esES"] = "El Espejo del Alba",
        ["zhTW"] = "黎明之鏡",
        ["zhCN"] = "黎明之镜",
    },
    ["Wintergarde Keep"] = {
        ["ptBR"] = "Bastilha Invergarde",
        ["ruRU"] = "Крепость Стражей Зимы",
        ["deDE"] = "Feste Wintergarde",
        ["koKR"] = "윈터가드 성채",
        ["esMX"] = "Fortaleza de Hibergarde",
        ["enUS"] = true,
        ["frFR"] = "Donjon de Garde-hiver",
        ["esES"] = "Fortaleza de Hibergarde",
        ["zhTW"] = "溫特加德要塞",
        ["zhCN"] = "暮冬要塞",
    },
    ["Wintergarde Mine"] = {
        ["ptBR"] = "Mina Invergarde",
        ["ruRU"] = "Рудник Стражей Зимы",
        ["deDE"] = "Minen von Wintergarde",
        ["koKR"] = "윈터가드 광산",
        ["esMX"] = "Mina de Hibergarde",
        ["enUS"] = true,
        ["frFR"] = "Mine de Garde-hiver",
        ["esES"] = "Mina de Hibergarde",
        ["zhTW"] = "溫特加德礦坑",
        ["zhCN"] = "暮冬矿洞",
    },
    ["Emerald Dragonshrine"] = {
        ["ptBR"] = "Santuário Dragônico Esmeralda",
        ["ruRU"] = "Изумрудное святилище драконов",
        ["deDE"] = "Smaragddrachenschrein",
        ["koKR"] = "에메랄드 용제단",
        ["esMX"] = "Santuario de Dragones Esmeralda",
        ["enUS"] = true,
        ["frFR"] = "Sanctuaire draconique émeraude",
        ["esES"] = "Santuario de Dragones Esmeralda",
        ["zhTW"] = "翡翠龍殿",
        ["zhCN"] = "翡翠巨龙圣地",
    },
    ["New Hearthglen"] = {
        ["ptBR"] = "Nova Amparo",
        ["ruRU"] = "Новый Дольный Очаг",
        ["deDE"] = "Neuherdweiler",
        ["koKR"] = "신 하스글렌",
        ["esMX"] = "Nueva Vega del Amparo",
        ["enUS"] = true,
        ["frFR"] = "Nouvelle-Âtreval",
        ["esES"] = "Nueva Vega del Amparo",
        ["zhTW"] = "新壁爐谷",
        ["zhCN"] = "新壁炉谷",
    },
    ["Crusader's Landing"] = {
        ["ptBR"] = "Ancoradouro dos Cruzados",
        ["ruRU"] = "Стоянка рыцарей",
        ["deDE"] = "Hafen des Kreuzzüglers",
        ["koKR"] = "십자군 정박지",
        ["esMX"] = "El Tramo del Cruzado",
        ["enUS"] = true,
        ["frFR"] = "L'accostage du Croisé",
        ["esES"] = "El Tramo del Cruzado",
        ["zhTW"] = "十字軍臺地",
        ["zhCN"] = "十字军码头",
    },
    ["Azure Dragonshrine"] = {
        ["ptBR"] = "Santuário Dragônico Lazúli",
        ["ruRU"] = "Лазуритовое святилище драконов",
        ["deDE"] = "Azurdrachenschrein",
        ["koKR"] = "청금석 용제단",
        ["esMX"] = "Santuario de Dragones Azur",
        ["enUS"] = true,
        ["frFR"] = "Sanctuaire draconique azur",
        ["esES"] = "Santuario de Dragones Azur",
        ["zhTW"] = "蒼藍龍殿",
        ["zhCN"] = "碧蓝巨龙圣地",
    },
    ["The Forgotten Shore"] = {
        ["ptBR"] = "Costa Abandonada",
        ["ruRU"] = "Забытое взморье",
        ["deDE"] = "Der Vergessene Strand",
        ["koKR"] = "망각의 해변",
        ["esMX"] = "La Orilla Olvidada",
        ["enUS"] = true,
        ["frFR"] = "La côte Oubliée",
        ["esES"] = "La Orilla Olvidada",
        ["zhTW"] = "遺民之濱",
        ["zhCN"] = "遗忘海岸",
    },
    ["Venomspite"] = {
        ["ptBR"] = "Perfídia",
        ["ruRU"] = "Ядозлобь",
        ["deDE"] = "Gallgrimm",
        ["koKR"] = "원한의 초소",
        ["esMX"] = "Rencor Venenoso",
        ["enUS"] = true,
        ["frFR"] = "Vexevenin",
        ["esES"] = "Rencor Venenoso",
        ["zhTW"] = "毒怨之地",
        ["zhCN"] = "怨毒镇",
    },
    ["The Crystal Vice"] = {
        ["ptBR"] = "Fenda Cristalina",
        ["ruRU"] = "Ущелье порочных кристаллов",
        ["deDE"] = "Die Kristallschlucht",
        ["koKR"] = "수정 계곡",
        ["esMX"] = "Vicio de Cristal",
        ["enUS"] = true,
        ["frFR"] = "L'Étau de cristal",
        ["esES"] = "Vicio de Cristal",
        ["zhTW"] = "水晶之鉗",
        ["zhCN"] = "水晶裂痕",
    },
    ["The Carrion Fields"] = {
        ["ptBR"] = "Campos de Carniça",
        ["ruRU"] = "Поля Падальщиков",
        ["deDE"] = "Die Aasfelder",
        ["koKR"] = "부패의 벌판",
        ["esMX"] = "Los Campos de Carroña",
        ["enUS"] = true,
        ["frFR"] = "Les champs de la Charogne",
        ["esES"] = "Los Campos de Carroña",
        ["zhTW"] = "腐屍農地",
        ["zhCN"] = "腐臭平原",
    },
    ["Onslaught Base Camp"] = {
        ["ptBR"] = "Base da Ofensiva",
        ["ruRU"] = "Лагерь Алого Натиска",
        ["deDE"] = "Basislager des Ansturms",
        ["koKR"] = "붉은돌격대 주둔지",
        ["esMX"] = "Campamento del Embate",
        ["enUS"] = true,
        ["frFR"] = "Camp de base de l'Assaut",
        ["esES"] = "Campamento del Embate",
        ["zhTW"] = "突襲營地",
        ["zhCN"] = "先锋军营地",
    },
    ["Thorson's Post"] = {
        ["ptBR"] = "Posto de Thorson",
        ["ruRU"] = "Застава Торсона",
        ["deDE"] = "Thorsons Posten",
        ["koKR"] = "토르손의 전초기지",
        ["esMX"] = "Puesto de Thorson",
        ["enUS"] = true,
        ["frFR"] = "Poste de Thorson",
        ["esES"] = "Puesto de Thorson",
        ["zhTW"] = "托爾森崗哨",
        ["zhCN"] = "索尔森的岗哨",
    },
    ["Light's Trust"] = {
        ["ptBR"] = "Guarda da Luz",
        ["ruRU"] = "Опора Света",
        ["deDE"] = "Die Lichtwarte",
        ["koKR"] = "믿음의 빛 거점",
        ["esMX"] = "Confianza de la Luz",
        ["enUS"] = true,
        ["frFR"] = "La Confiance de Lumière",
        ["esES"] = "Confianza de la Luz",
        ["zhTW"] = "聖光之託",
        ["zhCN"] = "圣光之望礼拜堂",
    },
    ["Frostmourne Cavern"] = {
        ["ptBR"] = "Caverna Gélido Lamento",
        ["ruRU"] = "Пещера Ледяной Скорби",
        ["deDE"] = "Frostgramhöhlen",
        ["koKR"] = "서리한 동굴",
        ["esMX"] = "Caverna Agonía de Escarcha",
        ["enUS"] = true,
        ["frFR"] = "Caverne de Deuillegivre",
        ["esES"] = "Caverna Agonía de Escarcha",
        ["zhTW"] = "霜之哀傷洞窟",
        ["zhCN"] = "霜之哀伤洞穴",
    },
    ["Scarlet Point"] = {
        ["ptBR"] = "Vista Escarlate",
        ["ruRU"] = "Застава Алого ордена",
        ["deDE"] = "Scharlachrote Wacht",
        ["koKR"] = "붉은돌격대 초소",
        ["esMX"] = "Punta Escarlata",
        ["enUS"] = true,
        ["frFR"] = "Halte Ecarlate",
        ["esES"] = "Punta Escarlata",
        ["zhTW"] = "血色哨點",
        ["zhCN"] = "血色哨站",
    },
    ["Jintha'kalar"] = {
        ["ptBR"] = "Jintha'kalar",
        ["ruRU"] = "Джинта'калар",
        ["deDE"] = "Jintha'kalar",
        ["koKR"] = "진타칼라르",
        ["esMX"] = "Jintha'kalar",
        ["enUS"] = true,
        ["frFR"] = "Jintha'kalar",
        ["esES"] = "Jintha'kalar",
        ["zhTW"] = "辛薩卡拉",
        ["zhCN"] = "金萨卡拉",
    },
    ["Ice Heart Cavern"] = {
        ["ptBR"] = "Caverna Gelocórdia",
        ["ruRU"] = "Пещера Ледяного Сердца",
        ["deDE"] = "Eiskernhöhlen",
        ["koKR"] = "얼음 심장 동굴",
        ["esMX"] = "Caverna Corazón de Hielo",
        ["enUS"] = true,
        ["frFR"] = "Caverne du Cœur de glace",
        ["esES"] = "Caverna Corazón de Hielo",
        ["zhTW"] = "冰心洞窟",
        ["zhCN"] = "冰心洞穴",
    },
    ["Wintergrasp"] = {
        ["ptBR"] = "Invérnia",
        ["ruRU"] = "Озеро Ледяных Оков",
        ["deDE"] = "Tausendwintersee",
        ["koKR"] = "겨울손아귀 호수",
        ["esMX"] = "Conquista del Invierno",
        ["enUS"] = true,
        ["frFR"] = "Joug-d'hiver",
        ["esES"] = "Conquista del Invierno",
        ["zhTW"] = "冬握湖",
        ["zhCN"] = "冬拥湖",
    },
    ["Kili'ua's Atoll"] = {
        ["ptBR"] = "Atol de Kili'ua",
        ["ruRU"] = "Атолл Кили'уа",
        ["deDE"] = "Kili'uas Atoll",
        ["koKR"] = "킬리우아의 산호섬",
        ["esMX"] = "Atolón de Kili'ua",
        ["enUS"] = true,
        ["frFR"] = "Atoll de Kili'ua",
        ["esES"] = "Atolón de Kili'ua",
        ["zhTW"] = "齊里厄雅環礁",
        ["zhCN"] = "基利瓦的礁石",
    },
    ["Silverbrook"] = {
        ["ptBR"] = "Arroio Prateado",
        ["ruRU"] = "Среброречье",
        ["deDE"] = "Silberwasser",
        ["koKR"] = "은빛시내 마을",
        ["esMX"] = "Arroyoplata",
        ["enUS"] = true,
        ["frFR"] = "Ruissargent",
        ["esES"] = "Arroyoplata",
        ["zhTW"] = "銀溪鎮",
        ["zhCN"] = "银溪镇",
    },
    ["Vordrassil's Heart"] = {
        ["ptBR"] = "Coração de Vordrassil",
        ["ruRU"] = "Сердце Фордрассила",
        ["deDE"] = "Vordrassils Herz",
        ["koKR"] = "볼드랏실의 심장",
        ["esMX"] = "Corazón de Vordrassil",
        ["enUS"] = true,
        ["frFR"] = "Cœur de Vordrassil",
        ["esES"] = "Corazón de Vordrassil",
        ["zhTW"] = "沃達希爾之心",
        ["zhCN"] = "沃达希尔之心",
    },
    ["Vordrassil's Limb"] = {
        ["ptBR"] = "Rama de Vordrassil",
        ["ruRU"] = "Ветви Фордрассила",
        ["deDE"] = "Vordrassils Ast",
        ["koKR"] = "볼드랏실의 가지",
        ["esMX"] = "Extremidad de Vordrassil",
        ["enUS"] = true,
        ["frFR"] = "Branche de Vordrassil",
        ["esES"] = "Extremidad de Vordrassil",
        ["zhTW"] = "沃達希爾之枝",
        ["zhCN"] = "沃达希尔之臂",
    },
    ["Amberpine Lodge"] = {
        ["ptBR"] = "Chalé do Pinho Âmbar",
        ["ruRU"] = "Приют Янтарной Сосны",
        ["deDE"] = "Ammertannhütte",
        ["koKR"] = "호박빛소나무 오두막",
        ["esMX"] = "Refugio Pino Ámbar",
        ["enUS"] = true,
        ["frFR"] = "Gîte Ambrepin",
        ["esES"] = "Refugio Pino Ámbar",
        ["zhTW"] = "琥珀松小屋",
        ["zhCN"] = "琥珀松木营地",
    },
    ["Solstice Village"] = {
        ["ptBR"] = "Aldeia Solstício",
        ["ruRU"] = "Деревня Солнцестояния",
        ["deDE"] = "Julheim",
        ["koKR"] = "극지 마을",
        ["esMX"] = "Poblado Solsticio",
        ["enUS"] = true,
        ["frFR"] = "Solstice",
        ["esES"] = "Poblado Solsticio",
        ["zhTW"] = "季至村",
        ["zhCN"] = "冬至村",
    },
    ["Conquest Hold"] = {
        ["ptBR"] = "Forte da Conquista",
        ["ruRU"] = "Крепость Завоевателей",
        ["deDE"] = "Burg Siegeswall",
        ["koKR"] = "정복의 요새",
        ["esMX"] = "Bastión de la Conquista",
        ["enUS"] = true,
        ["frFR"] = "Bastion de la Conquête",
        ["esES"] = "Bastión de la Conquista",
        ["zhTW"] = "征服堡",
        ["zhCN"] = "征服堡",
    },
    ["Voldrune"] = {
        ["ptBR"] = "Runavold",
        ["ruRU"] = "Волдрун",
        ["deDE"] = "Voldrune",
        ["koKR"] = "볼드룬",
        ["esMX"] = "Runavold",
        ["enUS"] = true,
        ["frFR"] = "Voldrune",
        ["esES"] = "Runavold",
        ["zhTW"] = "沃德盧恩",
        ["zhCN"] = "沃德伦",
    },
    ["Granite Springs"] = {
        ["ptBR"] = "Fontes Graníticas",
        ["ruRU"] = "Гранитные ключи",
        ["deDE"] = "Granitquell",
        ["koKR"] = "화강암 웅덩이",
        ["esMX"] = "Manantial de Granito",
        ["enUS"] = true,
        ["frFR"] = "Sources de granit",
        ["esES"] = "Manantial de Granito",
        ["zhTW"] = "花崗岩之泉",
        ["zhCN"] = "岩石之泉",
    },
    ["Zeb'Halak"] = {
        ["ptBR"] = "Zeb'Halak",
        ["ruRU"] = "Зеб'Халак",
        ["deDE"] = "Zeb'Halak",
        ["koKR"] = "제브할락",
        ["esMX"] = "Zeb'Halak",
        ["enUS"] = true,
        ["frFR"] = "Zeb'Halak",
        ["esES"] = "Zeb'Halak",
        ["zhTW"] = "札布哈拉克",
        ["zhCN"] = "塞布哈拉克",
    },
    ["Camp Oneqwah"] = {
        ["ptBR"] = "Aldeia Oneqwah",
        ["ruRU"] = "Лагерь Уанква",
        ["deDE"] = "Camp Oneqwah",
        ["koKR"] = "원크와 야영지",
        ["esMX"] = "Campamento Oneqwah",
        ["enUS"] = true,
        ["frFR"] = "Camp Oneqwah",
        ["esES"] = "Campamento Oneqwah",
        ["zhTW"] = "歐尼克瓦營地",
        ["zhCN"] = "欧尼瓦营地",
    },
    ["Eastwind Shore"] = {
        ["ptBR"] = "Costa da Lestada",
        ["ruRU"] = "Побережье Восточного Ветра",
        ["deDE"] = "Ostwindküste",
        ["koKR"] = "샛바람 해안",
        ["esMX"] = "Playa Viento Este",
        ["enUS"] = true,
        ["frFR"] = "Rivage d'Estevent",
        ["esES"] = "Playa Viento Este",
        ["zhTW"] = "東風水濱",
        ["zhCN"] = "东风海岸",
    },
    ["Boulder Hills"] = {
        ["ptBR"] = "Montes dos Penedos",
        ["ruRU"] = "Каменистые холмы",
        ["deDE"] = "Felshügel",
        ["koKR"] = "바위 언덕",
        ["esMX"] = "Colinas Pedrusco",
        ["enUS"] = true,
        ["frFR"] = "Collines du Rocher",
        ["esES"] = "Colinas Pedrusco",
        ["zhTW"] = "巨礫之丘",
        ["zhCN"] = "巨石丘陵",
    },
    ["Rage Fang Shrine"] = {
        ["ptBR"] = "Ermida Presa Raivosa",
        ["ruRU"] = "Святилище Красного Клыка",
        ["deDE"] = "Schrein des Grollfangs",
        ["koKR"] = "분노의 송곳니 제단",
        ["esMX"] = "Santuario Colmillo Iracundo",
        ["enUS"] = true,
        ["frFR"] = "Sanctuaire du Croc rageur",
        ["esES"] = "Santuario Colmillo Iracundo",
        ["zhTW"] = "怒牙聖壇",
        ["zhCN"] = "怒牙神殿",
    },
    ["Drakil'jin Ruins"] = {
        ["ptBR"] = "Ruínas de Drakil'jin",
        ["ruRU"] = "Руины Дракил'джин",
        ["deDE"] = "Ruinen von Drakil'jin",
        ["koKR"] = "드라킬진 폐허",
        ["esMX"] = "Ruinas de Drakil'jin",
        ["enUS"] = true,
        ["frFR"] = "Ruines de Drakil'jin",
        ["esES"] = "Ruinas de Drakil'jin",
        ["zhTW"] = "德拉齊金遺跡",
        ["zhCN"] = "达基尔金废墟",
    },
    ["Blackriver Logging Camp"] = {
        ["ptBR"] = "Madeireira Rio Negro",
        ["ruRU"] = "Лесопилка Черноречья",
        ["deDE"] = "Holzfällerlager Schwarzwasser",
        ["koKR"] = "검은강 벌목지",
        ["esMX"] = "Aserradero Río Negro",
        ["enUS"] = true,
        ["frFR"] = "Camp de bûcherons de la rivière Noire",
        ["esES"] = "Aserradero Río Negro",
        ["zhTW"] = "黑河伐木營地",
        ["zhCN"] = "黑水伐木场",
    },
    ["Heart's Blood Shrine"] = {
        ["ptBR"] = "Ermida Verossangue",
        ["ruRU"] = "Святилище Кровавого Сердца",
        ["deDE"] = "Schrein des Herzensblutes",
        ["koKR"] = "혈심장 제단",
        ["esMX"] = "Santuario Sangre de Corazón",
        ["enUS"] = true,
        ["frFR"] = "Sanctuaire du Sang du cœur",
        ["esES"] = "Santuario Sangre de Corazón",
        ["zhTW"] = "心之血聖壇",
        ["zhCN"] = "心血神殿",
    },
    ["Hollowstone Mine"] = {
        ["ptBR"] = "Mina da Pedra Oca",
        ["ruRU"] = "Рудник Полого Камня",
        ["deDE"] = "Hohlsteinmine",
        ["koKR"] = "빈돌 광산",
        ["esMX"] = "Mina Piedrahueca",
        ["enUS"] = true,
        ["frFR"] = "Mine de la Pierre creuse",
        ["esES"] = "Mina Piedrahueca",
        ["zhTW"] = "穴石礦坑",
        ["zhCN"] = "空石矿洞",
    },
    ["Dun Argol"] = {
        ["ptBR"] = "Dun Argol",
        ["ruRU"] = "Дун Аргол",
        ["deDE"] = "Dun Argol",
        ["koKR"] = "던 아르골",
        ["esMX"] = "Dun Argol",
        ["enUS"] = true,
        ["frFR"] = "Dun Argol",
        ["esES"] = "Dun Argol",
        ["zhTW"] = "丹亞戈",
        ["zhCN"] = "丹厄古尔",
    },
    ["Thor Modan"] = {
        ["ptBR"] = "Thor Modan",
        ["ruRU"] = "Тор Модан",
        ["deDE"] = "Thor Modan",
        ["koKR"] = "토르 모단",
        ["esMX"] = "Thor Modan",
        ["enUS"] = true,
        ["frFR"] = "Thor Modan",
        ["esES"] = "Thor Modan",
        ["zhTW"] = "鐸爾莫丹",
        ["zhCN"] = "索尔莫丹",
    },
    ["Blue Sky Logging Grounds"] = {
        ["ptBR"] = "Madeireira Céu Azul",
        ["ruRU"] = "Лесозаготовки Синего Неба",
        ["deDE"] = "Holzfällerposten Blauhimmel",
        ["koKR"] = "푸른 하늘 벌목장",
        ["esMX"] = "Aserradero Cielo Azul",
        ["enUS"] = true,
        ["frFR"] = "Chantier d'abattage du Ciel bleu",
        ["esES"] = "Aserradero Cielo Azul",
        ["zhTW"] = "藍天伐木地",
        ["zhCN"] = "蓝天伐木场",
    },
    ["Maw of Neltharion"] = {
        ["ptBR"] = "Bocarra de Neltharion",
        ["ruRU"] = "Пасть Нелтариона",
        ["deDE"] = "Neltharions Schlund",
        ["koKR"] = "넬타리온의 턱",
        ["esMX"] = "Fauces de Neltharion",
        ["enUS"] = true,
        ["frFR"] = "Gueule de Neltharion",
        ["esES"] = "Fauces de Neltharion",
        ["zhTW"] = "奈薩里奧之喉",
        ["zhCN"] = "奈萨里奥之喉",
    },
    ["The Briny Pinnacle"] = {
        ["ptBR"] = "Morro Salgado",
        ["ruRU"] = "Соленая вершина",
        ["deDE"] = "Die Salzzinne",
        ["koKR"] = "소금바위 봉우리",
        ["esMX"] = "El Pináculo Salobre",
        ["enUS"] = true,
        ["frFR"] = "Cime Saumâtre",
        ["esES"] = "El Pináculo Salobre",
        ["zhTW"] = "海水之巔",
        ["zhCN"] = "海洋之巅",
    },
    ["Glittering Strand"] = {
        ["ptBR"] = "Praia Reluzente",
        ["ruRU"] = "Сверкающее взморье",
        ["deDE"] = "Glimmerstrand",
        ["koKR"] = "반짝이는 해안",
        ["esMX"] = "Orilla Resplandeciente",
        ["enUS"] = true,
        ["frFR"] = "Grève Lumineuse",
        ["esES"] = "Orilla Resplandeciente",
        ["zhTW"] = "閃耀水岸",
        ["zhCN"] = "灿烂海岸",
    },
    ["Iskaal"] = {
        ["ptBR"] = "Iskaal",
        ["ruRU"] = "Искаал",
        ["deDE"] = "Iskaal",
        ["koKR"] = "이스카알",
        ["esMX"] = "Iskaal",
        ["enUS"] = true,
        ["frFR"] = "Iskaal",
        ["esES"] = "Iskaal",
        ["zhTW"] = "伊斯考",
        ["zhCN"] = "伊斯卡尔",
    },
    ["Dragon's Fall"] = {
        ["ptBR"] = "Aldeia do Dragão Arruinado",
        ["ruRU"] = "Драконья погибель",
        ["deDE"] = "Drachensturz",
        ["koKR"] = "용사냥 마루",
        ["esMX"] = "Caída del Dragón",
        ["enUS"] = true,
        ["frFR"] = "Chute du dragon",
        ["esES"] = "Caída del Dragón",
        ["zhTW"] = "龍殞營地",
        ["zhCN"] = "猎龙营地",
    },
    ["The Oculus"] = {
        ["ptBR"] = "Óculus",
        ["ruRU"] = "Окулус",
        ["deDE"] = "Das Oculus",
        ["koKR"] = "마력의 눈",
        ["esMX"] = "El Oculus",
        ["enUS"] = true,
        ["frFR"] = "L'Oculus",
        ["esES"] = "El Oculus",
        ["zhTW"] = "奧核之眼",
        ["zhCN"] = "魔环",
    },
    ["Prospector's Point"] = {
        ["ptBR"] = "Mirante do Minerador",
        ["ruRU"] = "Лагерь горняков",
        ["deDE"] = "Prospektorat",
        ["koKR"] = "발굴단 거점",
        ["esMX"] = "Altozano del Prospector",
        ["enUS"] = true,
        ["frFR"] = "Pointe du Prospecteur",
        ["esES"] = "Altozano del Prospector",
        ["zhTW"] = "勘察員崗哨",
        ["zhCN"] = "勘探员哨站",
    },
    ["Coldwind Heights"] = {
        ["ptBR"] = "Planalto Vento Frio",
        ["ruRU"] = "Морозные выси",
        ["deDE"] = "Kaltwindanhöhen",
        ["koKR"] = "눈바람 언덕",
        ["esMX"] = "Altos Viento Helado",
        ["enUS"] = true,
        ["frFR"] = "Hauts de Vent-froid",
        ["esES"] = "Altos Viento Helado",
        ["zhTW"] = "冷風陵地",
        ["zhCN"] = "冷风高地",
    },
    ["Redwood Trading Post"] = {
        ["ptBR"] = "Entreposto Sequoia",
        ["ruRU"] = "Торговая лавка Красного леса",
        ["deDE"] = "Handelsposten von Rotholz",
        ["koKR"] = "붉은나무 교역소",
        ["esMX"] = "Puesto de Venta de Madera Roja",
        ["enUS"] = true,
        ["frFR"] = "Comptoir du Cèdre",
        ["esES"] = "Puesto de Venta de Madera Roja",
        ["zhTW"] = "紅木貿易站",
        ["zhCN"] = "红木商栈",
    },
    ["Vengeance Pass"] = {
        ["ptBR"] = "Desfiladeiro da Vingança",
        ["ruRU"] = "Перевал Возмездия",
        ["deDE"] = "Pass der Vergeltung",
        ["koKR"] = "복수의 고개",
        ["esMX"] = "Paso Venganza",
        ["enUS"] = true,
        ["frFR"] = "Défilé de la Vengeance",
        ["esES"] = "Paso Venganza",
        ["zhTW"] = "復仇隘口",
        ["zhCN"] = "复仇小径",
    },
    ["Dawn's Reach"] = {
        ["ptBR"] = "Confins da Aurora",
        ["ruRU"] = "Рассветный край",
        ["deDE"] = "Dämmerkuppe",
        ["koKR"] = "십자군 주둔지",
        ["esMX"] = "Tramo del Alba",
        ["enUS"] = true,
        ["frFR"] = "Confins de l'Aube",
        ["esES"] = "Tramo del Alba",
        ["zhTW"] = "黎明之境",
        ["zhCN"] = "黎明河滩",
    },
    ["Heartwood Trading Post"] = {
        ["ptBR"] = "Entreposto Alburno",
        ["ruRU"] = "Торговая лавка Чащи Леса",
        ["deDE"] = "Handelsposten Kernholz",
        ["koKR"] = "심재 교역소",
        ["esMX"] = "Puesto de Venta de Duramen",
        ["enUS"] = true,
        ["frFR"] = "Comptoir de Cœur-du-bois",
        ["esES"] = "Puesto de Venta de Duramen",
        ["zhTW"] = "心材貿易站",
        ["zhCN"] = "心木商栈",
    },
    ["Evergreen Trading Post"] = {
        ["ptBR"] = "Entreposto Perene",
        ["ruRU"] = "Торговая лавка Вечнозеленого леса",
        ["deDE"] = "Handelsposten Immergrün",
        ["koKR"] = "사철나무 교역소",
        ["esMX"] = "Puesto de Venta de Siempreverde",
        ["enUS"] = true,
        ["frFR"] = "Comptoir des Conifères",
        ["esES"] = "Puesto de Venta de Siempreverde",
        ["zhTW"] = "常青貿易站",
        ["zhCN"] = "常青商栈",
    },
    ["Spruce Point Post"] = {
        ["ptBR"] = "Posto Ponta do Pinheiro",
        ["ruRU"] = "Застава еловой макушки",
        ["deDE"] = "Posten des Fichtenpunkts",
        ["koKR"] = "전나무 거점 주둔지",
        ["esMX"] = "Puesto del Altozano de Píceas",
        ["enUS"] = true,
        ["frFR"] = "Poste du cap de l'Epicéa",
        ["esES"] = "Puesto del Altozano de Píceas",
        ["zhTW"] = "雲杉峰崗哨",
        ["zhCN"] = "云杉哨站",
    },
    ["White Pine Trading Post"] = {
        ["ptBR"] = "Entreposto Pinheiro Branco",
        ["ruRU"] = "Торговая лавка Белой Сосны",
        ["deDE"] = "Handelsposten Weißkiefer",
        ["koKR"] = "흰 소나무 교역소",
        ["esMX"] = "Puesto de Venta de Pino Blanco",
        ["enUS"] = true,
        ["frFR"] = "Comptoir du Pin blanc",
        ["esES"] = "Puesto de Venta de Pino Blanco",
        ["zhTW"] = "白松貿易站",
        ["zhCN"] = "白松商栈",
    },
    ["Aspen Grove Post"] = {
        ["ptBR"] = "Posto Álamo",
        ["ruRU"] = "Застава Тополиной рощи",
        ["deDE"] = "Posten des Espenhains",
        ["koKR"] = "미루나무 숲 초소",
        ["esMX"] = "Puesto de la Alameda",
        ["enUS"] = true,
        ["frFR"] = "Poste de la Tremblaie",
        ["esES"] = "Puesto de la Alameda",
        ["zhTW"] = "白楊崗哨",
        ["zhCN"] = "白杨商栈",
    },
    ["Forest's Edge Post"] = {
        ["ptBR"] = "Posto Boca da Mata",
        ["ruRU"] = "Застава на опушке",
        ["deDE"] = "Posten des Waldrands",
        ["koKR"] = "숲 가장자리 초소",
        ["esMX"] = "Puesto Fronterizo del Bosque",
        ["enUS"] = true,
        ["frFR"] = "Poste de la Lisière",
        ["esES"] = "Puesto Fronterizo del Bosque",
        ["zhTW"] = "林邊崗哨",
        ["zhCN"] = "林边哨站",
    },
    ["Eldritch Heights"] = {
        ["ptBR"] = "Cerro Lúgubre",
        ["ruRU"] = "Зловещая возвышенность",
        ["deDE"] = "Düsterhöhen",
        ["koKR"] = "으스스한 언덕",
        ["esMX"] = "Cumbres Fantasmales",
        ["enUS"] = true,
        ["frFR"] = "Les hauts Surréels",
        ["esES"] = "Cumbres de Eldritch",
        ["zhTW"] = "異法陵地",
        ["zhCN"] = "埃尔德齐断崖",
    },
    ["Venture Bay"] = {
        ["ptBR"] = "Baía dos Empreendimentos",
        ["ruRU"] = "Бухта торговцев",
        ["deDE"] = "Venturebucht",
        ["koKR"] = "투자개발 만",
        ["esMX"] = "Bahía Ventura",
        ["enUS"] = true,
        ["frFR"] = "Baie de la KapitalRisk",
        ["esES"] = "Bahía Ventura",
        ["zhTW"] = "風險海灣",
        ["zhCN"] = "风险湾",
    },
    ["Wintergarde Crypt"] = {
        ["ptBR"] = "Cripta de Invergarde",
        ["ruRU"] = "Склеп Стражей Зимы",
        ["deDE"] = "Gruft von Wintergarde",
        ["koKR"] = "윈터가드 납골당",
        ["esMX"] = "Cripta de Hibergarde",
        ["enUS"] = true,
        ["frFR"] = "Crypte de Garde-hiver",
        ["esES"] = "Cripta de Hibergarde",
        ["zhTW"] = "溫特加德墓穴",
        ["zhCN"] = "暮冬地穴",
    },
    ["Bloodmoon Isle"] = {
        ["ptBR"] = "Ilha Sangreluna",
        ["ruRU"] = "Остров Кровавой Луны",
        ["deDE"] = "Blutmondinsel",
        ["koKR"] = "핏빛달 섬",
        ["esMX"] = "Isla Luna de Sangre",
        ["enUS"] = true,
        ["frFR"] = "Île de la Lune sanguine",
        ["esES"] = "Isla Luna de Sangre",
        ["zhTW"] = "血月島",
        ["zhCN"] = "血月岛",
    },
    ["Shadowfang Tower"] = {
        ["ptBR"] = "Torre da Presa Negra",
        ["ruRU"] = "Башня Темного Клыка",
        ["deDE"] = "Schattenfangturm",
        ["koKR"] = "그림자송곳니 탑",
        ["esMX"] = "Torre de Colmillo Oscuro",
        ["enUS"] = true,
        ["frFR"] = "Tour d'Ombrecroc",
        ["esES"] = "Torre de Colmillo Oscuro",
        ["zhTW"] = "影牙塔",
        ["zhCN"] = "影牙之塔",
    },
    ["Wintergarde Mausoleum"] = {
        ["ptBR"] = "Mausoléu de Invergarde",
        ["ruRU"] = "Усыпальница Стражей Зимы",
        ["deDE"] = "Mausoleum von Wintergarde",
        ["koKR"] = "윈터가드 묘지",
        ["esMX"] = "Mausoleo de Hibergarde",
        ["enUS"] = true,
        ["frFR"] = "Mausolée de Garde-hiver",
        ["esES"] = "Mausoleo de Hibergarde",
        ["zhTW"] = "溫特加德墓塚",
        ["zhCN"] = "暮冬陵园",
    },
    ["Duskhowl Den"] = {
        ["ptBR"] = "Gruta do Uivo da Noite",
        ["ruRU"] = "Логово Ночного Воя",
        ["deDE"] = "Grauheulerbau",
        ["koKR"] = "그늘울음 동굴",
        ["esMX"] = "Cubil Aúllaocaso",
        ["enUS"] = true,
        ["frFR"] = "Tanière des Hurlesoir",
        ["esES"] = "Cubil Aúllaocaso",
        ["zhTW"] = "暮嚎之穴",
        ["zhCN"] = "暗嚎兽穴",
    },
    ["The Conquest Pit"] = {
        ["ptBR"] = "Fosso da Conquista",
        ["ruRU"] = "Бойцовская яма",
        ["deDE"] = "Die Siegeswallgrube",
        ["koKR"] = "정복의 요새 투기장",
        ["esMX"] = "El Foso de la Conquista",
        ["enUS"] = true,
        ["frFR"] = "La fosse des Conquérants",
        ["esES"] = "El Foso de la Conquista",
        ["zhTW"] = "征服之淵",
        ["zhCN"] = "征服斗兽场",
    },
    ["The Path of Iron"] = {
        ["ptBR"] = "Caminho de Ferro",
        ["ruRU"] = "Путь Железа",
        ["deDE"] = "Der Eisenpfad",
        ["koKR"] = "무쇠단의 길",
        ["esMX"] = "La Senda de Hierro",
        ["enUS"] = true,
        ["frFR"] = "Le sentier du Fer",
        ["esES"] = "La Senda de Hierro",
        ["zhTW"] = "鐵之途",
        ["zhCN"] = "铁铸之路",
    },
    ["Ruins of Tethys"] = {
        ["ptBR"] = "Ruínas de Tethys",
        ["ruRU"] = "Руины Тетиса",
        ["deDE"] = "Ruinen von Tethys",
        ["koKR"] = "테시스의 폐허",
        ["esMX"] = "Ruinas de Tethys",
        ["enUS"] = true,
        ["frFR"] = "Ruines de Téthys",
        ["esES"] = "Ruinas de Tethys",
        ["zhTW"] = "瑟希斯遺跡",
        ["zhCN"] = "泰塞斯废墟",
    },
    ["Silverbrook Hills"] = {
        ["ptBR"] = "Serra do Arroio Prateado",
        ["ruRU"] = "Холмы Среброречья",
        ["deDE"] = "Silberwasserhügel",
        ["koKR"] = "은빛시내 언덕",
        ["esMX"] = "Colinas de Arroyoplata",
        ["enUS"] = true,
        ["frFR"] = "Collines de Ruissargent",
        ["esES"] = "Colinas de Arroyoplata",
        ["zhTW"] = "銀溪丘",
        ["zhCN"] = "银溪丘陵",
    },
    ["The Broken Bluffs"] = {
        ["ptBR"] = "Penhascos Inóspitos",
        ["ruRU"] = "Изрезанные утесы",
        ["deDE"] = "Der Felssturz",
        ["koKR"] = "부서진 절벽",
        ["esMX"] = "Riscos Quebrados",
        ["enUS"] = true,
        ["frFR"] = "Les pitons Brisés",
        ["esES"] = "Riscos Quebrados",
        ["zhTW"] = "破碎崖",
        ["zhCN"] = "裂崖",
    },
    ["7th Legion Front"] = {
        ["ptBR"] = "Front da 7ª Legião",
        ["ruRU"] = "Передовая 7-го легиона",
        ["deDE"] = "Front der 7. Legion",
        ["koKR"] = "7군단 전초지",
        ["esMX"] = "Frente de la Séptima Legión",
        ["enUS"] = true,
        ["frFR"] = "Front de la 7e Légion",
        ["esES"] = "Frente de la Séptima Legión",
        ["zhTW"] = "第七軍團前線",
        ["zhCN"] = "第七军团前线",
    },
    ["The Dragon Wastes"] = {
        ["ptBR"] = "Ermos Dragônicos",
        ["ruRU"] = "Драконьи пустоши",
        ["deDE"] = "Die Dracheneiswüste",
        ["koKR"] = "용의 황무지",
        ["esMX"] = "Baldío del Dragón",
        ["enUS"] = true,
        ["frFR"] = "Le désert des Dragons",
        ["esES"] = "Baldío del Dragón",
        ["zhTW"] = "龍墳荒原",
        ["zhCN"] = "巨龙废土",
    },
    ["Ruins of Drak'Zin"] = {
        ["ptBR"] = "Ruínas de Drak'Zin",
        ["ruRU"] = "Руины Драк'Зина",
        ["deDE"] = "Ruinen von Drak'Zin",
        ["koKR"] = "드락진 폐허",
        ["esMX"] = "Ruinas de Drak'Zin",
        ["enUS"] = true,
        ["frFR"] = "Ruines de Drak'Zin",
        ["esES"] = "Ruinas de Drak'Zin",
        ["zhTW"] = "德拉克辛遺跡",
        ["zhCN"] = "达克辛废墟",
    },
    ["Drak'Mar Lake"] = {
        ["ptBR"] = "Lago Drak'Mar",
        ["ruRU"] = "Озеро Драк'Мар",
        ["deDE"] = "Drak'Marsee",
        ["koKR"] = "드락마 호수",
        ["esMX"] = "Lago Drak'Mar",
        ["enUS"] = true,
        ["frFR"] = "Lac Drak'Mar",
        ["esES"] = "Lago Drak'Mar",
        ["zhTW"] = "德拉克瑪湖",
        ["zhCN"] = "达克玛尔湖",
    },
    ["Dragonspine Tributary"] = {
        ["ptBR"] = "Afluente Espinodraco",
        ["ruRU"] = "Кладовая Драконьего Хребта",
        ["deDE"] = "Drachenwirbelzufluss",
        ["koKR"] = "용돌기 강",
        ["esMX"] = "Afluente del Espinazo del Dragón",
        ["enUS"] = true,
        ["frFR"] = "Affluent de l'Epine-de-dragon",
        ["esES"] = "Afluente del Espinazo del Dragón",
        ["zhTW"] = "龍脊支流",
        ["zhCN"] = "龙脊河",
    },
    ["Drak'ural"] = {
        ["ptBR"] = "Drak'ural",
        ["ruRU"] = "Драк'урал",
        ["deDE"] = "Drak'ural",
        ["koKR"] = "드락우랄",
        ["esMX"] = "Drak'ural",
        ["enUS"] = true,
        ["frFR"] = "Drak'ural",
        ["esES"] = "Drak'ural",
        ["zhTW"] = "德拉克烏洛",
        ["zhCN"] = "达克乌拉",
    },
    ["Thorvald's Camp"] = {
        ["ptBR"] = "Acampamento do Thorvald",
        ["ruRU"] = "Лагерь Торвальда",
        ["deDE"] = "Thorvalds Lager",
        ["koKR"] = "토르발트의 야영지",
        ["esMX"] = "Campamento de Thorvald",
        ["enUS"] = true,
        ["frFR"] = "Camp de Thorvald",
        ["esES"] = "Campamento de Thorvald",
        ["zhTW"] = "索瓦爾德營地",
        ["zhCN"] = "托尔瓦德的营地",
    },
    ["Ghostblade Post"] = {
        ["ptBR"] = "Posto Lâmina Espectral",
        ["ruRU"] = "Застава Призрачного Клинка",
        ["deDE"] = "Geisterklingenposten",
        ["koKR"] = "유령칼날 초소",
        ["esMX"] = "Puesto del Filo Fantasmal",
        ["enUS"] = true,
        ["frFR"] = "Poste de la Lame-fantôme",
        ["esES"] = "Puesto del Filo Fantasmal",
        ["zhTW"] = "鬼刃崗哨",
        ["zhCN"] = "幽刃岗哨",
    },
    ["Ashwood Post"] = {
        ["ptBR"] = "Posto Freixo",
        ["ruRU"] = "Ясеневая застава",
        ["deDE"] = "Eschenholzposten",
        ["koKR"] = "잿빛나무 초소",
        ["esMX"] = "Puesto Fresno",
        ["enUS"] = true,
        ["frFR"] = "Poste du Frêne",
        ["esES"] = "Puesto Fresno",
        ["zhTW"] = "灰木崗哨",
        ["zhCN"] = "灰木哨站",
    },
    ["Lydell's Ambush"] = {
        ["ptBR"] = "Cilada de Lídio",
        ["ruRU"] = "Засада Лиделла",
        ["deDE"] = "Lydells Hinterhalt",
        ["koKR"] = "리델의 매복지",
        ["esMX"] = "Emboscada de Lydell",
        ["enUS"] = true,
        ["frFR"] = "Embuscade de Lydell",
        ["esES"] = "Emboscada de Lydell",
        ["zhTW"] = "黎戴爾的埋伏處",
        ["zhCN"] = "林德尔的伏击点",
    },
    ["Harkor's Camp"] = {
        ["ptBR"] = "Acampamento do Harkor",
        ["ruRU"] = "Лагерь Харкора",
        ["deDE"] = "Harkors Lager",
        ["koKR"] = "하코르의 야영지",
        ["esMX"] = "Campamento de Harkor",
        ["enUS"] = true,
        ["frFR"] = "Camp de Harkor",
        ["esES"] = "Campamento de Harkor",
        ["zhTW"] = "哈克爾營地",
        ["zhCN"] = "哈考尔营地",
    },
    ["Vordrassil Pass"] = {
        ["ptBR"] = "Desfiladeiro de Vordrassil",
        ["ruRU"] = "Перевал Фордрассил",
        ["deDE"] = "Pass von Vordrassil",
        ["koKR"] = "볼드랏실 고개",
        ["esMX"] = "Paso de Vordrassil",
        ["enUS"] = true,
        ["frFR"] = "Passe de Vordrassil",
        ["esES"] = "Paso de Vordrassil",
        ["zhTW"] = "沃達希爾小徑",
        ["zhCN"] = "沃达希尔小径",
    },
    ["Ruuna's Camp"] = {
        ["ptBR"] = "Acampamento da Ruuna",
        ["ruRU"] = "Лагерь Рууны",
        ["deDE"] = "Ruunas Lager",
        ["koKR"] = "루나의 야영지",
        ["esMX"] = "Campamento de Ruuna",
        ["enUS"] = true,
        ["frFR"] = "Camp de Ruuna",
        ["esES"] = "Campamento de Ruuna",
        ["zhTW"] = "魯巫娜的營地",
        ["zhCN"] = "卢娜的营地",
    },
    ["Shrine of Scales"] = {
        ["ptBR"] = "Altar das Escamas",
        ["ruRU"] = "Святилище Чешуи",
        ["deDE"] = "Schrein der Schuppen",
        ["koKR"] = "비늘 제단",
        ["esMX"] = "Santuario de Escamas",
        ["enUS"] = true,
        ["frFR"] = "Sanctuaire des Écailles",
        ["esES"] = "Santuario de Escamas",
        ["zhTW"] = "群鱗聖壇",
        ["zhCN"] = "蛇鳞神殿",
    },
    ["Drak'atal Passage"] = {
        ["ptBR"] = "Passagem de Drak'atal",
        ["ruRU"] = "Перевал Драк'атала",
        ["deDE"] = "Passage von Drak'atal",
        ["koKR"] = "드라카탈 통로",
        ["esMX"] = "Pasaje de Drak'atal",
        ["enUS"] = true,
        ["frFR"] = "Passage de Drak'atal",
        ["esES"] = "Pasaje de Drak'atal",
        ["zhTW"] = "德拉克托通道",
        ["zhCN"] = "达克阿塔小径",
    },
    ["The Argent Stand"] = {
        ["ptBR"] = "Fortaleza Argêntea",
        ["ruRU"] = "Серебряная застава",
        ["deDE"] = "Die Argentumwache",
        ["koKR"] = "은빛십자군 격전지",
        ["esMX"] = "El Confín Argenta",
        ["enUS"] = true,
        ["frFR"] = "Le séjour d'Argent",
        ["esES"] = "El Confín Argenta",
        ["zhTW"] = "銀白看臺",
        ["zhCN"] = "银色前沿",
    },
    ["Altar of Sseratus"] = {
        ["ptBR"] = "Altar de Sseratus",
        ["ruRU"] = "Алтарь Шшератуса",
        ["deDE"] = "Altar von Sseratus",
        ["koKR"] = "세라투스의 제단",
        ["esMX"] = "Altar de Sseratus",
        ["enUS"] = true,
        ["frFR"] = "Autel de Sseratus",
        ["esES"] = "Altar de Sseratus",
        ["zhTW"] = "司瑟拉圖斯祭壇",
        ["zhCN"] = "西莱图斯祭坛",
    },
    ["Drak'Sotra Fields"] = {
        ["ptBR"] = "Campos de Drak'Sotra",
        ["ruRU"] = "Поля Драк'Сотры",
        ["deDE"] = "Felder von Drak'Sotra",
        ["koKR"] = "드락소트라 농장",
        ["esMX"] = "Campos Drak'Sotra",
        ["enUS"] = true,
        ["frFR"] = "Champs de Drak'Sotra",
        ["esES"] = "Campos Drak'Sotra",
        ["zhTW"] = "德拉克索璀原野",
        ["zhCN"] = "达克索塔农田",
    },
    ["Drak'Sotra"] = {
        ["ptBR"] = "Drak'Sotra",
        ["ruRU"] = "Драк'Сотра",
        ["deDE"] = "Drak'Sotra",
        ["koKR"] = "드락소트라",
        ["esMX"] = "Drak'Sotra",
        ["enUS"] = true,
        ["frFR"] = "Drak'Sotra",
        ["esES"] = "Drak'Sotra",
        ["zhTW"] = "德拉克索璀",
        ["zhCN"] = "达克索塔",
    },
    ["Drak'Agal"] = {
        ["ptBR"] = "Draz'Agal",
        ["ruRU"] = "Драк'Агал",
        ["deDE"] = "Drak'Agal",
        ["koKR"] = "드락아갈",
        ["esMX"] = "Drak'Agal",
        ["enUS"] = true,
        ["frFR"] = "Drak'Agal",
        ["esES"] = "Drak'Agal",
        ["zhTW"] = "德拉克亞苟",
        ["zhCN"] = "达克迦尔",
    },
    ["The Avalanche"] = {
        ["ptBR"] = "A Avalanche",
        ["ruRU"] = "Застывшая лавина",
        ["deDE"] = "Die Lawine",
        ["koKR"] = "눈사태 언덕",
        ["esMX"] = "La Avalancha",
        ["enUS"] = true,
        ["frFR"] = "L'Avalanche",
        ["esES"] = "La Avalancha",
        ["zhTW"] = "雪崩地",
        ["zhCN"] = "雪崩山麓",
    },
    ["Nesingwary Base Camp"] = {
        ["ptBR"] = "Acampamento do Rosarães",
        ["ruRU"] = "Лагерь Эрнестуэя",
        ["deDE"] = "Nesingwarys Basislager",
        ["koKR"] = "네싱워리 주둔지",
        ["esMX"] = "Campamento Base de Nesingwary",
        ["enUS"] = true,
        ["frFR"] = "Camp de base de Nesingwary",
        ["esES"] = "Campamento Base de Nesingwary",
        ["zhTW"] = "奈辛瓦里營地",
        ["zhCN"] = "奈辛瓦里营地",
    },
    ["The Seabreach Flow"] = {
        ["ptBR"] = "Arroio Quebra-mar",
        ["ruRU"] = "Разлом Морского Потока",
        ["deDE"] = "Der Meeresklammstrom",
        ["koKR"] = "바닷길 여울",
        ["esMX"] = "El Flujo de la Brecha del Mar",
        ["enUS"] = true,
        ["frFR"] = "Le courant de la Brèche",
        ["esES"] = "El Flujo de la Brecha del Mar",
        ["zhTW"] = "海裂之湧",
        ["zhCN"] = "碎浪河",
    },
    ["The Bones of Nozronn"] = {
        ["ptBR"] = "Ossos de Nozronn",
        ["ruRU"] = "Скелет Нозронна",
        ["deDE"] = "Die Knochen von Nozronn",
        ["koKR"] = "노즈론의 무덤",
        ["esMX"] = "Los Huesos de Nozronn",
        ["enUS"] = true,
        ["frFR"] = "Les os de Nozronn",
        ["esES"] = "Los Huesos de Nozronn",
        ["zhTW"] = "諾茲朗之骨",
        ["zhCN"] = "诺兹隆之骨",
    },
    ["Kartak's Hold"] = {
        ["ptBR"] = "Aldeia de Kartak",
        ["ruRU"] = "Форт Картака",
        ["deDE"] = "Kartaks Stellung",
        ["koKR"] = "카르탁의 요새",
        ["esMX"] = "Bastión de Kartak",
        ["enUS"] = true,
        ["frFR"] = "Bastion de Kartak",
        ["esES"] = "Bastión de Kartak",
        ["zhTW"] = "卡爾塔克堡",
        ["zhCN"] = "卡塔克要塞",
    },
    ["Sparktouched Haven"] = {
        ["ptBR"] = "Refúgio Piscabrilha",
        ["ruRU"] = "Заиндевелая гавань",
        ["deDE"] = "Zuflucht der Funkenbesprühten",
        ["koKR"] = "번개불꽃 안식처",
        ["esMX"] = "Retiro Pavesa",
        ["enUS"] = true,
        ["frFR"] = "Le havre Touchétincelle",
        ["esES"] = "Retiro Pavesa",
        ["zhTW"] = "炫觸避風港",
        ["zhCN"] = "灵鳍湾",
    },
    ["The Path of the Lifewarden"] = {
        ["ptBR"] = "Caminho da Guardiã da Vida",
        ["ruRU"] = "Путь Хранителя Жизни",
        ["deDE"] = "Der Pfad der Lebenswächterin",
        ["koKR"] = "생명 감시자의 길",
        ["esMX"] = "La Senda del Guardián de Vida",
        ["enUS"] = true,
        ["frFR"] = "Le chemin de la Gardienne de la vie",
        ["esES"] = "La Senda del Guardián de Vida",
        ["zhTW"] = "生命守護者之路",
        ["zhCN"] = "生命守卫者之路",
    },
    ["Heb'Valok"] = {
        ["ptBR"] = "Heb'Valok",
        ["ruRU"] = "Хеб'Валок",
        ["deDE"] = "Heb'Valok",
        ["koKR"] = "헤브발로크",
        ["esMX"] = "Heb'Valok",
        ["enUS"] = true,
        ["frFR"] = "Heb'Valok",
        ["esES"] = "Heb'Valok",
        ["zhTW"] = "希伯伐洛克",
        ["zhCN"] = "赫布瓦罗",
    },
    ["Plaguelands: The Scarlet Enclave"] = {
        ["ptBR"] = "Terras Pestilentas: Enclave Escarlate",
        ["ruRU"] = "Чумные земли: Анклав Алого ордена",
        ["deDE"] = "Pestländer: Die Scharlachrote Enklave",
        ["koKR"] = "동부 역병지대: 붉은십자군 초소",
        ["esMX"] = "Tierras de la Peste: El Enclave Escarlata",
        ["enUS"] = true,
        ["frFR"] = "Maleterres : l'enclave Écarlate",
        ["esES"] = "Tierras de la Peste: El Enclave Escarlata",
        ["zhTW"] = "東瘟疫之地: 血色領區",
        ["zhCN"] = "东瘟疫之地：血色领地",
    },
    ["Kolramas"] = {
        ["ptBR"] = "Kolramas",
        ["ruRU"] = "Колрамас",
        ["deDE"] = "Kolramas",
        ["koKR"] = "콜라마스",
        ["esMX"] = "Kolramas",
        ["enUS"] = true,
        ["frFR"] = "Kolramas",
        ["esES"] = "Kolramas",
        ["zhTW"] = "科爾拉瑪斯",
        ["zhCN"] = "科尔拉玛斯",
    },
    ["Mistwhisper Refuge"] = {
        ["ptBR"] = "Refúgio Brumurmúria",
        ["ruRU"] = "Убежище Шепота Тумана",
        ["deDE"] = "Zuflucht der Nebelflüsterer",
        ["koKR"] = "안개속삭임 야영지",
        ["esMX"] = "Refugio Susurraneblina",
        ["enUS"] = true,
        ["frFR"] = "Le refuge de Murmebrume",
        ["esES"] = "Refugio Susurraneblina",
        ["zhTW"] = "霧語避難所",
        ["zhCN"] = "雾语村",
    },
    ["The Glimmering Pillar"] = {
        ["ptBR"] = "Pilar Rutilante",
        ["ruRU"] = "Мерцающая колонна",
        ["deDE"] = "Die Schimmersäule",
        ["koKR"] = "미명의 봉우리",
        ["esMX"] = "El Pilar Iluminado",
        ["enUS"] = true,
        ["frFR"] = "Le pilier Scintillant",
        ["esES"] = "El Pilar Iluminado",
        ["zhTW"] = "微光之柱",
        ["zhCN"] = "光芒之柱",
    },
    ["Spearborn Encampment"] = {
        ["ptBR"] = "Assentamento do Povo da Lança",
        ["ruRU"] = "Лагерь Копьеносца",
        ["deDE"] = "Lager der Speerträger",
        ["koKR"] = "작살사냥꾼 야영지",
        ["esMX"] = "Campamento Lanzonato",
        ["enUS"] = true,
        ["frFR"] = "Campement Né-des-lances",
        ["esES"] = "Campamento Lanzonato",
        ["zhTW"] = "矛生駐營",
        ["zhCN"] = "锐矛营地",
    },
    ["Zeramas"] = {
        ["ptBR"] = "Zeramas",
        ["ruRU"] = "Зерамас",
        ["deDE"] = "Zeramas",
        ["koKR"] = "제라마스",
        ["esMX"] = "Zeramas",
        ["enUS"] = true,
        ["frFR"] = "Zeramas",
        ["esES"] = "Zeramas",
        ["zhTW"] = "賽拉瑪斯",
        ["zhCN"] = "泽尔拉玛斯",
    },
    ["Reliquary of Agony"] = {
        ["ptBR"] = "Relicário da Agonia",
        ["ruRU"] = "Реликварий Агонии",
        ["deDE"] = "Reliquie der Pein",
        ["koKR"] = "고뇌의 성물함",
        ["esMX"] = "Relicario de Agonía",
        ["enUS"] = true,
        ["frFR"] = "Reliquaire d'agonie",
        ["esES"] = "Relicario de Agonía",
        ["zhTW"] = "苦楚聖匣",
        ["zhCN"] = "折磨之匣",
    },
    ["Ebon Watch"] = {
        ["ptBR"] = "Posto Ébano",
        ["ruRU"] = "Черная застава",
        ["deDE"] = "Die Schwarze Wacht",
        ["koKR"] = "칠흑의 감시초소",
        ["esMX"] = "Puesto de Vigilancia de Ébano",
        ["enUS"] = true,
        ["frFR"] = "Guet d'Ébène",
        ["esES"] = "Puesto de Vigilancia de Ébano",
        ["zhTW"] = "黯黑守望",
        ["zhCN"] = "黑锋哨站",
    },
    ["Thrym's End"] = {
        ["ptBR"] = "Ruína de Thrym",
        ["ruRU"] = "Тупик Трыма",
        ["deDE"] = "Thryms Ende",
        ["koKR"] = "스림의 최후",
        ["esMX"] = "Fin de Thrym",
        ["enUS"] = true,
        ["frFR"] = "Fin de Thrym",
        ["esES"] = "Fin de Thrym",
        ["zhTW"] = "瑟瑞姆之歿",
        ["zhCN"] = "塞穆之末",
    },
    ["Voltarus"] = {
        ["ptBR"] = "Voltarus",
        ["ruRU"] = "Волтар",
        ["deDE"] = "Voltarus",
        ["koKR"] = "볼타루스",
        ["esMX"] = "Voltarus",
        ["enUS"] = true,
        ["frFR"] = "Voltarus",
        ["esES"] = "Voltarus",
        ["zhTW"] = "沃塔魯斯",
        ["zhCN"] = "沃尔塔鲁斯",
    },
    ["Reliquary of Pain"] = {
        ["ptBR"] = "Relicário da Dor",
        ["ruRU"] = "Реликварий Боли",
        ["deDE"] = "Reliquiar des Schmerzes",
        ["koKR"] = "고통의 성물함",
        ["esMX"] = "Relicario de Dolor",
        ["enUS"] = true,
        ["frFR"] = "Reliquaire de souffrance",
        ["esES"] = "Relicario de Dolor",
        ["zhTW"] = "痛苦聖匣",
        ["zhCN"] = "痛苦之匣",
    },
    ["Rageclaw Den"] = {
        ["ptBR"] = "Covil Patafúria",
        ["ruRU"] = "Логово Яростного Когтя",
        ["deDE"] = "Zornklauenbau",
        ["koKR"] = "성난발톱 소굴",
        ["esMX"] = "Guarida de Garrafuria",
        ["enUS"] = true,
        ["frFR"] = "Tanière Grifferage",
        ["esES"] = "Guarida de Garrafuria",
        ["zhTW"] = "怒爪巢穴",
        ["zhCN"] = "怒爪巢穴",
    },
    ["Light's Breach"] = {
        ["ptBR"] = "Campo da Luz",
        ["ruRU"] = "Разлом Света",
        ["deDE"] = "Die Lichtbresche",
        ["koKR"] = "빛의 틈",
        ["esMX"] = "Brecha de la Luz",
        ["enUS"] = true,
        ["frFR"] = "La Brèche de Lumière",
        ["esES"] = "Brecha de la Luz",
        ["zhTW"] = "聖光止境",
        ["zhCN"] = "圣光据点",
    },
    ["Pools of Zha'Jin"] = {
        ["ptBR"] = "Poços de Zha'Jin",
        ["ruRU"] = "Озера Жа'Джина",
        ["deDE"] = "Teiche von Zha'Jin",
        ["koKR"] = "자진의 웅덩이",
        ["esMX"] = "Pozas de Zha'Jin",
        ["enUS"] = true,
        ["frFR"] = "Bassins de Zha'Jin",
        ["esES"] = "Pozas de Zha'Jin",
        ["zhTW"] = "薩金之池",
        ["zhCN"] = "扎尔金之池",
    },
    ["Zim'Abwa"] = {
        ["ptBR"] = "Zim'Abwa",
        ["ruRU"] = "Зим'Абва",
        ["deDE"] = "Zim'Abwa",
        ["koKR"] = "짐아브와",
        ["esMX"] = "Zim'Abwa",
        ["enUS"] = true,
        ["frFR"] = "Zim'Abwa",
        ["esES"] = "Zim'Abwa",
        ["zhTW"] = "辛阿布瓦",
        ["zhCN"] = "希姆埃巴",
    },
    ["Amphitheater of Anguish"] = {
        ["ptBR"] = "Anfiteatro da Angústia",
        ["ruRU"] = "Амфитеатр Страданий",
        ["deDE"] = "Amphitheater der Agonie",
        ["koKR"] = "고뇌의 투기장",
        ["esMX"] = "Anfiteatro de la Angustia",
        ["enUS"] = true,
        ["frFR"] = "Amphithéâtre de l'Angoisse",
        ["esES"] = "Anfiteatro de la Angustia",
        ["zhTW"] = "苦痛露天競技場",
        ["zhCN"] = "痛苦斗兽场",
    },
    ["Altar of Rhunok"] = {
        ["ptBR"] = "Altar de Rhunok",
        ["ruRU"] = "Алтарь Рунока",
        ["deDE"] = "Altar von Rhunok",
        ["koKR"] = "루노크의 제단",
        ["esMX"] = "Altar de Rhunok",
        ["enUS"] = true,
        ["frFR"] = "Autel de Rhunok",
        ["esES"] = "Altar de Rhunok",
        ["zhTW"] = "魯諾克祭壇",
        ["zhCN"] = "伦诺克祭坛",
    },
    ["Altar of Har'koa"] = {
        ["ptBR"] = "Altar de Har'koa",
        ["ruRU"] = "Алтарь Хар'коа",
        ["deDE"] = "Altar von Har'koa",
        ["koKR"] = "하르코아의 제단",
        ["esMX"] = "Altar de Har'koa",
        ["enUS"] = true,
        ["frFR"] = "Autel de Har'koa",
        ["esES"] = "Altar de Har'koa",
        ["zhTW"] = "哈寇亞祭壇",
        ["zhCN"] = "哈克娅祭坛",
    },
    ["Zim'Torga"] = {
        ["ptBR"] = "Zim'Torga",
        ["ruRU"] = "Зим'Торга",
        ["deDE"] = "Zim'Torga",
        ["koKR"] = "짐토르가",
        ["esMX"] = "Zim'Torga",
        ["enUS"] = true,
        ["frFR"] = "Zim'Torga",
        ["esES"] = "Zim'Torga",
        ["zhTW"] = "辛托加",
        ["zhCN"] = "希姆托加",
    },
    ["Pools of Jin'Alai"] = {
        ["ptBR"] = "Poços de Jin'Alai",
        ["ruRU"] = "Бассейн Джин'Алаи",
        ["deDE"] = "Teiche von Jin'Alai",
        ["koKR"] = "진알라이의 웅덩이",
        ["esMX"] = "Pozas de Jin'Alai",
        ["enUS"] = true,
        ["frFR"] = "Bassins de Jin'Alai",
        ["esES"] = "Pozas de Jin'Alai",
        ["zhTW"] = "金阿萊之池",
        ["zhCN"] = "金亚莱之池",
    },
    ["Altar of Quetz'lun"] = {
        ["ptBR"] = "Altar de Quetz'lun",
        ["ruRU"] = "Алтарь Кетц'лун",
        ["deDE"] = "Altar von Quetz'lun",
        ["koKR"] = "쿠에츠룬의 제단",
        ["esMX"] = "Altar de Quetz'lun",
        ["enUS"] = true,
        ["frFR"] = "Autel de Quetz'lun",
        ["esES"] = "Altar de Quetz'lun",
        ["zhTW"] = "奎茲倫祭壇",
        ["zhCN"] = "奎丝鲁恩祭坛",
    },
    ["Heb'Drakkar"] = {
        ["ptBR"] = "Heb'Drakkar",
        ["ruRU"] = "Хеб'Драккар",
        ["deDE"] = "Heb'Drakkar",
        ["koKR"] = "헤브드라카",
        ["esMX"] = "Heb'Drakkar",
        ["enUS"] = true,
        ["frFR"] = "Heb'Drakkar",
        ["esES"] = "Heb'Drakkar",
        ["zhTW"] = "希伯德拉卡",
        ["zhCN"] = "赫布达卡",
    },
    ["Drak'Mabwa"] = {
        ["ptBR"] = "Drak'Mabwa",
        ["ruRU"] = "Драк'Мабва",
        ["deDE"] = "Drak'Mabwa",
        ["koKR"] = "드락마브와",
        ["esMX"] = "Drak'Mabwa",
        ["enUS"] = true,
        ["frFR"] = "Drak'Mabwa",
        ["esES"] = "Drak'Mabwa",
        ["zhTW"] = "德拉克瑪布瓦",
        ["zhCN"] = "达克玛瓦",
    },
    ["Zim'Rhuk"] = {
        ["ptBR"] = "Zim'Rhuk",
        ["ruRU"] = "Зим'Рук",
        ["deDE"] = "Zim'Rhuk",
        ["koKR"] = "짐루크",
        ["esMX"] = "Zim'Rhuk",
        ["enUS"] = true,
        ["frFR"] = "Zim'Rhuk",
        ["esES"] = "Zim'Rhuk",
        ["zhTW"] = "辛茹克",
        ["zhCN"] = "希姆鲁克",
    },
    ["Altar of Mam'toth"] = {
        ["ptBR"] = "Altar de Mam'toth",
        ["ruRU"] = "Алтарь Мам'Тота",
        ["deDE"] = "Altar von Mam'toth",
        ["koKR"] = "맘토스의 제단",
        ["esMX"] = "Altar de Mam'toth",
        ["enUS"] = true,
        ["frFR"] = "Autel de Mam'toth",
        ["esES"] = "Altar de Mam'toth",
        ["zhTW"] = "瑪姆托司祭壇",
        ["zhCN"] = "犸托斯祭坛",
    },
    ["Acherus: The Ebon Hold"] = {
        ["ptBR"] = "Áquerus: A Fortaleza de Ébano",
        ["ruRU"] = "Акерус: Черный оплот",
        ["deDE"] = "Acherus: Die Schwarze Festung",
        ["koKR"] = "아케루스: 칠흑의 요새",
        ["esMX"] = "Acherus: El Bastión de Ébano",
        ["enUS"] = true,
        ["frFR"] = "Achérus : le fort d'Ébène",
        ["esES"] = "Acherus: El Bastión de Ébano",
        ["zhTW"] = "亞榭洛:黯黑堡",
        ["zhCN"] = "阿彻鲁斯：黑锋要塞",
    },
    ["New Avalon"] = {
        ["ptBR"] = "Nova Avalon",
        ["ruRU"] = "Новый Авалон",
        ["deDE"] = "Neu-Avalon",
        ["koKR"] = "신 아발론",
        ["esMX"] = "Nuevo Avalon",
        ["enUS"] = true,
        ["frFR"] = "Nouvelle-Avalon",
        ["esES"] = "Nuevo Avalon",
        ["zhTW"] = "新亞法隆",
        ["zhCN"] = "新阿瓦隆",
    },
    ["New Avalon Fields"] = {
        ["ptBR"] = "Campos de Nova Avalon",
        ["ruRU"] = "Поля Нового Авалона",
        ["deDE"] = "Felder von Neu-Avalon",
        ["koKR"] = "신 아발론 농장",
        ["esMX"] = "Campos de Nuevo Avalon",
        ["enUS"] = true,
        ["frFR"] = "Champs de la Nouvelle-Avalon",
        ["esES"] = "Campos de Nuevo Avalon",
        ["zhTW"] = "新亞法隆農地",
        ["zhCN"] = "新阿瓦隆农田",
    },
    ["New Avalon Orchard"] = {
        ["ptBR"] = "Pomar de Nova Avalon",
        ["ruRU"] = "Сад Нового Авалона",
        ["deDE"] = "Obsthain von Neu-Avalon",
        ["koKR"] = "신 아발론 과수원",
        ["esMX"] = "Huerto de Nuevo Avalon",
        ["enUS"] = true,
        ["frFR"] = "Vergers de la Nouvelle-Avalon",
        ["esES"] = "Huerto de Nuevo Avalon",
        ["zhTW"] = "新亞法隆果林",
        ["zhCN"] = "新阿瓦隆果园",
    },
    ["New Avalon Town Hall"] = {
        ["ptBR"] = "Prefeitura de Nova Avalon",
        ["ruRU"] = "Ратуша Нового Авалона",
        ["deDE"] = "Rathaus von Neu-Avalon",
        ["koKR"] = "신 아발론 마을회관",
        ["esMX"] = "Concejo de Nuevo Avalon",
        ["enUS"] = true,
        ["frFR"] = "Hôtel de ville de la Nouvelle-Avalon",
        ["esES"] = "Concejo de Nuevo Avalon",
        ["zhTW"] = "新亞法隆市政廳",
        ["zhCN"] = "新阿瓦隆市政厅",
    },
    ["Havenshire"] = {
        ["ptBR"] = "Vila do Amparo",
        ["ruRU"] = "Тихоземье",
        ["deDE"] = "Havenau",
        ["koKR"] = "헤이븐샤이어",
        ["esMX"] = "Villa Refugio",
        ["enUS"] = true,
        ["frFR"] = "Havre-comté",
        ["esES"] = "Villa Refugio",
        ["zhTW"] = "避風郡",
        ["zhCN"] = "海文郡",
    },
    ["Havenshire Farms"] = {
        ["ptBR"] = "Fazendas da Vila do Amparo",
        ["ruRU"] = "Тихоземские фермы",
        ["deDE"] = "Höfe von Havenau",
        ["koKR"] = "헤이븐샤이어 농장",
        ["esMX"] = "Granjas de Villa Refugio",
        ["enUS"] = true,
        ["frFR"] = "Fermes de Havre-comté",
        ["esES"] = "Granjas de Villa Refugio",
        ["zhTW"] = "避風郡農場",
        ["zhCN"] = "海文郡农场",
    },
    ["Havenshire Lumber Mill"] = {
        ["ptBR"] = "Serraria Vila do Amparo",
        ["ruRU"] = "Тихоземская лесопилка",
        ["deDE"] = "Sägewerk von Havenau",
        ["koKR"] = "헤이븐샤이어 제재소",
        ["esMX"] = "Serrería de Villa Refugio",
        ["enUS"] = true,
        ["frFR"] = "Scierie de Havre-comté",
        ["esES"] = "Serrería de Villa Refugio",
        ["zhTW"] = "避風郡伐木場",
        ["zhCN"] = "海文郡伐木场",
    },
    ["Havenshire Stables"] = {
        ["ptBR"] = "Estábulos da Vila do Amparo",
        ["ruRU"] = "Тихоземские стойла",
        ["deDE"] = "Ställe von Havenau",
        ["koKR"] = "헤이븐샤이어 마구간",
        ["esMX"] = "Establos de Villa Refugio",
        ["enUS"] = true,
        ["frFR"] = "Écurie de Havre-comté",
        ["esES"] = "Establos de Villa Refugio",
        ["zhTW"] = "避風郡獸欄",
        ["zhCN"] = "海文郡马厩",
    },
    ["Scarlet Hold"] = {
        ["ptBR"] = "Castelo Escarlate",
        ["ruRU"] = "Крепость Алого ордена",
        ["deDE"] = "Scharlachrote Festung",
        ["koKR"] = "붉은십자군 요새",
        ["esMX"] = "El Bastión Escarlata",
        ["enUS"] = true,
        ["frFR"] = "Fort écarlate",
        ["esES"] = "El Bastión Escarlata",
        ["zhTW"] = "血色堡",
        ["zhCN"] = "血色城堡",
    },
    ["Chapel of the Crimson Flame"] = {
        ["ptBR"] = "Capela da Chama Carmesim",
        ["ruRU"] = "Часовня Багрового Пламени",
        ["deDE"] = "Kapelle der Scharlachroten Flamme",
        ["koKR"] = "진홍불꽃의 예배당",
        ["esMX"] = "Capilla de la Llama Carmesí",
        ["enUS"] = true,
        ["frFR"] = "Chapelle de la Flamme cramoisie",
        ["esES"] = "Capilla de la Llama Carmesí",
        ["zhTW"] = "赤紅之焰禮拜堂",
        ["zhCN"] = "赤色烈焰礼拜堂",
    },
    ["Light's Point Tower"] = {
        ["ptBR"] = "Torre Ponto de Luz",
        ["ruRU"] = "Башня Заставы Света",
        ["deDE"] = "Lichtgipfelturm",
        ["koKR"] = "빛의 거점탑",
        ["esMX"] = "Torre de la Punta de la Luz",
        ["enUS"] = true,
        ["frFR"] = "Tour de la halte de la Lumière",
        ["esES"] = "Torre de la Punta de la Luz",
        ["zhTW"] = "聖光之尖哨塔",
        ["zhCN"] = "圣光哨塔",
    },
    ["Light's Point"] = {
        ["ptBR"] = "Pontal da Luz",
        ["ruRU"] = "Застава Света",
        ["deDE"] = "Lichtgipfel",
        ["koKR"] = "빛의 거점",
        ["esMX"] = "Punta de la Luz",
        ["enUS"] = true,
        ["frFR"] = "Halte de la Lumière",
        ["esES"] = "Punta de la Luz",
        ["zhTW"] = "聖光之尖",
        ["zhCN"] = "圣光哨站",
    },
    ["Crypt of Remembrance"] = {
        ["ptBR"] = "Cripta da Memória",
        ["ruRU"] = "Склеп Воспоминаний",
        ["deDE"] = "Krypta der Erinnerung",
        ["koKR"] = "기념 납골당",
        ["esMX"] = "Cripta de los Recuerdos",
        ["enUS"] = true,
        ["frFR"] = "La crypte du Souvenir",
        ["esES"] = "Cripta de los Recuerdos",
        ["zhTW"] = "緬懷墓穴",
        ["zhCN"] = "追忆墓穴",
    },
    ["The Noxious Glade"] = {
        ["ptBR"] = "Clareira Nociva",
        ["ruRU"] = "Ядовитая поляна",
        ["deDE"] = "Das giftige Tal",
        ["koKR"] = "맹독의 숲",
        ["esMX"] = "El Claro Ponzoñoso",
        ["enUS"] = true,
        ["frFR"] = "La Clairière nocive",
        ["esES"] = "El Claro Ponzoñoso",
        ["zhTW"] = "劇毒林地",
        ["zhCN"] = "剧毒林地",
    },
    ["Tyr's Hand"] = {
        ["ptBR"] = "Manopla de Tyr",
        ["ruRU"] = "Длань Тира",
        ["deDE"] = "Tyrs Hand",
        ["koKR"] = "티르의 손 수도원",
        ["esMX"] = "Mano de Tyr",
        ["enUS"] = true,
        ["frFR"] = "Main de Tyr",
        ["esES"] = "Mano de Tyr",
        ["zhTW"] = "提爾之手",
        ["zhCN"] = "提尔之手",
    },
    ["King's Harbor"] = {
        ["ptBR"] = "Porto Real",
        ["ruRU"] = "Королевская гавань",
        ["deDE"] = "Hafen des Königs",
        ["koKR"] = "왕의 항구",
        ["esMX"] = "Puerto del Rey",
        ["enUS"] = true,
        ["frFR"] = "Port-royal",
        ["esES"] = "Puerto del Rey",
        ["zhTW"] = "國王港",
        ["zhCN"] = "国王港",
    },
    ["Scarlet Overlook"] = {
        ["ptBR"] = "Penhasco Escarlate",
        ["ruRU"] = "Дозорное укрепление Алого ордена",
        ["deDE"] = "Scharlachroter Rundblick",
        ["koKR"] = "붉은십자군 전망대",
        ["esMX"] = "Mirador Escarlata",
        ["enUS"] = true,
        ["frFR"] = "Le surplomb Écarlate",
        ["esES"] = "Mirador Escarlata",
        ["zhTW"] = "血色瞰臺",
        ["zhCN"] = "血色悬崖",
    },
    ["Light's Hope Chapel"] = {
        ["ptBR"] = "Capela Esperança da Luz",
        ["ruRU"] = "Часовня Последней Надежды",
        ["deDE"] = "Kapelle des hoffnungsvollen Lichts",
        ["koKR"] = "희망의 빛 예배당",
        ["esMX"] = "Capilla de la Esperanza de la Luz",
        ["enUS"] = true,
        ["frFR"] = "Chapelle de l'Espoir de Lumière",
        ["esES"] = "Capilla de la Esperanza de la Luz",
        ["zhTW"] = "聖光之願禮拜堂",
        ["zhCN"] = "圣光之愿礼拜堂",
    },
    ["Sinner's Folly"] = {
        ["ptBR"] = "Extravagância do Pecador",
        ["ruRU"] = "Глупость Грешника",
        ["deDE"] = "Sündenbabel",
        ["koKR"] = "불신자의 만용호",
        ["esMX"] = "Locura del Pecador",
        ["enUS"] = true,
        ["frFR"] = "Folie du pécheur",
        ["esES"] = "Locura del Pecador",
        ["zhTW"] = "罪人愚行號",
        ["zhCN"] = "罪人的愚行",
    },
    ["Pestilent Scar"] = {
        ["ptBR"] = "Cicatriz Pestilenta",
        ["ruRU"] = "Моровой овраг",
        ["deDE"] = "Pestilenznarbe",
        ["koKR"] = "전염의 흉터",
        ["esMX"] = "Cicatriz Pestilente",
        ["enUS"] = true,
        ["frFR"] = "Balafre pestilentielle",
        ["esES"] = "Cicatriz Pestilente",
        ["zhTW"] = "瘟疫之痕",
        ["zhCN"] = "瘟疫之痕",
    },
    ["Browman Mill"] = {
        ["ptBR"] = "Engenho Assombrado",
        ["ruRU"] = "Лесопилка Бровача",
        ["deDE"] = "Braumanns Mühle",
        ["koKR"] = "브라우만 밀농장",
        ["esMX"] = "Molino Cejifrente",
        ["enUS"] = true,
        ["frFR"] = "Scierie de Browman",
        ["esES"] = "Molino Cejifrente",
        ["zhTW"] = "布洛米爾",
        ["zhCN"] = "布洛米尔",
    },
    ["Havenshire Mine"] = {
        ["ptBR"] = "Mina da Vila do Amparo",
        ["ruRU"] = "Тихоземская шахта",
        ["deDE"] = "Mine von Havenau",
        ["koKR"] = "헤이븐샤이어 광산",
        ["esMX"] = "Mina de Villa Refugio",
        ["enUS"] = true,
        ["frFR"] = "Mine de Havre-comté",
        ["esES"] = "Mina de Villa Refugio",
        ["zhTW"] = "避風郡礦坑",
        ["zhCN"] = "海文郡矿洞",
    },
    ["Ursoc's Den"] = {
        ["ptBR"] = "Covil de Ursoc",
        ["ruRU"] = "Логово Урсока",
        ["deDE"] = "Ursocs Höhle",
        ["koKR"] = "우르속의 동굴",
        ["esMX"] = "El Cubil de Ursoc",
        ["enUS"] = true,
        ["frFR"] = "Tanière d'Ursoc",
        ["esES"] = "El Cubil de Ursoc",
        ["zhTW"] = "厄索克之穴",
        ["zhCN"] = "乌索克之巢",
    },
    ["The Bonefields"] = {
        ["ptBR"] = "Os Campos de Ossos",
        ["ruRU"] = "Поля Костей",
        ["deDE"] = "Die Knochenfelder",
        ["koKR"] = "뼈의 언덕",
        ["esMX"] = "Los Campos de Huesos",
        ["enUS"] = true,
        ["frFR"] = "Les champs d'Ossements",
        ["esES"] = "Los Campos de Huesos",
        ["zhTW"] = "白骨原野",
        ["zhCN"] = "埋骨地",
    },
    ["Dorian's Outpost"] = {
        ["ptBR"] = "Posto Avançado de Dorian",
        ["ruRU"] = "Форпост Дориана",
        ["deDE"] = "Dorians Außenposten",
        ["koKR"] = "도리안의 전초기지",
        ["esMX"] = "Avanzada de Dorian",
        ["enUS"] = true,
        ["frFR"] = "Avant-poste de Dorian",
        ["esES"] = "Avanzada de Dorian",
        ["zhTW"] = "多里安前哨",
        ["zhCN"] = "多里安哨站",
    },
    ["Mam'toth Crater"] = {
        ["ptBR"] = "Cratera de Mam'toth",
        ["ruRU"] = "Кратер Мам'Тота",
        ["deDE"] = "Krater Mam'toth",
        ["koKR"] = "맘토스 분화구",
        ["esMX"] = "Cráter de Mam'toth",
        ["enUS"] = true,
        ["frFR"] = "Cratère de Mam'toth",
        ["esES"] = "Cráter de Mam'toth",
        ["zhTW"] = "瑪姆托司爆坑",
        ["zhCN"] = "犸托斯巨坑",
    },
    ["Zol'Maz Stronghold"] = {
        ["ptBR"] = "Fortaleza de Zol'Maz",
        ["ruRU"] = "Крепость Зол'Маз",
        ["deDE"] = "Festung Zol'Maz",
        ["koKR"] = "졸마즈 요새",
        ["esMX"] = "Bastión de Zol'Maz",
        ["enUS"] = true,
        ["frFR"] = "Bastion de Zol'Maz",
        ["esES"] = "Bastión de Zol'Maz",
        ["zhTW"] = "佐爾馬茲堡砦",
        ["zhCN"] = "佐尔玛兹要塞",
    },
    ["Zol'Heb"] = {
        ["ptBR"] = "Zol'Heb",
        ["ruRU"] = "Зол'Хеб",
        ["deDE"] = "Zol'Heb",
        ["koKR"] = "졸헤브",
        ["esMX"] = "Zol'Heb",
        ["enUS"] = true,
        ["frFR"] = "Zol'Heb",
        ["esES"] = "Zol'Heb",
        ["zhTW"] = "佐爾希伯",
        ["zhCN"] = "佐尔赫布",
    },
    ["Rageclaw Lake"] = {
        ["ptBR"] = "Lago Patafúria",
        ["ruRU"] = "Озеро Яростного Когтя",
        ["deDE"] = "Zornklauensee",
        ["koKR"] = "성난발톱 호수",
        ["esMX"] = "Lago de Garrafuria",
        ["enUS"] = true,
        ["frFR"] = "Lac Grifferage",
        ["esES"] = "Lago de Garrafuria",
        ["zhTW"] = "怒爪湖",
        ["zhCN"] = "怒爪湖",
    },
    ["The Savage Thicket"] = {
        ["ptBR"] = "Floresta Selvagem",
        ["ruRU"] = "Дикая чаща",
        ["deDE"] = "Das Wilde Dickicht",
        ["koKR"] = "야만의 숲",
        ["esMX"] = "El Matorral Silvestre",
        ["enUS"] = true,
        ["frFR"] = "Le fourré Sauvage",
        ["esES"] = "El Matorral Silvestre",
        ["zhTW"] = "蠻荒灌木林",
        ["zhCN"] = "蛮荒树林",
    },
    ["New Avalon Forge"] = {
        ["ptBR"] = "Forja de Nova Avalon",
        ["ruRU"] = "Кузня Нового Авалона",
        ["deDE"] = "Schmiede von Neu-Avalon",
        ["koKR"] = "신 아발론 대장간",
        ["esMX"] = "Forja de Nuevo Avalon",
        ["enUS"] = true,
        ["frFR"] = "Forge de la Nouvelle-Avalon",
        ["esES"] = "Forja de Nuevo Avalon",
        ["zhTW"] = "新亞法隆熔爐",
        ["zhCN"] = "新阿瓦隆熔炉",
    },
    ["Dalaran Arena"] = {
        ["ptBR"] = "Arena de Dalaran",
        ["ruRU"] = "Арена Даларана",
        ["deDE"] = "Arena von Dalaran",
        ["koKR"] = "달라란 투기장",
        ["esMX"] = "Arena de Dalaran",
        ["enUS"] = true,
        ["frFR"] = "Arène de Dalaran",
        ["esES"] = "Arena de Dalaran",
        ["zhTW"] = "達拉然競技場",
        ["zhCN"] = "达拉然竞技场",
    },
    ["Westguard Inn"] = {
        ["ptBR"] = "Estalagem da Guarda Oeste",
        ["ruRU"] = "Таверна Западной Стражи",
        ["deDE"] = "Gasthaus der Westwacht",
        ["koKR"] = "서부경비대 여관",
        ["esMX"] = "Taberna de Guardia Oeste",
        ["enUS"] = true,
        ["frFR"] = "Auberge de la Garde de l'ouest",
        ["esES"] = "Taberna de Guardia Oeste",
        ["zhTW"] = "鎮西旅店",
        ["zhCN"] = "西部卫戍要塞旅店",
    },
    ["Waygate"] = {
        ["ptBR"] = "Pórtico",
        ["ruRU"] = "Связующая спираль",
        ["deDE"] = "Das Tor",
        ["koKR"] = "차원문",
        ["esMX"] = "Puerta",
        ["enUS"] = true,
        ["frFR"] = "Portail d'accès",
        ["esES"] = "Puerta",
        ["zhTW"] = "甬道之門",
        ["zhCN"] = "界门",
    },
    ["The Shaper's Terrace"] = {
        ["ptBR"] = "O Terraço do Moldador",
        ["ruRU"] = "Терраса Создателя",
        ["deDE"] = "Die Terrasse des Formers",
        ["koKR"] = "구체자의 정원",
        ["esMX"] = "El Bancal del Creador",
        ["enUS"] = true,
        ["frFR"] = "La terrasse du Façonneur",
        ["esES"] = "El Bancal del Creador",
        ["zhTW"] = "塑造者殿堂",
        ["zhCN"] = "塑造者之台",
    },
    ["Strand of the Ancients"] = {
        ["ptBR"] = "Baía dos Ancestrais",
        ["ruRU"] = "Берег Древних",
        ["deDE"] = "Strand der Uralten",
        ["koKR"] = "고대의 해안",
        ["esMX"] = "Playa de los Ancestros",
        ["enUS"] = true,
        ["frFR"] = "Rivage des Anciens",
        ["esES"] = "Playa de los Ancestros",
        ["zhTW"] = "遠祖灘頭",
        ["zhCN"] = "远古海滩",
    },
    ["Bittertide Lake"] = {
        ["ptBR"] = "Lago Maremarga",
        ["ruRU"] = "Озеро Горьких Волн",
        ["deDE"] = "Bittertidensee",
        ["koKR"] = "거센물결 호수",
        ["esMX"] = "Lago Olamarga",
        ["enUS"] = true,
        ["frFR"] = "Lac de Flot-amer",
        ["esES"] = "Lago Olamarga",
        ["zhTW"] = "惡潮湖",
        ["zhCN"] = "苦潮湖",
    },
    ["The Suntouched Pillar"] = {
        ["ptBR"] = "Pilar Tocado pelo Sol",
        ["ruRU"] = "Колонна Солнечного Благословения",
        ["deDE"] = "Die Sonnenstrahlsäule",
        ["koKR"] = "해마루 봉우리",
        ["esMX"] = "El Pilar Toquesol",
        ["enUS"] = true,
        ["frFR"] = "Le pilier Solegrâce",
        ["esES"] = "El Pilar Toquesol",
        ["zhTW"] = "日觸之柱",
        ["zhCN"] = "日灼之柱",
    },
    ["Frigid Breach"] = {
        ["ptBR"] = "Pontal Frio",
        ["ruRU"] = "Хладный разлом",
        ["deDE"] = "Die Eisbresche",
        ["koKR"] = "얼어붙은 틈",
        ["esMX"] = "Brecha Gélida",
        ["enUS"] = true,
        ["frFR"] = "Brèche algide",
        ["esES"] = "Brecha Gélida",
        ["zhTW"] = "嚴寒止境",
        ["zhCN"] = "冰冷裂口",
    },
    ["Swindlegrin's Dig"] = {
        ["ptBR"] = "Escavação do Caloteiro",
        ["ruRU"] = "Раскоп Хитрохмыла",
        ["deDE"] = "Schwindelgrins' Grabungsstätte",
        ["koKR"] = "스윈들그린의 채굴현장",
        ["esMX"] = "Excavación de Timomueca",
        ["enUS"] = true,
        ["frFR"] = "Site de fouilles de Ricarnaque",
        ["esES"] = "Excavación de Timomueca",
        ["zhTW"] = "詐咧挖掘場",
        ["zhCN"] = "斯温迪格林挖掘场",
    },
    ["The Stormwright's Shelf"] = {
        ["ptBR"] = "Prateleira do Criador da Tempestade",
        ["ruRU"] = "Уступ Ваятеля Бурь",
        ["deDE"] = "Das Sturmherrenschelf",
        ["koKR"] = "폭풍전령 바위",
        ["esMX"] = "La Plataforma del Tormentoso",
        ["enUS"] = true,
        ["frFR"] = "La saillie de Forgetempête",
        ["esES"] = "La Plataforma del Tormentoso",
        ["zhTW"] = "風暴工匠沙洲",
        ["zhCN"] = "雷暴台地",
    },
    ["Death's Hand Encampment"] = {
        ["ptBR"] = "Posto Avançado Mão da Morte",
        ["ruRU"] = "Лагерь Руки Смерти",
        ["deDE"] = "Lager der Todeshand",
        ["koKR"] = "죽음의 손 야영지",
        ["esMX"] = "Campamento Mano de la Muerte",
        ["enUS"] = true,
        ["frFR"] = "Campement de la Main de Mort",
        ["esES"] = "Campamento Mano de la Muerte",
        ["zhTW"] = "死亡之手駐營",
        ["zhCN"] = "死亡之手营地",
    },
    ["Scarlet Tavern"] = {
        ["ptBR"] = "Taberna Escarlate",
        ["ruRU"] = "Таверна Алого ордена",
        ["deDE"] = "Scharlachrote Taverne",
        ["koKR"] = "붉은십자군 선술집",
        ["esMX"] = "Taberna Escarlata",
        ["enUS"] = true,
        ["frFR"] = "Taverne écarlate",
        ["esES"] = "Taberna Escarlata",
        ["zhTW"] = "血色旅店",
        ["zhCN"] = "血色旅店",
    },
    ["Dalaran"] = {
        ["ptBR"] = "Dalaran",
        ["ruRU"] = "Даларан",
        ["deDE"] = "Dalaran",
        ["koKR"] = "달라란",
        ["esMX"] = "Dalaran",
        ["enUS"] = true,
        ["frFR"] = "Dalaran",
        ["esES"] = "Dalaran",
        ["zhTW"] = "達拉然",
        ["zhCN"] = "达拉然",
    },
    ["Nozzlerust Post"] = {
        ["ptBR"] = "Posto Ferrugem",
        ["ruRU"] = "Лагерь Соплозабилось",
        ["deDE"] = "Düsenrostposten",
        ["koKR"] = "녹주둥이 전초기지",
        ["esMX"] = "Puesto Boquilla Oxidada",
        ["enUS"] = true,
        ["frFR"] = "Poste de Rouilletuyère",
        ["esES"] = "Puesto Boquilla Oxidada",
        ["zhTW"] = "鏽鼻崗哨",
        ["zhCN"] = "诺兹拉斯哨站",
    },
    ["Farshire Mine"] = {
        ["ptBR"] = "Mina de Algures",
        ["ruRU"] = "Шахта Далечья",
        ["deDE"] = "Mine von Fernhain",
        ["koKR"] = "파샤이어 광산",
        ["esMX"] = "Mina de Lindeallá",
        ["enUS"] = true,
        ["frFR"] = "Mine de Comté-lointaine",
        ["esES"] = "Mina de Lindeallá",
        ["zhTW"] = "遠郡礦坑",
        ["zhCN"] = "致远郡矿洞",
    },
    ["The Mosslight Pillar"] = {
        ["ptBR"] = "Pilar Verdeluz",
        ["ruRU"] = "Колонна Мохосвета",
        ["deDE"] = "Die Mooslichtsäule",
        ["koKR"] = "이끼빛 봉우리",
        ["esMX"] = "El Pilar Musgoluz",
        ["enUS"] = true,
        ["frFR"] = "Le pilier Mousselume",
        ["esES"] = "El Pilar Musgoluz",
        ["zhTW"] = "苔光之柱",
        ["zhCN"] = "苔光之柱",
    },
    ["Saragosa's Landing"] = {
        ["ptBR"] = "Patamar de Saragosa",
        ["ruRU"] = "Лагерь Сарагосы",
        ["deDE"] = "Saragosas Landeplatz",
        ["koKR"] = "사라고사의 영지",
        ["esMX"] = "Alto de Saragosa",
        ["enUS"] = true,
        ["frFR"] = "Aire de Saragosa",
        ["esES"] = "Alto de Saragosa",
        ["zhTW"] = "薩拉苟莎臺地",
        ["zhCN"] = "莎拉苟萨平台",
    },
    ["Vengeance Lift"] = {
        ["ptBR"] = "Elevador da Vingança",
        ["ruRU"] = "Подъемник лагеря Возмездия",
        ["deDE"] = "Blutklammlift",
        ["koKR"] = "복수의 승강장",
        ["esMX"] = "Elevador de Venganza",
        ["enUS"] = true,
        ["frFR"] = "Ascenseur de la vengeance",
        ["esES"] = "Elevador de Venganza",
        ["zhTW"] = "復仇升降梯",
        ["zhCN"] = "复仇升降梯",
    },
    ["Balejar Watch"] = {
        ["ptBR"] = "Posto Balejar",
        ["ruRU"] = "Застава Баледжара",
        ["deDE"] = "Balejarwacht",
        ["koKR"] = "베일야르 감시초소",
        ["esMX"] = "Avanzada Balejar",
        ["enUS"] = true,
        ["frFR"] = "Guet de Balejar",
        ["esES"] = "Avanzada Balejar",
        ["zhTW"] = "貝爾亞守望",
        ["zhCN"] = "拜尔亚岗哨",
    },
    ["New Agamand Inn"] = {
        ["ptBR"] = "Estalagem de Nova Agamand",
        ["ruRU"] = "Таверна Нового Агамонда",
        ["deDE"] = "Gasthaus von Neu-Agamand",
        ["koKR"] = "신 아가만드 여관",
        ["esMX"] = "Posada de Nuevo Agamand",
        ["enUS"] = true,
        ["frFR"] = "Auberge de la Nouvelle-Agamand",
        ["esES"] = "Posada de Nuevo Agamand",
        ["zhTW"] = "新阿加曼德旅店",
        ["zhCN"] = "新阿加曼德旅店",
    },
    ["Passage of Lost Fiends"] = {
        ["ptBR"] = "Passagem dos Demônios Perdidos",
        ["ruRU"] = "Перевал Заблудившихся Злодеев",
        ["deDE"] = "Pass der verlorenen Geister",
        ["koKR"] = "잃어버린 악마의 통로",
        ["esMX"] = "Pasaje de los Malignos Perdidos",
        ["enUS"] = true,
        ["frFR"] = "Passage des démons perdus",
        ["esES"] = "Pasaje de los Malignos Perdidos",
        ["zhTW"] = "失落惡魔通道",
        ["zhCN"] = "迷失恶魔之路",
    },
    ["The Ring of Valor"] = {
        ["ptBR"] = "Ringue dos Valorosos",
        ["ruRU"] = "Арена Доблести",
        ["deDE"] = "Der Ring der Ehre",
        ["koKR"] = "용맹의 투기장",
        ["esMX"] = "El Círculo del Valor",
        ["enUS"] = true,
        ["frFR"] = "L'Arène des valeureux",
        ["esES"] = "El Círculo del Valor",
        ["zhTW"] = "勇武之環",
        ["zhCN"] = "勇气竞技场",
    },
    ["Hall of the Frostwolf"] = {
        ["ptBR"] = "Salão do Lobo do Gelo",
        ["ruRU"] = "Зал Северного Волка",
        ["deDE"] = "Halle der Frostwölfe",
        ["koKR"] = "서리늑대 전당",
        ["esMX"] = "Cámara de los Lobo Gélido",
        ["enUS"] = true,
        ["frFR"] = "Hall des Loups-de-givre",
        ["esES"] = "Cámara de los Lobo Gélido",
        ["zhTW"] = "霜狼大廳",
        ["zhCN"] = "霜狼大厅",
    },
    ["Hall of the Stormpike"] = {
        ["ptBR"] = "Salão de Lançatroz",
        ["ruRU"] = "Зал Грозовой Вершины",
        ["deDE"] = "Halle der Sturmlanzen",
        ["koKR"] = "스톰파이크 전당",
        ["esMX"] = "Cámara de los Pico Tormenta",
        ["enUS"] = true,
        ["frFR"] = "Hall des Foudrepiques",
        ["esES"] = "Cámara de los Pico Tormenta",
        ["zhTW"] = "雷矛大廳",
        ["zhCN"] = "雷矛大厅",
    },
    ["Stormwind Harbor"] = {
        ["ptBR"] = "Porto de Ventobravo",
        ["ruRU"] = "Порт Штормграда",
        ["deDE"] = "Hafen von Sturmwind",
        ["koKR"] = "스톰윈드 항구",
        ["esMX"] = "Puerto de Ventormenta",
        ["enUS"] = true,
        ["frFR"] = "Port de Hurlevent",
        ["esES"] = "Puerto de Ventormenta",
        ["zhTW"] = "暴風港",
        ["zhCN"] = "暴风城港口",
    },
    ["The Makers' Overlook"] = {
        ["ptBR"] = "Mirante dos Criadores",
        ["ruRU"] = "Дозор Творцов",
        ["deDE"] = "Die Warte der Schöpfer",
        ["koKR"] = "창조주의 전망대",
        ["esMX"] = "El Mirador de los Creadores",
        ["enUS"] = true,
        ["frFR"] = "Le surplomb du Faiseur",
        ["esES"] = "El Mirador de los Creadores",
        ["zhTW"] = "造物者瞰臺",
        ["zhCN"] = "造物者悬台",
    },
    ["The Makers' Perch"] = {
        ["ptBR"] = "Alcândora dos Criadores",
        ["ruRU"] = "Обитель Творцов",
        ["deDE"] = "Hort der Schöpfer",
        ["koKR"] = "창조주의 감시대",
        ["esMX"] = "El Pedestal de los Creadores",
        ["enUS"] = true,
        ["frFR"] = "Perchoir du Faiseur",
        ["esES"] = "El Pedestal de los Creadores",
        ["zhTW"] = "造物者棲所",
        ["zhCN"] = "造物者之座",
    },
    ["Scarlet Tower"] = {
        ["ptBR"] = "Torre Escarlate",
        ["ruRU"] = "Алая башня",
        ["deDE"] = "Scharlachroter Turm",
        ["koKR"] = "붉은십자군 경비탑",
        ["esMX"] = "Torre Escarlata",
        ["enUS"] = true,
        ["frFR"] = "Tour écarlate",
        ["esES"] = "Torre Escarlata",
        ["zhTW"] = "血色哨塔",
        ["zhCN"] = "血色哨塔",
    },
    ["Onslaught Harbor"] = {
        ["ptBR"] = "Porto da Ofensiva",
        ["ruRU"] = "Гавань Натиска",
        ["deDE"] = "Hafen des Ansturms",
        ["koKR"] = "붉은돌격대 항구",
        ["esMX"] = "Puerto del Embate",
        ["enUS"] = true,
        ["frFR"] = "Port de l'Assaut",
        ["esES"] = "Puerto del Embate",
        ["zhTW"] = "突襲軍港口",
        ["zhCN"] = "先锋军港口",
    },
    ["K3"] = {
        ["ptBR"] = "K3",
        ["ruRU"] = "К-3",
        ["deDE"] = "K3",
        ["koKR"] = "K3",
        ["esMX"] = "K3",
        ["enUS"] = true,
        ["frFR"] = "K3",
        ["esES"] = "K3",
        ["zhTW"] = "K3",
        ["zhCN"] = "K3",
    },
    ["Snowblind Hills"] = {
        ["ptBR"] = "Serra Ceganeve",
        ["ruRU"] = "Холмы Снежной Слепоты",
        ["deDE"] = "Blendschneehügel",
        ["koKR"] = "설맹의 언덕",
        ["esMX"] = "Colinas Veloneve",
        ["enUS"] = true,
        ["frFR"] = "Collines du Voile blanc",
        ["esES"] = "Colinas Veloneve",
        ["zhTW"] = "雪盲丘",
        ["zhCN"] = "雪盲岭",
    },
    ["Snowblind Terrace"] = {
        ["ptBR"] = "Terraço Ceganeve",
        ["ruRU"] = "Терраса Снежной Слепоты",
        ["deDE"] = "Blendschneeterrasse",
        ["koKR"] = "설맹의 언덕 길목",
        ["esMX"] = "Bancal Veloneve",
        ["enUS"] = true,
        ["frFR"] = "Terrasse du Voile blanc",
        ["esES"] = "Bancal Veloneve",
        ["zhTW"] = "雪盲殿堂",
        ["zhCN"] = "雪盲台地",
    },
    ["Garm"] = {
        ["ptBR"] = "Garm",
        ["ruRU"] = "Гарм",
        ["deDE"] = "Garm",
        ["koKR"] = "가름",
        ["esMX"] = "Garm",
        ["enUS"] = true,
        ["frFR"] = "Garm",
        ["esES"] = "Garm",
        ["zhTW"] = "迦姆",
        ["zhCN"] = "加姆",
    },
    ["Brunnhildar Village"] = {
        ["ptBR"] = "Aldeia Brunnhildar",
        ["ruRU"] = "Деревня Бруннхильдар",
        ["deDE"] = "Brunnhildar",
        ["koKR"] = "브룬힐다르 마을",
        ["esMX"] = "Poblado Brunnhildar",
        ["enUS"] = true,
        ["frFR"] = "Brunnhildar",
        ["esES"] = "Poblado Brunnhildar",
        ["zhTW"] = "布倫希爾達村",
        ["zhCN"] = "布伦希尔达村",
    },
    ["Sifreldar Village"] = {
        ["ptBR"] = "Aldeia Sifreldar",
        ["ruRU"] = "Деревня Сифрельдар",
        ["deDE"] = "Sifreldar",
        ["koKR"] = "시프렐다르 마을",
        ["esMX"] = "Poblado Sifreldar",
        ["enUS"] = true,
        ["frFR"] = "Sifreldar",
        ["esES"] = "Poblado Sifreldar",
        ["zhTW"] = "希弗爾達村",
        ["zhCN"] = "希弗列尔达村",
    },
    ["Valkyrion"] = {
        ["ptBR"] = "Valkyrion",
        ["ruRU"] = "Валькирион",
        ["deDE"] = "Valkyrion",
        ["koKR"] = "발키리온",
        ["esMX"] = "Valkyrion",
        ["enUS"] = true,
        ["frFR"] = "Valkyrion",
        ["esES"] = "Valkyrion",
        ["zhTW"] = "華爾基倫",
        ["zhCN"] = "瓦基里安",
    },
    ["The Forlorn Mine"] = {
        ["ptBR"] = "Mina Esquecida",
        ["ruRU"] = "Заброшенный рудник",
        ["deDE"] = "Die verlassene Mine",
        ["koKR"] = "쓸쓸한 광산",
        ["esMX"] = "La Mina Desolada",
        ["enUS"] = true,
        ["frFR"] = "La mine Lugubre",
        ["esES"] = "La Mina Desolada",
        ["zhTW"] = "凋落礦坑",
        ["zhCN"] = "荒弃矿洞",
    },
    ["Bor's Breath River"] = {
        ["ptBR"] = "Rio Vale de Bor",
        ["ruRU"] = "Река Дыхания Бора",
        ["deDE"] = "Bors Atemstrom",
        ["koKR"] = "보르의 숨결 강",
        ["esMX"] = "Río del Aliento de Bor",
        ["enUS"] = true,
        ["frFR"] = "Le Souffle de Bor",
        ["esES"] = "Río del Aliento de Bor",
        ["zhTW"] = "伯爾之息河谷",
        ["zhCN"] = "伯尔之息河",
    },
    ["Argent Vanguard"] = {
        ["ptBR"] = "Vanguarda Argêntea",
        ["ruRU"] = "Оплот Серебряного Авангарда",
        ["deDE"] = "Argentumvorhut",
        ["koKR"] = "은빛십자군 선봉기지",
        ["esMX"] = "Vanguardia Argenta",
        ["enUS"] = true,
        ["frFR"] = "L'avant-garde d'Argent",
        ["esES"] = "Vanguardia Argenta",
        ["zhTW"] = "銀白先鋒駐地",
        ["zhCN"] = "银色前线基地",
    },
    ["Frosthold"] = {
        ["ptBR"] = "Fortaleza Gelada",
        ["ruRU"] = "Ледяная крепость",
        ["deDE"] = "Eisfestung",
        ["koKR"] = "서리요새",
        ["esMX"] = "Fuerte Escarcha",
        ["enUS"] = true,
        ["frFR"] = "Fort du Givre",
        ["esES"] = "Fuerte Escarcha",
        ["zhTW"] = "霜堡",
        ["zhCN"] = "冰霜堡",
    },
    ["Grom'arsh Crash-Site"] = {
        ["ptBR"] = "Local da Queda de Grom'arsh",
        ["ruRU"] = "Место крушения Гром'арша",
        ["deDE"] = "Absturzstelle Grom'ash",
        ["koKR"] = "그롬아쉬 추락 지점",
        ["esMX"] = "Lugar del accidente de Grom'arsh",
        ["enUS"] = true,
        ["frFR"] = "Point d'impact de Grom'arsh",
        ["esES"] = "Lugar del accidente de Grom'arsh",
        ["zhTW"] = "葛羅姆亞什失事地",
        ["zhCN"] = "格罗玛什坠毁点",
    },
    ["Temple of Storms"] = {
        ["ptBR"] = "Templo das Tempestades",
        ["ruRU"] = "Храм Штормов",
        ["deDE"] = "Tempel der Stürme",
        ["koKR"] = "폭풍의 신전",
        ["esMX"] = "Templo de las Tormentas",
        ["enUS"] = true,
        ["frFR"] = "Temple des Tempêtes",
        ["esES"] = "Templo de las Tormentas",
        ["zhTW"] = "風暴神殿",
        ["zhCN"] = "风暴神殿",
    },
    ["Engine of the Makers"] = {
        ["ptBR"] = "Maquinário dos Criadores",
        ["ruRU"] = "Машина Творцов",
        ["deDE"] = "Maschine der Schöpfer",
        ["koKR"] = "창조주의 기계",
        ["esMX"] = "Motor de los Creadores",
        ["enUS"] = true,
        ["frFR"] = "Moteur des Faiseurs",
        ["esES"] = "Motor de los Creadores",
        ["zhTW"] = "造物者動力核心",
        ["zhCN"] = "造物者引擎",
    },
    ["The Foot Steppes"] = {
        ["ptBR"] = "Estepes do Sopé",
        ["ruRU"] = "Подножие",
        ["deDE"] = "Die Fußmarschen",
        ["koKR"] = "눈봉우리 분지",
        ["esMX"] = "Las Estepas Inferiores",
        ["enUS"] = true,
        ["frFR"] = "Le Pied-mont",
        ["esES"] = "Las Estepas Inferiores",
        ["zhTW"] = "足跡冷原",
        ["zhCN"] = "山底平原",
    },
    ["Dragonspine Peaks"] = {
        ["ptBR"] = "Pico Espinodraco",
        ["ruRU"] = "Драконьи пики",
        ["deDE"] = "Drachenwirbelgipfel",
        ["koKR"] = "용돌기 봉우리",
        ["esMX"] = "Cumbres Espinazo de Dragón",
        ["enUS"] = true,
        ["frFR"] = "Pics de l'Epine-de-dragon",
        ["esES"] = "Cumbres Espinazo de Dragón",
        ["zhTW"] = "龍脊群山",
        ["zhCN"] = "龙脊之巅",
    },
    ["Narvir's Cradle"] = {
        ["ptBR"] = "Berço de Narvir",
        ["ruRU"] = "Колыбель Нарвира",
        ["deDE"] = "Narvirs Wiege",
        ["koKR"] = "나르비르의 요람",
        ["esMX"] = "Cuna de Narvir",
        ["enUS"] = true,
        ["frFR"] = "Le berceau de Narvir",
        ["esES"] = "Cuna de Narvir",
        ["zhTW"] = "那維爾搖籃",
        ["zhCN"] = "纳维尔支架",
    },
    ["Valley of Ancient Winters"] = {
        ["ptBR"] = "Vale dos Antigos Invernos",
        ["ruRU"] = "Долина Древних Зим",
        ["deDE"] = "Das uralte Wintertal",
        ["koKR"] = "고대의 겨울 계곡",
        ["esMX"] = "Valle de los Viejos Inviernos",
        ["enUS"] = true,
        ["frFR"] = "La vallée des Anciens hivers",
        ["esES"] = "Valle de los Viejos Inviernos",
        ["zhTW"] = "遠古寒冬山谷",
        ["zhCN"] = "上古寒冬山谷",
    },
    ["Dun Niffelem"] = {
        ["ptBR"] = "Dun Niffelem",
        ["ruRU"] = "Дун Ниффелем",
        ["deDE"] = "Dun Niffelem",
        ["koKR"] = "던 니펠렘",
        ["esMX"] = "Dun Niffelem",
        ["enUS"] = true,
        ["frFR"] = "Dun Niffelem",
        ["esES"] = "Dun Niffelem",
        ["zhTW"] = "丹尼弗蘭",
        ["zhCN"] = "丹尼芬雷",
    },
    ["Frostfield Lake"] = {
        ["ptBR"] = "Lago Congelado",
        ["ruRU"] = "Промерзшее озеро",
        ["deDE"] = "Frostfeldsee",
        ["koKR"] = "서리평원 호수",
        ["esMX"] = "Lago Campo de Escarcha",
        ["enUS"] = true,
        ["frFR"] = "Lac du Champ-gelé",
        ["esES"] = "Lago Campo de Escarcha",
        ["zhTW"] = "霜域湖",
        ["zhCN"] = "霜原湖",
    },
    ["Thunderfall"] = {
        ["ptBR"] = "Tormentério",
        ["ruRU"] = "Громовержье",
        ["deDE"] = "Donnerfall",
        ["koKR"] = "천둥 골짜기",
        ["esMX"] = "Truenotoño",
        ["enUS"] = true,
        ["frFR"] = "Chute-tonnerre",
        ["esES"] = "Truenotoño",
        ["zhTW"] = "雷殞之地",
        ["zhCN"] = "落雷谷",
    },
    ["Camp Tunka'lo"] = {
        ["ptBR"] = "Aldeia Tunka'lo",
        ["ruRU"] = "Лагерь Тунка’ло",
        ["deDE"] = "Camp Tunka'lo",
        ["koKR"] = "툰카로 야영지",
        ["esMX"] = "Campamento Tunka'lo",
        ["enUS"] = true,
        ["frFR"] = "Camp Tunka'lo",
        ["esES"] = "Campamento Tunka'lo",
        ["zhTW"] = "坦卡羅營地",
        ["zhCN"] = "唐卡洛营地",
    },
    ["Brann's Base-Camp"] = {
        ["ptBR"] = "Acampamento do Brann",
        ["ruRU"] = "Базовый лагерь Бранна",
        ["deDE"] = "Branns Basislager",
        ["koKR"] = "브란의 기지",
        ["esMX"] = "Campamento base de Brann",
        ["enUS"] = true,
        ["frFR"] = "Campement de Brann",
        ["esES"] = "Campamento base de Brann",
        ["zhTW"] = "布萊恩營地",
        ["zhCN"] = "布莱恩的营地",
    },
    ["Gate of Echoes"] = {
        ["ptBR"] = "Portão dos Ecos",
        ["ruRU"] = "Врата эха",
        ["deDE"] = "Tor der Echos",
        ["koKR"] = "메아리 관문",
        ["esMX"] = "Puerta de los Ecos",
        ["enUS"] = true,
        ["frFR"] = "Porte des Échos",
        ["esES"] = "Puerta de los Ecos",
        ["zhTW"] = "回聲之門",
        ["zhCN"] = "回音之门",
    },
    ["Plain of Echoes"] = {
        ["ptBR"] = "Planície dos Ecos",
        ["ruRU"] = "Равнина эха",
        ["deDE"] = "Ebene der Echos",
        ["koKR"] = "메아리 평원",
        ["esMX"] = "Llanura de los Ecos",
        ["enUS"] = true,
        ["frFR"] = "Plaine des Échos",
        ["esES"] = "Llanura de los Ecos",
        ["zhTW"] = "回聲平原",
        ["zhCN"] = "回音平原",
    },
    ["Terrace of the Makers"] = {
        ["ptBR"] = "Terraço dos Criadores",
        ["ruRU"] = "Терраса Творцов",
        ["deDE"] = "Terrasse der Schöpfer",
        ["koKR"] = "창조주의 거처",
        ["esMX"] = "Bancal de los Creadores",
        ["enUS"] = true,
        ["frFR"] = "Terrasse des Faiseurs",
        ["esES"] = "Bancal de los Creadores",
        ["zhTW"] = "造物者殿堂",
        ["zhCN"] = "造物者圣台",
    },
    ["Gate of Lightning"] = {
        ["ptBR"] = "Pórtico dos Relâmpagos",
        ["ruRU"] = "Врата молнии",
        ["deDE"] = "Das Blitztor",
        ["koKR"] = "번개의 관문",
        ["esMX"] = "Puerta de los Rayos",
        ["enUS"] = true,
        ["frFR"] = "Porte de la Foudre",
        ["esES"] = "Puerta de los Rayos",
        ["zhTW"] = "雷光之門",
        ["zhCN"] = "闪电之门",
    },
    ["Path of the Titans"] = {
        ["ptBR"] = "Caminho dos Titãs",
        ["ruRU"] = "Путь Титанов",
        ["deDE"] = "Pfad der Titanen",
        ["koKR"] = "티탄의 길",
        ["esMX"] = "Senda de los Titanes",
        ["enUS"] = true,
        ["frFR"] = "Voie des Titans",
        ["esES"] = "Senda de los Titanes",
        ["zhTW"] = "泰坦之途",
        ["zhCN"] = "泰坦之路",
    },
    ["Uldis"] = {
        ["ptBR"] = "Uldis",
        ["ruRU"] = "Ульдис",
        ["deDE"] = "Uldis",
        ["koKR"] = "울디스",
        ["esMX"] = "Uldis",
        ["enUS"] = true,
        ["frFR"] = "Uldis",
        ["esES"] = "Uldis",
        ["zhTW"] = "奧迪斯",
        ["zhCN"] = "奥迪斯",
    },
    ["Loken's Bargain"] = {
        ["ptBR"] = "Barganha de Loken",
        ["ruRU"] = "Сделка Локена",
        ["deDE"] = "Lokens Handel",
        ["koKR"] = "로켄의 거래물",
        ["esMX"] = "Acuerdo de Loken",
        ["enUS"] = true,
        ["frFR"] = "Marché de Loken",
        ["esES"] = "Acuerdo de Loken",
        ["zhTW"] = "洛肯的交易地",
        ["zhCN"] = "洛肯的宝库",
    },
    ["Bor's Fall"] = {
        ["ptBR"] = "Cascata de Bor",
        ["ruRU"] = "Водопад Бора",
        ["deDE"] = "Bors Sturz",
        ["koKR"] = "보르의 폭포",
        ["esMX"] = "Caída de Bor",
        ["enUS"] = true,
        ["frFR"] = "Chute de Bor",
        ["esES"] = "Caída de Bor",
        ["zhTW"] = "伯爾瀑布",
        ["zhCN"] = "伯尔瀑布",
    },
    ["Bor's Breath"] = {
        ["ptBR"] = "Vale de Bor",
        ["ruRU"] = "Дыхание Бора",
        ["deDE"] = "Bors Atem",
        ["koKR"] = "보르의 숨결",
        ["esMX"] = "Aliento de Bor",
        ["enUS"] = true,
        ["frFR"] = "Souffle de Bor",
        ["esES"] = "Aliento de Bor",
        ["zhTW"] = "伯爾之息",
        ["zhCN"] = "伯尔之息",
    },
    ["Rohemdal Pass"] = {
        ["ptBR"] = "Desfiladeiro de Rohemdal",
        ["ruRU"] = "Рохемдальский проход",
        ["deDE"] = "Rohemdalpass",
        ["koKR"] = "로헴달 고개",
        ["esMX"] = "Paso de Rohemdal",
        ["enUS"] = true,
        ["frFR"] = "Passe de Rohemdal",
        ["esES"] = "Paso de Rohemdal",
        ["zhTW"] = "洛罕達之徑",
        ["zhCN"] = "洛希达尔小径",
    },
    ["The Storm Foundry"] = {
        ["ptBR"] = "Fundição da Tempestade",
        ["ruRU"] = "Плавильня штормов",
        ["deDE"] = "Die Wiege des Sturms",
        ["koKR"] = "폭풍 주조소",
        ["esMX"] = "La Fundición de la Tormenta",
        ["enUS"] = true,
        ["frFR"] = "La Fonderie des tempêtes",
        ["esES"] = "La Fundición de la Tormenta",
        ["zhTW"] = "風暴鑄造場",
        ["zhCN"] = "风暴铸造场",
    },
    ["Hibernal Cavern"] = {
        ["ptBR"] = "Caverna Hibérnia",
        ["ruRU"] = "Пещера зимней спячки",
        ["deDE"] = "Überwinterungshöhle",
        ["koKR"] = "겨울 동굴",
        ["esMX"] = "Caverna Hibernal",
        ["enUS"] = true,
        ["frFR"] = "Caverne de l'hibernation",
        ["esES"] = "Caverna Hibernal",
        ["zhTW"] = "凜冬洞窟",
        ["zhCN"] = "冬眠洞穴",
    },
    ["Voldrune Dwelling"] = {
        ["ptBR"] = "Residência de Runavold",
        ["ruRU"] = "Поселение Волдрун",
        ["deDE"] = "Voldrunenbehausung",
        ["koKR"] = "볼드룬 주거지",
        ["esMX"] = "Morada Runavold",
        ["enUS"] = true,
        ["frFR"] = "Logis de Voldrune",
        ["esES"] = "Morada Runavold",
        ["zhTW"] = "沃德盧恩居所",
        ["zhCN"] = "沃德伦民居",
    },
    ["Torseg's Rest"] = {
        ["ptBR"] = "Repouso de Torseg",
        ["ruRU"] = "Покой Торсега",
        ["deDE"] = "Torsegs Ruheplatz",
        ["koKR"] = "토르섹의 쉼터",
        ["esMX"] = "Reposo de Torseg",
        ["enUS"] = true,
        ["frFR"] = "Le Repos de Torseg",
        ["esES"] = "Reposo de Torseg",
        ["zhTW"] = "托賽格安息地",
        ["zhCN"] = "托塞格的营地",
    },
    ["Sparksocket Minefield"] = {
        ["ptBR"] = "Campo Minado do Curtomada",
        ["ruRU"] = "Минное поле Свечекрута",
        ["deDE"] = "Funksockels Minenfeld",
        ["koKR"] = "스파크소켓의 지뢰밭",
        ["esMX"] = "Campo de Minas Encajebujía",
        ["enUS"] = true,
        ["frFR"] = "Champ de mines de Grilledouille",
        ["esES"] = "Campo de Minas Encajebujía",
        ["zhTW"] = "炫臼礦區",
        ["zhCN"] = "斯巴索克雷区",
    },
    ["Ricket's Folly"] = {
        ["ptBR"] = "O Erro da Ricket",
        ["ruRU"] = "Просторы Рикет",
        ["deDE"] = "Rickets Torheit",
        ["koKR"] = "리켓의 로켓 썰매",
        ["esMX"] = "Locura de Ricket",
        ["enUS"] = true,
        ["frFR"] = "La Folie de Ricket",
        ["esES"] = "Locura de Ricket",
        ["zhTW"] = "芮凱特異所",
        ["zhCN"] = "莉吉特爆炸坑",
    },
    ["Garm's Bane"] = {
        ["ptBR"] = "Perdição de Garm",
        ["ruRU"] = "Побоище Гарма",
        ["deDE"] = "Garms Bann",
        ["koKR"] = "가름의 파멸",
        ["esMX"] = "Pesadilla de Garm",
        ["enUS"] = true,
        ["frFR"] = "Plaie-de-Garm",
        ["esES"] = "Pesadilla de Garm",
        ["zhTW"] = "迦姆之禍",
        ["zhCN"] = "加姆雷区",
    },
    ["Garm's Rise"] = {
        ["ptBR"] = "Ladeira de Garm",
        ["ruRU"] = "Подъем Гарма",
        ["deDE"] = "Garms Erhebung",
        ["koKR"] = "가름의 마루",
        ["esMX"] = "Alto de Garm",
        ["enUS"] = true,
        ["frFR"] = "Cime de Garm",
        ["esES"] = "Alto de Garm",
        ["zhTW"] = "迦姆高崗",
        ["zhCN"] = "加姆高地",
    },
    ["Crystalweb Cavern"] = {
        ["ptBR"] = "Caverna da Teia de Cristal",
        ["ruRU"] = "Пещера Хрустальной Паутины",
        ["deDE"] = "Kristallnetzhöhle",
        ["koKR"] = "수정그물 동굴",
        ["esMX"] = "Caverna Red de Cristal",
        ["enUS"] = true,
        ["frFR"] = "Caverne de la Toile cristalline",
        ["esES"] = "Caverna Red de Cristal",
        ["zhTW"] = "晶網洞窟",
        ["zhCN"] = "水晶蛛网洞穴",
    },
    ["Temple of Life"] = {
        ["ptBR"] = "Templo da Vida",
        ["ruRU"] = "Храм жизни",
        ["deDE"] = "Tempel des Lebens",
        ["koKR"] = "생명의 신전",
        ["esMX"] = "Templo de la Vida",
        ["enUS"] = true,
        ["frFR"] = "Temple de la Vie",
        ["esES"] = "Templo de la Vida",
        ["zhTW"] = "生命神殿",
        ["zhCN"] = "生命神殿",
    },
    ["Temple of Order"] = {
        ["ptBR"] = "Templo da Ordem",
        ["ruRU"] = "Храм Порядка",
        ["deDE"] = "Tempel der Ordnung",
        ["koKR"] = "질서의 신전",
        ["esMX"] = "Templo del Orden",
        ["enUS"] = true,
        ["frFR"] = "Temple de l'Ordre",
        ["esES"] = "Templo del Orden",
        ["zhTW"] = "秩序神殿",
        ["zhCN"] = "秩序神殿",
    },
    ["Temple of Winter"] = {
        ["ptBR"] = "Templo do Inverno",
        ["ruRU"] = "Храм Зимы",
        ["deDE"] = "Tempel des Winters",
        ["koKR"] = "겨울의 신전",
        ["esMX"] = "Templo del Invierno",
        ["enUS"] = true,
        ["frFR"] = "Temple de l'Hiver",
        ["esES"] = "Templo del Invierno",
        ["zhTW"] = "凜冬神殿",
        ["zhCN"] = "寒冬神殿",
    },
    ["Temple of Invention"] = {
        ["ptBR"] = "Templo da Invenção",
        ["ruRU"] = "Храм Изобретений",
        ["deDE"] = "Tempel des Erfindungsreichtums",
        ["koKR"] = "발명의 신전",
        ["esMX"] = "Templo de la Invención",
        ["enUS"] = true,
        ["frFR"] = "Temple de l'Innovation",
        ["esES"] = "Templo de la Invención",
        ["zhTW"] = "發明神殿",
        ["zhCN"] = "创世神殿",
    },
    ["Death's Rise"] = {
        ["ptBR"] = "Beiral da Morte",
        ["ruRU"] = "Уступ Смерти",
        ["deDE"] = "Todesanhöhe",
        ["koKR"] = "죽음의 마루",
        ["esMX"] = "Ascenso de la Muerte",
        ["enUS"] = true,
        ["frFR"] = "Cime de la Mort",
        ["esES"] = "Ascenso de la Muerte",
        ["zhTW"] = "死亡高崗",
        ["zhCN"] = "死亡高地",
    },
    ["The Dead Fields"] = {
        ["ptBR"] = "Campos Estéreis",
        ["ruRU"] = "Мертвые поля",
        ["deDE"] = "Die toten Felder",
        ["koKR"] = "죽음의 들판",
        ["esMX"] = "Los Campos Muertos",
        ["enUS"] = true,
        ["frFR"] = "Les champs des Morts",
        ["esES"] = "Los Campos Muertos",
        ["zhTW"] = "亡者原野",
        ["zhCN"] = "死亡旷野",
    },
    ["Dargath's Demise"] = {
        ["ptBR"] = "Destino de Dargath",
        ["ruRU"] = "Погибель Даргата",
        ["deDE"] = "Dargaths Niedergang",
        ["koKR"] = "다르가스의 최후",
        ["esMX"] = "Óbito de Dargath",
        ["enUS"] = true,
        ["frFR"] = "La Fin de Dargath",
        ["esES"] = "Óbito de Dargath",
        ["zhTW"] = "達加希的終點",
        ["zhCN"] = "达加斯的行刑场",
    },
    ["The Hidden Hollow"] = {
        ["ptBR"] = "Vazio Oculto",
        ["ruRU"] = "Скрытая низина",
        ["deDE"] = "Die versteckte Senke",
        ["koKR"] = "숨겨진 동굴",
        ["esMX"] = "La Hondonada Oculta",
        ["enUS"] = true,
        ["frFR"] = "Le creux Caché",
        ["esES"] = "La Hondonada Oculta",
        ["zhTW"] = "隱匿谷",
        ["zhCN"] = "隐蔽山洞",
    },
    ["Bernau's Happy Fun Land"] = {
        ["ptBR"] = "Divertilândia de Bernau",
        ["ruRU"] = "Страна веселья Берно",
        ["deDE"] = "Bernaus lustiges Paradies",
        ["koKR"] = "버나우의 놀이동산",
        ["esMX"] = "El Maravilloso Mundo de Bernau",
        ["enUS"] = true,
        ["frFR"] = "Pays du bonheur de Bernau",
        ["esES"] = "El Maravilloso Mundo de Bernau",
        ["zhTW"] = "博諾的快樂之地",
        ["zhCN"] = "Bernau's Happy Fun Land",
    },
    ["Frostgrip's Hollow"] = {
        ["ptBR"] = "Ravina Gélida",
        ["ruRU"] = "Лощина Ледохвата",
        ["deDE"] = "Frostgriffs Höhle",
        ["koKR"] = "서리손아귀 동굴",
        ["esMX"] = "Hondonada Puño Helado",
        ["enUS"] = true,
        ["frFR"] = "Creux de Poignegivre",
        ["esES"] = "Hondonada Puño Helado",
        ["zhTW"] = "霜握谷",
        ["zhCN"] = "霜握的洞穴",
    },
    ["The Frigid Tomb"] = {
        ["ptBR"] = "Tumba Frígida",
        ["ruRU"] = "Стылый склеп",
        ["deDE"] = "Das eisige Grab",
        ["koKR"] = "얼어붙은 무덤",
        ["esMX"] = "La Tumba Gélida",
        ["enUS"] = true,
        ["frFR"] = "La tombe Algide",
        ["esES"] = "La Tumba Gélida",
        ["zhTW"] = "嚴寒陵寢",
        ["zhCN"] = "严寒墓穴",
    },
    ["Twin Shores"] = {
        ["ptBR"] = "Praias Gêmeas",
        ["ruRU"] = "Два берега",
        ["deDE"] = "Zwillingsküste",
        ["koKR"] = "쌍둥이 해안",
        ["esMX"] = "Las Playas Gemelas",
        ["enUS"] = true,
        ["frFR"] = "Rivages jumeaux",
        ["esES"] = "Las Playas Gemelas",
        ["zhTW"] = "雙水之濱",
        ["zhCN"] = "双子海岸",
    },
    ["Zim'bo's Hideout"] = {
        ["ptBR"] = "Esconderijo de Zim'bo",
        ["ruRU"] = "Убежище Зим'бо",
        ["deDE"] = "Zim'bos Versteck",
        ["koKR"] = "짐보의 은신처",
        ["esMX"] = "Guarida de Zim'bo",
        ["enUS"] = true,
        ["frFR"] = "Planque de Zim'bo",
        ["esES"] = "Guarida de Zim'bo",
        ["zhTW"] = "辛波的藏身所",
        ["zhCN"] = "希姆波的藏身处",
    },
    ["Abandoned Camp"] = {
        ["ptBR"] = "Acampamento Abandonado",
        ["ruRU"] = "Заброшенный лагерь",
        ["deDE"] = "Verlassenes Lager",
        ["koKR"] = "버려진 야영지",
        ["esMX"] = "Campamento Abandonado",
        ["enUS"] = true,
        ["frFR"] = "Camp abandonné",
        ["esES"] = "Campamento Abandonado",
        ["zhTW"] = "廢棄營地",
        ["zhCN"] = "被遗弃的营地",
    },
    ["The Shadow Vault"] = {
        ["ptBR"] = "Abóbada das Sombras",
        ["ruRU"] = "Мрачный Свод",
        ["deDE"] = "Das Schattengewölbe",
        ["koKR"] = "어둠의 무기고",
        ["esMX"] = "La Cámara de las Sombras",
        ["enUS"] = true,
        ["frFR"] = "Le caveau des Ombres",
        ["esES"] = "La Cámara de las Sombras",
        ["zhTW"] = "暗影穹殿",
        ["zhCN"] = "暗影拱顶",
    },
    ["Winter's Breath Lake"] = {
        ["ptBR"] = "Lago Sopro Invernal",
        ["ruRU"] = "Озеро Дыхания Зимы",
        ["deDE"] = "Winterhauchsee",
        ["koKR"] = "겨울의 숨결 호수",
        ["esMX"] = "Lago Aliento Invernal",
        ["enUS"] = true,
        ["frFR"] = "Lac du Souffle de l'hiver",
        ["esES"] = "Lago Aliento Invernal",
        ["zhTW"] = "冬息湖",
        ["zhCN"] = "冬息湖",
    },
    ["The Forgotten Overlook"] = {
        ["ptBR"] = "Mirante Esquecido",
        ["ruRU"] = "Забытая высота",
        ["deDE"] = "Die vergessene Warte",
        ["koKR"] = "잊혀진 전망대",
        ["esMX"] = "El Mirador Olvidado",
        ["enUS"] = true,
        ["frFR"] = "Le surplomb Oublié",
        ["esES"] = "El Mirador Olvidado",
        ["zhTW"] = "遺忘瞰臺",
        ["zhCN"] = "遗忘峭壁",
    },
    ["Jintha'kalar Passage"] = {
        ["ptBR"] = "Passagem de Jintha'kalar",
        ["ruRU"] = "Джинта'каларский проход",
        ["deDE"] = "Jintha'kalarpassage",
        ["koKR"] = "진타칼라르 통로",
        ["esMX"] = "Pasaje de Jintha'kalar",
        ["enUS"] = true,
        ["frFR"] = "Passage de Jintha'kalar",
        ["esES"] = "Pasaje de Jintha'kalar",
        ["zhTW"] = "辛薩卡拉通道",
        ["zhCN"] = "金萨卡拉小径",
    },
    ["Arriga Footbridge"] = {
        ["ptBR"] = "Pinguela do Arriga",
        ["ruRU"] = "Мост Аррига",
        ["deDE"] = "Arrigabrücke",
        ["koKR"] = "아리가 교각",
        ["esMX"] = "Pasarela de Arriga",
        ["enUS"] = true,
        ["frFR"] = "Passerelle Arriga",
        ["esES"] = "Pasarela de Arriga",
        ["zhTW"] = "艾瑞加之橋",
        ["zhCN"] = "埃雷加之桥",
    },
    ["The Lost Passage"] = {
        ["ptBR"] = "Passagem Perdida",
        ["ruRU"] = "Забытый проход",
        ["deDE"] = "Die verlorene Passage",
        ["koKR"] = "잃어버린 통로",
        ["esMX"] = "El Pasaje Perdido",
        ["enUS"] = true,
        ["frFR"] = "Le passage perdu",
        ["esES"] = "El Pasaje Perdido",
        ["zhTW"] = "失落通道",
        ["zhCN"] = "失落小径",
    },
    ["Bouldercrag's Refuge"] = {
        ["ptBR"] = "Refúgio do Petrenedo",
        ["ruRU"] = "Приют Глыбоскала",
        ["deDE"] = "Bergfels' Zuflucht",
        ["koKR"] = "바울더크랙의 은거처",
        ["esMX"] = "Refugio de Pedruscón",
        ["enUS"] = true,
        ["frFR"] = "Refuge de Rochecombe",
        ["esES"] = "Refugio de Pedruscón",
        ["zhTW"] = "石崖避難所",
        ["zhCN"] = "布德克拉格庇护所",
    },
    ["The Inventor's Library"] = {
        ["ptBR"] = "Biblioteca do Inventor",
        ["ruRU"] = "Библиотека Изобретателя",
        ["deDE"] = "Die Bibliothek des Erfinders",
        ["koKR"] = "발명가의 도서관",
        ["esMX"] = "La Biblioteca del Inventor",
        ["enUS"] = true,
        ["frFR"] = "Bibliothèque de l'inventeur",
        ["esES"] = "La Biblioteca del Inventor",
        ["zhTW"] = "發明者圖書館",
        ["zhCN"] = "创世者的图书馆",
    },
    ["The Frozen Mine"] = {
        ["ptBR"] = "Mina Congelada",
        ["ruRU"] = "Застывшая шахта",
        ["deDE"] = "Die gefrorene Mine",
        ["koKR"] = "얼어붙은 광산",
        ["esMX"] = "La Mina Gélida",
        ["enUS"] = true,
        ["frFR"] = "La mine Gelée",
        ["esES"] = "La Mina Gélida",
        ["zhTW"] = "冰凍礦坑",
        ["zhCN"] = "冰霜矿洞",
    },
    ["Frostfloe Deep"] = {
        ["ptBR"] = "Caverna Flotagelo",
        ["ruRU"] = "Ледяные глубины",
        ["deDE"] = "Frostschollentiefe",
        ["koKR"] = "거대한 유빙",
        ["esMX"] = "Hondonada Témpano Gélido",
        ["enUS"] = true,
        ["frFR"] = "Gouffre du Sérac",
        ["esES"] = "Hondonada Témpano Gélido",
        ["zhTW"] = "浮冰霜淵",
        ["zhCN"] = "浮冰深渊",
    },
    ["The Howling Hollow"] = {
        ["ptBR"] = "Vazio Uivante",
        ["ruRU"] = "Стенающая ложбина",
        ["deDE"] = "Die heulende Senke",
        ["koKR"] = "울부짖는 동굴",
        ["esMX"] = "La Hondonada Aullante",
        ["enUS"] = true,
        ["frFR"] = "Le creux Hurlant",
        ["esES"] = "La Hondonada Aullante",
        ["zhTW"] = "嚎風谷",
        ["zhCN"] = "凛风洞窟",
    },
    ["Crusader Forward Camp"] = {
        ["ptBR"] = "Campo Avançado dos Cruzados",
        ["ruRU"] = "Передовой лагерь рыцарей",
        ["deDE"] = "Lager der Kreuzfahrer",
        ["koKR"] = "십자군 전진기지",
        ["esMX"] = "Puesto de Avanzada de los Cruzados",
        ["enUS"] = true,
        ["frFR"] = "Camp avancé des croisés",
        ["esES"] = "Puesto de Avanzada de los Cruzados",
        ["zhTW"] = "十字軍前進營地",
        ["zhCN"] = "北伐军前线营地",
    },
    ["Stormcrest"] = {
        ["ptBR"] = "Pico Crista de Gelo",
        ["ruRU"] = "Грозовесье",
        ["deDE"] = "Sturmspitze",
        ["koKR"] = "폭풍마루",
        ["esMX"] = "Crestormenta",
        ["enUS"] = true,
        ["frFR"] = "Foudrecrête",
        ["esES"] = "Crestormenta",
        ["zhTW"] = "風暴頂",
        ["zhCN"] = "雷羽峰",
    },
    ["Bonesnap's Camp"] = {
        ["ptBR"] = "Acampamento do Quebraossos",
        ["ruRU"] = "Лагерь Костехвата",
        ["deDE"] = "Knochenknackers Lager",
        ["koKR"] = "본스냅 야영지",
        ["esMX"] = "Campamento Cascahueso",
        ["enUS"] = true,
        ["frFR"] = "Camp de Bris'os",
        ["esES"] = "Campamento Cascahueso",
        ["zhTW"] = "斷骨營地",
        ["zhCN"] = "博斯纳普的营地",
    },
    ["Ufrang's Hall"] = {
        ["ptBR"] = "Salão de Ufrang",
        ["ruRU"] = "Зал Уфранга",
        ["deDE"] = "Ufrangs Halle",
        ["koKR"] = "우프랑의 전당",
        ["esMX"] = "Sala de Ufrang",
        ["enUS"] = true,
        ["frFR"] = "Salle d'Ufrang",
        ["esES"] = "Sala de Ufrang",
        ["zhTW"] = "烏弗蘭大廳",
        ["zhCN"] = "乌弗朗之厅",
    },
    ["The Obsidian Sanctum"] = {
        ["ptBR"] = "Santuário Obsidiano",
        ["ruRU"] = "Обсидиановое святилище",
        ["deDE"] = "Das Obsidiansanktum",
        ["koKR"] = "흑요석 성소",
        ["esMX"] = "El Sagrario Obsidiana",
        ["enUS"] = true,
        ["frFR"] = "Le sanctum Obsidien",
        ["esES"] = "El Sagrario Obsidiana",
        ["zhTW"] = "黑曜聖所",
        ["zhCN"] = "黑曜石圣殿",
    },
    ["Ahn'kahet: The Old Kingdom"] = {
        ["ptBR"] = "Ahn'kahet: O Velho Reino",
        ["ruRU"] = "Ан'кахет: Старое Королевство",
        ["deDE"] = "Ahn'kahet: Das Alte Königreich",
        ["koKR"] = "안카헤트: 고대 왕국",
        ["esMX"] = "Ahn'kahet: El Antiguo Reino",
        ["enUS"] = true,
        ["frFR"] = "Ahn'kahet : l'Ancien royaume",
        ["esES"] = "Ahn'kahet: El Antiguo Reino",
        ["zhTW"] = "安卡罕特:古王國",
        ["zhCN"] = "安卡赫特：古代王国",
    },
    ["Ahn'kahet"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Ан'кахет",
        ["deDE"] = true,
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["frFR"] = false,
        ["esES"] = false,
        ["zhTW"] = "安卡罕特",
        ["zhCN"] = false,
    },
    ["Fjorn's Anvil"] = {
        ["ptBR"] = "Bigorna de Fjorn",
        ["ruRU"] = "Наковальня Фьорна",
        ["deDE"] = "Fjorns Amboss",
        ["koKR"] = "피요른의 모루",
        ["esMX"] = "Yunque de Fjorn",
        ["enUS"] = true,
        ["frFR"] = "L'enclume de Fjorn",
        ["esES"] = "Yunque de Fjorn",
        ["zhTW"] = "斐雍之砧",
        ["zhCN"] = "弗约恩之砧",
    },
    ["Jotunheim"] = {
        ["ptBR"] = "Jotunheim",
        ["ruRU"] = "Йотунхейм",
        ["deDE"] = "Jotunheim",
        ["koKR"] = "요툰하임",
        ["esMX"] = "Jotunheim",
        ["enUS"] = true,
        ["frFR"] = "Jotunheim",
        ["esES"] = "Jotunheim",
        ["zhTW"] = "卓頓海姆",
        ["zhCN"] = "尤顿海姆",
    },
    ["Savage Ledge"] = {
        ["ptBR"] = "Plataforma Selvagem",
        ["ruRU"] = "Дикий уступ",
        ["deDE"] = "Wilde Klippe",
        ["koKR"] = "야만전사의 절벽",
        ["esMX"] = "Cornisa Salvaje",
        ["enUS"] = true,
        ["frFR"] = "L'escarpement Sauvage",
        ["esES"] = "Cornisa Salvaje",
        ["zhTW"] = "蠻荒岩臺",
        ["zhCN"] = "野蛮之台",
    },
    ["Halls of the Ancestors"] = {
        ["ptBR"] = "Salões dos Antepassados",
        ["ruRU"] = "Залы Предков",
        ["deDE"] = "Hallen der Vorfahren",
        ["koKR"] = "선조의 전당",
        ["esMX"] = "Salas de los Ancestros",
        ["enUS"] = true,
        ["frFR"] = "Salles des Ancêtres",
        ["esES"] = "Salas de los Ancestros",
        ["zhTW"] = "先祖大廳",
        ["zhCN"] = "先祖大厅",
    },
    ["The Blighted Pool"] = {
        ["ptBR"] = "Tanque Empesteado",
        ["ruRU"] = "Гнилостный пруд",
        ["deDE"] = "Der verseuchte Teich",
        ["koKR"] = "파멸의 웅덩이",
        ["esMX"] = "La Poza Contagiada",
        ["enUS"] = true,
        ["frFR"] = "L'étang Chancreux",
        ["esES"] = "La Poza Contagiada",
        ["zhTW"] = "荒疫之池",
        ["zhCN"] = "枯萎之池",
    },
    ["The Eye of Eternity"] = {
        ["ptBR"] = "Olho da Eternidade",
        ["ruRU"] = "Око Вечности",
        ["deDE"] = "Das Auge der Ewigkeit",
        ["koKR"] = "영원의 눈",
        ["esMX"] = "El Ojo de la Eternidad",
        ["enUS"] = true,
        ["frFR"] = "L'Œil de l'éternité",
        ["esES"] = "El Ojo de la Eternidad",
        ["zhTW"] = "永恆之眼",
        ["zhCN"] = "永恒之眼",
    },
    ["The Argent Vanguard"] = {
        ["ptBR"] = "Vanguarda Argêntea",
        ["ruRU"] = "Оплот Серебряного Авангарда",
        ["deDE"] = "Die Argentumvorhut",
        ["koKR"] = "은빛십자군 선봉기지",
        ["esMX"] = "La Vanguardia Argenta",
        ["enUS"] = true,
        ["frFR"] = "L'avant-garde d'Argent",
        ["esES"] = "La Vanguardia Argenta",
        ["zhTW"] = "銀白先鋒駐地",
        ["zhCN"] = "银色前线基地",
    },
    ["Mimir's Workshop"] = {
        ["ptBR"] = "Oficina do Mimir",
        ["ruRU"] = "Мастерская Мимира",
        ["deDE"] = "Mimirs Werkstatt",
        ["koKR"] = "미미르의 작업장",
        ["esMX"] = "Taller de Mimir",
        ["enUS"] = true,
        ["frFR"] = "Atelier de Mimir",
        ["esES"] = "Taller de Mimir",
        ["zhTW"] = "彌米爾工坊",
        ["zhCN"] = "米米尔的车间",
    },
    ["Ironwall Dam"] = {
        ["ptBR"] = "Dique da Muralha de Ferro",
        ["ruRU"] = "Железная плотина",
        ["deDE"] = "Eisenwalldamm",
        ["koKR"] = "무쇠벽 둑",
        ["esMX"] = "Presa del Muro de Hierro",
        ["enUS"] = true,
        ["frFR"] = "Barrage Mur-de-fer",
        ["esES"] = "Presa del Muro de Hierro",
        ["zhTW"] = "鐵牆水壩",
        ["zhCN"] = "铁墙大坝",
    },
    ["Valley of Echoes"] = {
        ["ptBR"] = "Vale dos Ecos",
        ["ruRU"] = "Долина Эха",
        ["deDE"] = "Tal der Echos",
        ["koKR"] = "메아리 골짜기",
        ["esMX"] = "Valle de los Ecos",
        ["enUS"] = true,
        ["frFR"] = "Vallée des Échos",
        ["esES"] = "Valle de los Ecos",
        ["zhTW"] = "回聲山谷",
        ["zhCN"] = "回音谷",
    },
    ["The Breach"] = {
        ["ptBR"] = "A Brecha",
        ["ruRU"] = "Пролом",
        ["deDE"] = "Die Bresche",
        ["koKR"] = "거대한 틈",
        ["esMX"] = "La Brecha",
        ["enUS"] = true,
        ["frFR"] = "La Brèche",
        ["esES"] = "La Brecha",
        ["zhTW"] = "止境",
        ["zhCN"] = "突破口",
    },
    ["Scourgeholme"] = {
        ["ptBR"] = "Forte do Flagelo",
        ["ruRU"] = "Плетхольм",
        ["deDE"] = "Geißelholme",
        ["koKR"] = "스컬지홀름",
        ["esMX"] = "Ciudad de la Plaga",
        ["enUS"] = true,
        ["frFR"] = "Fléaulme",
        ["esES"] = "Ciudad de la Plaga",
        ["zhTW"] = "天譴岸地",
        ["zhCN"] = "天灾城",
    },
    ["The Broken Front"] = {
        ["ptBR"] = "O Front Partido",
        ["ruRU"] = "Прорванный фронт",
        ["deDE"] = "Die Zerbrochene Front",
        ["koKR"] = "파괴된 싸움터",
        ["esMX"] = "El Frente Roto",
        ["enUS"] = true,
        ["frFR"] = "Le Front brisé",
        ["esES"] = "El Frente Roto",
        ["zhTW"] = "破碎前線",
        ["zhCN"] = "破碎前线",
    },
    ["Mord'rethar: The Death Gate"] = {
        ["ptBR"] = "Mord'rethar: O Portão da Morte",
        ["ruRU"] = "Морд'ретар: Врата Смерти",
        ["deDE"] = "Mord'rethar: Das Tor des Todes",
        ["koKR"] = "모드레타르: 죽음의 관문",
        ["esMX"] = "Mord'rethar: La Puerta de la Muerte",
        ["enUS"] = true,
        ["frFR"] = "Mord'rethar : la Porte de la Mort",
        ["esES"] = "Mord'rethar: La Puerta de la Muerte",
        ["zhTW"] = "默德雷薩:死亡之門",
        ["zhCN"] = "死亡之门莫德雷萨",
    },
    ["The Bombardment"] = {
        ["ptBR"] = "O Bombardeio",
        ["ruRU"] = "Зона бомбардировки",
        ["deDE"] = "Das Bombardement",
        ["koKR"] = "폭격지",
        ["esMX"] = "El Bombardeo",
        ["enUS"] = true,
        ["frFR"] = "Le Bombardement",
        ["esES"] = "El Bombardeo",
        ["zhTW"] = "轟炸地",
        ["zhCN"] = "轰炸场",
    },
    ["The Skybreaker"] = {
        ["ptBR"] = "O Rompe-céus",
        ["ruRU"] = "Усмиритель небес",
        ["deDE"] = "Die Himmelsbrecher",
        ["koKR"] = "하늘파괴자호",
        ["esMX"] = "El Rompecielos",
        ["enUS"] = true,
        ["frFR"] = "Le Brise-ciel",
        ["esES"] = "El Rompecielos",
        ["zhTW"] = "破天者號",
        ["zhCN"] = "破天号",
    },
    ["Orgrim's Hammer"] = {
        ["ptBR"] = "Martelo de Orgrim",
        ["ruRU"] = "Молот Оргрима",
        ["deDE"] = "Orgrims Hammer",
        ["koKR"] = "오그림의 망치호",
        ["esMX"] = "Martillo de Orgrim",
        ["enUS"] = true,
        ["frFR"] = "Le Marteau d'Orgrim",
        ["esES"] = "Martillo de Orgrim",
        ["zhTW"] = "奧格林之錘",
        ["zhCN"] = "奥格瑞姆之锤",
    },
    ["Ymirheim"] = {
        ["ptBR"] = "Ymarheim",
        ["ruRU"] = "Имирхейм",
        ["deDE"] = "Ymirheim",
        ["koKR"] = "이미르하임",
        ["esMX"] = "Ymirheim",
        ["enUS"] = true,
        ["frFR"] = "Ymirheim",
        ["esES"] = "Ymirheim",
        ["zhTW"] = "依米海姆",
        ["zhCN"] = "伊米海姆",
    },
    ["Saronite Mines"] = {
        ["ptBR"] = "Minas de Saronita",
        ["ruRU"] = "Саронитовые шахты",
        ["deDE"] = "Saronitminen",
        ["koKR"] = "사로나이트 광산",
        ["esMX"] = "Minas de Saronita",
        ["enUS"] = true,
        ["frFR"] = "Mines de saronite",
        ["esES"] = "Minas de Saronita",
        ["zhTW"] = "薩鋼礦坑",
        ["zhCN"] = "萨隆邪铁矿洞",
    },
    ["The Conflagration"] = {
        ["ptBR"] = "A Conflagração",
        ["ruRU"] = "Пожарище",
        ["deDE"] = "Der Großbrand",
        ["koKR"] = "끝없는 불길",
        ["esMX"] = "La Conflagración",
        ["enUS"] = true,
        ["frFR"] = "La Déflagration",
        ["esES"] = "La Conflagración",
        ["zhTW"] = "焚焰地",
        ["zhCN"] = "战火平原",
    },
    ["Ironwall Rampart"] = {
        ["ptBR"] = "Muralha de Ferro",
        ["ruRU"] = "Железный вал",
        ["deDE"] = "Eisenwallbollwerk",
        ["koKR"] = "무쇠벽 성채",
        ["esMX"] = "Fortificación del Muro de Hierro",
        ["enUS"] = true,
        ["frFR"] = "Rempart Mur-de-fer",
        ["esES"] = "Fortificación del Muro de Hierro",
        ["zhTW"] = "鐵牆壁壘",
        ["zhCN"] = "铁墙壁垒",
    },
    ["Weeping Quarry"] = {
        ["ptBR"] = "Pedreira dos Lamentos",
        ["ruRU"] = "Саронитовый карьер",
        ["deDE"] = "Der Tränenbruch",
        ["koKR"] = "진흙탕 채석장",
        ["esMX"] = "Cantera Llorosa",
        ["enUS"] = true,
        ["frFR"] = "Carrière des Larmes",
        ["esES"] = "Cantera Llorosa",
        ["zhTW"] = "哀泣礦場",
        ["zhCN"] = "哭泣采掘场",
    },
    ["Corp'rethar: The Horror Gate"] = {
        ["ptBR"] = "Corp'rethar: O Portão do Horror",
        ["ruRU"] = "Корп'ретар: Врата Ужаса",
        ["deDE"] = "Corp'rethar: Das Tor des Schreckens",
        ["koKR"] = "코프레타르: 공포의 관문",
        ["esMX"] = "Corp'rethar: La Puerta del Horror",
        ["enUS"] = true,
        ["frFR"] = "Corp'rethar : la Porte de l'Horreur",
        ["esES"] = "Corp'rethar: La Puerta del Horror",
        ["zhTW"] = "寇普雷薩:驚怖之門",
        ["zhCN"] = "恐惧之门科雷萨",
    },
    ["Malykriss: The Vile Hold"] = {
        ["ptBR"] = "Malykriss: O Forte Torpe",
        ["ruRU"] = "Маликрисс: Зловещая Крепость",
        ["deDE"] = "Malykriss: Die unheilvolle Festung",
        ["koKR"] = "말리크리스: 타락의 요새",
        ["esMX"] = "Malykriss: El Bastión Inmundo",
        ["enUS"] = true,
        ["frFR"] = "Malykriss : le Fort infâme",
        ["esES"] = "Malykriss: El Bastión Inmundo",
        ["zhTW"] = "瑪里庫立斯:邪鄙堡",
        ["zhCN"] = "玛雷卡里斯：邪恶城堡",
    },
    ["Cathedral of Darkness"] = {
        ["ptBR"] = "Catedral das Trevas",
        ["ruRU"] = "Собор Тьмы",
        ["deDE"] = "Kathedrale der Dunkelheit",
        ["koKR"] = "어둠의 대성당",
        ["esMX"] = "Catedral de la Oscuridad",
        ["enUS"] = true,
        ["frFR"] = "Cathédrale des ténèbres",
        ["esES"] = "Catedral de la Oscuridad",
        ["zhTW"] = "黑暗大教堂",
        ["zhCN"] = "黑暗大教堂",
    },
    ["Icecrown Glacier"] = {
        ["ptBR"] = "Glaciar Coroa de Gelo",
        ["ruRU"] = "Ледник Ледяная Корона",
        ["deDE"] = "Eiskronengletscher",
        ["koKR"] = "얼음왕관 빙하",
        ["esMX"] = "Glaciar Corona de Hielo",
        ["enUS"] = true,
        ["frFR"] = "Glacier de la Couronne de glace",
        ["esES"] = "Glaciar Corona de Hielo",
        ["zhTW"] = "寒冰皇冠",
        ["zhCN"] = "冰冠冰川",
    },
    ["Valhalas"] = {
        ["ptBR"] = "Valhalas",
        ["ruRU"] = "Валхалас",
        ["deDE"] = "Valhalas",
        ["koKR"] = "발할라스",
        ["esMX"] = "Valhalas",
        ["enUS"] = true,
        ["frFR"] = "Valhalas",
        ["esES"] = "Valhalas",
        ["zhTW"] = "英靈殿",
        ["zhCN"] = "瓦哈拉斯",
    },
    ["The Underhalls"] = {
        ["ptBR"] = "Salões Subterrâneos",
        ["ruRU"] = "Глубинные чертоги",
        ["deDE"] = "Das Kellergewölbe",
        ["koKR"] = "지하 전당",
        ["esMX"] = "Las Cámaras Subterráneas",
        ["enUS"] = true,
        ["frFR"] = "Les Basses-salles",
        ["esES"] = "Las Cámaras Subterráneas",
        ["zhTW"] = "地下大廳",
        ["zhCN"] = "地下大厅",
    },
    ["Njorndar Village"] = {
        ["ptBR"] = "Vila Njorndar",
        ["ruRU"] = "Деревня Ньорндар",
        ["deDE"] = "Njorndar",
        ["koKR"] = "요른다르 마을",
        ["esMX"] = "Poblado Njorndar",
        ["enUS"] = true,
        ["frFR"] = "Njorndar",
        ["esES"] = "Poblado Njorndar",
        ["zhTW"] = "尼約達村",
        ["zhCN"] = "约尔达村",
    },
    ["Balargarde Fortress"] = {
        ["ptBR"] = "Fortaleza Balargarde",
        ["ruRU"] = "Цитадель Балагарда",
        ["deDE"] = "Festung Balargarde",
        ["koKR"] = "발라르가드 요새",
        ["esMX"] = "Fortaleza de Balargarde",
        ["enUS"] = true,
        ["frFR"] = "Forteresse de Balargarde",
        ["esES"] = "Fortaleza de Balargarde",
        ["zhTW"] = "巴拉加德堡壘",
        ["zhCN"] = "巴拉加德堡垒",
    },
    ["Kul'galar Keep"] = {
        ["ptBR"] = "Forte Kul'galar",
        ["ruRU"] = "Крепость Кул'галар",
        ["deDE"] = "Feste Kul'galar",
        ["koKR"] = "쿨갈라르 성채",
        ["esMX"] = "Fortaleza de Kul'galar",
        ["enUS"] = true,
        ["frFR"] = "Donjon de Kul'galar",
        ["esES"] = "Fortaleza de Kul'galar",
        ["zhTW"] = "庫爾加拉要塞",
        ["zhCN"] = "库尔加拉要塞",
    },
    ["The Crimson Cathedral"] = {
        ["ptBR"] = "Catedral Carmesim",
        ["ruRU"] = "Багровый собор",
        ["deDE"] = "Die Scharlachrote Kathedrale",
        ["koKR"] = "진홍빛 성당",
        ["esMX"] = "La Catedral Carmesí",
        ["enUS"] = true,
        ["frFR"] = "La Cathédrale cramoisie",
        ["esES"] = "La Catedral Carmesí",
        ["zhTW"] = "赤紅大教堂",
        ["zhCN"] = "赤色大教堂",
    },
    ["Sanctum of Reanimation"] = {
        ["ptBR"] = "Sacrário da Reanimação",
        ["ruRU"] = "Святилище воскрешения",
        ["deDE"] = "Sanktum der Reanimation",
        ["koKR"] = "부활의 성소",
        ["esMX"] = "Sagrario de Reanimación",
        ["enUS"] = true,
        ["frFR"] = "Sanctum de réanimation",
        ["esES"] = "Sagrario de Reanimación",
        ["zhTW"] = "再活化聖所",
        ["zhCN"] = "复生密室",
    },
    ["The Fleshwerks"] = {
        ["ptBR"] = "Usina de Carne",
        ["ruRU"] = "Мясопилка",
        ["deDE"] = "Die Fleischwerke",
        ["koKR"] = "살덩이작업장",
        ["esMX"] = "La Factoría de Carne",
        ["enUS"] = true,
        ["frFR"] = "La Charognerie",
        ["esES"] = "La Factoría de Carne",
        ["zhTW"] = "血肉作坊",
        ["zhCN"] = "缝合场",
    },
    ["Vengeance Landing Inn"] = {
        ["ptBR"] = "Estalagem de Porto Vendeta",
        ["ruRU"] = "Таверна Лагеря возмездия",
        ["deDE"] = "Gasthaus des Hafens der Vergeltung",
        ["koKR"] = "복수의 상륙지 여관",
        ["esMX"] = "Taberna de Campo Venganza",
        ["enUS"] = true,
        ["frFR"] = "Auberge de l'accostage de la Vengeance",
        ["esES"] = "Taberna de Campo Venganza",
        ["zhTW"] = "復仇臺地旅店",
        ["zhCN"] = "复仇港旅店",
    },
    ["Wildervar Mine"] = {
        ["ptBR"] = "Mina Vildervar",
        ["ruRU"] = "Вилдерварская шахта",
        ["deDE"] = "Mine von Wildervar",
        ["koKR"] = "빌더바르 광산",
        ["esMX"] = "Mina de Vildervar",
        ["enUS"] = true,
        ["frFR"] = "Mine Hardivar",
        ["esES"] = "Mina de Vildervar",
        ["zhTW"] = "威德瓦礦坑",
        ["zhCN"] = "维德瓦矿洞",
    },
    ["The Pit of the Fang"] = {
        ["ptBR"] = "Fosso da Presa",
        ["ruRU"] = "Яма Клыка",
        ["deDE"] = "Die Reißzahngrube",
        ["koKR"] = "송곳니 구덩이",
        ["esMX"] = "El Foso del Colmillo",
        ["enUS"] = true,
        ["frFR"] = "La Fosse du croc",
        ["esES"] = "El Foso del Colmillo",
        ["zhTW"] = "尖牙之淵",
        ["zhCN"] = "利齿之坑",
    },
    ["Frosthowl Cavern"] = {
        ["ptBR"] = "Caverna Uivo de Gelo",
        ["ruRU"] = "Пещера Ледяного Воя",
        ["deDE"] = "Heulende Frosthöhle",
        ["koKR"] = "서리울음 동굴",
        ["esMX"] = "Caverna Aúllaescarcha",
        ["enUS"] = true,
        ["frFR"] = "Caverne des Hurlegivres",
        ["esES"] = "Caverna Aúllaescarcha",
        ["zhTW"] = "霜嚎洞窟",
        ["zhCN"] = "霜嚎洞穴",
    },
    ["The Valley of Lost Hope"] = {
        ["ptBR"] = "Vale das Esperanças Perdidas",
        ["ruRU"] = "Долина Потерянной Надежды",
        ["deDE"] = "Das Tal der Verlorenen Hoffnung",
        ["koKR"] = "잃어버린 희망의 계곡",
        ["esMX"] = "El Valle de la Esperanza Perdida",
        ["enUS"] = true,
        ["frFR"] = "La vallée de l'Espoir perdu",
        ["esES"] = "El Valle de la Esperanza Perdida",
        ["zhTW"] = "逝望山谷",
        ["zhCN"] = "失落希望之谷",
    },
    ["The Valley of Fallen Heroes"] = {
        ["ptBR"] = "Vale dos Heróis Caídos",
        ["ruRU"] = "Долина Павших Героев",
        ["deDE"] = "Das Tal der Gefallenen Helden",
        ["koKR"] = "전사한 영웅의 계곡",
        ["esMX"] = "El Valle de los Héroes Caídos",
        ["enUS"] = true,
        ["frFR"] = "La vallée des Héros défunts",
        ["esES"] = "El Valle de los Héroes Caídos",
        ["zhTW"] = "逝往英雄山谷",
        ["zhCN"] = "陨落英雄之谷",
    },
    ["Vanguard Infirmary"] = {
        ["ptBR"] = "Enfermaria da Vanguarda",
        ["ruRU"] = "Лазарет Оплота",
        ["deDE"] = "Feldlazarett der Vorhut",
        ["koKR"] = "선봉기지 치료소",
        ["esMX"] = "Enfermería de la Vanguardia",
        ["enUS"] = true,
        ["frFR"] = "Infirmerie de l'avant-garde",
        ["esES"] = "Enfermería de la Vanguardia",
        ["zhTW"] = "先鋒醫護站",
        ["zhCN"] = "前线基地医护所",
    },
    ["Hall of the Shaper"] = {
        ["ptBR"] = "Salão do Formador",
        ["ruRU"] = "Зал Творца",
        ["deDE"] = "Halle des Formers",
        ["koKR"] = "구체자의 전당",
        ["esMX"] = "Sala del Creador",
        ["enUS"] = true,
        ["frFR"] = "Hall du Façonneur",
        ["esES"] = "Sala del Creador",
        ["zhTW"] = "塑造者大廳",
        ["zhCN"] = "塑造者之厅",
    },
    ["Temple of Wisdom"] = {
        ["ptBR"] = "Templo da Sabedoria",
        ["ruRU"] = "Храм Мудрости",
        ["deDE"] = "Tempel der Weisheit",
        ["koKR"] = "지혜의 신전",
        ["esMX"] = "Templo de Sabiduría",
        ["enUS"] = true,
        ["frFR"] = "Temple de la Sagesse",
        ["esES"] = "Templo de Sabiduría",
        ["zhTW"] = "智慧神殿",
        ["zhCN"] = "智慧神殿",
    },
    ["Death's Breach"] = {
        ["ptBR"] = "Vanguarda da Morte",
        ["ruRU"] = "Разлом Смерти",
        ["deDE"] = "Die Todesbresche",
        ["koKR"] = "죽음의 틈",
        ["esMX"] = "Brecha de la Muerte",
        ["enUS"] = true,
        ["frFR"] = "Brèche-de-Mort",
        ["esES"] = "Brecha de la Muerte",
        ["zhTW"] = "死亡止境",
        ["zhCN"] = "死亡裂口",
    },
    ["Abandoned Mine"] = {
        ["ptBR"] = "Mina Abandonada",
        ["ruRU"] = "Заброшенная шахта",
        ["deDE"] = "Verlassene Mine",
        ["koKR"] = "버려진 광산",
        ["esMX"] = "Mina Abandonada",
        ["enUS"] = true,
        ["frFR"] = "Mine abandonnée",
        ["esES"] = "Mina Abandonada",
        ["zhTW"] = "棄置礦坑",
        ["zhCN"] = "被遗弃的矿洞",
    },
    ["Ruins of the Scarlet Enclave"] = {
        ["ptBR"] = "Ruínas do Enclave Escarlate",
        ["ruRU"] = "Руины Анклава Алого ордена",
        ["deDE"] = "Ruinen der Scharlachroten Enklave",
        ["koKR"] = "붉은십자군 폐허",
        ["esMX"] = "Ruinas de El Enclave Escarlata",
        ["enUS"] = true,
        ["frFR"] = "Ruines de l'enclave Écarlate",
        ["esES"] = "Ruinas de El Enclave Escarlata",
        ["zhTW"] = "血色領區廢墟",
        ["zhCN"] = "血色领地废墟",
    },
    ["Halls of Stone"] = {
        ["ptBR"] = "Salões Rochosos",
        ["ruRU"] = "Чертоги Камня",
        ["deDE"] = "Hallen des Steins",
        ["koKR"] = "돌의 전당",
        ["esMX"] = "Cámaras de Piedra",
        ["enUS"] = true,
        ["frFR"] = "Les salles de Pierre",
        ["esES"] = "Cámaras de Piedra",
        ["zhTW"] = "石之大廳",
        ["zhCN"] = "岩石大厅",
    },
    ["Halls of Lightning"] = {
        ["ptBR"] = "Salões Relampejantes",
        ["ruRU"] = "Чертоги Молний",
        ["deDE"] = "Hallen der Blitze",
        ["koKR"] = "번개의 전당",
        ["esMX"] = "Cámaras de Relámpagos",
        ["enUS"] = true,
        ["frFR"] = "Les salles de Foudre",
        ["esES"] = "Cámaras de Relámpagos",
        ["zhTW"] = "雷光大廳",
        ["zhCN"] = "闪电大厅",
    },
    ["The Great Tree"] = {
        ["ptBR"] = "A Grande Árvore",
        ["ruRU"] = "Великое Древо",
        ["deDE"] = "Der Große Baum",
        ["koKR"] = "거대 고목",
        ["esMX"] = "El Gran Árbol",
        ["enUS"] = true,
        ["frFR"] = "Le grand Arbre",
        ["esES"] = "El Gran Árbol",
        ["zhTW"] = "巨偉之樹",
        ["zhCN"] = "符印巨树",
    },
    ["The Mirror of Twilight"] = {
        ["ptBR"] = "Espelho do Crepúsculo",
        ["ruRU"] = "Зеркало Сумерек",
        ["deDE"] = "Der Zwielichtspiegel",
        ["koKR"] = "황혼의 거울",
        ["esMX"] = "El Espejo del Crepúsculo",
        ["enUS"] = true,
        ["frFR"] = "Le Miroir du crépuscule",
        ["esES"] = "El Espejo del Crepúsculo",
        ["zhTW"] = "曦光之鏡",
        ["zhCN"] = "暮色之镜",
    },
    ["The Twilight Rivulet"] = {
        ["ptBR"] = "Regato do Crepúsculo",
        ["ruRU"] = "Сумеречный ручей",
        ["deDE"] = "Der Zwielichtbach",
        ["koKR"] = "황혼의 개울",
        ["esMX"] = "El Riachuelo Crepuscular",
        ["enUS"] = true,
        ["frFR"] = "Le ruisselet du Crépuscule",
        ["esES"] = "El Riachuelo Crepuscular",
        ["zhTW"] = "曦光之溪",
        ["zhCN"] = "暮色小溪",
    },
    ["The Decrepit Flow"] = {
        ["ptBR"] = "Córrego Decrépito",
        ["ruRU"] = "Замерший поток",
        ["deDE"] = "Der versiegende Strom",
        ["koKR"] = "이울어진 물줄기",
        ["esMX"] = "La Corriente Decrépita",
        ["enUS"] = true,
        ["frFR"] = "Le courant Stagnant",
        ["esES"] = "La Corriente Decrépita",
        ["zhTW"] = "衰舊之流",
        ["zhCN"] = "衰弱之河",
    },
    ["Forlorn Woods"] = {
        ["ptBR"] = "Bosque Esquecido",
        ["ruRU"] = "Опустевшие леса",
        ["deDE"] = "Die trostlosen Wälder",
        ["koKR"] = "쓸쓸한 숲",
        ["esMX"] = "El Bosque Desolado",
        ["enUS"] = true,
        ["frFR"] = "Bois Lugubre",
        ["esES"] = "El Bosque Desolado",
        ["zhTW"] = "凋落樹林",
        ["zhCN"] = "绝望之林",
    },
    ["Ruins of Shandaral"] = {
        ["ptBR"] = "Ruínas de Shandaral",
        ["ruRU"] = "Руины Шандарала",
        ["deDE"] = "Ruinen von Shandaral",
        ["koKR"] = "샨다랄 폐허",
        ["esMX"] = "Ruinas de Shandaral",
        ["enUS"] = true,
        ["frFR"] = "Ruines de Shandaral",
        ["esES"] = "Ruinas de Shandaral",
        ["zhTW"] = "珊達拉遺跡",
        ["zhCN"] = "杉达拉废墟",
    },
    ["The Azure Front"] = {
        ["ptBR"] = "Front Lazúli",
        ["ruRU"] = "Лазурный берег",
        ["deDE"] = "Die Azurfront",
        ["koKR"] = "하늘빛 전초지",
        ["esMX"] = "El Frente Azur",
        ["enUS"] = true,
        ["frFR"] = "Le front Azur",
        ["esES"] = "El Frente Azur",
        ["zhTW"] = "蒼藍前線",
        ["zhCN"] = "碧蓝前线",
    },
    ["Violet Stand"] = {
        ["ptBR"] = "Fortaleza Violácea",
        ["ruRU"] = "Аметистовая застава",
        ["deDE"] = "Die Violette Wacht",
        ["koKR"] = "보랏빛 단",
        ["esMX"] = "El Confín Violeta",
        ["enUS"] = true,
        ["frFR"] = "Le Séjour pourpre",
        ["esES"] = "El Confín Violeta",
        ["zhTW"] = "紫羅蘭看臺",
        ["zhCN"] = "紫罗兰哨站",
    },
    ["The Unbound Thicket"] = {
        ["ptBR"] = "Selva Franca",
        ["ruRU"] = "Дикая чаща",
        ["deDE"] = "Unbändiges Dickicht",
        ["koKR"] = "해방의 숲",
        ["esMX"] = "El Matorral Desatado",
        ["enUS"] = true,
        ["frFR"] = "Le fourré Délié",
        ["esES"] = "El Matorral Desatado",
        ["zhTW"] = "無縛灌木林",
        ["zhCN"] = "自由之林",
    },
    ["Sunreaver's Command"] = {
        ["ptBR"] = "Comando Fendessol",
        ["ruRU"] = "Лагерь Похитителя Солнца",
        ["deDE"] = "Sonnenhäschers Schar",
        ["koKR"] = "선리버 지휘초소",
        ["esMX"] = "Dominio de los Atracasol",
        ["enUS"] = true,
        ["frFR"] = "Quartier général de Saccage-soleil",
        ["esES"] = "Dominio de los Atracasol",
        ["zhTW"] = "奪日者指揮所",
        ["zhCN"] = "夺日者指挥站",
    },
    ["Windrunner's Overlook"] = {
        ["ptBR"] = "Penhasco Correventos",
        ["ruRU"] = "Дозор Ветрокрылой",
        ["deDE"] = "Windläufers Warte",
        ["koKR"] = "윈드러너 전망대",
        ["esMX"] = "Mirador Brisaveloz",
        ["enUS"] = true,
        ["frFR"] = "Surplomb de Coursevent",
        ["esES"] = "Mirador Brisaveloz",
        ["zhTW"] = "風行者瞰臺",
        ["zhCN"] = "风行者观察站",
    },
    ["The Underbelly"] = {
        ["ptBR"] = "Os Esgotos",
        ["ruRU"] = "Клоака",
        ["deDE"] = "Die Schattenseite",
        ["koKR"] = "마법의 뒤안길",
        ["esMX"] = "Los Bajos Fondos",
        ["enUS"] = true,
        ["frFR"] = "Les Entrailles",
        ["esES"] = "Los Bajos Fondos",
        ["zhTW"] = "城底區",
        ["zhCN"] = "达拉然下水道",
    },
    ["The Violet Hold"] = {
        ["ptBR"] = "Castelo Violeta",
        ["ruRU"] = "Аметистовая крепость",
        ["deDE"] = "Die Violette Festung",
        ["koKR"] = "보랏빛 요새",
        ["esMX"] = "El Bastión Violeta",
        ["enUS"] = true,
        ["frFR"] = "Le fort Pourpre",
        ["esES"] = "El Bastión Violeta",
        ["zhTW"] = "紫羅蘭堡",
        ["zhCN"] = "紫罗兰监狱",
    },
    ["The Eventide"] = {
        ["ptBR"] = "Anoitecer",
        ["ruRU"] = "Вечерняя Заря",
        ["deDE"] = "Die Abendruh",
        ["koKR"] = "어스름 거리",
        ["esMX"] = "El Manto de la Noche",
        ["enUS"] = true,
        ["frFR"] = "Le Brunant",
        ["esES"] = "El Manto de la Noche",
        ["zhTW"] = "日暮區",
        ["zhCN"] = "日暮广场",
    },
    ["Circle of Wills"] = {
        ["ptBR"] = "Círculo dos Desejos",
        ["ruRU"] = "Круг Воли",
        ["deDE"] = "Kreis der Mächte",
        ["koKR"] = "의지의 투기장",
        ["esMX"] = "Círculo de Voluntades",
        ["enUS"] = true,
        ["frFR"] = "Le cercle des Volontés",
        ["esES"] = "Círculo de Voluntades",
        ["zhTW"] = "意志之環",
        ["zhCN"] = "意志竞技场",
    },
    ["Silverwing Flag Room"] = {
        ["ptBR"] = "Sala da Bandeira Asa de Prata",
        ["ruRU"] = "Флаговая комната Среброкрылых",
        ["deDE"] = "Flaggenraum der Silberschwingen",
        ["koKR"] = "은빛날개 깃발 보관실",
        ["esMX"] = "Sala de la Bandera de Brisa de Plata",
        ["enUS"] = true,
        ["frFR"] = "Salle du drapeau des Ailes-d'argent",
        ["esES"] = "Sala de la Bandera de Brisa de Plata",
        ["zhTW"] = "銀翼旗幟房間",
        ["zhCN"] = "银翼军旗室",
    },
    ["Warsong Flag Room"] = {
        ["ptBR"] = "Sala da Bandeira Brado Guerreiro",
        ["ruRU"] = "Флаговая комната Песни Войны",
        ["deDE"] = "Flaggenraum des Kriegshymnenklans",
        ["koKR"] = "전쟁노래 깃발 보관실",
        ["esMX"] = "Sala de la Bandera Grito de Guerra",
        ["enUS"] = true,
        ["frFR"] = "Salle du drapeau des Chanteguerres",
        ["esES"] = "Sala de la Bandera Grito de Guerra",
        ["zhTW"] = "戰歌旗幟房間",
        ["zhCN"] = "战歌军旗室",
    },
    ["Dubra'Jin"] = {
        ["ptBR"] = "Dubra'Jin",
        ["ruRU"] = "Дубра'джин",
        ["deDE"] = "Dubra'Jin",
        ["koKR"] = "두브라진",
        ["esMX"] = "Dubra'Jin",
        ["enUS"] = true,
        ["frFR"] = "Dubra'Jin",
        ["esES"] = "Dubra'Jin",
        ["zhTW"] = "杜布拉金",
        ["zhCN"] = "杜布拉金",
    },
    ["Crusaders' Pinnacle"] = {
        ["ptBR"] = "Pináculo dos Cruzados",
        ["ruRU"] = "Вершина Рыцарей",
        ["deDE"] = "Kreuzfahrerturm",
        ["koKR"] = "십자군 봉우리",
        ["esMX"] = "Pináculo de los Cruzados",
        ["enUS"] = true,
        ["frFR"] = "Cime des Croisés",
        ["esES"] = "Pináculo de los Cruzados",
        ["zhTW"] = "十字軍之巔",
        ["zhCN"] = "北伐军之峰",
    },
    ["Windy Bluffs"] = {
        ["ptBR"] = "Penhasco dos Ventos",
        ["ruRU"] = "Ветряные утесы",
        ["deDE"] = "Die windigen Klippen",
        ["koKR"] = "바람 절벽",
        ["esMX"] = "Riscos Ventosos",
        ["enUS"] = true,
        ["frFR"] = "Les pitons Venteux",
        ["esES"] = "Riscos Ventosos",
        ["zhTW"] = "群風崖",
        ["zhCN"] = "狂风崖",
    },
    ["Blackwatch"] = {
        ["ptBR"] = "Guarda Negra",
        ["ruRU"] = "Черный дозор",
        ["deDE"] = "Die Schwarzwacht",
        ["koKR"] = "어둠의 감시초소",
        ["esMX"] = "La Guardia Negra",
        ["enUS"] = true,
        ["frFR"] = "Guet Noir",
        ["esES"] = "La Guardia Negra",
        ["zhTW"] = "黑色守望",
        ["zhCN"] = "黑色观察站",
    },
    ["Gimorak's Den"] = {
        ["ptBR"] = "Covil de Gimorak",
        ["ruRU"] = "Логово Гиморака",
        ["deDE"] = "Gimoraks Bau",
        ["koKR"] = "기모라크의 동굴",
        ["esMX"] = "Guarida de Gimorak",
        ["enUS"] = true,
        ["frFR"] = "Tanière de Gimorak",
        ["esES"] = "Guarida de Gimorak",
        ["zhTW"] = "吉摩拉克獸穴",
        ["zhCN"] = "基莫拉克之巢",
    },
    ["The Pit of Fiends"] = {
        ["ptBR"] = "Fosso dos Demônios",
        ["ruRU"] = "Яма чудовищ",
        ["deDE"] = "Die Schreckensgrube",
        ["koKR"] = "악마의 구덩이",
        ["esMX"] = "El Foso de los Mefistos",
        ["enUS"] = true,
        ["frFR"] = "La fosse aux Démons",
        ["esES"] = "El Foso de los Mefistos",
        ["zhTW"] = "魔鬼之淵",
        ["zhCN"] = "邪魔之坑",
    },
    ["Battlescar Spire"] = {
        ["ptBR"] = "Pináculo Chaga de Guerra",
        ["ruRU"] = "Вершина Боевого Шрама",
        ["deDE"] = "Kriegsnarbenwarte",
        ["koKR"] = "전투의 흉터 첨탑",
        ["esMX"] = "Cumbre Marca de Guerra",
        ["enUS"] = true,
        ["frFR"] = "Flèche de la Balafre",
        ["esES"] = "Cumbre Marca de Guerra",
        ["zhTW"] = "戰傷尖塔",
        ["zhCN"] = "战痕尖塔",
    },
    ["Hall of Horrors"] = {
        ["ptBR"] = "Salão dos Horrores",
        ["ruRU"] = "Зал Ужасов",
        ["deDE"] = "Halle des Grauens",
        ["koKR"] = "공포의 전당",
        ["esMX"] = "Cámara de los Horrores",
        ["enUS"] = true,
        ["frFR"] = "Salle des Horreurs",
        ["esES"] = "Cámara de los Horrores",
        ["zhTW"] = "驚怖大廳",
        ["zhCN"] = "恐惧大厅",
    },
    ["The Circle of Suffering"] = {
        ["ptBR"] = "Círculo dos Sofrimentos",
        ["ruRU"] = "Круг Страдания",
        ["deDE"] = "Der Kreis des Leidens",
        ["koKR"] = "고통의 투기장",
        ["esMX"] = "El Círculo de Sufrimiento",
        ["enUS"] = true,
        ["frFR"] = "Cercle de Souffrance",
        ["esES"] = "El Círculo de Sufrimiento",
        ["zhTW"] = "苦難之環",
        ["zhCN"] = "受难之环",
    },
    ["Rise of Suffering"] = {
        ["ptBR"] = "Beira do Sofrimento",
        ["ruRU"] = "Высота Страдания",
        ["deDE"] = "Anhöhe des Leidens",
        ["koKR"] = "고통의 언덕",
        ["esMX"] = "Alto del Sufrimiento",
        ["enUS"] = true,
        ["frFR"] = "Cime de Souffrance",
        ["esES"] = "Alto del Sufrimiento",
        ["zhTW"] = "苦難高崗",
        ["zhCN"] = "苦难高地",
    },
    ["Krasus' Landing"] = {
        ["ptBR"] = "Plataforma de Krasus",
        ["ruRU"] = "Площадка Краса",
        ["deDE"] = "Krasus' Landeplatz",
        ["koKR"] = "크라서스 착륙장",
        ["esMX"] = "Alto de Krasus",
        ["enUS"] = true,
        ["frFR"] = "Aire de Krasus",
        ["esES"] = "Alto de Krasus",
        ["zhTW"] = "卡薩斯平臺",
        ["zhCN"] = "克拉苏斯平台",
    },
    ["Sewer Exit Pipe"] = {
        ["ptBR"] = "Cano de Saída dos Esgotos",
        ["ruRU"] = "Выход из сточной трубы",
        ["deDE"] = "Ausgangsrohr der Kanalisation",
        ["koKR"] = "하수도 배출관",
        ["esMX"] = "Tubería de salida de las cloacas",
        ["enUS"] = true,
        ["frFR"] = "Tunnel de sortie des égouts",
        ["esES"] = "Tubería de salida de las cloacas",
        ["zhTW"] = "下水道出口管道",
        ["zhCN"] = "下水道排水管",
    },
    ["Dalaran Island"] = {
        ["ptBR"] = "Ilha de Dalaran",
        ["ruRU"] = "Остров Даларан",
        ["deDE"] = "Insel Dalaran",
        ["koKR"] = "달라란 섬",
        ["esMX"] = "Isla de Dalaran",
        ["enUS"] = true,
        ["frFR"] = "Île de Dalaran",
        ["esES"] = "Isla de Dalaran",
        ["zhTW"] = "達拉然島",
        ["zhCN"] = "达拉然岛",
    },
    ["Force Interior"] = {
        ["ptBR"] = "Força Interior",
        ["ruRU"] = "Интерьер силы",
        ["deDE"] = "Das Innere der Macht",
        ["koKR"] = "내부 강제",
        ["esMX"] = "Fuerza Interior",
        ["enUS"] = true,
        ["frFR"] = "Force intérieure",
        ["esES"] = "Fuerza Interior",
        ["zhTW"] = "力場內部",
        ["zhCN"] = "内室",
    },
    ["Gate of the Red Sun"] = {
        ["ptBR"] = "Pórtico do Sol Escarlate",
        ["ruRU"] = "Врата Красного Солнца",
        ["deDE"] = "Tor der Rubinsonne",
        ["koKR"] = "붉은 태양 관문",
        ["esMX"] = "Puerta del Sol Rojo",
        ["enUS"] = true,
        ["frFR"] = "Porte du Soleil rouge",
        ["esES"] = "Puerta del Sol Rojo",
        ["zhTW"] = "紅日之門",
        ["zhCN"] = "红日之门",
    },
    ["Gate of the Blue Sapphire"] = {
        ["ptBR"] = "Pórtico da Safira Azul",
        ["ruRU"] = "Врата Синего Сапфира",
        ["deDE"] = "Tor des Saphirhimmels",
        ["koKR"] = "푸른 사파이어 관문",
        ["esMX"] = "Puerta del Zafiro Azul",
        ["enUS"] = true,
        ["frFR"] = "Porte du Saphir bleu",
        ["esES"] = "Puerta del Zafiro Azul",
        ["zhTW"] = "藍晶之門",
        ["zhCN"] = "蓝玉之门",
    },
    ["Gate of the Green Emerald"] = {
        ["ptBR"] = "Pórtico da Esmeralda Verde",
        ["ruRU"] = "Врата Зеленого Изумруда",
        ["deDE"] = "Tor des Smaragdhorizonts",
        ["koKR"] = "초록 에메랄드 관문",
        ["esMX"] = "Puerta de la Esmeralda Verde",
        ["enUS"] = true,
        ["frFR"] = "Porte de l'Émeraude verte",
        ["esES"] = "Puerta de la Esmeralda Verde",
        ["zhTW"] = "碧翠之門",
        ["zhCN"] = "翡翠之门",
    },
    ["Gate of the Purple Amethyst"] = {
        ["ptBR"] = "Pórtico da Ametista Roxa",
        ["ruRU"] = "Врата Лилового Аметиста",
        ["deDE"] = "Tor des Amethyststerns",
        ["koKR"] = "보라 자수정 관문",
        ["esMX"] = "Puerta de la Amatista Púrpura",
        ["enUS"] = true,
        ["frFR"] = "Porte de l'Améthyste violette",
        ["esES"] = "Puerta de la Amatista Púrpura",
        ["zhTW"] = "紫晶之門",
        ["zhCN"] = "紫晶之门",
    },
    ["Gate of the Yellow Moon"] = {
        ["ptBR"] = "Pórtico da Lua Amarela",
        ["ruRU"] = "Врата Желтой Луны",
        ["deDE"] = "Tor des Goldmondes",
        ["koKR"] = "노란 달 관문",
        ["esMX"] = "Puerta de la Luna Amarilla",
        ["enUS"] = true,
        ["frFR"] = "Porte de la Lune jaune",
        ["esES"] = "Puerta de la Luna Amarilla",
        ["zhTW"] = "黃月之門",
        ["zhCN"] = "金月之门",
    },
    ["Courtyard of the Ancients"] = {
        ["ptBR"] = "Pátio dos Anciãos",
        ["ruRU"] = "Двор Древних",
        ["deDE"] = "Hof der Uralten",
        ["koKR"] = "고대의 안마당",
        ["esMX"] = "Patio de los Ancestros",
        ["enUS"] = true,
        ["frFR"] = "Cour des Anciens",
        ["esES"] = "Patio de los Ancestros",
        ["zhTW"] = "遠祖庭院",
        ["zhCN"] = "远古庭院",
    },
    ["Landing Beach"] = {
        ["ptBR"] = "Praia do Desembarque",
        ["ruRU"] = "Береговая станция",
        ["deDE"] = "Anlandestrand",
        ["koKR"] = "해안 선착장",
        ["esMX"] = "Playa de Desembarco",
        ["enUS"] = true,
        ["frFR"] = "Plage de débarquement",
        ["esES"] = "Playa de Desembarco",
        ["zhTW"] = "起降海灘",
        ["zhCN"] = "登陆海滩",
    },
    ["Dalaran City"] = {
        ["ptBR"] = "Dalaran",
        ["ruRU"] = "Даларан",
        ["deDE"] = "Dalaran",
        ["koKR"] = "달라란",
        ["esMX"] = "Ciudad de Dalaran",
        ["enUS"] = true,
        ["frFR"] = "Dalaran",
        ["esES"] = "Ciudad de Dalaran",
        ["zhTW"] = "達拉然城",
        ["zhCN"] = "达拉然城",
    },
    ["The Violet Citadel Spire"] = {
        ["ptBR"] = "Torre da Cidadela Violeta",
        ["ruRU"] = "Шпиль Аметистовой цитадели",
        ["deDE"] = "Turm der Violetten Zitadelle",
        ["koKR"] = "보랏빛 성채 첨탑",
        ["esMX"] = "Aguja de La Ciudadela Violeta",
        ["enUS"] = true,
        ["frFR"] = "Fléche de la citadelle Pourpre",
        ["esES"] = "Aguja de La Ciudadela Violeta",
        ["zhTW"] = "紫羅蘭城塞尖塔",
        ["zhCN"] = "紫罗兰塔",
    },
    ["Naz'anak: The Forgotten Depths"] = {
        ["ptBR"] = "Naz'anak: As Profundezas Abandonadas",
        ["ruRU"] = "Наз'анак: Забытые глубины",
        ["deDE"] = "Naz'anak: Die Vergessenen Tiefen",
        ["koKR"] = "나즈아낙: 망각의 심연",
        ["esMX"] = "Naz'anak: Las Profundidades Olvidadas",
        ["enUS"] = true,
        ["frFR"] = "Naz'anak : les profondeurs oubliées",
        ["esES"] = "Naz'anak: Las Profundidades Olvidadas",
        ["zhTW"] = "納茲安那克:遺忘深淵",
        ["zhCN"] = "纳扎纳克：遗忘深渊",
    },
    ["Sunreaver's Sanctuary"] = {
        ["ptBR"] = "Santuário Fendessol",
        ["ruRU"] = "Прибежище Похитителя Солнца",
        ["deDE"] = "Sonnenhäschers Zuflucht",
        ["koKR"] = "선리버 성소",
        ["esMX"] = "Santuario Atracasol",
        ["enUS"] = true,
        ["frFR"] = "Sanctuaire de Saccage-soleil",
        ["esES"] = "Santuario Atracasol",
        ["zhTW"] = "奪日者聖堂",
        ["zhCN"] = "夺日者圣殿",
    },
    ["Elevator"] = {
        ["ptBR"] = "Elevador",
        ["ruRU"] = "Подъемник",
        ["deDE"] = "Aufzug",
        ["koKR"] = "승강기",
        ["esMX"] = "Elevador",
        ["enUS"] = true,
        ["frFR"] = "Ascenseur",
        ["esES"] = "Elevador",
        ["zhTW"] = "升降梯",
        ["zhCN"] = "升降梯",
    },
    ["Antonidas Memorial"] = {
        ["ptBR"] = "Memorial a Antônidas",
        ["ruRU"] = "Памятник Антонидасу",
        ["deDE"] = "Antonidas' Denkmal",
        ["koKR"] = "안토니다스 기념지",
        ["esMX"] = "Monumento de Antonidas",
        ["enUS"] = true,
        ["frFR"] = "Monument à Antonidas",
        ["esES"] = "Monumento de Antonidas",
        ["zhTW"] = "安東尼達斯紀念碑",
        ["zhCN"] = "安东尼达斯纪念碑",
    },
    ["The Violet Citadel"] = {
        ["ptBR"] = "A Cidadela Violeta",
        ["ruRU"] = "Аметистовая цитадель",
        ["deDE"] = "Die Violette Zitadelle",
        ["koKR"] = "보랏빛 성채",
        ["esMX"] = "La Ciudadela Violeta",
        ["enUS"] = true,
        ["frFR"] = "Citadelle Pourpre",
        ["esES"] = "La Ciudadela Violeta",
        ["zhTW"] = "紫羅蘭城塞",
        ["zhCN"] = "紫罗兰城堡",
    },
    ["Magus Commerce Exchange"] = {
        ["ptBR"] = "Área Comercial Magus",
        ["ruRU"] = "Торговая палата волшебников",
        ["deDE"] = "Handelsmarkt der Magier",
        ["koKR"] = "마법사 교역소",
        ["esMX"] = "Mercado de Magos",
        ["enUS"] = true,
        ["frFR"] = "La halle des mages",
        ["esES"] = "Mercado de Magos",
        ["zhTW"] = "魔導師貿易區",
        ["zhCN"] = "魔法商业区",
    },
    ["UNUSED"] = {
        ["ptBR"] = "UNUSED",
        ["ruRU"] = "UNUSED",
        ["deDE"] = "Unbenutzt",
        ["koKR"] = "미사용",
        ["esMX"] = "UNUSED",
        ["enUS"] = true,
        ["frFR"] = "INUTILISÉ",
        ["esES"] = "UNUSED",
        ["zhTW"] = "UNUSED",
        ["zhCN"] = "UNUSED",
    },
    ["First Legion Forward Camp"] = {
        ["ptBR"] = "Acampamento Avançado da Primeira Legião",
        ["ruRU"] = "Лагерь сопротивления первого легиона",
        ["deDE"] = "Vorhutslager der Ersten Legion",
        ["koKR"] = "1군단 전진기지",
        ["esMX"] = "Puesto de Avanzada de la Primera Legión",
        ["enUS"] = true,
        ["frFR"] = "Camp avancé de la Première légion",
        ["esES"] = "Puesto de Avanzada de la Primera Legión",
        ["zhTW"] = "第一軍團前進營地",
        ["zhCN"] = "第一军团前线营地",
    },
    ["Hall of the Conquered Kings"] = {
        ["ptBR"] = "Salão dos Reis Derrotados",
        ["ruRU"] = "Зал побежденных королей",
        ["deDE"] = "Halle der bezwungenen Könige",
        ["koKR"] = "정복당한 왕들의 전당",
        ["esMX"] = "Cámara de los Reyes Conquistados",
        ["enUS"] = true,
        ["frFR"] = "Salle des Rois conquis",
        ["esES"] = "Cámara de los Reyes Conquistados",
        ["zhTW"] = "征服諸王大廳",
        ["zhCN"] = "败降王者之厅",
    },
    ["Befouled Terrace"] = {
        ["ptBR"] = "Terraço Conspurcado",
        ["ruRU"] = "Опоганенная терраса",
        ["deDE"] = "Besudelte Terrasse",
        ["koKR"] = "더럽혀진 단상",
        ["esMX"] = "Bancal Infecto",
        ["enUS"] = true,
        ["frFR"] = "Terrasse Souillée",
        ["esES"] = "Bancal Infecto",
        ["zhTW"] = "玷污殿堂",
        ["zhCN"] = "被玷污的平台",
    },
    ["The Desecrated Altar"] = {
        ["ptBR"] = "Altar Profanado",
        ["ruRU"] = "Оскверненный алтарь",
        ["deDE"] = "Der entweihte Altar",
        ["koKR"] = "모독의 제단",
        ["esMX"] = "El Altar Profanado",
        ["enUS"] = true,
        ["frFR"] = "L'autel désacralisé",
        ["esES"] = "El Altar Profanado",
        ["zhTW"] = "褻瀆祭壇",
        ["zhCN"] = "被亵渎的祭坛",
    },
    ["Shimmering Bog"] = {
        ["ptBR"] = "Brejo Cintilante",
        ["ruRU"] = "Мерцающая топь",
        ["deDE"] = "Schimmersumpf",
        ["koKR"] = "미명의 수렁",
        ["esMX"] = "Ciénaga Bruñida",
        ["enUS"] = true,
        ["frFR"] = "La tourbière Chatoyante",
        ["esES"] = "Ciénaga Bruñida",
        ["zhTW"] = "幻光泥沼",
        ["zhCN"] = "闪光泥沼",
    },
    ["Fallen Temple of Ahn'kahet"] = {
        ["ptBR"] = "Templo de Ahn'kahet",
        ["ruRU"] = "Павший храм Ан'кахета",
        ["deDE"] = "Der gefallene Tempel Ahn'kahet",
        ["koKR"] = "무너진 안카헤트 신전",
        ["esMX"] = "Templo Caído de Ahn'kahet",
        ["enUS"] = true,
        ["frFR"] = "Temple déchu d'Ahn'kahet",
        ["esES"] = "Templo Caído de Ahn'kahet",
        ["zhTW"] = "安卡罕特墮落神殿",
        ["zhCN"] = "坍塌的安卡赫特神殿",
    },
    ["Halls of Binding"] = {
        ["ptBR"] = "Salões do Confinamento",
        ["ruRU"] = "Залы Оков",
        ["deDE"] = "Hallen der Bindung",
        ["koKR"] = "구속의 전당",
        ["esMX"] = "Sala de Vínculos",
        ["enUS"] = true,
        ["frFR"] = "Salles de lien",
        ["esES"] = "Sala de Vínculos",
        ["zhTW"] = "束縛大廳",
        ["zhCN"] = "束缚大厅",
    },
    ["Winter's Heart"] = {
        ["ptBR"] = "Coração do Inverno",
        ["ruRU"] = "Сердце зимы",
        ["deDE"] = "Winterherz",
        ["koKR"] = "겨울의 심장",
        ["esMX"] = "Corazón del Invierno",
        ["enUS"] = true,
        ["frFR"] = "Cœur de l'hiver",
        ["esES"] = "Corazón del Invierno",
        ["zhTW"] = "寒冬之心",
        ["zhCN"] = "寒冬之心",
    },
    ["The North Sea"] = {
        ["ptBR"] = "Mar do Norte",
        ["ruRU"] = "Северное море",
        ["deDE"] = "Das Nordmeer",
        ["koKR"] = "북해",
        ["esMX"] = "El Mar del Norte",
        ["enUS"] = true,
        ["frFR"] = "La mer Boréale",
        ["esES"] = "El Mar del Norte",
        ["zhTW"] = "北海",
        ["zhCN"] = "北海",
    },
    ["The Broodmother's Nest"] = {
        ["ptBR"] = "Ninho da Prolemadre",
        ["ruRU"] = "Гнездо праматери",
        ["deDE"] = "Das Nest der Brutmutter",
        ["koKR"] = "여왕 둥지",
        ["esMX"] = "El Nido de la Madre de Linaje",
        ["enUS"] = true,
        ["frFR"] = "Le nid de la mère des couvées",
        ["esES"] = "El Nido de la Madre de Linaje",
        ["zhTW"] = "育母之巢",
        ["zhCN"] = "母龙之巢",
    },
    ["Dalaran Floating Rocks"] = {
        ["ptBR"] = "Pedras Flutuantes de Dalaran",
        ["ruRU"] = "Даларанские парящие камни",
        ["deDE"] = "Fliegende Felsen von Dalaran",
        ["koKR"] = "떠다니는 바위",
        ["esMX"] = "Rocas Flotantes de Dalaran",
        ["enUS"] = true,
        ["frFR"] = "Rochers flottants de Dalaran",
        ["esES"] = "Rocas Flotantes de Dalaran",
        ["zhTW"] = "達拉然漂浮岩",
        ["zhCN"] = "达拉然浮石",
    },
    ["Raptor Pens"] = {
        ["ptBR"] = "Redil dos Raptores",
        ["ruRU"] = "Ямы ящеров",
        ["deDE"] = "Raptorenställe",
        ["koKR"] = "랩터 우리",
        ["esMX"] = "Cercado de Raptores",
        ["enUS"] = true,
        ["frFR"] = "Enclos à raptors",
        ["esES"] = "Cercado de Raptores",
        ["zhTW"] = "迅猛龍圍欄",
        ["zhCN"] = "迅猛龙围栏",
    },
    ["The Noxious Pass"] = {
        ["ptBR"] = "Estrada Nociva",
        ["ruRU"] = "Гибельный путь",
        ["deDE"] = "Der Giftpass",
        ["koKR"] = "맹독의 길",
        ["esMX"] = "El Paso Ponzoñoso",
        ["enUS"] = true,
        ["frFR"] = "La passe Nocive",
        ["esES"] = "El Paso Ponzoñoso",
        ["zhTW"] = "腐毒小徑",
        ["zhCN"] = "剧毒小径",
    },
    ["Vargoth's Retreat"] = {
        ["ptBR"] = "Retiro de Vargoth",
        ["ruRU"] = "Укрытие Варгота",
        ["deDE"] = "Erzmagier Vargoths Rückzugsort",
        ["koKR"] = "바르고스의 은거지",
        ["esMX"] = "Reposo de Vargoth",
        ["enUS"] = true,
        ["frFR"] = "Retraite de Vargoth",
        ["esES"] = "Reposo de Vargoth",
        ["zhTW"] = "瓦戈斯居所",
        ["zhCN"] = "瓦格斯的居所",
    },
    ["Violet Citadel Balcony"] = {
        ["ptBR"] = "Varanda da Cidadela Violeta",
        ["ruRU"] = "Балкон Аметистовой цитадели",
        ["deDE"] = "Balkon der Violetten Zitadelle",
        ["koKR"] = "보랏빛 성채 발코니",
        ["esMX"] = "Balcón de la Ciudadela Violeta",
        ["enUS"] = true,
        ["frFR"] = "Balcon de la citadelle Pourpre",
        ["esES"] = "Balcón de la Ciudadela Violeta",
        ["zhTW"] = "紫羅蘭城塞露台",
        ["zhCN"] = "紫罗兰城堡阳台",
    },
    ["Band of Variance"] = {
        ["ptBR"] = "Faixa de Alternância",
        ["ruRU"] = "Кольцо отклонения",
        ["deDE"] = "Ring der Varianz",
        ["koKR"] = "변화의 고리",
        ["esMX"] = "Anillo de Discrepancia",
        ["enUS"] = true,
        ["frFR"] = "Bague de variance",
        ["esES"] = "Anillo de Discrepancia",
        ["zhTW"] = "變化之環",
        ["zhCN"] = "突变之环",
    },
    ["Band of Acceleration"] = {
        ["ptBR"] = "Faixa de Aceleração",
        ["ruRU"] = "Кольцо ускорения",
        ["deDE"] = "Ring der Akzeleration",
        ["koKR"] = "가속의 고리",
        ["esMX"] = "Anillo de Aceleración",
        ["enUS"] = true,
        ["frFR"] = "Bague d'accélération",
        ["esES"] = "Anillo de Aceleración",
        ["zhTW"] = "加速之環",
        ["zhCN"] = "加速之环",
    },
    ["Band of Transmutation"] = {
        ["ptBR"] = "Faixa de Transmutação",
        ["ruRU"] = "Кольцо трансмутации",
        ["deDE"] = "Ring der Transmutation",
        ["koKR"] = "변환의 고리",
        ["esMX"] = "Anillo de Transmutación",
        ["enUS"] = true,
        ["frFR"] = "Bague de transmutation",
        ["esES"] = "Anillo de Transmutación",
        ["zhTW"] = "轉化之環",
        ["zhCN"] = "转化之环",
    },
    ["Band of Alignment"] = {
        ["ptBR"] = "Faixa de Alinhamento",
        ["ruRU"] = "Кольцо управления",
        ["deDE"] = "Ring der Abgleichung",
        ["koKR"] = "정렬의 고리",
        ["esMX"] = "Anillo de Alineación",
        ["enUS"] = true,
        ["frFR"] = "Bague d'alignement",
        ["esES"] = "Anillo de Alineación",
        ["zhTW"] = "化合之環",
        ["zhCN"] = "校准之环",
    },
    ["Ashwood Lake"] = {
        ["ptBR"] = "Lago Freixo",
        ["ruRU"] = "Ясеневое озеро",
        ["deDE"] = "Eschenholzsee",
        ["koKR"] = "잿빛나무 호수",
        ["esMX"] = "Lago Fresno",
        ["enUS"] = true,
        ["frFR"] = "Lac du Frêne",
        ["esES"] = "Lago Fresno",
        ["zhTW"] = "灰木湖",
        ["zhCN"] = "灰木湖",
    },
    ["Iron Concourse"] = {
        ["ptBR"] = "Junção de Ferro",
        ["ruRU"] = "Железный двор",
        ["deDE"] = "Der Eisenstau",
        ["koKR"] = "무쇠 대열 광장",
        ["esMX"] = "Explanada de Hierro",
        ["enUS"] = true,
        ["frFR"] = "Corridor de Fer",
        ["esES"] = "Explanada de Hierro",
        ["zhTW"] = "鐵之集合場",
        ["zhCN"] = "钢铁广场",
    },
    ["Formation Grounds"] = {
        ["ptBR"] = "Campos de Formação",
        ["ruRU"] = "Плац",
        ["deDE"] = "Gestaltungsgelände",
        ["koKR"] = "전투대형 훈련장",
        ["esMX"] = "Campo de Formación",
        ["enUS"] = true,
        ["frFR"] = "Champ d'entraînement",
        ["esES"] = "Campo de Formación",
        ["zhTW"] = "構築之地",
        ["zhCN"] = "练兵场",
    },
    ["Razorscale's Aerie"] = {
        ["ptBR"] = "Refúgio da Navalhada",
        ["ruRU"] = "Гнездо Острокрылой",
        ["deDE"] = "Klingenschuppes Kanzel",
        ["koKR"] = "칼날비늘의 둥지",
        ["esMX"] = "Nidal de Tajoescama",
        ["enUS"] = true,
        ["frFR"] = "Nichoir de Tranchécaille",
        ["esES"] = "Nidal de Tajoescama",
        ["zhTW"] = "銳鱗之巢",
        ["zhCN"] = "锋鳞之巢",
    },
    ["The Colossal Forge"] = {
        ["ptBR"] = "Forja Colossal",
        ["ruRU"] = "Гигантская кузня",
        ["deDE"] = "Die Kolossale Schmiede",
        ["koKR"] = "거대 제련실",
        ["esMX"] = "La Forja Colosal",
        ["enUS"] = true,
        ["frFR"] = "La Forge colossale",
        ["esES"] = "La Forja Colosal",
        ["zhTW"] = "巨熔爐",
        ["zhCN"] = "巨人熔炉",
    },
    ["The Scrapyard"] = {
        ["ptBR"] = "O Ferro Velho",
        ["ruRU"] = "Мусорная свалка",
        ["deDE"] = "Der Schrottplatz",
        ["koKR"] = "고철 야적장",
        ["esMX"] = "La Chatarrería",
        ["enUS"] = true,
        ["frFR"] = "La Ferraillerie",
        ["esES"] = "La Chatarrería",
        ["zhTW"] = "廢料場",
        ["zhCN"] = "废料场",
    },
    ["The Conservatory of Life"] = {
        ["ptBR"] = "Reserva Biológica",
        ["ruRU"] = "Оранжерея Жизни",
        ["deDE"] = "Das Konservatorium des Lebens",
        ["koKR"] = "생명의 정원",
        ["esMX"] = "El Invernadero de Vida",
        ["enUS"] = true,
        ["frFR"] = "Le jardin de la Vie",
        ["esES"] = "El Invernadero de Vida",
        ["zhTW"] = "生命溫室",
        ["zhCN"] = "生命温室",
    },
    ["The Archivum"] = {
        ["ptBR"] = "Archivum",
        ["ruRU"] = "Архив",
        ["deDE"] = "Das Archivum",
        ["koKR"] = "고대 기록관",
        ["esMX"] = "El Archivum",
        ["enUS"] = true,
        ["frFR"] = "L'Archivum",
        ["esES"] = "El Archivum",
        ["zhTW"] = "大資料庫",
        ["zhCN"] = "档案馆",
    },
    ["Argent Tournament Grounds"] = {
        ["ptBR"] = "Campos do Torneio Argênteo",
        ["ruRU"] = "Ристалище Серебряного турнира",
        ["deDE"] = "Argentumturnierplatz",
        ["koKR"] = "은빛십자군 마상시합 광장",
        ["esMX"] = "Campos del Torneo Argenta",
        ["enUS"] = true,
        ["frFR"] = "Enceinte du tournoi d'Argent",
        ["esES"] = "Campos del Torneo Argenta",
        ["zhTW"] = "銀白聯賽場地",
        ["zhCN"] = "银色比武场",
    },
    ["Tournament"] = {
        ["ptBR"] = "Torneio",
        ["ruRU"] = "Турнир",
        ["deDE"] = "Turnier",
        ["koKR"] = "토너먼트",
        ["esMX"] = "Torneo",
        ["enUS"] = true,
        ["frFR"] = "Tournoi",
        ["esES"] = "Torneo",
        ["zhTW"] = false,
        ["zhCN"] = "比赛",
    },
    ["Expedition Base Camp"] = {
        ["ptBR"] = "Acampamento da Expedição",
        ["ruRU"] = "Главный лагерь экспедиции",
        ["deDE"] = "Basislager der Expedition",
        ["koKR"] = "원정대 기지",
        ["esMX"] = "Campamento Base de la Expedición",
        ["enUS"] = true,
        ["frFR"] = "Camp de base de l'expédition",
        ["esES"] = "Campamento Base de la Expedición",
        ["zhTW"] = "遠征隊營地",
        ["zhCN"] = "远征军营地",
    },
    ["The Cooper Residence"] = {
        ["ptBR"] = "Residência dos Curvelo",
        ["ruRU"] = "Имение Купера",
        ["deDE"] = "Die Cooper-Residenz",
        ["koKR"] = "쿠퍼 저택",
        ["esMX"] = "La Residencia Cooper",
        ["enUS"] = true,
        ["frFR"] = "La résidence des Tonnelier",
        ["esES"] = "La Residencia Cooper",
        ["zhTW"] = "庫珀的住所",
        ["zhCN"] = "桶屋",
    },
    ["The Ring of Champions"] = {
        ["ptBR"] = "Arena dos Campeões",
        ["ruRU"] = "Арена чемпионов",
        ["deDE"] = "Der Ring der Champions",
        ["koKR"] = "용사의 투기장",
        ["esMX"] = "La Liza de los Campeones",
        ["enUS"] = true,
        ["frFR"] = "La lice des champions",
        ["esES"] = "La Liza de los Campeones",
        ["zhTW"] = "勇士競技場",
        ["zhCN"] = "冠军赛场",
    },
    ["The Aspirants' Ring"] = {
        ["ptBR"] = "Arena dos Aspirantes",
        ["ruRU"] = "Арена претендентов",
        ["deDE"] = "Der Ring der Streiter",
        ["koKR"] = "지원자의 투기장",
        ["esMX"] = "La Liza de los Aspirantes",
        ["enUS"] = true,
        ["frFR"] = "La lice des aspirants",
        ["esES"] = "La Liza de los Aspirantes",
        ["zhTW"] = "志士競技場",
        ["zhCN"] = "候选者赛场",
    },
    ["The Argent Valiants' Ring"] = {
        ["ptBR"] = "Arena dos Valentes Argênteos",
        ["ruRU"] = "Арена искателей славы Серебряного Авангарда",
        ["deDE"] = "Der Ring der Recken des Argentumkreuzzugs",
        ["koKR"] = "은빛십자군 용맹전사의 투기장",
        ["esMX"] = "La Liza de los Valerosos Argenta",
        ["enUS"] = true,
        ["frFR"] = "La lice des vaillants d'Argent",
        ["esES"] = "La Liza de los Valerosos Argenta",
        ["zhTW"] = "銀白驍士競技場",
        ["zhCN"] = "银色勇士赛场",
    },
    ["The Alliance Valiants' Ring"] = {
        ["ptBR"] = "Arena dos Valentes da Aliança",
        ["ruRU"] = "Арена искателей славы из Альянса",
        ["deDE"] = "Der Ring der Recken der Allianz",
        ["koKR"] = "얼라이언스 용맹전사의 투기장",
        ["esMX"] = "La Liza de los Valerosos de la Alianza",
        ["enUS"] = true,
        ["frFR"] = "La lice des vaillants de l'Alliance",
        ["esES"] = "La Liza de los Valerosos de la Alianza",
        ["zhTW"] = "聯盟驍士競技場",
        ["zhCN"] = "联盟勇士赛场",
    },
    ["The Horde Valiants' Ring"] = {
        ["ptBR"] = "Arena dos Valentes da Horda",
        ["ruRU"] = "Арена искателей славы из Орды",
        ["deDE"] = "Der Ring der Recken der Horde",
        ["koKR"] = "호드 용맹전사의 투기장",
        ["esMX"] = "La Liza de los Valerosos de la Horda",
        ["enUS"] = true,
        ["frFR"] = "La lice des vaillants de la Horde",
        ["esES"] = "La Liza de los Valerosos de la Horda",
        ["zhTW"] = "部落驍士競技場",
        ["zhCN"] = "部落勇士赛场",
    },
    ["Argent Pavilion"] = {
        ["ptBR"] = "Pavilhão Argênteo",
        ["ruRU"] = "Серебряный павильон",
        ["deDE"] = "Argentumpavillon",
        ["koKR"] = "은빛십자군 막사",
        ["esMX"] = "Pabellón Argenta",
        ["enUS"] = true,
        ["frFR"] = "Pavillon d'Argent",
        ["esES"] = "Pabellón Argenta",
        ["zhTW"] = "銀白亭閣",
        ["zhCN"] = "银色大帐",
    },
    ["Sunreaver Pavilion"] = {
        ["ptBR"] = "Pavilhão Fendessol",
        ["ruRU"] = "Павильон Похитителей Солнца",
        ["deDE"] = "Sonnenhäscherpavillon",
        ["koKR"] = "선리버 막사",
        ["esMX"] = "Pabellón Atracasol",
        ["enUS"] = true,
        ["frFR"] = "Pavillon de Saccage-soleil",
        ["esES"] = "Pabellón Atracasol",
        ["zhTW"] = "奪日者亭閣",
        ["zhCN"] = "夺日者大帐",
    },
    ["Silver Covenant Pavilion"] = {
        ["ptBR"] = "Pavilhão do Pacto de Prata",
        ["ruRU"] = "Павильон Серебряного союза",
        ["deDE"] = "Silberbundpavillon",
        ["koKR"] = "은빛 서약단 막사",
        ["esMX"] = "Pabellón de El Pacto de Plata",
        ["enUS"] = true,
        ["frFR"] = "Pavillon du Concordat argenté",
        ["esES"] = "Pabellón de El Pacto de Plata",
        ["zhTW"] = "白銀誓盟亭閣",
        ["zhCN"] = "银色盟约大帐",
    },
    ["The Forlorn Cavern"] = {
        ["ptBR"] = "Caverna Esquecida",
        ["ruRU"] = "Заброшенный грот",
        ["deDE"] = "Das düstere Viertel",
        ["koKR"] = "쓸쓸한 뒷골목",
        ["esMX"] = "La Caverna Abandonada",
        ["enUS"] = true,
        ["frFR"] = "La Caverne lugubre",
        ["esES"] = "La Caverna Abandonada",
        ["zhTW"] = "荒棄的洞穴",
        ["zhCN"] = "荒弃的洞穴",
    },
    ["claytonio test area"] = {
        ["ptBR"] = "área de teste do clayton",
        ["ruRU"] = "claytonio test area",
        ["deDE"] = "Testgebiet Claytonio",
        ["koKR"] = "클레이토니오 시험 지역",
        ["esMX"] = "claytonio test area",
        ["enUS"] = true,
        ["frFR"] = "claytonio test area",
        ["esES"] = "claytonio test area",
        ["zhTW"] = "claytonio test area",
        ["zhCN"] = "claytonio test area",
    },
    ["Quel'Delar's Rest"] = {
        ["ptBR"] = "Repouso de Quel'Delar",
        ["ruRU"] = "Покой Кель'Делара",
        ["deDE"] = "Quel'Delars Ruh",
        ["koKR"] = "쿠엘델라의 쉼터",
        ["esMX"] = "Reposo de Quel'Delar",
        ["enUS"] = true,
        ["frFR"] = "Repos de Quel'Delar",
        ["esES"] = "Reposo de Quel'Delar",
        ["zhTW"] = "奎爾德拉之眠",
        ["zhCN"] = "奎尔德拉之冢",
    },
    ["Isle of Conquest"] = {
        ["ptBR"] = "Ilha da Conquista",
        ["ruRU"] = "Остров Завоеваний",
        ["deDE"] = "Insel der Eroberung",
        ["koKR"] = "정복의 섬",
        ["esMX"] = "Isla de la Conquista",
        ["enUS"] = true,
        ["frFR"] = "Île des Conquérants",
        ["esES"] = "Isla de la Conquista",
        ["zhTW"] = "征服之島",
        ["zhCN"] = "征服之岛",
    },
    ["Trial of the Crusader"] = {
        ["ptBR"] = "Prova do Cruzado",
        ["ruRU"] = "Испытание крестоносца",
        ["deDE"] = "Prüfung des Kreuzfahrers",
        ["koKR"] = "십자군의 시험장",
        ["esMX"] = "Prueba del Cruzado",
        ["enUS"] = true,
        ["frFR"] = "L'épreuve du croisé",
        ["esES"] = "Prueba del Cruzado",
        ["zhTW"] = "十字軍試煉",
        ["zhCN"] = "十字军的试炼",
    },
    ["Trial of the Champion"] = {
        ["ptBR"] = "Prova do Campeão",
        ["ruRU"] = "Испытание чемпиона",
        ["deDE"] = "Prüfung des Champions",
        ["koKR"] = "용사의 시험장",
        ["esMX"] = "Prueba del Campeón",
        ["enUS"] = true,
        ["frFR"] = "L'épreuve du champion",
        ["esES"] = "Prueba del Campeón",
        ["zhTW"] = "勇士試煉",
        ["zhCN"] = "冠军的试炼",
    },
    ["Runeweaver Square"] = {
        ["ptBR"] = "Praça Fiarruna",
        ["ruRU"] = "Площадь Руноплета",
        ["deDE"] = "Runenweberplatz",
        ["koKR"] = "룬위버 광장",
        ["esMX"] = "Plaza Tejerruna",
        ["enUS"] = true,
        ["frFR"] = "Place Tisserune",
        ["esES"] = "Plaza Tejerruna",
        ["zhTW"] = "織符者廣場",
        ["zhCN"] = "鲁因广场",
    },
    ["The Silver Enclave"] = {
        ["ptBR"] = "Enclave Prateado",
        ["ruRU"] = "Серебряный Союз",
        ["deDE"] = "Die Silberne Enklave",
        ["koKR"] = "은빛 자치구",
        ["esMX"] = "El Enclave de Plata",
        ["enUS"] = true,
        ["frFR"] = "L'enclave Argentée",
        ["esES"] = "El Enclave de Plata",
        ["zhTW"] = "白銀領區",
        ["zhCN"] = "银色领地",
    },
    ["Isle of Conquest No Man's Land"] = {
        ["ptBR"] = "Terra de Ninguém da Ilha da Conquista",
        ["ruRU"] = "Остров Завоеваний нейтральная территория",
        ["deDE"] = "Niemandsland auf der Insel der Eroberung",
        ["koKR"] = "정복의 섬 접근 금지",
        ["esMX"] = "Tierra de Nadie de Isla de la Conquista",
        ["enUS"] = true,
        ["frFR"] = "No man's land de l'île des Conquérants",
        ["esES"] = "Tierra de Nadie de Isla de la Conquista",
        ["zhTW"] = "無人登陸的征服之島",
        ["zhCN"] = "征服之岛（禁区）",
    },
    ["Deathspeaker's Watch"] = {
        ["ptBR"] = "Vigília do Morta-voz",
        ["ruRU"] = "Застава Вестника Смерти",
        ["deDE"] = "Todessprechers Wacht",
        ["koKR"] = "죽음예언자 감시초소",
        ["esMX"] = "Avanzada del Portavoz de la Muerte",
        ["enUS"] = true,
        ["frFR"] = "Le Guet du nécrorateur",
        ["esES"] = "Avanzada del Portavoz de la Muerte",
        ["zhTW"] = "亡頌者之望",
        ["zhCN"] = "亡语者岗哨",
    },
    ["Workshop"] = {
        ["ptBR"] = "Oficina",
        ["ruRU"] = "Мастерская",
        ["deDE"] = "Werkstatt",
        ["koKR"] = "작업장",
        ["esMX"] = "Taller",
        ["enUS"] = true,
        ["frFR"] = "Atelier",
        ["esES"] = "Taller",
        ["zhTW"] = "工坊",
        ["zhCN"] = "车间",
    },
    ["Quarry"] = {
        ["ptBR"] = "Pedreira",
        ["ruRU"] = "Каменоломня",
        ["deDE"] = "Steinbruch",
        ["koKR"] = "채석장",
        ["esMX"] = "Cantera",
        ["enUS"] = true,
        ["frFR"] = "Carrière",
        ["esES"] = "Cantera",
        ["zhTW"] = "礦場",
        ["zhCN"] = "采石场",
    },
    ["Docks"] = {
        ["ptBR"] = "Docas",
        ["ruRU"] = "Причал",
        ["deDE"] = "Docks",
        ["koKR"] = "부두",
        ["esMX"] = "Muelles",
        ["enUS"] = true,
        ["frFR"] = "Docks",
        ["esES"] = "Muelles",
        ["zhTW"] = "碼頭",
        ["zhCN"] = "码头",
    },
    ["Hangar"] = {
        ["ptBR"] = "Hangar",
        ["ruRU"] = "Ангар",
        ["deDE"] = "Hangar",
        ["koKR"] = "격납고",
        ["esMX"] = "Hangar",
        ["enUS"] = true,
        ["frFR"] = "Hangar",
        ["esES"] = "Hangar",
        ["zhTW"] = "機棚",
        ["zhCN"] = "飞艇基地",
    },
    ["Refinery"] = {
        ["ptBR"] = "Refinaria",
        ["ruRU"] = "Нефтезавод",
        ["deDE"] = "Raffinerie",
        ["koKR"] = "정제소",
        ["esMX"] = "Refinería",
        ["enUS"] = true,
        ["frFR"] = "Raffinerie",
        ["esES"] = "Refinería",
        ["zhTW"] = "精煉廠",
        ["zhCN"] = "油料精炼厂",
    },
    ["Horde Keep"] = {
        ["ptBR"] = "Bastilha da Horda",
        ["ruRU"] = "Крепость Орды",
        ["deDE"] = "Hordenfestung",
        ["koKR"] = "호드 요새",
        ["esMX"] = "Fortaleza de la Horda",
        ["enUS"] = true,
        ["frFR"] = "Donjon de la Horde",
        ["esES"] = "Fortaleza de la Horda",
        ["zhTW"] = "部落要塞",
        ["zhCN"] = "部落要塞",
    },
    ["Alliance Keep"] = {
        ["ptBR"] = "Bastilha da Aliança",
        ["ruRU"] = "Крепость Альянса",
        ["deDE"] = "Allianzfestung",
        ["koKR"] = "얼라이언스 요새",
        ["esMX"] = "Fortaleza de la Alianza",
        ["enUS"] = true,
        ["frFR"] = "Donjon de l'Alliance",
        ["esES"] = "Fortaleza de la Alianza",
        ["zhTW"] = "聯盟要塞",
        ["zhCN"] = "联盟要塞",
    },
    ["The Sea Reaver's Run"] = {
        ["ptBR"] = "Estreito do Aniquilador Marítimo",
        ["ruRU"] = "Пролив Грозы Морей",
        ["deDE"] = "Die Straße der Meerhäscher",
        ["koKR"] = "바다 학살자의 터",
        ["esMX"] = "La Travesía del Atracamar",
        ["enUS"] = true,
        ["frFR"] = "Le trajet du Saccageur des mers",
        ["esES"] = "La Travesía del Atracamar",
        ["zhTW"] = "海劫者航道",
        ["zhCN"] = "破海者航道",
    },
    ["Transport: Alliance Gunship"] = {
        ["ptBR"] = "Transporte: Belonave da Aliança",
        ["ruRU"] = "Транспорт: Боевой корабль Альянса",
        ["deDE"] = "Transport: Kanonenboot der Allianz",
        ["koKR"] = "수송: 얼라이언스 비행포격선",
        ["esMX"] = "Transporte: Nave de Guerra de la Alianza",
        ["enUS"] = true,
        ["frFR"] = "Transport : canonnière de l'Alliance",
        ["esES"] = "Transporte: Nave de Guerra de la Alianza",
        ["zhTW"] = "傳送:聯盟砲艇",
        ["zhCN"] = "交通工具：联盟炮艇",
    },
    ["Transport: Horde Gunship"] = {
        ["ptBR"] = "Transporte: Belonave da Horda",
        ["ruRU"] = "Транспорт: Боевой корабль Орды",
        ["deDE"] = "Transport: Kanonenboot der Horde",
        ["koKR"] = "수송: 호드 비행포격선",
        ["esMX"] = "Transporte: Nave de Guerra de la Horda",
        ["enUS"] = true,
        ["frFR"] = "Transport : canonnière de la Horde",
        ["esES"] = "Transporte: Nave de Guerra de la Horda",
        ["zhTW"] = "傳送:部落砲艇",
        ["zhCN"] = "交通工具：部落炮艇",
    },
    ["Hrothgar's Landing"] = {
        ["ptBR"] = "Porto de Hrothgar",
        ["ruRU"] = "Лагерь Хротгара",
        ["deDE"] = "Hrothgars Landestelle",
        ["koKR"] = "흐로스가르 상륙지",
        ["esMX"] = "Desembarco de Hrothgar",
        ["enUS"] = true,
        ["frFR"] = "Accostage de Hrothgar",
        ["esES"] = "Desembarco de Hrothgar",
        ["zhTW"] = "赫魯斯加臺地",
        ["zhCN"] = "洛斯加尔登陆点",
    },
    ["The Forge of Souls"] = {
        ["ptBR"] = "Forja das Almas",
        ["ruRU"] = "Кузня Душ",
        ["deDE"] = "Die Seelenschmiede",
        ["koKR"] = "영혼의 제련소",
        ["esMX"] = "La Forja de Almas",
        ["enUS"] = true,
        ["frFR"] = "La Forge des âmes",
        ["esES"] = "La Forja de Almas",
        ["zhTW"] = "眾魂熔爐",
        ["zhCN"] = "灵魂洪炉",
    },
    ["Pit of Saron"] = {
        ["ptBR"] = "Fosso de Saron",
        ["ruRU"] = "Яма Сарона",
        ["deDE"] = "Grube von Saron",
        ["koKR"] = "사론의 구덩이",
        ["esMX"] = "Foso de Saron",
        ["enUS"] = true,
        ["frFR"] = "Fosse de Saron",
        ["esES"] = "Foso de Saron",
        ["zhTW"] = "薩倫之淵",
        ["zhCN"] = "萨隆矿坑",
    },
    ["Halls of Reflection"] = {
        ["ptBR"] = "Salões da Reflexão",
        ["ruRU"] = "Залы Отражений",
        ["deDE"] = "Hallen der Reflexion",
        ["koKR"] = "투영의 전당",
        ["esMX"] = "Cámaras de Reflexión",
        ["enUS"] = true,
        ["frFR"] = "Salles des Reflets",
        ["esES"] = "Cámaras de Reflexión",
        ["zhTW"] = "倒影大廳",
        ["zhCN"] = "映像大厅",
    },
    ["Transport: Alliance Gunship (IGB)"] = {
        ["ptBR"] = "Transporte: Belonave da Aliança (IGB)",
        ["ruRU"] = "Транспорт: боевой корабль Альянса (IGB)",
        ["deDE"] = "Transport: Kanonenschiff der Allianz (IGB)",
        ["koKR"] = "수송: 얼라이언스 비행포격선",
        ["esMX"] = "Transporte: Nave de Guerra de la Alianza",
        ["enUS"] = true,
        ["frFR"] = "Transport: canonnière de l'Alliance (IGB)",
        ["esES"] = "Transporte: Nave de Guerra de la Alianza",
        ["zhTW"] = "傳送:聯盟砲艇(IGB)",
        ["zhCN"] = "Transport: Alliance Gunship (IGB)",
    },
    ["Transport: Horde Gunship (IGB)"] = {
        ["ptBR"] = "Transporte: Belonave da Horda (IGB)",
        ["ruRU"] = "Транспорт: боевой корабль Орды (IGB)",
        ["deDE"] = "Transport: Kanonenschiff der Horde (IGB)",
        ["koKR"] = "수송: 호드 비행포격선",
        ["esMX"] = "Transporte: Nave de Guerra de la Horda",
        ["enUS"] = true,
        ["frFR"] = "Transport : canonnière de la Horde(IGB)",
        ["esES"] = "Transporte: Nave de Guerra de la Horda",
        ["zhTW"] = "傳送:部落砲艇(IGB)",
        ["zhCN"] = "Transport: Horde Gunship (IGB)",
    },
    ["The Frost Queen's Lair"] = {
        ["ptBR"] = "Covil da Rainha Gélida",
        ["ruRU"] = "Логово Королевы Льда",
        ["deDE"] = "Der Hort der Frostkönigin",
        ["koKR"] = "서리 여왕의 둥지",
        ["esMX"] = "La Guarida de la Reina de Escarcha",
        ["enUS"] = true,
        ["frFR"] = "Le repaire de la reine du Givre",
        ["esES"] = "La Guarida de la Reina de Escarcha",
        ["zhTW"] = "冰霜之后的巢穴",
        ["zhCN"] = "冰霜女王的巢穴",
    },
    ["Putricide's Laboratory of Alchemical Horrors and Fun"] = {
        ["ptBR"] = "Laboratório de Horrores e Diversões Alquímicas do Putricídio",
        ["ruRU"] = "Лаборатория алхимических ужасов и забав",
        ["deDE"] = "Seuchenmords Laboratorium der alchemistischen Schrecken und Späße",
        ["koKR"] = "공포와 재미가 넘치는 퓨트리사이드의 연금술 실험실",
        ["esMX"] = "Laboratorio Horrores y Risas Alquímicas de Putricidio",
        ["enUS"] = true,
        ["frFR"] = "Laboratoire des désopilantes atrocités alchimiques de Putricide",
        ["esES"] = "Laboratorio Horrores y Risas Alquímicas de Putricidio",
        ["zhTW"] = "普崔希德的恐懼與歡樂鍊金實驗室",
        ["zhCN"] = "普崔赛德的恐怖和娱乐化学实验室",
    },
    ["The Crimson Hall"] = {
        ["ptBR"] = "Salão Carmesim",
        ["ruRU"] = "Багровый зал",
        ["deDE"] = "Die Blutrote Halle",
        ["koKR"] = "진홍빛 전당",
        ["esMX"] = "La Sala Carmesí",
        ["enUS"] = true,
        ["frFR"] = "La salle Cramoisie",
        ["esES"] = "La Sala Carmesí",
        ["zhTW"] = "赤紅大廳",
        ["zhCN"] = "血色厅堂",
    },
    ["The Frozen Throne"] = {
        ["ptBR"] = "O Trono de Gelo",
        ["ruRU"] = "Ледяной Трон",
        ["deDE"] = "Der Frostthron",
        ["koKR"] = "얼어붙은 왕좌",
        ["esMX"] = "El Trono Helado",
        ["enUS"] = true,
        ["frFR"] = "Le Trône de glace",
        ["esES"] = "El Trono Helado",
        ["zhTW"] = "冰封王座",
        ["zhCN"] = "冰封王座",
    },
    ["The Sanctum of Blood"] = {
        ["ptBR"] = "Sacrário de Sangue",
        ["ruRU"] = "Святилище Крови",
        ["deDE"] = "Das Sanktum des Blutes",
        ["koKR"] = "피의 성소",
        ["esMX"] = "El Sagrario de Sangre",
        ["enUS"] = true,
        ["frFR"] = "Le sanctum de Sang",
        ["esES"] = "El Sagrario de Sangre",
        ["zhTW"] = "血之聖所",
        ["zhCN"] = "鲜血秘室",
    },
    ["The Dark Approach"] = {
        ["ptBR"] = "Entrada Negra",
        ["ruRU"] = "Темный Подступ",
        ["deDE"] = "Der dunkle Zugang",
        ["koKR"] = "어둠의 진입로",
        ["esMX"] = "El Trayecto Oscuro",
        ["enUS"] = true,
        ["frFR"] = "La Sombre marche",
        ["esES"] = "El Trayecto Oscuro",
        ["zhTW"] = "黑暗路徑",
        ["zhCN"] = "黑暗小径",
    },
    ["Scourgelord's Command"] = {
        ["ptBR"] = "Comando do Senhor do Flagelo",
        ["ruRU"] = "Смотровая площадка",
        ["deDE"] = "Order des Geißelfürsten",
        ["koKR"] = "스컬지군주의 지휘소",
        ["esMX"] = "Dominio del Señor de la Plaga",
        ["enUS"] = true,
        ["frFR"] = "Quartier général du seigneur du Fléau",
        ["esES"] = "Dominio del Señor de la Plaga",
        ["zhTW"] = "天譴領主指揮所",
        ["zhCN"] = "天灾领主的指挥站",
    },
    ["The Shadow Throne"] = {
        ["ptBR"] = "O Trono das Sombras",
        ["ruRU"] = "Темный трон",
        ["deDE"] = "Der Schattenthron",
        ["koKR"] = "어둠의 왕좌",
        ["esMX"] = "El Trono de las Sombras",
        ["enUS"] = true,
        ["frFR"] = "Le trône des Ombres",
        ["esES"] = "El Trono de las Sombras",
        ["zhTW"] = "暗影王座",
        ["zhCN"] = "暗影王座",
    },
    ["The Hidden Passage"] = {
        ["ptBR"] = "Passagem Secreta",
        ["ruRU"] = "Потайной ход",
        ["deDE"] = "Die versteckte Passage",
        ["koKR"] = "숨겨진 통로",
        ["esMX"] = "El Pasaje Oculto",
        ["enUS"] = true,
        ["frFR"] = "Le passage secret",
        ["esES"] = "El Pasaje Oculto",
        ["zhTW"] = "隱藏通道",
        ["zhCN"] = "隐秘小径",
    },
    ["Frostmourne"] = {
        ["ptBR"] = "Gélido Lamento",
        ["ruRU"] = "Ледяная Скорбь",
        ["deDE"] = "Frostgram",
        ["koKR"] = "서리한",
        ["esMX"] = "Agonía de Escarcha",
        ["enUS"] = true,
        ["frFR"] = "Deuillegivre",
        ["esES"] = "Agonía de Escarcha",
        ["zhTW"] = "霜之哀傷",
        ["zhCN"] = "霜之哀伤",
    },
    ["The Ruby Sanctum"] = {
        ["ptBR"] = "Santuário Rubi",
        ["ruRU"] = "Рубиновое святилище",
        ["deDE"] = "Das Rubinsanktum",
        ["koKR"] = "루비 성소",
        ["esMX"] = "El Sagrario Rubí",
        ["enUS"] = true,
        ["frFR"] = "Le sanctum Rubis",
        ["esES"] = "El Sagrario Rubí",
        ["zhTW"] = "晶紅聖所",
        ["zhCN"] = "红玉圣殿",
    },
    ["Borean Tundra"] = {
        ["ptBR"] = "Tundra Boreana",
        ["ruRU"] = "Борейская тундра",
        ["deDE"] = "Die Boreanische Tundra",
        ["koKR"] = "북풍의 땅",
        ["esMX"] = "Tundra Boreal",
        ["enUS"] = true,
        ["frFR"] = "Toundra Boréenne",
        ["esES"] = "Tundra Boreal",
        ["zhTW"] = "北風凍原",
        ["zhCN"] = "北风苔原",
    },
    ["Icecrown"] = {
        ["ptBR"] = "Coroa de Gelo",
        ["ruRU"] = "Ледяная Корона",
        ["deDE"] = "Eiskrone",
        ["koKR"] = "얼음왕관",
        ["esMX"] = "Corona de Hielo",
        ["enUS"] = true,
        ["frFR"] = "Couronne de glace",
        ["esES"] = "Corona de Hielo",
        ["zhTW"] = "寒冰皇冠",
        ["zhCN"] = "冰冠冰川",
    },
    ["Sholazar Basin"] = {
        ["ptBR"] = "Bacia Sholazar",
        ["ruRU"] = "Низина Шолазар",
        ["deDE"] = "Das Sholazarbecken",
        ["koKR"] = "숄라자르 분지",
        ["esMX"] = "Cuenca de Sholazar",
        ["enUS"] = true,
        ["frFR"] = "Bassin de Sholazar",
        ["esES"] = "Cuenca de Sholazar",
        ["zhTW"] = "休拉薩盆地",
        ["zhCN"] = "索拉查盆地",
    },
    ["Dragonblight"] = {
        ["ptBR"] = "Praga Dragônica",
        ["ruRU"] = "Драконий Погост",
        ["deDE"] = "Die Drachenöde",
        ["koKR"] = "용의 안식처",
        ["esMX"] = "Cementerio de Dragones",
        ["enUS"] = true,
        ["frFR"] = "Désolation des dragons",
        ["esES"] = "Cementerio de Dragones",
        ["zhTW"] = "龍骨荒野",
        ["zhCN"] = "龙骨荒野",
    },
    ["Battle for Wintergrasp"] = {
        ["ptBR"] = "Batalha por Invérnia",
        ["ruRU"] = "Битва за озеро Ледяных Оков",
        ["deDE"] = "Die Schlacht um Tausendwinter",
        ["koKR"] = "격전의 겨울손아귀",
        ["esMX"] = "Batalla por Conquista del Invierno",
        ["enUS"] = true,
        ["frFR"] = "Bataille de Joug-d’hiver",
        ["esES"] = "Batalla por Conquista del Invierno",
        ["zhTW"] = "冬握湖戰鬥",
        ["zhCN"] = "冬拥湖之战",
    },
    ["Westspark Workshop"] = {
        ["ptBR"] = "Oficina do Parque Oeste",
        ["ruRU"] = "Мастерская Западной Искры",
        ["deDE"] = "Die Werkstatt Westfunk",
        ["koKR"] = "서부불꽃 작업장",
        ["esMX"] = "Taller Chispa Occidental",
        ["enUS"] = true,
        ["frFR"] = "Atelier de l’Ouestincelle",
        ["esES"] = "Taller Chispa Occidental",
        ["zhTW"] = "西炫工坊",
        ["zhCN"] = "西部火花车间",
    },
    ["The Steppe of Life"] = {
        ["ptBR"] = "Estepe da Vida",
        ["ruRU"] = "Степь Жизни",
        ["deDE"] = "Die Lebendige Steppe",
        ["koKR"] = "생명의 평원",
        ["esMX"] = "Las Estepas de la Vida",
        ["enUS"] = true,
        ["frFR"] = "Steppes de la Vie",
        ["esES"] = "Las Estepas de la Vida",
        ["zhTW"] = "生命冷原",
        ["zhCN"] = "生命草原",
    },
    ["Eastspark Workshop"] = {
        ["ptBR"] = "Oficina do Parque Leste",
        ["ruRU"] = "Мастерская Восточной Искры",
        ["deDE"] = "Die Werkstatt Ostfunk",
        ["koKR"] = "동부불꽃 작업장",
        ["esMX"] = "Taller Chispa Oriental",
        ["enUS"] = true,
        ["frFR"] = "Atelier de l’Estincelle",
        ["esES"] = "Taller Chispa Oriental",
        ["zhTW"] = "東炫工坊",
        ["zhCN"] = "东部火花车间",
    },
    ["The Chilled Quagmire"] = {
        ["ptBR"] = "Atoleiro Gelado",
        ["ruRU"] = "Холодная трясина",
        ["deDE"] = "Der Kühle Sumpf",
        ["koKR"] = "얼어붙은 수렁",
        ["esMX"] = "El Cenagal Escalofrío",
        ["enUS"] = true,
        ["frFR"] = "Bourbier Glacial",
        ["esES"] = "El Cenagal Escalofrío",
        ["zhTW"] = "寒冽泥淖",
        ["zhCN"] = "冰冷湿地",
    },
    ["The Forest of Shadows"] = {
        ["ptBR"] = "Floresta das Sombras",
        ["ruRU"] = "Лес Теней",
        ["deDE"] = "Der Schattenwald",
        ["koKR"] = "그늘진 수풀",
        ["esMX"] = "El Bosque de las Sombras",
        ["enUS"] = true,
        ["frFR"] = "Forêt des Ombres",
        ["esES"] = "El Bosque de las Sombras",
        ["zhTW"] = "暗影森林",
        ["zhCN"] = "阴影森林",
    },
    ["Glacial Falls"] = {
        ["ptBR"] = "Cachoeira Glacial",
        ["ruRU"] = "Ледопады",
        ["deDE"] = "Die Eiswasserfälle",
        ["koKR"] = "빙하 폭포",
        ["esMX"] = "Cascadas Glaciales",
        ["enUS"] = true,
        ["frFR"] = "Chutes Glaciales",
        ["esES"] = "Cascadas Glaciales",
        ["zhTW"] = "冰川瀑布",
        ["zhCN"] = "冰川瀑布",
    },
    ["The Cauldron of Flames"] = {
        ["ptBR"] = "Caldeirão das Chamas",
        ["ruRU"] = "Огненная котловина",
        ["deDE"] = "Der Flammenkessel",
        ["koKR"] = "불길의 가마솥",
        ["esMX"] = "El Caldero de Llamas",
        ["enUS"] = true,
        ["frFR"] = "Chaudron des flammes",
        ["esES"] = "El Caldero de Llamas",
        ["zhTW"] = "火焰熔爐",
        ["zhCN"] = "烈焰之坑",
    },
    ["Winter's Edge Tower"] = {
        ["ptBR"] = "Torre da Borda Invernal",
        ["ruRU"] = "Башня Клинка Зимы",
        ["deDE"] = "Der Wintersturzturm",
        ["koKR"] = "겨울 칼날 경비탑",
        ["esMX"] = "Torre Filoinvierno",
        ["enUS"] = true,
        ["frFR"] = "Tour Bornehiver",
        ["esES"] = "Torre Filoinvierno",
        ["zhTW"] = "冬際哨塔",
        ["zhCN"] = "冬缘塔楼",
    },
    ["Flamewatch Tower"] = {
        ["ptBR"] = "Torre da Guarda Ígnea",
        ["ruRU"] = "Башня Огненного Дозора",
        ["deDE"] = "Der Flammenaugenturm",
        ["koKR"] = "불꽃감시 경비탑",
        ["esMX"] = "Torre de la Guardia en Llamas",
        ["enUS"] = true,
        ["frFR"] = "Tour Guetteflamme",
        ["esES"] = "Torre de la Guardia en Llamas",
        ["zhTW"] = "焰望哨塔",
        ["zhCN"] = "火光塔楼",
    },
    ["Western Bridge"] = {
        ["ptBR"] = "Ponte Ocidental",
        ["ruRU"] = "Западный мост",
        ["deDE"] = "Die Westliche Brücke",
        ["koKR"] = "서부 교각",
        ["esMX"] = "Puente Occidental",
        ["enUS"] = true,
        ["frFR"] = "Pont de l’ouest",
        ["esES"] = "Puente Occidental",
        ["zhTW"] = "西部橋樑",
        ["zhCN"] = "西部桥梁",
    },
    ["Central Bridge"] = {
        ["ptBR"] = "Ponte Central",
        ["ruRU"] = "Центральный мост",
        ["deDE"] = "Die Zentrale Brücke",
        ["koKR"] = "중앙 교각",
        ["esMX"] = "Puente Central",
        ["enUS"] = true,
        ["frFR"] = "Pont central",
        ["esES"] = "Puente Central",
        ["zhTW"] = "中央橋樑",
        ["zhCN"] = "中部桥梁",
    },
    ["Wintergrasp Fortress"] = {
        ["ptBR"] = "Fortaleza Invérnia",
        ["ruRU"] = "Крепость Ледяных Оков",
        ["deDE"] = "Die Tausendwinterfestung",
        ["koKR"] = "겨울손아귀 요새",
        ["esMX"] = "Fortaleza de Conquista del Invierno",
        ["enUS"] = true,
        ["frFR"] = "Forteresse de Joug-d’hiver",
        ["esES"] = "Fortaleza de Conquista del Invierno",
        ["zhTW"] = "冬握堡壘",
        ["zhCN"] = "冬拥堡垒",
    },
    ["The Sunken Ring"] = {
        ["ptBR"] = "Ringue Enterrado",
        ["ruRU"] = "Затопленный Круг",
        ["deDE"] = "Der Versunkene Ring",
        ["koKR"] = "가라앉은 경기장",
        ["esMX"] = "El Anillo Sumergido",
        ["enUS"] = true,
        ["frFR"] = "Arène Engloutie",
        ["esES"] = "El Anillo Sumergido",
        ["zhTW"] = "沉沒之環",
        ["zhCN"] = "沉降之环",
    },
    ["Eastern Bridge"] = {
        ["ptBR"] = "Ponte Oriental",
        ["ruRU"] = "Восточный мост",
        ["deDE"] = "Die Östliche Brücke",
        ["koKR"] = "동부 교각",
        ["esMX"] = "Puente Oriental",
        ["enUS"] = true,
        ["frFR"] = "Pont de l’est",
        ["esES"] = "Puente Oriental",
        ["zhTW"] = "東部橋樑",
        ["zhCN"] = "东部桥梁",
    },
    ["The Broken Temple"] = {
        ["ptBR"] = "Templo Partido",
        ["ruRU"] = "Павший храм",
        ["deDE"] = "Der Zerbrochene Tempel",
        ["koKR"] = "파괴된 신전",
        ["esMX"] = "El Templo Quebrado",
        ["enUS"] = true,
        ["frFR"] = "Temple Brisé",
        ["esES"] = "El Templo Quebrado",
        ["zhTW"] = "破碎神殿",
        ["zhCN"] = "破碎神殿",
    },
    ["Shadowsight Tower"] = {
        ["ptBR"] = "Mirante Negro",
        ["ruRU"] = "Башня Темного Взора",
        ["deDE"] = "Der Schattenblickturm",
        ["koKR"] = "그늘눈 경비탑",
        ["esMX"] = "Torre de la Vista de las Sombras",
        ["enUS"] = true,
        ["frFR"] = "Tour d’Ombrevue",
        ["esES"] = "Torre de la Vista de las Sombras",
        ["zhTW"] = "影景哨塔",
        ["zhCN"] = "影目塔楼",
    },
    ["The Lifeblood Pillar"] = {
        ["ptBR"] = "Pilar Sangue Vital",
        ["ruRU"] = "Колонна Жизненной Силы",
        ["deDE"] = "Die Lebensblutsäule",
        ["koKR"] = "생명의 피 봉우리",
        ["esMX"] = "El Pilar Sangrevida",
        ["enUS"] = true,
        ["frFR"] = "Pilier Sang-de-vie",
        ["esES"] = "El Pilar Sangrevida",
        ["zhTW"] = "活血之柱",
        ["zhCN"] = "源血之柱",
    },
    ["The Lost Lands"] = {
        ["ptBR"] = "Terras Perdidas",
        ["ruRU"] = "Затерянные земли",
        ["deDE"] = "Die Verlorenen Lande",
        ["koKR"] = "잃어버린 땅",
        ["esMX"] = "Las Tierras Perdidas",
        ["enUS"] = true,
        ["frFR"] = "Terres Perdues",
        ["esES"] = "Las Tierras Perdidas",
        ["zhTW"] = "失落之地",
        ["zhCN"] = "迷失之地",
    },
    ["The Skyreach Pillar"] = {
        ["ptBR"] = "Pilar Beira-céu",
        ["ruRU"] = "Колонна Небесного Пути",
        ["deDE"] = "Die Himmelszeltsäule",
        ["koKR"] = "하늘길 봉우리",
        ["esMX"] = "El Pilar del Trecho Celestial",
        ["enUS"] = true,
        ["frFR"] = "Pilier Confins-du-ciel",
        ["esES"] = "El Pilar del Trecho Celestial",
        ["zhTW"] = "擎天之柱",
        ["zhCN"] = "通天之柱",
    },
    ["Hardknuckle Clearing"] = {
        ["ptBR"] = "Clareira do Nodo",
        ["ruRU"] = "Зачистка барабанчей",
        ["deDE"] = "Die Lichtung der Hartknöchel",
        ["koKR"] = "바위돌기고릴라 폐허",
        ["esMX"] = "Claro Callonudillo",
        ["enUS"] = true,
        ["frFR"] = "Clairière des Poings-durs",
        ["esES"] = "Claro Callonudillo",
        ["zhTW"] = "硬拳空地",
        ["zhCN"] = "硬皮旷野",
    },
    ["Sapphire Hive"] = {
        ["ptBR"] = "Colmeia Safira",
        ["ruRU"] = "Сапфирный улей",
        ["deDE"] = "Der Saphirschwarm",
        ["koKR"] = "사파이어 부화장",
        ["esMX"] = "Enjambre Zafiro",
        ["enUS"] = true,
        ["frFR"] = "Ruche de Saphir",
        ["esES"] = "Enjambre Zafiro",
        ["zhTW"] = "天藍蜂巢",
        ["zhCN"] = "蓝玉虫巢",
    },
    ["Wintergrasp River"] = {
        ["ptBR"] = "Rio Invérnia",
        ["ruRU"] = "Река Ледяных Оков",
        ["deDE"] = "Der Tausendwinterfluss",
        ["koKR"] = "겨울손아귀 강",
        ["esMX"] = "Río Conquista del Invierno",
        ["enUS"] = true,
        ["frFR"] = "Joug-d’hiver",
        ["esES"] = "Río Conquista del Invierno",
        ["zhTW"] = "冬握河",
        ["zhCN"] = "冬拥河",
    },
    ["Frenzyheart River"] = {
        ["ptBR"] = "Rio dos Feralma",
        ["ruRU"] = "Река Бешеного Сердца",
        ["deDE"] = "Der Strom der Wildherzen",
        ["koKR"] = "광란의심장 강",
        ["esMX"] = "Río Corazón Frenético",
        ["enUS"] = true,
        ["frFR"] = "Rivière de Frénécœur",
        ["esES"] = "Río Corazón Frenético",
        ["zhTW"] = "狂心之河",
        ["zhCN"] = "狂心河",
    },
    ["The Sundered Shard"] = {
        ["ptBR"] = "Estilhaço Partido",
        ["ruRU"] = "Одинокий осколок",
        ["deDE"] = "Die Versprengte Scherbe",
        ["koKR"] = "조각난 파편",
        ["esMX"] = "El Fragmento Hendido",
        ["enUS"] = true,
        ["frFR"] = "Éclat scindé",
        ["esES"] = "El Fragmento Hendido",
        ["zhTW"] = "破碎裂片",
        ["zhCN"] = "崩裂碎片",
    },
    ["Frenzyheart Hill"] = {
        ["ptBR"] = "Morro dos Feralma",
        ["ruRU"] = "Холм Бешеного Сердца",
        ["deDE"] = "Der Hügel der Wildherzen",
        ["koKR"] = "광란의심장 언덕",
        ["esMX"] = "Colina Corazón Frenético",
        ["enUS"] = true,
        ["frFR"] = "Colline de Frénécœur",
        ["esES"] = "Colina Corazón Frenético",
        ["zhTW"] = "狂心之丘",
        ["zhCN"] = "狂心岭",
    },
    ["Rainspeaker Rapids"] = {
        ["ptBR"] = "Corredeiras Pluvozes",
        ["ruRU"] = "Водопады Гласа Дождя",
        ["deDE"] = "Der Katarakt der Regenrufer",
        ["koKR"] = "구름몰이 여울목",
        ["esMX"] = "Rápidos de Hablalluvia",
        ["enUS"] = true,
        ["frFR"] = "Rapides parlepluie",
        ["esES"] = "Rápidos de Hablalluvia",
        ["zhTW"] = "雨頌者急湍",
        ["zhCN"] = "雨声河",
    },
    ["Lakeside Landing"] = {
        ["ptBR"] = "Pouso Beiralago",
        ["ruRU"] = "Лагерь у озера",
        ["deDE"] = "Der Landeplatz am See",
        ["koKR"] = "호반의 착륙장",
        ["esMX"] = "Pista del Lago",
        ["enUS"] = true,
        ["frFR"] = "Terrain d’atterrissage de Rive-du-lac",
        ["esES"] = "Pista del Lago",
        ["zhTW"] = "湖畔起降場",
        ["zhCN"] = "湖边着陆场",
    },
    ["River's Heart"] = {
        ["ptBR"] = "Coração do Rio",
        ["ruRU"] = "Слияние рек",
        ["deDE"] = "Der Flussnabel",
        ["koKR"] = "강의 심장부",
        ["esMX"] = "Corazón del Río",
        ["enUS"] = true,
        ["frFR"] = "Cœur du fleuve",
        ["esES"] = "Corazón del Río",
        ["zhTW"] = "大河之心",
        ["zhCN"] = "河流之心",
    },
    ["Rainspeaker Canopy"] = {
        ["ptBR"] = "Dossel Pluvozes",
        ["ruRU"] = "Прибежище Гласа Дождя",
        ["deDE"] = "Der Baldachin der Regenrufer",
        ["koKR"] = "구름몰이 거처",
        ["esMX"] = "Canope de Hablalluvia",
        ["enUS"] = true,
        ["frFR"] = "Canopée Parlepluie",
        ["esES"] = "Canope de Hablalluvia",
        ["zhTW"] = "雨頌者之篷",
        ["zhCN"] = "雨声树屋",
    },
    ["The Blight Line"] = {
        ["ptBR"] = "Confim da Praga",
        ["ruRU"] = "Увядшая поляна",
        ["deDE"] = "Die Seuchenfront",
        ["koKR"] = "파멸의 역병지",
        ["esMX"] = "La Línea de Añublo",
        ["enUS"] = true,
        ["frFR"] = "Ligne de la désolation",
        ["esES"] = "La Línea de Añublo",
        ["zhTW"] = "荒萎線",
        ["zhCN"] = "荒芜边界",
    },
    ["Wildgrowth Mangal"] = {
        ["ptBR"] = "Mangue Silvestre",
        ["ruRU"] = "Дикие мангровые заросли",
        ["deDE"] = "Der Wildwuchsmangal",
        ["koKR"] = "야생수풀 늪지대",
        ["esMX"] = "Manglar Silvestre",
        ["enUS"] = true,
        ["frFR"] = "Mangrove de la Croissance sauvage",
        ["esES"] = "Manglar Silvestre",
        ["zhTW"] = "叢生沼林",
        ["zhCN"] = "蛮藤谷",
    },
    ["Mosswalker Village"] = {
        ["ptBR"] = "Aldeia Limâmbulo",
        ["ruRU"] = "Деревня Мохобродов",
        ["deDE"] = "Das Mooswandlerdorf",
        ["koKR"] = "이끼걸음 마을",
        ["esMX"] = "Poblado Caminamoho",
        ["enUS"] = true,
        ["frFR"] = "Marchemousse",
        ["esES"] = "Poblado Caminamoho",
        ["zhTW"] = "苔行者村",
        ["zhCN"] = "苔行村",
    },
    ["The Borean Wall"] = {
        ["ptBR"] = "Muralha Boreana",
        ["ruRU"] = "Борейская стена",
        ["deDE"] = "Der Boreanische Wall",
        ["koKR"] = "북풍의 벽",
        ["esMX"] = "La Muralla Boreal",
        ["enUS"] = true,
        ["frFR"] = "Mur Boréen",
        ["esES"] = "La Muralla Boreal",
        ["zhTW"] = "北風之牆",
        ["zhCN"] = "北风之墙",
    },
    ["North Point Station"] = {
        ["ptBR"] = "Estação Norte",
        ["ruRU"] = "Северная станция",
        ["deDE"] = "Die Nordstation",
        ["koKR"] = "북부 거점",
        ["esMX"] = "Estación de la Punta Norte",
        ["enUS"] = true,
        ["frFR"] = "Poste de la Halte du nord",
        ["esES"] = "Estación de la Punta Norte",
        ["zhTW"] = "北點抽水站",
        ["zhCN"] = "北部哨站",
    },
    ["Spire of Pain"] = {
        ["ptBR"] = "Pináculo da Dor",
        ["ruRU"] = "Шпиль Боли",
        ["deDE"] = "Die Säule der Pein",
        ["koKR"] = "고통의 첨탑",
        ["esMX"] = "Aguja de Dolor",
        ["enUS"] = true,
        ["frFR"] = "Flèche de la Douleur",
        ["esES"] = "Aguja de Dolor",
        ["zhTW"] = "苦痛尖塔",
        ["zhCN"] = "苦痛尖塔",
    },
    ["Spire of Decay"] = {
        ["ptBR"] = "Pináculo da Decomposição",
        ["ruRU"] = "Шпиль Порчи",
        ["deDE"] = "Die Säule der Fäulnis",
        ["koKR"] = "부패의 첨탑",
        ["esMX"] = "Aguja de Putrefacción",
        ["enUS"] = true,
        ["frFR"] = "Flèche de la Décomposition",
        ["esES"] = "Aguja de Putrefacción",
        ["zhTW"] = "凋零尖塔",
        ["zhCN"] = "凋零尖塔",
    },
    ["Spire of Blood"] = {
        ["ptBR"] = "Torre Sangrenta",
        ["ruRU"] = "Шпиль Крови",
        ["deDE"] = "Die Säule des Blutes",
        ["koKR"] = "피의 첨탑",
        ["esMX"] = "Aguja de Sangre",
        ["enUS"] = true,
        ["frFR"] = "Flèche du Sang",
        ["esES"] = "Aguja de Sangre",
        ["zhTW"] = "鮮血尖塔",
        ["zhCN"] = "鲜血尖塔",
    },
    ["Festering Pools"] = {
        ["ptBR"] = "Poços Purulentos",
        ["ruRU"] = "Гнойные пруды",
        ["deDE"] = "Die Eiterteiche",
        ["koKR"] = "썩은 웅덩이",
        ["esMX"] = "Pozas Purulentas",
        ["enUS"] = true,
        ["frFR"] = "Bassins Purulents",
        ["esES"] = "Pozas Purulentas",
        ["zhTW"] = "膿瘡之池",
        ["zhCN"] = "溃烂之池",
    },
    ["Talramas"] = {
        ["ptBR"] = "Talramas",
        ["ruRU"] = "Талрамас",
        ["deDE"] = "Talramas",
        ["koKR"] = "탈라마스",
        ["esMX"] = "Talramas",
        ["enUS"] = true,
        ["frFR"] = "Talramas",
        ["esES"] = "Talramas",
        ["zhTW"] = "塔爾拉瑪斯",
        ["zhCN"] = "塔尔拉玛斯",
    },
    ["Steam Springs"] = {
        ["ptBR"] = "Fontes de Vapor",
        ["ruRU"] = "Кипящие Источники",
        ["deDE"] = "Die Dampfquellen",
        ["koKR"] = "증기 온천",
        ["esMX"] = "Manantiales de Vapor",
        ["enUS"] = true,
        ["frFR"] = "Sources de vapeur",
        ["esES"] = "Manantiales de Vapor",
        ["zhTW"] = "蒸汽之泉",
        ["zhCN"] = "蒸汽之泉",
    },
    ["The Flood Plains"] = {
        ["ptBR"] = "Planícies Inundadas",
        ["ruRU"] = "Затопленные равнины",
        ["deDE"] = "Die Flutebenen",
        ["koKR"] = "범람 평야",
        ["esMX"] = "Llanuras Anegadas",
        ["enUS"] = true,
        ["frFR"] = "Plaines Inondées",
        ["esES"] = "Llanuras Anegadas",
        ["zhTW"] = "氾濫平原",
        ["zhCN"] = "洪荒平原",
    },
    ["The Geyser Fields"] = {
        ["ptBR"] = "Campos de Gêiser",
        ["ruRU"] = "Поле Гейзеров",
        ["deDE"] = "Die Geysirfelder",
        ["koKR"] = "간헐천 지대",
        ["esMX"] = "Los Campos de Géiseres",
        ["enUS"] = true,
        ["frFR"] = "Champs de Geysers",
        ["esES"] = "Los Campos de Géiseres",
        ["zhTW"] = "水泉原野",
        ["zhCN"] = "喷泉平原",
    },
    ["Fizzcrank Pumping Station"] = {
        ["ptBR"] = "Estação Bombeadora do Biela",
        ["ruRU"] = "Насосная станция Выкрутеня",
        ["deDE"] = "Kurbelzischs Pumpstation",
        ["koKR"] = "피즈크랭크 채굴 현장",
        ["esMX"] = "Estación de Bombeo de Palanqueta",
        ["enUS"] = true,
        ["frFR"] = "Station de pompage de Spumelevier",
        ["esES"] = "Estación de Bombeo de Palanqueta",
        ["zhTW"] = "嘶軸幫浦站",
        ["zhCN"] = "菲兹兰克泵站",
    },
    ["The Court of Bones"] = {
        ["ptBR"] = "Corte de Ossos",
        ["ruRU"] = "Двор Костей",
        ["deDE"] = "Der Hof der Knochen",
        ["koKR"] = "해골 광장",
        ["esMX"] = "El Patio de los Huesos",
        ["enUS"] = true,
        ["frFR"] = "Cour des Ossements",
        ["esES"] = "El Patio de los Huesos",
        ["zhTW"] = "白骨之廷",
        ["zhCN"] = "白骨之庭",
    },
    ["Icemist Village"] = {
        ["ptBR"] = "Aldeia Bruma Boreal",
        ["ruRU"] = "Деревня Ледяной Пыли",
        ["deDE"] = "Eisnebel",
        ["koKR"] = "얼음안개 마을",
        ["esMX"] = "Poblado Bruma de Hielo",
        ["enUS"] = true,
        ["frFR"] = "Brume-glace",
        ["esES"] = "Poblado Bruma de Hielo",
        ["zhTW"] = "冰霧村",
        ["zhCN"] = "冰雾村",
    },
    ["Westwind Refugee Camp"] = {
        ["ptBR"] = "Campo de Refugiados de Zefirália",
        ["ruRU"] = "Лагерь беженцев Западного Ветра",
        ["deDE"] = "Das Flüchtlingslager von Westwind",
        ["koKR"] = "서풍의 피난민 행렬",
        ["esMX"] = "Campo de Refugiados de Viento Oeste",
        ["enUS"] = true,
        ["frFR"] = "Camp de réfugiés de Ponevent",
        ["esES"] = "Campo de Refugiados de Viento Oeste",
        ["zhTW"] = "西風難民營",
        ["zhCN"] = "西风避难营",
    },
    ["Obsidian Dragonshrine"] = {
        ["ptBR"] = "Santuário Dragônico Obsidiano",
        ["ruRU"] = "Обсидиановое святилище драконов",
        ["deDE"] = "Der Obsidiandrachenschrein",
        ["koKR"] = "흑요석 용제단",
        ["esMX"] = "Santuario de Dragones Obsidiana",
        ["enUS"] = true,
        ["frFR"] = "Sanctuaire draconique obsidien",
        ["esES"] = "Santuario de Dragones Obsidiana",
        ["zhTW"] = "黑曜龍殿",
        ["zhCN"] = "黑曜石巨龙圣地",
    },
    ["Agmar's Hammer"] = {
        ["ptBR"] = "Martelo de Agmar",
        ["ruRU"] = "Молот Агмара",
        ["deDE"] = "Agmars Hammer",
        ["koKR"] = "아그마르의 망치",
        ["esMX"] = "El Martillo de Agmar",
        ["enUS"] = true,
        ["frFR"] = "Marteau d’Agmar",
        ["esES"] = "Martillo de Agmar",
        ["zhTW"] = "阿格瑪之錘",
        ["zhCN"] = "阿格玛之锤",
    },
    ["Coldwind Pass"] = {
        ["ptBR"] = "Desfiladeiro Ventálgido",
        ["ruRU"] = "Перевал Холодного Ветра",
        ["deDE"] = "Der Kaltwindpass",
        ["koKR"] = "눈바람 고개",
        ["esMX"] = "Pasaje Viento Helado",
        ["enUS"] = true,
        ["frFR"] = "Passe de Vent-froid",
        ["esES"] = "Pasaje Viento Helado",
        ["zhTW"] = "冷風小徑",
        ["zhCN"] = "冷风小径",
    },
    ["Angrathar the Wrathgate"] = {
        ["ptBR"] = "Angrathar",
        ["ruRU"] = "Ангратар",
        ["deDE"] = "Angrathar",
        ["koKR"] = "분노의 관문 앙그라타르",
        ["esMX"] = "Angrathar la Puerta de Cólera",
        ["enUS"] = true,
        ["frFR"] = "Angrathar",
        ["esES"] = "Angrathar la Puerta de Cólera",
        ["zhTW"] = "『憤怒之門』安格拉薩",
        ["zhCN"] = "天谴之门安加萨",
    },
    ["Aldur'thar: The Desolation Gate"] = {
        ["ptBR"] = "Aldur'thar: o Portão da Desolação",
        ["ruRU"] = "Алдур'тар: Врата Горя",
        ["deDE"] = "Aldur'thar: Das Tor der Verwüstung",
        ["koKR"] = "알두르타르: 황폐의 관문",
        ["esMX"] = "Aldur'thar: La Puerta de la Desolación",
        ["enUS"] = true,
        ["frFR"] = "Aldur’thar : la Porte de la Désolation",
        ["esES"] = "Aldur'thar: La Puerta de la Desolación",
        ["zhTW"] = "奧多薩：荒寂之門",
        ["zhCN"] = "荒凉之门奥尔杜萨",
    },
    ["Silent Vigil"] = {
        ["ptBR"] = "Vigia Silente",
        ["ruRU"] = "Молчаливое Бдение",
        ["deDE"] = "Die stille Nachtwache",
        ["koKR"] = "침묵의 망루",
        ["esMX"] = "Vigía Silencioso",
        ["enUS"] = true,
        ["frFR"] = "Veille Silencieuse",
        ["esES"] = "Vigía Silencioso",
        ["zhTW"] = "靜默警戒",
        ["zhCN"] = "沉默墓地",
    },
    ["The Storm Peaks"] = {
        ["ptBR"] = "Picos Tempestuosos",
        ["ruRU"] = "Грозовая Гряда",
        ["deDE"] = "Die Sturmgipfel",
        ["koKR"] = "폭풍우 봉우리",
        ["esMX"] = "Las Cumbres Tormentosas",
        ["enUS"] = true,
        ["frFR"] = "Pics Foudroyés",
        ["esES"] = "Cumbres Tormentosas",
        ["zhTW"] = "風暴群山",
        ["zhCN"] = "风暴峭壁",
    },
    ["Nidavelir"] = {
        ["ptBR"] = "Nidavelir",
        ["ruRU"] = "Нидавелир",
        ["deDE"] = "Nidavelir",
        ["koKR"] = "니다벨리르",
        ["esMX"] = "Nidavelir",
        ["enUS"] = true,
        ["frFR"] = "Nidavelir",
        ["esES"] = "Nidavelir",
        ["zhTW"] = "尼達維里爾",
        ["zhCN"] = "尼达维里尔",
    },
    ["Snowdrift Plains"] = {
        ["ptBR"] = "Planícies Nevadas",
        ["ruRU"] = "Снежные равнины",
        ["deDE"] = "Die Verschneiten Ebenen",
        ["koKR"] = "눈더미 평원",
        ["esMX"] = "Llanuras Ventisquero",
        ["enUS"] = true,
        ["frFR"] = "Plaines des Congères",
        ["esES"] = "Llanuras Ventisquero",
        ["zhTW"] = "雪迅平原",
        ["zhCN"] = "雪流平原",
    },
    ["Sindragosa's Fall"] = {
        ["ptBR"] = "Queda de Sindragosa",
        ["ruRU"] = "Каньон Гибели Синдрагосы",
        ["deDE"] = "Sindragosas Sturz",
        ["koKR"] = "신드라고사의 추락지",
        ["esMX"] = "La Caída de Sindragosa",
        ["enUS"] = true,
        ["frFR"] = "Chute de Sindragosa",
        ["esES"] = "Caída de Sindragosa",
        ["zhTW"] = "辛德拉苟莎之殞",
        ["zhCN"] = "辛达苟萨之墓",
    },
    ["Uncharted Territory"] = {
        ["ptBR"] = "Território Desconhecido",
        ["ruRU"] = "Неизведанная территория",
        ["deDE"] = "Unerforschtes Gebiet",
        ["koKR"] = "미지의 땅",
        ["esMX"] = "Territorio no explorado",
        ["enUS"] = true,
        ["frFR"] = "Territoire inconnu",
        ["esES"] = "Territorio inexplorado",
        ["zhTW"] = "未知領土",
        ["zhCN"] = "未知领域",
    },
}

for k, v in pairs(northrendLocales) do
    l10n.translations[k] = v
end
