-- Title: SLDataText
-- Version: 2.05
-- Revision Date: October 20, 2008
-- Author: Jeff "Taffu" Fancher
-- Notes: GPLv3 License
----------------------------------------------

function DT_FetchLocaleList()
    local locale = GetLocale()
    local localeList
    
    if ( locale == "enUS" ) then -- English Locale --------------------------------------------------
        localeList = {
            -- Point & Strata info
            ["Bottom Right"] = "Bottom Right",
            ["Bottom"] = "Bottom",
            ["Bottom Left"] = "Bottom Left",
            ["Right"] = "Right",
            ["Center"] = "Center",
            ["Left"] = "Left",
            ["Top Right"] = "Top Right",
            ["Top"] = "Top",
            ["Top Left"] = "Top Left",
            ["Up"] = "Up",
            ["Down"] = "Down",
            ["Parent"] = "Parent",
            ["Background"] = "Background",
            ["Low"] = "Low",
            ["Medium"] = "Medium",
            ["High"] = "High",
            ["Dialog"] = "Dialog",
            
            -- Command info
            ["/sldt"] = "/sldt",
            ["/sldatatext"] = "/sldatatext",
            
            -- Option info
            ["SLDataText"] = "SLDataText",            
            ["GenSet"] = "General Settings",
            ["LockEle"] = "Lock Elements",
            ["LockEleDesc"] = "Toggle all elements locked/unlocked.",
            ["HIC"] = "Hide In Combat",
            ["HICDesc"] = "When active, modules will hide when engaged in combat.",
            ["ClassColGbl"] = "Class Colored (Global)",
            ["ClassColGblDesc"] = "When active, all modules secondary text will be colored according to your class.",
            
            ["GblOpts"] = "Global Options",
            ["GblFontDesc"] = "Global font options offer the ability to use consistent font settings throughout all or some DT modules. This option can be voided independently in individual module option menus.",
            ["GblFontSet"] = "Global Font Settings",
            ["GblFont"] = "Global Font",
            ["GblFontDesc"] = "Select a global font that can be used by all modules.",
            ["GblFontSize"] = "Global Font Size",
            ["GblFontSizeDesc"] = "Select a global font size that can be used by all modules.",
            ["MoreInfo"] = "Each module can be anchored to another module using the module(s) frame name. Each module(s) frame name consists of 'SLDT', followed by an underscore and then the modules name. (ie. Clock would be SLDT_Clock)",
            
            -- Common Module Options
            ["Enabled"] = "Enabled",
            ["EnabledDesc"] = "Toggle module enabled/disabled.",
            ["HideTT"] = "Hide Tooltip",
            ["HideTTDesc"] = "When enabled, will disable the tooltip feature of the module.",
            ["SIC"] = "Show In Combat",
            ["SICDesc"] = "When enabled, will force being shown in combat.",
            ["ClassCol"] = "Class Colorize",
            ["ClassColDesc"] = "When enabled, secondary text will be colored according to your class.",
            ["SecText"] = "Secondary Text",
            ["SecTextDesc"] = "Input secondary text to be used in module display.",
            ["DispSet"] = "Display Settings",
            ["DispStyle"] = "Display Style",
            ["UseGblFont"] = "Use Global Font",
            ["UseGblFontDesc"] = "Toggle use of global font on/off.",
            ["UseGblFSize"] = "Use Global Font Size",
            ["UseGblFSizeDesc"] = "Toggle use of global font size on/off.",
            ["Font"] = "Font",
            ["FontDesc"] = "Select font for module.",
            ["FontSize"] = "Font Size",
            ["FontSizeDesc"] = "Select font size for module.",
            ["LaySet"] = "Layout Settings",
            ["TextJust"] = "Text Justify",
            ["TextJustDesc"] = "Select the text justification for this module.",
            ["ParFrm"] = "Parent Frame",
            ["ParFrmDesc"] = "Manually set the frame you would like the module anchored to.",
            ["AnchFrom"] = "Anchor From",
            ["AnchFromDesc"] = "Manually set the point on the parent frame to anchor the module to.",
            ["XOff"] = "X Offset",
            ["XOffDesc"] = "Manually set the frames horizontal offset.",
            ["YOff"] = "Y Offset",
            ["YOffDesc"] = "Manually set the frames vertical offset.",
            ["Strata"] = "Strata",
            ["StrataDesc"] = "Set modules frame strata.",
            ["TTAnch"] = "Tooltip Anchor",
            ["TTAnchDesc"] = "Select the point of the tooltip to anchor from.",
            ["AnchTTFrom"] = "Anchor Tooltip From",
            ["AnchTTFromDesc"] = "Select the point of the module frame to anchor the tooltip to.",
            ["TTSize"] = "Tooltip Size",
            ["TTSizeDesc"] = "Set the size/scale of the tooltip menu.",
            
            -- Bag Options
            ["Bag"] = "Bag",
            ["GenBagSet"] = "General Bag Settings",
            ["ShowRemSpace"] = "Show Remaining Space",
            ["ShowRemSpaceDesc"] = "When enabled, module will reflect remaining space instead of used space.",
            ["ShowTotSpace"] = "Show Total Space",
            ["ShowTotSpaceDesc"] = "When enabled, module will show total available bag space.",
            ["HAmmo"] ="Hide Ammo",
            ["HAmmoDesc"] = "When enabled, module will omit ammo information.",
            ["Bag Data"] = "Bag Data",
            ["Quiver"] = "Quiver",
            ["Ammo Pouch"] = "Ammo Pouch",
            ["Soul Bag"] = "Soul Bag",
            ["Bag:"] = "Bag:",
            ["Total:"] = "Total:",
            ["Used:"] = "Used:",
            ["Remaining:"] = "Remaining:",
            ["Ammo:"] = "Ammo:",
            
            -- Clock Options
            ["Clock"] = "Clock",
            ["GenClkSet"] = "General Clock Settings",
            ["SST"] = "Show Server Time",
            ["SSTDesc"] = "When enabled, time will be Server Time.",
            ["ST24Hour"] = "Server 24 Hour",
            ["ST24HourDesc"] = "When enabled, server time will reflect 24 hour format.",
            ["ClkFormat"] = "Clock Format",
            ["ClkFormatDesc"] = "Select format for clock (Default: %I:%M).",
            ["am"] = "am",
            ["pm"] = "pm",
            ["Time Info"] = "Time Info",
            ["Realm Time:"] = "Realm Time:",
            ["Local Time:"] = "Local Time:",
            ["ClkHint1"] = "Click to show clock settings.",
            ["ClkHint2"] = "Shift+Click to show calendar.",
            ["ClkFormDescLong"] = "The Clock Format feature allows direct input of date() time formats. %I = 12 hour (01-12), %H = 24 hour (00-24), %l = 12 hour (1-12), %k = 24 hour (0-24), %M = minutes (00-59), %S = seconds (00-60)",
            
            -- Coords Options
            ["Coords"] = "Coords",
            ["GenCorSet"] = "General Coords Settings",
            ["Prec"] = "Precision",
            ["PrecDesc"] = "Set the decimal precision for coordinates.",
            
            -- Durability Options
            ["Durability"] = "Durability",
            ["GenDurSet"] = "General Durability Settings",
            ["Armor:"] = "Armor:",
            ["Head"] = "Head",
            ["Shoulder"] = "Shoulder",
            ["Chest"] = "Chest",
            ["Waist"] = "Waist",
            ["Wrist"] = "Wrist",
            ["Hands"] = "Hands",
            ["Legs"] = "Legs",
            ["Feet"] = "Feet",
            ["Main Hand"] = "Main Hand",
            ["Off Hand"] = "Off Hand",
            ["Ranged"] = "Ranged",
            ["Durability Stats"] = "Durability Stats",
            
            -- Experience Options
            ["Experience"] = "Experience",
            ["GenExpSet"] = "General Experience Settings",
            ["DispStyle"] = "Display Style",
            ["DispStyleDesc"] = "Select how the experience points are displayed.",
            ["Full"] = "Full",
            ["Compact"] = "Compact",
            ["ExpStats"] = "Experience Stats",
            ["Current XP:"] = "Current XP:",
            ["Needed XP:"] = "Needed XP:",
            ["XP To Go:"] = "XP To Go:",
            ["Rested XP:"] = "Rested XP:",
            
            -- Framerate Options
            ["Framerate"] = "Framerate",
            ["GenFPSSet"] = "General Framerate Settings",
            ["fps"] = "fps",
            
            -- Friends Options
            ["FriendList"] = "FriendList",
            ["GenFLSet"] = "General FriendList Settings",
            ["FLHint"] = "<Click> to whisper, <Alt+Click> to group invite.",
            ["Friends:"] = "Friends:",
            
            -- Gold Options
            ["Gold"] = "Gold",
            ["GenGoldSet"] = "General Gold Settings",
            ["GDispStyleDesc"] = "Select the currency display style.",
            ["Short"] = "Short",
            ["Full"] = "Full",
            ["Extended"] = "Extended",
            ["Gold"] = "Gold",
            ["Silver"] = "Silver",
            ["Copper"] = "Copper",
            ["Gold Stats"] = "Gold Stats",
            ["Starting Gold"] = "Starting Gold",
            ["Current Gold"] = "Current Gold",
            ["Gold Earned"] = "Gold Earned",
            ["Server Gold"] = "Server Gold",
            ["Total Gold"] = "Total Gold",
            
            -- Guild Options
            ["GuildList"] = "GuildList",
            ["GenGLSet"] = "General GuildList Settings",
            ["GLHint"] = "<Click> to whisper, <Alt+Click> to group invite.",
            ["Guild:"] = "Guild:",
            
            -- Latency Options
            ["Latency"] = "Latency",
            ["GenLagSet"] = "General Latency Settings",
            ["ms"] = "ms",
            
            -- Mail Options
            ["Mail"] = "Mail",
            ["GenMailSet"] = "General Mail Settings",
            ["ShowTotal"] = "Show Total",
            ["ShowTotalDesc"] = "When enabled, module will display total mail.",
            ["New!"] = "New!",
            ["Mail:"] = "Mail:",
            ["No Mail"] = "No Mail",
            
            -- Memory Options
            ["Memory"] = "Memory",
            ["GenMemSet"] = "General Memory Settings",
            ["HideBlizz"] = "Hide Blizzard Memory",
            ["HideBlizzDesc"] = "When enabled, memory usage associated to Blizzard UI elements will not be shown.",
            ["Memory Stats"] = "Memory Stats",
            ["MiB"] = "MiB",
            ["KiB"] = "KiB",
            
            -- Statline Options
            ["Statline"] = "Statline",
            ["GenSLSet"] = "General Statline Settings",
            ["Stat1"] = "Statistic 1",
            ["Stat1Desc"] = "Select statistic for the first display slot.",
            ["Stat2"] = "Statistic 2",
            ["Stat2Desc"] = "Select statistic for the second display slot.",
            ["Stat3"] = "Statistic 3",
            ["Stat3Desc"] = "Select statistic for the third display slot.",
            ["Armor Rating"] = "Armor Rating",
            ["Attack Power"] = "Attack Power",
            ["Block Chance"] = "Block Chance",
            ["Crit Chance"] = "Crit Chance",
            ["Damage Per Second"] = "Damage Per Second",
            ["Defense Rating"] = "Defense Rating",
            ["Dodge Chance"] = "Dodge Chance",
            ["Expertise Percentage"] = "Expertise Percentage",
            ["Hit Rating"] = "Hit Rating",
            ["Mana Regen Casting"] = "Mana Regen Casting",
            ["Parry Chance"] = "Parry Chance",
            ["Ranged Attack Power"] = "Ranged Attack Power",
            ["Ranged Crit Chance"] = "Ranged Crit Chance",
            ["Spell Bonus Healing"] = "Spell Bonus Healing",
            ["Spell Crit Chance"] = "Spell Crit Chance",
            ["Spell Damage"] = "Spell Damage",
            ["Spell Penetration"] = "Spell Penetration",
            
            -- Tracking Options
            ["Tracking"] = "Tracking",
            ["GenTrackSet"] = "General Tracking Settings",
            ["Text"] = "Text",
            ["Icon"] = "Icon",
            ["TDispStyleDesc"] = "Select the tracking display style.",
            ["IconSize"] = "Icon Size",
            ["IconSizeDesc"] = "Select the size of the tracking icon.",
            
            -- ZoneText Options
            ["ZoneText"] = "ZoneText",
            ["GenZTSet"] = "General ZoneText Settings",
            
        }
    elseif ( locale == "deDE" ) then -- German Locale --------------------------------------------------
        localeList = {
            -- Point & Strata info
            ["Bottom Right"] = "Bottom Right",
            ["Bottom"] = "Bottom",
            ["Bottom Left"] = "Bottom Left",
            ["Right"] = "Right",
            ["Center"] = "Center",
            ["Left"] = "Left",
            ["Top Right"] = "Top Right",
            ["Top"] = "Top",
            ["Top Left"] = "Top Left",
            ["Up"] = "Up",
            ["Down"] = "Down",
            ["Parent"] = "Parent",
            ["Background"] = "Background",
            ["Low"] = "Low",
            ["Medium"] = "Medium",
            ["High"] = "High",
            ["Dialog"] = "Dialog",
            
            -- Command info
            ["/sldt"] = "/sldt",
            ["/sldatatext"] = "/sldatatext",
            
            -- Option info
            ["SLDataText"] = "SLDataText",            
            ["GenSet"] = "General Settings",
            ["LockEle"] = "Lock Elements",
            ["LockEleDesc"] = "Toggle all elements locked/unlocked.",
            ["HIC"] = "Hide In Combat",
            ["HICDesc"] = "When active, modules will hide when engaged in combat.",
            ["ClassColGbl"] = "Class Colored (Global)",
            ["ClassColGblDesc"] = "When active, all modules secondary text will be colored according to your class.",
            
            ["GblOpts"] = "Global Options",
            ["GblFontDesc"] = "Global font options offer the ability to use consistent font settings throughout all or some DT modules. This option can be voided independently in individual module option menus.",
            ["GblFontSet"] = "Global Font Settings",
            ["GblFont"] = "Global Font",
            ["GblFontDesc"] = "Select a global font that can be used by all modules.",
            ["GblFontSize"] = "Global Font Size",
            ["GblFontSizeDesc"] = "Select a global font size that can be used by all modules.",
            ["MoreInfo"] = "Each module can be anchored to another module using the module(s) frame name. Each module(s) frame name consists of 'SLDT', followed by an underscore and then the modules name. (ie. Clock would be SLDT_Clock)",
            
            -- Common Module Options
            ["Enabled"] = "Enabled",
            ["EnabledDesc"] = "Toggle module enabled/disabled.",
            ["HideTT"] = "Hide Tooltip",
            ["HideTTDesc"] = "When enabled, will disable the tooltip feature of the module.",
            ["SIC"] = "Show In Combat",
            ["SICDesc"] = "When enabled, will force being shown in combat.",
            ["ClassCol"] = "Class Colorize",
            ["ClassColDesc"] = "When enabled, secondary text will be colored according to your class.",
            ["SecText"] = "Secondary Text",
            ["SecTextDesc"] = "Input secondary text to be used in module display.",
            ["DispSet"] = "Display Settings",
            ["DispStyle"] = "Display Style",
            ["UseGblFont"] = "Use Global Font",
            ["UseGblFontDesc"] = "Toggle use of global font on/off.",
            ["UseGblFSize"] = "Use Global Font Size",
            ["UseGblFSizeDesc"] = "Toggle use of global font size on/off.",
            ["Font"] = "Font",
            ["FontDesc"] = "Select font for module.",
            ["FontSize"] = "Font Size",
            ["FontSizeDesc"] = "Select font size for module.",
            ["LaySet"] = "Layout Settings",
            ["TextJust"] = "Text Justify",
            ["TextJustDesc"] = "Select the text justification for this module.",
            ["ParFrm"] = "Parent Frame",
            ["ParFrmDesc"] = "Manually set the frame you would like the module anchored to.",
            ["AnchFrom"] = "Anchor From",
            ["AnchFromDesc"] = "Manually set the point on the parent frame to anchor the module to.",
            ["XOff"] = "X Offset",
            ["XOffDesc"] = "Manually set the frames horizontal offset.",
            ["YOff"] = "Y Offset",
            ["YOffDesc"] = "Manually set the frames vertical offset.",
            ["Strata"] = "Strata",
            ["StrataDesc"] = "Set modules frame strata.",
            ["TTAnch"] = "Tooltip Anchor",
            ["TTAnchDesc"] = "Select the point of the tooltip to anchor from.",
            ["AnchTTFrom"] = "Anchor Tooltip From",
            ["AnchTTFromDesc"] = "Select the point of the module frame to anchor the tooltip to.",
            ["TTSize"] = "Tooltip Size",
            ["TTSizeDesc"] = "Set the size/scale of the tooltip menu.",
            
            -- Bag Options
            ["Bag"] = "Bag",
            ["GenBagSet"] = "General Bag Settings",
            ["ShowRemSpace"] = "Show Remaining Space",
            ["ShowRemSpaceDesc"] = "When enabled, module will reflect remaining space instead of used space.",
            ["ShowTotSpace"] = "Show Total Space",
            ["ShowTotSpaceDesc"] = "When enabled, module will show total available bag space.",
            ["HAmmo"] ="Hide Ammo",
            ["HAmmoDesc"] = "When enabled, module will omit ammo information.",
            ["Bag Data"] = "Bag Data",
            ["Quiver"] = "Quiver",
            ["Ammo Pouch"] = "Ammo Pouch",
            ["Soul Bag"] = "Soul Bag",
            ["Bag:"] = "Bag:",
            ["Total:"] = "Total:",
            ["Used:"] = "Used:",
            ["Remaining:"] = "Remaining:",
            ["Ammo:"] = "Ammo:",
            
            -- Clock Options
            ["Clock"] = "Clock",
            ["GenClkSet"] = "General Clock Settings",
            ["SST"] = "Show Server Time",
            ["SSTDesc"] = "When enabled, time will be Server Time.",
            ["ClkFormat"] = "Clock Format",
            ["ClkFormatDesc"] = "Select format for clock (Default: %I:%M).",
            ["am"] = "am",
            ["pm"] = "pm",
            ["Time Info"] = "Time Info",
            ["Realm Time:"] = "Realm Time:",
            ["Local Time:"] = "Local Time:",
            ["ClkHint1"] = "Click to show clock settings.",
            ["ClkHint2"] = "Shift+Click to show calendar.",
            ["ClkFormDescLong"] = "The Clock Format feature allows direct input of date() time formats. %I = 12 hour (01-12), %H = 24 hour (00-24), %l = 12 hour (1-12), %k = 24 hour (0-24), %M = minutes (00-59), %S = seconds (00-60)",
            
            -- Coords Options
            ["Coords"] = "Coords",
            ["GenCorSet"] = "General Coords Settings",
            ["Prec"] = "Precision",
            ["PrecDesc"] = "Set the decimal precision for coordinates.",
            
            -- Durability Options
            ["Durability"] = "Durability",
            ["GenDurSet"] = "General Durability Settings",
            ["Armor:"] = "Armor:",
            ["Head"] = "Head",
            ["Shoulder"] = "Shoulder",
            ["Chest"] = "Chest",
            ["Waist"] = "Waist",
            ["Wrist"] = "Wrist",
            ["Hands"] = "Hands",
            ["Legs"] = "Legs",
            ["Feet"] = "Feet",
            ["Main Hand"] = "Main Hand",
            ["Off Hand"] = "Off Hand",
            ["Ranged"] = "Ranged",
            ["Durability Stats"] = "Durability Stats",
            
            -- Experience Options
            ["Experience"] = "Experience",
            ["GenExpSet"] = "General Experience Settings",
            ["DispStyle"] = "Display Style",
            ["DispStyleDesc"] = "Select how the experience points are displayed.",
            ["Full"] = "Full",
            ["Compact"] = "Compact",
            ["ExpStats"] = "Experience Stats",
            ["Current XP:"] = "Current XP:",
            ["Needed XP:"] = "Needed XP:",
            ["XP To Go:"] = "XP To Go:",
            ["Rested XP:"] = "Rested XP:",
            
            -- Framerate Options
            ["Framerate"] = "Framerate",
            ["GenFPSSet"] = "General Framerate Settings",
            ["fps"] = "fps",
            
            -- Friends Options
            ["FriendList"] = "FriendList",
            ["GenFLSet"] = "General FriendList Settings",
            ["FLHint"] = "<Click> to whisper, <Alt+Click> to group invite.",
            ["Friends:"] = "Friends:",
            
            -- Gold Options
            ["Gold"] = "Gold",
            ["GenGoldSet"] = "General Gold Settings",
            ["GDispStyleDesc"] = "Select the currency display style.",
            ["Short"] = "Short",
            ["Full"] = "Full",
            ["Extended"] = "Extended",
            ["Gold"] = "Gold",
            ["Silver"] = "Silver",
            ["Copper"] = "Copper",
            ["Gold Stats"] = "Gold Stats",
            ["Starting Gold"] = "Starting Gold",
            ["Current Gold"] = "Current Gold",
            ["Gold Earned"] = "Gold Earned",
            ["Server Gold"] = "Server Gold",
            ["Total Gold"] = "Total Gold",
            
            -- Guild Options
            ["GuildList"] = "GuildList",
            ["GenGLSet"] = "General GuildList Settings",
            ["GLHint"] = "<Click> to whisper, <Alt+Click> to group invite.",
            ["Guild:"] = "Guild:",
            
            -- Latency Options
            ["Latency"] = "Latency",
            ["GenLagSet"] = "General Latency Settings",
            ["ms"] = "ms",
            
            -- Mail Options
            ["Mail"] = "Mail",
            ["GenMailSet"] = "General Mail Settings",
            ["ShowTotal"] = "Show Total",
            ["ShowTotalDesc"] = "When enabled, module will display total mail.",
            ["New!"] = "New!",
            ["Mail:"] = "Mail:",
            ["No Mail"] = "No Mail",
            
            -- Memory Options
            ["Memory"] = "Memory",
            ["GenMemSet"] = "General Memory Settings",
            ["HideBlizz"] = "Hide Blizzard Memory",
            ["HideBlizzDesc"] = "When enabled, memory usage associated to Blizzard UI elements will not be shown.",
            ["Memory Stats"] = "Memory Stats",
            ["MiB"] = "MiB",
            ["KiB"] = "KiB",
            
            -- Statline Options
            ["Statline"] = "Statline",
            ["GenSLSet"] = "General Statline Settings",
            ["Stat1"] = "Statistic 1",
            ["Stat1Desc"] = "Select statistic for the first display slot.",
            ["Stat2"] = "Statistic 2",
            ["Stat2Desc"] = "Select statistic for the second display slot.",
            ["Stat3"] = "Statistic 3",
            ["Stat3Desc"] = "Select statistic for the third display slot.",
            ["Armor Rating"] = "Armor Rating",
            ["Attack Power"] = "Attack Power",
            ["Block Chance"] = "Block Chance",
            ["Crit Chance"] = "Crit Chance",
            ["Damage Per Second"] = "Damage Per Second",
            ["Defense Rating"] = "Defense Rating",
            ["Dodge Chance"] = "Dodge Chance",
            ["Expertise Percentage"] = "Expertise Percentage",
            ["Hit Rating"] = "Hit Rating",
            ["Mana Regen Casting"] = "Mana Regen Casting",
            ["Parry Chance"] = "Parry Chance",
            ["Ranged Attack Power"] = "Ranged Attack Power",
            ["Ranged Crit Chance"] = "Ranged Crit Chance",
            ["Spell Bonus Healing"] = "Spell Bonus Healing",
            ["Spell Crit Chance"] = "Spell Crit Chance",
            ["Spell Damage"] = "Spell Damage",
            ["Spell Penetration"] = "Spell Penetration",
            
            -- Tracking Options
            ["Tracking"] = "Tracking",
            ["GenTrackSet"] = "General Tracking Settings",
            ["Text"] = "Text",
            ["Icon"] = "Icon",
            ["TDispStyleDesc"] = "Select the tracking display style.",
            ["IconSize"] = "Icon Size",
            ["IconSizeDesc"] = "Select the size of the tracking icon.",
            
            -- ZoneText Options
            ["ZoneText"] = "ZoneText",
            ["GenZTSet"] = "General ZoneText Settings",
            
        }
    end
    
    return localeList
end