



-- Hooks...
cast:HookScript("OnShow", function () castbar:SetScript("OnUpdate", nil) end) 
cast:SetScript("OnEvent", function (self, event, ...) OnCombatEventCastbar(plate,...) end) 
cast:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED");

local InArena = false
local InRaid = false
local InParty = false

local ArenaGUID = {}
local ArenaName = {}


-- local GroupGUIDtoName = {}
-- local GroupNameToGUID = {}

local function CheckGroupStatus() 
	InArena = IsActiveBattlefieldArena()
	InRaid = (UnitInRaid("player") == 1)
	InParty = (UnitInParty("player") == 1)
end

local function GetArenaList()
	if not InArena then return end
	wipe(ArenaGUID)		
	local unitid
	for i =1,5 do
		unitid = "arena"..i
		ArenaGUID[UnitGUID(unitid)] = unitid
		ArenaName[UnitName(unitid)] = unitid
	end
end

local function CheckRaidTargets(guid)
	-- We need to check our raid/party and see if anyone has the caster targeted
	if not InRaid then return end
	local unitid, unitidTarget
	local RaidSize = GetNumRaidMembers();
	for i = 1,RaidSize do
		unitid = "raid"..i.."target"
		unitidTarget = UnitGUID(unitid)
		if guid == unitidTarget then return unitid end
	end
end

local function UpdateSelfCast(self)
	local currentTime = GetTime()
	if currentTime > self.endTime then
		self:SetScript("OnUpdate", nil)
		self:Hide()
		return
	end
	self:SetValue(self.endTime - currentTime)
end

local function ShowSpellCastEvent(plate, spell, icon, startTime, endTime, notInterruptible)
	if not (spell and icon and startTime and endTime) then return end
	local castbar = bars.castbar
	UpdateStubbornRegions()
	
	-- unit.isCasting = true
	-- unit.spellName = spell		-- Update Core to also provide this info
	--visual.specialText2:SetText(spell);
	--visual.specialText2:Show();
	
	-- Standard Casting Graphics
	visual.spellicon:SetTexture(icon)
	if notInterruptible then visual.castnostop:Show(); visual.castborder:Hide()
	else visual.castnostop:Hide(); visual.castborder:Show() end
	
	-- Cast Bar
	castbar.endTime = endTime
	castbar:SetMinMaxValues(endTime - startTime)
	castbar:SetValue(0)
	castbar:SetStatusBarColor(1, .2, 0)
	castbar:Show()	
	castbar:SetScript("OnUpdate", UpdateSelfCast)
end

function OnCombatEventCastbar(plate, ...)

-- My own temporary hack...
CheckGroupStatus()
GetArenaList()
--

	local timestamp, combatevent, sourceGUID, sourceName, sourceFlags, destGUID, destName, destFlags, spellid, spellname = ...
	local unitid
	UpdateReferences(plate)
	if (not combatevent == "SPELL_CAST_START") or unit.isTarget then return end

	-- Identify the Unit...
	if InArena then	
		unitid = ArenaName[sourceName]
		--unitid = ArenaGUID[sourceGUID]
	elseif InRaid then 
		if sourceGUID ~= unit.guid then return end
		unitid = CheckRaidTargets(sourceGUID) 
	end

	if unitid then 
		local spell, _, _, icon, startTime, endTime, _, _, notInterruptible = UnitCastingInfo(unitid)
		ShowSpellCastEvent(plate, spell, icon, startTime, endTime, notInterruptible)
	else 
		local currentTime = GetTime()
		local spell, _, icon, _, _, _, castTime, _, _ = GetSpellInfo(spellid)
		ShowSpellCastEvent(plate, spell, icon, currentTime, currentTime + castTime, true)
	end
end