-------------------------------------------------------------------------------------------
--	WANT TO CHANGE THE STYLE OF THE MINIMAP BLIPS?	--
-------------------------------------------------------------------------------------------
--file path to blip textures (2 styles are included with this addon, or you can find/create your own.)
--If you like the default blips instead, then use "Interface\\Minimap\\OBJECTICONS.blp"

local blips = "Interface\\AddOns\\PocketPlot\\media\\PPblips2.blp"
-------------------------------------------------------------------------------------------------------------------------------------

local PocketPlot = CreateFrame("Frame", nil, Minimap)
local LSM = LibStub("LibSharedMedia-3.0")
local fonts = LSM:List("font")
local class = select(2, UnitClass("player"))
local classColor, movershown, clockFrame, clockTime, db, options
local Minimap = Minimap
local MinimapZoneTextButton = MinimapZoneTextButton
local GameTimeFrame = GameTimeFrame
local MiniMapTracking = MiniMapTracking
local MiniMapBattlefieldFrame = MiniMapBattlefieldFrame
local MiniMapMailFrame = MiniMapMailFrame
local MiniMapVoiceChatFrame = MiniMapVoiceChatFrame
local MiniMapMeetingStoneFrame = MiniMapMeetingStoneFrame
PP_oldMinimap, PP_oldDurabilityFrame, PP_oldVehicleSeatIndicator = nil	--, PP_oldWatchFrame = nil
local _G = _G
local mover = CreateFrame("Frame", nil, UIParent)
		mover:SetBackdrop({bgFile ="Interface\\Buttons\\WHITE8x8",})
		mover:SetBackdropColor(.2,.2,.9,.6)
		mover:SetMovable(1)
		mover:Hide()
local moverText = mover:CreateFontString(nil, "OVERLAY")
		moverText:SetFont("Fonts\\ARIALN.ttf", 14)
		moverText:SetParent(mover)
		moverText:SetPoint("CENTER")
local coordframe = CreateFrame("Frame", nil, Minimap)
		coordframe:SetHeight(28)	--height of clock button
		coordframe:SetWidth(60)		--width of clock button
		coordframe:EnableMouse(true)
local coords = coordframe:CreateFontString(nil, "OVERLAY")
		coords:SetParent(coordframe)
local frames = {	"Minimap",
					"DurabilityFrame",
					"VehicleSeatIndicator",
					"MiniMapInstanceDifficulty",
--					"WatchFrame",
					"None",
				}
local stratae = {"BACKGROUND", "LOW", "MEDIUM", "HIGH", "DIALOG"}
local shapes = {"Square", "Circle"}
local fontFlags = {"None", "Outline", "Thick Outline", "Monochrome"}

local defaults = {
	shape = "Square",
	lsmfont = "Blue Highway",
	fontFlag = "Outline",
	zoneText = true,
	zoneSize = 14,  --font size
	clockSize = 16,	--font size
	scale = 1,  --scale of the minimap
	mapPos = {x = -10, y = -10},  --offset of the minimap from the top right corner.  If you wish to change where the minimap is anchored, see the "Minimap Location and Size" section below  Note: this will move the quest tracker, etc, unless you use other addons to control those frames.
	bg = {r = 0, g = 0, b = 0},  --border colors (red, green, blue) -- values are a range from 0-1  (0,0,0 is black and 1,1,1 is white)
	mmAlpha = 1,
	combHide = false,
	alpha = 1,
	top = false,
	coords = true,
	coordSize = 16,
	classbg = false,
	classfont = false,
	insets = 4,
	strata = "BACKGROUND",
	level = 2,
}


local function ClassColors()
	if db.classbg then
		PocketPlot:SetBackdropColor(classColor.r, classColor.g, classColor.b, db.alpha)
	else
		PocketPlot:SetBackdropColor(db.bg.r-.05,db.bg.g-.05,db.bg.b-.05,db.alpha)
	end
	if db.classfont then
		clockTime:SetTextColor(classColor.r, classColor.g, classColor.b)
		coords:SetTextColor(classColor.r, classColor.g, classColor.b)
	else
		clockTime:SetTextColor(1,1,1)
		coords:SetTextColor(1,1,1)
	end
end

local function CombatHide()
	if db.combHide then
		PocketPlot:RegisterEvent("PLAYER_REGEN_ENABLED")
		PocketPlot:RegisterEvent("PLAYER_REGEN_DISABLED")
		PocketPlot:SetScript("OnEvent", function(self,event)
					if event == "PLAYER_REGEN_DISABLED" then
						Minimap:Hide()
					else
						Minimap:Show()
					end
				end)
	else
		PocketPlot:UnregisterEvent("PLAYER_REGEN_ENABLED")
		PocketPlot:UnregisterEvent("PLAYER_REGEN_DISABLED")
	end
end

local function SetShape()
	if db.shape == "Square" then
		Minimap:SetMaskTexture("Interface\\AddOns\\PocketPlot\\media\\mask.blp")
		PocketPlot:SetBackdrop({ bgFile = "Interface\\Buttons\\WHITE8x8" })
		--so minimap buttons follow the square shape instead of round
		GetMinimapShape = function() return "SQUARE" end
	else
		Minimap:SetMaskTexture("Interface\\AddOns\\PocketPlot\\Media\\circle-bg.tga")
		PocketPlot:SetBackdrop({ bgFile = "Interface\\AddOns\\PocketPlot\\Media\\circle-bg.tga" })
		GetMinimapShape = function() return "ROUND" end
	end
end

local function MoveFrames(frame)
	if frame == "None" then
		mover:Hide()
		mover:EnableMouse(0)
		return
	else
		mover:Show()
		moverText:SetText(frame)
		mover:EnableMouse(1)
		mover:ClearAllPoints()
		mover:SetAllPoints(frame)
	end
end

local function SetPosition(frame)
	if mover:IsShown() then
		local r,_,a,x,y = mover:GetPoint()
		--frames lose their reference anchor frame when dragging... :/
		if movershown == "Minimap" then
			p = "UIParent"
		else
			p = "MinimapCluster"
		end
		db[frame] = {["r"]=r, ["p"]="UIParent",["a"]=a,["x"]=x,["y"]=y}
	end
	_G[frame]:ClearAllPoints()
	_G[frame]:SetPoint(db[frame].r, _G[db[frame].p], db[frame].a, db[frame].x, db[frame].y)
	if not _G["PP_old"..frame] then
		_G["PP_old"..frame] = _G[frame].SetPoint
		_G[frame].SetPoint = function(self, a,b,c,d,e, ...)
				local a,b,c,d,e = db[frame].r, _G[db[frame].p], db[frame].a, db[frame].x, db[frame].y
				return _G["PP_old"..frame](self, a,b,c,d,e, ...)
			end
	end
end

local function MapSetup()
	--restore moved frame positions--
	for i=1, #frames do
		if db[frames[i]] then
			SetPosition(frames[i])
		end
	end

--MINIMAP LOCATION AND SIZE
	Minimap:SetScale(db.scale)	--this says that the minimap is set to 90% scale
	Minimap:SetFrameStrata(db.strata)
	Minimap:SetFrameLevel(db.level)
	Minimap:SetAlpha(db.mmAlpha)
		
--ZONE TEXT
	MinimapZoneTextButton:SetParent("Minimap")
	MinimapZoneTextButton:SetPoint("TOP", Minimap, "TOP", 0, -1)	--where the zone text is located
	MinimapZoneTextButton:SetFrameLevel(5)
	MinimapZoneText:SetFont(LSM:Fetch("font", db.lsmfont), db.zoneSize, db.fontFlag)	--font and font size for zone text
	if not db.zoneText then
		MinimapZoneTextButton:Hide()
	end

--MINIMAP ICONS/BLIPS
	Minimap:SetBlipTexture(blips)	--custom texture for blips

--MAKE THE MINIMAP SQUARE WITH A THIN BORDER
	MinimapBorder:Hide()
	SetShape()
	PocketPlot:SetFrameLevel(1)
	PocketPlot:SetPoint("CENTER", Minimap, "CENTER")
	local dims = Minimap:GetWidth()
	PocketPlot:SetHeight(dims + db.insets)
	PocketPlot:SetWidth(dims + db.insets)

--MAKE THE MINIMAP ZOOM WITH MOUSEWHEEL
	MinimapZoomIn:Hide()
	MinimapZoomOut:Hide()
	Minimap:EnableMouseWheel(true)
	Minimap:SetScript("OnMouseWheel", function(_, zoom)
			if zoom > 0 then
				Minimap_ZoomIn()
			else
				Minimap_ZoomOut()
			end
		end)

--CLOCK FRAME
	if not IsAddOnLoaded("Blizzard_TimeManager") then
		LoadAddOn("Blizzard_TimeManager")
	end
	clockFrame, clockTime = TimeManagerClockButton:GetRegions()
	clockFrame:Hide()
	clockTime:SetFont(LSM:Fetch("font", db.lsmfont), db.clockSize, db.fontFlag)

--CALENDAR BUTTON/FRAME
	GameTimeFrame:SetAlpha(0)	--calendar button (old day/night indicator)  --Set alpha to 0 so that it's still hidden, but we'll see the ? flash for new invites
	GameTimeFrame:EnableMouse(false)	--so that we don't get the tooltip/click behavior still
	GameTimeCalendarInvitesTexture:SetParent("Minimap")	 --the ? texture
	--right click to open the calendar (but do it without pinging the map)
	local oldOnClick = Minimap:GetScript("OnMouseUp")
	Minimap:SetScript("OnMouseUp", function(self, click)
				if click == "RightButton" then
					if not CalendarFrame then
						LoadAddOn("Blizzard_Calendar")
					end
					if CalendarFrame:IsShown() then
						CalendarFrame:Hide()
					else
						CalendarFrame:Show()
					end
					return
				end
				oldOnClick(self)
			end)
	
--TRACKING ICON/MENU
	MiniMapTrackingButton:SetAlpha(0)
	MiniMapTrackingBackground:Hide()
	MiniMapTracking:ClearAllPoints()
	MiniMapTracking:SetPoint("BOTTOMLEFT", Minimap, "BOTTOMLEFT", -4, -5)	--where the tracking icon/menu is located
	MiniMapTracking:SetScale(.9)
	MiniMapTrackingIcon:SetTexCoord(0.07,0.93,0.07,0.93)

--BATTLEGROUND QUEUE ICON
	MiniMapBattlefieldBorder:Hide()
	MiniMapBattlefieldFrame:ClearAllPoints()
	MiniMapBattlefieldFrame:SetPoint("BOTTOM", Minimap, "BOTTOM", 2, -3)	--where the battleground icon is located

--NEW MAIL ICON
	MiniMapMailBorder:Hide()
	MiniMapMailFrame:ClearAllPoints()
	MiniMapMailFrame:SetPoint("BOTTOMRIGHT", Minimap, "BOTTOMRIGHT", 4, -5)	--where the mail icon is located
	MiniMapMailIcon:SetTexture("Interface\\Minimap\\Tracking\\Mailbox.blp")

--VOICE CHAT ICON
	MiniMapVoiceChatFrameBorder:Hide()
	MiniMapVoiceChatFrameBackground:Hide()
	MiniMapVoiceChatFrame:ClearAllPoints()
	MiniMapVoiceChatFrame:SetPoint("BOTTOMRIGHT", Minimap, "BOTTOMRIGHT", -25, -5)

--LFG ICON
	MiniMapLFGFrameBorder:Hide()
	MiniMapLFGFrame:ClearAllPoints()
	MiniMapLFGFrame:SetPoint("BOTTOMLEFT", Minimap, "BOTTOMLEFT", 27, -4)
	
--MISC. THINGS TO HIDE
	MiniMapWorldMapButton:Hide()	--default keybinding for world map is M
	MinimapNorthTag:SetAlpha(0)	--Hide() wasn't working, but SetAlpha() is...
	MinimapBorderTop:Hide()
	
	CombatHide()	--Check to see if we should hide the minimap in combat
	
	MinimapCluster:EnableMouse(false)	--so you can still click the game world/turn in the upper right corner

--COORDINATES
	coords:SetFont(LSM:Fetch("font",db.lsmfont), db.coordSize, db.fontFlag)
	if db.coords then
		coordframe:Show()
	else
		coordframe:Hide()
	end
	
--COLOR BORDER AND CLOCK/COORDS BY CLASS IF ENABLED
	ClassColors()
end

local function CoordPosition()
	local clockshown = TimeManagerClockButton:IsShown()
	local coordshown = coordframe:IsShown()
	TimeManagerClockButton:ClearAllPoints()
	coords:ClearAllPoints()
	coordframe:ClearAllPoints()
	if not db.top then
		if clockshown and not coordshown then
			TimeManagerClockButton:SetPoint("TOP", Minimap, "BOTTOM", 0, 0)
		end
		if coordshown and not clockshown then
			coords:SetPoint("CENTER")
			coordframe:SetPoint("TOP", Minimap, "BOTTOM", 0, 0)
		end
		if clockshown and coordshown then
			TimeManagerClockButton:SetPoint("TOPLEFT", Minimap, "BOTTOMLEFT", -10, 0)
			coords:SetPoint("RIGHT")
			coordframe:SetPoint("TOPRIGHT", Minimap, "BOTTOMRIGHT", 0, 0)
		end
	else
		if clockshown and not coordshown then
			TimeManagerClockButton:SetPoint("BOTTOM", Minimap, "TOP", 0, 0)
		end
		if coordshown and not clockshown then
			coords:SetPoint("CENTER")
			coordframe:SetPoint("BOTTOM", Minimap, "TOP", 0, 0)
		end
		if clockshown and coordshown then
			TimeManagerClockButton:SetPoint("BOTTOMLEFT", Minimap, "TOPLEFT", -10, 0)
			coords:SetPoint("RIGHT")
			coordframe:SetPoint("BOTTOMRIGHT", Minimap, "TOPRIGHT", 0, 0)
		end
	end
end

local function SetUpDB()
	if PocketPlotPCDB.charSpec then
		--set defaults if new charSpec DB
		for k,v in pairs(defaults) do
			if type(PocketPlotPCDB[k]) == "nil" then
				PocketPlotPCDB[k] = v
			end
		end
		db = PocketPlotPCDB
	else
		db = PocketPlotDB
	end
end


options = {
	name = "PocketPlot Options",
	type = "group",
	args = {
		header0 = {
			name = "General options",
			type = "header",
			order = 0,
		},
		shape = {
			name = "Minimap Shape",
			desc = "Set the shape of the minimap.",
			type = "select",
			values = shapes,
			get = function()
						for k, v in pairs(shapes) do
							if db.shape == v then
								return k
							end
						end
					end,
			set = function(_,key)
						db.shape = shapes[key]
						SetShape()
						ClassColors()
					end,
			order = 0.1,
		},
		scale = {
			name = "Minimap Scale",
			desc = "Set the scale of the minimap.",
			type = "range",
			min = .25,
			max = 2,
			step = .05,
			get = function() return db.scale end,
			set = function(_,value)
						db.scale = value
						Minimap:SetScale(value)
					end,
			order = 0.2,
		},
		mmAlpha = {
			name = "Minimap Alpha",
			desc = "Set the transparency of the minimap.",
			type = "range",
			min = 0.05,
			max = 1,
			step = .05,
			get = function() return db.mmAlpha end,
			set = function(_,value)
						db.mmAlpha = value
						Minimap:SetAlpha(value)
					end,
			order = 0.25,
		},
		combHide = {
			name = "Hide in Combat",
			desc = "Hide the minimap when in combat.",
			type = "toggle",
			get = function() return db.combHide end,
			set = function()
						db.combHide = not db.combHide
						CombatHide()
					end,
			order = 0.275,
		},
		strata = {
			name = "Minimap Strata",
			desc = "Set the strata of the minimap and how it layers with other elements in your interface.",
			type = "select",
			values = stratae,
			get = function()
						for k, v in pairs(stratae) do
							if db.strata == v then
								return k
							end
						end
					end,
			set = function(_,key)
						db.strata = stratae[key]
						Minimap:SetFrameStrata(db.strata)
					end,
			order = 0.3,
		},
		level = {
			name = "Strata Level",
			desc = "Nudge the minimap up and down different levels on its frame strata.",
			type = "range",
			min = 1,
			max = 10,
			step = 1,
			get = function() return db.level end,
			set = function(_,value)
						db.level = value
						Minimap:SetFrameLevel(db.level)
					end,
			order = 0.4,
		},
		header1 = {
			name = "Border options",
			type = "header",
			order = 0.5,
		},
		border = {
			name = "Border Color",
			desc = "Select a color for the minimap's border.",
			type = "color",
			disabled = function() return db.classbg 	end,
--			hasAlpha = true,
			get = function() return db.bg.r, db.bg.g, db.bg.b end,
			set = function(_,r,g,b)
						db.bg.r,db.bg.g,db.bg.b = r,g,b
						ClassColors()
					end,
			order = 1,
		},
		classbg = {
			name = "Class colored border",
			desc = "Color the minimap border by your class.",
			type = "toggle",
			get = function() return db.classbg end,
			set = function()
						db.classbg = not db.classbg
						ClassColors()
					end,
			order = 2,
		},
		insets = {
			name = "Border size",
			desc = "Set the width of the border around the minimap.",
			type = "range",
			min = .5,
			max = 10,
			step = .5,
			get = function() return db.insets end,
			set = function(_,value)
						db.insets = value
						local dims = Minimap:GetWidth()
						PocketPlot:SetHeight(dims + value)
						PocketPlot:SetWidth(dims + value)
					end,
			order = 3,
		},
		alpha = {
			name = "Border Alpha",
			desc = "Set the alpha for the minimap border.",
			type = "range",
			min = 0,
			max = 1,
			step = .05,
			get = function() return db.alpha end,
			set = function(_,alpha)
						db.alpha = alpha
						ClassColors()
					end,
			order = 3.5,
		},
--		div1 = {
--			name = " ",
--			type = "description",
--			order = 4,
--		},
		header2 = {
			name = "Text options",
			type = "header",
			order = 5,
		},
		font = {
			name = "Font",
			desc = "Select a font to use.",
			type = "select",
			values = fonts,
			get = function()
						for k,v in pairs(fonts) do
							if v == db.lsmfont then
								return k
							end
						end
					end,
			set = function(_,font)
						db.lsmfont = fonts[font]
						clockTime:SetFont(LSM:Fetch("font", db.lsmfont), db.clockSize, db.fontFlag)
						MinimapZoneText:SetFont(LSM:Fetch("font", db.lsmfont), db.zoneSize, db.fontFlag)
						coords:SetFont(LSM:Fetch("font",db.lsmfont), db.coordSize, db.fontFlag)
					end,
			order = 6,
		},
		fontFlag = {
			name = "Font Flag",
			desc = "Set how to alter the displayed font.",
			type = "select",
			values = fontFlags,
			get = function()
						for k, v in pairs(fontFlags) do
							if db.fontFlag == v then
								return k
							end
						end
					end,
			set = function(_,key)
						db.fontFlag = fontFlags[key]
						clockTime:SetFont(LSM:Fetch("font", db.lsmfont), db.clockSize, db.fontFlag)
						MinimapZoneText:SetFont(LSM:Fetch("font", db.lsmfont), db.zoneSize, db.fontFlag)
						coords:SetFont(LSM:Fetch("font",db.lsmfont), db.coordSize, db.fontFlag)
					end,
			order = 6.5,
		},
		zonesize = {
			name = "Zone Text Size",
			desc = "Change the font size of the Zone Text.",
			type = "range",
			min = 6,
			max = 24,
			step = 1,
			get = function() return db.zoneSize end,
			set = function(_,size) 
						db.zoneSize = size
						MinimapZoneText:SetFont(LSM:Fetch("font",db.lsmfont), db.zoneSize, db.fontFlag)
					end,
			order = 7,
		},
		clocksize = {
			name = "Clock Text Size",
			desc = "Change the font size of the clock.",
			type = "range",
			min = 6,
			max = 24,
			step = 1,
			get = function() return db.clockSize end,
			set = function(_,size) 
						db.clockSize = size
						clockTime:SetFont(LSM:Fetch("font",db.lsmfont), db.clockSize, db.fontFlag)
					end,
			order = 8,
		},
		coordsize = {
			name = "Coords Text Size",
			desc = "Change the font size of the coordinates.",
			type = "range",
			min = 6,
			max = 24,
			step = 1,
			get = function() return db.coordSize end,
			set = function(_,size) 
						db.coordSize = size
						coords:SetFont(LSM:Fetch("font",db.lsmfont), db.coordSize, db.fontFlag)
					end,
			order = 9,
		},
		classfont = {
			name = "Class colored text",
			desc = "Color the clock and coordinates by your class.",
			type = "toggle",
			get = function() return db.classfont end,
			set = function()
						db.classfont = not db.classfont
						ClassColors()
					end,
			order = 10,
		},
		coords = {
			name = "Display coords",
			desc = "Toggle showing the coordinates display.",
			type = "toggle",
			get = function() return db.coords end,
			set = function()
						db.coords = not db.coords
						if db.coords then
							coordframe:Show()
						else
							coordframe:Hide()
						end
						CoordPosition()
					end,
			order = 11,
		},
		zoneText = {
			name = "Display zone text",
			desc = "Toggle showing the zone text.",
			type = "toggle",
			get = function() return db.zoneText end,
			set = function()
						db.zoneText = not db.zoneText
						if db.zoneText then
							MinimapZoneTextButton:Show()
						else
							MinimapZoneTextButton:Hide()
						end
					end,
			order = 12,
		},
		top = {
			name = "Clock/coords on top",
			desc = "Toggle showing the clock and coordinates above or below the map.",
			type = "toggle",
			get = function() return db.top end,
			set = function()
						db.top = not db.top
						CoordPosition()
					end,
			order = 13,
		},
--		div2 = {
--			name = " ",
--			type = "description",
--			order = 13,
--		},
		header3 = {
			name = "Frame Locations",
			type = "header",
			order = 14,
		},
		movers = {
			name = "Enable mover for...",
			desc = "Shows an anchor to move the selected frame.",
			type = "select",
			values = frames,
			get = function()
						if movershown then
							for k,v in pairs(frames) do
								if v == movershown then
									return k
								end
							end
						else
							return 5	--key for "None" in frames table
						end
					end,
			set = function(_,frame)
						movershown = frames[frame]
						MoveFrames(movershown)
					end,
			order = 15,
		},
		reset = {
			name = "Restore Positions",
			desc = "Clicking this will restore all frames to their default positions.\n\n|c00E30016WARNING:|r Your UI will be reloaded in the process!",
			type = "execute",
			confirm = true,
			func = function()
						for i=1, #frames do
							db[frames[i]] = nil
						end
						ReloadUI()
					end,
			order = 16,
		},
		nudgeL = {
			name = "Left",
			desc = "Nudge the frame 1px to the left.",
			type = "execute",
			width = "half",
			disabled = function() return movershown == "None" or movershown == nil end,
			func = function()
						if not db[movershown] then
							SetPosition(movershown)
						end
						local frame = _G[movershown]
						db[movershown].x = db[movershown].x - 1
						frame:ClearAllPoints()
						frame:SetPoint(db[movershown].r, db[movershown].p, db[movershown].a, db[movershown].x, db[movershown].y)
						mover:ClearAllPoints()
						mover:SetAllPoints(frame)
					end,
			order = 17,
		},
		nudgeR = {
			name = "Right",
			desc = "Nudge the frame 1px to the right.",
			type = "execute",
			width = "half",
			disabled = function() return movershown == "None" or movershown == nil end,
			func = function()
						if not db[movershown] then
							SetPosition(movershown)
						end
						local frame = _G[movershown]
						db[movershown].x = db[movershown].x + 1
						frame:ClearAllPoints()
						frame:SetPoint(db[movershown].r, db[movershown].p, db[movershown].a, db[movershown].x, db[movershown].y)
						mover:ClearAllPoints()
						mover:SetAllPoints(frame)
					end,
			order = 18,
		},
		nudgeU = {
			name = "Up",
			desc = "Nudge the frame 1px towards the top of the screen.",
			type = "execute",
			width = "half",
			disabled = function() return movershown == "None" or movershown == nil end,
			func = function()
						if not db[movershown] then
							SetPosition(movershown)
						end
						local frame = _G[movershown]
						db[movershown].y = db[movershown].y + 1
						frame:ClearAllPoints()
						frame:SetPoint(db[movershown].r, db[movershown].p, db[movershown].a, db[movershown].x, db[movershown].y)
						mover:ClearAllPoints()
						mover:SetAllPoints(frame)
					end,
			order = 19,
		},
		nudgeD = {
			name = "Down",
			desc = "Nudge the frame 1px towards the bottom of the screen.",
			type = "execute",
			width = "half",
			disabled = function() return movershown == "None" or movershown == nil end,
			func = function()
						if not db[movershown] then
							SetPosition(movershown)
						end
						local frame = _G[movershown]
						db[movershown].y = db[movershown].y - 1
						frame:ClearAllPoints()
						frame:SetPoint(db[movershown].r, db[movershown].p, db[movershown].a, db[movershown].x, db[movershown].y)
						mover:ClearAllPoints()
						mover:SetAllPoints(frame)
					end,
			order = 20,
		},
		div3 = {
			name = " ",
			type = "description",
			order = 21,
		},
		header4 = {
			name = "Profile",
			type = "header",
			order = 22,
		},
--[[		warning = {
			name = "\n|c00E30016WARNING:|r Changing any of the following options will cause your UI to be reloaded in the process!\n",
			type = "description",
			order = 22.5,
		},]]--
		charSpec = {
			name = "Character specific settings",
			desc = "Have this character use their own profile.  If checked, any changes made will not affect other characters.\n\n|c00E30016WARNING:|r Your UI will be reloaded in the process!",
			type = "toggle",
			width = "full",
			confirm = true,
			get = function() return PocketPlotPCDB.charSpec end,
			set = function()
						PocketPlotPCDB.charSpec = not PocketPlotPCDB.charSpec
						ReloadUI()
					end,
			order = 23,
		},
		copyProfile = {
			name = "Copy from Default",
			desc = "Copy all settings from the default, global profile to this character's profile.  This will not effect other characters' specific profiles.\n\n|c00E30016WARNING:|r Your UI will be reloaded in the process!",
			type = "execute",
			confirm = true,
			disabled = function() return not PocketPlotPCDB.charSpec end,
			func = function()
						PocketPlotPCDB = PocketPlotDB
						PocketPlotPCDB.charSpec = true
						ReloadUI()
					end,
			order = 24,
		},
		resetProfile = {
			name = "Profile Reset",
			desc = "Reset this profile back to the out-of-the-box settings.  If you reset the character specific profile, the global profile will be untouched, and vice versa.  This will not effect other character specific profiles.\n\n|c00E30016WARNING:|r Your UI will be reloaded in the process!",
			type = "execute",
			confirm = true,
			func = function()
						if PocketPlotPCDB.charSpec then
							PocketPlotPCDB = {charSpec = true}
						else
							PocketPlotDB = {}
						end
						ReloadUI()
					end,
			order = 25,
		},
	},
}


local function PlayerLogin()
	PocketPlotDB = PocketPlotDB or {}
	PocketPlotPCDB = PocketPlotPCDB or {}
		if PocketPlotPCDB.charSpec == nil then
			PocketPlotPCDB.charSpec = false
		end
	for k,v in pairs(defaults) do
	    if type(PocketPlotDB[k]) == "nil" then
	        PocketPlotDB[k] = v
	    end
	end
	SetUpDB()
	
	classColor = CUSTOM_CLASS_COLORS and CUSTOM_CLASS_COLORS[class] or RAID_CLASS_COLORS[class]
	
	if CUSTOM_CLASS_COLORS then
		CUSTOM_CLASS_COLORS:RegisterCallback(ClassColors)
	end

	LibStub("AceConfig-3.0"):RegisterOptionsTable("PocketPlot", options)
	PocketPlot.optionsFrame = LibStub("AceConfigDialog-3.0"):AddToBlizOptions("PocketPlot", "PocketPlot")
	SlashCmdList["POCKETPLOT"] = function() InterfaceOptionsFrame_OpenToCategory("PocketPlot") end
	SLASH_POCKETPLOT1 = "/pocketplot"
	SLASH_POCKETPLOT2 = "/pp"
	
	MapSetup()
	
--	--restore moved frame positions--
--	for i=1, #frames do
--		if db[frames[i]] then
--			SetPosition(frames[i])
--		end
--	end
	
	--is here because it wasn't working down below for some odd reason...--
	TimeManagerClockButton:SetScript("OnHide", CoordPosition)
	TimeManagerClockButton:SetScript("OnShow", CoordPosition)
	
	PocketPlot:UnregisterEvent("PLAYER_LOGIN")
end

--this is here instead of in the above function because Grid would throw some dumb error that shouldn't have been occuring, imo
LSM:Register("font", "Blue Highway", "Interface\\AddOns\\PocketPlot\\media\\BLUEHIGH.ttf")


mover:SetScript("OnMouseDown", function() mover:StartMoving() end)
mover:SetScript("OnMouseUp", function() mover:StopMovingOrSizing() SetPosition(movershown) end)
coordframe:SetScript("OnEnter", function(self)
			GameTooltip:SetOwner(self, "ANCHOR_LEFT")
			GameTooltip:AddLine("Click to display the world map.")
			GameTooltip:AddLine("Shift-click to input your coordinates into chat.")
			GameTooltip:Show()
		end)
coordframe:SetScript("OnLeave", function() GameTooltip:Hide() end)
coordframe:SetScript("OnMouseUp", function()
			if IsShiftKeyDown() then
				ChatFrameEditBox:Insert("["..coords:GetText().."]")
			elseif WorldMapFrame:IsShown() then
				WorldMapFrame:Hide()
			else
				WorldMapFrame:Show()
			end
		end)
coordframe:SetScript("OnUpdate", function()
			local coordx,coordy = GetPlayerMapPosition("player")
			coords:SetFormattedText("%.1f/%.1f", coordx*100, coordy*100)
		end)
coordframe:SetScript("OnEvent", function(self)
			if db.coords then
				if IsInInstance() then
					self:Hide()
				else
					self:Show()
				end
				CoordPosition()
			end
		end)
PocketPlot:SetScript("OnEvent", PlayerLogin)

coordframe:RegisterEvent("PLAYER_ENTERING_WORLD")
PocketPlot:RegisterEvent("PLAYER_LOGIN")
