-- Title: SLDataText
-- Version: 2.05
-- Revision Date: October 20, 2008
-- Author: Jeff "Taffu" Fancher
-- Notes: Beta
-- Copyright 2008 Jeff Fancher (GPLv3)
----------------------------------------------

local _G = getfenv(0)
local DT = CreateFrame("Frame", "SLDataText")
local L = DT_FetchLocaleList()
DT.Media = LibStub("LibSharedMedia-3.0")
DT.Tablet = LibStub("Tablet-2.0")
local db

DT.fontList = { }
DT.modules = { }
DT.justTable = { ["LEFT"] = L["Left"], ["CENTER"] = L["Center"], ["RIGHT"] = L["Right"], }
DT.strataTable = {
    ["PARENT"] = L["Parent"],
    ["BACKGROUND"] = L["Background"],
    ["LOW"] = L["Low"],
    ["MEDIUM"] = L["Medium"],
    ["HIGH"] = L["High"],
    ["DIALOG"] = L["Dialog"],
}
DT.pointTable = {
    ["LEFT"] = L["Left"],
    ["CENTER"] = L["Center"],
    ["RIGHT"] = L["Right"],
    ["BOTTOM"] = L["Bottom"],
    ["BOTTOMLEFT"] = L["Bottom Left"],
    ["BOTTOMRIGHT"] = L["Bottom Right"],
    ["TOP"] = L["Top"],
    ["TOPLEFT"] = L["Top Left"],
    ["TOPRIGHT"] = L["Top Right"],
}
DT.classColors = {
    ["DEATHKNIGHT"] = "|cffc41f3b",
    ["DRUID"] = "|cffff7d0a",
    ["HUNTER"] = "|cffabd473",
    ["MAGE"] = "|cff69ccf0",
    ["PALADIN"] = "|cfff58cba",
    ["PRIEST"] = "|cffffffff",
    ["ROGUE"] = "|cfffff569",
    ["SHAMAN"] = "|cff2459ff",
    ["WARLOCK"] = "|cff9482ca",
    ["WARRIOR"] = "|cffc79c6e",
}
DT.classColor = DT.classColors[select(2, UnitClass("player"))]

function DT:Debug(msg)
    ChatFrame1:AddMessage(msg)
end

function DT:CheckEnabledState(module)
    if ( not module ) then return end
    local state
    if ( module.db ) then state = module.db.profile.enabled end
    if ( state ) then
        if ( not module:IsShown() and not InCombatLockdown() ) then module:Show() end
    else
        if ( module:IsShown() ) then module:Hide() end
    end
    return state
end

function DT:FetchFont(modFont)
    local font = self.Media:Fetch("font", modFont)
    return font
end

function DT:FetchFontList()
    local fontList
    fontList = self.Media:List("font")
    return fontList
end

function DT:Refresh()
    for key, val in pairs(self.modules) do
        self:ModuleUpdate(val[2], val[2].db.profile)
    end
end

function DT:MakeSlashCmd(...)
	local global = string.upper(self:GetName())
	SlashCmdList[global] = function() LibStub("AceConfigDialog-3.0"):Open("SLDataText") end
	for i = 1,select("#",...) do
		local slash = select(i,...)
		setglobal("SLASH_"..global..i,slash)
	end
end

function DT:PLAYER_REGEN_ENABLED()
    for key, val in pairs(self.modules) do
        if ( not InCombatLockdown() and val[2].db.profile.enabled ) then
            val[2]:Show()
        end
    end
end

function DT:PLAYER_REGEN_DISABLED()
    if ( db.hideInCombat ) then
        for key, val in pairs(self.modules) do
            if ( not val[2].db.profile.noCombatHide ) then
                val[2]:Hide()
            end
        end
    end
end

function DT:SmallUpdate(module, modDB)
    if ( not module ) then return end
    if ( not self:CheckEnabledState(module) ) then return end
    module:UpdateStats()
    module:SetWidth(module.string:GetWidth())
    module:SetHeight(module.string:GetHeight())
    if ( module.button ) then module.button:SetAllPoints(module) end
end

function DT:TextUpdate(module, modDB)
    if ( not module ) then return end
    if ( not self:CheckEnabledState(module) ) then return end
    local font, size
    if ( modDB.useGlobalFont ) then
        font = db.gFont
    else
        font = modDB.fontFace
    end
    if ( modDB.useGlobalFontSize ) then
        size = db.gFontSize
    else
        size = modDB.fontSize
    end
    module.string:SetFont(self:FetchFont(font), size)
    module.string:SetShadowColor(0, 0, 0, 1)
    module.string:SetShadowOffset(1, -1)
    module:UpdateStats()
end

function DT:FrameUpdate(module, modDB)
    if ( not module ) then return end
    if ( not self:CheckEnabledState(module) ) then return end
    module:UpdateStats()
    if ( module.icon ) then
        module.icon:SetWidth(modDB.iconSize)
        module.icon:SetHeight(modDB.iconSize)
    end
    
    module:SetWidth(module.string:GetWidth())
    module:SetHeight(module.string:GetHeight())
    if ( module.button ) then module.button:SetAllPoints(module) end
    
    module:EnableMouse(true)
    module:SetFrameStrata(modDB.strata)
    
    if ( not db.locked ) then
        if ( module.button ) then module.button:EnableMouse(false) end
        module:SetBackdropColor(0, 0, 0, 1)
        module:SetMovable(true)
        module:RegisterForDrag("LeftButton")
        module:SetScript("OnMouseDown", function()
            self:MoveFrame(module, modDB)
        end)
        module:SetScript("OnMouseUp", function()
            self:StopFrame(module, modDB)
        end)
    else
        if ( module.button ) then module.button:EnableMouse(true) end
        module:SetBackdropColor(0, 0, 0, 0)
        module:SetMovable(false)
        module:RegisterForDrag("LeftButton")
        module:SetScript("OnMouseDown", nil)
        module:SetScript("OnMouseUp", nil)
    end
    
    if ( not module.isMoving ) then
        module:ClearAllPoints()
        module:SetPoint(modDB.justify, modDB.pos.anchor, modDB.pos.anchorFrom, modDB.pos.offX, modDB.pos.offY)
        module.string:ClearAllPoints()
        module.string:SetPoint(modDB.justify, module, modDB.justify, 0, 0)
        if ( module.icon ) then
            module.icon:ClearAllPoints()
            module.icon:SetPoint(modDB.justify, module, modDB.justify, 0, 0)
        end
    end
end

function DT:ModuleUpdate(module, modDB)
    if ( not module ) then return end
    if ( not self:CheckEnabledState(module) ) then return end
    
    module:SetBackdrop({
        bgFile = "Interface\\Tooltips\\UI-Tooltip-Background", tile = true, tileSize = 16,
        insets = { left = 0, top = 0, right = 0, bottom = 0 },
    })
    
    local font, size
    if ( modDB.useGlobalFont ) then
        font = db.gFont
    else
        font = modDB.fontFace
    end
    if ( modDB.useGlobalFontSize ) then
        size = db.gFontSize
    else
        size = modDB.fontSize
    end
    module.string:SetFont(self:FetchFont(font), size)
    module.string:SetShadowColor(0, 0, 0, 1)
    module.string:SetShadowOffset(1, -1)
    
    module:UpdateStats()
    if ( module.icon ) then
        module.icon:SetWidth(modDB.iconSize)
        module.icon:SetHeight(modDB.iconSize)
    end
    module:SetWidth(module.string:GetWidth())
    module:SetHeight(module.string:GetHeight())
    if ( module.button ) then module.button:SetAllPoints(module) end
    
    module:EnableMouse(true)
    module:SetFrameStrata(modDB.strata)
    
    if ( not db.locked ) then
        if ( module.button ) then module.button:EnableMouse(false) end
        module:SetBackdropColor(0, 0, 0, 1)
        module:SetMovable(true)
        module:RegisterForDrag("LeftButton")
        module:SetScript("OnMouseDown", function()
            self:MoveFrame(module, modDB)
        end)
        module:SetScript("OnMouseUp", function()
            self:StopFrame(module, modDB)
        end)
    else
        if ( module.button ) then module.button:EnableMouse(true) end
        module:SetBackdropColor(0, 0, 0, 0)
        module:SetMovable(false)
        module:RegisterForDrag("LeftButton")
        module:SetScript("OnMouseDown", nil)
        module:SetScript("OnMouseUp", nil)
    end
    
    if ( not module.isMoving ) then
        module:ClearAllPoints()
        module:SetPoint(modDB.justify, modDB.pos.anchor, modDB.pos.anchorFrom, modDB.pos.offX, modDB.pos.offY)
        module.string:ClearAllPoints()
        module.string:SetPoint(modDB.justify, module, modDB.justify, 0, 0)
        if ( module.icon ) then
            module.icon:ClearAllPoints()
            module.icon:SetPoint(modDB.justify, module, modDB.justify, 0, 0)
        end
    end
end

--[[ Movement Functions ]]

function DT:MoveFrame(module, modDB)
    module:SetPoint(modDB.justify, modDB.pos.anchor, modDB.pos.anchorFrom, modDB.pos.offX, modDB.pos.offY)
    module.isMoving = true
    if ( not db.locked ) then module:StartMoving() else end
end

function DT:StopFrame(module, modDB)
    module:StopMovingOrSizing()
    module.isMoving = false
    local aP, _, aF, x, y = module:GetPoint()
    local anchor = module:GetParent():GetName()
    local xoff, yoff = TranslateCoords(module, modDB.justify, aF, x, y)
    
    modDB.pos.anchorPoint, modDB.pos.anchor, modDB.pos.anchorFrom, modDB.pos.offX, modDB.pos.offY = modDB.justify, anchor, aF, floor(xoff), floor(yoff)
end

function TranslateCoords(module, just, aF, x, y)
    local y1, x1
    
    if      ( aF == "TOP" or aF == "TOPLEFT" or aF == "TOPRIGHT" ) then                               y1 = module:GetHeight()/2; y = y - y1
    elseif  ( aF == "BOTTOM" or aF == "BOTTOMLEFT" or aF == "BOTTOMRIGHT" ) then                      y1 = module:GetHeight()/2; y = y + y1 end
    
    if      ( just == "RIGHT" and (aF == "TOPRIGHT" or aF == "RIGHT" or aF == "BOTTOMRIGHT") ) then   x = x
    elseif  ( just == "RIGHT" and (aF == "TOPLEFT" or aF == "LEFT" or aF == "BOTTOMLEFT") ) then      x1 = module:GetWidth(); x = x + x1
    elseif  ( just == "RIGHT" and (aF == "CENTER" or aF == "TOP" or aF == "BOTTOM") ) then            x1 = module:GetWidth()/2; x = x + x1
    elseif  ( just == "LEFT" and (aF == "TOPRIGHT" or aF == "RIGHT" or aF == "BOTTOMRIGHT") ) then    x1 = module:GetWidth(); x = x - x1
    elseif  ( just == "LEFT" and (aF == "TOPLEFT" or aF == "LEFT" or aF == "BOTTOMLEFT") ) then       x = x
    elseif  ( just == "LEFT" and (aF == "CENTER" or aF == "TOP" or aF == "BOTTOM") ) then             x1 = module:GetWidth()/2; x = x - x1
    elseif  ( just == "CENTER" and (aF == "TOPLEFT" or aF == "LEFT" or aF == "BOTTOMLEFT") ) then     x1 = module:GetWidth()/2; x = x + x1
    elseif  ( just == "CENTER" and (aF == "TOPRIGHT" or aF == "RIGHT" or aF == "BOTTOMRIGHT") ) then  x1 = module:GetWidth()/2; x = x - x1
    elseif  ( just == "CENTER" and (aF == "CENTER" or aF == "TOP" or aF == "BOTTOM") ) then           x = x end
    
    return x, y
end

DT.options = {
    type = "group",
	name = L["SLDataText"],
    plugins = {},
    childGroups = "tree",
	args = {
        general = {
            type = "group",
            name = L["GenSet"],
            guiInline = true,
            args = {
                locked = {
                    type = "toggle",
                    name = L["LockEle"],
                    desc = L["LockEleDesc"],
                    get = function() return db.locked end,
                    set = function() db.locked = not db.locked DT:Refresh() end,
                    order = 100,
                },
                hideInCombat = {
                    type = "toggle",
                    name = L["HIC"],
                    desc = L["HICDesc"],
                    get = function() return db.hideInCombat end,
                    set = function() db.hideInCombat = not db.hideInCombat DT:Refresh() end,
                    order = 200,
                },
                classColored = {
                    type = "toggle",
                    name = L["ClassColGbl"],
                    desc = L["ClassColGblDesc"],
                    get = function() return db.classColored end,
                    set = function() db.classColored = not db.classColored DT:Refresh() end,
                    order = 300,
                },
            },
        },
        global = {
            type = "group",
            name = L["GblOpts"],
            order = 1,
            args = {
                desc = {
                    type = "description",
                    name = L["GblFontDesc"],
                    order = 1,
                },
                gblFontHeader = {
                    type = "header",
                    name = L["GblFontSet"],
                    order = 50,
                },
                gFont = {
                    type = "select",
                    name = L["GblFont"],
                    desc = L["GblFontDesc"],
                    values = DT:FetchFontList(),
                    get = function()
                        for k, v in pairs(DT.fontList) do
                            if db.gFont == v then
                                return k
                            end
                        end
                    end,
                    set = function(_, font)
                        db.gFont = DT.fontList[font]
                        font = DT:FetchFont(DT.fontList[font])
                        DT:Refresh()
                    end,
                    width = "double",
                    order = 100,
                },
                gFontSize = {
                    type = "range",
                    name = L["GblFontSize"],
                    desc = L["GblFontSizeDesc"],
                    min = 6, max = 36, step = 1,
                    get = function() return db.gFontSize end,
                    set = function(_, val) db.gFontSize = val DT:Refresh() end,
                    width = "double",
                    order = 200,
                },
                moreInfo = {
                    type = "description",
                    name = L["MoreInfo"],
                    order = 300,
                },
            },
        },
    },
}

function DT:OnProfileChange()
    ReloadUI()
    self:Refresh()
end

function DT:PLAYER_LOGIN()
    self.db = LibStub("AceDB-3.0"):New("SLDTDB")
    self.db:RegisterDefaults({
        profile = {
            locked = true,
            hideInCombat = false,
            classColored = true,
            gFont = "Arial Narrow",
            gFontSize = 12,
            modules = {
                ['*'] = true,
            },
        },
    })
    self.db.RegisterCallback(self, "OnProfileChanged", "OnProfileChange")
	self.db.RegisterCallback(self, "OnProfileCopied", "OnProfileChange")
	self.db.RegisterCallback(self, "OnProfileReset", "OnProfileChange")
    
    self.options.args.profile = LibStub("AceDBOptions-3.0"):GetOptionsTable(self.db)
    self.options.args.profile.order = 1000
    db = self.db.profile
    LibStub("AceConfigRegistry-3.0"):RegisterOptionsTable("SLDataText", self.options)       
    self.fontList = self.Media:List("font")
    self:MakeSlashCmd(L["/sldt"], L["/sldatatext"])
    self:UnregisterEvent("PLAYER_LOGIN")
end

DT:SetScript("OnEvent", function(self, event, ...)
    self[event](self, event, ...)
end)

DT:RegisterEvent("PLAYER_LOGIN")
DT:RegisterEvent("PLAYER_REGEN_ENABLED")
DT:RegisterEvent("PLAYER_REGEN_DISABLED")

_G.DT = DT