
-------------------------------------------------------------------------------------
-- Default Theme
-------------------------------------------------------------------------------------

local config = {}
local path = "Interface\\Addons\\TidyPlates\\Artwork"

local vertical = -5
local adjust = -6 -- Adjust Cast Bar distance

config.hitbox = {
	width = 149,
	height = 37,
}

config.healthborder = {
	texture		 =				path.."\\GreyerBorder",
	glowtexture =					path.."\\Highlight",
	elitetexture =					path.."\\GreyerBorderEliteStarSharp",
	width = 128,
	height = 64,
	x = 0,
	y = vertical,
	anchor = "CENTER",
}

config.threatborder = {
	texture =			path.."\\GreyerThreat",
	elitetexture =			path.."\\GreyerThreatElite",
	width = 128,
	height = 64,
	x = 0,
	y = vertical,
	anchor = "CENTER",
}

config.castborder = {
	texture =					path.."\\Cast",
	width = 128,
	height = 64,
	x = 0,
	y = 0 +adjust+vertical,
	anchor = "CENTER",
}

config.castnostop = {
	texture = 				path.."\\NoCast",
	width = 128,
	height = 64,
	x = 0,
	y = 0+adjust+vertical,
	anchor = "CENTER",
}

config.name = {
	typeface =					path.."\\LiberationSans-Regular.ttf",
	size = 9,
	width = 75,
	height = 10,
	x = -13,
	y = 6+vertical,
	align = "LEFT",
	anchor = "CENTER",
	vertical = "BOTTOM",
	shadow = true,
	flags = "NONE",
}

config.level = {
	typeface =					path.."\\LiberationSans-Regular.ttf",
	size = 9,
	width = 25,
	height = 10,
	x = 35,
	y = 6+vertical,
	align = "RIGHT",
	anchor = "CENTER",
	vertical = "BOTTOM",
	shadow = true,
	flags = "NONE",
}

config.healthbar = {
	texture =					 path.."\\Bar",
	height = 12,
	width = 101,
	x = 0,
	y = 15+vertical,
	anchor = "CENTER",
	orientation = "HORIZONTAL",
}

config.castbar = {
	texture =					path.."\\Bar",
	height = 12,
	width = 99,
	x = 0,
	y = -8+adjust+vertical,
	anchor = "CENTER",
	orientation = "HORIZONTAL",
}

config.specialText = {
	typeface =					path.."\\LiberationSans-Regular.ttf",
	size = 9,
	width = 93,
	height = 10,
	x = 0,
	y = 16+vertical,
	align = "RIGHT",
	anchor = "CENTER",
	vertical = "BOTTOM",
	shadow = true,
	flags = "NONE",
}

config.specialText2 = {
	typeface =					path.."\\LiberationSans-Regular.ttf",
	size = 8,
	width = 100,
	height = 10,
	x = 1,
	y = adjust-8+vertical,
	align = "LEFT",
	anchor = "CENTER",
	vertical = "BOTTOM",
	shadow = true,
	flags = "NONE",
}

config.specialArt = {
	width = 24,
	height = 24,
	x = -5,
	y = 15+vertical,
	anchor = "TOP",
}

config.spellicon = {
	width = 24,
	height = 24,
	x = 65,
	y = -11+adjust+vertical,
	anchor = "CENTER",
}

config.raidicon = {
	width = 20,
	height = 20,
	x = -35,
	y = 12+vertical,
	anchor = "TOP",
}

config.dangerskull = {
	width = 18,
	height = 18,
	x = -17,
	y = 10+vertical,
	anchor = "TOP",
}

config.frame = {
	emptyTexture =					path.."\\Empty",
	width = 101,
	height = 45,
	x = 0,
	y = 0+vertical,
	anchor = "CENTER",
}

config.threatcolor = {
	LOW = { r = .75, g = 1, b = 0, a= 1, },
	MEDIUM = { r = 1, g = 1, b = 0, a = 1, },
	HIGH = { r = 1, g = 0, b = 0, a = 1, },
}

config.options = {
	showLevel = true,
	showName = true,
	showSpecialText = false,
	showSpecialText2 = false,
	showSpecialArt = false,
	showDangerSkull = false,
	showspellIcon = true,
	showNostopSpell = true,
	useOnUpdate = false,
	useCustomHealthbarColor = false,
}

TidyPlates.defaultTheme = config
TidyPlates:ActivateTheme(TidyPlates.defaultTheme)

-------------------------------------------------------------------------------------
--  Helpers
-------------------------------------------------------------------------------------
local function copytable(original)
	local duplicate = {}
	for key, value in pairs(original) do
		if type(value) == "table" then duplicate[key] = copytable(value)
		else duplicate[key] = value end
	end
	return duplicate
end

local function mergetable(master, mate)
	local merged = {}
	local matedata
	for key, value in pairs(master) do
		if type(value) == "table" then 
			matedata = mate[key]
			if type(matedata) == "table" then merged[key] = mergetable(value, matedata) 
			else merged[key] = copytable(value) end
		else 
			matedata = mate[key]
			if matedata == nil then merged[key] = master[key] 
			else merged[key] = matedata end
		end
	end
	return merged
end
-------------------------------------------------------------------------------------
--  Default Options
-------------------------------------------------------------------------------------
TidyPlatesOptions = {theme = "Beta Grey"}
local TidyPlatesOptionsDefaults = copytable(TidyPlatesOptions)
local TidyPlatesThemeNames, TidyPlatesThemeIndexes = {}, {}
if not TidyPlatesThemeList then TidyPlatesThemeList = {} end
TidyPlatesThemeNames[1] = "None"
TidyPlatesThemeIndexes["None"] = 1

-------------------------------------------------------------------------------------
-- Auto-Loader
-------------------------------------------------------------------------------------
local function LoadTheme(incomingtheme) 
	local name, theme, style, stylename
	local merged = {}
	-- Load Complete Values
	if type(incomingtheme) == "table" then theme = incomingtheme
	-- Load Partial Values from ThemeList
	elseif type(TidyPlatesThemeList) == "table" then 
		if type(incomingtheme) == 'string' then theme = TidyPlatesThemeList[incomingtheme]; name = incomingtheme
		else name, theme = next(TidyPlatesThemeList) end
	else return end
	
	-- Check for valid theme
	if theme == nil then 
		TidyPlatesOptions.theme = "None"
		TidyPlates:ActivateTheme(TidyPlates.defaultTheme)
		return 
	end
	
	if theme.SetStyle and type(theme.SetStyle) == "function" then
		-- Load Multiplate
		for stylename, style in pairs(theme) do
			if type(style) == "function" then merged[stylename] = style
			elseif type(style) == "table" then merged[stylename] = mergetable(TidyPlates.defaultTheme, style) end
		end
		merged.multiStyle = true
	else 
		-- load Single Plate
		merged = mergetable(TidyPlates.defaultTheme, theme)	
		for stylename, style in pairs(theme) do if type(style) == "function" then merged[stylename] = style end	end
	end
	
	if type(merged) == "table" then TidyPlates:ActivateTheme(merged) end
end

function TidyPlates:ReloadTheme()
	LoadTheme(TidyPlatesOptions.theme)
	TidyPlates:ForceUpdate()
	-- /script TidyPlatesOptions.theme = "Neon"; TidyPlates:ReloadTheme()
end
	
-------------------------------------------------------------------------------------
-- Panel
-------------------------------------------------------------------------------------

local function UpdateThemeNames()
	local themecount = 1
	if type(TidyPlatesThemeList) == "table" then
		for themename, themepointer in pairs(TidyPlatesThemeList) do
			themecount = themecount + 1
			TidyPlatesThemeNames[themecount] = themename
			TidyPlatesThemeIndexes[themename] = themecount
		end
	end
end

local panel = PanelHelpers:CreatePanelFrame( "TidyPlatesInterfaceOptions", "Tidy Plates" )

local function ActivateInterfacePanel()
	---- Note 
	panel.label = panel:CreateFontString(nil, 'ARTWORK', 'GameFontNormal')
	panel.label:SetPoint("TOPLEFT", panel, "TOPLEFT", 20, -45)
	panel.label:SetWidth(325)
	panel.label:SetText("|cFFFFFFFFCustomization of Tidy Plates is done via Theme Packages.  Look for more at Wowinterface.com.")

	-- Theme Chooser
	local dropmenu = {}
	for index, name in pairs(TidyPlatesThemeNames) do dropmenu[index] = {text = name, notCheckable = 1 } end
	panel.dropdown = PanelHelpers:CreateDropdownFrame("TidyPlatesChooserDropdown", panel, dropmenu, 1)
	panel.dropdown:SetPoint("TOPLEFT", 16, -120)
	
	---- Theme Label 
	panel.themelabel = panel:CreateFontString(nil, 'ARTWORK', 'GameFontNormal')
	panel.themelabel:SetPoint("BOTTOMLEFT", panel.dropdown,"TOPLEFT", 20, 5)
	panel.themelabel:SetWidth(170)
	panel.themelabel:SetJustifyH("LEFT")
	panel.themelabel:SetText("Themes:")
	
	panel.apply = CreateFrame("Button", "TidyPlatesApplyButton", panel, "UIPanelButtonTemplate2")
	panel.apply:SetPoint("TOPLEFT",panel.dropdown, "TOPRIGHT", 115, -2)
	panel.apply:SetText("Apply")
	panel.apply:SetWidth(80)
	panel.apply:SetScript("OnClick",function() 
		TidyPlatesOptions.theme = TidyPlatesThemeNames[panel.dropdown.Value]
		LoadTheme(TidyPlatesOptions.theme)
		TidyPlates:ForceUpdate()
	end)
	
	-- Functions
	panel.okay = function () 
		TidyPlatesOptions.theme = TidyPlatesThemeNames[panel.dropdown.Value]
		LoadTheme(TidyPlatesOptions.theme)
		TidyPlates:ForceUpdate()
	end

	panel.refresh = function ()
		panel.dropdown:SetValue(TidyPlatesThemeIndexes[TidyPlatesOptions.theme])
	end

	InterfaceOptions_AddCategory(panel);
end

-------------------------------------------------------------------------------------
-- Auto-Loader
-------------------------------------------------------------------------------------
panel:SetScript("OnEvent", function(self, event) 
	UpdateThemeNames()
	LoadTheme(TidyPlatesOptions.theme)
	ActivateInterfacePanel()
end)
panel:RegisterEvent("PLAYER_LOGIN")

-------------------------------------------------------------------------------------
-- Slash Commands
-------------------------------------------------------------------------------------
TidyPlatesSlashCommands = {}
TidyPlatesSlashCommands.reset = function() print("Tidy Plates: Variables Reset"); TidyPlatesOptions = copytable(TidyPlatesOptionsDefaults); LoadTheme(TidyPlatesOptions.theme) end

function slash_TidyPlates(arg)
	if type(TidyPlatesSlashCommands[arg]) == 'function' then 
		TidyPlatesSlashCommands[arg]() 
		TidyPlates:ForceUpdate()
	else InterfaceOptionsFrame_OpenToCategory(panel);ChatFrame1:AddMessage('Tidy Plates Command-Line;  /tidyplates [reset]') end
end

SLASH_TIDYPLATES1 = '/tidyplates'
SlashCmdList['TIDYPLATES'] = slash_TidyPlates;

