------------------------------------------------------------------
-- Panel Helpers (Used to create interface panels)
------------------------------------------------------------------
PanelHelpers = {}

function PanelHelpers:CreatePanelFrame(reference, title)
	local panelframe = CreateFrame( "Frame", reference, UIParent);
	panelframe.name = title
	panelframe.Label = panelframe:CreateFontString(nil, 'ARTWORK', 'GameFontNormalLarge')
	panelframe.Label:SetPoint("TOPLEFT", panelframe, "TOPLEFT", 16, -16)
	panelframe.Label:SetHeight(15)
	panelframe.Label:SetWidth(350)
	panelframe.Label:SetJustifyH("LEFT")
	panelframe.Label:SetJustifyV("TOP")
	panelframe.Label:SetText(title.." Options")
	return panelframe
end

function PanelHelpers:CreateCheckButton(reference, parent, label)
	local checkbutton = CreateFrame( "CheckButton", reference, parent, "InterfaceOptionsCheckButtonTemplate" )
	_G[reference.."Text"]:SetText(label)
	return checkbutton
end

function PanelHelpers:CreateRadioButtons(reference, parent, numberOfButtons, defaultButton, spacing, list)
	local index
	local radioButtonSet = {}
	
	for index = 1, numberOfButtons do
		radioButtonSet[index] = CreateFrame( "CheckButton", reference..index, parent, "UIRadioButtonTemplate" )
		radioButtonSet[index].Label = _G[reference..index.."Text"]
		radioButtonSet[index].Label:SetText(list[index] or " ")
		radioButtonSet[index].Label:SetWidth(250)
		radioButtonSet[index].Label:SetJustifyH("LEFT")
		
		if index > 1 then 
			radioButtonSet[index]:SetPoint("TOP", radioButtonSet[index-1], "BOTTOM", 0, -(spacing or 10)) 
		end
		
		radioButtonSet[index]:SetScript("OnClick", function (self) 
			local button
			for button = 1, numberOfButtons do radioButtonSet[button]:SetChecked(false) end
			self:SetChecked(true)
		end)
	end
	
	radioButtonSet.GetChecked = function() 
		local index
		for index = 1, numberOfButtons do
			if radioButtonSet[index]:GetChecked() then return index end
		end
	end
	
	radioButtonSet.SetChecked = function(self, number) 
		local index
		for index = 1, numberOfButtons do radioButtonSet[index]:SetChecked(false) end
		radioButtonSet[number]:SetChecked(true)
	end
	
	
	radioButtonSet[defaultButton]:SetChecked(true)
	return radioButtonSet
end

function PanelHelpers:CreateSliderFrame(reference, parent)
	local slider = CreateFrame("Slider", reference, parent, 'OptionsSliderTemplate')
	slider:SetWidth(100)
	slider:SetHeight(15)
	--slider.tooltipText =
	slider.Label = _G[reference..'Text']
	slider.Low = _G[reference.."Low"]
	slider.High = _G[reference.."High"]
	slider:SetMinMaxValues(1, 10)
	slider:SetValueStep(1)
	slider:SetValue(1)
	slider:SetOrientation("HORIZONTAL")
	slider:Enable()
	slider:SetScript("OnValueChanged", function() 
		--slider.tooltipText = tostring(slider:GetValue())
		--slider.Label:SetText(tostring(slider:GetValue())) 
	end)
	return slider
end
		
function PanelHelpers:CreateDropdownFrame(reference, parent, menu, default)
	local dropdown = CreateFrame("Frame", reference, parent, "UIDropDownMenuTemplate" )
	local index, item
	dropdown.Label = _G[reference.."Text"]
	dropdown.Label:SetText(menu[default].text)
	dropdown.Value = default
	dropdown.initialize = function(self, level)
		if not level == 1 then return end
		for index, item in pairs(menu) do
			item.func = function(self) dropdown.Label:SetText(item.text); dropdown.Value = index  end
			UIDropDownMenu_AddButton(item, level)
		end end
	dropdown.SetValue = function (self, value) dropdown.Label:SetText(menu[value].text); dropdown.Value = value end
	return dropdown
end

------------------------------------------------------------------
-- Panel Helper Demo
------------------------------------------------------------------
--[[
-- Main Panel
local panel = PanelHelpers:CreatePanelFrame( "ExamplePanelRef", "Example Interface Panel Title" )
-- Check Button
panel.checkbutton = PanelHelpers:CreateCheckButton("ExampleCheckbutton", panel, "Optional Feature")

local radiolist = {"Small","Medium","Large", "Epic"}
panel.radiobuttons = PanelHelpers:CreateRadioButtons("ExampleRadioSet", panel, 4, 1, 10, radiolist)
panel.radiobuttons[1]:SetPoint("TOPLEFT", 16, -190)


panel.checkbutton:SetPoint("TOPLEFT", 16, -50)
-- Dropdown Menu
local dropmenu = { 
			{ text = "Turtle", notCheckable = 1 } ,
			{ text = "Dog", notCheckable = 1 } ,
			{ text = "Cheetah", notCheckable = 1 }
			}
panel.dropdown = PanelHelpers:CreateDropdownFrame("ExampleDropdown", panel, dropmenu, "Turtle")
panel.dropdown:SetPoint("TOPLEFT", 16, -90)
-- Slider
panel.slider = PanelHelpers:CreateSliderFrame("ExampleSlider", panel)
panel.slider:SetPoint("TOPLEFT", 16, -140)
panel.slider:SetValue(5)
-- Functions
panel.okay = function (self) 
	print( panel.checkbutton:GetChecked().." "..panel.dropdown.Label:GetText().." "..panel.slider:GetValue())
end;
-- Adds the panel to the interface window
InterfaceOptions_AddCategory(panel);
--]]