function Gnosis:OptColor_Entry( key, idx, namestr, variable, cfgtab, bartab )
	cfgtab = cfgtab or "cbconf";
	bartab = bartab or "castbars";

	return {
		order = idx,
		name = namestr,
		type = "color",
		get = function(info) return unpack( Gnosis.s[cfgtab][key][variable] ); end,
		set = function(info,r,g,b,a) Gnosis.s[cfgtab][key][variable] = { r, g, b, a }; Gnosis:SetBarParams( key, cfgtab, bartab ); end,
		hasAlpha = true,
	};
end

function Gnosis:OptColorText_Entry( key, idx, namestr, variable, cfgtab, bartab )
	cfgtab = cfgtab or "cbconf";
	bartab = bartab or "castbars";

	return {
		order = idx,
		name = namestr,
		type = "input",
		get = function(info) return Gnosis:CreateColorString( unpack( Gnosis.s[cfgtab][key][variable] ) ) end,
		set = function(info,val)
			local r, g, b, a = Gnosis:GetColorsFromString( val );
			if( r ) then
				Gnosis.s[cfgtab][key][variable] = { r, g, b, a };
				Gnosis:SetBarParams( key, cfgtab, bartab );
			end
		end,
	};
end

function Gnosis:OptToggle_Entry( key, idx, namestr, descstr, variable, cfgtab, bartab )
	cfgtab = cfgtab or "cbconf";
	bartab = bartab or "castbars";

	local t = {
		order = self:GetNextTableIndexInner(),
		name = namestr,
		desc = descstr,
		type = "toggle",
		get = function(info) return Gnosis.s[cfgtab][key][variable]; end,
		set = function(info,val) Gnosis.s[cfgtab][key][variable] = val; Gnosis:SetBarParams( key, cfgtab, bartab ); end,
	}

	return t;
end

function Gnosis:OptSimpleToggle( key, idx, namestr, descstr, variable, cfgtab )
	cfgtab = cfgtab or "cbconf";

	return {
		order = idx,
		name = namestr,
		desc = descstr,
		type = "toggle",
		get = function(info) return Gnosis.s[cfgtab][key][variable]; end,
		set = function(info,val) Gnosis.s[cfgtab][key][variable] = val; end,
	};
end

function Gnosis:deepcopy( object )
    local lookup_table = {}
    local function _copy(object)
        if type(object) ~= "table" then
            return object;
        elseif lookup_table[object] then
            return lookup_table[object];
        end
        local new_table = {};
        lookup_table[object] = new_table;
        for index, value in pairs(object) do
            new_table[_copy(index)] = _copy( value );
        end
        return setmetatable( new_table, _copy( getmetatable(object) ) );
    end
    return _copy(object);
end
