-- Configuration
Legacy = CreateFrame("Frame", "Legacy")

-- Common Functions
local onEvent = function(self, event, ...)
	self[event](self, event, ...)
--	if(NUM_EXTENDED_UI_FRAMES>0) then
--        	for i = 1, NUM_EXTENDED_UI_FRAMES do
--     	        	_G["WorldStateCaptureBar" .. i]:ClearAllPoints()
--			_G["WorldStateCaptureBar" .. i]:SetPoint("TOPLEFT", UIParent, "TOPLEFT", 20, -100)
--		end
--	end
end


-- Auto-Sell Grey Quality Items and Repairs

function Legacy:MERCHANT_SHOW(event)
-- Sells Grey Items
	local Pot = 0
	for bag = 0,4 do
		if GetContainerNumSlots(bag) > 0 then
			for slot=1, GetContainerNumSlots(bag) do
				local Item = GetContainerItemLink(bag, slot)
				if (Item) then
					ItemQuality = select(3, GetItemInfo(Item))
					ItemPrice = select(11, GetItemInfo(Item))
					ItemCount = select(2, GetContainerItemInfo(bag, slot))
					if (ItemQuality == 0 and ItemPrice ~= 0) then
						UseContainerItem(bag, slot)
						Pot = Pot + (ItemPrice * ItemCount)
					end
				end
			end
		end
	end
	
	if(Pot ~= 0) then
		print("|cff267dffTotal Sold:|cffffffff  " .. GetCoinTextureString(Pot,13))
	end
	
-- Repairs

	local RepairCost = GetRepairAllCost()
	local MyMoney = GetMoney()
		if CanMerchantRepair() then
			if(MyMoney >= RepairCost and RepairCost > 0) then
				RepairAllItems()
				print("|cffe4ff00Repair-Cost:|cffffffff  " .. GetCoinTextureString(RepairCost,13))
			elseif (MyMoney < RepairCost) then
				print("|cfff10b62Insufficient Funds to Repair|r")
			end
		end
	
	self:UnregisterEvent("event")
	
end

-- Faction/Reputation Thingie
local MinReps = { }
function Legacy:UPDATE_FACTION(event)

	local RepRemains
	for factionIndex=1, GetNumFactions(), 1 do
		local name, description, standingID, bottomValue, topValue, earnedValue, atWarWith, canToggleAtWar, isHeader, isCollapsed, isWatched = GetFactionInfo(factionIndex)
		if ( not isHeader ) then
			if (MinReps[name]) then
				local difference = earnedValue - MinReps[name].Value
				if (difference > 0 and standingID ~= 8) then
					RepRemains = topValue-earnedValue
					print(format("%d faction needed until %s with %s.",RepRemains,getglobal("FACTION_STANDING_LABEL"..standingID+1),name))
				elseif (difference < 0 and standingID ~= 1) then
					difference=abs(difference)
					RepRemains = earnedValue-bottomValue
					print(format("%d faction left until %s with %s.",RepRemains,getglobal("FACTION_STANDING_LABEL"..standingID-1),name))
				end
			MinReps[name].Value = earnedValue
			else
				MinReps[name] = { }
				MinReps[name].Value = earnedValue
			end
		end
	end
end


-- Set World Status Frames

function Legacy:PLAYER_LOGIN(event)
	self:UnregisterEvent("PLAYER_LOGIN")
	UIErrorsFrame:UnregisterEvent("UI_ERROR_MESSAGE")
	if (WorldStateAlwaysUpFrame) then
		WorldStateAlwaysUpFrame:ClearAllPoints()
		WorldStateAlwaysUpFrame:SetPoint("TOP", UIParent, "TOP", -65, -15)
		WorldStateAlwaysUpFrame:SetScale(1)
		WorldStateAlwaysUpFrame.SetPoint = function() end
	end
end


-- Events
Legacy:SetScript("OnEvent", onEvent)
Legacy:RegisterEvent"PLAYER_LOGIN"
Legacy:RegisterEvent("MERCHANT_SHOW")
Legacy:RegisterEvent("UPDATE_FACTION")
