local n = select(2, ...)

-- window settings
n.windowsettings = {
	pos = { "BOTTOMRIGHT", 400, -400 },
	width = 235,
	maxlines = 6,
	backgroundalpha = 0,
	scrollbar = true,

	titleheight = 13,
	titlealpha = 0.9,
	titlefont = [[Fonts\HandelGothicBT.ttf]],
	titlefontsize = 12,
	titlefontcolor = {1, .82, 0},

	lineheight = 11,
	linegap = 1,
	linealpha = 1,
	linetexture = [[Interface\AddOns\SharedMedia\statusbar\Ruben]],
	linefont = [[Fonts\FRIZQT__.ttf]],
	linefontsize = 12,
	linefontcolor = {1, 1, 1},
}

-- core settings
n.coresettings = {
	refreshinterval = 1,
	minfightlength = 15,
	combatseconds = 3,
}

-- available types and their order
n.types = {
	{
		name = "Damage",
		id = "dd",
		c = {.25, .66, .35},
	},
	{
		name = "Damage Targets",
		id = "dd",
		view = "Targets",
		onlyfights = true,
		c = {.25, .66, .35},
	},
	{
		name = "Damage Taken: Targets",
		id = "dt",
		view = "Targets",
		onlyfights = true,
		c = {.66, .25, .25},
	},
	{
		name = "Damage Taken: Abilities",
		id = "dt",
		view = "Spells",
		c = {.66, .25, .25},
	},
	{
		name = "Friendly Fire",
		id = "ff",
		c = {.63, .58, .24},
	},
	{
		name = "Healing + Absorbs",
		id = "hd",
		id2 = "ga",
		c = {.25, .5, .85},
	},
--	{
--		name = "Healing",
--		id = "hd",
--		c = {.25, .5, .85},
--	},
--	{
--		name = "Guessed Absorbs",
--		id = "ga",
--		c = {.25, .5, .85},
--	},
	{
		name = "Overhealing",
		id = "oh",
		c = {.25, .5, .85},
	},
	{
		name = "Dispels",
		id = "dp",
		c = {.58, .24, .63},
	},
	{
		name = "Interrupts",
		id = "ir",
		c = {.09, .61, .55},
	},
	{
		name = "Power Gains",
		id = "pg",
		c = {48/255, 113/255, 191/255},
	},
	{
		name = "Death Log",
		id = "deathlog",
		view = "Deathlog",
		onlyfights = true,
		c = {.66, .25, .25},
	},
}
