----------------------------------------------
TidyPlates = {}
local activetheme = {}
local numChildren = -1
local echoUpdate = 0
local EMPTY_TEXTURE = "Interface\\Addons\\TidyPlates\\Artwork\\Empty"
local useAutohide = false
----------------------------------------------
local pairs = pairs
local select = select
----------------------------------------------
local regionPosition = { "threatGlow", "healthBorder", "castBorder", "castNostop", 
					"spellIcon", "highlightTexture", "nameText", "levelText",
					"dangerSkull", "raidIcon", "eliteIcon" }
----------------------------------------------
local listToClass = {}
local colorToClass = {}
local function pctToInt(number) return math.floor((100*number) + 0.5) end
for classname, color in pairs(RAID_CLASS_COLORS) do
	colorToClass["C"..pctToInt(color.r)+pctToInt(color.g)+pctToInt(color.b)] = classname
end
----------------------------------------------
local PlateHandler = CreateFrame("Frame")
----------------------------------------------
local function shouldDisplayThreat(unit)
	if InCombatLockdown() and unit.reaction ~= "FRIENDLY" and IsThreatWarningEnabled() then return true 
	else return false end
end

local function combatByColor(r, g, b, a) return (r > .5 and g < .5) end

local function threatByColor( object , name)
	local redCan, greenCan, blueCan, alphaCan = object:GetVertexColor()
	local shown
	if not object:IsShown() then return "LOW" end
	if greenCan > .7 then return "MEDIUM" end
	if redCan > .7 then return "HIGH" end
end

local function reactionByColor(object)																											
	local redCan, greenCan, blueCan, alphaCan = object:GetStatusBarColor()
	if redCan < .01 and blueCan < .01 and greenCan > .99 then return "FRIENDLY", "NPC" 
	elseif redCan < .01 and blueCan > .99 and greenCan < .01 then return "FRIENDLY", "PLAYER"
	elseif redCan > .99 and blueCan < .01 and greenCan > .99 then return "NEUTRAL", "NPC"
	else return "HOSTILE", "PLAYER" end
end

local function GetRegionReference(plate, ...)
	local index, region, position
	local select = select
	local regions = plate.extended.regions
	for index = 1, select( "#", ... ) do
		region = select( index, ... )
		position = regionPosition[index]
		if region and position then regions[regionPosition[index]] = region end
	end
end

local function IsFrameNameplate(frame)
	local region = frame:GetRegions()
	return region and region:GetObjectType() == "Texture" and region:GetTexture() == "Interface\\TargetingFrame\\UI-TargetingFrame-Flash" 
end

----------------------------------------------
local function SetFrameByStyle(frame, style, anchorTo)																						
	frame:ClearAllPoints()
	frame:SetWidth(style.width)
	frame:SetHeight(style.height)
	frame:SetPoint(style.anchor, anchorTo, style.anchor, style.x, style.y)
end

local function ApplyBarSettings(statBar, statbarStyle, extended)																			
		statBar:SetStatusBarTexture(statbarStyle.texture)
		SetFrameByStyle(statBar, statbarStyle, extended)
		statBar:SetOrientation(statbarStyle.orientation)
end

local function ApplyFontStyle(text, style) 																								
	text:SetFont(style.typeface, style.size, style.flags)
	text:SetJustifyH(style.align)
	text:SetJustifyV(style.vertical)
	text:SetDrawLayer("ARTWORK")
	text:SetShadowOffset(1, -1)
	if style.shadow then text:SetShadowColor(0,0,0,1)
	else text:SetShadowColor(0,0,0,0) end
end


local function ApplyTexture(region,texture) 
	if texture == region:GetTexture() then return end
	region:SetTexture(texture) 
	region:SetTexCoord(0,1,0,1) 
end

local function SetTextureRegion(region, texture, style, anchor) 
	ApplyTexture(region, texture)
	SetFrameByStyle(region, style, anchor)
end

local function SetFontstringRegion(region, style, anchor)
	ApplyFontStyle(region, style)
	SetFrameByStyle(region, style, anchor)
end
----------------------------------------------
local function SetEchoUpdate(echos) echoUpdate = max(echoUpdate,echos) end

local function UpdateStyle(plate)
	local index, region, content
	local extended = plate.extended
	local bars = extended.bars
	local regions = extended.regions 	
	local style = plate.extended.style
		-- Hitbox
		if not InCombatLockdown() then plate:SetWidth(style.hitbox.width); plate:SetHeight(style.hitbox.height) end
		-- Alignment Frame
		SetFrameByStyle(extended, style.frame, plate)	
		-- Main overlay
		SetTextureRegion(regions.healthBorder, style.healthborder.texture, style.healthborder, extended)
		-- Mouseover glow
		ApplyTexture(regions.highlightTexture, style.healthborder.glowtexture)
		regions.highlightTexture:SetAllPoints(regions.healthBorder)
		-- Threat Glow
		SetTextureRegion(regions.threatIndicator, style.threatborder.texture, style.threatborder, extended)
		-- Cast Regular
		SetTextureRegion(regions.castBorder, style.castborder.texture, style.castborder, extended)
		regions.castBorder:SetDrawLayer("ARTWORK")		-- Changed from "ARTWORK"
		-- Cast Unstoppable 
		if style.options.showNostopSpell then 
			SetTextureRegion(regions.castNostop, style.castnostop.texture, style.castnostop, extended)
		else SetTextureRegion(regions.castNostop, style.castborder.texture, style.castborder, extended) end
		regions.castNostop:SetDrawLayer("ARTWORK")
		-- Name Text
		if style.options.showName then regions.nameText:Show()
			SetFontstringRegion(regions.nameText, style.name, extended)
		else regions.nameText:Hide() end
		-- Level Text
		if style.options.showLevel and (not regions.dangerSkull:IsShown()) then regions.levelText:Show()
			SetFontstringRegion(regions.levelText, style.level, extended)
		else regions.levelText:Hide() end
		-- Special Text 1
		if style.options.showSpecialText then regions.specialText:Show()
			SetFontstringRegion(regions.specialText, style.specialText, extended)
		else regions.specialText:Hide() end
		-- Special Text 2
		if style.options.showSpecialText2 then regions.specialText2:Show()
			SetFontstringRegion(regions.specialText2, style.specialText2, extended)
		else regions.specialText2:Hide() end
		-- Special Art
		if style.options.showSpecialArt then regions.specialArt:Show()
			SetFrameByStyle(regions.specialArt, style.specialArt, extended)
		else regions.specialArt:Hide() end
		-- Raid Icon/Lucky Charms..
		SetFrameByStyle(regions.raidIcon, style.raidicon, extended)
		regions.raidIcon:SetDrawLayer("OVERLAY")
		-- Spellcast Icon
		SetFrameByStyle(regions.spellIcon, style.spellicon, extended)
		regions.spellIcon:SetDrawLayer("OVERLAY")
		if not style.options.showspellIcon then regions.spellIcon:SetAlpha(0) end
		-- Skull Icon
		if style.options.showDangerSkull then 
			SetFrameByStyle(regions.dangerSkull, style.dangerskull, extended)
			regions.dangerSkull:SetDrawLayer("OVERLAY")
		else regions.dangerSkull:SetAlpha(0) end
		--[[Hide redundant items
		regions.threatGlow:SetTexture(EMPTY_TEXTURE )
		regions.eliteIcon:SetAlpha(0)
		bars.health:SetStatusBarTexture(EMPTY_TEXTURE )
		--]]
		------------ Configure the Status Bars (Health and Cast)  ------------
		ApplyBarSettings(bars.displayhealth, style.healthbar, extended)  -- Replacement Healthbar
		ApplyBarSettings(bars.cast, style.castbar, extended)
end

local function UpdatePlateIndicators(plate)
	local extended = plate.extended
	local unit = extended.unit
	local style = extended.style
	local color = extended.color
	local bars = extended.bars
	local regions = extended.regions 
	local threatregion = regions.threatIndicator
	local alpha = 1 
	-- Scale & Alpha
	if type(activetheme.SetAlpha) == 'function' then alpha = activetheme.SetAlpha(unit) or 1; extended:SetAlpha(alpha ) end
	if alpha == 0 then return end
	if activetheme.SetScale then extended:SetScale(activetheme.SetScale(unit) or 1)	end
	-- Elite Border Modifier
	if unit.isElite then 
		threatregion:SetTexture(style.threatborder.elitetexture)
		ApplyTexture(regions.healthBorder, style.healthborder.elitetexture)
	else threatregion:SetTexture(style.threatborder.texture) end
	-- Aggro Glow
	if shouldDisplayThreat(unit) then
		color = style.threatcolor[unit.threatSituation]
		threatregion:Show()
		threatregion:SetVertexColor(color.r, color.g, color.b, color.a)
	else threatregion:Hide() end
	-- Special-case Text
	if style.options.showSpecialText and activetheme.SetSpecialText then
		regions.specialText:SetText(activetheme.SetSpecialText(unit)) end
	if style.options.showSpecialText2 and activetheme.SetSpecialText2 then
		regions.specialText2:SetText(activetheme.SetSpecialText2(unit)) end
	-- Special-Case Image
	if style.options.showSpecialArt and activetheme.SetSpecialArt then
		regions.specialArt:SetTexture(activetheme.SetSpecialArt(unit)) end
	-- Bar
	if style.options.useCustomHealthbarColor and activetheme.SetHealthbarColor then
		bars.displayhealth:SetStatusBarColor(activetheme.SetHealthbarColor(unit))
	else bars.displayhealth:SetStatusBarColor(bars.health:GetStatusBarColor()) end	
	bars.displayhealth:SetMinMaxValues(bars.health:GetMinMaxValues())
	bars.displayhealth:SetValue(bars.health:GetValue())

end

local function UpdatePlate(plate, force)
	local _, stylename
	local unitchanged = false
	local extended = plate.extended
	local bars = extended.bars
	local regions = extended.regions 
	local unit = plate.extended.unit
	local unitcache = plate.extended.unitcache
	------------ Derived Properties  ------------
	unit.threatSituation = threatByColor(regions.threatGlow, regions.nameText:GetText())
	unit.reaction, unit.type = reactionByColor(bars.health)
	unit.isBoss = regions.dangerSkull:IsShown()
	unit.isDangerous = unit.isBoss
	unit.isElite = regions.eliteIcon:IsShown()
	unit.isMarked = regions.raidIcon:IsShown()
	unit.name = regions.nameText:GetText()
	unit.alpha = plate:GetAlpha()
	unit.isTarget = (unit.alpha == 1) and UnitExists("target")		-- Does this cause a performance hit?
	unit.level = regions.levelText:GetText()
	unit.health = bars.health:GetValue()
	unit.isMouseover = regions.highlightTexture:IsShown()
	unit.red, unit.green, unit.blue = bars.health:GetStatusBarColor()
	unit.isCasting = bars.cast:IsShown()
	_, unit.healthmax = bars.health:GetMinMaxValues()
	unit.class = colorToClass["C"..pctToInt(unit.red)+pctToInt(unit.green)+pctToInt(unit.blue)] or "UNKNOWN"
	unit.isInCombat = combatByColor(regions.nameText:GetTextColor())
	-- Compare to unitcache
	for key, value in pairs(unit) do if unitcache[key] ~= value then unitchanged = true; unitcache[key] = value end end

	if unitchanged or force then 
	
		--if extended:GetAlpha() == 0 then break end
			------------ Get Current Plate Style ------------
		if activetheme.multiStyle then 
			stylename = activetheme.SetStyle(unit)
			plate.extended.style = activetheme[stylename]
		else plate.extended.style = activetheme end
		------------ Configure Graphical Elements ------------
		if force or extended.stylename ~= stylename then
			extended.stylename = stylename
			UpdateStyle(plate)
		end
		------------ Indicators  ------------
		UpdatePlateIndicators(plate)

	end
	
	if type(activetheme.OnUpdate) == 'function' then activetheme.OnUpdate(extended, unit) end
end

local function ApplyPlateExtension(plate)
	local health, cast, extended, regions
	plate.extended = CreateFrame("Frame", nil, plate)		
	extended = plate.extended
	extended.secureframe = plate
	extended.style, extended.unit,extended.unitcache,  extended.color, extended.regions, extended.bars = {}, {}, {}, {}, {}, {}
	extended.bars.health, extended.bars.cast = plate:GetChildren()
	health, cast = extended.bars.health, extended.bars.cast 
	regions = extended.regions
	GetRegionReference(plate, plate:GetRegions())
	extended.stylename = ""
	for index, region in pairs(regions) do region:SetParent(extended) end
	plate.extended:EnableDrawLayer( "HIGHLIGHT" );
	extended.bars.displayhealth = CreateFrame("StatusBar", nil, extended)		-- changed 
	cast:SetParent(extended)		-- testing
	-- Frame Levels
	-- extended.bars.displayhealth:SetFrameLevel(health:GetFrameLevel())	
	-- cast:SetFrameLevel(health:GetFrameLevel())		-- changed 
	--extended.bars.displayhealth:SetFrameLevel(extended:GetFrameLevel() - 1)
	--cast:SetFrameLevel(extended:GetFrameLevel() - 1)
	--print(plate:GetFrameLevel())
	extended.bars.displayhealth:SetFrameLevel(plate:GetFrameLevel())
	cast:SetFrameLevel(plate:GetFrameLevel())
			-- Hide redundant items
		regions.threatGlow:SetTexture(EMPTY_TEXTURE )
		regions.eliteIcon:SetAlpha(0)
		extended.bars.health:SetStatusBarTexture(EMPTY_TEXTURE )
	--print(extended:GetFrameLevel())
	-- Create Textures
	regions.threatIndicator = extended:CreateTexture(nil, "ARTWORK")
	regions.specialArt = extended:CreateTexture(nil, "OVERLAY")
	regions.specialText = extended:CreateFontString(nil, "OVERLAY")
	regions.specialText2 = extended:CreateFontString(nil, "OVERLAY")
	-- For adding additionl plate sub-objects 
	if type(activetheme.OnInitialize) == 'function' then activetheme.OnInitialize(extended) end
	-- Update Immediately
	UpdatePlate(plate, true)
	-- Hook for Updates
	health:HookScript("OnValueChanged", function () UpdatePlate(plate, false) end) 
	health:HookScript("OnShow", function ()  UpdatePlate(plate, true); SetEchoUpdate(1) end)  -- echo the update to all plates, to catch target changes
	health:HookScript("OnHide", function () extended.unitcache = {}; SetEchoUpdate(1) end) 
	cast:HookScript("OnShow", function () UpdatePlate(plate, true) end) 
	cast:HookScript("OnValueChanged", function () UpdatePlate(plate, true) end) 
	cast:HookScript("OnHide", function () UpdatePlate(plate, true); SetEchoUpdate(1) end) 
end
----------------------------------------------
local function OnCreateChildFrames(...)
	for i=1, select("#", ...) do 
		local plate = select(i, ...)
		if IsFrameNameplate(plate) then
			if not plate.extended then ApplyPlateExtension(plate) end
		end end
end

local function OnUpdate(self)
	local curChildren = WorldFrame:GetNumChildren()
	if (curChildren ~= numChildren) then
		numChildren = curChildren
		OnCreateChildFrames(WorldFrame:GetChildren()) 
	end	
	if echoUpdate > 0 then echoUpdate = echoUpdate - 1; TidyPlates:Update() end
end

local function UpdateAll(force, ...)
	for i=1, select("#", ...) do 
		local plate = select(i, ...)
		if type(plate.extended) == 'table' and plate.extended:IsShown() then UpdatePlate(plate, force) end
	end
end
----------------------------------------------
local events = {}
local PlateHandler = CreateFrame("Frame")
PlateHandler:SetScript("OnEvent", function(self, event, ...) events[event]() end)
-- EVENTS
function events:PLAYER_ENTERING_WORLD() PlateHandler:SetScript("OnUpdate", OnUpdate) end
function events:PLAYER_REGEN_ENABLED() TidyPlates:ForceUpdate(); SetEchoUpdate(2); if useAutoHide then SetCVar("nameplateShowEnemies", 0) end end
function events:PLAYER_REGEN_DISABLED() TidyPlates:ForceUpdate(); SetEchoUpdate(2); if useAutoHide then SetCVar("nameplateShowEnemies", 1) end end
function events:PLAYER_TARGET_CHANGED() SetEchoUpdate(2) end
function events:RAID_TARGET_UPDATE() SetEchoUpdate(1) end
function events:PLAYER_TARGET_CHANGED() SetEchoUpdate(1) end
function events:UNIT_THREAT_LIST_UPDATE() SetEchoUpdate(1) end
function events:UNIT_THREAT_SITUATION_UPDATE() TidyPlates:ForceUpdate(); SetEchoUpdate(1) end
function events:UNIT_LEVEL() SetEchoUpdate(1) end
function events:CURSOR_UPDATE() SetEchoUpdate(1) end
--function events:UNIT_SPELLCAST_SUCCEEDED() SetEchoUpdate(1) end
-- EVENT REGISTRATION
for eventname in pairs(events) do PlateHandler:RegisterEvent(eventname) end
GameTooltip:HookScript("OnTooltipSetUnit", function(self) UpdateAll(false, WorldFrame:GetChildren()) end)
----------------------------------------------
function TidyPlates:ActivateTheme(theme) if theme and type(theme) == 'table' then activetheme = theme; end end
--function TidyPlates:ForceUpdate(self, arg) if arg and type(arg) == "table" then UpdatePlate(arg, true) else UpdateAll(true, WorldFrame:GetChildren()) end end
function TidyPlates:ForceUpdate(self) UpdateAll(true, WorldFrame:GetChildren()) end
function TidyPlates:ForceUpdateFrame(self, frametarget) if frametarget and type(frametarget) == "table" and type(frametarget.secureframe) == "table" then UpdatePlate(frametarget, true) end end

function TidyPlates:Update(self) UpdateAll(false, WorldFrame:GetChildren()) end
function TidyPlates:UseAutoHide(option) useAutoHide = option if not InCombatLockdown() then SetCVar("nameplateShowEnemies", 0) end end

