do
	local L,SN,ST = DXE.L,DXE.SN,DXE.ST

	local data = {
		version = 300,
		key = "noththeplaguebringer", 
		zone = L.zone["Naxxramas"], 
		name = L.npc_naxxramas["Noth the Plaguebringer"], 
		triggers = {
			scan = {
				15954, -- Noth
				16983, -- Plagued Champion
				16981, -- Plagued Guardian
			}, 
		},
		onactivate = {
			tracing = {15954}, -- Noth
			tracerstart = true,
			tracerstop = true,
			combatstop = true,
			defeat = 15954,
		},
		userdata = { 
			roomtime = {90,110,180,loop = false, type = "series"},
			balconytime = {70,95,120,loop = false, type = "series"},
		},
		onstart = {
			{
				"alert","teleportbalccd",
				"expect",{"&difficulty&","==","2"},
				"alert","blinkcd",
			}
		},
		alerts = {
			blinkcd = {
				varname = format(L.alert["%s Cooldown"],SN[29208]),
				type = "dropdown", 
				text = format(L.alert["%s Cooldown"],SN[29208]),
				time = 30, 
				flashtime = 5, 
				sound = "ALERT1", 
				color1 = "MAGENTA", 
				icon = ST[29208],
			},
			teleportbalccd = {
				varname = L.alert["Teleport to Balcony"], 
				type = "dropdown", 
				text = L.alert["Teleport to Balcony"], 
				time = "<roomtime>", 
				flashtime = 5, 
				color1 = "RED",
				sound = "ALERT2",
				icon = ST[66548],
			},
			teleportroomcd = {
				varname = L.alert["Teleport to Room"], 
				type = "dropdown", 
				text = L.alert["Teleport to Room"], 
				time = "<balconytime>", 
				flashtime = 5, 
				color1 = "RED",
				sound = "ALERT2",
				icon = ST[29231],
			},
			cursewarn = {
				varname = format(L.alert["%s Warning"],L.alert["Curse"]),
				type = "simple", 
				text = format(L.alert["%s Cast"],L.alert["Curse"]).."!",
				time = 1.5, 
				sound = "ALERT3", 
				icon = ST[29213],
			},
		},
		events = {
			-- Curses
			{
				type = "combatevent", 
				eventtype = "SPELL_CAST_SUCCESS", 
				spellid = {29213,54835}, 
				execute = {
					{
						"alert","cursewarn", 
					},
				},
			},
			-- Emotes
			{
				type = "event", 
				event = "CHAT_MSG_RAID_BOSS_EMOTE", 
				execute = {
					{
						"expect",{"#1#","find",L.chat_naxxramas["blinks away"]},
						"alert","blinkcd", 
					},
					{
						"expect",{"#1#","find",L.chat_naxxramas["teleports to the balcony"]},
						"quash","blinkcd",
						"alert","teleportroomcd", 
					},
					{
						"expect",{"#1#","find",L.chat_naxxramas["teleports back into battle"]},
						"alert","teleportbalccd", 
					},
				},
			},
		},
	}
	DXE:RegisterEncounter(data)
end

