
local threatSpinnerWidgetPath = "Interface\\Addons\\TidyPlates\\Widgets\\ThreatSpinner\\"
local threatfont = "Interface\\Addons\\TidyPlates\\Media\\LiberationSans-Regular.ttf"
local THREATWIDGET_SEGMENT_ART = {
	HIGHTANK = threatSpinnerWidgetPath.."Red",
	MEDIUMTANK = threatSpinnerWidgetPath.."Orange",
	LOWTANK = threatSpinnerWidgetPath.."Yellow",
	HIGHDPS = threatSpinnerWidgetPath.."Green",
	MEDIUMDPS = threatSpinnerWidgetPath.."Blue",
	LOWDPS = threatSpinnerWidgetPath.."Blue",
	UNKNOWN = threatSpinnerWidgetPath.."Unknown",
}

local function SetFade(frame)
	if GetTime() > frame.FadeTime then
		frame:Hide()
		frame:SetScript("OnUpdate", nil)
	end
end

---------------
-- Threat Functions
---------------
local function GetThreatSegment(threat)
	if not threat then return nil end
	if threat > 135 then return "HIGHTANK"
	elseif threat > 110 then return "MEDIUMTANK"
	elseif threat > 100 then return "LOWTANK"
	elseif threat > 85 then return "HIGHDPS"
	elseif threat > 55 then return "MEDIUMDPS"
	else return "LOWDPS"  end
end

local function GetRelativeThreat(unit)
	if not UnitExists(unit) then return end
	local _, group, size, index, unitid
	local playerthreat, leaderthreat, tempthreat, petthreat, leadername  = 0,0,0,0, nil
	_, _,  playerthreat, _, _ = UnitDetailedThreatSituation("player", unit)
	
	if HasPetUI() then 
		_, _,  petthreat, _, _ = UnitDetailedThreatSituation("pet", unit)
		leaderthreat = petthreat or 0
		leadername = "pet" 
	end
	
	if UnitInRaid("player") then group = "raid"; size = GetNumRaidMembers() - 1
	elseif UnitInParty("player") then group = "party"; size = GetNumPartyMembers()
	else group = nil end
	if group then
		for index = 1, size do
			unitid = group..index
			_, _, tempthreat , _, _ = UnitDetailedThreatSituation(unitid, unit)
			if tempthreat and tempthreat > leaderthreat then 
				leaderthreat = tempthreat 
				leadername = unitid
				end
		end
	end
	
	if playerthreat and leaderthreat then
		if playerthreat == 100 then return playerthreat + (100-leaderthreat), nil
		else return playerthreat, leadername end
	else return end
end


---------------
-- Threat Widget
---------------


local function UpdateThreatWidget(frame, unit)
	local unitid
	if unit.isTarget and UnitExists("target") then unitid = "target"
	elseif unit.isMouseover then unitid = "mouseover" end
	if unitid then
		local threat, topholder = GetRelativeThreat(unitid) 
		local threatsegment = GetThreatSegment(threat)
		if threatsegment then
			-- Set Indicator
			frame:Show()
			frame.ThreatIcon:SetTexture(THREATWIDGET_SEGMENT_ART[threatsegment])
			frame.ThreatText:SetText(floor(threat))
			if topholder then frame.TargetText:SetText(UnitName(topholder))
			else frame.TargetText:SetText("") end
			-- Set Fading
			frame.FadeTime = GetTime() + 3
			frame:SetScript("OnUpdate", SetFade)
		else frame:Hide() end
	elseif (GetTime() > frame.FadeTime) or (not InCombatLockdown()) then frame:Hide() end
end

local function CreateSpinnerThreatWidget(parent)
	local frame = CreateFrame("Frame", nil, parent)
	frame:SetWidth(64)
	frame:SetHeight(64)
	-- Icon
	frame.ThreatIcon = frame:CreateTexture(nil, "OVERLAY")
	frame.ThreatIcon:SetAllPoints(frame)
	-- Threat Text
	frame.ThreatText = frame:CreateFontString(nil, "OVERLAY")
	frame.ThreatText:SetFont(threatfont, 8, "NONE")
	frame.ThreatText:SetPoint("CENTER",frame.ThreatIcon,"CENTER", -1, 0)
	frame.ThreatText:SetWidth(20)
	frame.ThreatText:SetHeight(20)
	-- Target Text
	frame.TargetText = frame:CreateFontString(nil, "OVERLAY")
	frame.TargetText:SetFont(threatfont, 8, "NONE")
	frame.TargetText:SetShadowOffset(1, -1)
	frame.TargetText:SetShadowColor(0,0,0,1)
	frame.TargetText:SetPoint("BOTTOM",frame,"TOP", 1, -25)
	frame.TargetText:SetWidth(50)
	frame.TargetText:SetHeight(20)
	-- Setup
	frame.FadeTime = 0
	frame:Hide()
	frame.Update = UpdateThreatWidget
	return frame
end

TidyPlatesWidgets.CreateSpinnerThreatWidget = CreateSpinnerThreatWidget
