local L = {}

--
-- defaults for all locales
--

-- Localized category display names
L.Weapon, L.Armor, L.Container, L.Consumables, L.Glyph, L.Trades, L.Projectile, L.Quiver, L.Recipe, L.Gem, L.Misc, L.Quest = GetAuctionItemClasses();
L["Keyring"] 					= KEYRING;
L["Projectile"] 				= AMMOSLOT;
L["Sets"] 						= EQUIPMENT_MANAGER;
L["SoulShards"] 				= (select(1, GetItemInfo(6265))); 
L["New"] 						= NEW;
L["BagBar"] 					= TUTORIAL_TITLE10; -- the bagbars

-- categories we need to name ourselves
L["Bags"] 						= "Main";
L["Bank"] 						= "Bank";
L["Gizmos"] 					= "Gizmos";
L["Junk"] 						= "Junk";

-- free space display
L["free"] 						= "free";

-- Interface Options Menu
L["HIDE_JUNK"] 					= "Always hide gray quality loot";
L["HIDE_SHARDS"] 				= "Always hide Soul Shards";
L["HIDE_AMMO"] 					= "Hide the Ammo unless no Ammo is equipped, or you've run out";
L["LOCK_FRAMES"] 				= "Lock the bags into place";

-- error messages
L["ERR_VALID_SCALES"] 			= "Valid scales are from %.1f to %.1f";

--
-- add the default locale
--
gLib:AddLocale( "gBags", nil, L );


--------------------------------------------------------------------
--
-- 	For other locales we only change what totally sucks, 
-- 	since most of the localized category names are supplied by WoW.
--
--------------------------------------------------------------------

-- enUS / enGB
L = {
	["Sets"] 						= "Item Sets";
};
gLib:AddLocale( "gBags", "enUS", L );
gLib:AddLocale( "gBags", "enGB", L );


-- deDE
L = {
	["Bank"] 						= "Bank";
	["Bags"] 						= "Hauptfach";
	["Junk"] 						= "Abfall";
	["Sets"] 						= "Sets";
};
gLib:AddLocale( "gBags", "deDE", L );
