gFrames_db = {

	lowThreshold = 20, 						-- low mana threshold for all mana classes
	highThreshold = 80, 					-- high mana treshold for hunters

	showpetmana = false, 					-- show text on your pet's manabar
	
	scale = 1, 								-- scale of the unitframes (1 being 100%)

	noArena = false,						-- true to disable Arena enemy frames

	swingTimer = true, 						-- true to enable the swing timer
	swingTimerHunter = true,				-- true to only show the swing timer for Hunters
	swingNoMelee = true,					-- disables the swing timer for melee combat
	swingNoRanged = false, 					-- disables the swing timer for ranged attacks

	HealthcolorTapping = true, 				-- Color units tapped by other players gray
	HealthcolorDisconnected = true, 		-- Color disconnected units gray
	HealthcolorSmooth = true, 				-- Smooth coloring of health, on non-class colored targets (overrides default health color)
	HealthcolorClass = true, 				-- Color player's health by their class
	HealthcolorClassNPC = false, 			-- Color NPC's health by their class
	HealthcolorHappiness = false, 			-- Color your pet's health based happiness
	
	PowercolorTapping = true, 				-- Color units tapped by other players gray
	PowercolorDisconnected = true, 			-- Color disconnected units gray
	PowercolorClass = true, 				-- Color power by type (mana, rage, etc)
	PowercolorClassNPC = true, 				-- Color NPC power by type
	PowercolorReaction = true, 
	PowercolorHappiness = true, 			-- Color your pet's power by it's happiness

	noPlayerAuras = false, 					-- true to disable oUF buffs/debuffs on the player frame
	noPetAuras = true, 						-- true to disable oUF buffs/debuffs on the pet frame
	noTargetAuras = false,	 				-- true to disable oUF buffs/debuffs on the target frame
	noToTAuras = true, 						-- true to disable oUF buffs/debuffs on the ToT frame

	spellrangefade = true,					-- makes out-of-range units transparent
	
	iconSize = 22,							-- general icon size on player and target frames
	iconPadding = 2, 						-- padding between auras and icons
	
	overlaycolor = {0.15, 0.15, 0.15, 0.15},
	darkoverlaycolor = {0.15, 0.15, 0.15, 0.35},
	
	damagecolors = {
		DAMAGE = {0.69, 0.31, 0.31},
		CRUSHING = {0.69, 0.31, 0.31},
		CRITICAL = {0.69, 0.31, 0.31},
		GLANCING = {0.69, 0.31, 0.31},
		STANDARD = {0.84, 0.75, 0.65},
		IMMUNE = {0.84, 0.75, 0.65},
		ABSORB = {0.84, 0.75, 0.65},
		BLOCK = {0.84, 0.75, 0.65},
		RESIST = {0.84, 0.75, 0.65},
		MISS = {0.84, 0.75, 0.65},
		HEAL = {0.33, 0.59, 0.33},
		CRITHEAL = {0.33, 0.59, 0.33},
		ENERGIZE = {0.31, 0.45, 0.63},
		CRITENERGIZE = {0.31, 0.45, 0.63},
	},
	fontheight = {							-- yeah, this seems weird
		[8] = 8,
		[9] = 9,
		[10] = 10,
		[11] = 11,
		[12] = 12,
		[14] = 14,
		[16] = 16,
		[18] = 18,
		[20] = 20,
		[22] = 22,
		[24] = 24,
		[26] = 26,
	},
	fontmultiplier = { 						-- layout scaling of fonts
		[0] = 0.85,
		[1] = 0.85,
		[2] = 1.25,
		[3] = 1.25,
		[4] = 1.0,
		[5] = 1.0,
	},

	-- Layouts (does not affect raid frames)
		-- 0 = 1280w, 2x12 fbar1+fbar2 vertical
		-- 1 = 1280w, 1x12 fbar1 vertical
		-- 2 = 1440w+, 1x24 fbar1+fbar2 horizontal
		-- 3 = 1440w+, 2x24 (fbar1+fbar2 horizontal), (fbar4+fbar5 horizontal) vertical
		-- 4 = same as 2
		-- 5 = 1280w, 2x12 fbar1+2 vertical, and 2x6 fbar3, split right/left

	sizes = {
		playerW = {			-- width of the player and target frames
			[0] = 190,			-- layout 0
			[1] = 190,			-- layout 1
			[2] = 262,			-- layout 2
			[3] = 262,			-- layout 3
			[4] = 214,			-- layout 4
			[5] = 214,			-- layout 5
		},
		playerH = {			-- height of the player and target frames
			[0] = 66,			-- layout 0
			[1] = 66,			-- layout 1
			[2] = 76,			-- layout 2
			[3] = 76,			-- layout 3
			[4] = 66,			-- layout 4
			[5] = 66,			-- layout 5
		},
		partyW = {			-- width of the party frames
			[0] = 170,			-- layout 0
			[1] = 170,			-- layout 1
			[2] = 170,			-- layout 2
			[3] = 170,			-- layout 3
			[4] = 170,			-- layout 4
			[5] = 170,			-- layout 5
		},
		partyH = {			-- height of the party frames
			[0] = 33,			-- layout 0
			[1] = 33,			-- layout 1
			[2] = 33,			-- layout 2
			[3] = 33,			-- layout 3
			[4] = 33,			-- layout 4
			[5] = 33,			-- layout 5
		},
		focusW = {			-- width of the focus frame
			[0] = 110,			-- layout 0
			[1] = 110,			-- layout 1
			[2] = 150,			-- layout 2
			[3] = 150,			-- layout 3
			[4] = 130,			-- layout 4
			[5] = 130,			-- layout 5
		},
		focusH = {			-- height of the focus frame
			[0] = 24,			-- layout 0
			[1] = 24,			-- layout 1
			[2] = 33,			-- layout 2
			[3] = 33,			-- layout 3
			[4] = 26,			-- layout 4
			[5] = 26,			-- layout 5
		},
		focustargetW = {	-- width of the focus target frame
			[0] = 110,			-- layout 0
			[1] = 110,			-- layout 1
			[2] = 150,			-- layout 2
			[3] = 150,			-- layout 3
			[4] = 130,			-- layout 4
			[5] = 130,			-- layout 5
		},
		focustargetH = {	-- height of the focus target frame
			[0] = 24,			-- layout 0
			[1] = 24,			-- layout 1
			[2] = 33,			-- layout 2
			[3] = 33,			-- layout 3
			[4] = 26,			-- layout 4
			[5] = 26,			-- layout 5
		},
		arenaW = {			-- width of the arena enemy frames
			[0] = 170,			-- layout 0
			[1] = 170,			-- layout 1
			[2] = 170,			-- layout 2
			[3] = 170,			-- layout 3
			[4] = 170,			-- layout 4
			[5] = 170,			-- layout 5
		},
		arenaH = {			-- height of the arena enemy frames
			[0] = 33,			-- layout 0
			[1] = 33,			-- layout 1
			[2] = 33,			-- layout 2
			[3] = 33,			-- layout 3
			[4] = 33,			-- layout 4
			[5] = 33,			-- layout 5
		},
		playerPetW = {		-- width of the player's pet frame
			[0] = 190,			-- layout 0
			[1] = 190,			-- layout 1
			[2] = 155,			-- layout 2
			[3] = 155,			-- layout 3
			[4] = 110,			-- layout 4
			[5] = 110,			-- layout 5
		},
		playerPetH = {		-- height of the player's pet frame
			[0] = 24,			-- layout 0
			[1] = 24,			-- layout 1
			[2] = 38,			-- layout 2
			[3] = 38,			-- layout 3
			[4] = 32,			-- layout 4
			[5] = 32,			-- layout 5
		},
		partyPetW = {		-- width of the party pets' frames
			[0] = 170,			-- layout 0
			[1] = 170,			-- layout 1
			[2] = 170,			-- layout 2
			[3] = 170,			-- layout 3
			[4] = 170,			-- layout 4
			[5] = 170,			-- layout 5
		},
		partyPetH = {		-- height of the party pets' frames
			[0] = 33,			-- layout 0
			[1] = 33,			-- layout 1
			[2] = 33,			-- layout 2
			[3] = 33,			-- layout 3
			[4] = 33,			-- layout 4
			[5] = 33,			-- layout 4
		},
		targettargetW = {	-- width of the target of target frame
			[0] = 190,			-- layout 0
			[1] = 190,			-- layout 1
			[2] = 155,			-- layout 2
			[3] = 155,			-- layout 3
			[4] = 110,			-- layout 4
			[5] = 110,			-- layout 5
		},
		targettargetH = {	-- height of the target of target frame
			[0] = 24,			-- layout 0
			[1] = 24,			-- layout 1
			[2] = 38,			-- layout 2
			[3] = 38,			-- layout 3
			[4] = 32,			-- layout 4
			[5] = 32,			-- layout 5
		},
		defaultW = {		-- width of the default frames
			[0] = 110,			-- layout 0
			[1] = 110,			-- layout 1
			[2] = 145,			-- layout 2
			[3] = 145,			-- layout 3
			[4] = 110,			-- layout 4
			[5] = 110,			-- layout 5
		},
		defaultH = {		-- height of the default frames
			[0] = 16,			-- layout 0
			[1] = 16,			-- layout 1
			[2] = 32,			-- layout 2
			[3] = 32,			-- layout 3
			[4] = 16,			-- layout 4
			[5] = 16,			-- layout 5
		},
		pbheight = {				-- height of the power bars in various layouts
			[0] = { 					-- layout number 0
				["player"] = 7,			-- player power bar
				["default"] = 5,		-- all other power bars
			},
			[1] = { 					-- layout number 1....
				["player"] = 7,
				["default"] = 5,
			},
			[2] = { 
				["player"] = 7,
				["default"] = 5,
			},
			[3] = { 
				["player"] = 7,
				["default"] = 5,
			},
			[4] = { 
				["player"] = 7,
				["default"] = 5,
			},
			[5] = { 
				["player"] = 7,
				["default"] = 5,
			},
			[6] = { 
				["player"] = 7,
				["default"] = 5,
			},
		},
	},
	coords = {	
		partyX = 8, 							-- horizontal offset for the party frames
		partyY = -(Minimap:GetHeight() + 120), 	-- vertical offset for the party frames
		arenaX = {					-- horizontal offset for the arena enemy frames
			[0] = 400,					-- layout 0
			[1] = 400, 					-- layout 1
			[2] = 400,					-- layout 2
			[3] = 400, 					-- layout 3
			[4] = 400, 					-- layout 4
			[5] = 400, 					-- layout 5
		},
		arenaY = {					-- vertical offset for the arena enemy frames
			[0] = 300,					-- layout 0
			[1] = 300, 					-- layout 1
			[2] = 400,					-- layout 2
			[3] = 400, 					-- layout 3
			[4] = 400, 					-- layout 4
			[5] = 400, 					-- layout 5
		},
		arenaPoint = {		
			[0] = "BOTTOM",				-- layout 0
			[1] = "BOTTOM", 			-- layout 1
			[2] = "BOTTOM",				-- layout 2
			[3] = "BOTTOM", 			-- layout 3
			[4] = "BOTTOM", 			-- layout 4
			[5] = "BOTTOM", 			-- layout 5
		},
		arenaRelativePoint = {		
			[0] = "BOTTOM",				-- layout 0
			[1] = "BOTTOM", 			-- layout 1
			[2] = "BOTTOM",				-- layout 2
			[3] = "BOTTOM", 			-- layout 3
			[4] = "BOTTOM", 			-- layout 4
			[5] = "BOTTOM", 			-- layout 5
		},
		arenaGrowth = {		
			[0] = "TOP",				-- layout 0
			[1] = "TOP", 				-- layout 1
			[2] = "TOP",				-- layout 2
			[3] = "TOP", 				-- layout 3
			[4] = "TOP", 				-- layout 4
			[5] = "TOP", 				-- layout 5
		},
	},
	--
	--	Spawn positions of the frames
	--
	spawn = {
		player = {
			[0] = {								-- layout number 0
				point = "BOTTOMRIGHT",
				relativepoint = "BOTTOM",
				parent = "UIParent",
				xoffset = -4,
				yoffset = 84+32,
			},
			[1] = {
				point = "BOTTOMRIGHT",
				relativepoint = "BOTTOM",
				parent = "UIParent",
				xoffset = -4,
				yoffset = 60+32,
			},
			[2] = {
				point = "BOTTOMRIGHT",
				relativepoint = "BOTTOM",
				parent = "UIParent",
				xoffset = -89,
				yoffset = 56,
			},
			[3] = {
				point = "BOTTOMRIGHT",
				relativepoint = "BOTTOM",
				parent = "UIParent",
				xoffset = -89,
				yoffset = 84,
			},
			[4] = {
				point = "BOTTOMRIGHT",
				relativepoint = "BOTTOM",
				parent = "UIParent",
				xoffset = -62,
				yoffset = 82-24,
			},
			[5] = {
				point = "BOTTOMRIGHT",
				relativepoint = "BOTTOM",
				parent = "UIParent",
				xoffset = -62,
				yoffset = 82,
			},
		},
		target = {
			[0] = {
				point = "BOTTOMLEFT",
				relativepoint = "BOTTOM",
				parent = "UIParent",
				xoffset = 4,
				yoffset = 84+32,
			},
			[1] = {
				point = "BOTTOMLEFT",
				relativepoint = "BOTTOM",
				parent = "UIParent",
				xoffset = 4,
				yoffset = 60+32,
			},
			[2] = {
				point = "BOTTOMLEFT",
				relativepoint = "BOTTOM",
				parent = "UIParent",
				xoffset = 89,
				yoffset = 56,
			},
			[3] = {
				point = "BOTTOMLEFT",
				relativepoint = "BOTTOM",
				parent = "UIParent",
				xoffset = 89,
				yoffset = 84,
			},
			[4] = {
				point = "BOTTOMLEFT",
				relativepoint = "BOTTOM",
				parent = "UIParent",
				xoffset = 62,
				yoffset = 82-24,
			},
			[5] = {
				point = "BOTTOMLEFT",
				relativepoint = "BOTTOM",
				parent = "UIParent",
				xoffset = 62,
				yoffset = 82,
			},
		},
		pet = {
			[0] = {
				point = "TOPLEFT",
				relativepoint = "BOTTOMLEFT",
				parent = "oUF_player",
				xoffset = 0,
				yoffset = -8,
			},
			[1] = {
				point = "TOPLEFT",
				relativepoint = "BOTTOMLEFT",
				parent = "oUF_player",
				xoffset = 0,
				yoffset = -8,
			},
			[2] = {
				point = "BOTTOMLEFT",
				relativepoint = "BOTTOMRIGHT",
				parent = "oUF_player",
				xoffset = 12,
				yoffset = 46,
			},
			[3] = {
				point = "BOTTOMLEFT",
				relativepoint = "BOTTOMRIGHT",
				parent = "oUF_player",
				xoffset = 12,
				yoffset = 46,
			},
			[4] = {
				point = "BOTTOMLEFT",
				relativepoint = "BOTTOMRIGHT",
				parent = "oUF_player",
				xoffset = 7,
				yoffset = 40,
			},
			[5] = {
				point = "BOTTOMLEFT",
				relativepoint = "BOTTOMRIGHT",
				parent = "oUF_player",
				xoffset = 7,
				yoffset = 40,
			},
		},
		focus = {
			[0] = {
				point = "TOPLEFT",
				relativepoint = "TOPLEFT",
				parent = "UIParent",
				xoffset = 220,
				yoffset = -650,
			},
			[1] = {
				point = "TOPLEFT",
				relativepoint = "TOPLEFT",
				parent = "UIParent",
				xoffset = 220,
				yoffset = -650,
			},
			[2] = {
				point = "TOPLEFT",
				relativepoint = "TOPLEFT",
				parent = "UIParent",
				xoffset = 220,
				yoffset = -650,
			},
			[3] = {
				point = "TOPLEFT",
				relativepoint = "TOPLEFT",
				parent = "UIParent",
				xoffset = 220,
				yoffset = -650,
			},
			[4] = {
				point = "TOPLEFT",
				relativepoint = "TOPLEFT",
				parent = "UIParent",
				xoffset = 220,
				yoffset = -650,
			},
			[5] = {
				point = "TOPLEFT",
				relativepoint = "TOPLEFT",
				parent = "UIParent",
				xoffset = 220,
				yoffset = -650,
			},
		},
		focustarget = {
			[0] = {
				point = "TOPLEFT",
				relativepoint = "TOPRIGHT",
				parent = "oUF_focus",
				xoffset = 8,
				yoffset = 0,
			},
			[1] = {
				point = "TOPLEFT",
				relativepoint = "TOPRIGHT",
				parent = "oUF_focus",
				xoffset = 8,
				yoffset = 0,
			},
			[2] = {
				point = "TOPLEFT",
				relativepoint = "TOPRIGHT",
				parent = "oUF_focus",
				xoffset = 8,
				yoffset = 0,
			},
			[3] = {
				point = "TOPLEFT",
				relativepoint = "TOPRIGHT",
				parent = "oUF_focus",
				xoffset = 8,
				yoffset = 0,
			},
			[4] = {
				point = "TOPLEFT",
				relativepoint = "TOPRIGHT",
				parent = "oUF_focus",
				xoffset = 8,
				yoffset = 0,
			},
			[5] = {
				point = "TOPLEFT",
				relativepoint = "TOPRIGHT",
				parent = "oUF_focus",
				xoffset = 8,
				yoffset = 0,
			},
		},
		targettarget = {
			[0] = {
				point = "TOPRIGHT",
				relativepoint = "BOTTOMRIGHT",
				parent = "oUF_target",
				xoffset = 0,
				yoffset = -8,
			},
			[1] = {
				point = "TOPRIGHT",
				relativepoint = "BOTTOMRIGHT",
				parent = "oUF_target",
				xoffset = 0,
				yoffset = -8,
			},
			[2] = {
				point = "BOTTOMLEFT",
				relativepoint = "BOTTOMRIGHT",
				parent = "oUF_player",
				xoffset = 12,
				yoffset = 0,
			},
			[3] = {
				point = "BOTTOMLEFT",
				relativepoint = "BOTTOMRIGHT",
				parent = "oUF_player",
				xoffset = 12,
				yoffset = 0,
			},
			[4] = {
				point = "BOTTOMLEFT",
				relativepoint = "BOTTOMRIGHT",
				parent = "oUF_player",
				xoffset = 7,
				yoffset = 0,
			},
			[5] = {
				point = "BOTTOMLEFT",
				relativepoint = "BOTTOMRIGHT",
				parent = "oUF_player",
				xoffset = 7,
				yoffset = 0,
			},
		},
	},
}
