-- if set to true buttons will fade when they are on cooldown
local fade = true

-- if the cooldown remainder is less than this in seconds the tresholdcolor will be applied and the cooldown will be shown in decimals
local treshold = 6.5

-- the color of the cooldowntext in red, green, blue values
local color = {255/255, 255/255, 255/255}

-- the color of the cooldowntext when below the treshold in red, green, blue values
local tresholdcolor = {255/255, 0/255, 0/255}

-----------------------------------------------DON'T EDIT BELOW THIS LINE -----------------------------------------------
function formattime(s)
	if (s < 3600 and s >= 60) then
		return format("%dm", floor(s / 60 + 1))
	elseif (s < treshold) then
		return format("%.1f", s)
	elseif (s < 60) then
		return floor(s+1)
	else
		return format("%dh", floor(s/ 3600 + 1))
	end
end
local function update(self, elapsed)
	local remaining = self.endTime - GetTime()	
	if remaining > 0 and self.text:IsShown() then
		self.text:SetText(formattime(remaining))
		if self:GetParent().action and fade then
			self.texture:Show()
		else
			self.texture:Hide()
		end
		if remaining > treshold then
			self.text:SetTextColor(unpack(color))
		else
			self.text:SetTextColor(unpack(tresholdcolor))
		end
	else
		self.texture:Hide()
		self.text:SetText("")
		self.text:Hide()
	end
end
local function createtext(self)
	local text = self:CreateFontString(nil, "OVERLAY")
	text:SetPoint("CENTER")
	text:SetParent(self:GetParent())	
	local texture = self:CreateTexture()
	texture:SetAllPoints(self)
	texture:SetTexture(0, 0, 0, .6)
	texture:SetParent(self:GetParent())
	self:SetScript("OnUpdate", update)
	self:SetAlpha(0)
	self:HookScript("OnHide", function() text:Hide() texture:Hide() end)
	self:HookScript("OnShow", function() text:Show() texture:Show() end)	
	self.texture = texture
	self.text = text	
	return text
end
local function startcd(self, start, duration, test)
	if start > 0 and duration > 3 then
		self.endTime  = start + duration
		local text = self.text or createtext(self)
		local height = self:GetHeight()
		if height==0 then
			height = 20
		end
		text:SetFont("Fonts\\FRIZQT__.ttf", 0.5*height, "THINOUTLINE")
		text:Show()
	elseif self.text then
		self.text:Hide()
		self.texture:Hide()
	end
end
local methods = getmetatable(ActionButton1Cooldown).__index
hooksecurefunc(methods, "SetCooldown", startcd)